/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import com.google.common.flogger.FluentLogger;
import hec.io.TextFileReference;
import hec.io.TimeSeriesContainer;
import hec.lang.annotation.Scriptable;
import hec.model.RunTimeStep;
import hec.model.TSRecord;
import hec.rss.model.Element;
import hec.rss.model.JythonUtil;
import hec.rss.model.LocalVariableGroup;
import hec.rss.model.OpController;
import hec.rss.model.OpRule;
import hec.rss.model.OpValue;
import hec.rss.model.RssRun;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.ScriptOpRule$1;
import hec.rss.model.ScriptedRuleJavaInfc;
import hec.rss.model.StateVariable;
import hec.rss.model.dependencies.Dependency;
import hec.rss.model.dependencies.DependencyException;
import hec.rss.model.dependencies.DependencyFinder;
import hec.rss.model.dependencies.DependencySet;
import hec.rss.model.dependencies.TsValRef;
import hec.rss.model.reports.AltInputReportEnums;
import hec.rss.model.reports.AlternativeInputReport;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.python.core.Py;
import org.python.core.PyCode;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.util.PythonInterpreter;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class ScriptOpRule
extends OpRule {
    private static final FluentLogger a = FluentLogger.forEnclosingClass();
    private boolean _useJavaClass;
    private String _javaClassPath;
    private ScriptedRuleJavaInfc _javaSRClass;
    private transient PythonInterpreter b = null;
    private TextFileReference _scriptRef;
    private String _scriptText;
    private transient boolean c;
    private transient PyCode d;
    private transient PyCode e;
    private transient PyCode f;
    private transient LocalVariableGroup i;
    private transient int j;
    private transient int k;
    private transient Map<String, Object> l;
    private transient boolean m = true;
    private transient int n = 0;
    long _totalComputeInitTime;
    long _totalComputeTime;
    private transient ScriptOpRule$1 o = new ScriptOpRule$1(this);

    public ScriptOpRule() {
        ScriptOpRule scriptOpRule = this;
        scriptOpRule.addObserver(scriptOpRule.o);
        this._scriptRef = new TextFileReference(this::useTextFileReferences);
    }

    public ScriptOpRule(String string) {
        super(string);
        ScriptOpRule scriptOpRule = this;
        scriptOpRule.addObserver(scriptOpRule.o);
        this._scriptRef = new TextFileReference(this::useTextFileReferences);
    }

    public ScriptOpRule(OpController opController, String string) {
        super(opController, string);
        ScriptOpRule scriptOpRule = this;
        scriptOpRule.addObserver(scriptOpRule.o);
        this._scriptRef = new TextFileReference(this::useTextFileReferences);
    }

    @Override
    public void evaluateLimits(RunTimeStep runTimeStep, int n) {
        Object object;
        long l = System.currentTimeMillis();
        this.j = runTimeStep.getTotalNumSteps();
        this.n = n;
        Object object2 = null;
        if (this.c) {
            ((RssTSLocationObject)this).getSystem().printLogMessage("evaluateRule(" + this.getName() + ")");
        }
        if (this._useJavaClass) {
            if (this._javaSRClass != null) {
                ScriptOpRule scriptOpRule = this;
                object2 = this._javaSRClass.runRuleScript(scriptOpRule, ((RssTSLocationObject)scriptOpRule).getSystem(), runTimeStep);
            } else {
                ((RssTSLocationObject)this).getSystem().printLogMessage("Java class for scripted rule " + this.getName() + " is null.");
            }
        } else {
            object = new PyStringMap();
            object.__setitem__("currentRule", Py.java2py((Object)this));
            object.__setitem__("currentRuntimestep", Py.java2py((Object)runTimeStep));
            object.__setitem__("network", Py.java2py((Object)((RssTSLocationObject)this).getSystem()));
            this.b.setLocals((PyObject)object);
            try {
                this.b.exec((PyObject)this.d);
                this.b.exec((PyObject)this.f);
                PyObject pyObject = this.b.getLocals();
                PyObject pyObject2 = ((PyStringMap)pyObject).__getitem__((PyObject)new PyString("ret"));
                object2 = Py.tojava((PyObject)pyObject2, (String)"hec.rss.model.OpValue");
            }
            catch (Exception exception) {
                ((RssTSLocationObject)this).getSystem().printErrorMessage("Exception running Rule Script " + this.getName() + " for Reservoir " + String.valueOf(this.getOperationsElement()) + " Error:" + String.valueOf(exception));
                System.out.println("evaluteRule: Exception running Rule Script " + this.getName() + " for Reservoir " + String.valueOf(this.getOperationsElement()) + " Error:" + String.valueOf(exception));
                if (this.getNetwork().getRssRun().getLogLevel() >= 7) {
                    String string = TextFileReference.getValue((TextFileReference)this._scriptRef, (String)this._scriptText);
                    ((FluentLogger.Api)a.atInfo()).log("ScriptOpRule Script is:");
                    ((FluentLogger.Api)a.atInfo()).log("==========================================");
                    ((FluentLogger.Api)a.atInfo()).log(string);
                    ((FluentLogger.Api)a.atInfo()).log("ret=runRuleScript(currentRule, network, currentRuntimestep)\n");
                    ((FluentLogger.Api)a.atInfo()).log("==========================================");
                    this.getNetwork().printLogMessage("ScriptOpRule Script is:");
                    this.getNetwork().printLogMessage("==========================================");
                    this.getNetwork().printLogMessage(string);
                    this.getNetwork().printLogMessage("ret=runRuleScript(currentRule, network, currentRuntimestep)\n");
                    this.getNetwork().printLogMessage("==========================================");
                }
                exception.printStackTrace(System.out);
                if (((RssTSLocationObject)this).getSystem().getAlternative().getWaterQualityOptions().shouldRunWq()) {
                    ((RssTSLocationObject)this).getSystem().getRssRun().getWQRun().finalizeCompute();
                }
                throw new RuntimeException(exception);
            }
            finally {
                long l2 = System.currentTimeMillis();
                long l3 = l2 - l;
                this._totalComputeTime += l3;
                if (this.c) {
                    ((RssTSLocationObject)this).getSystem().printLogMessage("evaluteRule " + this.getName() + " took:" + l3 + " ms.");
                }
            }
        }
        if (object2 instanceof OpValue) {
            if (this.c) {
                ((RssTSLocationObject)this).getSystem().printLogMessage("evaluteRule(" + this.getName() + " returning OpValue " + String.valueOf(object2));
            }
            object = object2;
            this.k = object.type;
            double d = object.value = RMAConst.isValidValue((double)object.value) ? object.value : -3.4028234663852886E38;
            if (this.h != null) {
                this.h.array[runTimeStep.step] = ((OpValue)object2).value;
            }
        }
        if (this.c) {
            ((RssTSLocationObject)this).getSystem().printLogMessage("evaluteRule(" + this.getName() + ") returning null");
        }
    }

    public void setEvalRule(boolean bl) {
        this.m = bl;
    }

    public boolean getEvalRule() {
        return this.m;
    }

    public int getComputeIteration() {
        return this.n;
    }

    @Override
    public OpValue getOpValue(RunTimeStep runTimeStep) {
        if (!RMAConst.isValidValue((double)this.h.array[runTimeStep.step])) {
            return null;
        }
        OpValue opValue = new OpValue();
        new OpValue().type = this.k;
        opValue.value = this.h.array[runTimeStep.step];
        return opValue;
    }

    public void setUseJavaClass(boolean bl) {
        this._useJavaClass = bl;
    }

    public void setJavaClassPath(String string) {
        this._javaClassPath = string;
    }

    public boolean useJavaClass() {
        return this._useJavaClass;
    }

    public String getJavaClassPath() {
        return this._javaClassPath;
    }

    public void setScriptText(String string) {
        this._scriptText = TextFileReference.setValue((TextFileReference)this._scriptRef, (String)string);
    }

    public String getScriptText() {
        return TextFileReference.getValue((TextFileReference)this._scriptRef, (String)this._scriptText);
    }

    public static String a() {
        return "OpValue runRuleScript(OpRule currentRule, RssSystem network, RunTimeStep currentRuntimestep)";
    }

    @Override
    public int getRuleLimitType() {
        return 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean initializeCompute() {
        this._totalComputeInitTime = 0L;
        this._totalComputeTime = 0L;
        boolean bl = super.initializeCompute();
        this.l = null;
        if (this._useJavaClass) {
            Class<?> clazz;
            try {
                clazz = Class.forName(this._javaClassPath);
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("ERROR: Can't find class " + this._javaClassPath + " to use for the Scripted Rule " + this.getName());
                return false;
            }
            try {
                Object obj = clazz.newInstance();
                if (!(obj instanceof ScriptedRuleJavaInfc)) return bl;
                this._javaSRClass = (ScriptedRuleJavaInfc)obj;
                ScriptOpRule scriptOpRule = this;
                this._javaSRClass.initRuleScript(scriptOpRule, ((RssTSLocationObject)scriptOpRule).getSystem());
                return bl;
            }
            catch (InstantiationException instantiationException) {
                System.out.println("Error retrieving user specified Java class for Scripted Rule " + this.getName() + " failed " + String.valueOf(instantiationException));
                ((RssTSLocationObject)this).getSystem().printErrorMessage("Error retrieving user specified Java class for Scripted Rule " + this.getName() + " failed " + String.valueOf(instantiationException));
                instantiationException.printStackTrace();
                return false;
            }
            catch (IllegalAccessException illegalAccessException) {
                System.out.println("Error retrieving user specified Java class for Scripted Rule " + this.getName() + " failed " + String.valueOf(illegalAccessException));
                ((RssTSLocationObject)this).getSystem().printErrorMessage("Error retrieving user specified Java class for Scripted Rule " + this.getName() + " failed " + String.valueOf(illegalAccessException));
                illegalAccessException.printStackTrace();
                return false;
            }
        }
        if (this.b == null) {
            this.b = this.getInitializedInterpreter();
        }
        try {
            this.d = this.compileScript(this._scriptRef, this._scriptText);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            if (exception.toString().contains("Mark invalid") && this._scriptRef.getValue().length() > ScriptOpRule.b()) {
                ((RssTSLocationObject)this).getSystem().printErrorMessage("Failed to compile Scripted Rule " + this.getName() + "'s Script. It contains too many characters for Jython to compile.");
                return false;
            } else {
                System.out.println("Python Compilation Error of Scripted Rule " + this.getName() + " Script failed " + String.valueOf(exception2));
                ((RssTSLocationObject)this).getSystem().printErrorMessage("Python Compilation Error of Scripted Rule " + this.getName() + " failed");
            }
            return false;
        }
        this.f = this.compileScript(null, "ret=runRuleScript(currentRule, network, currentRuntimestep)\n");
        if (!this.hasInitializeScript()) return bl;
        this.e = this.compileScript(null, "ret=initRuleScript(currentRule, network)\n");
        if (this.initializeScript()) return bl;
        ((RssTSLocationObject)this).getSystem().printErrorMessage("Initialization of Scripted Operations Rule " + this.getName() + " failed.");
        return false;
    }

    public static int b() {
        return StateVariable.a();
    }

    private PythonInterpreter getInitializedInterpreter() {
        long l = System.currentTimeMillis();
        RssRun rssRun = ((RssTSLocationObject)this).getSystem().getRssRun();
        if (rssRun != null) {
            this.c = rssRun.getLogLevel() == 10;
        }
        JythonUtil.c();
        rssRun = new PythonInterpreter();
        JythonUtil.a((PythonInterpreter)rssRun, ((RssTSLocationObject)this).getSystem().getFileManager());
        if (this.c) {
            ((RssTSLocationObject)this).getSystem().printLogMessage("getInitializedInterpreter: creating interpreter took " + (System.currentTimeMillis() - l) + " ms");
        }
        return rssRun;
    }

    private PyCode compileScript(TextFileReference textFileReference, String string) {
        string = TextFileReference.getValue((TextFileReference)textFileReference, (String)string);
        return JythonUtil.a(string, this.getScriptFilepath(textFileReference));
    }

    private boolean initializeScript() {
        long l = System.currentTimeMillis();
        Object object = new PyStringMap();
        object.__setitem__("currentRule", Py.java2py((Object)this));
        object.__setitem__("network", Py.java2py((Object)((RssTSLocationObject)this).getSystem()));
        this.b.setLocals((PyObject)object);
        try {
            if (this.c) {
                ((RssTSLocationObject)this).getSystem().printLogMessage("initializeScript(" + this.getName() + ")");
            }
            this.b.exec((PyObject)this.d);
            this.b.exec((PyObject)this.e);
            object = this.b.getLocals();
            PyObject pyObject = ((PyStringMap)object).__getitem__((PyObject)new PyString("ret"));
            object = Py.tojava((PyObject)pyObject, (String)Boolean.class.getName());
            if (object instanceof Boolean) {
                if (this.c) {
                    ((RssTSLocationObject)this).getSystem().printLogMessage("initializeScript(" + this.getName() + ") returning " + String.valueOf(object));
                }
                boolean bl = (Boolean)object;
                return bl;
            }
            return true;
        }
        catch (Exception exception) {
            ((RssTSLocationObject)this).getSystem().printErrorMessage("Exception running Rule init Script " + this.getName() + " for Reservoir " + String.valueOf(this.getOperationsElement()) + " Error:" + String.valueOf(exception));
            ((FluentLogger.Api)a.atInfo()).log("initializeScript: Exception running Rule init Script %s for Reservoir %s Error:%s", (Object)this.getName(), (Object)this.getOperationsElement(), (Object)exception);
            if (this.getNetwork().getRssRun().getLogLevel() >= 7) {
                String string = TextFileReference.getValue((TextFileReference)this._scriptRef, (String)this._scriptText);
                ((FluentLogger.Api)a.atInfo()).log("Initialization Script is:");
                ((FluentLogger.Api)a.atInfo()).log("==========================================");
                ((FluentLogger.Api)a.atInfo()).log(string);
                ((FluentLogger.Api)a.atInfo()).log("ret=initRuleScript(currentRule, network)\n");
                ((FluentLogger.Api)a.atInfo()).log("==========================================");
                this.getNetwork().printLogMessage("Initialization Script is:");
                this.getNetwork().printLogMessage("==========================================");
                this.getNetwork().printLogMessage(string);
                this.getNetwork().printLogMessage("ret=initRuleScript(currentRule, network)\n");
                this.getNetwork().printLogMessage("==========================================");
            }
            exception.printStackTrace(System.out);
            throw new RuntimeException(exception);
        }
        finally {
            long l2 = System.currentTimeMillis();
            long l3 = l2 - l;
            if (this.c) {
                ((RssTSLocationObject)this).getSystem().printLogMessage("initializeScript " + this.getName() + " took:" + l3 + " ms.");
            }
            this._totalComputeInitTime += l3;
        }
    }

    @Override
    public OpValue evaluateRule(RunTimeStep runTimeStep, double d, int n, boolean bl) {
        ((OpRule)this).evaluateLimits(runTimeStep, 0);
        return ((OpRule)this).getOpValue(runTimeStep);
    }

    private boolean hasInitializeScript() {
        ScriptOpRule scriptOpRule = this;
        return scriptOpRule.hasSourceLineWith(scriptOpRule.getScriptText(), "initRuleScript");
    }

    private boolean hasSourceLineWith(String object, String string) {
        boolean bl = false;
        if (object != null && !((String)object).isEmpty()) {
            object = new StringTokenizer((String)object, "\n");
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string2 = ((StringTokenizer)object).nextToken();
                if (string2.indexOf(string) < 0 || (string2 = string2.trim()).startsWith("#")) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    @Scriptable
    public TSRecord localTimeSeriesNew(String string) {
        return this.localTimeSeriesNew(string, Double.NEGATIVE_INFINITY);
    }

    @Scriptable
    public TSRecord localTimeSeriesNew(String string, double d) {
        if (this.i == null) {
            this.i = new LocalVariableGroup();
        }
        return this.i.a(string, d, this.h.array.length);
    }

    @Scriptable
    public TSRecord localTimeSeriesNew(String string, TimeSeriesContainer timeSeriesContainer) {
        if (this.i == null) {
            this.i = new LocalVariableGroup();
        }
        return this.i.a(string, timeSeriesContainer);
    }

    @Scriptable
    public int localTimeSeriesSize() {
        return this.i.a();
    }

    @Scriptable
    public int localTimeSeriesClear() {
        return this.i.b();
    }

    @Scriptable
    public List<String> localTimeSeriesListKeys() {
        return this.i.c();
    }

    @Scriptable
    public List<TSRecord> localTimeSeriesList() {
        if (this.i == null) {
            return new ArrayList<TSRecord>(0);
        }
        return this.i.d();
    }

    @Scriptable
    public TSRecord localTimeSeriesGet(String string) {
        if (this.i == null) {
            this.i = new LocalVariableGroup();
        }
        return this.i.a(string);
    }

    @Scriptable
    public boolean localTimeSeriesExists(String string) {
        if (this.i == null) {
            return false;
        }
        return this.i.b(string);
    }

    @Scriptable
    public boolean varExists(String string) {
        if (string == null || this.l == null) {
            return false;
        }
        return this.l.containsKey(string);
    }

    @Scriptable
    public void varPut(String string, Object object) {
        if (string == null || object == null) {
            return;
        }
        if (this.l == null) {
            this.l = new LinkedHashMap<String, Object>();
        }
        this.l.put(string, object);
    }

    @Scriptable
    public Object varGet(String string) {
        if (this.l == null) {
            return null;
        }
        return this.l.get(string);
    }

    @Scriptable
    public int varsClear() {
        if (this.l == null) {
            return 0;
        }
        int n = this.l.size();
        this.l.clear();
        return n;
    }

    @Scriptable
    public int varsSize() {
        if (this.l == null) {
            return 0;
        }
        return this.l.size();
    }

    @Scriptable
    public List<Object> varsList() {
        if (this.l == null) {
            return new ArrayList<Object>(0);
        }
        Collection<Object> collection = this.l.values();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.addAll(collection);
        return arrayList;
    }

    @Scriptable
    public List<String> varsListKeys() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.l == null) {
            return arrayList;
        }
        Object object = this.l.keySet();
        object = object.iterator();
        while (object.hasNext()) {
            arrayList.add((String)object.next());
        }
        return arrayList;
    }

    @Scriptable
    public Object varRemove(String string) {
        if (this.l == null) {
            return null;
        }
        return this.l.remove(string);
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            return field.get(this);
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            return super.setFieldObject(field, object);
        }
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, org.jdom.Element element) {
        super.outputReport(alternativeInputReport, element);
        element.setAttribute("Rule", "Scripted");
        if (alternativeInputReport.b().get((Object)AltInputReportEnums.RES_SCRIPT_DATA).a()) {
            element.setAttribute("Script", this.getScriptText());
            element.setAttribute("UseJavaClass", Boolean.toString(this._useJavaClass));
            if (this._javaClassPath != null) {
                element.setAttribute("JavaClassPath", this._javaClassPath);
            }
        }
    }

    public long getTotalComputeInitMs() {
        return this._totalComputeInitTime;
    }

    public long getTotalComputeMs() {
        return this._totalComputeTime;
    }

    protected void nameChanged() {
        if (this._scriptRef != null) {
            this._scriptRef.setFilename(this.getScriptFilename());
        }
        if (this._scriptText != null) {
            ScriptOpRule scriptOpRule = this;
            scriptOpRule.setScriptText(scriptOpRule._scriptText);
        }
    }

    private String getScriptFilename() {
        String string = RMAIO.userNameToFileName((String)this.getName()) + ".py";
        Object object = this.getOperationsElement();
        if (object != null) {
            object = RMAIO.userNameToFileName((String)object.toString());
            string = (String)object + "_" + string;
        }
        return RMAIO.concatPath((String)"scripts", (String)string);
    }

    private String getScriptFilepath(TextFileReference object) {
        String string = null;
        if (object != null && (object = object.getFilename()) != null) {
            string = ((RssTSLocationObject)this).getSystem().getBaseDirectory();
            string = RMAIO.concatPath((String)string, (String)object);
        }
        return string;
    }

    public void useTextFileReferences() {
        if (this._scriptRef == null) {
            this._scriptRef = new TextFileReference();
        }
        this.nameChanged();
        if (this._scriptText != null) {
            ScriptOpRule scriptOpRule = this;
            scriptOpRule.setScriptText(scriptOpRule._scriptText);
        }
    }

    @Override
    public void getElementDependencies(List list) {
        if (this.g == null) {
            return;
        }
        if (this.b == null) {
            this.b = this.getInitializedInterpreter();
        }
        Object object = new DependencyFinder(this.b);
        ((DependencyFinder)object).a("network", this.g);
        try {
            object = DependencySet.a(new String[]{this.getScriptText()}, (DependencyFinder)object);
            this.addElemDep(list, ((DependencySet)object).b());
            this.addElemDep(list, ((DependencySet)object).a());
            return;
        }
        catch (DependencyException dependencyException) {
            ((RssTSLocationObject)this).getSystem().printWarningMessage("failed to build dependency set for ScriptedOpRule (" + this.getName() + ")");
            return;
        }
    }

    private void addElemDep(List<Element> list, Collection<Dependency> object) {
        if (object == null) {
            return;
        }
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (Dependency)object.next();
            if (!((Dependency)object2).f()) continue;
            String string = this.getDependencyName((Dependency)object2);
            object2 = this.getDependencyType((Dependency)object2);
            Element element = null;
            int n = -1;
            switch (((String)object2).hashCode()) {
                case -173110412: {
                    if (!((String)object2).equals("Junction")) break;
                    n = 0;
                    break;
                }
                case -268033969: {
                    if (!((String)object2).equals("Reservoir")) break;
                    n = 1;
                    break;
                }
                case 78834003: {
                    if (!((String)object2).equals("Reach")) break;
                    n = 2;
                    break;
                }
                case 310247571: {
                    if (!((String)object2).equals("Diversion")) break;
                    n = 3;
                }
            }
            switch (n) {
                case 0: {
                    element = this.g.findJunction(string);
                    break;
                }
                case 1: {
                    element = this.g.findReservoir(string);
                    break;
                }
                case 2: {
                    element = this.g.findReach(string);
                    break;
                }
                case 3: {
                    element = this.g.findDiversion(string);
                }
            }
            if (element == null || list.contains(element)) continue;
            list.add(element);
        }
    }

    private String getDependencyName(Dependency object) {
        String string = "";
        if ((object = ((Dependency)object).c()) != null && (object = ((TsValRef)object).c()) != null) {
            string = object.getName();
        }
        return string;
    }

    private String getDependencyType(Dependency object) {
        String string = "";
        if ((object = ((Dependency)object).c()) != null && (object = ((TsValRef)object).c()) != null) {
            string = object.getType();
        }
        return string;
    }
}

