/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import com.google.common.flogger.FluentLogger;
import hec.clientapp.client.ClientApp;
import hec.clientapp.model.Manager;
import hec.clientapp.model.ManagerProxyListContainer;
import hec.clientapp.model.ModelAlt;
import hec.clientapp.model.SimulationExtract;
import hec.clientapp.model.SimulationPeriod;
import hec.clientapp.model.SimulationRun;
import hec.clientapp.model.TSDataSet;
import hec.clientapp.model.TSRecordImpl;
import hec.clientapp.rmi.csinterface.HecRmiWorkspace;
import hec.clientapp.rmi.csinterface.RmiWorkspace;
import hec.heclib.dss.DSSPathname;
import hec.heclib.dss.DssDataType;
import hec.heclib.dss.HecTimeSeriesBase;
import hec.heclib.util.HecTime;
import hec.io.DSSIdentifier;
import hec.io.DataContainer;
import hec.io.Identifier;
import hec.io.PairedDataContainer;
import hec.io.TextContainer;
import hec.io.TimeSeriesContainer;
import hec.lang.ClientAppCheck;
import hec.lang.DSSPathString;
import hec.lang.ModelReference;
import hec.lang.UserId;
import hec.lang.WorkspaceNameFactory;
import hec.model.AltItem;
import hec.model.ITSDataSet;
import hec.model.RunTimeWindow;
import hec.model.TSRecord;
import hec.rss.RssRmiWorkspace;
import hec.rss.model.GVDataSet;
import hec.rss.model.HotstartOptions;
import hec.rss.model.PDCDataSet;
import hec.rss.model.PDCRecord;
import hec.rss.model.RssAlt;
import hec.rss.model.RssModelVariableSet;
import hec.rss.model.globalvariable.AltTableGlobalData;
import hec.rss.model.globalvariable.AltTimeSeriesGlobalData;
import hec.rss.model.globalvariable.BaseAltGlobalData;
import hec.rss.model.globalvariable.GlobalVariableData;
import hec.rss.model.globalvariable.GlobalVariableType;
import java.awt.Component;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import mil.army.usace.hec.rmi.csinterface.DSSManager;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import rma.util.RMAIO;

public class SimulationExtractModel
implements SimulationExtract,
Serializable {
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();
    private static final String DEBUG_FLAG = "Extract.Debug";
    private int _timeStep = 1;
    private int _timeIncrement = 2;
    private transient ManagerProxyListContainer _wksp;
    private Pattern _fpartExcludeFilter;
    private String _variantName;
    private boolean _hasError;
    private List<String> _errors = new ArrayList<String>();

    public SimulationExtractModel() {
    }

    public SimulationExtractModel(ManagerProxyListContainer managerProxyListContainer) {
        this._wksp = managerProxyListContainer;
    }

    public void setWorkspace(ManagerProxyListContainer managerProxyListContainer) {
        this._wksp = managerProxyListContainer;
    }

    public boolean runExtract(SimulationPeriod simulationPeriod) {
        Vector vector = simulationPeriod.getSimulationRuns();
        vector.addAll(simulationPeriod.getTrialRuns());
        if (vector == null || vector.isEmpty()) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("There are no Simulation Runs created.  Cannot Finish Extract");
            return false;
        }
        TSDataSet tSDataSet = new TSDataSet();
        boolean bl = true;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        RssAlt rssAlt = null;
        this._hasError = false;
        this._errors.clear();
        for (int i = 0; i < vector.size(); ++i) {
            ModelAlt modelAlt;
            SimulationRun simulationRun = (SimulationRun)vector.elementAt(i);
            Vector vector2 = simulationRun.getAltList();
            if (vector2 == null || vector2.isEmpty()) {
                return false;
            }
            RunTimeWindow runTimeWindow = simulationPeriod.getRunTimeWindow();
            for (int j = 0; j < vector2.size(); ++j) {
                Object object = (AltItem)vector2.elementAt(j);
                modelAlt = simulationRun.getModelAlt((AltItem)object);
                if (modelAlt == null) {
                    if (!Boolean.getBoolean(DEBUG_FLAG)) continue;
                    ((FluentLogger.Api)LOGGER.atInfo()).log("---------------------------------------------------------------------------");
                    ((FluentLogger.Api)LOGGER.atInfo()).log("NULL ModelAlt in extract for %s", object);
                    ((FluentLogger.Api)LOGGER.atInfo()).log("---------------------------------------------------------------------------");
                    continue;
                }
                ModelReference modelReference = modelAlt.getModelRef();
                object = simulationPeriod.openManager(modelReference.wkspName, modelReference.className, modelReference.newId);
                Object object2 = WorkspaceNameFactory.getWorkspaceName((String)modelReference.wkspName, (boolean)true);
                if (object2 == null) {
                    object2 = "supplemental";
                }
                modelAlt = ClientApp.Workspace().openManager((String)object2, modelReference.className, modelReference.id);
                if (!(object instanceof RssAlt)) continue;
                if (modelAlt instanceof RssAlt) {
                    rssAlt = (RssAlt)modelAlt;
                    ((RssAlt)object).getSystem().copyGlobalVariableTables(rssAlt.getSystem());
                }
                if ((object = (RssAlt)object) == null) {
                    if (!Boolean.getBoolean(DEBUG_FLAG)) continue;
                    ((FluentLogger.Api)LOGGER.atInfo()).log("---------------------------------------------------------------------------");
                    ((FluentLogger.Api)LOGGER.atInfo()).log("NULL RSS ALT IN EXTRACT");
                    ((FluentLogger.Api)LOGGER.atInfo()).log("---------------------------------------------------------------------------");
                    continue;
                }
                arrayList.add(object);
                List<String> list = ((RssAlt)object).prepareForExtract(runTimeWindow, (RssAlt)object, simulationPeriod.getDSSFileManager());
                this._errors.addAll(list);
                bl = list.isEmpty();
                boolean bl2 = this.extractAlternative((RssAlt)object, tSDataSet, runTimeWindow.getStartTime());
                if (bl = bl && bl2) continue;
                this._hasError = true;
            }
            String string = simulationPeriod.getSimulationPath() + "/" + simulationPeriod.getOutputDSSFileName();
            DSSManager dSSManager = simulationPeriod.getDSSFileManager();
            modelAlt = null;
            try {
                dSSManager.setDssFileSizeHuge(string);
            }
            catch (RemoteException remoteException) {
                ((FluentLogger.Api)LOGGER.atInfo()).log("runExtract:error(non-fatal) setting DSS file to size huge %s", (Object)remoteException.getMessage());
            }
            try {
                modelAlt = (DSSManager)simulationPeriod.getProxyList().getWorkspace().getDSSFileManager().getRemote();
            }
            catch (RemoteException remoteException) {
                ((FluentLogger.Api)LOGGER.atInfo()).log("runExtract: RemoteException getting DSSManager %s", (Object)remoteException.getMessage());
            }
            this.copyTsDataSet(runTimeWindow, string, tSDataSet, dSSManager, (DSSManager)modelAlt, "Alternative Input");
            for (Object object2 : arrayList) {
                if (rssAlt != null) {
                    this.markDeletedGlobalVariables((RssAlt)object2, rssAlt);
                }
                this.copyGVDataSet(runTimeWindow, string, (RssAlt)object2, dSSManager, (DSSManager)modelAlt);
                if (!((RssAlt)object2).getWaterQualityOptions().shouldRunWq()) continue;
                this.copyTsDataSet(runTimeWindow, string, ((RssAlt)object2).getInputWQTSDataSet(), dSSManager, (DSSManager)modelAlt, "Water Quality Input");
                this.copyTsDataSet(runTimeWindow, string, ((RssAlt)object2).getObsWQTSDataSet(), dSSManager, (DSSManager)modelAlt, "Water Quality Obs");
                this.copyPDCDataSet(runTimeWindow, string, ((RssAlt)object2).getInputWQPDCDataSet(runTimeWindow), dSSManager, (DSSManager)modelAlt);
                this.copyPDCDataSet(runTimeWindow, string, ((RssAlt)object2).getObsWQPDCDataSet(runTimeWindow), dSSManager, (DSSManager)modelAlt);
            }
        }
        return bl;
    }

    private void markDeletedGlobalVariables(RssAlt object, RssAlt rssAlt) {
        if ((object = ((RssAlt)object).getInputGVDataSet()) != null) {
            for (GlobalVariableData globalVariableData : ((GVDataSet)((Object)object)).getGVRecords()) {
                if (rssAlt.getSystem().globalVariableExists(globalVariableData.getIndex(), globalVariableData.getType())) continue;
                globalVariableData.markForDelete(true);
            }
        }
    }

    public void copyPDCDataSet(RunTimeWindow object, String string, PDCDataSet object2, DSSManager dSSManager, DSSManager dSSManager2) {
        object = ((PDCDataSet)((Object)object2)).getAll();
        object = object.iterator();
        while (object.hasNext()) {
            Object object3;
            object2 = (PDCRecord)object.next();
            if (!DSSPathname.isValidPathname((String)object2.getDSSPathname())) {
                object3 = "A Water Quality input PairedData record path is empty for " + object2.getName();
                ((FluentLogger.Api)LOGGER.atInfo()).log((String)object3);
                this._errors.add((String)object3);
                this._hasError = true;
                continue;
            }
            object3 = new DSSPathString();
            object3.setPathname(object2.getDSSPathname());
            if (this.filtersOutFPart(object3.getFPart())) continue;
            object2 = new DSSIdentifier(this._wksp.makeAbsolutePath(object2.getDSSFilename()), object2.getDSSPathname());
            try {
                object3 = dSSManager2.readPairedDataContainer((DSSIdentifier)object2);
                if (object3 == null) {
                    object2 = "WARNING: failed to read " + String.valueOf(object2);
                    ((FluentLogger.Api)LOGGER.atInfo()).log("copyPDCDataSet: " + (String)object2);
                    this._errors.add((String)object2);
                    this._hasError = true;
                    continue;
                }
                if (object3.getNumberCurves() == 0 || object3.getNumberOrdinates() == 0) {
                    object2 = "WARNING empty Paired Data Record. Read from " + String.valueOf(object3);
                    ((FluentLogger.Api)LOGGER.atInfo()).log((String)object2);
                    this._errors.add((String)object2);
                    this._hasError = true;
                    continue;
                }
                ((PairedDataContainer)object3).fileName = string;
                int n = dSSManager.write((DataContainer)object3);
                if (n == 0) continue;
                String string2 = "WARNING: failed to write " + ((PairedDataContainer)object3).fileName + ":" + ((PairedDataContainer)object3).fullName;
                ((FluentLogger.Api)LOGGER.atInfo()).log("copyPDCDataSet: " + string2);
                this._errors.add(string2);
                this._hasError = true;
            }
            catch (RemoteException remoteException) {
                object3 = remoteException;
                object2 = remoteException.getMessage();
                this._errors.add((String)object2);
                ((FluentLogger.Api)LOGGER.atInfo()).log((String)object2);
                object2 = "Within the PDC data reading";
                this._errors.add((String)object2);
                ((FluentLogger.Api)LOGGER.atInfo()).log((String)object2);
                ((Throwable)object3).printStackTrace();
                this._hasError = true;
            }
        }
    }

    public void copyGVDataSet(RunTimeWindow runTimeWindow, String string, RssAlt rssAlt, DSSManager dSSManager, DSSManager dSSManager2) {
        GVDataSet gVDataSet = rssAlt.getInputGVDataSet();
        if (gVDataSet == null) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("copyGVDataSet:Null Global Data Data Set for Alternative %s", (Object)rssAlt);
        } else {
            this.copyGVDataSet(runTimeWindow, string, rssAlt, dSSManager, dSSManager2, gVDataSet);
        }
        if (this._variantName != null) {
            gVDataSet = rssAlt.getInputGVDataSet(this._variantName, false);
            if (gVDataSet == null) {
                ((FluentLogger.Api)LOGGER.atInfo()).log("copyGVDataSet:Null Global Data Data Set for Alternative %s Variant=%s", (Object)rssAlt, (Object)this._variantName);
                return;
            }
            ((FluentLogger.Api)LOGGER.atInfo()).log("copyGVDataSet:copying Global Variable Data for Variant %s", (Object)this._variantName);
            this.copyGVDataSet(runTimeWindow, string, rssAlt, dSSManager, dSSManager2, gVDataSet);
        }
    }

    private void copyGVDataSet(RunTimeWindow runTimeWindow, String string, RssAlt rssAlt, DSSManager dSSManager, DSSManager dSSManager2, GVDataSet gVDataSet) {
        List<GlobalVariableData> list = gVDataSet.getGVRecords();
        DSSIdentifier dSSIdentifier = new DSSIdentifier();
        DSSPathname dSSPathname = new DSSPathname();
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            Object object2 = list.get(i);
            if (object2 == null || object2.isMarkedForDeletion()) continue;
            String string2 = object2.getDSSFilename();
            Object object3 = object2.getDSSPathname();
            dSSIdentifier.setFileName(string2);
            if (GlobalVariableType.TABLE == object2.getType()) {
                object = (AltTableGlobalData)object2;
                ((BaseAltGlobalData)object).loadData();
            }
            if (GlobalVariableType.TIME_SERIES == object2.getType()) {
                object = (AltTimeSeriesGlobalData)object2;
                object2 = new RunTimeWindow(runTimeWindow);
                HecTime hecTime = object2.getEndTime();
                HecTime hecTime2 = object2.getLookbackTime();
                hecTime.setTimeGranularity(this._timeIncrement);
                hecTime2.setTimeGranularity(this._timeIncrement);
                int n = object2.getTimeIncrement() == 1 ? 61 : (object2.getTimeIncrement() == 2 ? 25 : 2);
                hecTime.add(n);
                hecTime2.subtract(n);
                dSSPathname.setPathname((String)object3);
                String string3 = dSSPathname.getEPart();
                if (this.filtersOutFPart(dSSPathname.getFPart())) continue;
                int n2 = HecTimeSeriesBase.getIntervalFromEPart((String)string3);
                object2.setEndTime(hecTime);
                object2.setLookbackTime(hecTime2);
                string2 = rssAlt.getRelativePath(string2);
                string2 = this._wksp.makeAbsolutePath(string2);
                if (string2.isEmpty()) continue;
                if (n2 == 0) {
                    dSSIdentifier.setFileName(string2);
                    dSSIdentifier.setDSSPath((String)object3);
                    dSSIdentifier.setTimeWindow(hecTime2, hecTime);
                    dSSIdentifier.setReadPrevious(true);
                    dSSIdentifier.setReadSubsequent(true);
                    try {
                        object3 = dSSManager2.readTS(dSSIdentifier, false);
                        if (object3 != null && ((TimeSeriesContainer)object3).times != null && ((TimeSeriesContainer)object3).times.length != 0) {
                            hecTime2 = new HecTime(((TimeSeriesContainer)object3).times[0], 1);
                            object2.setLookbackTime(hecTime2);
                            hecTime = new HecTime(((TimeSeriesContainer)object3).times[((TimeSeriesContainer)object3).times.length - 1], 1);
                            object2.setEndTime(hecTime);
                        }
                    }
                    catch (RemoteException remoteException) {
                        ((FluentLogger.Api)LOGGER.atInfo()).log(remoteException.getMessage());
                        ((FluentLogger.Api)LOGGER.atInfo()).log("copyGVDataSet:Within the IR TS data reading for extra time steps");
                        remoteException.printStackTrace();
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        ((FluentLogger.Api)LOGGER.atInfo()).log("copyGVDataSet:DSSFile not found %s", (Object)dSSIdentifier.getFileName());
                    }
                }
                object.initialize((RunTimeWindow)object2);
                object3 = ((AltTimeSeriesGlobalData)object).clone();
                object3.setDSSFilename(string2);
                if (object3.getDSSFilename() == null || object3.getDSSFilename().trim().length() == 0) {
                    if (!Boolean.getBoolean(DEBUG_FLAG)) continue;
                    ((FluentLogger.Api)LOGGER.atInfo()).log("copyGVDataSet: no filename defined for %s", (Object)object3.getName());
                    continue;
                }
                if (object3.getDSSPathname() == null || "///////".equals(object3.getDSSPathname())) {
                    if (!Boolean.getBoolean(DEBUG_FLAG)) continue;
                    ((FluentLogger.Api)LOGGER.atInfo()).log("copyGVDataSet: no DSS pathname defined for %s", (Object)object3.getName());
                    continue;
                }
                if (!object3.loadTSData(dSSManager2, hecTime2, hecTime)) {
                    object2 = "Could not load Time Series Data for Global Variable " + String.valueOf(object) + " " + object.getDSSPathname() + " \nfrom DSS file %s" + object3.getDSSFilename();
                    ((FluentLogger.Api)LOGGER.atInfo()).log("---------------------------------------------------------------------------");
                    ((FluentLogger.Api)LOGGER.atInfo()).log((String)object2);
                    ((FluentLogger.Api)LOGGER.atInfo()).log("---------------------------------------------------------------------------");
                    this._errors.add((String)object2);
                    continue;
                }
                object2 = (TSRecord)object.clone();
                object2.setDSSFilename(string);
                object2.setUnits(object3.getUnits());
                object2.setUnitsType(object3.getUnitsType());
                if (!((TSRecordImpl)object2).writeTSData(dSSManager)) {
                    ((FluentLogger.Api)LOGGER.atInfo()).log("---------------------------------------------------------------------------");
                    ((FluentLogger.Api)LOGGER.atInfo()).log("Could not write Time Series Data for Global Variable Record %s %s\n from DSS file %s", object, (Object)object2.getDSSPathname(), (Object)object2.getDSSFilename());
                    ((FluentLogger.Api)LOGGER.atInfo()).log("---------------------------------------------------------------------------");
                    continue;
                }
                ((FluentLogger.Api)LOGGER.atInfo()).log("Extracted record %s from file %s to file %s", (Object)object2.getDSSPathname(), (Object)object3.getDSSFilename(), (Object)object2.getDSSFilename());
                continue;
            }
            dSSIdentifier.setDSSPath((String)object3);
            string2 = rssAlt.getRelativePath(string2);
            string2 = this._wksp.makeAbsolutePath(string2);
            dSSIdentifier.setFileName(string2);
            try {
                if (object2.getType() == GlobalVariableType.TABLE && ((AltTableGlobalData)object2).isDSS()) {
                    object = ((AltTableGlobalData)object2).getPairedData();
                    if (object == null) continue;
                    object2 = (PairedDataContainer)object.clone();
                    ((PairedDataContainer)object.clone()).fileName = string;
                    ((PairedDataContainer)object2).fullName = object3;
                    dSSManager.write((DataContainer)object2);
                    continue;
                }
                string2 = new TextContainer();
                string2.setText(object2.getValue());
                if (!object2.getDSSFilename().isEmpty()) {
                    dSSIdentifier.setFileName(string);
                }
                if (!string2.hasText()) continue;
                dSSPathname.setPathname((String)object3);
                dSSIdentifier.setDSSPath(dSSPathname.getPathname());
                object2.setDSSPathname(dSSPathname.getPathname());
                ((TextContainer)string2).fullName = dSSPathname.getPathname();
                int n = dSSManager.writeTextData(dSSIdentifier, (TextContainer)string2);
                if (n == 0) continue;
                ((FluentLogger.Api)LOGGER.atInfo()).log("copyGVDataSet:failed to write DSS data for %s to %s rv=%d", object2, (Object)dSSIdentifier, (Object)n);
                continue;
            }
            catch (RemoteException remoteException) {
                object = remoteException;
                remoteException.printStackTrace();
            }
        }
        gVDataSet.setModified(true);
        gVDataSet.getProxyList().saveManager(UserId.getUserId(), (Manager)gVDataSet);
        gVDataSet.loadGlobalVariableValues();
        GVDataSet gVDataSet2 = gVDataSet;
        gVDataSet2.writeFile(gVDataSet2.getIdentifier());
    }

    public boolean extractAlternative(RssAlt rssAlt, TSDataSet tSDataSet, HecTime hecTime) {
        Object object;
        Object object2;
        DSSPathname dSSPathname;
        this.findLargestTimeStep(rssAlt);
        if (rssAlt.getPluginDataList() != null || rssAlt.getPluginDataList().size() > 1) {
            dSSPathname = rssAlt.getPluginDataList();
            for (int i = 0; i < dSSPathname.size(); ++i) {
                Vector vector;
                object2 = dSSPathname.get(i);
                if (!object2.useCompute() || (vector = object2.getTSInputData(rssAlt, hecTime)) == null) continue;
                tSDataSet.getTSRecords().addAll(vector);
            }
        }
        object2 = this._variantName != null ? rssAlt.getInputTSDataSet(this._variantName, false) : rssAlt.getInputTSDataSet();
        ((FluentLogger.Api)LOGGER.atInfo()).log("Extract Alternative %s", (Object)rssAlt);
        ((FluentLogger.Api)LOGGER.atInfo()).log("Extract TSDataSet  %s", object2);
        if (object2 == null) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("---------------------------------------------------------------------------");
            ((FluentLogger.Api)LOGGER.atInfo()).log("No Time Series Data Set Defined For Alternative %s", (Object)rssAlt.getName());
            ((FluentLogger.Api)LOGGER.atInfo()).log("Continuing the Time Series Extract without it");
            ((FluentLogger.Api)LOGGER.atInfo()).log("---------------------------------------------------------------------------");
            return false;
        }
        tSDataSet.appendTSRecords((ITSDataSet)object2);
        object2 = rssAlt.getObservedTSDataSet();
        if (object2 == null) {
            return false;
        }
        dSSPathname = new DSSPathname();
        Vector vector = object2.getTSRecords();
        for (int i = 0; i < vector.size(); ++i) {
            String string;
            object = (TSRecord)vector.elementAt(i);
            if (object.getDSSFilename().length() != 0 && object.getDSSFilename() != null) continue;
            dSSPathname.setPathname(object.getDSSPathname());
            if (this.filtersOutFPart(dSSPathname.getFPart())) {
                ((FluentLogger.Api)LOGGER.atInfo()).log("extractAlternative:filtered out %s", (Object)object.getDSSPathname());
                continue;
            }
            String string2 = "";
            if (object.getName().startsWith("~")) {
                string = rssAlt.getSystem().getNameForKeyString(object.getName());
                string2 = object.getName();
            } else {
                string = object.getName();
            }
            ((FluentLogger.Api)LOGGER.atInfo()).log("---------------------------------------------------------------------------");
            ((FluentLogger.Api)LOGGER.atInfo()).log("No Observed Time Series Data Defined For Alternative %s", (Object)rssAlt.getName());
            ((FluentLogger.Api)LOGGER.atInfo()).log("For location: %s (%s)", (Object)string, (Object)string2);
            ((FluentLogger.Api)LOGGER.atInfo()).log("---------------------------------------------------------------------------");
        }
        tSDataSet.appendTSRecords((ITSDataSet)object2);
        HotstartOptions hotstartOptions = rssAlt.getHotstartOptions();
        if (hotstartOptions != null && hotstartOptions.shouldLoadHotstart()) {
            object = hotstartOptions.getLoadAltName();
            if (object == null) {
                ((FluentLogger.Api)LOGGER.atInfo()).log("WARNING:Hotstart alt file for %s is undefined.", (Object)rssAlt.getName());
            } else {
                this.copyHotstartFile(rssAlt, (String)object, hecTime);
            }
        }
        return true;
    }

    public boolean hasError() {
        return this._hasError;
    }

    public List<String> getErrors() {
        return this._errors;
    }

    public void copyTsDataSet(RunTimeWindow runTimeWindow, String string, TSDataSet tSDataSet, DSSManager dSSManager, DSSManager dSSManager2) {
        this.copyTsDataSet(runTimeWindow, string, tSDataSet, dSSManager, dSSManager2, "");
    }

    public void copyTsDataSet(RunTimeWindow runTimeWindow, String string, TSDataSet object, DSSManager dSSManager, DSSManager dSSManager2, String string2) {
        object = object.getTSRecords();
        try {
            int n;
            Vector<String> vector = new Vector<String>();
            ((FluentLogger.Api)LOGGER.atInfo()).log("Using TimeStep of %s", (Object)RunTimeWindow.getTimeStepString((int)this._timeStep, (int)this._timeIncrement));
            for (n = 0; n < ((Vector)object).size(); ++n) {
                Object object2;
                Object object3;
                Object object4 = (TSRecord)((Vector)object).elementAt(n);
                RunTimeWindow runTimeWindow2 = new RunTimeWindow(runTimeWindow);
                HecTime hecTime = runTimeWindow2.getEndTime();
                HecTime hecTime2 = runTimeWindow2.getLookbackTime();
                hecTime.setTimeGranularity(this._timeIncrement);
                hecTime2.setTimeGranularity(this._timeIncrement);
                int n2 = runTimeWindow2.getTimeIncrement() == 1 ? 61 : (runTimeWindow2.getTimeIncrement() == 2 ? 25 : 2);
                hecTime.add(n2);
                hecTime2.subtract(n2);
                DSSPathString dSSPathString = new DSSPathString();
                if (!DSSPathname.isValidPathname((String)object4.getDSSPathname())) {
                    object3 = string2 + " TS record path is invalid for " + object4.getName() + " DSS Pathname='" + object4.getDSSPathname() + "'";
                    ((FluentLogger.Api)LOGGER.atInfo()).log((String)object3);
                    this._errors.add((String)object3);
                    this._hasError = true;
                    continue;
                }
                dSSPathString.setPathname(object4.getDSSPathname());
                object3 = dSSPathString.getEPart();
                if (this.filtersOutFPart(dSSPathString.getFPart())) continue;
                int n3 = HecTimeSeriesBase.getIntervalFromEPart((String)object3);
                runTimeWindow2.setEndTime(hecTime);
                runTimeWindow2.setLookbackTime(hecTime2);
                if (n3 == 0) {
                    DSSIdentifier dSSIdentifier = new DSSIdentifier(this._wksp.makeAbsolutePath(object4.getDSSFilename()), object4.getDSSPathname());
                    dSSIdentifier.setTimeWindow(hecTime2, hecTime);
                    dSSIdentifier.setReadPrevious(true);
                    dSSIdentifier.setReadSubsequent(true);
                    try {
                        object3 = dSSManager2.readTS(dSSIdentifier, false);
                        if (object3 != null && ((TimeSeriesContainer)object3).times != null && ((TimeSeriesContainer)object3).times.length != 0) {
                            hecTime2 = new HecTime(((TimeSeriesContainer)object3).times[0], 1);
                            runTimeWindow2.setLookbackTime(hecTime2);
                            hecTime = new HecTime(((TimeSeriesContainer)object3).times[((TimeSeriesContainer)object3).times.length - 1], 1);
                            runTimeWindow2.setEndTime(hecTime);
                        } else {
                            object2 = "WARNING: failed to read " + String.valueOf(dSSIdentifier);
                            ((FluentLogger.Api)LOGGER.atInfo()).log("copyTsDataSet: %s", object2);
                            this._errors.add((String)object2);
                            this._hasError = true;
                        }
                    }
                    catch (RemoteException remoteException) {
                        object3 = remoteException;
                        object2 = remoteException.getMessage();
                        this._errors.add((String)object2);
                        ((FluentLogger.Api)LOGGER.atInfo()).log((String)object2);
                        object2 = "Within the IR TS data reading for extra time steps";
                        this._errors.add((String)object2);
                        ((FluentLogger.Api)LOGGER.atInfo()).log((String)object2);
                        ((Throwable)object3).printStackTrace();
                        this._hasError = true;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        object2 = "WARNING: DSSFile not found " + dSSIdentifier.getFileName();
                        ((FluentLogger.Api)LOGGER.atInfo()).log("copyTsDataSet: %s", object2);
                        this._errors.add((String)object2);
                        this._hasError = true;
                    }
                }
                object4.initialize(runTimeWindow2);
                dSSPathString = (TSRecord)((TSRecordImpl)object4).clone();
                dSSPathString.setDSSFilename(this._wksp.makeAbsolutePath(object4.getDSSFilename()));
                if (dSSPathString.getDSSFilename() == null || dSSPathString.getDSSFilename().trim().length() == 0) {
                    if (!Boolean.getBoolean(DEBUG_FLAG)) continue;
                    ((FluentLogger.Api)LOGGER.atInfo()).log("copyTsDataSet: no filename defined for %s", (Object)dSSPathString.getName());
                    continue;
                }
                if (dSSPathString.getDSSPathname() == null || "///////".equals(dSSPathString.getDSSPathname())) {
                    if (!Boolean.getBoolean(DEBUG_FLAG)) continue;
                    ((FluentLogger.Api)LOGGER.atInfo()).log("copyTsDataSet: no DSS pathname defined for %s", (Object)dSSPathString.getName());
                    continue;
                }
                if (!((TSRecordImpl)dSSPathString).loadTSData(dSSManager2, hecTime2, hecTime)) {
                    object3 = dSSPathString.getParamName();
                    object2 = RssModelVariableSet.getModelVariable(dSSPathString.getVariableId());
                    if (object2 != null) {
                        object3 = object2.getName();
                    }
                    ((FluentLogger.Api)LOGGER.atInfo()).log("---------------------------------------------------------------------------");
                    object4 = "For " + dSSPathString.getName() + "-" + (String)object3 + " could not load Time Series Data for Time Series Record \n" + object4.getDSSPathname() + " from DSS File " + object4.getDSSFilename();
                    ((FluentLogger.Api)LOGGER.atInfo()).log((String)object4);
                    ((FluentLogger.Api)LOGGER.atInfo()).log("---------------------------------------------------------------------------");
                    this._errors.add((String)object4);
                    this._hasError = true;
                    continue;
                }
                object3 = (TSRecord)((TSRecordImpl)dSSPathString).clone();
                object3.setDSSFilename(string);
                object3.setUnits(dSSPathString.getUnits());
                object3.setUnitsType(dSSPathString.getUnitsType());
                if (object3.getUnitsType() == null || object3.getUnitsType().trim().isEmpty()) {
                    ((FluentLogger.Api)LOGGER.atInfo()).log("---------------------------------------------------------------------------");
                    object2 = "Missing Time Series Type for Time Series Record \n" + object3.getDSSPathname() + " from DSS File " + object3.getDSSFilename() + " which could cause an error during the compute. Type should be one of " + String.valueOf(DssDataType.INST_VAL) + " or " + String.valueOf(DssDataType.PER_AVER);
                    ((FluentLogger.Api)LOGGER.atInfo()).log((String)object2);
                    ((FluentLogger.Api)LOGGER.atInfo()).log("---------------------------------------------------------------------------");
                    this._errors.add((String)object2);
                    this._hasError = true;
                }
                if (this.writeTSData((TSRecord)object3, dSSManager)) {
                    ((FluentLogger.Api)LOGGER.atInfo()).log("Extracted record %s from file %s to file %s", (Object)object3.getDSSPathname(), (Object)dSSPathString.getDSSFilename(), (Object)object3.getDSSFilename());
                }
                if (vector.contains(dSSPathString.getDSSFilename())) continue;
                vector.addElement(dSSPathString.getDSSFilename());
            }
            for (n = 0; n < vector.size(); ++n) {
                dSSManager2.close((String)vector.elementAt(n));
            }
            dSSManager.close(string);
            return;
        }
        catch (RemoteException remoteException) {
            this._hasError = true;
            ((FluentLogger.Api)LOGGER.atInfo()).log(remoteException.getMessage());
            remoteException.printStackTrace();
            return;
        }
    }

    private boolean writeTSData(TSRecord tSRecord, DSSManager dSSManager) {
        int n = this.getWriteRetryCnt();
        for (int i = 0; i < n && !((TSRecordImpl)tSRecord).writeTSData(dSSManager); ++i) {
            if (i >= n - 1) {
                this.logWriteTsMsg(tSRecord);
                return false;
            }
            if (this.deleteTsRecord(tSRecord, dSSManager)) continue;
            this.logWriteTsMsg(tSRecord);
            return false;
        }
        return true;
    }

    private boolean deleteTsRecord(TSRecord object, DSSManager dSSManager) {
        String string = object.getDSSPathname();
        string = new DSSPathname(string);
        string.setDPart("*");
        object = object.getDSSFilename();
        DSSIdentifier dSSIdentifier = new DSSIdentifier((String)object, string.getPathname());
        Vector vector = null;
        try {
            vector = dSSManager.searchDSSPaths(dSSIdentifier);
        }
        catch (RemoteException remoteException) {}
        if (vector != null) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("Found %d records for %s in DSS File %s to delete", (Object)vector.size(), (Object)string.getPathname(), object);
            try {
                int n = dSSManager.delete((String)object, (List)vector);
                if (n == 0) {
                    return true;
                }
                ((FluentLogger.Api)LOGGER.atInfo()).log("Failed to delete records for %s. rv %d", (Object)dSSIdentifier, n);
            }
            catch (RemoteException remoteException) {
                ((FluentLogger.Api)LOGGER.atInfo()).log("Exception deleting records for %s. Error %s", (Object)dSSIdentifier, (Object)remoteException.getMessage());
            }
        }
        return false;
    }

    private void logWriteTsMsg(TSRecord object) {
        object = "Could not write Time Series Data for Time Series Record \n" + object.getDSSPathname() + " from DSS File " + object.getDSSFilename();
        ((FluentLogger.Api)LOGGER.atInfo()).log("---------------------------------------------------------------------------");
        ((FluentLogger.Api)LOGGER.atInfo()).log((String)object);
        ((FluentLogger.Api)LOGGER.atInfo()).log("---------------------------------------------------------------------------");
        this._errors.add((String)object);
        this._hasError = true;
    }

    private int getWriteRetryCnt() {
        return 2;
    }

    private HecTime[] getStartEndTimes(RunTimeWindow runTimeWindow, HecTime[] hecTimeArray) {
        runTimeWindow = new RunTimeWindow(runTimeWindow);
        HecTime hecTime = runTimeWindow.getEndTime();
        HecTime hecTime2 = runTimeWindow.getLookbackTime();
        hecTime.setTimeGranularity(this._timeIncrement);
        hecTime2.setTimeGranularity(this._timeIncrement);
        int n = runTimeWindow.getTimeIncrement() == 1 ? 61 : (runTimeWindow.getTimeIncrement() == 2 ? 25 : 2);
        hecTime.add(n);
        hecTime2.subtract(n);
        hecTimeArray[0] = hecTime2;
        hecTimeArray[1] = hecTime;
        return hecTimeArray;
    }

    private boolean filtersOutFPart(String string) {
        if (this._fpartExcludeFilter == null) {
            return false;
        }
        return this._fpartExcludeFilter.matcher(string).matches();
    }

    private void findLargestTimeStep(RssAlt rssAlt) {
        int n = rssAlt.getTimestep();
        int n2 = rssAlt.getTimestepIncrement();
        if (n2 > this._timeIncrement) {
            this._timeIncrement = n2;
        }
        if (n2 == this._timeIncrement && n > this._timeStep) {
            this._timeStep = n;
        }
    }

    private void copyHotstartFile(RssAlt rssAlt, String string, HecTime object) {
        string = this.getSrcHotstartFilename(rssAlt, string, (HecTime)object);
        object = this.getDestHotstartFileName(rssAlt, string);
        RmiWorkspace rmiWorkspace = (RmiWorkspace)rssAlt.getWorkspace().getRemote();
        try {
            rmiWorkspace = rmiWorkspace.getFileManager();
        }
        catch (RemoteException remoteException) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("copyHotStartFile: RemoteException getting RmiFileManager %s", (Object)remoteException);
            return;
        }
        this.copyFile((RmiFileManager)rmiWorkspace, string.concat(".nhs"), ((String)object).concat(".nhs"));
        rssAlt = rssAlt.getDSSFileManager();
        string = string.concat(".dss");
        object = ((String)object).concat(".dss");
        try {
            block9: {
                block8: {
                    int n = rssAlt.copyFile(string, (String)object);
                    if (n == 0) break block8;
                    if (ClientAppCheck.haveClientApp()) break block9;
                    ((FluentLogger.Api)LOGGER.atInfo()).log("copyHotstartFile:Failed to copy Hotstart DSS file %s to %s ", (Object)string, object);
                }
                return;
            }
            JOptionPane.showMessageDialog((Component)ClientApp.frame(), "Failed to copy Hotstart DSS file \n" + string + "\nto\n" + (String)object, "Extract Failed", 0);
        }
        catch (RemoteException remoteException) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("copyHotstartFile:RemoteException copying %s to %s ", (Object)string, object);
            if (ClientAppCheck.haveClientApp()) {
                JOptionPane.showMessageDialog((Component)ClientApp.frame(), "Exception during copy of Hotstart DSS file \n" + string + "\nto\n" + (String)object, "Extract Failed", 0);
                return;
            }
            ((FluentLogger.Api)LOGGER.atInfo()).log("copyHotstartFile:Exception during copy of Hotstart DSS file %s to %s", (Object)string, object);
        }
    }

    private void copyFile(RmiFileManager rmiFileManager, String string, String string2) {
        ((FluentLogger.Api)LOGGER.atInfo()).log("copyFile:copying hotstart file %s to %s", (Object)string, (Object)string2);
        Identifier identifier = new Identifier(string);
        Identifier identifier2 = new Identifier(string2);
        try {
            if (!rmiFileManager.copyFile(identifier, identifier2)) {
                ((FluentLogger.Api)LOGGER.atInfo()).log("copyHotstartFile:failed to copy Hotstart file %s to ", (Object)string, (Object)string2);
                if (ClientAppCheck.haveClientApp()) {
                    JOptionPane.showMessageDialog((Component)ClientApp.frame(), "Failed to copy Hotstart file \n" + string + "\nto\n" + string2, "Extract Failed", 0);
                }
            }
            return;
        }
        catch (RemoteException remoteException) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("copyHotStartFile: RemoteException copying hotstart file %s", (Object)remoteException.getMessage());
            if (ClientAppCheck.haveClientApp()) {
                JOptionPane.showMessageDialog((Component)ClientApp.frame(), "Exception during copy of Hotstart file \n" + string + "\nto\n" + string2, "Extract Failed", 0);
                return;
            }
            ((FluentLogger.Api)LOGGER.atInfo()).log("copyFile:Exception during copy of Hotstart file %s  to %s", (Object)string, (Object)string2);
            return;
        }
    }

    private String getSrcHotstartFilename(RssAlt object, String string, HecTime hecTime) {
        String string2;
        Object object2 = (RmiWorkspace)object.getWorkspace().getRemote();
        if (object2 instanceof RssRmiWorkspace) {
            try {
                object2 = ((RssRmiWorkspace)object2).getChildWorkspace("");
            }
            catch (RemoteException remoteException) {
                ((FluentLogger.Api)LOGGER.atInfo()).log("RemoteException getting parent rmiworkspace. %s" + remoteException.getMessage());
                remoteException.printStackTrace();
            }
        }
        if (object2 instanceof HecRmiWorkspace) {
            try {
                object2 = ((HecRmiWorkspace)object2).getBaseWorkspace();
            }
            catch (RemoteException remoteException) {
                ((FluentLogger.Api)LOGGER.atInfo()).log("RemoteException getting parent workspace error:%s" + String.valueOf(remoteException));
                remoteException.printStackTrace();
            }
        } else {
            object2 = (RmiWorkspace)object.getWorkspace().getRemote();
        }
        try {
            string2 = object2.getWorkspacePath() + "/rss/hotstarts/";
        }
        catch (RemoteException remoteException) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("getFileName:RemoteException getting workspace path. Error %s" + remoteException.getMessage());
            remoteException.printStackTrace();
            return null;
        }
        object = string == null ? object.getName() : string;
        int n = ((String)object).indexOf(":");
        if (n >= 0) {
            object = ((String)object).substring(n + 1);
        }
        HecTime hecTime2 = new HecTime(hecTime);
        hecTime2.showTimeAsBeginningOfDay(false);
        hecTime2.setTimeIncrement(2);
        object2 = hecTime2.dateAndTime(4);
        if ("00:00".equals(hecTime.time())) {
            hecTime.setTime("0000");
            object2 = hecTime2.dateAndTime(4);
        }
        object2 = RMAIO.removeChar((String)object2, (char)',');
        object2 = RMAIO.removeChar((String)object2, (char)':');
        object = ((String)object).concat(".").concat((String)object2);
        object = RMAIO.userNameToFileName((String)object);
        object = string2.concat((String)object);
        return object;
    }

    private String getDestHotstartFileName(RssAlt object, String string) {
        object.getProxyList().getContainer();
        object = (RmiWorkspace)object.getWorkspace().getRemote();
        try {
            object = object.getWorkspacePath() + "/rss/hotstarts/";
        }
        catch (RemoteException remoteException) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("RemoteException gettting dest hotstart workspace path. Error %s" + remoteException.getMessage());
            remoteException.printStackTrace();
            return null;
        }
        string = RMAIO.getFileFromPath((String)string);
        object = ((String)object).concat(string);
        return object;
    }

    public void setFPartExcludeFilter(Pattern pattern) {
        this._fpartExcludeFilter = pattern;
    }

    public void setVariantName(String string) {
        this._variantName = string;
    }
}

