/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.data.Parameter;
import hec.model.RunTimeStep;
import hec.model.SeasonalRecord;
import hec.rss.model.OpRule;
import hec.rss.model.OpValue;

public class SpecFlowOpRule
extends OpRule {
    SeasonalRecord _seasonalRecord = new SeasonalRecord();
    private transient boolean a;

    public SpecFlowOpRule() {
    }

    public SpecFlowOpRule(String string) {
        super(string);
    }

    @Override
    public synchronized Object clone() {
        try {
            SpecFlowOpRule specFlowOpRule = (SpecFlowOpRule)super.clone();
            ((SpecFlowOpRule)super.clone())._seasonalRecord = (SeasonalRecord)this._seasonalRecord.clone();
            return specFlowOpRule;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public boolean initializeCompute() {
        if (!super.initializeCompute()) {
            return false;
        }
        this.a = this._multiplier != null && !this._multiplier.isDefaults();
        return true;
    }

    @Override
    public OpValue evaluateRule(RunTimeStep runTimeStep, double d) {
        double d2 = this._seasonalRecord.interpolate(runTimeStep);
        if (d2 == Double.NEGATIVE_INFINITY) {
            return null;
        }
        if (this.getEnableRiseFallCondition() && !this.checkRisingFallingCondition(runTimeStep)) {
            return null;
        }
        if (this.a) {
            int n = runTimeStep.getDayOfWeek();
            double d3 = this._multiplier.getMultiplier(n);
            d2 *= d3;
            System.out.println("Day of Week " + n + "  " + d3 + " " + runTimeStep.getHecTime().toString());
        }
        OpValue opValue = new OpValue();
        new OpValue().type = 1;
        opValue.value = d2;
        return opValue;
    }

    public SeasonalRecord getSeasonalRecord() {
        this._seasonalRecord.setUnitSystem(this.getUnitSystem());
        this._seasonalRecord.setParameterId(Parameter.PARAMID_FLOW);
        this._seasonalRecord.setGmtOffset(this.getGmtOffset());
        return this._seasonalRecord;
    }

    public void setInterpolationType(int n) {
        this._seasonalRecord.setInterpolationType(n);
    }

    public int getInterpolationType() {
        return this._seasonalRecord.getInterpolationType();
    }
}

