/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.TSRecordProxy;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.heclib.dss.DSSPathname;
import hec.heclib.util.doubleArrayContainer;
import hec.io.DSSIdentifier;
import hec.model.PairedValues;
import hec.model.RunTimeStep;
import hec.rss.model.ControlStructure;
import hec.rss.model.Element;
import hec.rss.model.Function;
import hec.rss.model.HindcastData;
import hec.rss.model.IntakeOpening;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssNode;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.reports.AltInputReportInfc;
import hec.rss.model.reports.AlternativeInputReport;
import hec.util.XMLUtilities;
import java.util.ArrayList;
import java.util.Vector;
import org.jdom.Content;
import rma.util.DSSPathPartGenerator;
import rma.util.RMAConst;

public class Spillway
extends ControlStructure
implements AltInputReportInfc {
    public static final int WEIR_COEF = 0;
    public static final int ELEV_VS_OUTFLOW = 1;
    public static final int FIRST_SPILLFUNC_TYPE = 0;
    public static final int LAST_SPILLFUNC_TYPE = 1;
    public static final int KNOWN_SPILL_CONSTANT = 0;
    public static final int KNOWN_SPILL_TS = 1;
    public static final int FIRST_HINDCAST_COND = 0;
    public static final int LAST_HINDCAST_COND = 1;
    double _topOfDam = Double.NEGATIVE_INFINITY;
    double _topLength = Double.NEGATIVE_INFINITY;
    double _weirCoef = 0.0;
    private static double a = 1000.0;
    private static double b = 100.0;
    private static double c = 3.0;
    PairedValues _elevOutValues = new PairedValues();
    int _spillFunctionType = 0;
    int _hindcastCondition = 0;
    double _initialSpill = 0.0;
    private transient doubleArrayContainer d;
    private transient doubleArrayContainer e;
    private transient doubleArrayContainer f;
    private transient doubleArrayContainer g;
    private transient doubleArrayContainer h;

    public Spillway() {
        this._intakeGeometry.setOpening(IntakeOpening.Top);
    }

    public Spillway(Element element) {
        super(element);
        this._intakeGeometry.setOpening(IntakeOpening.Top);
    }

    public double getEstimatedFlow(RunTimeStep runTimeStep, double d, double d2) {
        if (runTimeStep.isPerAvgTimeStep()) {
            return this.periodAverageFlow(d, d2, (double)runTimeStep.getTimeStepSeconds());
        }
        return ((ControlStructure)this).getRelease(d2);
    }

    @Override
    public double getEstimatedFlow(RunTimeStep runTimeStep, int n) {
        double d = 0.0;
        if (this.f == null) {
            return 0.0;
        }
        n = runTimeStep.step - 1;
        if (n < 0) {
            n = 0;
        }
        if (!RMAConst.isUndefinedValue((double)this.f.array[runTimeStep.step])) {
            d = this.f.array[runTimeStep.step];
        } else if (!RMAConst.isUndefinedValue((double)this.f.array[n])) {
            d = this.f.array[n];
        }
        return d;
    }

    @Override
    public double getEstimatedROI(RunTimeStep runTimeStep, int n) {
        n = runTimeStep.step - 1;
        if (n < 0) {
            return 0.0;
        }
        double d = 0.0;
        if (this.f == null) {
            return 0.0;
        }
        if (!RMAConst.isUndefinedValue((double)this.f.array[runTimeStep.step]) && !RMAConst.isUndefinedValue((double)this.f.array[n])) {
            d = (this.f.array[runTimeStep.step] - this.f.array[n]) / (double)runTimeStep.getTimeStepMinutes() * 60.0;
        }
        return d;
    }

    @Override
    public double getEstimatedROD(RunTimeStep runTimeStep, int n) {
        n = runTimeStep.step - 1;
        if (n < 0) {
            return 0.0;
        }
        double d = 0.0;
        if (this.f == null) {
            return 0.0;
        }
        if (!RMAConst.isUndefinedValue((double)this.f.array[runTimeStep.step]) && !RMAConst.isUndefinedValue((double)this.f.array[n])) {
            d = (this.f.array[n] - this.f.array[runTimeStep.step]) / (double)runTimeStep.getTimeStepMinutes() * 60.0;
        }
        return d;
    }

    @Override
    public Vector getActiveTSProxies(Vector vector, int n) {
        if (vector == null) {
            vector = new Vector<TSRecordProxy>();
        }
        if (n == 1) {
            if (this._hindcastCondition == 1) {
                vector.add(this.getTSRecordProxy(96));
            }
        } else {
            vector.add(this.getTSRecordProxy(47));
        }
        return vector;
    }

    @Override
    public void updateTSProxyList() {
        if (this.element == null) {
            return;
        }
        RssNode rssNode = this.element.getNode(0);
        if (rssNode != null && rssNode.getTSRecordProxy(0) == null) {
            rssNode.addTSRecordProxy(0);
        }
        if ((rssNode = this.element.getNode(1)) != null && rssNode.getTSRecordProxy(0) == null) {
            rssNode.addTSRecordProxy(0);
        }
        if (this.getTSRecordProxy(96) == null) {
            this.addTSRecordProxy(96);
        }
        if (this.getTSRecordProxy(127) == null) {
            this.addTSRecordProxy(127);
        }
        if (this.getTSRecordProxy(47) == null) {
            this.addTSRecordProxy(47);
        }
    }

    @Override
    public void setupForSerialization() {
        super.setupForSerialization();
        if (this._elevOutValues == null) {
            return;
        }
        Object object = new DSSPathPartGenerator();
        Object object2 = new DSSPathname();
        Object object3 = this.getElement().getTopParent().getName();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add((String)object3);
        object3 = object.generatePathnamePart(arrayList, "");
        object2.setAPart((String)object3);
        arrayList.clear();
        arrayList.add(this.getElement().getName());
        arrayList.add("Rating");
        object3 = ((RssTSLocationObject)this).getSystem();
        object = object3 != null ? ((RssSystem)object3).generateUniquePathPart(arrayList, "-") : object.generatePathnamePart(arrayList, "-");
        object2.setBPart((String)object);
        object = Parameter.getParamString((int)Parameter.PARAMID_ELEV) + "-" + Parameter.getParamString((int)Parameter.PARAMID_FLOW);
        object2.setCPart((String)object);
        object = this.getElement().getSystem().getDssPairedDataFilePath();
        object2 = object2.getPathname();
        this._elevOutValues.setDssIdentifer(new DSSIdentifier((String)object, (String)object2));
        this._elevOutValues.setParamXId(Parameter.PARAMID_ELEV);
        this._elevOutValues.setParamYId(Parameter.PARAMID_FLOW);
        this._elevOutValues.setUnitSystem(this.getUnitSystem());
    }

    @Override
    public void applyHindcastData(HindcastData hindcastData) {
        if (hindcastData == null) {
            return;
        }
        if (hindcastData.getVariableId() == 96) {
            if (hindcastData.getType() == 1) {
                this._hindcastCondition = 0;
                this._initialSpill = hindcastData.getValue();
                return;
            }
            if (hindcastData.getType() == 0) {
                this._hindcastCondition = 1;
            }
        }
    }

    @Override
    public void getHindcastDataList(Vector vector) {
        if (vector == null) {
            return;
        }
        Object object = this.element.getSystem().getKeyStringForObject(this);
        object = new HindcastData((String)object, 96, 1);
        vector.add(object);
    }

    @Override
    public synchronized Object clone() {
        Spillway spillway = (Spillway)super.clone();
        if (this._elevOutValues != null) {
            spillway._elevOutValues = this._elevOutValues;
        }
        return spillway;
    }

    public double getMinSpillElevation() {
        if (this._spillFunctionType == 0) {
            return this._topOfDam;
        }
        if (this._spillFunctionType == 1) {
            for (int i = 0; i < this._elevOutValues.size(); ++i) {
                if (!(this._elevOutValues.getYValue(i) > 0.0)) continue;
                return this._elevOutValues.getYValue(i);
            }
        }
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public boolean isNodeComputed(int n, RssNode rssNode, Integer n2) {
        return true;
    }

    @Override
    public boolean initialize() {
        this.e = null;
        this.f = null;
        this.d = null;
        if (!super.initialize()) {
            return false;
        }
        RssNode rssNode = this.element.getNode(0);
        RssNode rssNode2 = this.element.getNode(1);
        if (rssNode == null || rssNode2 == null) {
            this.printErrorMessage("initialize", "Failed to load up and down stream nodes");
            return false;
        }
        Element element = this.element.getTopParent();
        if (!(element instanceof ReservoirElement)) {
            this.printErrorMessage("initialize", "no parent reservoir");
            return false;
        }
        this.d = ((ReservoirElement)element).getStorageFunction().getTSContainer(10);
        this.e = rssNode.getTSContainer(0);
        this.f = rssNode2.getTSContainer(0);
        if (this.d == null || this.e == null || this.f == null) {
            this.printErrorMessage("initialize", "failed to load elevation or flow time-series");
            return false;
        }
        if (this._hindcastCondition == 1) {
            this.g = this.getTSContainer(96);
            if (this.g == null) {
                this.printErrorMessage("initialize", "failed to lookback time-series");
                return false;
            }
        }
        if (this.adjustableParam == null) {
            this.adjustableParam = ((Function)this).getAdjustableParameter();
        }
        this.h = this.getTSContainer(47);
        if (this.h == null) {
            this.printErrorMessage("initialize", "failed to load flow setting time-series");
            return false;
        }
        this.adjustableParam.setValueTSContainer(this.h);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double getHindcastValue(RunTimeStep runTimeStep) {
        int n = this._hindcastCondition;
        if (n == 1) {
            if (this.g != null && RMAConst.isValidValue((double)this.g.array[runTimeStep.step])) {
                return this.g.array[runTimeStep.step];
            }
            this.printErrorMessage("computeHindcastStep", "known spill TS empty or invalid");
            this.element.getSystem().printMessage("Date and Time: " + runTimeStep.dateTimeString());
            return 0.0;
        }
        if (n == 0) {
            return this._initialSpill;
        }
        System.out.println("Spillway.getHindcastEquation: unknown hindcast condition " + n);
        return 1.0;
    }

    @Override
    public int computeHindcastStep(RunTimeStep runTimeStep) {
        if (this.f == null || this.e == null) {
            this.printErrorMessage("computeHindcastStep", "Time series arrays missing");
            this.element.getSystem().printMessage("Date and Time: " + runTimeStep.dateTimeString());
            return 1;
        }
        this.f.array[runTimeStep.step] = this.getHindcastValue(runTimeStep);
        if (this.f.array[runTimeStep.step] == Double.NEGATIVE_INFINITY) {
            return 1;
        }
        this.e.array[runTimeStep.step] = this.f.array[runTimeStep.step];
        this.adjustableParam.setMaxValue(this.f.array[runTimeStep.step]);
        this.adjustableParam.setMinValue(this.f.array[runTimeStep.step]);
        this.adjustableParam.setValue(this.f.array[runTimeStep.step]);
        this.h.array[runTimeStep.step] = this.f.array[runTimeStep.step];
        return 0;
    }

    @Override
    public int computeForecastStep(RunTimeStep runTimeStep) {
        int n;
        if (this.f == null || this.e == null || this.d == null) {
            this.printErrorMessage("computeForecastStep", "Time series arrays missing");
            this.element.getSystem().printMessage("Date and Time: " + runTimeStep.dateTimeString());
            return 1;
        }
        int n2 = n = runTimeStep.step > 0 ? runTimeStep.step - 1 : 0;
        if (runTimeStep.isPerAvgTimeStep()) {
            Spillway spillway = this;
            this.f.array[runTimeStep.step] = spillway.periodAverageFlow(spillway.d.array[n], this.d.array[runTimeStep.step], (double)runTimeStep.getTimeStepSeconds());
        } else {
            Spillway spillway = this;
            this.f.array[runTimeStep.step] = ((ControlStructure)spillway).getRelease(spillway.d.array[runTimeStep.step]);
        }
        this.e.array[runTimeStep.step] = this.f.array[runTimeStep.step];
        this.adjustableParam.setMaxValue(this.f.array[runTimeStep.step]);
        this.adjustableParam.setMinValue(this.f.array[runTimeStep.step]);
        this.adjustableParam.setValue(this.f.array[runTimeStep.step]);
        this.h.array[runTimeStep.step] = this.f.array[runTimeStep.step];
        return 0;
    }

    @Override
    public int computeForecastStep(RunTimeStep runTimeStep, double[] dArray, double[] dArray2, int n) {
        if (this.f == null || this.e == null) {
            this.printErrorMessage("computeForecastStep", "Time series arrays missing");
            this.element.getSystem().printMessage("Date and Time: " + runTimeStep.dateTimeString());
            return 1;
        }
        this.f.array[runTimeStep.step] = runTimeStep.isPerAvgTimeStep() ? this.periodAverageFlow(dArray, dArray2, n) : ((ControlStructure)this).getRelease(dArray2[n - 1]);
        this.e.array[runTimeStep.step] = this.f.array[runTimeStep.step];
        this.adjustableParam.setMaxValue(this.f.array[runTimeStep.step]);
        this.adjustableParam.setMinValue(this.f.array[runTimeStep.step]);
        this.adjustableParam.setValue(this.f.array[runTimeStep.step]);
        this.h.array[runTimeStep.step] = this.f.array[runTimeStep.step];
        return 0;
    }

    @Override
    public double computeSubStepFlow(RunTimeStep runTimeStep, double d, double d2) {
        double d3 = ((ControlStructure)this).getRelease(d2);
        return d3;
    }

    public double computeStepFlow(RunTimeStep runTimeStep) {
        double d;
        if (runTimeStep.isPerAvgTimeStep()) {
            Spillway spillway = this;
            d = spillway.periodAverageFlow(spillway.d.array[runTimeStep.step - 1], this.d.array[runTimeStep.step], (double)runTimeStep.getTimeStepSeconds());
        } else {
            Spillway spillway = this;
            d = ((ControlStructure)spillway).getRelease(spillway.d.array[runTimeStep.step]);
        }
        return d;
    }

    @Override
    public double getRelease(double d) {
        if (this._spillFunctionType == 0) {
            if (this._topOfDam == Double.NEGATIVE_INFINITY || this._topLength == Double.NEGATIVE_INFINITY) {
                return 0.0;
            }
            if (d > this._topOfDam) {
                return this._weirCoef * this._topLength * Math.pow(d - this._topOfDam, 1.5);
            }
            return 0.0;
        }
        if (this._spillFunctionType == 1) {
            return this._elevOutValues.interpolateValue(d);
        }
        return 0.0;
    }

    public double getTopOfDam() {
        return this._topOfDam;
    }

    public void getTopOfDam(ParamDouble paramDouble) {
        paramDouble.setValue(this.getTopOfDam());
        paramDouble.setUnitSystem(this.getUnitSystem());
        paramDouble.setParameterId(Parameter.PARAMID_ELEV);
    }

    public void setTopOfDam(ParamDouble paramDouble) {
        this.setTopOfDam(paramDouble.getValue());
    }

    public void getWidthOfDam(ParamDouble paramDouble) {
        paramDouble.setValue(this.getWidthOfDam());
        paramDouble.setUnitSystem(this.getUnitSystem());
        paramDouble.setParameterId(Parameter.PARAMID_WIDTH);
    }

    public void setWidthOfDam(ParamDouble paramDouble) {
        this.setWidthOfDam(paramDouble.getValue());
    }

    public double getWidthOfDam() {
        return this._topLength;
    }

    public void setTopOfDam(double d) {
        this._topOfDam = d;
    }

    public void setWidthOfDam(double d) {
        this._topLength = d;
    }

    public double getWeirCoef() {
        return this._weirCoef;
    }

    public void setWeirCoef(double d) {
        this._weirCoef = d;
    }

    @Override
    public boolean hasDefaultParameters() {
        return this._topOfDam == a && this._topLength == b && this._weirCoef == c;
    }

    public boolean setSpillFunctionType(int n) {
        if (n < 0 || n > 1) {
            return false;
        }
        this._spillFunctionType = n;
        return true;
    }

    public int getSpillFunctionType() {
        return this._spillFunctionType;
    }

    public PairedValues getElevOutflowValues() {
        this._elevOutValues.setUnitSystem(this.getUnitSystem());
        this._elevOutValues.setParamXId(Parameter.PARAMID_ELEV);
        this._elevOutValues.setParamYId(Parameter.PARAMID_FLOW);
        return this._elevOutValues;
    }

    public void setElevOutflowValues(PairedValues pairedValues) {
        this._elevOutValues = pairedValues;
        this._elevOutValues.setUnitSystem(this.getUnitSystem());
        this._elevOutValues.setParamXId(Parameter.PARAMID_ELEV);
        this._elevOutValues.setParamYId(Parameter.PARAMID_FLOW);
    }

    public int getHindcastCondition() {
        return this._hindcastCondition;
    }

    public boolean setHindcastCondition(int n) {
        if (n < 0 || n > 1) {
            return false;
        }
        this._hindcastCondition = n;
        return true;
    }

    public double getInitialSpill() {
        return this._initialSpill;
    }

    public void setInitialSpill(double d) {
        this._initialSpill = d;
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, org.jdom.Element element) {
        element.setAttribute("Name", this.getDisplayName());
        element.setAttribute("OutletElevation", Double.toString(this._topOfDam));
        if (this._spillFunctionType == 0) {
            element.setAttribute("WeirCoff", Double.toString(this._weirCoef));
            element.setAttribute("WeirLength", Double.toString(this._topLength));
            return;
        }
        alternativeInputReport = new org.jdom.Element("Elevation");
        element.addContent((Content)alternativeInputReport);
        XMLUtilities.createArrayElements((org.jdom.Element)alternativeInputReport, (double[])this._elevOutValues.getYArray());
        alternativeInputReport = new org.jdom.Element("Outflow");
        element.addContent((Content)alternativeInputReport);
        XMLUtilities.createArrayElements((org.jdom.Element)alternativeInputReport, (double[])this._elevOutValues.getXArray());
    }
}

