/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.data.DataSetException;
import hec.data.Parameter;
import hec.data.Units;
import hec.heclib.dss.DSSPathname;
import hec.io.DSSIdentifier;
import hec.model.PairedValues;
import hec.model.RunTimeStep;
import hec.model.ValuePair;
import hec.rss.model.Element;
import hec.rss.model.HotstartState;
import hec.rss.model.RSimDssPathPartGenerator;
import hec.rss.model.Routing;
import hec.rss.model.RoutingHotstartState;
import hec.rss.model.RssReturnStatusConstants;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.SsarrRoutingHotstartState;
import hec.rss.model.reports.AlternativeInputReport;
import hec.util.XMLUtilities;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Vector;
import org.jdom.Content;

public class SsarrRouting
extends Routing {
    PairedValues _outflowTimeOfStorageTable = new PairedValues();
    int _numberReaches = 1;
    double _nCoefficient = Double.NEGATIVE_INFINITY;
    double _kts = Double.NEGATIVE_INFINITY;
    boolean _useTable = false;
    private transient double[] c;
    transient double[] a;
    transient Object[] b;
    private transient double[] d;
    private transient double[] e;
    private transient double[] f;
    private transient double[] g;
    private transient boolean h = false;
    private transient boolean i = true;

    public SsarrRouting() {
    }

    public SsarrRouting(Element element) {
        super(element);
    }

    @Override
    public void setupForSerialization() {
        RssReturnStatusConstants rssReturnStatusConstants;
        super.setupForSerialization();
        if (this._outflowTimeOfStorageTable == null) {
            return;
        }
        Object object = new DSSPathname();
        Object object2 = new RSimDssPathPartGenerator();
        String string = this.getElement().getTopParent().getName();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        string = object2.generatePathnamePart(arrayList, "");
        object.setAPart(string);
        arrayList.clear();
        String string2 = this.getElement().getName();
        if (string2 != null && string2.startsWith("~") && (rssReturnStatusConstants = this.getElement().getParent()) != null) {
            string2 = rssReturnStatusConstants.getName();
        }
        if (!string2.equalsIgnoreCase(string)) {
            arrayList.add(string2);
        }
        arrayList.add("SSARR");
        rssReturnStatusConstants = ((RssTSLocationObject)this).getSystem();
        object2 = rssReturnStatusConstants != null ? ((RssSystem)rssReturnStatusConstants).generateUniquePathPart(arrayList, "-") : object2.generatePathnamePart(arrayList, "-");
        object.setBPart((String)object2);
        object2 = Parameter.getParamString((int)Parameter.PARAMID_FLOW) + "-" + Parameter.getParamString((int)-1);
        object.setCPart((String)object2);
        object2 = this.getElement().getSystem().getDssPairedDataFilePath();
        object = object.getPathname();
        this._outflowTimeOfStorageTable.setDssIdentifer(new DSSIdentifier((String)object2, (String)object));
        this._outflowTimeOfStorageTable.setParamXId(Parameter.PARAMID_FLOW);
        this._outflowTimeOfStorageTable.setParamYId(-1);
        this._outflowTimeOfStorageTable.setUnitSystem(this.getUnitSystem());
    }

    @Override
    public synchronized Object clone() {
        SsarrRouting ssarrRouting = (SsarrRouting)super.clone();
        if (this._outflowTimeOfStorageTable != null) {
            ssarrRouting._outflowTimeOfStorageTable = (PairedValues)this._outflowTimeOfStorageTable.clone();
        }
        return ssarrRouting;
    }

    @Override
    public void saveFunctionState(int n) {
        if (this.b == null || n >= this.b.length) {
            return;
        }
        double[] dArray = (double[])this.b[n];
        if (dArray == null || dArray.length < this.a.length) {
            return;
        }
        System.arraycopy(this.a, 0, dArray, 0, this.a.length);
    }

    @Override
    public void saveHotstartState(HotstartState hotstartState, int n) {
        SsarrRoutingHotstartState ssarrRoutingHotstartState = (SsarrRoutingHotstartState)hotstartState.getChildState(this.getName(), this.getClass().getName());
        if (ssarrRoutingHotstartState == null) {
            ssarrRoutingHotstartState = new SsarrRoutingHotstartState(this);
            hotstartState.addChildState(ssarrRoutingHotstartState);
        }
        ((HotstartState)ssarrRoutingHotstartState).saveState(n);
    }

    @Override
    public boolean restoreHotstartState(HotstartState hotstartState) {
        if ((hotstartState = (SsarrRoutingHotstartState)hotstartState.getChildState(this.getName(), this.getClass().getName())) != null) {
            ((RoutingHotstartState)hotstartState).routing(this);
            return hotstartState.restoreState();
        }
        SsarrRouting ssarrRouting = this;
        ssarrRouting.printErrorMessage("Failed to find SsarrRouting hotstart state for " + String.valueOf(ssarrRouting.getElement()));
        return false;
    }

    @Override
    public void restoreFunctionState(int n) {
        if (this.b == null || n >= this.b.length) {
            return;
        }
        double[] dArray = (double[])this.b[n];
        if (dArray == null || dArray.length < this.c.length) {
            return;
        }
        System.arraycopy(dArray, 0, this.c, 0, this.c.length);
        System.arraycopy(dArray, 0, this.a, 0, this.a.length);
        if (n == 6) {
            this.h = false;
        }
    }

    @Override
    public int computeRouting(RunTimeStep runTimeStep) {
        int n = runTimeStep.step;
        int n2 = runTimeStep.nstep;
        runTimeStep.getTimeStepMinutes();
        if (!this.h) {
            for (int i = 0; i < this._numberReaches; ++i) {
                this.c[i] = this._tsUpstrm[n];
            }
            this.h = true;
        }
        double d = (double)runTimeStep.getTimeStepMinutes() / 60.0;
        for (int i = 0; i < n2; ++i) {
            double d2 = this._tsUpstrm[n + i];
            double d3 = i + n - 1 > 0 ? this._tsUpstrm[i + n - 1] : this._tsUpstrm[0];
            if (runTimeStep != null && ((RssTSLocationObject)this).getSystem().b) {
                int n3 = i + n;
                if (((RssTSLocationObject)this).getSystem().shouldSaveHotstartAtTimeStep(n3, runTimeStep.flag)) {
                    ArrayList<Element> arrayList = new ArrayList<Element>(1);
                    Element element = this.element.getTopParent();
                    arrayList.add(element);
                    ((RssTSLocationObject)this).getSystem().checkSaveHotstart(n3, runTimeStep.flag, arrayList);
                }
            }
            this._tsDnstrm[i + n] = this.computeRoutingStep(d, d3, d2);
            if (i != runTimeStep.rtw.getForecastSteps() - runTimeStep.rtw.getNumRoutingSteps() - 1) continue;
            this.element.saveElementState(4);
        }
        return this.checkForecastCalc(runTimeStep, true);
    }

    @Override
    public int computeForecastStep(RunTimeStep runTimeStep) {
        double d = this._tsUpstrm[runTimeStep.step];
        double d2 = runTimeStep.step > 0 ? this._tsUpstrm[runTimeStep.step - 1] : this._tsUpstrm[0];
        this._tsDnstrm[runTimeStep.step] = this.computeRoutingStep((double)runTimeStep.getTimeStepMinutes() / 60.0, d2, d);
        return this.checkForecastStepCalc(runTimeStep, true);
    }

    protected double computeRoutingStep(double d, double d2, double d3) {
        int n;
        double d4;
        int n2 = this._numberReaches;
        double d5 = 0.0;
        for (int i = 0; i < n2; ++i) {
            d5 += this.c[i];
        }
        double d6 = d5 / (double)n2;
        if (this._useTable) {
            d4 = this._outflowTimeOfStorageTable.interpolate(d6);
        } else {
            double d7 = d6;
            if (this.getUnitSystem() == 2) {
                d7 = d6 * 35.3147;
            }
            d4 = d7 < 1.0 ? this._kts : this._kts / Math.pow(d6, this._nCoefficient);
        }
        for (int i = 0; i < n2; ++i) {
            this.d[i] = this.c[i];
        }
        this.f[0] = d2;
        this.g[0] = d3;
        int n3 = 1;
        if (d4 <= d / 2.0) {
            n3 = (int)(d / 2.0 / d4) + 1;
        }
        double d8 = d / (double)n3;
        double d9 = d8 / (d4 + d8 / 2.0);
        double d10 = (d3 - d2) / (double)n3;
        for (n = 0; n < n3; ++n) {
            this.f[0] = d2 + d10 * (double)n;
            this.g[0] = d2 + d10 * (double)(n + 1);
            for (int i = 0; i < n2; ++i) {
                double d11 = (this.f[i] + this.g[i]) / 2.0;
                this.e[i] = this.d[i] + d9 * (d11 - this.d[i]);
                if (i < n2 - 1) {
                    this.f[i + 1] = this.d[i];
                    this.g[i + 1] = this.e[i];
                }
                this.d[i] = this.e[i];
            }
        }
        for (n = 0; n < n2; ++n) {
            this.a[n] = this.e[n];
        }
        for (n = 0; n < n2; ++n) {
            this.c[n] = this.a[n];
        }
        return this.a[this._numberReaches - 1];
    }

    @Override
    public boolean initialize() {
        if (!super.initialize()) {
            return false;
        }
        String string = System.getProperty("SKIP_INITIALIZE");
        if (string == null || string.equals("true")) {
            this.h = false;
            if (this._numberReaches <= 0) {
                this._numberReaches = 1;
            }
            this.c = new double[this._numberReaches];
            this.a = new double[this._numberReaches];
            this.b = new Object[7];
            for (int i = 0; i < 7; ++i) {
                this.b[i] = new double[this._numberReaches];
            }
            this.d = new double[this._numberReaches];
            this.e = new double[this._numberReaches];
            this.f = new double[this._numberReaches];
            this.g = new double[this._numberReaches];
        }
        return true;
    }

    public void setOutflowTimeOfStorageTable(PairedValues object) {
        if (object.getUnitSystem() == 0) {
            object.setUnitSystem(this.getUnitSystem());
            object.setParamYId(-1);
            object.setParamXId(Parameter.PARAMID_FLOW);
            this._outflowTimeOfStorageTable = object;
            return;
        }
        if (object.getUnitSystem() == this.getUnitSystem()) {
            this._outflowTimeOfStorageTable = object;
            return;
        }
        String string = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_FLOW, (int)this.getUnitSystem());
        String string2 = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_FLOW, (int)object.getUnitSystem());
        PairedValues pairedValues = new PairedValues();
        object = object.getDataVector();
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            double d;
            ValuePair valuePair = (ValuePair)((Vector)object).elementAt(i);
            double d2 = valuePair.yval;
            try {
                d = Units.convertUnits((double)valuePair.xval, (String)string2, (String)string);
            }
            catch (DataSetException dataSetException) {
                System.out.println(dataSetException.getMessage());
                dataSetException.printStackTrace();
                d = valuePair.xval;
            }
            pairedValues.addPair(d, d2);
        }
        this._outflowTimeOfStorageTable = pairedValues;
    }

    public void setNCoefficient(double d) {
        this._nCoefficient = d;
    }

    public double getNCoefficient() {
        return this._nCoefficient;
    }

    public void setKTS(double d) {
        this._kts = d;
    }

    public double getKTS() {
        return this._kts;
    }

    public void setUseTable(boolean bl) {
        this._useTable = bl;
    }

    public boolean useTable() {
        return this._useTable;
    }

    public void setNumberReaches(int n) {
        this._numberReaches = n == Integer.MIN_VALUE || n <= 0 ? 1 : n;
        this.c = new double[this._numberReaches];
        this.a = new double[this._numberReaches];
        this.h = false;
    }

    public int getNumberReaches() {
        return this._numberReaches;
    }

    public PairedValues getOutflowTimeOfStorageTable() {
        this._outflowTimeOfStorageTable.setUnitSystem(this.getUnitSystem());
        this._outflowTimeOfStorageTable.setParamXId(Parameter.PARAMID_FLOW);
        this._outflowTimeOfStorageTable.setParamYId(-1);
        return this._outflowTimeOfStorageTable;
    }

    public void setIsSI(boolean bl) {
        this.i = bl;
    }

    public void convertToWatershedUnits() {
    }

    @Override
    public boolean readData(BufferedReader bufferedReader) {
        return false;
    }

    @Override
    public boolean writeData(BufferedWriter bufferedWriter) {
        return false;
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, org.jdom.Element element) {
        element.setAttribute("NumberOfSubreaches", Integer.toString(this._numberReaches));
        if (this._useTable) {
            alternativeInputReport = new org.jdom.Element("Outflow");
            element.addContent((Content)alternativeInputReport);
            XMLUtilities.createArrayElements((org.jdom.Element)alternativeInputReport, (double[])this._outflowTimeOfStorageTable.getXArray());
            alternativeInputReport = new org.jdom.Element("TimeOfStorage");
            element.addContent((Content)alternativeInputReport);
            XMLUtilities.createArrayElements((org.jdom.Element)alternativeInputReport, (double[])this._outflowTimeOfStorageTable.getYArray());
            return;
        }
        element.setAttribute("NumberOfCoefficients", Double.toString(this._nCoefficient));
        element.setAttribute("KTS", Double.toString(this._kts));
    }

    @Override
    public boolean initializeStandalone() {
        if (!this.h) {
            if (this._numberReaches <= 0) {
                this._numberReaches = 1;
            }
            this.c = new double[this._numberReaches];
            this.a = new double[this._numberReaches];
            this.b = new Object[7];
            for (int i = 0; i < 7; ++i) {
                this.b[i] = new double[this._numberReaches];
            }
            this.d = new double[this._numberReaches];
            this.e = new double[this._numberReaches];
            this.f = new double[this._numberReaches];
            this.g = new double[this._numberReaches];
        }
        return true;
    }

    @Override
    public double computeRoutingStepStandalone(int n, double d, double d2, double d3, double[] dArray, double[] dArray2) {
        double d4 = (double)n / 60.0;
        System.arraycopy(dArray, 1, this.c, 0, this._numberReaches);
        double d5 = this.computeRoutingStep(d4, d, d2);
        System.arraycopy(this.a, 0, dArray2, 1, this._numberReaches);
        dArray2[0] = d2;
        return d5;
    }

    @Override
    public double[] getSubreachFlowArray(double d, double d2, int n) {
        double[] dArray = new double[this._numberReaches + 1];
        for (int i = 0; i < this._numberReaches; ++i) {
            dArray[i + 1] = this.a[i];
        }
        dArray[0] = d;
        return dArray;
    }

    @Override
    public int getNumberSubreaches() {
        return this._numberReaches;
    }
}

