/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import com.google.common.flogger.FluentLogger;
import hec.clientapp.model.TSRecordImpl;
import hec.clientapp.model.TSRecordProxy;
import hec.heclib.dss.DSSPathname;
import hec.heclib.util.HecTime;
import hec.heclib.util.doubleArrayContainer;
import hec.io.AsciiSerializable;
import hec.io.TextFileReference;
import hec.io.TimeSeriesContainer;
import hec.lang.annotation.Scriptable;
import hec.model.RunTimeStep;
import hec.model.RunTimeWindow;
import hec.model.TSRecord;
import hec.rss.lang.StopComputeException;
import hec.rss.model.Element;
import hec.rss.model.HindcastData;
import hec.rss.model.JythonUtil;
import hec.rss.model.LocalVariableGroup;
import hec.rss.model.RssRun;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.StateVariable$1;
import hec.rss.model.StateVariableJavaInfc;
import hec.rss.model.dependencies.Dependency;
import hec.rss.model.dependencies.DependencyException;
import hec.rss.model.dependencies.DependencyFinder;
import hec.rss.model.dependencies.DependencySet;
import hec.rss.model.dependencies.TsValRef;
import hec.rss.model.reports.AltInputReportInfc;
import hec.rss.model.reports.AlternativeInputReport;
import hec.util.XMLUtilities;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jdom.Content;
import org.python.core.Py;
import org.python.core.PyCode;
import org.python.core.PyException;
import org.python.core.PyObject;
import org.python.core.PyStringMap;
import org.python.util.PythonInterpreter;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class StateVariable
extends RssTSLocationObject
implements AsciiSerializable,
AltInputReportInfc {
    private static final FluentLogger a = FluentLogger.forEnclosingClass();
    public static final int KNOWN_STATE_CONST = 0;
    public static final int KNOWN_STATE_TS = 1;
    public static final String ARG_VARIABLE = "currentVariable";
    public static final String ARG_NETWORK = "network";
    public static final String ARG_TIMESTEP = "currentRunTimestep";
    public static final String METHOD_NETWORK_GETTIMESERIES = "network.getTimeSeries";
    private TextFileReference _scriptRef;
    private String _script;
    private TextFileReference _initScriptRef;
    private String _initScript;
    private TextFileReference _cleanupScriptRef;
    private String _cleanupScript;
    private boolean _useJavaClass = false;
    private String _javaClasspath = "";
    private Boolean _slaveSV = Boolean.FALSE;
    private RssSystem _network;
    private String _paramName;
    private String _paramType;
    private boolean _alwaysCompute = false;
    private transient PythonInterpreter b = null;
    private StateVariableJavaInfc _javaSVClass;
    private transient doubleArrayContainer c;
    private transient boolean d;
    private transient String e;
    private transient int f = 0;
    private transient double g = 0.0;
    private transient doubleArrayContainer h;
    private transient boolean i = false;
    private transient List j;
    private transient PyCode k;
    private transient PyStringMap l;
    private transient LocalVariableGroup m;
    private transient List n;
    private transient Map<String, Object> o;
    private transient String p;
    private transient long q;
    private transient StateVariable$1 r = new StateVariable$1(this);

    public StateVariable() {
        StateVariable stateVariable = this;
        stateVariable.addObserver(stateVariable.r);
        this._scriptRef = new TextFileReference(this::useTextFileReferences);
        this._cleanupScriptRef = new TextFileReference(this::useTextFileReferences);
        this._initScriptRef = new TextFileReference(this::useTextFileReferences);
    }

    public StateVariable(RssSystem rssSystem, int n) {
        this.setIndex(n);
        this._network = rssSystem;
        StateVariable stateVariable = this;
        stateVariable.addObserver(stateVariable.r);
        this._scriptRef = new TextFileReference(this::useTextFileReferences);
        this._cleanupScriptRef = new TextFileReference(this::useTextFileReferences);
        this._initScriptRef = new TextFileReference(this::useTextFileReferences);
    }

    protected void nameChanged() {
        String string = RMAIO.userNameToFileName((String)this.getName());
        if (this._scriptRef != null) {
            this._scriptRef.setFilename(RMAIO.concatPath((String)"scripts", (String)(string + "_main.py")));
        }
        if (this._initScriptRef != null) {
            this._initScriptRef.setFilename(RMAIO.concatPath((String)"scripts", (String)(string + "_init.py")));
        }
        if (this._cleanupScriptRef != null) {
            this._cleanupScriptRef.setFilename(RMAIO.concatPath((String)"scripts", (String)(string + "_cleanup.py")));
        }
    }

    private void useTextFileReferences() {
        if (this._scriptRef == null) {
            this._scriptRef = new TextFileReference();
        }
        if (this._initScriptRef == null) {
            this._initScriptRef = new TextFileReference();
        }
        if (this._cleanupScriptRef == null) {
            this._cleanupScriptRef = new TextFileReference();
        }
        this.nameChanged();
        if (this._script != null) {
            StateVariable stateVariable = this;
            stateVariable.setScript(stateVariable._script);
        }
        if (this._initScript != null) {
            StateVariable stateVariable = this;
            stateVariable.setInitScript(stateVariable._initScript);
        }
        if (this._cleanupScript != null) {
            StateVariable stateVariable = this;
            stateVariable.setCleanupScript(stateVariable._cleanupScript);
        }
    }

    public List getUsrObjList() {
        if (this.n == null) {
            this.n = new ArrayList();
        }
        return this.n;
    }

    public Object listGet(int n) {
        if (this.n == null) {
            return null;
        }
        return this.n.get(n);
    }

    public void listAdd(Object object) {
        if (this.n == null) {
            this.n = new ArrayList();
        }
        this.n.add(object);
    }

    public void listAdd(int n, Object object) {
        if (this.n == null) {
            this.n = new ArrayList();
        }
        this.n.add(n, object);
    }

    public void clearList() {
        if (this.n != null) {
            this.n.clear();
        }
    }

    public boolean listContains(Object object) {
        if (this.n != null) {
            return this.n.contains(object);
        }
        return false;
    }

    public boolean listRemove(Object object) {
        if (this.n != null) {
            return this.n.remove(object);
        }
        return false;
    }

    public int getListSize() {
        if (this.n != null) {
            return this.n.size();
        }
        return 0;
    }

    public List getReferencedElements() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this._script == null) {
            return arrayList;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this._script, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            int n;
            Object object = stringTokenizer.nextToken();
            if (((String)(object = ((String)object).trim())).startsWith("#") || (n = ((String)object).indexOf(METHOD_NETWORK_GETTIMESERIES)) < 0 || (n = ((String)(object = ((String)object).substring(n))).indexOf("(")) < 0) continue;
            object = ((String)object).substring(n + 1);
            if (!((StringTokenizer)(object = new StringTokenizer((String)object, ","))).hasMoreTokens()) continue;
            String string = ((StringTokenizer)object).nextToken();
            if (!((StringTokenizer)object).hasMoreTokens()) continue;
            object = ((StringTokenizer)object).nextToken();
            string = StateVariable.a(string);
            object = StateVariable.a((String)object);
            if ((object = this._network.getTimeSeriesLocation(string, (String)object)) == null || arrayList.contains(object)) continue;
            arrayList.add(object);
        }
        return arrayList;
    }

    private static String a(String string) {
        int n = (string = string.trim()).indexOf(34) + 1;
        if (n >= 0 && n < string.length()) {
            int n2 = string.lastIndexOf(34);
            string = n2 < n ? string.substring(n) : string.substring(n, n2);
            string = string.trim();
        }
        return string;
    }

    public boolean getAlwaysCompute() {
        return this._alwaysCompute;
    }

    public void setAlwaysCompute(boolean bl) {
        this._alwaysCompute = bl;
    }

    public boolean isActive() {
        return this.i;
    }

    public void setActive(boolean bl) {
        this.i = bl;
    }

    public void setUseJavaClass(boolean bl) {
        this._useJavaClass = bl;
    }

    public boolean useJavaClass() {
        return this._useJavaClass;
    }

    public void setJavaClasspath(String string) {
        this._javaClasspath = string;
    }

    public String getJavaClasspath() {
        return this._javaClasspath;
    }

    public void getHindcastDataList(Vector vector) {
        if (vector == null) {
            return;
        }
        Object object = this._network.getKeyStringForObject(this);
        object = new HindcastData((String)object, 98, 1);
        vector.add(object);
    }

    public void applyHindcastData(HindcastData hindcastData) {
        if (hindcastData == null) {
            return;
        }
        if (hindcastData.getVariableId() == 98) {
            if (hindcastData.getType() == 1) {
                this.f = 0;
                this.g = hindcastData.getValue();
                return;
            }
            if (hindcastData.getType() == 0) {
                this.f = 1;
            }
        }
    }

    public String getScript() {
        return TextFileReference.getValue((TextFileReference)this._scriptRef, (String)this._script);
    }

    public void setScript(String string) {
        this._script = TextFileReference.setValue((TextFileReference)this._scriptRef, (String)string);
        this.e = null;
    }

    public String getInitScript() {
        return TextFileReference.getValue((TextFileReference)this._initScriptRef, (String)this._initScript);
    }

    public void setInitScript(String string) {
        this._initScript = TextFileReference.setValue((TextFileReference)this._initScriptRef, (String)string);
    }

    public String getCleanupScript() {
        return TextFileReference.getValue((TextFileReference)this._cleanupScriptRef, (String)this._cleanupScript);
    }

    public void setCleanupScript(String string) {
        this._cleanupScript = TextFileReference.setValue((TextFileReference)this._cleanupScriptRef, (String)string);
    }

    @Scriptable
    public String getParamName() {
        return this._paramName;
    }

    @Scriptable
    public String getParamType() {
        return this._paramType;
    }

    public void setParamType(String string) {
        this._paramType = string;
    }

    public void setParamName(String string) {
        this._paramName = string;
    }

    public void setAsSlave(boolean bl) {
        this._slaveSV = bl;
    }

    public boolean isSlave() {
        return this._slaveSV;
    }

    @Scriptable
    public String toString() {
        return this.getName();
    }

    protected boolean initialize() {
        this.c = null;
        this.c = this.getTSContainer(97);
        if (this.c == null) {
            this._network.printErrorMessage("StateVariable(" + this.getName() + ").initialize: failed to init time-series");
            return false;
        }
        if (this.f == 1) {
            this.getTSDataSet(true).loadTSRecords();
            this.h = this.getTSContainer(98);
            if (this.h == null) {
                this._network.printErrorMessage("StateVariable(" + this.getName() + ").initialize: failed to find lookback time-series");
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean runScripInitialize() {
        this.q = 0L;
        this.j = this.getReferencedElements();
        this.n = null;
        this.o = null;
        if (this._useJavaClass) {
            Class<?> clazz;
            try {
                clazz = Class.forName(this._javaClasspath);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ((FluentLogger.Api)a.atSevere()).log("ERROR: Can't find class %s to use for the State Variable %s", (Object)this._javaClasspath, (Object)this.getName());
                return false;
            }
            try {
                Object obj = clazz.newInstance();
                if (!(obj instanceof StateVariableJavaInfc)) return true;
                this._javaSVClass = (StateVariableJavaInfc)obj;
                StateVariable stateVariable = this;
                this._javaSVClass.initialization(stateVariable, ((RssTSLocationObject)stateVariable).getSystem());
                return true;
            }
            catch (InstantiationException instantiationException) {
                ((FluentLogger.Api)a.atSevere()).log("Error retrieving user specified Java class for State Variable %s failed. Error: %s ", (Object)this.getName(), (Object)instantiationException.getMessage());
                ((RssTSLocationObject)this).getSystem().printErrorMessage("Error retrieving user specified Java class for State Variable " + this.getName() + " failed " + String.valueOf(instantiationException));
                instantiationException.printStackTrace();
                return false;
            }
            catch (IllegalAccessException illegalAccessException) {
                ((FluentLogger.Api)a.atInfo()).log("Error retrieving user specified Java class for State Variable %s failed. Error %s ", (Object)this.getName(), (Object)illegalAccessException.getMessage());
                ((RssTSLocationObject)this).getSystem().printErrorMessage("Error retrieving user specified Java class for State Variable " + this.getName() + " failed " + String.valueOf(illegalAccessException));
                illegalAccessException.printStackTrace();
                return false;
            }
        }
        if (this.runPythonScriptInitialize()) return true;
        return false;
    }

    private boolean runPythonScriptInitialize() {
        Object object;
        if (this.b == null) {
            this.b = this.createInitializedInterpreter();
        }
        try {
            StateVariable stateVariable = this;
            object = stateVariable.compileScript(stateVariable._initScriptRef, this._initScript);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            if (exception.toString().contains("Mark invalid") && this.getScript().length() > StateVariable.a()) {
                ((RssTSLocationObject)this).getSystem().printErrorMessage("Failed to compile State Variable " + this.getName() + " Init Script. It contains too many characters for Jython to compile.");
            } else {
                ((FluentLogger.Api)a.atInfo()).log("Python Compilation Error of StateVariable %s Init Script failed. Error: %s ", (Object)this.getName(), (Object)exception2.getMessage());
                ((RssTSLocationObject)this).getSystem().printErrorMessage("Python Compilation Error of StateVariable " + this.getName() + " failed");
            }
            return false;
        }
        if (!this.initializeScript((PyCode)object)) {
            ((RssTSLocationObject)this).getSystem().printErrorMessage("Initialization of StateVariable " + this.getName() + " failed");
            return false;
        }
        try {
            this.k = this.compileScript(this._scriptRef, this._script);
        }
        catch (Exception exception) {
            object = exception;
            if (exception.toString().contains("Mark invalid") && this.getScript().length() > StateVariable.a()) {
                ((RssTSLocationObject)this).getSystem().printErrorMessage("Failed to compile State Variable " + this.getName() + " Main Script. It contains too many characters for Jython to compile.");
            } else {
                ((RssTSLocationObject)this).getSystem().printErrorMessage("Failed to compile State Variable " + this.getName() + " Main Script. Exception:" + String.valueOf(object));
                ((Throwable)object).printStackTrace();
            }
            return false;
        }
        this.l = new PyStringMap();
        this.l.__setitem__(ARG_VARIABLE, Py.java2py((Object)this));
        this.l.__setitem__(ARG_NETWORK, Py.java2py((Object)((RssTSLocationObject)this).getSystem()));
        return true;
    }

    public static int a() {
        return Integer.getInteger("Scripts.MaxLength", 99000);
    }

    private boolean initializeScript(PyCode object) {
        boolean bl = true;
        long l = System.currentTimeMillis();
        if (object != null) {
            bl = false;
            try {
                if (this.d) {
                    ((RssTSLocationObject)this).getSystem().printLogMessage("initializeScript(" + this.getName() + ")");
                }
                PyStringMap pyStringMap = new PyStringMap();
                pyStringMap.__setitem__(ARG_VARIABLE, Py.java2py((Object)this));
                pyStringMap.__setitem__(ARG_NETWORK, Py.java2py((Object)((RssTSLocationObject)this).getSystem()));
                this.b.setLocals((PyObject)pyStringMap);
                this.b.exec((PyObject)object);
                this.b.set(ARG_VARIABLE, Py.java2py((Object)this));
                this.b.set(ARG_NETWORK, Py.java2py((Object)((RssTSLocationObject)this).getSystem()));
                this.b.exec("ret=initStateVariable(currentVariable, network)\n");
                bl = true;
                object = (Boolean)this.b.get("ret", Boolean.class);
                if (object instanceof Boolean) {
                    if (this.d) {
                        ((RssTSLocationObject)this).getSystem().printLogMessage("initializeScript(" + this.getName() + ") returning " + (Boolean)object);
                    }
                    Object object2 = object;
                    bl = (Boolean)object2;
                }
            }
            catch (Exception exception) {
                Object object3;
                boolean bl2 = false;
                if (exception instanceof PyException) {
                    object3 = (PyException)((Object)exception);
                    object3.normalize();
                    String string = PyException.exceptionClassName((PyObject)object3.type);
                    if (StopComputeException.class.getName().equals(string)) {
                        ((FluentLogger.Api)a.atInfo()).log("initializeScript:caught %s", (Object)object3.value);
                        ((FluentLogger.Api)a.atInfo()).log("State Variable %s''s init script halted the compute", (Object)this.getName());
                        ((RssTSLocationObject)this).getSystem().printErrorMessage(object3.value.toString());
                        ((RssTSLocationObject)this).getSystem().printErrorMessage("State Variable " + this.getName() + "'s init script halted the compute");
                        bl = false;
                        bl2 = true;
                    }
                }
                if (!bl2) {
                    ((FluentLogger.Api)a.atInfo()).log("initializeScript:Error running initialization script %s", (Object)exception.getMessage());
                    object3 = this.getInitializeScript();
                    if (this._network.getRssRun().getLogLevel() >= 7) {
                        ((FluentLogger.Api)a.atInfo()).log("initializeScript:initialization script is:");
                        ((FluentLogger.Api)a.atInfo()).log("==========================================");
                        ((FluentLogger.Api)a.atInfo()).log((String)object3);
                        ((FluentLogger.Api)a.atInfo()).log("==========================================");
                    }
                    ((RssTSLocationObject)this).getSystem().printErrorMessage("Error running StateVariable " + this.getName() + "'s initialization script. Error" + String.valueOf(exception));
                    if (this.d) {
                        ((FluentLogger.Api)((FluentLogger.Api)a.atInfo()).withCause((Throwable)exception)).log();
                    }
                    ((RssTSLocationObject)this).getSystem().printErrorMessage("Check ComputeLog for details");
                    ((RssTSLocationObject)this).getSystem().printLogMessage("StateVariable " + this.getName() + " initialization failed.");
                    ((RssTSLocationObject)this).getSystem().printLogMessage(exception.toString());
                    if (this._network.getRssRun().getLogLevel() >= 7) {
                        ((RssTSLocationObject)this).getSystem().printLogMessage("Initialization script is:");
                        ((RssTSLocationObject)this).getSystem().printLogMessage("-------------------------------");
                        ((RssTSLocationObject)this).getSystem().printLogMessage((String)object3);
                        ((RssTSLocationObject)this).getSystem().printLogMessage("-------------------------------");
                    }
                    this.p = null;
                    bl = false;
                }
            }
            finally {
                if (this.d) {
                    ((RssTSLocationObject)this).getSystem().printLogMessage("initializeScript " + this.getName() + " took:" + (System.currentTimeMillis() - l) + " ms.");
                }
            }
        }
        return bl;
    }

    private PyCode compileScript(TextFileReference textFileReference, String string) {
        string = TextFileReference.getValue((TextFileReference)textFileReference, (String)string);
        return JythonUtil.a(string, this.getScriptFilepath(textFileReference));
    }

    private String getScriptFilepath(TextFileReference object) {
        String string = null;
        if (object != null && (object = object.getFilename()) != null) {
            string = ((RssTSLocationObject)this).getSystem().getBaseDirectory();
            string = RMAIO.concatPath((String)string, (String)object);
        }
        return string;
    }

    private PythonInterpreter createInitializedInterpreter() {
        long l = System.currentTimeMillis();
        RssRun rssRun = ((RssTSLocationObject)this).getSystem().getRssRun();
        if (rssRun != null) {
            this.d = rssRun.getLogLevel() == 10;
        }
        JythonUtil.c();
        rssRun = new PythonInterpreter();
        JythonUtil.a((PythonInterpreter)rssRun, ((RssTSLocationObject)this).getSystem().getFileManager());
        if (this.d) {
            ((RssTSLocationObject)this).getSystem().printLogMessage("initializeCompute(" + this.getName() + "): creating interpreter took " + (System.currentTimeMillis() - l) + " ms");
        }
        return rssRun;
    }

    public boolean runCleanupScript() {
        block15: {
            if (this._useJavaClass) {
                if (this._javaSVClass != null) {
                    StateVariable stateVariable = this;
                    this._javaSVClass.cleanUp(stateVariable, ((RssTSLocationObject)stateVariable).getSystem());
                }
            } else if (!this._slaveSV.booleanValue()) {
                String string;
                if (this.b == null) {
                    this.b = this.createInitializedInterpreter();
                }
                if ((string = this.getCleanupScript()) == null || string.length() == 0) {
                    if (this.b != null) {
                        this.b.cleanup();
                    }
                } else {
                    try {
                        StateVariable stateVariable = this;
                        String string2 = stateVariable.getScriptFilepath(stateVariable._cleanupScriptRef);
                        PyCode pyCode = JythonUtil.a(string, string2);
                        PyStringMap pyStringMap = new PyStringMap();
                        pyStringMap.__setitem__(ARG_VARIABLE, Py.java2py((Object)this));
                        pyStringMap.__setitem__(ARG_NETWORK, Py.java2py((Object)((RssTSLocationObject)this).getSystem()));
                        this.b.setLocals((PyObject)pyStringMap);
                        this.b.exec((PyObject)pyCode);
                        this.b.cleanup();
                        this.b = null;
                    }
                    catch (StopComputeException stopComputeException) {
                        ((FluentLogger.Api)a.atInfo()).log("runCleanupScript:catch StopComputeException %s", (Object)stopComputeException.getMessage());
                        ((FluentLogger.Api)a.atInfo()).log("State Variable %s''s cleanup script halted the compute", (Object)this.getName());
                        ((RssTSLocationObject)this).getSystem().printErrorMessage(stopComputeException.getMessage());
                        ((RssTSLocationObject)this).getSystem().printErrorMessage("State Variable " + this.getName() + "'s cleanup script halted the compute");
                        return false;
                    }
                    catch (Exception exception) {
                        Exception exception2 = exception;
                        if (exception instanceof PyException) {
                            PyException pyException = (PyException)((Object)exception2);
                            pyException.normalize();
                            String string3 = PyException.exceptionClassName((PyObject)pyException.type);
                            if (StopComputeException.class.getName().equals(string3)) {
                                ((FluentLogger.Api)a.atInfo()).log("runCleanupScript:caught %s" + String.valueOf(pyException.value));
                                ((FluentLogger.Api)a.atInfo()).log("State Variable %s''s cleanup script halted the compute", (Object)this.getName());
                                ((RssTSLocationObject)this).getSystem().printErrorMessage(pyException.value.toString());
                                ((RssTSLocationObject)this).getSystem().printErrorMessage("State Variable " + this.getName() + "'s cleanup script halted the compute");
                                return false;
                            }
                        }
                        ((FluentLogger.Api)a.atInfo()).log("runCleanupScript running cleanup script %s Error: %s", (Object)this.getName(), (Object)exception2.getMessage());
                        if (this._network.getRssRun().getLogLevel() >= 7) {
                            ((FluentLogger.Api)a.atInfo()).log("runCleanupScript script is:");
                            ((FluentLogger.Api)a.atInfo()).log("==========================================");
                            ((FluentLogger.Api)a.atInfo()).log(string);
                            ((FluentLogger.Api)a.atInfo()).log("==========================================");
                        }
                        if (this.d) {
                            ((FluentLogger.Api)((FluentLogger.Api)a.atInfo()).withCause((Throwable)exception2)).log();
                        }
                        ((RssTSLocationObject)this).getSystem().printErrorMessage("Error running StateVariable " + this.getName() + "'s cleanup script. Error" + String.valueOf(exception2));
                        ((RssTSLocationObject)this).getSystem().printErrorMessage("Check ComputeLog for details");
                        ((RssTSLocationObject)this).getSystem().printLogMessage("StateVariable " + this.getName() + " cleanup failed.");
                        ((RssTSLocationObject)this).getSystem().printLogMessage(exception2.toString());
                        if (this._network.getRssRun().getLogLevel() < 7) break block15;
                        ((RssTSLocationObject)this).getSystem().printLogMessage("Cleanup script is:");
                        ((RssTSLocationObject)this).getSystem().printLogMessage("-------------------------------");
                        ((RssTSLocationObject)this).getSystem().printLogMessage(string);
                        ((RssTSLocationObject)this).getSystem().printLogMessage("-------------------------------");
                    }
                }
            }
        }
        return true;
    }

    private String getInitializeScript() {
        if (this.p == null) {
            CharSequence charSequence = TextFileReference.getValue((TextFileReference)this._initScriptRef, (String)this._initScript);
            if (charSequence == null || ((String)charSequence).isEmpty()) {
                return "";
            }
            charSequence = new StringBuilder((String)charSequence);
            ((StringBuilder)charSequence).append("\n");
            ((StringBuilder)charSequence).append("ret=initStateVariable(currentVariable, network)\n");
            this.p = ((StringBuilder)charSequence).toString();
        }
        return this.p;
    }

    void evaluateHindcast(RunTimeStep runTimeStep) {
        if (this.c == null) {
            return;
        }
        if (this.f == 1) {
            if (this.h != null && RMAConst.isValidValue((double)this.h.array[runTimeStep.step])) {
                this.c.array[runTimeStep.step] = this.h.array[runTimeStep.step];
                return;
            }
            this._network.printErrorMessage("StateVariable(" + this.getName() + ").computeHindcastStep: known state variable TS empty or invalid");
            this._network.printMessage("  Date and Time: " + runTimeStep.dateTimeString());
            return;
        }
        if (this.f == 0) {
            this.c.array[runTimeStep.step] = this.g;
        }
    }

    public void evaluate(RunTimeStep object) {
        long l = System.currentTimeMillis();
        if (this._useJavaClass) {
            if (this._javaSVClass != null) {
                this._javaSVClass.main(this, (RunTimeStep)object, ((RssTSLocationObject)this).getSystem());
                return;
            }
        } else if (!this._slaveSV.booleanValue()) {
            this.l.__setitem__("currentRuntimestep", Py.java2py((Object)object));
            if (this.b == null) {
                this.b = this.createInitializedInterpreter();
            }
            this.b.setLocals((PyObject)this.l);
            if (this.k != null) {
                try {
                    this.b.exec((PyObject)this.k);
                    long l2 = System.currentTimeMillis();
                    this.q += l2 - l;
                    return;
                }
                catch (Exception exception) {
                    Object object2;
                    Exception exception2 = exception;
                    if (exception instanceof PyException) {
                        object2 = (PyException)((Object)exception2);
                        object2.normalize();
                        object = PyException.exceptionClassName((PyObject)object2.type);
                        if (StopComputeException.class.getName().equals(object)) {
                            ((FluentLogger.Api)a.atInfo()).log("evaluate:caught %s", (Object)object2.value);
                            ((FluentLogger.Api)a.atInfo()).log("State Variable %s''s script halted the compute", (Object)this.getName());
                            ((RssTSLocationObject)this).getSystem().printErrorMessage(object2.value.toString());
                            ((RssTSLocationObject)this).getSystem().printErrorMessage("State Variable " + this.getName() + "'s script halted the compute");
                            throw object2;
                        }
                    }
                    ((FluentLogger.Api)a.atInfo()).log("evaluate:Error running script for StateVariable %s Error: %s", (Object)this.getName(), (Object)exception2);
                    ((RssTSLocationObject)this).getSystem().printErrorMessage("Error running script for StateVariable " + this.getName() + " Error:" + String.valueOf(exception2));
                    if (this._network.getRssRun().getLogLevel() >= 7) {
                        object2 = TextFileReference.getValue((TextFileReference)this._scriptRef, (String)this._script);
                        ((FluentLogger.Api)a.atInfo()).log("evaluate:StateVariable script is:");
                        ((FluentLogger.Api)a.atInfo()).log("==========================================");
                        ((FluentLogger.Api)a.atInfo()).log((String)object2);
                        ((FluentLogger.Api)a.atInfo()).log("==========================================");
                        ((RssTSLocationObject)this).getSystem().printLogMessage("evaluate:StateVariable script is:");
                        ((RssTSLocationObject)this).getSystem().printLogMessage("==========================================");
                        ((RssTSLocationObject)this).getSystem().printLogMessage((String)object2);
                        ((RssTSLocationObject)this).getSystem().printLogMessage("==========================================");
                    }
                    throw new RuntimeException(exception2);
                }
            }
        }
    }

    @Scriptable
    public void setValue(RunTimeStep runTimeStep, double d) {
        this.setValue(runTimeStep.step, d);
    }

    @Scriptable
    public void setValue(int n, double d) {
        if (this.c == null || this.c.array == null) {
            return;
        }
        if (n < 0 || n >= this.c.array.length) {
            return;
        }
        this.c.array[n] = d;
    }

    @Scriptable
    public void setValueRange(RunTimeStep runTimeStep, int n, double d) {
        this.setValueRange(runTimeStep.step, n, d);
    }

    @Scriptable
    public void setValueRange(int n, int n2, double d) {
        if (this.c == null || this.c.array == null) {
            return;
        }
        if (n < 0 || n >= this.c.array.length) {
            return;
        }
        if (n2 < 0) {
            return;
        }
        int n3 = n2;
        if (n + n2 >= this.c.array.length) {
            n3 = this.c.array.length - n;
        }
        n2 = n + n3;
        while (n < n2) {
            this.c.array[n] = d;
            ++n;
        }
    }

    @Scriptable
    public void setValueRange(RunTimeStep runTimeStep, HecTime hecTime, HecTime hecTime2, double d) {
        if (runTimeStep == null) {
            return;
        }
        this.setValueRange(runTimeStep.step, hecTime, hecTime2, d);
    }

    @Scriptable
    public void setValueRange(int n, HecTime hecTime, HecTime hecTime2, double d) {
        if (hecTime == null || hecTime2 == null || !hecTime.isDefined() || !hecTime2.isDefined() || hecTime2.lessThan(hecTime)) {
            return;
        }
        RunTimeWindow runTimeWindow = this.getNetwork().getRssRun().getRunTimeWindow();
        if (runTimeWindow == null) {
            return;
        }
        int n2 = runTimeWindow.getStepAtTime(hecTime);
        int n3 = runTimeWindow.getStepAtTime(hecTime2);
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 >= this.c.array.length) {
            n3 = this.c.array.length - 1;
        }
        if (n3 < n2) {
            return;
        }
        while (n2 < n3) {
            this.c.array[n2] = d;
            ++n2;
        }
    }

    @Scriptable
    public double getValue(RunTimeStep runTimeStep) {
        if (runTimeStep == null) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.getValue(runTimeStep.step);
    }

    protected double getValue(int n) {
        if (this.c == null || this.c.array == null) {
            return Double.NEGATIVE_INFINITY;
        }
        if (n < 0 || n >= this.c.array.length) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.c.array[n];
    }

    @Scriptable
    public double getPreviousValue(RunTimeStep runTimeStep) {
        if (runTimeStep == null) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.getValue(runTimeStep.step - 1);
    }

    public Vector getActiveTSProxies(Vector vector, int n) {
        if (vector == null) {
            vector = new Vector<TSRecordProxy>();
        }
        if (n == 1) {
            if (this.f == 1) {
                vector.add(this.getTSRecordProxy(98));
            }
        } else {
            vector.add(this.getTSRecordProxy(97));
        }
        return vector;
    }

    @Override
    @Scriptable
    public RssSystem getSystem() {
        return this._network;
    }

    @Scriptable
    public RssSystem getNetwork() {
        return ((RssTSLocationObject)this).getSystem();
    }

    public void setSystem(RssSystem rssSystem) {
        this._network = rssSystem;
    }

    @Override
    public void updateTSProxyList() {
        TSRecordProxy tSRecordProxy = null;
        if (this.getTSRecordProxy(97) == null) {
            if (this._paramName != null) {
                StateVariable stateVariable = this;
                tSRecordProxy = stateVariable.addTSRecordProxy(stateVariable.getName(), this._paramName, 97);
            } else {
                tSRecordProxy = this.addTSRecordProxy(97);
            }
        }
        if (this.getTSRecordProxy(98) == null) {
            if (this._paramName != null) {
                StateVariable stateVariable = this;
                tSRecordProxy = stateVariable.addTSRecordProxy(stateVariable.getName(), this._paramName, 98);
            } else {
                tSRecordProxy = this.addTSRecordProxy(98);
            }
        }
        if (tSRecordProxy != null) {
            this.setModified(true);
        }
    }

    @Scriptable
    public TSRecord getTimeSeries() {
        TSRecordProxy tSRecordProxy = this.getTSRecordProxy(97);
        if (tSRecordProxy != null) {
            return tSRecordProxy.getTSRecord();
        }
        return null;
    }

    @Scriptable
    public TSRecord getLookbackTimeSeries() {
        TSRecordProxy tSRecordProxy = this.getTSRecordProxy(98);
        if (tSRecordProxy != null) {
            return tSRecordProxy.getTSRecord();
        }
        return null;
    }

    @Scriptable
    public TSRecord localTimeSeriesNew(String string) {
        return this.localTimeSeriesNew(string, Double.NEGATIVE_INFINITY);
    }

    @Scriptable
    public TSRecord localTimeSeriesNew(String string, double d) {
        if (this.m == null) {
            this.m = new LocalVariableGroup();
        }
        return this.m.a(string, d, this.c.array.length);
    }

    @Scriptable
    public TSRecord localTimeSeriesNew(String string, TimeSeriesContainer timeSeriesContainer) {
        if (this.m == null) {
            this.m = new LocalVariableGroup();
        }
        return this.m.a(string, timeSeriesContainer);
    }

    @Scriptable
    public int localTimeSeriesSize() {
        return this.m.a();
    }

    @Scriptable
    public int localTimeSeriesClear() {
        return this.m.b();
    }

    @Scriptable
    public List<String> localTimeSeriesListKeys() {
        if (this.m == null) {
            return Collections.emptyList();
        }
        return this.m.c();
    }

    @Scriptable
    public List<TSRecord> localTimeSeriesList() {
        if (this.m == null) {
            return new ArrayList<TSRecord>(0);
        }
        return this.m.d();
    }

    @Scriptable
    public TSRecord localTimeSeriesGet(String string) {
        if (this.m == null) {
            this.m = new LocalVariableGroup();
        }
        return this.m.a(string);
    }

    @Scriptable
    public boolean localTimeSeriesExists(String string) {
        if (this.m == null) {
            return false;
        }
        return this.m.b(string);
    }

    @Scriptable
    public boolean localTimeSeriesWrite(String string) {
        if (string == null || this.m == null) {
            return false;
        }
        TSRecordImpl tSRecordImpl = (TSRecordImpl)this.localTimeSeriesGet(string);
        if (tSRecordImpl == null) {
            ((FluentLogger.Api)a.atInfo()).log("localTimeSeriesWrite: no local timeseries found for %s", (Object)string);
            return false;
        }
        RssSystem rssSystem = ((RssTSLocationObject)this).getSystem();
        if (rssSystem == null) {
            ((FluentLogger.Api)a.atInfo()).log("localTimeSeriesWrite:failed to get ResSim Network");
            return false;
        }
        RssRun rssRun = rssSystem.getRssRun();
        if (rssRun == null) {
            ((FluentLogger.Api)a.atInfo()).log("localTimeSeriesWrite:failed to get ResSim Run");
            return false;
        }
        String string2 = rssRun.getDSSOutputFile();
        tSRecordImpl.setDSSFilename(string2);
        string2 = this.getTimeSeries();
        string2 = string2.getDSSPathname();
        string2 = new DSSPathname(string2);
        String string3 = string2.getBPart();
        string3 = string3.concat("-").concat(string);
        string2.setBPart(string3);
        string3 = tSRecordImpl.getDSSPathname();
        if (string3 != null && string3.length() > 0) {
            String string4 = (string3 = new DSSPathname(string3)).getCPart();
            if (string4 != null && string4.length() > 0) {
                string2.setCPart(string4);
            }
            if ((string3 = string3.getEPart()) != null && string3.length() > 0) {
                string2.setEPart(string3);
            }
        }
        tSRecordImpl.setDSSPathname(string2.getPathname());
        ((FluentLogger.Api)a.atInfo()).log("localTimeSeriesWrite:DSSpath for %s is %s", (Object)string, (Object)tSRecordImpl.getDSSPathname());
        string3 = rssRun.getRunTimeWindow();
        tSRecordImpl.setTimeWindow(string3.getLookbackTime(), string3.getStartTime());
        if (!tSRecordImpl.writeTSData(rssSystem.getDSSFileManager())) {
            rssSystem.printErrorMessage("Failed to save Local TimeSeries " + string + " for StateVariable " + this.getName());
            ((FluentLogger.Api)a.atInfo()).log("localTimeSeriesWrite:Failed to save Local TimeSeries %s for StateVariable %s", (Object)string, (Object)this.getName());
            return false;
        }
        return true;
    }

    @Scriptable
    public boolean localTimeSeriesWriteAll() {
        List<String> list = this.localTimeSeriesListKeys();
        boolean bl = true;
        for (int i = 0; i < list.size(); ++i) {
            if (this.localTimeSeriesWrite(list.get(i))) continue;
            bl = false;
        }
        return bl;
    }

    @Scriptable
    public boolean varExists(String string) {
        if (string == null || this.o == null) {
            return false;
        }
        return this.o.containsKey(string);
    }

    @Scriptable
    public void varPut(String string, Object object) {
        if (string == null || object == null) {
            return;
        }
        if (this.o == null) {
            this.o = new LinkedHashMap<String, Object>();
        }
        this.o.put(string, object);
    }

    @Scriptable
    public Object varGet(String string) {
        if (this.o == null) {
            return null;
        }
        return this.o.get(string);
    }

    @Scriptable
    public int varsClear() {
        if (this.o == null) {
            return 0;
        }
        int n = this.o.size();
        this.o.clear();
        return n;
    }

    @Scriptable
    public int varsSize() {
        if (this.o == null) {
            return 0;
        }
        return this.o.size();
    }

    @Scriptable
    public List<Object> varsList() {
        if (this.o == null) {
            return new ArrayList<Object>(0);
        }
        Collection<Object> collection = this.o.values();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.addAll(collection);
        return arrayList;
    }

    @Scriptable
    public List<String> varsListKeys() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.o == null) {
            return arrayList;
        }
        Object object = this.o.keySet();
        object = object.iterator();
        while (object.hasNext()) {
            arrayList.add((String)object.next());
        }
        return arrayList;
    }

    @Scriptable
    public Object varRemove(String string) {
        if (this.o == null) {
            return null;
        }
        return this.o.remove(string);
    }

    long getTotalComputeTime() {
        return this.q;
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, org.jdom.Element element) {
        element.setAttribute("Name", this._name);
        element.setAttribute("Description", this._description);
        element.setAttribute("Parameter", this._paramName);
        element.setAttribute("ParameterType", this._paramType);
        element.setAttribute("AlwaysCompute", Boolean.toString(this._alwaysCompute));
        if (this.p != null) {
            alternativeInputReport = new org.jdom.Element("Initialize");
            element.addContent((Content)alternativeInputReport);
            XMLUtilities.saveDescription((org.jdom.Element)alternativeInputReport, (String)this.p);
            element.setText(this.p);
        }
        if (this._script != null) {
            element.setText(this._script);
        }
        if (this._cleanupScript != null) {
            element.setText(this._cleanupScript);
        }
    }

    public void getElementDependencies(List<Element> list, Element object) {
        if (this._network == null) {
            return;
        }
        if (this.b == null) {
            this.b = this.createInitializedInterpreter();
        }
        object = new DependencyFinder(this.b);
        ((DependencyFinder)object).a(ARG_NETWORK, this._network);
        try {
            object = DependencySet.a(new String[]{this.getInitScript(), this.getScript(), this.getCleanupScript()}, (DependencyFinder)object);
            this.addElemDep(list, ((DependencySet)object).b());
            this.addElemDep(list, ((DependencySet)object).a());
            return;
        }
        catch (DependencyException dependencyException) {
            ((RssTSLocationObject)this).getSystem().printWarningMessage("failed to build dependency set for ScriptedOpRule (" + this.getName() + ")");
            return;
        }
    }

    private void addElemDep(List<Element> list, Collection<Dependency> object) {
        if (object == null) {
            return;
        }
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (Dependency)object.next();
            if (!((Dependency)object2).f()) continue;
            String string = this.getDependencyName((Dependency)object2);
            object2 = this.getDependencyType((Dependency)object2);
            Element element = null;
            int n = -1;
            switch (((String)object2).hashCode()) {
                case -173110412: {
                    if (!((String)object2).equals("Junction")) break;
                    n = 0;
                    break;
                }
                case -268033969: {
                    if (!((String)object2).equals("Reservoir")) break;
                    n = 1;
                    break;
                }
                case 78834003: {
                    if (!((String)object2).equals("Reach")) break;
                    n = 2;
                    break;
                }
                case 310247571: {
                    if (!((String)object2).equals("Diversion")) break;
                    n = 3;
                }
            }
            switch (n) {
                case 0: {
                    element = this._network.findJunction(string);
                    break;
                }
                case 1: {
                    element = this._network.findReservoir(string);
                    break;
                }
                case 2: {
                    element = this._network.findReach(string);
                    break;
                }
                case 3: {
                    element = this._network.findDiversion(string);
                }
            }
            if (element == null || list.contains(element)) continue;
            list.add(element);
        }
    }

    private String getDependencyName(Dependency object) {
        String string = "";
        if ((object = ((Dependency)object).c()) != null && (object = ((TsValRef)object).c()) != null) {
            string = object.getName();
        }
        return string;
    }

    private String getDependencyType(Dependency object) {
        String string = "";
        if ((object = ((Dependency)object).c()) != null && (object = ((TsValRef)object).c()) != null) {
            string = object.getType();
        }
        return string;
    }
}

