/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.TSRecordProxy;
import hec.data.DataSetIllegalArgumentException;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.heclib.dss.DSSPathname;
import hec.heclib.util.doubleArrayContainer;
import hec.io.DSSIdentifier;
import hec.model.Interpolate;
import hec.model.PairedValues;
import hec.model.PairedValuesExt;
import hec.model.RunTimeStep;
import hec.rss.model.CapacityRecord;
import hec.rss.model.Continuity;
import hec.rss.model.Element;
import hec.rss.model.Function;
import hec.rss.model.HindcastData;
import hec.rss.model.PowerPlant;
import hec.rss.model.RSimDssPathPartGenerator;
import hec.rss.model.ReservoirElement;
import hec.rss.model.ReservoirOp;
import hec.rss.model.RssNode;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.VerticalDatumSettings;
import hec.rss.model.reports.AltInputReportInfc;
import hec.rss.model.reports.AlternativeInputReport;
import hec.util.XMLUtilities;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.army.usace.hec.metadata.VerticalDatumException;
import org.jdom.Content;
import rma.util.RMAConst;

public class Storage
extends Continuity
implements AltInputReportInfc {
    public static final int KNOWN_STORAGE_CONST = 0;
    public static final int KNOWN_STORAGE_TS = 1;
    public static final int KNOWN_ELEVATION_CONST = 2;
    public static final int KNOWN_ELEVATION_TS = 3;
    public static final int KNOWN_GUIDECURVE = 4;
    public static final int KNOWN_ELEV_FREL_CON = 5;
    public static final int KNOWN_ELEV_FREL_TS = 6;
    public static final int KNOWN_STOR_FREL_CON = 7;
    public static final int KNOWN_STOR_FREL_TS = 8;
    public static final int KNOWN_FREL_GC = 9;
    public static final int FIRST_HINDCAST_COND = 0;
    public static final int LAST_HINDCAST_COND = 9;
    public static final int SEEPAGE_NONE = -1;
    public static final int SEEPAGE_CONST = 0;
    public static final int SEEPAGE_FUNC = 1;
    public static final int EVAP_NONE = -1;
    public static final int EVAP_MONTHLY = 0;
    public static final int EVAP_TS = 1;
    public static final int[] DAYS_PER_MONTH = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private PairedValuesExt _capacityValues = null;
    Vector _capacityVector = new Vector();
    private transient PairedValues f = null;
    private transient PairedValues g = null;
    int _hindcastCondition = 3;
    double _initialStorage = 0.0;
    double _initialElevation = 0.0;
    int _seepageType = 0;
    double _constSeepage = Double.NEGATIVE_INFINITY;
    PairedValues _seepageValues = new PairedValues();
    int _evapType = 0;
    double[] _monthlyEvap = new double[]{Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY};
    boolean _usesEvap = false;
    boolean _usesSeepage = false;
    PairedValues _conicElevationArea = new PairedValues();
    boolean _useConicInterpolation = false;
    double _initialConicDepth = Double.NEGATIVE_INFINITY;
    double _firstStorageValue = 0.0;
    private transient double[] h;
    private transient boolean i = true;
    private transient doubleArrayContainer[] j;
    private transient doubleArrayContainer[] k;
    private transient double[] l;
    transient doubleArrayContainer a;
    private transient doubleArrayContainer m;
    transient doubleArrayContainer b;
    private transient doubleArrayContainer n;
    private transient doubleArrayContainer o;
    transient doubleArrayContainer c;
    private transient doubleArrayContainer p;
    private transient doubleArrayContainer q;
    private transient doubleArrayContainer r;
    private transient doubleArrayContainer s;
    private transient doubleArrayContainer t;
    private transient doubleArrayContainer u;
    private transient doubleArrayContainer[] v;
    private transient doubleArrayContainer w;
    private transient doubleArrayContainer x;
    private transient doubleArrayContainer y;
    transient doubleArrayContainer d;
    transient doubleArrayContainer e;
    public static final double DSDT_TO_Q_ENGLISH = 43560.0;
    public static final double DSDT_TO_Q_SI = 1.0;
    public static double DSDT_TO_Q = 43560.0;
    public static double AREA_CONV_ENGLISH = 43560.0;
    public static double AREA_CONV_SI = 10000.0;
    public static double AREA_CONV = AREA_CONV_ENGLISH;
    public static double EVAPLEN_CONV_ENGLISH = 12.0;
    public static double EVAPLEN_CONV_SI = 1000.0;
    public static double EVAPLEN_CONV = EVAPLEN_CONV_ENGLISH;

    public Storage() {
    }

    public Storage(Element element) {
        super(element);
    }

    @Override
    protected void initTSVals(int n) {
        if (n <= 0 || n >= this.b.array.length) {
            return;
        }
        if (!RMAConst.isValidValue((double)this.b.array[n])) {
            int n2 = n - 1;
            if (n > this.b.array.length - 1) {
                n = this.b.array.length - 1;
            }
            while (!RMAConst.isValidValue((double)this.b.array[n2]) && n2 >= 0) {
                --n2;
            }
            this.b.array[n] = this.b.array[n2];
            this.a.array[n] = this.a.array[n2];
            this.c.array[n] = this.c.array[n2];
        }
        if (!RMAConst.isValidValue((double)this.d.array[n])) {
            this.d.array[n] = this.b.array[n];
        }
        if (!RMAConst.isValidValue((double)this.e.array[n])) {
            this.e.array[n] = this.c.array[n];
        }
    }

    void updateElevEst(int n, double d) {
        if (n <= 0 || n >= this.b.array.length) {
            return;
        }
        this.d.array[n] = d >= 0.0 ? d * (this.b.array[n] - this.d.array[n]) + this.d.array[n] : -d;
        this.e.array[n] = this.c.array[n];
    }

    public double getPreviousElevationEst33(RunTimeStep runTimeStep) {
        return this.getBoundedArrayValue(runTimeStep.step - 1, this.d);
    }

    public double getElevationEst33(RunTimeStep runTimeStep) {
        return this.getBoundedArrayValue(runTimeStep.step, this.d);
    }

    public double getPreviousOutflowEst33(RunTimeStep runTimeStep) {
        return this.getBoundedArrayValue(runTimeStep.step - 1, this.e);
    }

    public double getOutflowEst33(RunTimeStep runTimeStep) {
        return this.getBoundedArrayValue(runTimeStep.step, this.e);
    }

    public double getEvapSeepVol(RunTimeStep runTimeStep) {
        double d;
        if (this.y == null || this.y.array == null) {
            return 0.0;
        }
        double d2 = this.y.array[runTimeStep.step];
        if (d2 == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        double d3 = this.calcEvapFlow(runTimeStep);
        double d4 = this.calcSeepageFlow(runTimeStep);
        double d5 = d = d3 + d4;
        double d6 = Storage.getFlowVolume(runTimeStep, d5, d5);
        return d6;
    }

    public double getElevationEst(RunTimeStep runTimeStep) {
        int n = runTimeStep.step;
        if (n > this.d.array.length - 1) {
            n = this.d.array.length - 1;
        }
        while (!RMAConst.isValidValue((double)this.d.array[n]) && n > 0) {
            --n;
        }
        return this.d.array[n];
    }

    public void setPumpVol(RunTimeStep runTimeStep, double d, double d2) {
        if (this.w != null) {
            this.w.array[runTimeStep.step] = d;
        }
        if (this.x != null) {
            this.x.array[runTimeStep.step] = d2;
        }
    }

    public double incrementPumpVolume(RunTimeStep runTimeStep, double d) {
        double d2;
        double d3 = this.a.array[runTimeStep.step] + d;
        if (d2 < 0.0) {
            d3 = 0.0;
        }
        d = d3 - this.a.array[runTimeStep.step];
        this.a.array[runTimeStep.step] = d3;
        this.b.array[runTimeStep.step] = this.storageToElevation(d3);
        if (this.w != null) {
            int n = runTimeStep.step;
            this.w.array[n] = this.w.array[n] + d;
        }
        return d;
    }

    public void incrementPumpVolumeCap(RunTimeStep runTimeStep, double d) {
        if (this.x != null) {
            int n = runTimeStep.step;
            this.x.array[n] = this.x.array[n] + d;
        }
    }

    @Override
    public boolean isNodeComputed(int n, RssNode rssNode, Integer n2) {
        return false;
    }

    @Override
    public void cleanupFromDeSerialization() {
        if (this._capacityValues == null) {
            return;
        }
        Storage storage = this;
        storage.copyIntoCapacityVector(storage._capacityValues);
    }

    @Override
    public void setupForSerialization() {
        String string;
        Object object;
        super.setupForSerialization();
        DSSPathname dSSPathname = new DSSPathname();
        RSimDssPathPartGenerator rSimDssPathPartGenerator = new RSimDssPathPartGenerator();
        Object object2 = this.getElement().getTopParent().getName();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add((String)object2);
        object2 = rSimDssPathPartGenerator.generatePathnamePart(arrayList, "");
        dSSPathname.setAPart((String)object2);
        if (this._seepageValues != null) {
            arrayList.clear();
            arrayList.add("Pool-Seepage");
            object2 = ((RssTSLocationObject)this).getSystem();
            object = object2 != null ? ((RssSystem)object2).generateUniquePathPart(arrayList, "-") : rSimDssPathPartGenerator.generatePathnamePart(arrayList, "-");
            dSSPathname.setBPart((String)object);
            object = Parameter.getParamString((int)Parameter.PARAMID_ELEV) + "-" + Parameter.getParamString((int)Parameter.PARAMID_FLOW);
            dSSPathname.setCPart((String)object);
            string = this.getElement().getSystem().getDssPairedDataFilePath();
            object = dSSPathname.getPathname();
            this._seepageValues.setDssIdentifer(new DSSIdentifier(string, (String)object));
            this._seepageValues.setParamXId(Parameter.PARAMID_ELEV);
            this._seepageValues.setParamYId(Parameter.PARAMID_FLOW);
            this._seepageValues.setUnitSystem(this.getUnitSystem());
            arrayList.clear();
            arrayList.add("Pool-Area Capacity-Conic");
            object = object2 != null ? ((RssSystem)object2).generateUniquePathPart(arrayList, "-") : rSimDssPathPartGenerator.generatePathnamePart(arrayList, "-");
            dSSPathname.setBPart((String)object);
            this._conicElevationArea.setDssIdentifer(new DSSIdentifier(string, dSSPathname.getPathname()));
            this._conicElevationArea.setUnitSystem(this.getUnitSystem());
            this._conicElevationArea.setParamXId(Parameter.PARAMID_ELEV);
            this._conicElevationArea.setParamYId(Parameter.PARAMID_AREARESERVOIR);
        }
        if (this._capacityVector != null) {
            this._capacityValues = new PairedValuesExt();
            Storage storage = this;
            storage.copyFromCapacityVectory(storage._capacityValues);
            arrayList.clear();
            arrayList.add("Pool-Area Capacity");
            object2 = ((RssTSLocationObject)this).getSystem();
            object = object2 != null ? ((RssSystem)object2).generateUniquePathPart(arrayList, "-") : rSimDssPathPartGenerator.generatePathnamePart(arrayList, "-");
            dSSPathname.setBPart((String)object);
            object = Parameter.getParamString((int)Parameter.PARAMID_ELEV) + "-" + Parameter.getParamString((int)Parameter.PARAMID_STOR) + "-" + Parameter.getParamString((int)Parameter.PARAMID_AREARESERVOIR);
            dSSPathname.setCPart((String)object);
            string = this.getElement().getSystem().getDssPairedDataFilePath();
            object = dSSPathname.getPathname();
            this._capacityValues.setDssIdentifier(new DSSIdentifier(string, (String)object));
            this._capacityValues.setParamXId(Parameter.PARAMID_ELEV);
            this._capacityValues.setParamYId(-1);
            this._capacityValues.setUnitSystem(this.getUnitSystem());
        }
    }

    @Override
    public void getHindcastDataList(Vector vector) {
        if (vector == null) {
            return;
        }
        String string = this.element.getSystem().getKeyStringForObject(this);
        HindcastData hindcastData = new HindcastData(string, 14, 1);
        vector.add(hindcastData);
        hindcastData = new HindcastData(string, 15, 2);
        vector.add(hindcastData);
    }

    public boolean computesEvaporation() {
        return this._usesEvap;
    }

    public void setComputesEvaporation(boolean bl) {
        this._usesEvap = bl;
    }

    public boolean computesSeepage() {
        return this._usesSeepage;
    }

    public void setComputesSeepage(boolean bl) {
        this._usesSeepage = bl;
    }

    public boolean useConicInterpolation() {
        return this._useConicInterpolation;
    }

    public void setUseConicInterpolation(boolean bl) {
        this._useConicInterpolation = bl;
    }

    public void setInitialConicDepth(ParamDouble paramDouble) {
        this.setInitialConicDepth(paramDouble.getValue());
    }

    public void setInitialConicDepth(double d) {
        this._initialConicDepth = d;
    }

    public void getInitialConicDepth(ParamDouble paramDouble) {
        paramDouble.setValue(this.getInitialConicDepth());
        paramDouble.setUnitSystem(this.getUnitSystem());
        paramDouble.setParameterId(Parameter.PARAMID_ELEV);
    }

    public double getInitialConicDepth() {
        return this._initialConicDepth;
    }

    public void setFirstStorageValue(ParamDouble paramDouble) {
        this.setFirstStorageValue(paramDouble.getValue());
    }

    public void setFirstStorageValue(double d) {
        this._firstStorageValue = d;
    }

    public void getFirstStorageValue(ParamDouble paramDouble) {
        paramDouble.setValue(this.getFirstStorageValue());
        paramDouble.setUnitSystem(this.getUnitSystem());
        paramDouble.setParameterId(Parameter.PARAMID_STOR);
    }

    public double getFirstStorageValue() {
        return this._firstStorageValue;
    }

    @Override
    public synchronized Object clone() {
        Storage storage = (Storage)super.clone();
        ((Storage)super.clone())._capacityVector = new Vector();
        for (int i = 0; i < this._capacityVector.size(); ++i) {
            CapacityRecord capacityRecord = (CapacityRecord)this._capacityVector.elementAt(i);
            if (capacityRecord == null) continue;
            capacityRecord = (CapacityRecord)capacityRecord.clone();
            storage._capacityVector.addElement(capacityRecord);
        }
        if (this.f != null) {
            storage.f = (PairedValues)this.f.clone();
        }
        if (this.g != null) {
            storage.g = (PairedValues)this.g.clone();
        }
        if (this._seepageValues != null) {
            storage._seepageValues = (PairedValues)this._seepageValues.clone();
        }
        if (this._conicElevationArea != null) {
            storage._conicElevationArea = (PairedValues)this._conicElevationArea.clone();
        }
        if (this._monthlyEvap != null) {
            storage._monthlyEvap = new double[this._monthlyEvap.length];
            System.arraycopy(this._monthlyEvap, 0, storage._monthlyEvap, 0, this._monthlyEvap.length);
        }
        return storage;
    }

    public boolean isInstantaneousInput() {
        return this.i;
    }

    @Override
    Vector getComputedNodes() {
        return null;
    }

    public void initElevStorAndElevAreaPV() {
        if (this._useConicInterpolation) {
            if (this._conicElevationArea != null) {
                this.fillWorkingPairedValuesFromConicStorage();
                return;
            }
        } else if (this._capacityVector != null) {
            this.convertCapacityVector();
        }
    }

    private void convertCapacityVector() {
        int n = this._capacityVector.size();
        this.f = new PairedValues();
        this.g = new PairedValues();
        this.g.setParamXId(Parameter.PARAMID_ELEV);
        this.g.setParamYId(Parameter.PARAMID_AREARESERVOIR);
        this.g.setUnitSystem(this.getUnitSystem());
        this.f.setParamXId(Parameter.PARAMID_ELEV);
        this.f.setParamYId(Parameter.PARAMID_STOR);
        this.f.setUnitSystem(this.getUnitSystem());
        for (int i = 0; i < n; ++i) {
            CapacityRecord capacityRecord = (CapacityRecord)this._capacityVector.elementAt(i);
            if (capacityRecord == null) continue;
            this.f.addPair(capacityRecord.elev, capacityRecord.stor);
            this.g.addPair(capacityRecord.elev, capacityRecord.area);
        }
    }

    private void fillWorkingPairedValuesFromConicStorage() {
        if (this._conicElevationArea == null) {
            return;
        }
        this.g = (PairedValues)this._conicElevationArea.clone();
        this.g.setParamXId(Parameter.PARAMID_ELEV);
        this.g.setParamYId(Parameter.PARAMID_AREARESERVOIR);
        this.g.setUnitSystem(this.getUnitSystem());
        double[] dArray = this.g.getXArray();
        double[] dArray2 = Storage.getConicStorageArray(this.g, this._firstStorageValue, this._initialConicDepth);
        if (dArray2 == null || dArray2.length != dArray.length) {
            return;
        }
        this.f = new PairedValues();
        this.f.setParamXId(Parameter.PARAMID_ELEV);
        this.f.setParamYId(Parameter.PARAMID_STOR);
        this.f.setUnitSystem(this.getUnitSystem());
        for (int i = 0; i < dArray2.length; ++i) {
            this.f.addPair(dArray[i], dArray2[i]);
        }
    }

    @Override
    public void applyHindcastData(HindcastData hindcastData) {
        if (hindcastData == null) {
            return;
        }
        if (hindcastData.getVariableId() == 14) {
            if (hindcastData.getType() == 1) {
                this._hindcastCondition = 2;
                this._initialElevation = hindcastData.getValue();
                return;
            }
            if (hindcastData.getType() == 0) {
                this._hindcastCondition = 3;
                return;
            }
            if (hindcastData.getType() == 3) {
                this._hindcastCondition = 4;
                return;
            }
            if (hindcastData.getType() == 5) {
                this._hindcastCondition = 5;
                this._initialElevation = hindcastData.getValue();
                return;
            }
            if (hindcastData.getType() == 6) {
                this._hindcastCondition = 6;
                return;
            }
            if (hindcastData.getType() == 7) {
                this._hindcastCondition = 9;
                return;
            }
        } else if (hindcastData.getVariableId() == 15) {
            if (hindcastData.getType() == 1) {
                this._hindcastCondition = 0;
                this._initialStorage = hindcastData.getValue();
                return;
            }
            if (hindcastData.getType() == 0) {
                this._hindcastCondition = 1;
                return;
            }
            if (hindcastData.getType() == 3) {
                this._hindcastCondition = 4;
                return;
            }
            if (hindcastData.getType() == 5) {
                this._hindcastCondition = 7;
                this._initialStorage = hindcastData.getValue();
                return;
            }
            if (hindcastData.getType() == 6) {
                this._hindcastCondition = 8;
                return;
            }
            if (hindcastData.getType() == 7) {
                this._hindcastCondition = 9;
            }
        }
    }

    @Override
    public Vector getActiveTSProxies(Vector vector, int n) {
        if (vector == null) {
            vector = new Vector<TSRecordProxy>();
        }
        if (n == 1) {
            if (this._hindcastCondition == 3 || this._hindcastCondition == 6) {
                vector.add(this.getTSRecordProxy(14));
            } else if (this._hindcastCondition == 1 || this._hindcastCondition == 8) {
                vector.add(this.getTSRecordProxy(15));
            }
            if (this._usesEvap && this._evapType == 1) {
                vector.add(this.getTSRecordProxy(18));
            }
        } else {
            vector.add(this.getTSRecordProxy(10));
            vector.add(this.getTSRecordProxy(23));
            vector.add(this.getTSRecordProxy(11));
            vector.add(this.getTSRecordProxy(20));
            vector.add(this.getTSRecordProxy(12));
            vector.add(this.getTSRecordProxy(13));
            vector.add(this.getTSRecordProxy(21));
            vector.add(this.getTSRecordProxy(24));
            vector.add(this.getTSRecordProxy(16));
            if (this._usesEvap) {
                vector.add(this.getTSRecordProxy(17));
            }
            if (this._usesSeepage) {
                vector.add(this.getTSRecordProxy(19));
            }
            vector.add(this.getTSRecordProxy(201));
            PowerPlant[] powerPlantArray = (PowerPlant[])this.element.getTopParent();
            powerPlantArray = powerPlantArray.getPowerPlants();
            if (powerPlantArray != null && powerPlantArray.length > 0) {
                vector.add(this.getTSRecordProxy(154));
            }
            vector.add(this.getTSRecordProxy(170));
            vector.add(this.getTSRecordProxy(175));
        }
        return vector;
    }

    @Override
    public void updateTSProxyList() {
        String string;
        if (this.getTSRecordProxy(10) == null) {
            this.addTSRecordProxy(10);
        }
        if (this.getTSRecordProxy(23) == null) {
            this.addTSRecordProxy(23);
        }
        if (this.getTSRecordProxy(11) == null) {
            this.addTSRecordProxy(11);
        }
        if (this.getTSRecordProxy(12) == null) {
            this.addTSRecordProxy(12);
        }
        if (this.getTSRecordProxy(13) == null) {
            this.addTSRecordProxy(13);
        }
        if (this.getTSRecordProxy(14) == null) {
            this.addTSRecordProxy(14);
        }
        if (this.getTSRecordProxy(15) == null) {
            this.addTSRecordProxy(15);
        }
        if (this.getTSRecordProxy(16) == null) {
            this.addTSRecordProxy(16);
        }
        if (this.getTSRecordProxy(17) == null) {
            this.addTSRecordProxy(17);
        }
        if (this.getTSRecordProxy(18) == null) {
            this.addTSRecordProxy(18);
        }
        if (this.getTSRecordProxy(19) == null) {
            this.addTSRecordProxy(19);
        }
        if (this.getTSRecordProxy(20) == null) {
            this.addTSRecordProxy(20);
        }
        if (this.getTSRecordProxy(21) == null) {
            this.addTSRecordProxy(21);
        }
        if (this.getTSRecordProxy(24) == null) {
            this.addTSRecordProxy(24);
        }
        if (this.getTSRecordProxy(201) == null) {
            this.addTSRecordProxy(201);
        }
        Object object = (ReservoirElement)this.element.getTopParent();
        PowerPlant[] powerPlantArray = ((ReservoirElement)object).getPowerPlants();
        VerticalDatumSettings verticalDatumSettings = ((ReservoirElement)object).getVerticalDatumSettings();
        VerticalDatumSettings verticalDatumSettings2 = new VerticalDatumSettings(verticalDatumSettings);
        try {
            string = Parameter.getParameter((int)Parameter.PARAMID_ELEV).getUnitsStringForSystem(this.getUnitSystem());
            verticalDatumSettings2.setUnits(string);
        }
        catch (DataSetIllegalArgumentException dataSetIllegalArgumentException) {
            Logger.getLogger(ReservoirElement.class.getName()).log(Level.SEVERE, null, dataSetIllegalArgumentException);
        }
        string = this.getTSRecordProxy(10);
        try {
            string.setVerticalDatumInfo(verticalDatumSettings2.toVerticalDatumXml());
        }
        catch (VerticalDatumException verticalDatumException) {
            object = "Error setting the following vertical datum information on Pool Elevation\nTime Series Proxy in Reservoir Element: " + object.getName() + "\n" + verticalDatumSettings.toVerticalDatumXml();
            Logger.getLogger(Storage.class.getName()).log(Level.WARNING, (String)object, verticalDatumException);
        }
        if (powerPlantArray != null && powerPlantArray.length > 0 && this.getTSRecordProxy(154) == null) {
            string = this.addTSRecordProxy(154);
        }
        if (this.getTSRecordProxy(170) == null) {
            string = this.addTSRecordProxy(170);
        }
        if (this.getTSRecordProxy(175) == null) {
            string = this.addTSRecordProxy(175);
        }
        if (string != null) {
            this.setModified(true);
        }
    }

    @Override
    public Vector getTSRecordProxies() {
        Vector<TSRecordProxy> vector = new Vector<TSRecordProxy>();
        for (int i = 0; i < this._tsrecordVector.size(); ++i) {
            TSRecordProxy tSRecordProxy = (TSRecordProxy)this._tsrecordVector.elementAt(i);
            if (tSRecordProxy == null || tSRecordProxy.isInput() && (tSRecordProxy.getParamName().equals(ReservoirElement.ELEVATION) && (this._hindcastCondition == 3 || this._hindcastCondition == 6) || tSRecordProxy.getParamName().equals(ReservoirElement.STORAGE) && this._hindcastCondition != 1 && this._hindcastCondition != 8)) continue;
            vector.addElement(tSRecordProxy);
        }
        return vector;
    }

    @Override
    public Vector getComputedTSRecordProxies(Vector vector) {
        TSRecordProxy tSRecordProxy;
        if (vector == null) {
            vector = new Vector<TSRecordProxy>();
        }
        if ((tSRecordProxy = this.getTSRecordProxy(10)) != null) {
            vector.add(tSRecordProxy);
        }
        if ((tSRecordProxy = this.getTSRecordProxy(23)) != null) {
            vector.add(tSRecordProxy);
        }
        if ((tSRecordProxy = this.getTSRecordProxy(11)) != null) {
            vector.add(tSRecordProxy);
        }
        if ((tSRecordProxy = this.getTSRecordProxy(12)) != null) {
            vector.add(tSRecordProxy);
        }
        if ((tSRecordProxy = this.getTSRecordProxy(13)) != null) {
            vector.add(tSRecordProxy);
        }
        if ((tSRecordProxy = this.getTSRecordProxy(17)) != null) {
            vector.add(tSRecordProxy);
        }
        if ((tSRecordProxy = this.getTSRecordProxy(19)) != null) {
            vector.add(tSRecordProxy);
        }
        if ((tSRecordProxy = this.getTSRecordProxy(20)) != null) {
            vector.add(tSRecordProxy);
        }
        if ((tSRecordProxy = this.getTSRecordProxy(21)) != null) {
            vector.add(tSRecordProxy);
        }
        if ((tSRecordProxy = this.getTSRecordProxy(24)) != null) {
            vector.add(tSRecordProxy);
        }
        if ((tSRecordProxy = this.getTSRecordProxy(201)) != null) {
            vector.add(tSRecordProxy);
        }
        return vector;
    }

    public double[] getElevationArray() {
        if (this.b == null) {
            this.b = this.getTSContainer(10);
        }
        return this.b.array;
    }

    public double getElevation(RunTimeStep runTimeStep) {
        if (this.b == null) {
            this.b = this.getTSContainer(10);
        }
        if (this.b == null) {
            return Double.NEGATIVE_INFINITY;
        }
        if (runTimeStep.step < 0 || runTimeStep.step >= this.b.array.length) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.b.array[runTimeStep.step];
    }

    public double getStorage(RunTimeStep runTimeStep) {
        if (this.a == null) {
            this.a = this.getTSContainer(11);
        }
        if (this.a == null) {
            return Double.NEGATIVE_INFINITY;
        }
        if (runTimeStep.step < 0 || runTimeStep.step >= this.a.array.length) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.a.array[runTimeStep.step];
    }

    public double getMaxStorage() {
        if (this.f == null || this.g == null) {
            this.initElevStorAndElevAreaPV();
        }
        if (this.f == null || this.f.size() <= 0) {
            return Double.NEGATIVE_INFINITY;
        }
        int n = this.f.size();
        double d = this.f.getYValue(n - 1);
        return d;
    }

    public double getMinStorage() {
        if (this.f == null || this.g == null) {
            this.initElevStorAndElevAreaPV();
        }
        if (this.f == null || this.f.size() <= 0) {
            return Double.NEGATIVE_INFINITY;
        }
        double d = this.f.getYValue(0);
        return d;
    }

    public double calcEvapFlow(RunTimeStep runTimeStep) {
        double d = this.getPreviousElevation(runTimeStep);
        double d2 = this.getElevation(runTimeStep);
        double d3 = this.calcEvapFlow(runTimeStep, d, d2, true);
        return d3;
    }

    public double calcEvapFlow(RunTimeStep runTimeStep, double d, double d2, boolean bl) {
        double d3;
        double d4;
        if (!this._usesEvap || !this.hasEvap()) {
            return 0.0;
        }
        if (RMAConst.isUndefinedValue((double)d) && RMAConst.isUndefinedValue((double)d2)) {
            return 0.0;
        }
        if (RMAConst.isUndefinedValue((double)d)) {
            d3 = d4 = this.elevationToArea(d2);
        } else if (RMAConst.isUndefinedValue((double)d2)) {
            d4 = d3 = this.elevationToArea(d);
        } else {
            d3 = this.elevationToArea(d);
            d4 = this.elevationToArea(d2);
        }
        double d5 = 0.5 * (d3 + d4) * AREA_CONV;
        double d6 = 0.0;
        if (this._evapType == 0) {
            d6 = d5 * this._monthlyEvap[runTimeStep.month() - 1] / (double)DAYS_PER_MONTH[runTimeStep.month() - 1] / 86400.0 / EVAPLEN_CONV;
        } else if (this.s != null) {
            d6 = d5 * this.s.array[runTimeStep.step] / (double)runTimeStep.getTimeStepSeconds();
        }
        if (bl && this.r != null) {
            this.r.array[runTimeStep.step] = d6;
        }
        return d6;
    }

    public boolean hasEvap() {
        if (!this._usesEvap) {
            return false;
        }
        if (this._evapType == 0) {
            int n;
            if (this._monthlyEvap == null || this._monthlyEvap.length != 12) {
                return false;
            }
            for (n = 0; n < 12; ++n) {
                if (this._monthlyEvap[n] != Double.NEGATIVE_INFINITY) continue;
                return false;
            }
            for (n = 0; n < 12; ++n) {
                if (this._monthlyEvap[n] == 0.0) continue;
                return true;
            }
            return false;
        }
        return this._evapType == 1;
    }

    public double[] getMonthlyEvap() {
        return this._monthlyEvap;
    }

    public boolean setMonthlyEvap(double[] dArray) {
        if (dArray == null || dArray.length != 12) {
            return false;
        }
        this._monthlyEvap = dArray;
        return true;
    }

    public int getEvapType() {
        return this._evapType;
    }

    public boolean setEvapType(int n) {
        if (n < -1 || n > 1) {
            return false;
        }
        this._evapType = n;
        return true;
    }

    public double[] getEvapArray() {
        if (this.r != null) {
            return this.r.array;
        }
        if (this.hasEvap()) {
            this.r = this.getTSContainer(17);
        }
        if (this.r == null) {
            return null;
        }
        return this.r.array;
    }

    public double[] getSeepArray() {
        if (this.t != null) {
            return this.t.array;
        }
        if (this.hasSeepage()) {
            this.t = this.getTSContainer(19);
        }
        if (this.t == null) {
            return null;
        }
        return this.t.array;
    }

    public double[] getSpillArray() {
        if (this.u != null) {
            return this.u.array;
        }
        this.u = this.getTSContainer(154);
        if (this.u == null) {
            return null;
        }
        return this.u.array;
    }

    public double calcSeepageFlow(RunTimeStep runTimeStep) {
        this.getPreviousElevation(runTimeStep);
        this.getElevation(runTimeStep);
        double d = this.calcSeepageFlow(runTimeStep, this.getPreviousElevation(runTimeStep), this.getElevation(runTimeStep), true);
        return d;
    }

    public double calcSeepageFlow(RunTimeStep runTimeStep, double d, double d2, boolean bl) {
        if (!this._usesSeepage || !this.hasSeepage()) {
            return 0.0;
        }
        double d3 = 0.0;
        if (this._seepageType == 0) {
            d3 = this._constSeepage;
        } else if (this._seepageType == 1) {
            d3 = this._seepageValues.interpolateValue(d);
            if (!RMAConst.isValidValue((double)d2)) {
                d3 = 0.5 * (d3 + this._seepageValues.interpolateValue(d2));
            }
        }
        if (bl && this.t != null) {
            this.t.array[runTimeStep.step] = d3;
        }
        return d3;
    }

    public boolean hasSeepage() {
        if (this._seepageType == 0) {
            return this._constSeepage != Double.NEGATIVE_INFINITY && this._constSeepage != 0.0;
        }
        if (this._seepageType == 1) {
            return this._seepageValues != null && this._seepageValues.size() > 0;
        }
        return false;
    }

    public void getConstSeepage(ParamDouble paramDouble) {
        paramDouble.setValue(this.getConstSeepage());
        paramDouble.setUnitSystem(this.getUnitSystem());
        paramDouble.setParameterId(Parameter.PARAMID_FLOW);
    }

    public void setConstSeepage(ParamDouble paramDouble) {
        this._constSeepage = paramDouble.getValue();
    }

    public double getConstSeepage() {
        return this._constSeepage;
    }

    public void setConstSeepage(double d) {
        this._constSeepage = d;
    }

    public PairedValues getSeepageValues() {
        this._seepageValues.setUnitSystem(this.getUnitSystem());
        this._seepageValues.setParamXId(Parameter.PARAMID_ELEV);
        this._seepageValues.setParamYId(Parameter.PARAMID_FLOW);
        return this._seepageValues;
    }

    public void setSeepageValues(PairedValues pairedValues) {
        this._seepageValues = pairedValues;
    }

    private double calcHoldoutFlow(RunTimeStep runTimeStep) {
        if (runTimeStep.step == 0) {
            this.m.array[runTimeStep.step] = 0.0;
            return 0.0;
        }
        double d = this.getPreviousStorage(runTimeStep);
        double d2 = this.getStorage(runTimeStep);
        if (!RMAConst.isValidValue((double)d) || !RMAConst.isValidValue((double)d2)) {
            this.m.array[runTimeStep.step] = 0.0;
            return 0.0;
        }
        double d3 = (d2 - d) / (double)runTimeStep.getTimeStepSeconds() * DSDT_TO_Q;
        if (this.r != null && RMAConst.isValidValue((double)this.r.array[runTimeStep.step])) {
            d3 += this.r.array[runTimeStep.step];
        }
        if (this.t != null && RMAConst.isValidValue((double)this.t.array[runTimeStep.step])) {
            d3 += this.t.array[runTimeStep.step];
        }
        if (this.m != null) {
            this.m.array[runTimeStep.step] = d3;
        }
        return d3;
    }

    public PairedValues getElevationStorageValues() {
        if (this.f == null || this.g == null) {
            this.initElevStorAndElevAreaPV();
        }
        return this.f;
    }

    public PairedValues getElevationAreaValues() {
        if (this.f == null || this.g == null) {
            this.initElevStorAndElevAreaPV();
        }
        this.g.setParamXId(Parameter.PARAMID_ELEV);
        this.g.setParamYId(Parameter.PARAMID_AREARESERVOIR);
        this.g.setUnitSystem(this.getUnitSystem());
        return this.g;
    }

    public void setCapacityValues(PairedValues pairedValues, PairedValues pairedValues2) {
        this.f = pairedValues;
        this.g = pairedValues2;
    }

    public int getSeepageType() {
        return this._seepageType;
    }

    public boolean setSeepageType(int n) {
        if (n < -1 || n > 1) {
            return false;
        }
        this._seepageType = n;
        return true;
    }

    public double getInitialStorage() {
        return this._initialStorage;
    }

    public void setInitialStorage(double d) {
        this._initialStorage = d;
    }

    public double getInitialElevation() {
        return this._initialElevation;
    }

    public void setInitialElevation(double d) {
        this._initialElevation = d;
    }

    public int getHindcastCondition() {
        return this._hindcastCondition;
    }

    public boolean setHindcastCondition(int n) {
        if (n < 0 || n > 9) {
            return false;
        }
        this._hindcastCondition = n;
        return true;
    }

    public double getPreviousStorage(RunTimeStep runTimeStep) {
        return this.getBoundedArrayValue(runTimeStep.step - 1, this.a);
    }

    public double getPreviousElevation(RunTimeStep runTimeStep) {
        return this.getBoundedArrayValue(runTimeStep.step - 1, this.b);
    }

    public double getInflowVolume(RunTimeStep runTimeStep) {
        if (this.n == null) {
            return 0.0;
        }
        return Storage.getFlowVolume(runTimeStep, this.n.array);
    }

    public double getNetInflowVolume(RunTimeStep runTimeStep) {
        if (this.o == null) {
            return 0.0;
        }
        return Storage.getFlowVolume(runTimeStep, this.o.array);
    }

    public double getOutflowVolume(RunTimeStep runTimeStep) {
        if (this.c == null) {
            return 0.0;
        }
        return Storage.getFlowVolume(runTimeStep, this.c.array);
    }

    private double getBoundedArrayValue(int n, doubleArrayContainer doubleArrayContainer2) {
        if (doubleArrayContainer2 == null || doubleArrayContainer2.array.length == 0) {
            return Double.NEGATIVE_INFINITY;
        }
        int n2 = n;
        if (n < 0) {
            n2 = 0;
        } else if (n >= doubleArrayContainer2.array.length) {
            n2 = doubleArrayContainer2.array.length - 1;
        }
        while (n2 >= 0) {
            if (RMAConst.isValidValue((double)doubleArrayContainer2.array[n2])) {
                return doubleArrayContainer2.array[n2];
            }
            --n2;
        }
        return Double.NEGATIVE_INFINITY;
    }

    public double getInflow(RunTimeStep runTimeStep) {
        return this.getBoundedArrayValue(runTimeStep.step, this.n);
    }

    public double getNetInflow(RunTimeStep runTimeStep) {
        return this.getBoundedArrayValue(runTimeStep.step, this.o);
    }

    public double getPreviousNetInflow(RunTimeStep runTimeStep) {
        return this.getBoundedArrayValue(runTimeStep.step - 1, this.o);
    }

    public double getPreviousOutflow(RunTimeStep runTimeStep) {
        return this.getBoundedArrayValue(runTimeStep.step - 1, this.c);
    }

    public double getOutflow(RunTimeStep runTimeStep) {
        return this.getBoundedArrayValue(runTimeStep.step, this.c);
    }

    public double getPumpbackFlow(RunTimeStep runTimeStep) {
        double d = 0.0;
        if (this.w != null && RMAConst.isValidValue((double)this.w.array[runTimeStep.step])) {
            double d2 = runTimeStep.getTimeStepSeconds();
            d = 0.0 + this.w.array[runTimeStep.step] / d2 * DSDT_TO_Q;
        }
        return d;
    }

    public double[] getNetInflowArray() {
        if (this.o == null) {
            this.o = this.getTSContainer(13);
        }
        if (this.o == null) {
            return null;
        }
        return this.o.array;
    }

    public double[] getOutflowArray() {
        if (this.c == null) {
            this.c = this.getTSContainer(21);
        }
        if (this.c == null) {
            return null;
        }
        return this.c.array;
    }

    public Vector getCapacityVector() {
        return (Vector)this._capacityVector.clone();
    }

    public void addCapacityRecord(CapacityRecord capacityRecord) {
        if (capacityRecord != null) {
            this._capacityVector.addElement(capacityRecord);
        }
        if (this.f != null) {
            this.f = null;
        }
        if (this.g != null) {
            this.g = null;
        }
    }

    public void emptyCapacityVector() {
        this._capacityVector.removeAllElements();
        if (this.f != null) {
            this.f = null;
        }
        if (this.g != null) {
            this.g = null;
        }
    }

    public void setConicElevationAreaValues(PairedValues pairedValues) {
        if (pairedValues != null) {
            this._conicElevationArea = (PairedValues)pairedValues.clone();
        }
    }

    public void clearConicElevationAreaValues() {
        this._conicElevationArea.clearValues();
    }

    public PairedValues getConicElevationAreaValues() {
        this._conicElevationArea.setUnitSystem(this.getUnitSystem());
        this._conicElevationArea.setParamXId(Parameter.PARAMID_ELEV);
        this._conicElevationArea.setParamYId(Parameter.PARAMID_AREARESERVOIR);
        PairedValues pairedValues = (PairedValues)this._conicElevationArea.clone();
        return pairedValues;
    }

    public double storageToElevation(double d) {
        double d2;
        if (this.f == null || this.g == null) {
            this.initElevStorAndElevAreaPV();
        }
        if (this._useConicInterpolation) {
            return this.conicStorageToElevation(d);
        }
        if (this.f == null || this.f.size() <= 0) {
            return Double.NEGATIVE_INFINITY;
        }
        int n = this.f.size();
        if (d <= this.f.getYValue(0) || n == 1) {
            return this.f.getXValue(0);
        }
        if (d > this.f.getYValue(n - 1)) {
            double d3 = this.f.getYValue(n - 2);
            double d4 = this.f.getXValue(n - 2);
            double d5 = this.f.getYValue(n - 1);
            double d6 = this.f.getXValue(n - 1);
            d2 = d4 + (d - d3) * (d6 - d4) / (d5 - d3);
        } else {
            d2 = this.f.getXValue(d);
        }
        return d2;
    }

    public double elevationToStorage(double d) {
        double d2;
        if (this.f == null || this.g == null) {
            this.initElevStorAndElevAreaPV();
        }
        if (this._useConicInterpolation) {
            return this.elevationToConicStorage(d);
        }
        if (this.f == null || this.f.size() <= 0) {
            return Double.NEGATIVE_INFINITY;
        }
        int n = this.f.size();
        if (d <= this.f.getXValue(0) || n == 1) {
            return this.f.getYValue(0);
        }
        if (d > this.f.getXValue(n - 1)) {
            double d3 = this.f.getYValue(n - 2);
            double d4 = this.f.getXValue(n - 2);
            double d5 = this.f.getYValue(n - 1);
            double d6 = this.f.getXValue(n - 1);
            d2 = d3 + (d - d4) * (d5 - d3) / (d6 - d4);
        } else {
            d2 = this.f.getYValue(d);
        }
        return d2;
    }

    public double elevationToArea(double d) {
        double d2;
        if (this.f == null || this.g == null) {
            this.initElevStorAndElevAreaPV();
        }
        if (this.f == null || this.f.size() <= 0) {
            return Double.NEGATIVE_INFINITY;
        }
        int n = this.g.size();
        if (d <= this.g.getXValue(0) || n == 1) {
            return this.g.getYValue(0);
        }
        if (d > this.g.getXValue(n - 1)) {
            double d3 = this.g.getYValue(n - 2);
            double d4 = this.g.getXValue(n - 2);
            double d5 = this.g.getYValue(n - 1);
            double d6 = this.g.getXValue(n - 1);
            d2 = d3 + (d - d4) * (d5 - d3) / (d6 - d4);
        } else {
            d2 = this.g.getYValue(d);
        }
        return d2;
    }

    public double getFlowForRateOfRise(double d, double d2, double d3) {
        if (d == Double.NEGATIVE_INFINITY || d2 == Double.NEGATIVE_INFINITY || d3 == Double.NEGATIVE_INFINITY) {
            return Double.NEGATIVE_INFINITY;
        }
        double d4 = this.elevationToStorage(d2);
        double d5 = d * d3 / 3600.0;
        d5 = -d5;
        double d6 = this.elevationToStorage(d2 + d5);
        DSDT_TO_Q = this.getUnitSystem() == 1 ? 43560.0 : 1.0;
        double d7 = (d6 - d4) * DSDT_TO_Q / d3;
        d7 = -d7;
        return d7;
    }

    @Override
    public boolean initialize() {
        ReservoirElement reservoirElement;
        PowerPlant[] powerPlantArray;
        int n;
        DSDT_TO_Q = this.getUnitSystem() == 1 ? 43560.0 : 1.0;
        AREA_CONV = this.getUnitSystem() == 1 ? AREA_CONV_ENGLISH : AREA_CONV_SI;
        EVAPLEN_CONV = this.getUnitSystem() == 1 ? EVAPLEN_CONV_ENGLISH : EVAPLEN_CONV_SI;
        this.j = null;
        this.k = null;
        this.l = null;
        this.a = null;
        this.m = null;
        this.b = null;
        this.d = null;
        this.n = null;
        this.o = null;
        this.c = null;
        this.e = null;
        this.r = null;
        this.s = null;
        this.t = null;
        this.y = null;
        this.u = null;
        this.v = null;
        this.w = null;
        this.x = null;
        if (!super.initialize()) {
            return false;
        }
        this.i = !this.element.getSystem().getRssRun().getAlternative().isPerAvgFlow();
        int n2 = 0;
        int n3 = 0;
        int n4 = this.element.getNodeCount();
        for (n = 0; n < n4; ++n) {
            RssNode rssNode = this.element.getNode(n);
            if (rssNode == null || !rssNode.isActive()) continue;
            if (this.element.getNodeDir(n) == 0) {
                ++n3;
                continue;
            }
            ++n2;
        }
        if (n2 <= 0) {
            this.printErrorMessage("initialize", "No inflow to this junction");
            return false;
        }
        if (n3 <= 0) {
            this.printErrorMessage("initialize", "No outflow from this junction");
            return false;
        }
        this.j = new doubleArrayContainer[n2];
        this.k = new doubleArrayContainer[n3];
        this.l = new double[n2];
        int n5 = 0;
        n2 = 0;
        for (n = 0; n < n4; ++n) {
            RssNode rssNode = this.element.getNode(n);
            if (rssNode == null || !rssNode.isActive()) continue;
            if (this.element.getNodeDir(n) == 0) {
                this.k[n2] = rssNode.getTSContainer(0);
                if (this.k[n2] == null) {
                    this.printErrorMessage("initialize", "Failed to get outflow TS array from node " + this.element.getSystem().getNameForKeyString(rssNode.getName()) + " (" + rssNode.getName() + ")");
                    return false;
                }
                ++n2;
                continue;
            }
            this.l[n5] = 1.0;
            this.j[n5] = rssNode.getTSContainer(4);
            if (this.j[n5] != null) {
                this.l[n5] = rssNode.getTSFactor(4);
            } else {
                this.j[n5] = rssNode.getTSContainer(0);
            }
            if (this.j[n5] == null) {
                this.printErrorMessage("initialize", "Failed to get inflow TS array from node " + rssNode.getName());
                return false;
            }
            ++n5;
        }
        if (this._hindcastCondition == 1 || this._hindcastCondition == 8) {
            this.p = this.getTSContainer(15);
            if (this.p == null) {
                this.printErrorMessage("initialize", "Failed to get lookback storage TS array");
                return false;
            }
        } else if (this._hindcastCondition == 3 || this._hindcastCondition == 6) {
            this.q = this.getTSContainer(14);
            if (this.q == null) {
                this.printErrorMessage("initialize", "Failed to get lookback elevation TS array");
                return false;
            }
        }
        this.a = this.getTSContainer(11);
        this.b = this.getTSContainer(10);
        this.d = this.getTSContainer(23);
        this.m = this.getTSContainer(16);
        this.n = this.getTSContainer(12);
        this.o = this.getTSContainer(13);
        this.c = this.getTSContainer(21);
        this.e = this.getTSContainer(24);
        this.y = this.getTSContainer(20);
        if (this.b == null || this.a == null || this.m == null || this.n == null || this.o == null || this.c == null) {
            return false;
        }
        if (this.hasEvap()) {
            this.r = this.getTSContainer(17);
            if (this._evapType == 1) {
                this.s = this.getTSContainer(18);
            }
        }
        if (this.hasSeepage()) {
            this.t = this.getTSContainer(19);
        }
        if ((powerPlantArray = (reservoirElement = (ReservoirElement)this.element.getTopParent()).getPowerPlants()) != null && powerPlantArray.length > 0) {
            this.u = this.getTSContainer(154);
            this.v = new doubleArrayContainer[powerPlantArray.length];
            for (n = 0; n < powerPlantArray.length; ++n) {
                this.v[n] = powerPlantArray[n].getAdjustableFlow().element.getNode(0).getTSContainer(0);
            }
        }
        this.w = this.getTSContainer(170);
        this.x = this.getTSContainer(175);
        return true;
    }

    public boolean initForecast(int n) {
        this.a = this.getTSContainer(11);
        this.b = this.getTSContainer(10);
        this.d = this.getTSContainer(23);
        this.m = this.getTSContainer(16);
        this.n = this.getTSContainer(12);
        this.o = this.getTSContainer(13);
        this.c = this.getTSContainer(21);
        this.e = this.getTSContainer(24);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int computeHindcastStep(RunTimeStep runTimeStep) {
        double d;
        double d2;
        double d3;
        block19: {
            double[] dArray;
            int n;
            int n2 = this.getHindcastCondition();
            if (runTimeStep.step > 0 && (n2 == 5 || n2 == 6 || n2 == 7 || n2 == 8 || n2 == 9)) {
                return ((Function)this).computeForecastStep(runTimeStep);
            }
            d3 = 0.0;
            d2 = 0.0;
            RssNode rssNode = this.element.getNode(0);
            if (rssNode == null) {
                return 1;
            }
            if (runTimeStep.step > 0) {
                int cfr_ignored_0 = runTimeStep.step;
            }
            int n3 = this.j.length;
            for (n = 0; n < n3; ++n) {
                dArray = this.j[n].array;
                if (this.j[n].array == null) continue;
                d3 += dArray[runTimeStep.step];
            }
            n3 = this.k.length;
            for (n = 0; n < n3; ++n) {
                dArray = this.k[n].array;
                if (this.k[n].array == null) continue;
                d2 += dArray[runTimeStep.step];
            }
            if (n2 == 1 || n2 == 8) {
                if (this.p != null && runTimeStep.step < this.p.array.length && RMAConst.isValidValue((double)this.p.array[runTimeStep.step])) {
                    this.a.array[runTimeStep.step] = Math.max(this.p.array[runTimeStep.step], this.getMinStorage());
                    Storage storage = this;
                    this.b.array[runTimeStep.step] = storage.storageToElevation(storage.a.array[runTimeStep.step]);
                    break block19;
                } else {
                    this.printErrorMessage("getHindcastEquation", "known storage TS empty or invalid");
                    this.element.getSystem().printErrorMessage("Date and Time: " + runTimeStep.dateTimeString());
                    return 1;
                }
            }
            if (n2 == 3 || n2 == 6) {
                if (this.q != null && runTimeStep.step < this.q.array.length && RMAConst.isValidValue((double)this.q.array[runTimeStep.step])) {
                    this.b.array[runTimeStep.step] = Math.max(this.q.array[runTimeStep.step], this.getMinElevation());
                    Storage storage = this;
                    this.a.array[runTimeStep.step] = storage.elevationToStorage(storage.q.array[runTimeStep.step]);
                    break block19;
                } else {
                    this.printErrorMessage("getHindcastEquation", "known elevation TS empty or invalid");
                    this.element.getSystem().printMessage("Date and Time: " + runTimeStep.dateTimeString());
                    return 1;
                }
            }
            if (n2 == 2 || n2 == 5) {
                this.b.array[runTimeStep.step] = Math.max(this.getInitialElevation(), this.getMinElevation());
                Storage storage = this;
                this.a.array[runTimeStep.step] = storage.elevationToStorage(storage.b.array[runTimeStep.step]);
            } else if (n2 == 0 || n2 == 7) {
                this.a.array[runTimeStep.step] = Math.max(this.getInitialStorage(), this.getMinStorage());
                Storage storage = this;
                this.b.array[runTimeStep.step] = storage.storageToElevation(storage.a.array[runTimeStep.step]);
            } else {
                if (n2 != 4 && n2 != 9) {
                    this.element.getSystem().printMessage("Storage.getHindcastEquation: unknown hindcastEquation " + n2);
                    this.element.getSystem().printMessage("Date and Time: " + runTimeStep.dateTimeString());
                    return 1;
                }
                ReservoirElement reservoirElement = (ReservoirElement)this.element.getTopParent();
                ReservoirOp reservoirOp = reservoirElement.getReservoirOp();
                d = reservoirOp.getActiveOpSet().getGuideCurveZone().getElevation(runTimeStep);
                this.b.array[runTimeStep.step] = Math.max(d, this.getMinElevation());
                Storage storage = this;
                this.a.array[runTimeStep.step] = storage.elevationToStorage(storage.b.array[runTimeStep.step]);
            }
        }
        double d4 = this.calcEvapFlow(runTimeStep);
        d = this.calcSeepageFlow(runTimeStep);
        this.n.array[runTimeStep.step] = d3;
        this.o.array[runTimeStep.step] = d3 - d4 - d;
        this.c.array[runTimeStep.step] = d2;
        if (this.m != null) {
            this.calcHoldoutFlow(runTimeStep);
        }
        if (this.d != null) {
            this.d.array[runTimeStep.step] = this.b.array[runTimeStep.step];
        }
        if (this.e != null) {
            this.e.array[runTimeStep.step] = this.c.array[runTimeStep.step];
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double getHindcastStorage(RunTimeStep runTimeStep) {
        double d;
        int n = this.getHindcastCondition();
        if (n == 1) {
            if (this.p == null) return Double.NEGATIVE_INFINITY;
            if (!RMAConst.isValidValue((double)this.p.array[runTimeStep.step])) return Double.NEGATIVE_INFINITY;
            d = this.p.array[runTimeStep.step];
            this.storageToElevation(d);
            return d;
        } else {
            if (n == 3) {
                if (this.q == null) return Double.NEGATIVE_INFINITY;
                if (!RMAConst.isValidValue((double)this.q.array[runTimeStep.step])) return Double.NEGATIVE_INFINITY;
                double d2 = this.q.array[runTimeStep.step];
                return this.elevationToStorage(d2);
            }
            if (n == 2) {
                double d3 = this.getInitialElevation();
                return this.elevationToStorage(d3);
            }
            if (n != 0) return Double.NEGATIVE_INFINITY;
            d = this.getInitialStorage();
            this.storageToElevation(d);
        }
        return d;
    }

    public boolean computeInflow(RunTimeStep runTimeStep) {
        int n;
        double d = 0.0;
        if (runTimeStep.step > 0) {
            int cfr_ignored_0 = runTimeStep.step;
        }
        int n2 = this.j.length;
        for (n = 0; n < n2; ++n) {
            double[] dArray = this.j[n].array;
            if (this.j[n].array == null) continue;
            d += dArray[runTimeStep.step];
        }
        double d2 = this.calcEvapFlow(runTimeStep);
        double d3 = this.calcSeepageFlow(runTimeStep);
        double d4 = d - d2 - d3;
        n = runTimeStep.getTimeStepSeconds();
        if (this.w != null && RMAConst.isValidValue((double)this.w.array[runTimeStep.step])) {
            d4 += this.w.array[runTimeStep.step] / (double)n * DSDT_TO_Q;
        }
        this.n.array[runTimeStep.step] = d;
        this.o.array[runTimeStep.step] = d4;
        return true;
    }

    @Override
    public int computeForecastStep(RunTimeStep runTimeStep) {
        double d;
        double[] dArray;
        int n;
        double d2 = 0.0;
        double d3 = 0.0;
        int n2 = runTimeStep.step > 0 ? runTimeStep.step - 1 : 0;
        int n3 = this.j.length;
        for (n = 0; n < n3; ++n) {
            dArray = this.j[n].array;
            if (this.j[n].array == null) continue;
            d2 += dArray[runTimeStep.step];
        }
        n3 = this.k.length;
        for (n = 0; n < n3; ++n) {
            dArray = this.k[n].array;
            if (this.k[n].array == null) continue;
            d3 += dArray[runTimeStep.step];
        }
        if (this.a == null) {
            return 1;
        }
        if (this.m == null) {
            return 1;
        }
        if (this.b == null) {
            return 1;
        }
        double d4 = runTimeStep.getTimeStepSeconds();
        double d5 = this.calcEvapFlow(runTimeStep);
        double d6 = this.calcSeepageFlow(runTimeStep);
        if (this.i) {
            d = this.n.array[n2];
            if (this.t != null && RMAConst.isValidValue((double)this.t.array[n2])) {
                d -= this.t.array[n2];
            }
            if (this.r != null && RMAConst.isValidValue((double)this.r.array[n2])) {
                d -= this.r.array[n2];
            }
            this.a.array[runTimeStep.step] = this.a.array[n2] + (d2 - d3 - d5 - d6 + (d - this.c.array[n2])) / 2.0 * d4 / DSDT_TO_Q;
        } else {
            this.a.array[runTimeStep.step] = this.a.array[n2] + (d2 - d3 - d5 - d6) * d4 / DSDT_TO_Q;
        }
        if (this.a.array[runTimeStep.step] < 0.0) {
            this.a.array[runTimeStep.step] = 0.0;
        }
        Storage storage = this;
        this.b.array[runTimeStep.step] = storage.storageToElevation(storage.a.array[runTimeStep.step]);
        Storage storage2 = this;
        this.y.array[runTimeStep.step] = storage2.elevationToArea(storage2.b.array[runTimeStep.step]);
        d = d2 - d5 - d6;
        if (this.w != null && RMAConst.isValidValue((double)this.w.array[runTimeStep.step])) {
            d += this.w.array[runTimeStep.step] / d4 * DSDT_TO_Q;
        }
        this.n.array[runTimeStep.step] = d2;
        this.o.array[runTimeStep.step] = d;
        this.c.array[runTimeStep.step] = d3;
        if (this.m != null) {
            this.calcHoldoutFlow(runTimeStep);
        }
        if (this.u != null) {
            this.calcSpillFlow(runTimeStep);
        }
        return 0;
    }

    @Override
    public double computeSubStepFlow(RunTimeStep runTimeStep, double d, double d2) {
        double d3 = d2;
        double d4 = d2;
        double d5 = this.calcEvapFlow(runTimeStep, d3, d3, false) + this.calcSeepageFlow(runTimeStep, d4, d4, false);
        return d5;
    }

    private void calcSpillFlow(RunTimeStep runTimeStep) {
        if (this.u == null || this.v == null) {
            return;
        }
        this.u.array[runTimeStep.step] = this.c.array[runTimeStep.step];
        if (!RMAConst.isValidValue((double)this.u.array[runTimeStep.step])) {
            return;
        }
        for (int i = 0; i < this.v.length; ++i) {
            if (!RMAConst.isValidValue((double)this.v[i].array[runTimeStep.step])) continue;
            int n = runTimeStep.step;
            this.u.array[n] = this.u.array[n] - this.v[i].array[runTimeStep.step];
            if (!(this.u.array[runTimeStep.step] < 0.0)) continue;
            this.u.array[runTimeStep.step] = 0.0;
        }
    }

    public double getMaxElevation() {
        if (this.f == null || this.g == null) {
            this.initElevStorAndElevAreaPV();
        }
        if (this.f == null || this.f.size() <= 0) {
            return 0.0;
        }
        int n = this.f.size();
        double d = this.f.getXValue(n - 1);
        if (d == Double.NEGATIVE_INFINITY) {
            d = 0.0;
        }
        return d;
    }

    public double getMinElevation() {
        if (this.f == null || this.g == null) {
            this.initElevStorAndElevAreaPV();
        }
        if (this.f == null || this.f.size() <= 0) {
            return -1.0;
        }
        double d = this.f.getXValue(0);
        if (d == Double.NEGATIVE_INFINITY) {
            d = -1.0;
        }
        return d;
    }

    private double elevationToConicStorage(double d) {
        int n;
        if (this.g == null || this.g.size() <= 0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this.h == null || this.h.length != this.g.size()) {
            this.h = Storage.getConicStorageArray(this.g, this._firstStorageValue, this._initialConicDepth);
            if (this.h == null) {
                return Double.NEGATIVE_INFINITY;
            }
        }
        double[] dArray = this.g.getXArray();
        double[] dArray2 = this.g.getYArray();
        if (dArray == null || dArray.length < 2 || dArray2 == null || dArray2.length < 2) {
            return Double.NEGATIVE_INFINITY;
        }
        if (d <= dArray[0]) {
            return this.h[0];
        }
        double d2 = this._initialConicDepth;
        if (d2 == Double.NEGATIVE_INFINITY) {
            d2 = 0.0;
        }
        if (d2 == 0.0 && dArray2[0] > 0.0) {
            double cfr_ignored_0 = (dArray[1] - dArray[0]) / (Math.sqrt(dArray2[1] / dArray2[0]) - 1.0);
        }
        if ((n = this.g.findInterval(d)) >= dArray.length - 1) {
            n = dArray.length - 2;
        }
        double d3 = dArray[n + 1] - dArray[n];
        if (n != 0) {
            double cfr_ignored_1 = d3 / (Math.sqrt(dArray2[n + 1] / dArray2[n]) - 1.0);
        }
        double d4 = 1.0;
        if (this.getUnitSystem() == 2) {
            d4 = 10000.0;
        }
        d3 = (d - dArray[n]) / (dArray[n + 1] - dArray[n]);
        double d5 = Math.sqrt(dArray2[n] * dArray2[n + 1]);
        double d6 = dArray2[n] + 2.0 * (d5 - dArray2[n]) * d3 + (dArray2[n] + dArray2[n + 1] - d5 * 2.0) * d3 * d3;
        double d7 = (d - dArray[n]) / 3.0 * d4 * (dArray2[n] + d6 + Math.sqrt(dArray2[n] * d6)) + this.h[n];
        return d7;
    }

    private double conicStorageToElevation(double d) {
        int n;
        if (this.g == null || this.g.size() < 2 || this._firstStorageValue == Double.NEGATIVE_INFINITY || !this.g.canInterpX() || !this.g.canInterpY()) {
            return Double.NEGATIVE_INFINITY;
        }
        double[] dArray = this.g.getXArray();
        double[] dArray2 = this.g.getYArray();
        if (dArray == null || dArray.length < 2 || dArray2 == null || dArray2.length < 2) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this.h == null || this.h.length != this.g.size()) {
            this.h = Storage.getConicStorageArray(this.g, this._firstStorageValue, this._initialConicDepth);
            if (this.h == null) {
                return Double.NEGATIVE_INFINITY;
            }
        }
        if (d <= this.h[0]) {
            return dArray[0];
        }
        double d2 = this._initialConicDepth;
        if (d2 == Double.NEGATIVE_INFINITY) {
            d2 = 0.0;
        }
        if (d2 == 0.0 && dArray2[0] > 0.0) {
            double cfr_ignored_0 = (dArray[1] - dArray[0]) / (Math.sqrt(dArray2[1] / dArray2[0]) - 1.0);
        }
        if (this.h == null || this.h.length != this.g.size()) {
            this.h = Storage.getConicStorageArray(this.g, this._firstStorageValue, this._initialConicDepth);
            if (this.h == null) {
                return Double.NEGATIVE_INFINITY;
            }
        }
        if ((n = Interpolate.bisearch((double[])this.h, (double)d, (int)this.h.length)) >= this.h.length - 1) {
            n = this.h.length - 2;
        }
        double d3 = dArray[n + 1] - dArray[n];
        if (n != 0) {
            double cfr_ignored_1 = d3 / (Math.sqrt(dArray2[n + 1] / dArray2[n]) - 1.0);
        }
        double d4 = 1.0;
        if (this.getUnitSystem() == 2) {
            d4 = 10000.0;
        }
        double d5 = Math.sqrt(4.0 * dArray2[n] * d4 / Math.PI);
        double d6 = Math.sqrt(4.0 * dArray2[n + 1] * d4 / Math.PI);
        double d7 = (d - this.h[n]) * 12.0 / Math.PI * Math.pow(d3 / (d6 - d5), 2.0) + Math.pow(d3 * d5 / (d6 - d5), 3.0);
        d7 = Math.pow(d7, 0.3333333333) - d3 * d5 / (d6 - d5) + dArray[n];
        return d7;
    }

    public static double getConicStorageForElevation(double d, PairedValues pairedValues, double[] dArray, double d2, double d3) {
        if (pairedValues == null || pairedValues.size() < 2 || d2 == Double.NEGATIVE_INFINITY || !pairedValues.canInterpX() || !pairedValues.canInterpY()) {
            return Double.NEGATIVE_INFINITY;
        }
        double[] dArray2 = pairedValues.getXArray();
        double[] dArray3 = pairedValues.getYArray();
        if (d3 == Double.NEGATIVE_INFINITY) {
            d3 = 0.0;
        }
        if (d3 == 0.0 && dArray3[0] > 0.0) {
            double cfr_ignored_0 = (dArray2[1] - dArray2[0]) / (Math.sqrt(dArray3[1] / dArray3[0]) - 1.0);
        }
        if (dArray == null) {
            return Double.NEGATIVE_INFINITY;
        }
        int n = pairedValues.findInterval(d);
        if (n >= dArray2.length - 1) {
            n = dArray2.length - 2;
        }
        double d4 = dArray2[n + 1] - dArray2[n];
        if (n != 0) {
            double cfr_ignored_1 = d4 / (Math.sqrt(dArray3[n + 1] / dArray3[n]) - 1.0);
        }
        double d5 = 1.0;
        if (pairedValues.getUnitSystem() == 2) {
            d5 = 10000.0;
        }
        d4 = (d - dArray2[n]) / (dArray2[n + 1] - dArray2[n]);
        double d6 = Math.sqrt(dArray3[n] * dArray3[n + 1]);
        double d7 = dArray3[n] + 2.0 * (d6 - dArray3[n]) * d4 + (dArray3[n] + dArray3[n + 1] - d6 * 2.0) * d4 * d4;
        double d8 = (d - dArray2[n]) / 3.0 * d5 * (dArray3[n] + d7 + Math.sqrt(dArray3[n] * d7)) + dArray[n];
        return d8;
    }

    public static double getConicStorageForElevation(double d, PairedValues pairedValues, double d2, double d3) {
        double[] dArray = Storage.getConicStorageArray(pairedValues, d2, d3);
        return Storage.getConicStorageForElevation(d, pairedValues, dArray, d2, d3);
    }

    public static double[] getConicStorageArray(PairedValues object, double d, double d2) {
        if (object == null || object.size() < 2 || d == Double.NEGATIVE_INFINITY || !object.canInterpX() || !object.canInterpY()) {
            return null;
        }
        double[] dArray = object.getXArray();
        double[] dArray2 = object.getYArray();
        double d3 = 1.0;
        if (object.getUnitSystem() == 2) {
            d3 = 10000.0;
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            d2 = 0.0;
        }
        if (d2 == 0.0 && dArray2[0] > 0.0) {
            double cfr_ignored_0 = (dArray[1] - dArray[0]) / (Math.sqrt(dArray2[1] / dArray2[0]) - 1.0);
        }
        double[] dArray3 = new double[dArray.length];
        object = dArray3;
        dArray3[0] = d;
        for (int i = 1; i < dArray.length; ++i) {
            double d4 = dArray[i] - dArray[i - 1];
            object[i] = (PairedValues)(d4 / 3.0 * d3 * (dArray2[i - 1] + dArray2[i] + Math.sqrt(dArray2[i - 1] * dArray2[i])) + object[i - 1]);
        }
        return object;
    }

    public double calcInitialConicDepth() {
        double d = this._initialConicDepth;
        if (d == Double.NEGATIVE_INFINITY) {
            d = 0.0;
        }
        double d2 = this.f.getYValue(0);
        double[] dArray = this.g.getYArray();
        double d3 = 1.0;
        if (this.g.getUnitSystem() == 2) {
            d3 = 10000.0;
        }
        if (d2 > 0.0) {
            double d4;
            double d5 = d2 * 3.0 / (d3 * dArray[0]);
            if (d > d5) {
                d = d5;
            }
            if (d < (d4 = d2 / (d3 * dArray[0]))) {
                d = d4;
            }
        } else {
            d = 0.0;
        }
        return d;
    }

    public double calcConicBottomArea() {
        double d;
        double d2 = this.calcInitialConicDepth();
        double d3 = this.f.getYValue(0);
        double[] dArray = this.g.getYArray();
        double d4 = 1.0;
        if (this.g.getUnitSystem() == 2) {
            d4 = 10000.0;
        }
        if (d3 > 0.0) {
            double d5 = d3 * 3.0 / (d4 * dArray[0]);
            double d6 = d3 / (d4 * dArray[0]);
            if (d2 >= d5) {
                d = 0.0;
            } else if (d2 <= d6) {
                d = dArray[0];
            } else {
                double d7 = d3 * 3.0 / d2 / d4;
                d = 0.5 * (-dArray[0] + d7 * 2.0 - Math.sqrt(dArray[0] * (d7 * 4.0 - 3.0 * dArray[0])));
            }
        } else {
            d = 0.0;
        }
        return d;
    }

    private void copyIntoCapacityVector(PairedValuesExt object) {
        if (this._capacityVector == null) {
            this._capacityVector = new Vector();
        } else {
            this._capacityVector.clear();
        }
        if (object == null) {
            return;
        }
        int n = object.size();
        double[] dArray = object.getXArray();
        object = object.getYData();
        for (int i = 0; i < n; ++i) {
            CapacityRecord capacityRecord = new CapacityRecord();
            new CapacityRecord().elev = dArray[i];
            capacityRecord.stor = (double)object[0][i];
            capacityRecord.area = (double)object[1][i];
            this._capacityVector.add(capacityRecord);
        }
    }

    private void copyFromCapacityVectory(PairedValuesExt pairedValuesExt) {
        pairedValuesExt.clearValues();
        for (int i = 0; i < this._capacityVector.size(); ++i) {
            Object object = (CapacityRecord)this._capacityVector.get(i);
            double d = ((CapacityRecord)object).elev;
            object = new double[]{((CapacityRecord)object).stor, ((CapacityRecord)object).area};
            pairedValuesExt.addPair(d, (double[])object);
        }
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, org.jdom.Element element) {
        org.jdom.Element element2;
        alternativeInputReport = new org.jdom.Element("Pool_Elevation");
        element.addContent((Content)alternativeInputReport);
        XMLUtilities.createArrayElements((org.jdom.Element)alternativeInputReport, (double[])this.getElevationStorageValues().getXArray());
        element.setAttribute("Use_Conic_Interpolation", Boolean.toString(this._useConicInterpolation));
        if (this._useConicInterpolation) {
            element.setAttribute("Initial_Conic_Depth", Double.toString(this.getInitialConicDepth()));
            alternativeInputReport = new org.jdom.Element("Conic_Area");
            element.addContent((Content)alternativeInputReport);
            XMLUtilities.createArrayElements((org.jdom.Element)alternativeInputReport, (double[])this.getConicElevationAreaValues().getXArray());
        } else {
            alternativeInputReport = new org.jdom.Element("Storage");
            element.addContent((Content)alternativeInputReport);
            XMLUtilities.createArrayElements((org.jdom.Element)alternativeInputReport, (double[])this._capacityValues.getXArray());
            alternativeInputReport = new org.jdom.Element("Area");
            element.addContent((Content)alternativeInputReport);
            XMLUtilities.createArrayElements((org.jdom.Element)alternativeInputReport, (double[])this._capacityValues.getYArray());
        }
        element.setAttribute("Has_Seepage", Boolean.toString(this._usesSeepage));
        if (this._usesSeepage) {
            alternativeInputReport = new org.jdom.Element("Seepage");
            element.addContent((Content)alternativeInputReport);
            alternativeInputReport.setAttribute("Seepage_Type", Integer.toString(this._seepageType));
            if (this._seepageType == 0) {
                alternativeInputReport.setAttribute("Contant_Seepage", Double.toString(this._constSeepage));
            } else {
                element2 = new org.jdom.Element("Seepage_Elev");
                alternativeInputReport.addContent((Content)element2);
                XMLUtilities.createArrayElements((org.jdom.Element)element2, (double[])this._seepageValues.getYArray());
                element2 = new org.jdom.Element("Seepage_Seepage");
                alternativeInputReport.addContent((Content)element2);
                XMLUtilities.createArrayElements((org.jdom.Element)element2, (double[])this._seepageValues.getXArray());
            }
        }
        element.setAttribute("Has_Evap", Boolean.toString(this._usesEvap));
        if (this._usesEvap) {
            element.setAttribute("Evap_Type", "Monthly");
            alternativeInputReport = new org.jdom.Element("Evaperation");
            element.addContent((Content)alternativeInputReport);
            alternativeInputReport.setAttribute("Seepage_Type", Integer.toString(this._evapType));
            if (this._evapType == 0) {
                element2 = new org.jdom.Element("Monthly_Evaps");
                alternativeInputReport.addContent((Content)element2);
                XMLUtilities.createArrayElements((org.jdom.Element)element2, (double[])this._monthlyEvap);
                return;
            }
        } else {
            element.setAttribute("Evap_Type", "Time Series");
        }
    }

    public void updateSystemState(RunTimeStep runTimeStep, int n) {
        for (int i = 0; i < n; ++i) {
            Storage storage = this;
            this.b.array[runTimeStep.step + i] = storage.storageToElevation(storage.a.array[runTimeStep.step + i]);
            Storage storage2 = this;
            this.y.array[runTimeStep.step + i] = storage2.elevationToArea(storage2.b.array[runTimeStep.step + i]);
        }
    }

    public double getElevationBounded(RunTimeStep runTimeStep) {
        return this.getBoundedArrayValue(runTimeStep.step, this.b);
    }
}

