/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.model.PairedValues;
import hec.rss.model.Storage;
import java.util.Hashtable;
import java.util.Vector;
import rma.swing.table.RmaTableModel;
import rma.swing.table.RmaTableModelInterface;
import rma.util.RMAIO;

public class StorageTableModel
extends RmaTableModel
implements RmaTableModelInterface {
    Hashtable _editableCells = new Hashtable();
    StringBuffer stChkCell = new StringBuffer();
    boolean _useConicInterpolation = false;

    public StorageTableModel() {
    }

    public StorageTableModel(String[] stringArray, Storage storage, boolean[] blArray) {
        this(stringArray, storage, blArray, false);
    }

    public StorageTableModel(String[] stringArray, Storage storage, boolean[] object, boolean bl) {
        super(stringArray, new Object[0][0], object);
        PairedValues pairedValues;
        this._useConicInterpolation = bl;
        this.setUnitSystem(storage.getUnitSystem());
        object = null;
        double d = Double.NEGATIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        if (this._useConicInterpolation) {
            pairedValues = storage.getConicElevationAreaValues();
            d = storage.getInitialConicDepth();
            d2 = storage.getFirstStorageValue();
        } else {
            object = storage.getElevationStorageValues();
            pairedValues = storage.getElevationAreaValues();
        }
        int n = pairedValues.getParametersIds()[0];
        int n2 = pairedValues.getParametersIds()[1];
        int n3 = Parameter.PARAMID_STOR;
        this.setColumnParameters(new int[]{n, n3, n2});
        double[] dArray = null;
        double[] dArray2 = null;
        double[] dArray3 = null;
        if (object != null) {
            dArray = object.getXArray();
            dArray2 = object.getYArray();
        }
        if (pairedValues != null) {
            dArray3 = pairedValues.getYArray();
            if (this._useConicInterpolation) {
                dArray = pairedValues.getXArray();
            }
        }
        if (dArray == null || dArray2 == null && dArray3 == null) {
            Vector<String> vector = new Vector<String>(stringArray.length);
            object = vector;
            vector.addElement("");
            this.addRow((Vector)object);
            for (int i = 1; i < 10; ++i) {
                this.addRow(new Vector(stringArray.length));
            }
            return;
        }
        int n4 = dArray.length;
        for (int i = 0; i < n4; ++i) {
            Vector<Object> vector = new Vector<Object>(3);
            if (dArray[i] == Double.NEGATIVE_INFINITY) continue;
            vector.add(new ParamDouble(dArray[i], this.getColumnParameter(0), storage.getUnitSystem(), 2));
            if (this._useConicInterpolation) {
                if (i == 0) {
                    vector.add(new ParamDouble(d2, this.getColumnParameter(1), storage.getUnitSystem(), 2));
                } else if (dArray3[i] != Double.NEGATIVE_INFINITY) {
                    double d3 = Storage.getConicStorageForElevation(dArray[i], pairedValues, d2, d);
                    vector.add(new ParamDouble(d3, this.getColumnParameter(1), storage.getUnitSystem(), 2));
                } else {
                    vector.add("");
                }
            } else if (dArray2[i] != Double.NEGATIVE_INFINITY) {
                vector.add(new ParamDouble(dArray2[i], this.getColumnParameter(1), storage.getUnitSystem(), 2));
            } else {
                vector.add("");
            }
            if (dArray3 != null) {
                if (i < dArray3.length && dArray3[i] != Double.NEGATIVE_INFINITY) {
                    vector.add(new ParamDouble(dArray3[i], this.getColumnParameter(2), storage.getUnitSystem(), 2));
                } else {
                    vector.add("");
                }
            }
            this.addRow(vector);
        }
        if (n4 == 0) {
            Vector<String> vector = new Vector<String>(stringArray.length);
            vector.addElement("");
            this.addRow(vector);
        }
        for (int i = 0; i < 10; ++i) {
            this.addRow(new Vector(stringArray.length));
        }
    }

    public void copyConicFromLinear(StorageTableModel object, double d) {
        PairedValues pairedValues = new PairedValues();
        PairedValues pairedValues2 = new PairedValues();
        StorageTableModel cfr_ignored_0 = (StorageTableModel)object.getModel();
        object.storeData(pairedValues, pairedValues2);
        double d2 = pairedValues.getYValue(0);
        object = Storage.getConicStorageArray(pairedValues2, d2, d);
        this.clearAll();
        int n = pairedValues2.size();
        for (int i = 0; i < n; ++i) {
            Vector<ParamDouble> vector = new Vector<ParamDouble>(3);
            ParamDouble paramDouble = new ParamDouble();
            pairedValues2.getXValue(i, paramDouble);
            vector.add(paramDouble);
            paramDouble = new ParamDouble();
            pairedValues2.getYValue(i, paramDouble);
            ParamDouble paramDouble2 = object != null && i < ((StorageTableModel)object).length ? new ParamDouble((double)object[i], this.getColumnParameter(1), pairedValues2.getUnitSystem(), 2) : new ParamDouble(Double.NEGATIVE_INFINITY, this.getColumnParameter(1), pairedValues2.getUnitSystem(), 2);
            vector.add(paramDouble2);
            vector.add(paramDouble);
            this.addRow(vector);
        }
        if (n == 0) {
            Vector<String> vector = new Vector<String>(3);
            vector.addElement("");
            this.addRow(vector);
        }
    }

    public void copyLinearFromConic(StorageTableModel object) {
        this.clearAll();
        object = object.getDataVector();
        int n = ((Vector)object).size();
        for (int i = 0; i < n; ++i) {
            Vector vector = (Vector)((Vector)object).elementAt(i);
            Vector<Object> vector2 = new Vector<Object>(3);
            for (int j = 0; j < 3; ++j) {
                Object e = vector.elementAt(j);
                if (e instanceof ParamDouble) {
                    try {
                        vector2.add(((ParamDouble)e).clone());
                    }
                    catch (Exception exception) {
                        vector2.add("");
                    }
                    continue;
                }
                vector2.add("");
            }
            this.addRow(vector2);
        }
        if (n == 0) {
            Vector<String> vector = new Vector<String>(3);
            vector.addElement("");
            this.addRow(vector);
        }
    }

    public boolean isEmpty() {
        Vector vector = this.getDataVector();
        for (int i = 0; i < vector.size(); ++i) {
            Vector vector2 = (Vector)vector.elementAt(i);
            Object e = vector2.elementAt(0);
            Object e2 = vector2.elementAt(1);
            vector2 = vector2.elementAt(2);
            if (!(e != null && !e.toString().equals("") || e2 != null && !e2.toString().equals("")) && (vector2 == null || ((Object)vector2).toString().equals(""))) continue;
            return false;
        }
        return true;
    }

    public RmaTableModel getModel() {
        return this;
    }

    public Object getValueAt(int n, int n2) {
        if (n < 0 || n >= this.getRowCount()) {
            return null;
        }
        if (n2 < 0 || n2 >= this.getColumnCount()) {
            return null;
        }
        Object object = super.getValueAt(n, n2);
        if (!(object instanceof ParamDouble)) {
            object = new ParamDouble(RMAIO.parseDouble((Object)object), this.getColumnParameter(n2));
            object.setUnitSystem(this.getUnitSystem());
            this.setValueAt(object, n, n2);
            return object;
        }
        return object;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (!(object instanceof ParamDouble)) {
            ParamDouble paramDouble = new ParamDouble();
            paramDouble.setValue(object.toString());
            paramDouble.setParameterId(this.getColumnParameter(n2));
            paramDouble.setUnitSystem(this.getUnitSystem());
            super.setValueAt((Object)paramDouble, n, n2);
            return;
        }
        super.setValueAt(object, n, n2);
    }

    public boolean isCellEditable(int n, int n2) {
        String string = this.getRowCellString(n, n2);
        if (this._editableCells.get(string) != null) {
            return true;
        }
        return super.isCellEditable(n, n2);
    }

    public void setCellEnabled(boolean bl, int n, int n2) {
        if (n < 0 || n2 < 0) {
            return;
        }
        String string = this.getRowCellString(n, n2);
        if (!bl) {
            this._editableCells.remove(string);
            return;
        }
        String string2 = string;
        this._editableCells.put(string2, string2);
    }

    private String getRowCellString(int n, int n2) {
        this.stChkCell.setLength(0);
        this.stChkCell.append(n);
        this.stChkCell.append(",");
        this.stChkCell.append(n2);
        return this.stChkCell.toString();
    }

    public void storeData(PairedValues pairedValues, PairedValues pairedValues2) {
        Vector vector = this.getDataVector();
        pairedValues.clearValues();
        pairedValues2.clearValues();
        for (int i = 0; i < vector.size(); ++i) {
            Vector vector2 = (Vector)vector.elementAt(i);
            Object e = vector2.elementAt(0);
            Object e2 = vector2.elementAt(1);
            vector2 = vector2.elementAt(2);
            if (e == null || e.toString().equals("")) continue;
            double d = RMAIO.parseDouble(e);
            double d2 = RMAIO.parseDouble(e2);
            double d3 = RMAIO.parseDouble((Object)vector2);
            if (d == Double.NEGATIVE_INFINITY) continue;
            pairedValues.addPair(d, d2);
            pairedValues2.addPair(d, d3);
        }
        pairedValues.setUnitSystem(this.getUnitSystem());
        pairedValues.setParamXId(this.getColumnParameter(0));
        pairedValues.setParamYId(this.getColumnParameter(1));
        pairedValues2.setUnitSystem(this.getUnitSystem());
        pairedValues2.setParamXId(this.getColumnParameter(0));
        pairedValues2.setParamYId(this.getColumnParameter(2));
    }
}

