/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.data.Parameter;
import hec.data.Units;
import hec.heclib.util.HecTime;
import hec.heclib.util.doubleArrayContainer;
import hec.lang.NamedType;
import hec.model.ConditionalBlock;
import hec.model.PairedValuesExt;
import hec.model.RunTimeStep;
import hec.model.SeasonalPairedValues;
import hec.model.SeasonalRecord;
import hec.model.SeasonalRecordExt;
import hec.rss.client.AdjustmentOptions$AdjustmentStrategy;
import hec.rss.client.AdjustmentOptions$ZoneAdjustments;
import hec.rss.model.ConditionalBlockRef;
import hec.rss.model.Element;
import hec.rss.model.ElementOp;
import hec.rss.model.IndependentVariable;
import hec.rss.model.OpController;
import hec.rss.model.OpRule;
import hec.rss.model.OpRuleRef;
import hec.rss.model.OpSet;
import hec.rss.model.ReservoirElement;
import hec.rss.model.ReservoirOp;
import hec.rss.model.ReservoirStorageVsYieldAnalysis;
import hec.rss.model.ReverseReservoirYieldAnalysis;
import hec.rss.model.RssConditional;
import hec.rss.model.RssConditionalBlock;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.StateVariable;
import hec.rss.model.Storage;
import hec.rss.model.YieldAnalysis;
import hec.rss.model.ZBOpRule;
import hec.rss.model.ZoneObject;
import hec.rss.model.ZoneObjectParent;
import hec.rss.model.reports.AltInputReportEnums;
import hec.rss.model.reports.AltInputReportInfc;
import hec.rss.model.reports.AlternativeInputReport;
import hec.util.XMLUtilities;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom.Content;
import rma.util.RMAConst;

public class StorageZone
extends NamedType
implements ZoneObjectParent,
AltInputReportInfc,
Cloneable {
    OpSet _opSet;
    public static final int ZONETYPEID_ELEV = 0;
    public static final int ZONETYPEID_STOR = 1;
    private int _zoneTypeID = 0;
    SeasonalRecord _zoneElevation = new SeasonalRecord();
    private SeasonalPairedValues _seasonalPairedValues = new SeasonalPairedValues();
    private boolean _hasSeasonalVariation = false;
    boolean m_useMultiYearData = false;
    int m_startYear = 1900;
    int m_unitSystem = 0;
    boolean m_useTimeSeries = false;
    IndependentVariable _independentVariable = new IndependentVariable();
    List<ZoneObject> _zoneObjectList = new ArrayList<ZoneObject>();
    private transient doubleArrayContainer a;
    private transient doubleArrayContainer b;
    private transient doubleArrayContainer c;
    private transient Storage d;
    private transient OpSet e;
    private double _referenceElevation = Double.NEGATIVE_INFINITY;
    private boolean _useRefElev = false;
    private boolean _useTVIndependentVariable = false;
    IndependentVariable _tvRowIndependentVariable = new IndependentVariable();
    IndependentVariable _tvColIndependentVariable = new IndependentVariable();
    private PairedValuesExt _userDefinedPairedValuesExt = new PairedValuesExt();
    private SeasonalRecordExt _userDefinedSeasonalRecordsExt = new SeasonalRecordExt();
    private String[] _userDefinedColumnValues;
    private transient ZBOpRule f;
    private transient boolean g = false;
    private transient double h = 1.0;
    private transient ReverseReservoirYieldAnalysis i = null;
    private transient ReservoirStorageVsYieldAnalysis j = null;
    private transient int k = -1;
    private transient boolean l = false;
    private transient double m = 0.0;

    public StorageZone() {
    }

    public StorageZone(String string) {
        super(string);
    }

    public void getElementDependencies(List<Element> list) {
        ReservoirElement reservoirElement = this.getReservoirElement();
        if (list == null || reservoirElement == null) {
            return;
        }
        if (this._independentVariable != null) {
            this._independentVariable.getElementDependencies(list, reservoirElement);
        }
    }

    public void getReferencedStateVariables(List list) {
        RssSystem rssSystem = this.getSystem();
        if (rssSystem == null) {
            return;
        }
        if (this._independentVariable != null) {
            StateVariable stateVariable;
            if (this._independentVariable.getType() == 4 && (stateVariable = rssSystem.getStateVariable(this._independentVariable.getStateVariableId())) != null && !list.contains(stateVariable)) {
                list.add(stateVariable);
            }
            if (this._independentVariable.getType() == 5) {
                if (this._independentVariable.getRowVariable().getType() == 4 && (stateVariable = rssSystem.getStateVariable(this._independentVariable.getRowVariable().getStateVariableId())) != null && !list.contains(stateVariable)) {
                    list.add(stateVariable);
                }
                if (this._independentVariable.getColVariable().getType() == 4 && (stateVariable = rssSystem.getStateVariable(this._independentVariable.getColVariable().getStateVariableId())) != null && !list.contains(stateVariable)) {
                    list.add(stateVariable);
                }
            }
        }
        int n = this._zoneObjectList.size();
        for (int i = 0; i < n; ++i) {
            ZoneObject zoneObject = this._zoneObjectList.get(i);
            if (zoneObject == null) continue;
            zoneObject.getReferencedStateVariables(list);
        }
    }

    public boolean initializeCompute() {
        double d;
        this._independentVariable.initializeCompute(this.getSystem(), this._opSet);
        if (this._opSet.getElementOp() instanceof ReservoirOp && (RMAConst.isUndefinedValue((double)(d = this.getFirstElevation())) || d == 0.0 && this._zoneElevation.size() < 2)) {
            this.getSystem().printErrorMessage("No Zone Elevation Data for Storage Zone " + this.getName() + " in Operations Set " + this._opSet.getName());
            return false;
        }
        int n = this._zoneObjectList.size();
        for (int i = 0; i < n; ++i) {
            ZoneObject zoneObject = this._zoneObjectList.get(i);
            if (zoneObject == null) continue;
            zoneObject.setParent(this);
        }
        OpController opController = this._opSet.getElementOp().getController();
        this.f = new ZBOpRule(opController.getReleaseElement().getName() + "-" + this.getName() + "-ZBOp Rule");
        this.f.setController(opController);
        this.f.setZone(this);
        this.f.initializeCompute();
        return true;
    }

    public List getActiveRules(RunTimeStep runTimeStep, List arrayList) {
        if (arrayList == null) {
            arrayList = new ArrayList<OpRule>();
        }
        int n = this._zoneObjectList.size();
        for (int i = 0; i < n; ++i) {
            Object object = this._zoneObjectList.get(i);
            if (object instanceof OpRuleRef) {
                object = (OpRuleRef)object;
                OpRule opRule = ((OpRuleRef)object).getRule();
                if (((OpRuleRef)object).isDisabled() || opRule == null || arrayList.contains(opRule)) continue;
                arrayList.add(opRule);
                continue;
            }
            if (!(object instanceof ConditionalBlockRef) || ((ConditionalBlockRef)object).isDisabled() || !(((ConditionalBlockRef)object).getConditionalBlock() instanceof RssConditionalBlock) || (object = (RssConditionalBlock)((ConditionalBlockRef)object).getConditionalBlock()) == null) continue;
            ((RssConditionalBlock)((Object)object)).getActiveRules(runTimeStep, arrayList);
        }
        return arrayList;
    }

    public List getPrimaryRules(List arrayList) {
        if (arrayList == null) {
            arrayList = new ArrayList<Object>();
        }
        int n = this._zoneObjectList.size();
        for (int i = 0; i < n; ++i) {
            Object object = this._zoneObjectList.get(i);
            if (!(object instanceof OpRuleRef)) continue;
            object = (OpRuleRef)object;
            if ((object = ((OpRuleRef)object).getRule()) == null || arrayList.contains(object)) continue;
            arrayList.add(object);
        }
        return arrayList;
    }

    public List<OpRule> getRules(List<OpRule> list) {
        if (list == null) {
            list = new ArrayList<OpRule>();
        }
        if (this.f != null) {
            list.add(this.f);
        }
        int n = this._zoneObjectList.size();
        for (int i = 0; i < n; ++i) {
            Object object = this._zoneObjectList.get(i);
            if (object instanceof OpRuleRef) {
                object = (OpRuleRef)object;
                if ((object = ((OpRuleRef)object).getRule()) == null || list.contains(object)) continue;
                list.add((OpRule)object);
                continue;
            }
            if (!(object instanceof ConditionalBlockRef) || !(((ConditionalBlockRef)object).getConditionalBlock() instanceof RssConditionalBlock) || (object = (RssConditionalBlock)((ConditionalBlockRef)object).getConditionalBlock()) == null) continue;
            ((RssConditionalBlock)((Object)object)).getRules(list);
        }
        return list;
    }

    public ZBOpRule getZBOpRule() {
        return this.f;
    }

    public List<OpRuleRef> getRuleRefs(List<OpRuleRef> list) {
        if (list == null) {
            list = new ArrayList<OpRuleRef>();
        }
        int n = this._zoneObjectList.size();
        for (int i = 0; i < n; ++i) {
            Object object = this._zoneObjectList.get(i);
            if (object instanceof OpRuleRef) {
                if ((object = (OpRuleRef)object) == null || list.contains(object)) continue;
                list.add((OpRuleRef)object);
                continue;
            }
            if (!(object instanceof ConditionalBlockRef) || !(((ConditionalBlockRef)object).getConditionalBlock() instanceof RssConditionalBlock) || (object = (RssConditionalBlock)((ConditionalBlockRef)object).getConditionalBlock()) == null) continue;
            ((RssConditionalBlock)((Object)object)).getRuleRefs(list);
        }
        return list;
    }

    public void decreaseZoneObjectPriority(Object object) {
        int n = this._zoneObjectList.indexOf(object);
        if (n == -1 || n == this._zoneObjectList.size() - 1) {
            return;
        }
        this._zoneObjectList.remove(object);
        if (++n == this._zoneObjectList.size()) {
            this._zoneObjectList.add((ZoneObject)object);
            return;
        }
        this._zoneObjectList.add(n, (ZoneObject)object);
    }

    public void increaseZoneObjectPriority(Object object) {
        int n = this._zoneObjectList.indexOf(object);
        if (n == -1 || n == 0) {
            return;
        }
        this._zoneObjectList.remove(object);
        this._zoneObjectList.add(--n, (ZoneObject)object);
    }

    public boolean setZonePriority(Object object, int n) {
        if (object == null) {
            return false;
        }
        int n2 = this._zoneObjectList.indexOf(object);
        if (n2 == -1) {
            return false;
        }
        this._zoneObjectList.remove(n2);
        if (n < 0) {
            n = 0;
        }
        if (n > this._zoneObjectList.size()) {
            this._zoneObjectList.add((ZoneObject)object);
        } else {
            this._zoneObjectList.add(n, (ZoneObject)object);
        }
        return true;
    }

    public void moveZoneObjectToBottomPriority(Object object) {
        if (object == null) {
            return;
        }
        int n = this._zoneObjectList.indexOf(object);
        if (n == -1) {
            return;
        }
        this._zoneObjectList.remove(object);
        this._zoneObjectList.add((ZoneObject)object);
    }

    public void moveZoneObjectToTopPriority(Object object) {
        if (object == null) {
            return;
        }
        int n = this._zoneObjectList.indexOf(object);
        if (n == -1) {
            return;
        }
        this._zoneObjectList.remove(object);
        if (this._zoneObjectList.isEmpty()) {
            this._zoneObjectList.add((ZoneObject)object);
            return;
        }
        this._zoneObjectList.add(0, (ZoneObject)object);
    }

    public List<ZoneObject> getZoneObjectsList() {
        if (this._zoneObjectList == null) {
            this._zoneObjectList = new ArrayList<ZoneObject>();
        }
        return this._zoneObjectList;
    }

    public OpRuleRef addRule(OpRule namedType) {
        if (this.usesOpRule((OpRule)namedType, false)) {
            return null;
        }
        namedType = new OpRuleRef(this, (OpRule)namedType);
        this._zoneObjectList.add((ZoneObject)namedType);
        this.setModified(true);
        return namedType;
    }

    public void removeAllRules() {
        List<OpRule> list = new ArrayList<OpRule>();
        list = this.getRules(list);
        for (int i = 0; i < list.size(); ++i) {
            if (!(list.get(i) instanceof OpRule)) continue;
            OpRule opRule = list.get(i);
            this.removeRule(opRule);
        }
    }

    public void removeAllIfBlocks() {
        this._zoneObjectList.size();
        Iterator<ZoneObject> iterator = this._zoneObjectList.iterator();
        while (iterator.hasNext()) {
            ZoneObject zoneObject = iterator.next();
            if (zoneObject == null || !(zoneObject instanceof ConditionalBlockRef)) continue;
            iterator.remove();
        }
    }

    public void removeIfBlock(ConditionalBlock conditionalBlock) {
        this._zoneObjectList.size();
        Iterator<ZoneObject> iterator = this._zoneObjectList.iterator();
        while (iterator.hasNext()) {
            ZoneObject zoneObject = iterator.next();
            if (zoneObject == null || !(zoneObject instanceof ConditionalBlockRef)) continue;
            zoneObject = (ConditionalBlockRef)zoneObject;
            ConditionalBlock conditionalBlock2 = ((ConditionalBlockRef)zoneObject).getConditionalBlock();
            this.removeIfBlock(conditionalBlock2, conditionalBlock);
            if (((ConditionalBlockRef)zoneObject).getConditionalBlock() != conditionalBlock) continue;
            iterator.remove();
        }
    }

    private void removeIfBlock(ConditionalBlock object, ConditionalBlock conditionalBlock) {
        object = object.getConditionals();
        for (int i = 0; i < object.size(); ++i) {
            RssConditional rssConditional = (RssConditional)object.get(i);
            List<ConditionalBlockRef> list = rssConditional.getConditionalBlockRefs(null);
            if (list == null) {
                return;
            }
            for (int j = 0; j < list.size(); ++j) {
                ConditionalBlockRef conditionalBlockRef = list.get(j);
                ConditionalBlock conditionalBlock2 = conditionalBlockRef.getConditionalBlock();
                if (conditionalBlock2 == conditionalBlock) {
                    rssConditional.removeCondtionalObject(conditionalBlockRef);
                    continue;
                }
                this.removeIfBlock(conditionalBlock2, conditionalBlock);
            }
        }
    }

    public OpRuleRef removeRule(OpRuleRef opRuleRef) {
        int n = this._zoneObjectList.size();
        OpRuleRef opRuleRef2 = null;
        for (int i = 0; i < n; ++i) {
            ZoneObject zoneObject = this._zoneObjectList.get(i);
            if (zoneObject == null || !(zoneObject instanceof OpRuleRef) || (opRuleRef2 = (OpRuleRef)zoneObject) != opRuleRef) continue;
            this._zoneObjectList.remove(i);
            return opRuleRef2;
        }
        return opRuleRef2;
    }

    public OpRuleRef removeRule(OpRule opRule) {
        int n = this._zoneObjectList.size();
        OpRuleRef opRuleRef = null;
        for (int i = 0; i < n; ++i) {
            ZoneObject zoneObject = this._zoneObjectList.get(i);
            if (zoneObject == null || !(zoneObject instanceof OpRuleRef) || !(opRuleRef = (OpRuleRef)zoneObject).getRule().getName().equalsIgnoreCase(opRule.getName()) && opRuleRef.getRule() != opRule) continue;
            this._zoneObjectList.remove(i);
            return opRuleRef;
        }
        return opRuleRef;
    }

    public List getControllerRules(int n, List arrayList) {
        if (arrayList == null) {
            arrayList = new ArrayList<Object>();
        }
        if (this._zoneObjectList == null) {
            return arrayList;
        }
        int n2 = this._zoneObjectList.size();
        for (int i = 0; i < n2; ++i) {
            Object object = this._zoneObjectList.get(i);
            if (object == null) continue;
            if (object instanceof OpRuleRef) {
                if (((OpRuleRef)(object = (OpRuleRef)object)).getOpControllerIndex() != n || (object = ((OpRuleRef)object).getRule()) == null || arrayList.contains(object)) continue;
                arrayList.add(object);
                continue;
            }
            if (!(object instanceof ConditionalBlockRef) || !(((ConditionalBlockRef)object).getConditionalBlock() instanceof RssConditionalBlock)) continue;
            object = (RssConditionalBlock)((ConditionalBlockRef)object).getConditionalBlock();
            ((RssConditionalBlock)((Object)object)).getControllerRules(n, arrayList);
        }
        return arrayList;
    }

    public void removeControllerRefs(int n) {
        int n2 = this._zoneObjectList.size();
        --n2;
        while (n2 >= 0) {
            Object object = this._zoneObjectList.get(n2);
            if (object != null) {
                if (object instanceof OpRuleRef) {
                    if (((OpRuleRef)(object = (OpRuleRef)object)).getOpControllerIndex() == n) {
                        this._zoneObjectList.remove(n2);
                    }
                } else if (object instanceof ConditionalBlockRef && ((ConditionalBlockRef)object).getConditionalBlock() instanceof RssConditionalBlock) {
                    object = (RssConditionalBlock)((ConditionalBlockRef)object).getConditionalBlock();
                    ((RssConditionalBlock)((Object)object)).removeControllerRefs(n);
                }
            }
            --n2;
        }
    }

    public List getConditionalBlockRefs(List arrayList) {
        if (arrayList == null) {
            arrayList = new ArrayList<ZoneObject>();
        }
        int n = this._zoneObjectList.size();
        for (int i = 0; i < n; ++i) {
            ZoneObject zoneObject = this._zoneObjectList.get(i);
            if (!(zoneObject instanceof ConditionalBlockRef)) continue;
            arrayList.add(zoneObject);
        }
        return arrayList;
    }

    public List getAllRuleRefs(int n, int n2, List arrayList) {
        if (arrayList == null) {
            arrayList = new ArrayList<ZoneObject>();
        }
        int n3 = this._zoneObjectList.size();
        for (int i = 0; i < n3; ++i) {
            Object object = this._zoneObjectList.get(i);
            if (object == null) continue;
            if (object instanceof OpRuleRef) {
                if (((OpRuleRef)(object = (OpRuleRef)object)).getOpControllerIndex() != n || ((OpRuleRef)object).getRuleIndex() != n2) continue;
                arrayList.add((ZoneObject)object);
                continue;
            }
            if (!(object instanceof ConditionalBlockRef) || !(((ConditionalBlockRef)object).getConditionalBlock() instanceof RssConditionalBlock)) continue;
            object = (RssConditionalBlock)((ConditionalBlockRef)object).getConditionalBlock();
            ((RssConditionalBlock)((Object)object)).getAllRuleRefs(n, n2, arrayList);
        }
        return arrayList;
    }

    public void removeAllRuleRefs(int n, int n2) {
        int n3 = this._zoneObjectList.size();
        --n3;
        while (n3 >= 0) {
            Object object = this._zoneObjectList.get(n3);
            if (object != null) {
                if (object instanceof OpRuleRef) {
                    if (((OpRuleRef)(object = (OpRuleRef)object)).getOpControllerIndex() == n && ((OpRuleRef)object).getRuleIndex() == n2) {
                        this._zoneObjectList.remove(n3);
                    }
                } else if (object instanceof ConditionalBlockRef && ((ConditionalBlockRef)object).getConditionalBlock() instanceof RssConditionalBlock) {
                    object = (RssConditionalBlock)((ConditionalBlockRef)object).getConditionalBlock();
                    ((RssConditionalBlock)((Object)object)).removeAllRuleRefs(n, n2);
                }
            }
            --n3;
        }
    }

    public void removeAllConditionalBlockRefs(int n) {
        int n2 = this._zoneObjectList.size();
        --n2;
        while (n2 >= 0) {
            Object object = this._zoneObjectList.get(n2);
            if (object != null && object instanceof ConditionalBlockRef) {
                if ((object = (ConditionalBlockRef)object).getConditionalBlockId() == n) {
                    this._zoneObjectList.remove(n2);
                } else if (((ConditionalBlockRef)object).getConditionalBlock() instanceof RssConditionalBlock) {
                    object = (RssConditionalBlock)((ConditionalBlockRef)object).getConditionalBlock();
                    ((RssConditionalBlock)((Object)object)).removeAllConditionalBlockRefs(n);
                }
            }
            --n2;
        }
    }

    public boolean usesOpRule(OpRule opRule, boolean n) {
        int n2 = this._zoneObjectList.size();
        for (n = 0; n < n2; ++n) {
            ZoneObject zoneObject = this._zoneObjectList.get(n);
            if (zoneObject == null || !(zoneObject instanceof OpRuleRef) || ((OpRuleRef)(zoneObject = (OpRuleRef)zoneObject)).getRule() != opRule) continue;
            return true;
        }
        return false;
    }

    public ConditionalBlockRef addConditionalBlock(ConditionalBlock object) {
        if (this.usesConditionalBlock((ConditionalBlock)object, false)) {
            return null;
        }
        object = new ConditionalBlockRef(this, (ConditionalBlock)object);
        this._zoneObjectList.add((ZoneObject)object);
        this.setModified(true);
        return object;
    }

    public ConditionalBlockRef removeConditionalBlock(ConditionalBlock conditionalBlock) {
        int n = this._zoneObjectList.size();
        ConditionalBlockRef conditionalBlockRef = null;
        for (int i = 0; i < n; ++i) {
            ZoneObject zoneObject = this._zoneObjectList.get(i);
            if (zoneObject == null || !(zoneObject instanceof ConditionalBlockRef) || (conditionalBlockRef = (ConditionalBlockRef)zoneObject).getConditionalBlock() != conditionalBlock) continue;
            this._zoneObjectList.remove(i);
            return conditionalBlockRef;
        }
        return conditionalBlockRef;
    }

    public boolean usesConditionalBlock(ConditionalBlock conditionalBlock, boolean n) {
        int n2 = this._zoneObjectList.size();
        for (n = 0; n < n2; ++n) {
            ZoneObject zoneObject = this._zoneObjectList.get(n);
            if (zoneObject == null || !(zoneObject instanceof ConditionalBlockRef) || ((ConditionalBlockRef)(zoneObject = (ConditionalBlockRef)zoneObject)).getConditionalBlock() != conditionalBlock) continue;
            return true;
        }
        return false;
    }

    public void setOpSet(OpSet opSet) {
        this._opSet = opSet;
    }

    public OpSet getOpSet() {
        return this._opSet;
    }

    public String getFullZoneName(StorageZone storageZone) {
        String string = this._opSet.getElementOp().getOperationsElement().getName();
        return string + "-" + storageZone.getName();
    }

    @Override
    public ElementOp getElementOp() {
        if (this._opSet == null) {
            return null;
        }
        return this._opSet.getElementOp();
    }

    public void setOpSetForElevOverride(OpSet opSet) {
        this.e = opSet;
    }

    public void setKnownElevTS(doubleArrayContainer doubleArrayContainer2) {
        this.a = doubleArrayContainer2;
    }

    public void setZoneElevTSContainer(doubleArrayContainer doubleArrayContainer2) {
        this.b = doubleArrayContainer2;
    }

    public void setZoneStorTSContainer(doubleArrayContainer doubleArrayContainer2) {
        this.c = doubleArrayContainer2;
    }

    public void setStorageFunction(Storage storage) {
        this.d = storage;
    }

    public RssSystem getSystem() {
        if (this._opSet == null) {
            return null;
        }
        return ((RssTSLocationObject)this._opSet).getSystem();
    }

    public ReservoirElement getReservoirElement() {
        if (this._opSet == null) {
            return null;
        }
        return (ReservoirElement)this._opSet.getElementOp().getOperationsElement();
    }

    private Storage getResStorageFunction() {
        if (this.d == null && this._opSet != null) {
            this.d = this.getReservoirElement().getStorageFunction();
        }
        return this.d;
    }

    public void setUnitSysetm(int n) {
        if (!Units.isValidUnitsSystem((int)n)) {
            System.out.println("ERROR <StorageZone.setUnitSysetm()> : Invalid unit system trying to be set " + n + " (2) SI (1) English");
            return;
        }
        if (this.m_unitSystem == 0) {
            this.m_unitSystem = n;
        }
    }

    public void useMultiYearData(boolean bl) {
        this.m_useMultiYearData = bl;
    }

    public boolean isMultiYearData() {
        return this.m_useMultiYearData;
    }

    public void useTimeSeries(boolean bl) {
        this.m_useTimeSeries = bl;
    }

    public boolean isTimeSeries() {
        return this.m_useTimeSeries;
    }

    public void setIndependentVariable(IndependentVariable independentVariable) {
        this._independentVariable = independentVariable;
        StorageZone storageZone = this;
        storageZone.useTimeSeries(storageZone._independentVariable.isTSOptChecked());
    }

    public IndependentVariable getIndependentVariable() {
        return this._independentVariable;
    }

    public void setStartYear(int n) {
        this.m_startYear = n;
    }

    public int getStartYear() {
        return this.m_startYear;
    }

    public int getUnitSystem() {
        return this.m_unitSystem;
    }

    public String toString() {
        return this.getName();
    }

    public double getInterpolateElev(HecTime hecTime) {
        if (this._zoneElevation == null) {
            return Double.NEGATIVE_INFINITY;
        }
        return this._zoneElevation.interpolate(hecTime);
    }

    public int getZoneTypeID() {
        return this._zoneTypeID;
    }

    public void setZoneTypeID(int n) {
        if (n != 0 && 1 != n) {
            String string = "Invalid zone type: " + n + ". Valid values are StorageZone.ZONETYPEID_ELEV or StorageZone.ZONETYPEID_STOR";
            throw new IllegalArgumentException(string);
        }
        this._zoneTypeID = n;
    }

    public double getElevation(RunTimeStep runTimeStep) {
        double d = -3.4028234663852886E38;
        double d2 = -3.4028234663852886E38;
        boolean bl = this.b != null && this.b.array != null && runTimeStep.step < this.b.array.length;
        double d3 = this.getIndpVarValue(runTimeStep, bl);
        if (this._zoneTypeID == 0) {
            d = d3;
            if (this.getResStorageFunction() != null) {
                d2 = this.d.elevationToStorage(d);
            }
        } else {
            d2 = d3;
            if (this.getResStorageFunction() != null) {
                d = this.d.storageToElevation(d2);
            }
        }
        if (this.e != null) {
            d = this.e.computeAdjustedZoneElev(this, runTimeStep, d);
        }
        if (bl) {
            this.b.array[runTimeStep.step] = d;
        }
        if (this.getResStorageFunction() != null && this.c != null && this.c.array != null && runTimeStep.step < this.c.array.length) {
            this.c.array[runTimeStep.step] = d2;
        }
        return d;
    }

    public double getIndpVarValue(RunTimeStep runTimeStep, boolean bl) {
        double d;
        if (this._independentVariable == null) {
            return Double.NEGATIVE_INFINITY;
        }
        doubleArrayContainer doubleArrayContainer2 = this.b;
        if (this._zoneTypeID == 1) {
            doubleArrayContainer2 = this.c;
        }
        switch (this._independentVariable.getType()) {
            case 0: 
            case 1: {
                if (bl && RMAConst.isValidValue((double)doubleArrayContainer2.array[runTimeStep.step]) && this.e == null) {
                    d = doubleArrayContainer2.array[runTimeStep.step];
                    break;
                }
                d = this._zoneElevation.interpolate(runTimeStep);
                if (!this.g) break;
                d = this.adjustForStorageScale(d, runTimeStep);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                double d2 = this._independentVariable.evaluateTSFunction(runTimeStep);
                if (!RMAConst.isValidValue((double)d2)) {
                    d = this.getReferenceValue();
                    break;
                }
                if (this._independentVariable.getType() == 3 && this._independentVariable.isTSOptChecked()) {
                    d = d2;
                    break;
                }
                if (this._seasonalPairedValues.hasSeasonalVariation()) {
                    d = this._seasonalPairedValues.interpolate(runTimeStep, d2);
                    break;
                }
                d = this._seasonalPairedValues.interpolate(d2);
                break;
            }
            case 5: {
                StorageZone storageZone = this;
                d = storageZone.getTwoVarValue(storageZone._independentVariable.getRowVariable(), this._independentVariable.getColVariable(), runTimeStep, bl);
                break;
            }
            default: {
                d = Double.NEGATIVE_INFINITY;
            }
        }
        return d;
    }

    private double adjustForStorageScale(double d, RunTimeStep runTimeStep) {
        double d2 = this.getIndex() == this.k ? this.adjustForStorageScaleMobile(d, runTimeStep) : this.adjustForStorageScaleAdjacent(d, runTimeStep);
        return d2;
    }

    private double adjustForStorageScaleMobile(double d, RunTimeStep runTimeStep) {
        if (this.i != null) {
            return this.adjustForStorageScaleMobileRYA(d, runTimeStep);
        }
        if (this.j != null) {
            return this.adjustForStorageScaleMobileSVYA(d, runTimeStep);
        }
        return d;
    }

    private double adjustForStorageScaleMobileRYA(double d, RunTimeStep runTimeStep) {
        double d2 = d;
        if (!this.i.c(runTimeStep)) {
            double d3;
            double d4;
            double d5;
            boolean bl = this.i.n();
            if (bl) {
                d5 = this.i.a(runTimeStep);
                d4 = 1.0;
            } else {
                d5 = this.i.b(runTimeStep);
                d4 = -1.0;
            }
            if (this.i.a().h() == AdjustmentOptions$AdjustmentStrategy.PROPORTIONALLY_SCALE) {
                double d6 = d4 * (d5 - d);
                d3 = d + this.h * d6;
            } else {
                d2 = d + this.h * this.i.o();
                d3 = bl ? Math.min(d2, d5) : Math.max(d2, d5);
            }
            d2 = d3;
        }
        return d2;
    }

    private double adjustForStorageScaleMobileSVYA(double d, RunTimeStep runTimeStep) {
        double d2 = d;
        if (!this.j.a(runTimeStep)) {
            double d3;
            double d4;
            double d5;
            boolean bl = this.j.n();
            if (bl) {
                d5 = this.j.f().getValue();
                d4 = 1.0;
            } else {
                d5 = this.j.e().getValue();
                d4 = -1.0;
            }
            if (this.j.g().b() == AdjustmentOptions$AdjustmentStrategy.PROPORTIONALLY_SCALE) {
                double d6 = d4 * (d5 - d);
                d3 = d + this.h * d6;
            } else {
                d2 = d + this.h * this.j.o();
                d3 = bl ? Math.min(d2, d5) : Math.max(d2, d5);
            }
            d2 = d3;
        }
        return d2;
    }

    private double adjustForStorageScaleAdjacent(double d, RunTimeStep runTimeStep) {
        if (this.i != null) {
            return this.adjustForStorageScaleAdjacentRYA(d, runTimeStep);
        }
        if (this.j != null) {
            return this.adjustForStorageScaleAdjacentSVYA(d, runTimeStep);
        }
        return d;
    }

    private double adjustForStorageScaleAdjacentRYA(double d, RunTimeStep runTimeStep) {
        double d2 = d;
        double d3 = this._opSet.getZone(this.k).getElevation(runTimeStep);
        boolean bl = this.i.n();
        if (this.i.a().n() == AdjustmentOptions$ZoneAdjustments.COLLAPSE_ZONES) {
            if (bl && this.l) {
                d2 = Math.max(d, d3);
            } else if (!bl && !this.l) {
                d2 = Math.min(d, d3);
            }
        } else if (bl && this.l && this.m > 0.0) {
            double d4 = this.i.a(runTimeStep);
            double d5 = d4 - d3;
            d2 = d3 + this.m * d5;
        } else if (!bl && !this.l && this.m > 0.0) {
            double d6 = this.i.b(runTimeStep);
            double d7 = d3 - d6;
            d2 = d3 - this.m * d7;
        }
        return d2;
    }

    private double adjustForStorageScaleAdjacentSVYA(double d, RunTimeStep runTimeStep) {
        double d2 = d;
        double d3 = this._opSet.getZone(this.k).getElevation(runTimeStep);
        boolean bl = this.j.n();
        if (this.j.g().a() == AdjustmentOptions$ZoneAdjustments.COLLAPSE_ZONES) {
            if (bl && this.l) {
                d2 = Math.max(d, d3);
            } else if (!bl && !this.l) {
                d2 = Math.min(d, d3);
            }
        } else if (bl && this.l && this.m > 0.0) {
            double d4 = this.j.f().getValue();
            double d5 = d4 - d3;
            d2 = d3 + this.m * d5;
        } else if (!bl && !this.l && this.m > 0.0) {
            double d6 = this.j.e().getValue();
            double d7 = d3 - d6;
            d2 = d3 - this.m * d7;
        }
        return d2;
    }

    public double getTwoVarValue(IndependentVariable independentVariable, IndependentVariable independentVariable2, RunTimeStep runTimeStep, boolean bl) {
        if (independentVariable == null || independentVariable2 == null) {
            return Double.NEGATIVE_INFINITY;
        }
        double d = Double.NEGATIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        switch (independentVariable2.getType()) {
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                d2 = independentVariable2.evaluateTSFunction(runTimeStep);
                if (d2 != Double.NEGATIVE_INFINITY) break;
                d = Double.NEGATIVE_INFINITY;
            }
        }
        switch (independentVariable.getType()) {
            case 0: 
            case 1: {
                d = this._userDefinedSeasonalRecordsExt.interpolate(runTimeStep, d2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                double d3 = independentVariable.evaluateTSFunction(runTimeStep);
                d = this._userDefinedPairedValuesExt.interpolate(d3, d2);
            }
        }
        return d;
    }

    public double getElevation(RunTimeStep runTimeStep, Hashtable serializable) {
        if (serializable != null && (serializable = (Double)((Hashtable)serializable).get(new Integer(runTimeStep.valueMinutes()))) != null && (Double)serializable != Double.NEGATIVE_INFINITY) {
            return (Double)serializable;
        }
        return this.getElevation(runTimeStep);
    }

    public double getFirstValue() {
        int n;
        double d = this._independentVariable != null ? ((n = this._independentVariable.getType()) == 0 || n == 1 ? this._zoneElevation.getValue(0) : (n == 3 || n == 4 || n == 6 || n == 2 || n == 5 ? this._zoneElevation.getValue(0) : this._referenceElevation)) : this._zoneElevation.getValue(0);
        return d;
    }

    public double getFirstElevation() {
        double d = this.getFirstValue();
        double d2 = -3.4028234663852886E38;
        if (this._zoneTypeID == 0) {
            d2 = d;
        } else if (this.getResStorageFunction() != null) {
            d2 = this.d.storageToElevation(d);
        }
        return d2;
    }

    public void setUseStorageScale(boolean bl, ReverseReservoirYieldAnalysis reverseReservoirYieldAnalysis) {
        this.g = bl;
        if (this.g) {
            this.i = reverseReservoirYieldAnalysis;
            return;
        }
        this.i = null;
    }

    public void setUseStorageScale(boolean bl, ReservoirStorageVsYieldAnalysis reservoirStorageVsYieldAnalysis) {
        this.g = bl;
        if (this.g) {
            this.j = reservoirStorageVsYieldAnalysis;
            return;
        }
        this.j = null;
    }

    public void setStorageScale(double d) {
        this.h = d;
    }

    public void setMobileZoneId(int n) {
        this.k = n;
    }

    public void setAbvMobileZone(boolean bl) {
        this.l = bl;
    }

    public void setProportionScale(double d) {
        this.m = d;
    }

    public double getReferenceValue() {
        return this._referenceElevation;
    }

    public void setReferenceValue(double d) {
        this._referenceElevation = d;
        this.setConstantValue(d);
    }

    public boolean useReferenceValue() {
        return this._useRefElev;
    }

    public void setUseReferenceValue(boolean bl) {
        this._useRefElev = bl;
    }

    public void setConstantValue(double d) {
        int[] nArray = new int[1];
        double[] dArray = new double[1];
        HecTime hecTime = new HecTime("01JAN");
        nArray[0] = hecTime.value();
        dArray[0] = d;
        this._zoneElevation.setArrays(nArray, dArray);
    }

    public boolean useTwoVariableIndependentVariable() {
        return this._useTVIndependentVariable;
    }

    public void setUseTwoVariableIndependentVariable(boolean bl) {
        this._useTVIndependentVariable = bl;
    }

    public IndependentVariable getTVRowIndependentVariable() {
        return this._tvRowIndependentVariable;
    }

    public void setTVRowIndependentVariable(IndependentVariable independentVariable) {
        this._tvRowIndependentVariable = independentVariable;
    }

    public IndependentVariable getTVColIndependentVariable() {
        return this._tvColIndependentVariable;
    }

    public void setTVColIndependentVariable(IndependentVariable independentVariable) {
        this._tvColIndependentVariable = independentVariable;
    }

    public void setUserDefinedValues(PairedValuesExt pairedValuesExt) {
        this._userDefinedPairedValuesExt = pairedValuesExt;
    }

    public void setUserDefinedValues(SeasonalRecordExt seasonalRecordExt) {
        this._userDefinedSeasonalRecordsExt = seasonalRecordExt;
    }

    public void setUserDefinedColumnValues(String[] stringArray) {
        this._userDefinedColumnValues = stringArray;
    }

    public PairedValuesExt getUserDefinedPairedValuesExt() {
        return this._userDefinedPairedValuesExt;
    }

    public SeasonalRecordExt getUserDefinedSeasonalRecordExt() {
        return this._userDefinedSeasonalRecordsExt;
    }

    public String[] getUserDefinedColumnValues() {
        return this._userDefinedColumnValues;
    }

    public boolean hasSeasonalVariation() {
        if (this._seasonalPairedValues != null) {
            this._hasSeasonalVariation = this._seasonalPairedValues.hasSeasonalVariation();
        }
        return this._hasSeasonalVariation;
    }

    public void setSeasonalRecord(SeasonalRecord seasonalRecord) {
        this._zoneElevation = seasonalRecord;
    }

    public void setFunctionElevation(SeasonalPairedValues seasonalPairedValues) {
        if (seasonalPairedValues == null) {
            return;
        }
        this._seasonalPairedValues = seasonalPairedValues;
        this._userDefinedPairedValuesExt = null;
        this._userDefinedSeasonalRecordsExt = null;
    }

    public void setFunctionElevation(PairedValuesExt pairedValuesExt) {
        if (pairedValuesExt == null) {
            return;
        }
        this._userDefinedPairedValuesExt = pairedValuesExt;
        this._seasonalPairedValues = null;
        this._userDefinedSeasonalRecordsExt = null;
    }

    public void setFunctionElevation(SeasonalRecordExt seasonalRecordExt) {
        if (seasonalRecordExt == null) {
            return;
        }
        this._userDefinedSeasonalRecordsExt = seasonalRecordExt;
        this._seasonalPairedValues = null;
        this._userDefinedPairedValuesExt = null;
    }

    public Object getFunctionElevation() {
        if (this._seasonalPairedValues == null && this._userDefinedSeasonalRecordsExt == null && this._userDefinedPairedValuesExt == null) {
            return null;
        }
        if (this._userDefinedPairedValuesExt != null && this._userDefinedPairedValuesExt.getNumberCurves() > 0) {
            this._userDefinedPairedValuesExt.setUnitSystem(this.getUnitSystem());
            this._userDefinedPairedValuesExt.setParamXId(-1);
            this._userDefinedPairedValuesExt.setParamYId(Parameter.PARAMID_ELEV);
            return this._userDefinedPairedValuesExt;
        }
        if (this._userDefinedSeasonalRecordsExt != null && this._userDefinedSeasonalRecordsExt.getNumberCurves() > 0) {
            this._userDefinedSeasonalRecordsExt.setUnitSystem(this.getUnitSystem());
            this._userDefinedSeasonalRecordsExt.setParameterId(-1);
            return this._userDefinedSeasonalRecordsExt;
        }
        this._seasonalPairedValues.setUnitSystem(this.getUnitSystem());
        this._seasonalPairedValues.setParamXId(-1);
        this._seasonalPairedValues.setParamYId(Parameter.PARAMID_ELEV);
        return this._seasonalPairedValues;
    }

    public SeasonalRecord getSeasonalRecord() {
        if (this._zoneElevation == null) {
            return null;
        }
        this._zoneElevation.setUnitSystem(this.getUnitSystem());
        int n = this._zoneTypeID == 0 ? Parameter.PARAMID_ELEV : Parameter.PARAMID_STOR;
        this._zoneElevation.setParameterId(n);
        return this._zoneElevation;
    }

    public synchronized Object clone() throws CloneNotSupportedException {
        try {
            StorageZone storageZone = (StorageZone)super.clone();
            if (this._independentVariable != null) {
                storageZone._independentVariable = (IndependentVariable)this._independentVariable.clone();
            }
            if (this._seasonalPairedValues != null) {
                storageZone._seasonalPairedValues = this._seasonalPairedValues.clone();
            }
            if (this._zoneElevation != null) {
                storageZone._zoneElevation = (SeasonalRecord)this._zoneElevation.clone();
            }
            storageZone.m_startYear = this.m_startYear;
            storageZone.m_unitSystem = this.m_unitSystem;
            storageZone.m_useMultiYearData = this.m_useMultiYearData;
            storageZone.m_useTimeSeries = this.m_useTimeSeries;
            storageZone._useRefElev = this._useRefElev;
            storageZone._referenceElevation = this._referenceElevation;
            storageZone._zoneObjectList = new ArrayList<ZoneObject>();
            int n = this._zoneObjectList.size();
            for (int i = 0; i < n; ++i) {
                ZoneObject zoneObject = this._zoneObjectList.get(i);
                zoneObject = (ZoneObject)zoneObject.clone();
                zoneObject.setParent(storageZone);
                storageZone._zoneObjectList.add(zoneObject);
            }
            storageZone.g = this.g;
            storageZone.h = this.h;
            storageZone.i = this.i;
            storageZone.j = this.j;
            storageZone.k = this.k;
            storageZone.l = this.l;
            storageZone.m = this.m;
            if (this.i != null) {
                storageZone.i = (ReverseReservoirYieldAnalysis)((YieldAnalysis)this.i).clone();
            }
            if (this.j != null) {
                storageZone.j = this.j.j();
            }
            return storageZone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Clone Exception", cloneNotSupportedException);
            return null;
        }
    }

    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            return super.setFieldObject(field, object);
        }
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, org.jdom.Element element) {
        AltInputReportInfc altInputReportInfc;
        Object object;
        element.setAttribute("Name", this.getDisplayName());
        element.setAttribute("Description", this.getDescription());
        element.setAttribute("Sort_Elevation", Double.toString(this._referenceElevation));
        org.jdom.Element element2 = new org.jdom.Element("IndependentVariable");
        this._independentVariable.outputReport(alternativeInputReport, element2);
        element.setAttribute("Function_Of", Integer.toString(this._independentVariable.getType()));
        if (this._independentVariable.getType() == 0) {
            element2 = new org.jdom.Element("Date");
            element.addContent((Content)element2);
            XMLUtilities.createArrayElements((org.jdom.Element)element2, (int[])this._zoneElevation.getTimeArray());
            element2 = new org.jdom.Element("Elevations");
            element.addContent((Content)element2);
            XMLUtilities.createArrayElements((org.jdom.Element)element2, (double[])this._zoneElevation.getDataArray());
        } else if (this._independentVariable.getType() == 1) {
            element2 = new org.jdom.Element("DateTime");
            element.addContent((Content)element2);
            XMLUtilities.createArrayElements((org.jdom.Element)element2, (int[])this._zoneElevation.getTimeArray());
            element2 = new org.jdom.Element("Elevations");
            element.addContent((Content)element2);
            XMLUtilities.createArrayElements((org.jdom.Element)element2, (double[])this._zoneElevation.getDataArray());
        } else if (this._independentVariable.getType() == 2) {
            element2 = new org.jdom.Element("ModelVariable");
            element.addContent((Content)element2);
            XMLUtilities.createArrayElements((org.jdom.Element)element2, (double[])this._userDefinedPairedValuesExt.getXArray());
            element2 = new org.jdom.Element("Elevations");
            element.addContent((Content)element2);
            XMLUtilities.createArrayElements((org.jdom.Element)element2, (double[])this._userDefinedPairedValuesExt.getYArray());
        } else if (this._independentVariable.getType() == 3 && !this._independentVariable.isTSOptChecked()) {
            element2 = new org.jdom.Element("TimeSeriesVariable");
            element.addContent((Content)element2);
            XMLUtilities.createArrayElements((org.jdom.Element)element2, (double[])this._userDefinedPairedValuesExt.getXArray());
            element2 = new org.jdom.Element("Elevations");
            element.addContent((Content)element2);
            XMLUtilities.createArrayElements((org.jdom.Element)element2, (double[])this._userDefinedPairedValuesExt.getYArray());
        } else if (this._independentVariable.getType() == 4) {
            element2 = new org.jdom.Element("StateVariable");
            element.addContent((Content)element2);
            XMLUtilities.createArrayElements((org.jdom.Element)element2, (double[])this._userDefinedPairedValuesExt.getXArray());
            element2 = new org.jdom.Element("Elevations");
            element.addContent((Content)element2);
            XMLUtilities.createArrayElements((org.jdom.Element)element2, (double[])this._userDefinedPairedValuesExt.getYArray());
        } else if (this._independentVariable.getType() == 6) {
            element2 = new org.jdom.Element("GlobalVariable");
            element.addContent((Content)element2);
            XMLUtilities.createArrayElements((org.jdom.Element)element2, (double[])this._userDefinedPairedValuesExt.getXArray());
            element2 = new org.jdom.Element("Elevations");
            element.addContent((Content)element2);
            XMLUtilities.createArrayElements((org.jdom.Element)element2, (double[])this._userDefinedPairedValuesExt.getYArray());
        } else if (this._independentVariable.getType() == 5) {
            object = this.getTVRowIndependentVariable();
            if (object != null) {
                element2 = new org.jdom.Element("RowVariable");
                element.addContent((Content)element2);
                ((IndependentVariable)object).outputReport(alternativeInputReport, element2);
            }
            if ((altInputReportInfc = this.getTVColIndependentVariable()) != null) {
                element2 = new org.jdom.Element("ColVariable");
                element.addContent((Content)element2);
                ((IndependentVariable)object).outputReport(alternativeInputReport, element2);
            }
        }
        if (alternativeInputReport.b().get((Object)AltInputReportEnums.RES_RULES).a()) {
            element2 = new org.jdom.Element("RuleRefsUsed");
            element.addContent((Content)element2);
            object = this.getRuleRefs(null);
            if (object != null) {
                for (int i = 0; i < object.size(); ++i) {
                    altInputReportInfc = (OpRuleRef)object.get(i);
                    element = new org.jdom.Element("RuleRef");
                    element2.addContent((Content)element);
                    ((OpRuleRef)altInputReportInfc).outputReport(alternativeInputReport, element);
                }
            }
        }
        if (alternativeInputReport.b().get((Object)AltInputReportEnums.RES_IF_THEN_ELSE).a()) {
            this.getConditionalBlockRefs(null);
        }
    }

    public ConditionalBlockRef getConditionalBlockRef(ConditionalBlock conditionalBlock) {
        List list = this.getConditionalBlockRefs(null);
        for (int i = 0; i < list.size(); ++i) {
            ConditionalBlockRef conditionalBlockRef = (ConditionalBlockRef)list.get(i);
            if (conditionalBlockRef.getConditionalBlock() != conditionalBlock) continue;
            return conditionalBlockRef;
        }
        return null;
    }

    public void setRuleDisabled(OpRule opRule, boolean bl) {
        int n = this._zoneObjectList.size();
        for (int i = 0; i < n; ++i) {
            ZoneObject zoneObject = this._zoneObjectList.get(i);
            if (zoneObject == null || !(zoneObject instanceof OpRuleRef) || !((OpRuleRef)(zoneObject = (OpRuleRef)zoneObject)).getRule().getName().equalsIgnoreCase(opRule.getName()) && ((OpRuleRef)zoneObject).getRule() != opRule) continue;
            ((OpRuleRef)zoneObject).setDisabled(bl);
        }
    }

    public void setRuleDisabled(OpRuleRef opRuleRef, boolean bl) {
        int n = this._zoneObjectList.size();
        for (int i = 0; i < n; ++i) {
            ZoneObject zoneObject = this._zoneObjectList.get(i);
            if (zoneObject == null || !(zoneObject instanceof OpRuleRef) || (zoneObject = (OpRuleRef)zoneObject) != opRuleRef) continue;
            ((OpRuleRef)zoneObject).setDisabled(bl);
        }
    }

    public void setIfBlockDisabled(ConditionalBlock conditionalBlock, boolean bl) {
        this._zoneObjectList.size();
        for (ZoneObject zoneObject : this._zoneObjectList) {
            if (zoneObject == null || !(zoneObject instanceof ConditionalBlockRef)) continue;
            zoneObject = (ConditionalBlockRef)zoneObject;
            ConditionalBlock conditionalBlock2 = ((ConditionalBlockRef)zoneObject).getConditionalBlock();
            this.setIfBlockDisabled(conditionalBlock2, conditionalBlock, bl);
            if (((ConditionalBlockRef)zoneObject).getConditionalBlock() != conditionalBlock) continue;
            ((ConditionalBlockRef)zoneObject).setDisabled(bl);
        }
    }

    private void setIfBlockDisabled(ConditionalBlock object, ConditionalBlock conditionalBlock, boolean bl) {
        object = object.getConditionals();
        for (int i = 0; i < object.size(); ++i) {
            RssConditional rssConditional = (RssConditional)object.get(i);
            List<ConditionalBlockRef> list = rssConditional.getConditionalBlockRefs(null);
            if (list == null) {
                return;
            }
            for (int j = 0; j < list.size(); ++j) {
                ConditionalBlockRef conditionalBlockRef = list.get(j);
                rssConditional = conditionalBlockRef.getConditionalBlock();
                if (rssConditional == conditionalBlock) {
                    conditionalBlockRef.setDisabled(bl);
                    continue;
                }
                this.setIfBlockDisabled((ConditionalBlock)rssConditional, conditionalBlock, bl);
            }
        }
    }
}

