/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.heclib.util.intContainer;
import hec.lang.NamedType;
import hec.model.ConditionalBlock;
import hec.model.RunTimeStep;
import hec.rss.model.ConditionalBlockRef;
import hec.rss.model.OpControllerZones;
import hec.rss.model.OpRule;
import hec.rss.model.OpRuleRef;
import hec.rss.model.OpSet;
import hec.rss.model.StorageZone;
import hec.rss.model.ZoneObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import rma.util.RMASort;

public class StorageZoneRules
extends NamedType
implements Cloneable {
    OpControllerZones _controllerZones;
    OpSet _opSet;
    int _zoneIndex;
    Hashtable _opRuleTable = new Hashtable();
    private transient StorageZone a;
    private transient intContainer b = new intContainer();
    private transient Vector c;

    public StorageZoneRules() {
    }

    public StorageZoneRules(OpControllerZones opControllerZones, StorageZone storageZone) {
        this._controllerZones = opControllerZones;
        if (storageZone != null) {
            this._zoneIndex = storageZone.getIndex();
            this.a = storageZone;
        }
        this._opSet = this._controllerZones.getOpSet();
    }

    public StorageZoneRules(OpSet opSet, StorageZone storageZone) {
        this._opSet = opSet;
        if (storageZone != null) {
            this._zoneIndex = storageZone.getIndex();
            this.a = storageZone;
        }
    }

    public OpSet getOpSet() {
        return this._opSet;
    }

    public void setOpSet(OpSet opSet) {
        this._opSet = opSet;
    }

    public void removeRuleRef(int n) {
        if (this.b == null) {
            this.b = new intContainer();
        }
        this.b.value = n;
        this._opRuleTable.remove(this.b);
        Enumeration enumeration = this._opRuleTable.elements();
        while (enumeration.hasMoreElements()) {
            ZoneObject zoneObject = (ZoneObject)enumeration.nextElement();
            zoneObject.removeRuleRef(n);
        }
        this.setModified(true);
    }

    public OpControllerZones getOpControllerZones() {
        return this._controllerZones;
    }

    public Vector getSortedZoneRuleRefs() {
        return this.getSortedZoneRuleRefs(true);
    }

    public ZoneObject removeZoneObject(int n) {
        if (this.b == null) {
            this.b = new intContainer();
        }
        this.b.value = n;
        ZoneObject zoneObject = (ZoneObject)this._opRuleTable.remove(this.b);
        this.setModified(true);
        return zoneObject;
    }

    public List getActiveRuleRefs(RunTimeStep runTimeStep) {
        this._opRuleTable.size();
        Vector vector = new Vector();
        ArrayList<Float> arrayList = new ArrayList<Float>();
        Enumeration enumeration = this._opRuleTable.elements();
        while (enumeration.hasMoreElements()) {
            Object object = (ZoneObject)enumeration.nextElement();
            object = object.getActiveRuleRefs(runTimeStep);
            vector.addAll(object);
            for (int i = 0; i < object.size(); ++i) {
                OpRuleRef opRuleRef = (OpRuleRef)object.get(i);
                arrayList.add(new Float(opRuleRef.getPriority()));
            }
        }
        RMASort.quickSort(arrayList, vector, (boolean)true);
        return vector;
    }

    public List getSortedZoneObjects(boolean bl) {
        int n = this._opRuleTable.size();
        this.c = new Vector(n);
        ArrayList<Float> arrayList = new ArrayList<Float>(n);
        Enumeration enumeration = this._opRuleTable.elements();
        while (enumeration.hasMoreElements()) {
            ZoneObject zoneObject = (ZoneObject)enumeration.nextElement();
            this.c.add(zoneObject);
            arrayList.add(new Float(zoneObject.getPriority()));
        }
        RMASort.quickSort(arrayList, (List)this.c, (boolean)bl);
        return this.c;
    }

    public List getSortedConditionalBlockRefs(boolean bl) {
        Vector<ZoneObject> vector = new Vector<ZoneObject>();
        int n = this._opRuleTable.size();
        ArrayList<Float> arrayList = new ArrayList<Float>(n);
        Enumeration enumeration = this._opRuleTable.elements();
        while (enumeration.hasMoreElements()) {
            ZoneObject zoneObject = (ZoneObject)enumeration.nextElement();
            if (!(zoneObject instanceof ConditionalBlockRef)) continue;
            vector.add(zoneObject);
            arrayList.add(new Float(zoneObject.getPriority()));
        }
        RMASort.quickSort(arrayList, vector, (boolean)bl);
        return vector;
    }

    public Vector getSortedZoneRuleRefs(boolean bl) {
        int n = this._opRuleTable.size();
        Vector vector = new Vector(n);
        ArrayList<Float> arrayList = new ArrayList<Float>(n);
        Enumeration enumeration = this._opRuleTable.elements();
        while (enumeration.hasMoreElements()) {
            Object object = (ZoneObject)enumeration.nextElement();
            object = object.getRuleRefs();
            vector.addAll(object);
            for (int i = 0; object != null && i < object.size(); ++i) {
                OpRuleRef opRuleRef = (OpRuleRef)object.get(i);
                arrayList.add(new Float(opRuleRef.getPriority()));
            }
        }
        RMASort.quickSort(arrayList, vector, (boolean)bl);
        return vector;
    }

    public Vector getZoneRuleRefs(Vector vector) {
        if (vector == null) {
            vector = new Vector();
        }
        Enumeration enumeration = this._opRuleTable.elements();
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        return vector;
    }

    public OpRuleRef addRule(OpRule opRule) {
        int n = 0;
        Enumeration enumeration = this._opRuleTable.elements();
        while (enumeration.hasMoreElements()) {
            int n2;
            ZoneObject zoneObject = (ZoneObject)enumeration.nextElement();
            if (zoneObject == null || n > (n2 = (int)Math.ceil(zoneObject.getPriority()))) continue;
            n = n2 + 1;
        }
        return this.addRule(opRule, n);
    }

    public OpRuleRef addRule(OpRule opRule, int n) {
        if (opRule == null) {
            return null;
        }
        if (this.b == null) {
            this.b = new intContainer();
        }
        this.b.value = opRule.getIndex();
        OpRuleRef opRuleRef = (OpRuleRef)this._opRuleTable.get(this.b);
        if (opRuleRef == null) {
            opRuleRef = new OpRuleRef();
            opRuleRef.setRule(opRule);
            opRuleRef.setPriority(n);
            this._opRuleTable.put(new intContainer(opRule.getIndex()), opRuleRef);
            this.setModified(true);
        }
        return opRuleRef;
    }

    public ConditionalBlockRef addConditionalBlock(ConditionalBlock conditionalBlock) {
        int n = 0;
        Enumeration enumeration = this._opRuleTable.elements();
        while (enumeration.hasMoreElements()) {
            int n2;
            ZoneObject zoneObject = (ZoneObject)enumeration.nextElement();
            if (zoneObject == null || n > (n2 = (int)Math.ceil(zoneObject.getPriority()))) continue;
            n = n2 + 1;
        }
        return this.addConditionalBlock(conditionalBlock, n);
    }

    public ConditionalBlockRef addConditionalBlock(ConditionalBlock conditionalBlock, int n) {
        if (conditionalBlock == null) {
            return null;
        }
        if (this.b == null) {
            this.b = new intContainer();
        }
        this.b.value = conditionalBlock.getIndex();
        ConditionalBlockRef conditionalBlockRef = (ConditionalBlockRef)this._opRuleTable.get(this.b);
        if (conditionalBlockRef == null) {
            conditionalBlockRef = new ConditionalBlockRef(this, conditionalBlock, n);
            this._opRuleTable.put(new intContainer(conditionalBlock.getIndex()), conditionalBlockRef);
            this.setModified(true);
        }
        return conditionalBlockRef;
    }

    public ConditionalBlockRef removeCondtionalBlockRef(int n) {
        return (ConditionalBlockRef)this.removeZoneObject(n);
    }

    public void setOpControllerZone(OpControllerZones opControllerZones) {
        if (opControllerZones == null) {
            return;
        }
        this._controllerZones = opControllerZones;
    }

    public int getStorageZoneIndex() {
        return this._zoneIndex;
    }

    public synchronized Object clone() {
        try {
            StorageZoneRules storageZoneRules = (StorageZoneRules)super.clone();
            ((StorageZoneRules)super.clone())._controllerZones = this._controllerZones;
            storageZoneRules._zoneIndex = this._zoneIndex;
            Enumeration enumeration = this._opRuleTable.keys();
            storageZoneRules._opRuleTable = new Hashtable();
            while (enumeration.hasMoreElements()) {
                intContainer intContainer2 = (intContainer)enumeration.nextElement();
                ZoneObject zoneObject = (ZoneObject)this._opRuleTable.get(intContainer2);
                ZoneObject zoneObject2 = (ZoneObject)zoneObject.clone();
                if (zoneObject == null) continue;
                storageZoneRules._opRuleTable.put(new intContainer(intContainer2.value), zoneObject2);
            }
            return storageZoneRules;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public OpRuleRef getOpRuleRef(int n) {
        if (this.b == null) {
            this.b = new intContainer();
        }
        this.b.value = n;
        return (OpRuleRef)this._opRuleTable.get(this.b);
    }

    Hashtable getOpRuleTable() {
        return this._opRuleTable;
    }

    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }
}

