/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.heclib.util.HecTime;
import hec.io.AsciiSerializable;
import hec.model.RunTimeStep;
import hec.model.RunTimeWindow;
import hec.rss.model.reports.AltInputReportInfc;
import hec.rss.model.reports.AlternativeInputReport;
import hec.util.XMLUtilities;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.TimeZone;
import org.jdom.Content;
import org.jdom.Element;
import rma.lang.RmaMath;

public class SunriseSunsetModel
implements AsciiSerializable,
AltInputReportInfc {
    int[] m_date;
    double[] m_afterSunset;
    double[] m_beforeSunrise;
    int[] m_noUnits;
    double m_latitude = Double.NEGATIVE_INFINITY;
    double m_longitude = Double.NEGATIVE_INFINITY;
    private transient double[] a = new double[1];
    private transient double[] b = new double[1];
    HecTime filterTime = null;

    public double getLongitude() {
        return this.m_longitude;
    }

    public void setLongitude(double d) {
        this.m_longitude = d;
    }

    public double getLatitude() {
        return this.m_latitude;
    }

    public void setLatitude(double d) {
        this.m_latitude = d;
    }

    public int getNumberValues() {
        if (this.m_date == null) {
            return 0;
        }
        return this.m_date.length;
    }

    public void setNumberValues(int n) {
        this.m_date = this.resize(this.m_date, n);
        this.m_afterSunset = this.resize(this.m_afterSunset, n);
        this.m_beforeSunrise = this.resize(this.m_beforeSunrise, n);
        this.m_noUnits = this.resize(this.m_noUnits, n);
    }

    private int[] resize(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        Arrays.fill(nArray2, Integer.MIN_VALUE);
        for (int i = 0; i < n && nArray != null && i < nArray.length; ++i) {
            nArray2[i] = nArray[i];
        }
        return nArray2;
    }

    private double[] resize(double[] dArray, int n) {
        double[] dArray2 = new double[n];
        for (int i = 0; i < n && dArray != null && i < dArray.length; ++i) {
            dArray2[i] = dArray[i];
        }
        return dArray2;
    }

    public void setValueAt(int n, int n2, double d, double d2, int n3) {
        if (n < 0) {
            return;
        }
        if (n >= this.getNumberValues()) {
            this.setNumberValues(n + 1);
        }
        this.m_date[n] = n2;
        this.m_afterSunset[n] = d;
        this.m_beforeSunrise[n] = d2;
        this.m_noUnits[n] = n3;
    }

    public int getDateAt(int n) {
        if (n < 0 || n >= this.m_date.length) {
            return Integer.MIN_VALUE;
        }
        return this.m_date[n];
    }

    public double getAfterSunsetAt(int n) {
        if (n < 0 || n >= this.m_afterSunset.length) {
            return -1.0;
        }
        return this.m_afterSunset[n];
    }

    public double getBeforeSunriseAt(int n) {
        if (n < 0 || n >= this.m_beforeSunrise.length) {
            return -1.0;
        }
        return this.m_beforeSunrise[n];
    }

    public int getNumOfUnitsAt(int n) {
        if (n < 0 || n >= this.m_noUnits.length) {
            return -1;
        }
        return this.m_noUnits[n];
    }

    public boolean getPumpInterval(RunTimeStep runTimeStep, TimeZone timeZone, int[] nArray, int[] nArray2) {
        int n;
        if (this.m_date == null || this.m_date.length == 0) {
            return false;
        }
        int n2 = runTimeStep.getHecTime().dayOfYear();
        int n3 = this.intervalTime(runTimeStep);
        RmaMath.computeSunriseSunset((int)n2, (double)this.m_latitude, (double)this.m_longitude, (TimeZone)timeZone, (double[])this.a, (double[])this.b);
        int n4 = -1;
        n2 = -1;
        if (n3 < this.m_date[0]) {
            n4 = this.m_date[this.m_date.length - 1];
            n2 = this.m_date.length - 1;
        }
        for (n = this.getNumberValues() - 1; n4 == -1 && n >= 0; --n) {
            if (n3 < this.m_date[n]) continue;
            n4 = this.m_date[n];
            n2 = n;
        }
        if (n4 == -1) {
            return false;
        }
        n = (int)(this.m_afterSunset[n2] * 60.0 + this.b[0] * 60.0);
        if (n > 1440) {
            n -= 1440;
        }
        if ((n3 = (int)(this.a[0] * 60.0 - this.m_beforeSunrise[n2] * 60.0)) <= 0) {
            n3 += 1440;
        }
        nArray[0] = n;
        nArray2[0] = n3;
        return true;
    }

    public boolean isInPumpingPeriod(RunTimeStep runTimeStep, TimeZone timeZone) {
        if (this.m_date == null || this.m_date.length == 0) {
            return false;
        }
        int n = runTimeStep.getHecTime().dayOfYear();
        int n2 = this.intervalTime(runTimeStep);
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        RmaMath.computeSunriseSunset((int)n, (double)this.m_latitude, (double)this.m_longitude, (TimeZone)timeZone, (double[])dArray, (double[])dArray2);
        int n3 = -1;
        n = -1;
        if (n2 < this.m_date[0]) {
            n3 = this.m_date[this.m_date.length - 1];
            n = this.m_date.length - 1;
        }
        for (int i = this.getNumberValues() - 1; n3 == -1 && i >= 0; --i) {
            if (n2 < this.m_date[i]) continue;
            n3 = this.m_date[i];
            n = i;
        }
        if (n3 == -1) {
            return false;
        }
        double d = this.m_afterSunset[n] * 60.0 + dArray2[0] * 60.0;
        n2 = n3 + (int)d;
        if (d >= 1440.0) {
            d -= 1440.0;
        }
        double d2 = dArray[0] * 60.0 - this.m_beforeSunrise[n] * 60.0;
        n3 = n3 + 1440 + (int)d2;
        if (d2 < 0.0) {
            d2 += 1440.0;
        }
        new HecTime(n2, 1);
        new HecTime(n3, 1);
        int n4 = runTimeStep.getHecTime().minutesSinceMidnight();
        return (double)n4 >= d || (double)n4 < d2;
    }

    private int computeIndex(RunTimeStep runTimeStep, TimeZone timeZone) {
        if (this.m_date == null || this.m_date.length == 0) {
            return -1;
        }
        if (this.filterTime == null) {
            this.filterTime = new HecTime();
        }
        int n = this.intervalTime(runTimeStep);
        int n2 = -1;
        if (n < this.m_date[0]) {
            n2 = this.m_date.length - 1;
        }
        this.filterTime.set(n);
        n = this.filterTime.dayOfYear();
        for (int i = this.getNumberValues() - 1; n2 == -1 && i >= 0; --i) {
            this.filterTime.set(this.m_date[i]);
            int n3 = this.filterTime.dayOfYear() + 1;
            int n4 = n3 = n3 > 365 ? n3 - 365 : n3;
            if (n < n3) continue;
            n2 = i;
        }
        return n2;
    }

    public int computePumpingWindow(RunTimeStep runTimeStep, TimeZone timeZone) {
        int n = this.computeIndex(runTimeStep, timeZone);
        if (n == -1) {
            return 0;
        }
        int n2 = runTimeStep.getHecTime().dayOfYear();
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        RmaMath.computeSunriseSunset((int)n2, (double)this.m_latitude, (double)this.m_longitude, (TimeZone)timeZone, (double[])dArray, (double[])dArray2);
        int n3 = n + 1;
        if (n3 >= this.m_date.length) {
            n3 = 0;
        }
        n2 = (int)((double)this.m_date[n] + this.m_afterSunset[n] * 60.0 + dArray2[0] * 60.0);
        HecTime hecTime = new HecTime(n2, 1);
        HecTime hecTime2 = new HecTime((int)((double)this.m_date[n3] - this.m_beforeSunrise[n3] * 60.0 + dArray[0] * 60.0), 1);
        boolean bl = hecTime2.dayOfYear() - 1 == runTimeStep.getHecTime().dayOfYear();
        if (!bl || runTimeStep.getHecTime().minutesSinceMidnight() < hecTime.minutesSinceMidnight()) {
            hecTime2.set((int)((double)this.m_date[n] - this.m_beforeSunrise[n] * 60.0 + dArray[0] * 60.0));
        } else {
            System.out.print("");
        }
        if (hecTime.dayOfYear() == runTimeStep.getHecTime().dayOfYear() && runTimeStep.getHecTime().minutesSinceMidnight() <= hecTime2.minutesSinceMidnight()) {
            if (--n < 0) {
                n = this.m_date.length - 1;
            }
            hecTime.set((int)((double)this.m_date[n] + this.m_afterSunset[n] * 60.0 + dArray2[0] * 60.0));
        }
        int n4 = runTimeStep.getHecTime().minutesSinceMidnight();
        n = hecTime.minutesSinceMidnight();
        int n5 = hecTime2.minutesSinceMidnight();
        if (n4 < n && n4 > n5) {
            return 0;
        }
        n4 = (n5 += 1440) - n;
        return n4 / 60;
    }

    public int computeHoursLeftInPumpingTime(RunTimeStep runTimeStep, TimeZone timeZone) {
        int n;
        double d;
        double d2;
        int n2 = this.computeIndex(runTimeStep, timeZone);
        if (n2 == -1) {
            return 0;
        }
        int n3 = runTimeStep.getHecTime().dayOfYear();
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        RmaMath.computeSunriseSunset((int)n3, (double)this.m_latitude, (double)this.m_longitude, (TimeZone)timeZone, (double[])dArray, (double[])dArray2);
        int n4 = n2 + 1;
        if (n4 >= this.m_date.length) {
            n4 = 0;
        }
        new HecTime(this.m_date[n2], 1);
        HecTime hecTime = new HecTime(this.m_date[n4], 1);
        if (hecTime.dayOfYear() != runTimeStep.getHecTime().dayOfYear()) {
            n4 = n2;
        }
        double d3 = this.m_afterSunset[n2] * 60.0 + dArray2[0] * 60.0;
        if (d2 >= 1440.0) {
            d3 -= 1440.0;
        }
        double d4 = dArray[0] * 60.0 - this.m_beforeSunrise[n4] * 60.0;
        if (d < 0.0) {
            d4 += 1440.0;
        }
        int cfr_ignored_0 = this.m_date[n2];
        int cfr_ignored_1 = this.m_date[n4];
        int n5 = runTimeStep.getHecTime().minutesSinceMidnight();
        if ((double)n < d3 && (double)n5 > d4) {
            return 0;
        }
        n4 = (int)d4;
        if (n5 > n4) {
            n4 += 1440;
        }
        n5 = n4 - n5;
        return n5 / 60;
    }

    public int getNumUnitsAtTime(RunTimeStep runTimeStep) {
        int n = this.intervalTime(runTimeStep);
        if (this.getNumberValues() == 0) {
            return 0;
        }
        if (n < this.m_date[0] || n >= this.m_date[this.m_date.length - 1]) {
            return this.m_noUnits[this.m_noUnits.length - 1];
        }
        for (int i = this.getNumberValues() - 1; i >= 0; --i) {
            if (n < this.m_date[i]) continue;
            return this.m_noUnits[i];
        }
        return 0;
    }

    public static void a(String[] object) {
        object = new double[1];
        Object object2 = new double[1];
        RmaMath.computeSunriseSunset((int)new HecTime("16JAN04").dayOfYear(), (double)38.5314622, (double)-121.7864906, (TimeZone)TimeZone.getDefault(), (double[])object, (double[])object2);
        String string = "AM";
        int n = 0;
        if (object[0] > 12.0) {
            string = "PM";
            object[0] = object[0] - 12.0;
            n = (int)((object[0] - (double)((int)object[0])) * 60.0);
        }
        Object object3 = n != 0 ? "" + n : "00";
        System.out.println("Sunrise = " + (int)object[0] + ":" + (String)object3 + " " + string);
        string = "AM";
        if (object2[0] > 12.0) {
            string = "PM";
            object2[0] = object2[0] - 12.0;
            n = (int)((object2[0] - (double)((int)object2[0])) * 60.0);
        }
        object3 = n != 0 ? "" + n : "00";
        System.out.println("Sunset = " + (int)object2[0] + ":" + (String)object3 + " " + string);
        object = new SunriseSunsetModel();
        ((SunriseSunsetModel)object).setLatitude(38.0);
        ((SunriseSunsetModel)object).setLongitude(-122.0);
        ((SunriseSunsetModel)object).setNumberValues(2);
        ((SunriseSunsetModel)object).setValueAt(0, 0, 3.0, 2.0, 2);
        RunTimeWindow runTimeWindow = new RunTimeWindow(new HecTime("11Feb2004"), new HecTime("19Feb2004"), new HecTime("10Feb2004"));
        object2 = runTimeWindow;
        runTimeWindow.setTimeStep(1, 2);
        string = new RunTimeStep((RunTimeWindow)object2);
        TimeZone timeZone = TimeZone.getDefault();
        for (int i = 0; i < object2.getNumSteps(); ++i) {
            string.setStep(i);
            ((SunriseSunsetModel)object).isInPumpingPeriod((RunTimeStep)string, timeZone);
        }
    }

    int intervalTime(RunTimeStep runTimeStep) {
        if ((runTimeStep = runTimeStep.getHecTime()) == null) {
            return 0;
        }
        int n = 0 + runTimeStep.dayOfYear() * 1440 + runTimeStep.minutesSinceMidnight();
        return n;
    }

    public Object getFieldObject(Field object) {
        try {
            object = ((Field)object).get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, Element element) {
        alternativeInputReport = new Element("Dates");
        element.addContent((Content)alternativeInputReport);
        XMLUtilities.createArrayElements((Element)alternativeInputReport, (int[])this.m_date);
        alternativeInputReport = new Element("AfterSS");
        element.addContent((Content)alternativeInputReport);
        XMLUtilities.createArrayElements((Element)alternativeInputReport, (double[])this.m_afterSunset);
        alternativeInputReport = new Element("BeforeSunrise");
        element.addContent((Content)alternativeInputReport);
        XMLUtilities.createArrayElements((Element)alternativeInputReport, (double[])this.m_beforeSunrise);
        alternativeInputReport = new Element("NoUnits");
        element.addContent((Content)alternativeInputReport);
        XMLUtilities.createArrayElements((Element)alternativeInputReport, (int[])this.m_noUnits);
        element.setAttribute("Latitude", Double.toString(this.m_latitude));
        element.setAttribute("Longitude", Double.toString(this.m_longitude));
    }
}

