/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.heclib.util.doubleArrayContainer;
import hec.model.RunTimeStep;
import hec.model.RunTimeWindow;
import hec.model.SeasonalRecord;
import hec.rss.model.DaysOfWeek;
import hec.rss.model.DemandRuleInf;
import hec.rss.model.OpRule;
import hec.rss.model.OpValue;
import hec.rss.model.PowerGenerationOptions;
import hec.rss.model.PowerGenerationPatternContainer;
import hec.rss.model.PowerPlant;
import hec.rss.model.ReservoirElement;
import hec.rss.model.ReservoirOp;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.SystemHydropowerRule;
import hec.rss.model.WaterAccount;
import hec.rss.model.reports.AlternativeInputReport;
import hec.util.XMLUtilities;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.jdom.Content;
import org.jdom.Element;
import rma.util.RMAConst;

public class SystemHydropowerOpRule
extends OpRule
implements DemandRuleInf,
PowerGenerationOptions {
    boolean _contributeStorageOnly = false;
    boolean _passThruOnly = false;
    private transient doubleArrayContainer a;
    private transient doubleArrayContainer b;
    private transient boolean c = true;
    private transient boolean d = false;
    public static final int LOCAL_GENERATION = 0;
    public static final int SPECIFY_GENERATION = 1;
    private transient int e = 0;
    private transient PowerGenerationPatternContainer f = new PowerGenerationPatternContainer();
    private transient Hashtable<Object, PowerGenerationPatternContainer> i = null;
    private transient double[] j = new double[12];
    private transient SeasonalRecord k = new SeasonalRecord();
    private transient int l = 0;
    private transient int m = 10;
    private transient int n = 0;
    private transient int o = 0;
    private transient int p = 0;
    private transient int q = 0;
    private transient int[] r = new int[0];
    private transient WaterAccount s;
    int m_parentRuleIndex = Integer.MIN_VALUE;
    private transient SystemHydropowerRule t;
    private transient boolean u = false;

    public SystemHydropowerOpRule() {
        this.createDefaultData();
    }

    public SystemHydropowerOpRule(String string) {
        super(string);
        this.createDefaultData();
    }

    @Override
    public void getElementDependencies(List list) {
        Object object = this.getParentRule();
        if (object == null) {
            return;
        }
        RssSystem rssSystem = ((RssTSLocationObject)this).getSystem();
        ReservoirElement reservoirElement = (ReservoirElement)this.getOperationsElement();
        object = ((SystemHydropowerRule)object).getReservoirSystemIndicies();
        for (int i = 0; i < ((Object)object).length; ++i) {
            ReservoirElement reservoirElement2;
            if (object[i] == reservoirElement.getIndex() || (reservoirElement2 = rssSystem.findReservoir((int)object[i])) == null || list.contains(reservoirElement2)) continue;
            list.add(reservoirElement2);
        }
    }

    public SystemHydropowerRule getParentRule() {
        if (this.t == null) {
            this.t = ((RssTSLocationObject)this).getSystem().getSystemHydropowerRule(this.getParentRuleIndex());
        }
        return this.t;
    }

    @Override
    public void evaluateLimits(RunTimeStep runTimeStep, int n) {
    }

    public void setEnergyRequirement(RunTimeStep runTimeStep, double d) {
        this.b.array[runTimeStep.step] = d;
    }

    public void setFlowRequirement(RunTimeStep runTimeStep, double d) {
        if (this.h != null) {
            this.h.array[runTimeStep.step] = d;
        }
    }

    @Override
    public OpValue getOpValue(RunTimeStep runTimeStep) {
        if (this.h == null) {
            return null;
        }
        double d = this.b.array[runTimeStep.step];
        double d2 = this.h.array[runTimeStep.step];
        double d3 = Double.NEGATIVE_INFINITY;
        if (!this._contributeStorageOnly && RMAConst.isValidValue((double)d) && !this.u) {
            d3 = d / (double)runTimeStep.getTimeStepMinutes() * 60.0;
        }
        this.a.array[runTimeStep.step] = d3;
        int n = ((ReservoirOp)this.getController().getElementOp()).getNumDecisionSteps();
        for (int i = 0; i < n; ++i) {
            if (runTimeStep.step + i >= this.a.array.length) continue;
            this.a.array[runTimeStep.step + i] = d3;
        }
        if (!RMAConst.isValidValue((double)d2)) {
            return null;
        }
        OpValue opValue = new OpValue();
        new OpValue().type = 0;
        if (Boolean.getBoolean("RSSYSPOWSPEC")) {
            opValue.type = 1;
        }
        opValue.value = d2;
        return opValue;
    }

    @Override
    public OpValue getPowerOpValue(RunTimeStep runTimeStep) {
        if (this.h == null) {
            return null;
        }
        double d = this.b.array[runTimeStep.step];
        double cfr_ignored_0 = this.h.array[runTimeStep.step];
        double d2 = Double.NEGATIVE_INFINITY;
        if (!this._contributeStorageOnly && RMAConst.isValidValue((double)d) && !this.u) {
            d2 = d / (double)runTimeStep.getTimeStepMinutes() * 60.0;
        }
        this.a.array[runTimeStep.step] = d2;
        int n = this.getController().getReservoirOp().getNumDecisionSteps();
        for (int i = 0; i < n; ++i) {
            if (runTimeStep.step + i >= this.a.array.length) continue;
            this.a.array[runTimeStep.step + i] = d2;
        }
        if (!RMAConst.isValidValue((double)d2)) {
            return null;
        }
        OpValue opValue = new OpValue();
        new OpValue().type = 0;
        if (Boolean.getBoolean("RSSYSPOWSPEC")) {
            opValue.type = 1;
        }
        opValue.value = d2;
        return opValue;
    }

    public int getMaxPeriodSteps() {
        SystemHydropowerRule systemHydropowerRule = this.getParentRule();
        if (systemHydropowerRule == null) {
            return 0;
        }
        return systemHydropowerRule.getPeriodSteps();
    }

    public boolean useEnergyRequiredTimeSeries() {
        SystemHydropowerRule systemHydropowerRule = this.getParentRule();
        if (systemHydropowerRule == null) {
            return false;
        }
        return systemHydropowerRule.useEnergyRequiredTimeSeries();
    }

    public void setUseEnergyRequiredTimeSeries(boolean bl) {
        SystemHydropowerRule systemHydropowerRule = this.getParentRule();
        if (systemHydropowerRule == null) {
            return;
        }
        systemHydropowerRule.setUseEnergyRequiredTimeSeries(bl);
    }

    public boolean getContributeStorageOnly() {
        return this._contributeStorageOnly;
    }

    public boolean getPassThruOnly() {
        return this._passThruOnly;
    }

    public void setContributeStorageOnly(boolean bl) {
        this._contributeStorageOnly = bl;
    }

    public void setPassThruOnly(boolean bl) {
        this._passThruOnly = bl;
    }

    @Override
    public boolean isLocalRule() {
        return false;
    }

    @Override
    public boolean isDnstrmRule() {
        return false;
    }

    @Override
    public boolean isPerAvgRule() {
        return true;
    }

    public int getDailyGenerationPattern() {
        return this.e;
    }

    public void setDailyGenerationPattern(int n) {
        this.e = n;
    }

    @Override
    public boolean initializeCompute() {
        PowerPlant[] powerPlantArray = (PowerPlant[])this._controller.getElementOp().getOperationsElement();
        RssSystem rssSystem = powerPlantArray.getSystem();
        this.a = null;
        this.b = null;
        this.t = null;
        super.initializeCompute();
        this.getParentRule();
        if (this.t == null) {
            rssSystem.printErrorMessage("SystemHydroPowerOpRule.initializeCompute: failed to find parent SystemHydropowerRule for rule " + this.getName());
            return false;
        }
        SystemHydropowerOpRule systemHydropowerOpRule = this;
        this.t.addChildRule(systemHydropowerOpRule, systemHydropowerOpRule.getOperationsElement().getIndex());
        this.a = this.getTSContainer(this.getTSProxyName(), 58);
        this.b = this.getTSContainer(this.getTSProxyName(), 59);
        if (this.a == null || this.b == null) {
            rssSystem.printErrorMessage("SystemHydropowerOpRule: failed to get output power or energy time series container");
            return false;
        }
        if ((powerPlantArray = powerPlantArray.getPowerPlants()) == null || powerPlantArray.length <= 0) {
            this.u = true;
        }
        return true;
    }

    @Override
    public OpValue evaluateRule(RunTimeStep runTimeStep, double d, int n, boolean bl) {
        return null;
    }

    @Override
    public void evaulatePerformance(RunTimeWindow runTimeWindow) {
        SystemHydropowerRule systemHydropowerRule = ((RssTSLocationObject)this).getSystem().getSystemHydropowerRule(this.getParentRuleIndex());
        if (systemHydropowerRule == null) {
            return;
        }
        ((OpRule)systemHydropowerRule).evaulatePerformance(runTimeWindow);
    }

    public int getParentRuleIndex() {
        return this.m_parentRuleIndex;
    }

    public void setParentRuleIndex(int n) {
        this.m_parentRuleIndex = n;
    }

    public int[] getReservoirIndexArray() {
        if (this.r == null) {
            return null;
        }
        int cfr_ignored_0 = this.r.length;
        int[] nArray = new int[this.r.length];
        System.arraycopy(this.r, 0, nArray, 0, this.r.length);
        return nArray;
    }

    public void setReservoirIndexArray(int[] nArray) {
        if (nArray == null) {
            this.r = new int[0];
            return;
        }
        this.r = new int[nArray.length];
        System.arraycopy(nArray, 0, this.r, 0, this.r.length);
    }

    @Override
    public int getStartingDay() {
        return this.n;
    }

    @Override
    public void setStartingDay(int n) {
        if (!DaysOfWeek.d(n)) {
            throw new IllegalArgumentException("Invalid Day being set in SystemHydropowerOpRule.setStartingDay()");
        }
        this.n = n;
    }

    @Override
    public int getDayBelongsToTerm() {
        return this.o;
    }

    @Override
    public void setDayBelongsToTerm(int n) {
        if (!DaysOfWeek.d(n)) {
            throw new IllegalArgumentException("Invalid Day being set in SystemHydropowerOpRule.setDayBelongsToTerm()");
        }
        this.o = n;
    }

    @Override
    public int getStartDayOfPeriod() {
        return this.p;
    }

    @Override
    public void setStartDayOfPeriod(int n) {
        if (!DaysOfWeek.d(n)) {
            throw new IllegalArgumentException("Invalid Day being set in SystemHydropowerOpRule.setStartDayOfPeriod()");
        }
        this.p = n;
    }

    private void createDefaultData() {
        Arrays.fill(this.j, Double.NEGATIVE_INFINITY);
    }

    @Override
    public int getGenerationPeriod() {
        return this.q;
    }

    @Override
    public void setGenerationPeriod(int n) {
        if (n != 1 && n != 0 && n != 2) {
            throw new IllegalArgumentException("Invalid geration period in SystemHydropowerOprRule.setGenerationPeriod()");
        }
        this.q = n;
    }

    public double[] getMonthlyPowerRequirement() {
        double[] dArray = new double[this.j.length];
        System.arraycopy(this.j, 0, dArray, 0, this.j.length);
        return dArray;
    }

    public void setMonthlyPowerRequirement(double[] dArray) {
        if (dArray == null) {
            return;
        }
        System.arraycopy(dArray, 0, this.j, 0, dArray.length <= this.j.length ? dArray.length : this.j.length);
    }

    public SeasonalRecord getSeasonalPowerRequirement() {
        this.k.setUnitSystem(this.getUnitSystem());
        return this.k;
    }

    public void setSeasonalPowerRequirement(SeasonalRecord seasonalRecord) {
        if (seasonalRecord == null) {
            return;
        }
        this.k = seasonalRecord;
    }

    @Override
    public void setRequirementVariation(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Invalid HydroPower Variation Requirement");
        }
        this.l = n;
    }

    @Override
    public int getRequirementVariation() {
        return this.l;
    }

    @Override
    public int getPowerReqSpecification() {
        return this.m;
    }

    @Override
    public void setPowerReqSpecification(int n) {
        if (n != 10 && n != 11 && n != 12 && n != 13 && n != 14) {
            throw new IllegalArgumentException("Invalid Power Requirement Specification in SystemHydropowerOpRule.setPowerReqSpecifaction()");
        }
        this.m = n;
    }

    public void setUsePlantFactor(boolean bl) {
        this.c = bl;
    }

    public boolean usePlantFactor() {
        return this.c;
    }

    public PowerGenerationPatternContainer getPowerPatternContainer() {
        return this.f;
    }

    public void setPowerPatternContainer(PowerGenerationPatternContainer powerGenerationPatternContainer) {
        this.f = powerGenerationPatternContainer;
    }

    public PowerGenerationPatternContainer getResPowerPatternContainer(int n) {
        Integer n2;
        PowerGenerationPatternContainer powerGenerationPatternContainer;
        if (this.i == null) {
            this.i = new Hashtable();
        }
        if ((powerGenerationPatternContainer = this.i.get(n2 = Integer.valueOf(n))) == null) {
            powerGenerationPatternContainer = new PowerGenerationPatternContainer();
            this.i.put(n2, powerGenerationPatternContainer);
        }
        return powerGenerationPatternContainer;
    }

    public void setResPowerPatternContainer(int n, PowerGenerationPatternContainer powerGenerationPatternContainer) {
        if (this.i == null) {
            this.i = new Hashtable();
        }
        Integer n2 = n;
        this.i.put(n2, powerGenerationPatternContainer);
    }

    public Hashtable<Object, PowerGenerationPatternContainer> getResPowerPatternTable() {
        return this.i;
    }

    public void copyParentInto(SystemHydropowerRule systemHydropowerRule) {
        this.setName(systemHydropowerRule.getName());
        this.setDescription(systemHydropowerRule.getDescription());
        this.c = systemHydropowerRule.usePlantFactor();
        this.d = systemHydropowerRule.useIndependantPowerRequirement();
        this.e = systemHydropowerRule.getDailyGenerationPattern();
        this.f = (PowerGenerationPatternContainer)systemHydropowerRule.getPowerPatternContainer().clone();
        this.i = systemHydropowerRule.getResGenPatternTableClone();
        this.j = systemHydropowerRule.getMonthlyPowerRequirement();
        this.k = systemHydropowerRule.getSeasonalPowerRequirement();
        this.l = systemHydropowerRule.getRequirementVariation();
        this.m = systemHydropowerRule.getPowerReqSpecification();
        this.n = systemHydropowerRule.getStartingDay();
        this.o = systemHydropowerRule.getDayBelongsToTerm();
        this.p = systemHydropowerRule.getStartDayOfPeriod();
        this.q = systemHydropowerRule.getGenerationPeriod();
        this.r = systemHydropowerRule.getReservoirSystemIndicies();
        this.m_parentRuleIndex = systemHydropowerRule.getIndex();
    }

    public boolean useIndependantPowerRequirement() {
        return this.d;
    }

    public void setIndependantPowerRequirement(boolean bl) {
        this.d = bl;
    }

    @Override
    public int getRuleLimitType() {
        return 0;
    }

    @Override
    public Vector getActiveTSRecordProxies(Vector vector, int n) {
        Object object;
        vector = super.getActiveTSRecordProxies(vector, n);
        if (n == 0) {
            SystemHydropowerOpRule systemHydropowerOpRule = this;
            object = systemHydropowerOpRule.getTSRecordProxy(systemHydropowerOpRule.getTSProxyName(), 58);
            if (object != null) {
                vector.addElement(object);
            }
            SystemHydropowerOpRule systemHydropowerOpRule2 = this;
            object = systemHydropowerOpRule2.getTSRecordProxy(systemHydropowerOpRule2.getTSProxyName(), 59);
            if (object != null) {
                vector.addElement(object);
            }
        }
        if ((object = ((RssTSLocationObject)this).getSystem().getSystemHydropowerRule(this.getParentRuleIndex())) != null) {
            return ((RssTSLocationObject)object).getActiveTSRecordProxies(vector, n);
        }
        return vector;
    }

    @Override
    public void updateTSProxyList() {
        SystemHydropowerRule systemHydropowerRule;
        super.updateTSProxyList();
        SystemHydropowerOpRule systemHydropowerOpRule = this;
        if (systemHydropowerOpRule.getTSRecordProxy(systemHydropowerOpRule.getTSProxyName(), 58) == null) {
            SystemHydropowerOpRule systemHydropowerOpRule2 = this;
            systemHydropowerOpRule2.addTSRecordProxy(systemHydropowerOpRule2.getTSProxyName(), 58);
        }
        SystemHydropowerOpRule systemHydropowerOpRule3 = this;
        if (systemHydropowerOpRule3.getTSRecordProxy(systemHydropowerOpRule3.getTSProxyName(), 59) == null) {
            SystemHydropowerOpRule systemHydropowerOpRule4 = this;
            systemHydropowerOpRule4.addTSRecordProxy(systemHydropowerOpRule4.getTSProxyName(), 59);
        }
        if ((systemHydropowerRule = ((RssTSLocationObject)this).getSystem().getSystemHydropowerRule(this.getParentRuleIndex())) != null) {
            ((RssTSLocationObject)systemHydropowerRule).updateTSProxyList();
        }
    }

    @Override
    public void clearTSProxyList() {
        super.clearTSProxyList();
        SystemHydropowerRule systemHydropowerRule = ((RssTSLocationObject)this).getSystem().getSystemHydropowerRule(this.getParentRuleIndex());
        if (systemHydropowerRule != null) {
            systemHydropowerRule.clearTSProxyList();
        }
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }

    @Override
    public synchronized Object clone() {
        SystemHydropowerOpRule systemHydropowerOpRule = (SystemHydropowerOpRule)super.clone();
        ((SystemHydropowerOpRule)super.clone()).f = (PowerGenerationPatternContainer)this.f.clone();
        return systemHydropowerOpRule;
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, Element element) {
        super.outputReport(alternativeInputReport, element);
        element.setAttribute("Rule", "HydropowerSystemHydropower");
        element.setAttribute("PowerVaries", Integer.toString(this.l));
        element.setAttribute("SpecifiedAs", Integer.toString(this.m));
        element.setAttribute("StartingDay", Integer.toString(this.n));
        element.setAttribute("DayBelongsToTerm", Integer.toString(this.o));
        element.setAttribute("DayofPeriod", Integer.toString(this.q));
        element.setAttribute("StartDayofPeriod", Integer.toString(this.p));
        element.setAttribute("PowerGenerationPattern", Integer.toString(this.getDailyGenerationPattern()));
        Element element2 = new Element("Seasonal_Times");
        element.addContent((Content)element2);
        XMLUtilities.createArrayElements((Element)element2, (int[])this.k.getTimeArray());
        element2 = new Element("Seasonal_Data");
        element.addContent((Content)element2);
        XMLUtilities.createArrayElements((Element)element2, (double[])this.k.getDataArray());
        element2 = new Element("ContibutingReservoirIDs");
        element.addContent((Content)element2);
        XMLUtilities.createArrayElements((Element)element2, (int[])this.getReservoirIndexArray());
        element2 = new Element("PowerGenerationPattern");
        element.addContent((Content)element2);
        this.getPowerPatternContainer().outputReport(alternativeInputReport, element2);
    }

    @Override
    public WaterAccount getWaterAccount() {
        return this.s;
    }

    @Override
    public void setWaterAccount(WaterAccount waterAccount) {
        this.s = waterAccount;
    }

    @Override
    boolean isPowerRule() {
        return !this._contributeStorageOnly && !this.u;
    }
}

