/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.TSRecordProxy;
import hec.data.Parameter;
import hec.heclib.util.HecTime;
import hec.heclib.util.doubleArrayContainer;
import hec.model.RunTimeStep;
import hec.model.RunTimeWindow;
import hec.model.SeasonalRecord;
import hec.model.TSRecord;
import hec.rss.model.DecisionEngine;
import hec.rss.model.Element;
import hec.rss.model.GenerationRequirement;
import hec.rss.model.OpRule;
import hec.rss.model.PowerGenerationPatternContainer;
import hec.rss.model.PowerPlant;
import hec.rss.model.ReservoirElement;
import hec.rss.model.ReservoirSysOp;
import hec.rss.model.ReservoirSystem;
import hec.rss.model.ReservoirSystemGroup;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.RunTimePeriod;
import hec.rss.model.Storage;
import hec.rss.model.SystemHydropowerOpRule;
import hec.rss.model.SystemStorageDefinition;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class SystemHydropowerRule
extends OpRule {
    public static final int REQ_SPECIFIED_PLANT_FACTOR = 10;
    public static final int REQ_SPECIFIED_DAILY = 11;
    public static final int REQ_SPECIFIED_WEEKLY = 12;
    public static final int REQ_SPECIFIED_MONTHLY = 13;
    public static final int REQ_SPECIFIED_SEASONALLY = 14;
    public static final int LOCAL_GENERATION = 0;
    public static final int SPECIFY_GENERATION = 1;
    public static final int MONTHLY_VARIATION = 0;
    public static final int SEASONAL_VARIATION = 1;
    public static final int GENERATION_PERIOD_TIMESTEP = 0;
    public static final int GENERATION_PERIOD_DAILY = 1;
    public static final int GENERATION_PERIOD_WEEKLY = 2;
    public static final double MW_CONST_ENGLISH = 0.0010241218789674143;
    public static final double MW_CONST_SI = 2.723311546840959E-6;
    public boolean DEBUG = false;
    private boolean m_usePlantFactor = true;
    boolean m_independantPowerReq = false;
    int m_dailyGenerationPattern = 0;
    PowerGenerationPatternContainer m_powerPatternContainer = new PowerGenerationPatternContainer();
    Hashtable<Object, PowerGenerationPatternContainer> _resGenPatternTable = null;
    double[] m_monthlyPowerRequirement = new double[12];
    SeasonalRecord m_seasonalPowerRequirement = new SeasonalRecord();
    int m_powerReqVariation = 0;
    int m_powerReqSpecifiedAs = 10;
    int m_startingDay = 0;
    int m_dayBelongsToTerm = 0;
    int m_startDayOfPeriod = 0;
    int m_generationPeriod = 0;
    int[] _reservoirIndexArray = new int[0];
    private transient ReservoirSystem a;
    private transient boolean[] b;
    private transient boolean[] c;
    private transient ReservoirElement[] d;
    private transient double[] e;
    private transient double[] f;
    private transient double[] i;
    private transient double[] j;
    private transient double[] k;
    private transient double[] l;
    private transient doubleArrayContainer[] m = null;
    private transient Integer[] n;
    private transient doubleArrayContainer o = null;
    private transient doubleArrayContainer[] p = null;
    private transient doubleArrayContainer q;
    private transient doubleArrayContainer r;
    private transient doubleArrayContainer s;
    private transient doubleArrayContainer[] t;
    private transient doubleArrayContainer u;
    private transient doubleArrayContainer v;
    private transient doubleArrayContainer[] w;
    private transient GenerationRequirement x;
    private transient doubleArrayContainer[] y = null;
    private transient double[] z;
    private transient double[] A;
    private transient double[] B;
    private transient double C;
    private transient double D;
    private transient int E;
    private transient SystemHydropowerOpRule[] F;
    private transient SystemStorageDefinition G;
    private boolean _useEnergyRequiredTimeSeries = false;
    private transient TSRecord H;
    BufferedWriter _bufout;
    File _fileout;

    public SystemHydropowerRule() {
        this.createDefaultData();
    }

    @Override
    public int getRuleLimitType() {
        return 0;
    }

    void getDistributedValue(RunTimeStep object, double[] dArray, DecisionEngine decisionEngine) {
        double d;
        if (this.a == null || this.a.b() <= 0) {
            return;
        }
        double d2 = this.q.array[object.step];
        if (d <= 0.0) {
            if (this.DEBUG) {
                this.writeDebugOutput(new RunTimePeriod(), d2, -1.0);
            }
            return;
        }
        int n = this.a.a((RunTimeStep)object, this);
        this.a.a(this.b);
        if (n <= 0) {
            if (this.DEBUG) {
                this.writeDebugOutput(new RunTimePeriod(), d2, -1.0);
            }
            return;
        }
        object = this.x.a((RunTimeStep)object);
        double d3 = this.a.a((RunTimePeriod)object);
        this.a.a((RunTimePeriod)object, decisionEngine, this);
        this.a.a((RunTimePeriod)object, d2, d3, this.e, this.t, this.u, this.f);
        this.calcStepGenReq((RunTimePeriod)object);
        if (this.DEBUG) {
            this.writeDebugOutput((RunTimePeriod)object, d2, d3);
        }
        for (double dArray[var1_2] : this.i) {
        }
    }

    public ReservoirElement[] getReservoirArray() {
        return this.d;
    }

    public void evaluateSysLimits(RunTimeStep runTimeStep, int n) {
        ((OpRule)this).evaluateLimits(runTimeStep, n);
    }

    SystemHydropowerOpRule[] getChildList() {
        return this.F;
    }

    public List<ReservoirElement> getReservoirs(List<ReservoirElement> list) {
        if (list == null) {
            list = new ArrayList<ReservoirElement>();
        }
        if (this._reservoirIndexArray == null) {
            return list;
        }
        RssSystem rssSystem = this.g;
        if (rssSystem == null) {
            rssSystem = this.getRssSystem();
        }
        int n = this._reservoirIndexArray.length;
        for (int i = 0; i < n; ++i) {
            ReservoirElement reservoirElement = (ReservoirElement)rssSystem.getElement(this._reservoirIndexArray[i]);
            if (reservoirElement == null) continue;
            list.add(reservoirElement);
        }
        return list;
    }

    public void addChildRule(SystemHydropowerOpRule systemHydropowerOpRule, int n) {
        if (systemHydropowerOpRule == null) {
            return;
        }
        if (this.F == null || this.F.length < this._reservoirIndexArray.length) {
            this.F = new SystemHydropowerOpRule[this._reservoirIndexArray.length];
        }
        for (int i = 0; i < this._reservoirIndexArray.length; ++i) {
            if (this._reservoirIndexArray[i] != n) continue;
            this.F[i] = systemHydropowerOpRule;
        }
    }

    public SystemHydropowerOpRule getChildRule(int n) {
        SystemHydropowerOpRule systemHydropowerOpRule = null;
        if (this.F == null) {
            return null;
        }
        for (int i = 0; i < this._reservoirIndexArray.length; ++i) {
            if (this._reservoirIndexArray[i] != n) continue;
            systemHydropowerOpRule = this.F[i];
        }
        return systemHydropowerOpRule;
    }

    public int getPeriodSteps() {
        return this.E;
    }

    @Override
    public void evaluateLimits(RunTimeStep runTimeStep, int n) {
    }

    public void evaluateLimits33(RunTimeStep object, int n) {
        double d;
        if (this.a == null || this.a.b() <= 0) {
            return;
        }
        double d2 = this.q.array[object.step];
        if (d <= 0.0) {
            if (this.DEBUG) {
                this.writeDebugOutput(new RunTimePeriod(), d2, -1.0);
            }
            return;
        }
        n = this.a.a((RunTimeStep)object, this);
        this.a.a(this.b);
        if (n <= 0) {
            if (this.DEBUG) {
                this.writeDebugOutput(new RunTimePeriod(), d2, -1.0);
            }
            return;
        }
        object = this.x.a((RunTimeStep)object);
        double d3 = this.a.a((RunTimePeriod)object);
        this.a.a((RunTimePeriod)object, null, this);
        this.a.a((RunTimePeriod)object, d2, d3, this.e, this.t, this.u, this.f);
        this.calcStepGenReq((RunTimePeriod)object);
        if (this.DEBUG) {
            this.writeDebugOutput((RunTimePeriod)object, d2, d3);
        }
    }

    private void calcStepGenReq(RunTimePeriod runTimePeriod) {
        if (this.z == null || this.z.length < runTimePeriod.b) {
            this.z = new double[runTimePeriod.b];
            this.A = new double[runTimePeriod.b];
            this.B = new double[runTimePeriod.b];
        } else {
            Arrays.fill(this.z, 0.0);
        }
        int n = runTimePeriod.a.rtw.getNumSteps();
        int n2 = runTimePeriod.a.step - runTimePeriod.c;
        int n3 = n2 >= 0 ? n2 : 0;
        int n4 = n2 >= 0 ? 0 : -n2;
        int n5 = runTimePeriod.b;
        if (n2 < 0) {
            n5 += n2;
        }
        if (n2 + runTimePeriod.b > n) {
            n5 -= n2 + runTimePeriod.b - n - 1;
        }
        int n6 = runTimePeriod.b - runTimePeriod.c;
        if (n2 + runTimePeriod.b > n) {
            n6 -= n2 + runTimePeriod.b - n - 1;
        }
        int n7 = this.e.length;
        int cfr_ignored_0 = runTimePeriod.b;
        int cfr_ignored_1 = runTimePeriod.c;
        runTimePeriod.a.getTimeStepSeconds();
        for (n = 0; n < n7; ++n) {
            ReservoirSystemGroup reservoirSystemGroup = this.a.a(n);
            if (!reservoirSystemGroup.e()) continue;
            reservoirSystemGroup.a(this.A, this.B);
            if (this.m_dailyGenerationPattern == 0) {
                System.arraycopy(this.p[n].array, n3, this.z, n4, n5);
            } else {
                System.arraycopy(this.o.array, n3, this.z, n4, n5);
            }
            PowerGenerationPatternContainer.a(this.z, this.e[n], runTimePeriod.c, n6, this.A, this.B);
            this.j[n] = this.z[runTimePeriod.c];
            if (this.j[n] < 0.0) {
                this.j[n] = 0.0;
            }
            this.F[n].setEnergyRequirement(runTimePeriod.a, this.j[n]);
            double d = 0.0;
            double d2 = 0.0;
            for (int i = runTimePeriod.c; i < runTimePeriod.b; ++i) {
                d2 += this.z[i];
            }
            if (d2 > 0.0) {
                d = this.f[n] / d2 * this.z[runTimePeriod.c] / (double)runTimePeriod.a.getTimeStepSeconds() * Storage.DSDT_TO_Q;
            }
            this.i[n] = d;
            this.F[n].setFlowRequirement(runTimePeriod.a, d);
        }
    }

    protected double getReservoirGeneration(int n) {
        if (this.d == null || this.j == null) {
            return Double.NEGATIVE_INFINITY;
        }
        int n2 = this._reservoirIndexArray.length;
        for (int i = 0; i < n2; ++i) {
            if (this._reservoirIndexArray[i] != n) continue;
            return this.j[i];
        }
        return Double.NEGATIVE_INFINITY;
    }

    public PowerGenerationPatternContainer getResGenPattern(int n) {
        if (this._resGenPatternTable == null) {
            return null;
        }
        return this._resGenPatternTable.get(n);
    }

    public Hashtable<Object, PowerGenerationPatternContainer> getResGenPatternTableClone() {
        if (this._resGenPatternTable == null) {
            return null;
        }
        Hashtable<Object, PowerGenerationPatternContainer> hashtable = new Hashtable<Object, PowerGenerationPatternContainer>();
        Enumeration<Object> enumeration = this._resGenPatternTable.keys();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            PowerGenerationPatternContainer powerGenerationPatternContainer = this._resGenPatternTable.get(object);
            hashtable.put(object, (PowerGenerationPatternContainer)powerGenerationPatternContainer.clone());
        }
        return hashtable;
    }

    protected int initForecast(RunTimeWindow object) {
        int n;
        if (this._reservoirIndexArray == null) {
            return 0;
        }
        Object object2 = new ArrayList();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<doubleArrayContainer> arrayList2 = new ArrayList<doubleArrayContainer>();
        int n2 = this._reservoirIndexArray.length;
        this.b = new boolean[n2];
        this.c = new boolean[n2];
        this.d = new ReservoirElement[n2];
        this.e = new double[n2];
        this.f = new double[n2];
        this.i = new double[n2];
        this.j = new double[n2];
        this.k = new double[n2];
        this.l = new double[n2];
        this.C = 0.0;
        for (n = 0; n < n2; ++n) {
            int n3;
            ReservoirElement reservoirElement = ((RssTSLocationObject)this).getSystem().findReservoir(this._reservoirIndexArray[n]);
            if (reservoirElement == null) continue;
            this.d[n] = reservoirElement;
            boolean bl = false;
            this.b[n] = false;
            if (this.F[n] != null) {
                bl = this.F[n].getContributeStorageOnly();
                boolean bl2 = this.F[n].getPassThruOnly();
                n3 = bl2 ? 1 : 0;
                if (!bl2) {
                    this.b[n] = true;
                }
            }
            if (!bl) {
                PowerPlant[] powerPlantArray = reservoirElement.getPowerPlants();
                for (n3 = 0; n3 < powerPlantArray.length; ++n3) {
                    object2.add(powerPlantArray[n3].getAdjustableFlow().getTSContainer(53));
                    arrayList.add(n);
                    this.C += powerPlantArray[n3].getInstalledCapacity();
                }
            }
            arrayList2.add(reservoirElement.getStorageFunction().getTSContainer(10));
        }
        this.G = ReservoirSysOp.a(this.g, this.d, this.b);
        this.m = new doubleArrayContainer[object2.size()];
        object2.toArray(this.m);
        this.n = new Integer[arrayList.size()];
        arrayList.toArray(this.n);
        this.y = new doubleArrayContainer[arrayList2.size()];
        arrayList2.toArray(this.y);
        this.q = null;
        this.r = null;
        this.o = null;
        this.s = null;
        String string = this.getTSProxyName();
        this.q = this.getTSContainer(string, 157);
        this.r = this.getTSContainer(string, 156);
        this.o = this.getTSContainer(string, 155);
        this.s = this.getTSContainer(string, 159);
        this.u = this.getTSContainer(string + "-Projected", 167);
        this.v = this.getTSContainer(string + "-Final", 167);
        this.t = new doubleArrayContainer[n2];
        this.w = new doubleArrayContainer[n2];
        for (n = 0; n < n2; ++n) {
            String string2 = string + "-" + this.d[n].getName();
            this.t[n] = this.getTSContainer(string2, 89);
            this.w[n] = this.getTSContainer(string2 + "-Final", 167);
        }
        if (this.q == null) {
            this.g.printErrorMessage("SystemHydropowerRule.initialize: failed to get required energy time series container");
            return 1;
        }
        if (this.useEnergyRequiredTimeSeries()) {
            object2 = this.m_powerReqSpecifiedAs == 10 ? this.getTSRecordProxy(string + "-Plant Factor Requirement", 196) : this.getTSRecordProxy(string + "-Energy Requirement", 196);
            if (object2 == null) {
                this.g.printErrorMessage("SystemHydropowerRule.initialize: failed to get required energy time series container");
                return 1;
            }
            this.H = object2.getTSRecord();
            if (this.H == null) {
                this.g.printErrorMessage("SystemHydropowerRule.initialize: failed to get required energy time series container");
                return 1;
            }
            if (this.m_powerReqSpecifiedAs == 10) {
                if (!this.H.getUnits().startsWith("UN")) {
                    this.g.printErrorMessage("SystemHydropowerRule.initialize: Input Time Series for required energy must be unitless for Plant Factor");
                    this.g.printErrorMessage("System Hydropower Rule Name - " + this.getName());
                    this.g.printErrorMessage("Record - " + this.H.getDSSPathname());
                    return 1;
                }
            } else if (!this.H.getUnits().equalsIgnoreCase(Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_ENERGY, (int)this.g.getUnitSystem()))) {
                this.g.printErrorMessage("SystemHydropowerRule.initialize: Input Time Series for required energy must have units of MWH");
                this.g.printErrorMessage("System Hydropower Rule Name - " + this.getName());
                this.g.printErrorMessage("Record - " + this.H.getDSSPathname());
                return 1;
            }
        }
        this.a = new ReservoirSystem(this.g, this.d);
        this.a.a((RunTimeWindow)object);
        this.a.a(this.G);
        for (n = 0; n < n2; ++n) {
            boolean bl = false;
            if (this.F[n] != null) {
                bl = this.F[n].getContributeStorageOnly();
            }
            object2 = this.a.a(this.d[n]);
            object2.a(bl);
        }
        this.x = new GenerationRequirement(this.m_powerReqVariation, this.m_powerReqSpecifiedAs, this.m_monthlyPowerRequirement, this.m_generationPeriod, this.m_startDayOfPeriod, this.m_startingDay, this.m_dayBelongsToTerm, this.m_seasonalPowerRequirement, this.C, this.g);
        if (this.useEnergyRequiredTimeSeries()) {
            this.x.a(this.H);
        }
        this.generateSysEnergyReqTS((RunTimeWindow)object);
        RunTimeWindow runTimeWindow = object;
        this.E = this.x.b(runTimeWindow.getRunTimeStepAtTime(runTimeWindow.getStartTime()));
        object = this.g.getComputeOptions();
        if (!object.noSysHydroRoutingSteps()) {
            this.g.printMessage("Number of Routing Steps = " + Integer.toString(this.E) + " for analysis of System Hydropower Rule " + this.getName());
        }
        if (Boolean.getBoolean("RSSYSPOWDEBUG")) {
            this.DEBUG = true;
            this.initDebugOutput();
        } else {
            this.DEBUG = false;
        }
        return 0;
    }

    private void generateSysEnergyReqTS(RunTimeWindow runTimeWindow) {
        int n = runTimeWindow.getNumSteps();
        if (this.m_dailyGenerationPattern == 0) {
            this.m_powerPatternContainer.setUseLocalGeneration(true);
            this.m_powerPatternContainer.setResIds(this._reservoirIndexArray);
            this.m_powerPatternContainer.setResPatternContainer(this._resGenPatternTable);
            int n2 = this._reservoirIndexArray.length;
            this.p = new doubleArrayContainer[n2];
            for (int i = 0; i < n2; ++i) {
                this.p[i] = new doubleArrayContainer();
                this.p[i].array = new double[n + 1];
                SystemHydropowerRule systemHydropowerRule = this;
                PowerGenerationPatternContainer powerGenerationPatternContainer = systemHydropowerRule.getResGenPattern(systemHydropowerRule._reservoirIndexArray[i]);
                if (powerGenerationPatternContainer != null) {
                    powerGenerationPatternContainer.fillPatternTS(runTimeWindow, this.p[i].array);
                    continue;
                }
                Arrays.fill(this.p[i].array, 1.0);
            }
        }
        this.m_powerPatternContainer.fillPatternTS(runTimeWindow, this.o.array);
        this.x.a(runTimeWindow, this.m_powerPatternContainer, this.o.array, this.q.array);
    }

    public int initOperationStep(RunTimeStep runTimeStep) {
        int n = this._reservoirIndexArray.length;
        for (int i = 0; i < n; ++i) {
            this.b[i] = false;
            this.e[i] = 0.0;
            this.f[i] = 0.0;
            this.i[i] = 0.0;
            this.j[i] = Double.NEGATIVE_INFINITY;
        }
        return 0;
    }

    @Override
    public Vector getActiveTSRecordProxies(Vector vector, int n) {
        Object object;
        String string = this.getTSProxyName();
        if (n == 0) {
            object = this.getTSRecordProxy(string, 155);
            if (object != null) {
                vector.addElement(object);
            }
            if ((object = this.getTSRecordProxy(string, 156)) != null) {
                vector.addElement(object);
            }
            if ((object = this.getTSRecordProxy(string, 157)) != null) {
                vector.addElement(object);
            }
            if ((object = this.getTSRecordProxy(string, 159)) != null) {
                vector.addElement(object);
            }
            if ((object = this.getTSRecordProxy(string + "-Projected", 167)) != null) {
                vector.addElement(object);
            }
            if ((object = this.getTSRecordProxy(string + "-Final", 167)) != null) {
                vector.addElement(object);
            }
            if (this.g != null && this._reservoirIndexArray != null && this._reservoirIndexArray.length > 0) {
                int n2 = this._reservoirIndexArray.length;
                for (int i = 0; i < n2; ++i) {
                    object = this.g.findReservoir(this._reservoirIndexArray[i]);
                    if (object == null) continue;
                    String string2 = string + "-" + object.getName();
                    if ((object = this.getTSRecordProxy(string2, 89)) != null) {
                        vector.addElement(object);
                    }
                    if ((object = this.getTSRecordProxy(string2 + "-Final", 167)) == null) continue;
                    vector.addElement(object);
                }
            }
        }
        if (n == 1 && this.useEnergyRequiredTimeSeries() && (object = this.m_powerReqSpecifiedAs == 10 ? this.getTSRecordProxy(string + "-Plant Factor Requirement", 196) : this.getTSRecordProxy(string + "-Energy Requirement", 196)) != null) {
            vector.addElement(object);
        }
        return vector;
    }

    @Override
    public void updateTSProxyList() {
        String string = this.getTSProxyName();
        if (this.getTSRecordProxy(string, 155) == null) {
            this.addTSRecordProxy(string, 155);
        }
        if (this.getTSRecordProxy(string, 156) == null) {
            this.addTSRecordProxy(string, 156);
        }
        if (this.getTSRecordProxy(string, 157) == null) {
            this.addTSRecordProxy(string, 157);
        }
        if (this.getTSRecordProxy(string, 159) == null) {
            this.addTSRecordProxy(string, 159);
        }
        if (this.getTSRecordProxy(string + "-Projected", 167) == null) {
            this.addTSRecordProxy(string + "-Projected", 167);
        }
        if (this.getTSRecordProxy(string + "-Final", 167) == null) {
            this.addTSRecordProxy(string + "-Final", 167);
        }
        if (this.useEnergyRequiredTimeSeries()) {
            if (this.m_powerReqSpecifiedAs == 10) {
                this.addTSRecordProxy(string + "-Plant Factor Requirement", 196);
            } else {
                this.addTSRecordProxy(string + "-Energy Requirement", 196);
            }
        }
        if (this.g != null && this._reservoirIndexArray != null && this._reservoirIndexArray.length > 0) {
            int n = this._reservoirIndexArray.length;
            for (int i = 0; i < n; ++i) {
                Object object = this.g.findReservoir(this._reservoirIndexArray[i]);
                if (object == null) continue;
                if (this.getTSRecordProxy((String)(object = string + "-" + object.getName()), 89) == null) {
                    this.addTSRecordProxy((String)object, 89);
                }
                if (this.getTSRecordProxy((String)object + "-Final", 167) != null) continue;
                this.addTSRecordProxy((String)object + "-Final", 167);
            }
        }
    }

    @Override
    public void evaulatePerformance(RunTimeWindow runTimeWindow) {
        int n;
        int n2;
        int n3;
        int n4;
        if (this._reservoirIndexArray == null || this._reservoirIndexArray.length <= 0) {
            return;
        }
        int n5 = this._reservoirIndexArray.length;
        RssSystem rssSystem = ((RssTSLocationObject)this).getSystem();
        for (n4 = 0; n4 < n5; ++n4) {
            this.b[n4] = true;
        }
        RunTimeWindow runTimeWindow2 = runTimeWindow;
        RunTimeStep runTimeStep = runTimeWindow2.getRunTimeStepAtTime(runTimeWindow2.getLookbackTime());
        n4 = runTimeStep.getTimeStepSeconds();
        HecTime hecTime = runTimeStep.getHecTime();
        int n6 = hecTime.secondsSinceMidnight();
        if (n6 == 0) {
            n6 = 86400;
        }
        if (this.m_generationPeriod == 0) {
            n3 = 1;
            n2 = 0;
        } else if (this.m_generationPeriod == 1) {
            n3 = 86400 / n4;
            n2 = n6 / n4 - 1;
        } else {
            n3 = 604800 / n4;
            int n7 = RunTimeStep.getDayOfWeek((HecTime)hecTime);
            int n8 = n7 - this.m_startDayOfPeriod;
            if (n8 < 0) {
                n8 += 7;
            }
            n2 = n6 / n4 - 1 + n8 * 86400 / n4;
        }
        double d = 0.0;
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        int n9 = runTimeWindow.getNumSteps();
        int n10 = this.m.length;
        for (n4 = 0; n4 <= n9; ++n4) {
            runTimeStep.step = n4;
            if (n2 == 0) {
                d = 0.0;
            }
            for (n = 0; n < n10; ++n) {
                if (!RMAConst.isValidValue((double)this.m[n].array[n4])) continue;
                d += this.m[n].array[n4];
            }
            this.r.array[n4] = d;
            if (n2 == n3 - 1) {
                this.s.array[n4] = this.r.array[n4] - this.q.array[n4];
                if (this.s.array[n4] > 0.0) {
                    this.s.array[n4] = 0.0;
                }
            } else {
                this.s.array[n4] = -3.4028234663852886E38;
            }
            this.a.a(runTimeStep, this);
            this.a.a(this.b);
            for (n = 0; n < n5; ++n) {
                this.l[n] = this.d[n].getStorageFunction().getStorage(runTimeStep);
            }
            ReservoirSysOp.a(rssSystem, this.d, this.b, runTimeStep, this.G, this.l, this.k, 0.0, dArray, dArray2);
            this.v.array[n4] = dArray2[0];
            for (n = 0; n < n5; ++n) {
                this.t[n].array[n4] = this.k[n];
            }
            if (++n2 != n3) continue;
            n2 = 0;
        }
        for (n = 0; n < n5; ++n) {
            for (n4 = 0; n4 < n5; ++n4) {
                this.b[n4] = false;
            }
            this.b[n] = true;
            SystemStorageDefinition systemStorageDefinition = ReservoirSysOp.a(rssSystem, this.d, this.b);
            for (n4 = 0; n4 <= n9; ++n4) {
                runTimeStep.step = n4;
                this.l[n] = this.d[n].getStorageFunction().getStorage(runTimeStep);
                ReservoirSysOp.a(rssSystem, this.d, this.b, runTimeStep, systemStorageDefinition, this.l, this.k, 0.0, dArray, dArray2);
                this.w[n].array[n4] = dArray2[0];
            }
        }
    }

    public PowerGenerationPatternContainer getPowerPatternContainer() {
        return this.m_powerPatternContainer;
    }

    public int getRequirementVariation() {
        return this.m_powerReqVariation;
    }

    private void createDefaultData() {
        Arrays.fill(this.m_monthlyPowerRequirement, Double.NEGATIVE_INFINITY);
    }

    @Override
    public boolean initializeCompute() {
        boolean bl = super.initializeCompute();
        return bl;
    }

    private int generateTime(String string) {
        int[] nArray = new int[1];
        HecTime.datjul((String)(string + "1900"), (int[])nArray);
        return nArray[0] * 1440;
    }

    public void setSystemHydropowerOpRule(SystemHydropowerOpRule systemHydropowerOpRule) {
        this.copyChildInto(systemHydropowerOpRule);
    }

    public boolean usePlantFactor() {
        return this.m_usePlantFactor;
    }

    public boolean useIndependantPowerRequirement() {
        return this.m_independantPowerReq;
    }

    public boolean useEnergyRequiredTimeSeries() {
        return this._useEnergyRequiredTimeSeries;
    }

    public void setUseEnergyRequiredTimeSeries(boolean bl) {
        this._useEnergyRequiredTimeSeries = bl;
    }

    public int getDailyGenerationPattern() {
        return this.m_dailyGenerationPattern;
    }

    public double[] getMonthlyPowerRequirement() {
        double[] dArray = new double[this.m_monthlyPowerRequirement.length];
        System.arraycopy(this.m_monthlyPowerRequirement, 0, dArray, 0, this.m_monthlyPowerRequirement.length);
        return dArray;
    }

    public SeasonalRecord getSeasonalPowerRequirement() {
        return this.m_seasonalPowerRequirement;
    }

    public int getDayBelongsToTerm() {
        return this.m_dayBelongsToTerm;
    }

    public int getStartingDay() {
        return this.m_startingDay;
    }

    public int getStartDayOfPeriod() {
        return this.m_startDayOfPeriod;
    }

    public int getPowerReqSpecification() {
        return this.m_powerReqSpecifiedAs;
    }

    public int getGenerationPeriod() {
        return this.m_generationPeriod;
    }

    public int[] getReservoirSystemIndicies() {
        int[] nArray = new int[this._reservoirIndexArray.length];
        System.arraycopy(this._reservoirIndexArray, 0, nArray, 0, nArray.length);
        return nArray;
    }

    public void copyChildInto(SystemHydropowerOpRule systemHydropowerOpRule) {
        this.setName(systemHydropowerOpRule.getName());
        this.setDescription(systemHydropowerOpRule.getDescription());
        this.m_usePlantFactor = systemHydropowerOpRule.usePlantFactor();
        this.m_independantPowerReq = systemHydropowerOpRule.useIndependantPowerRequirement();
        this.m_powerPatternContainer = systemHydropowerOpRule.getPowerPatternContainer();
        this.m_dailyGenerationPattern = systemHydropowerOpRule.getDailyGenerationPattern();
        this._resGenPatternTable = systemHydropowerOpRule.getResPowerPatternTable();
        this.m_monthlyPowerRequirement = systemHydropowerOpRule.getMonthlyPowerRequirement();
        this.m_seasonalPowerRequirement = systemHydropowerOpRule.getSeasonalPowerRequirement();
        this.m_powerReqVariation = systemHydropowerOpRule.getRequirementVariation();
        this.m_powerReqSpecifiedAs = systemHydropowerOpRule.getPowerReqSpecification();
        this.m_startingDay = systemHydropowerOpRule.getStartingDay();
        this.m_dayBelongsToTerm = systemHydropowerOpRule.getDayBelongsToTerm();
        this.m_startDayOfPeriod = systemHydropowerOpRule.getStartDayOfPeriod();
        this.m_generationPeriod = systemHydropowerOpRule.getGenerationPeriod();
        this._reservoirIndexArray = systemHydropowerOpRule.getReservoirIndexArray();
    }

    public boolean initialize(RssSystem rssSystem) {
        this.g = rssSystem;
        return true;
    }

    public boolean initForPostProcessing(RssSystem rssSystem) {
        this.g = rssSystem;
        return true;
    }

    public void finalizeCompute() {
        if (this.a != null) {
            ReservoirSystem reservoirSystem = this.a;
            if (reservoirSystem.d != null) {
                try {
                    reservoirSystem.d.flush();
                    reservoirSystem.d.close();
                }
                catch (IOException iOException) {
                    System.out.println(iOException);
                }
            }
        }
        if (this._bufout != null) {
            try {
                this._bufout.flush();
                this._bufout.close();
                return;
            }
            catch (IOException iOException) {
                System.out.println(iOException);
            }
        }
    }

    private void initDebugOutput() {
        try {
            int n;
            this._bufout = new BufferedWriter(new FileWriter("syspowerout.csv"));
            int n2 = this.e.length;
            String string = ",";
            this._bufout.write("Date");
            this._bufout.write(string + "Step");
            this._bufout.write(string + "istep");
            this._bufout.write(string + "periodSteps");
            this._bufout.write(string + "periodReq");
            this._bufout.write(string + "previosGen");
            this._bufout.write(string + "remainReq");
            for (n = 0; n < n2; ++n) {
                this._bufout.write(string + "active-" + ((Element)this.d[n]).toString());
            }
            for (n = 0; n < n2; ++n) {
                this._bufout.write(string + "tmpact-" + ((Element)this.d[n]).toString());
            }
            for (n = 0; n < n2; ++n) {
                this._bufout.write(string + "balStor-" + ((Element)this.d[n]).toString());
            }
            for (n = 0; n < n2; ++n) {
                this._bufout.write(string + "resEGen-" + ((Element)this.d[n]).toString());
            }
            this._bufout.write(string + "resEGenSum");
            this._bufout.write(string + "genReq");
            this._bufout.write(string + "diff");
            for (n = 0; n < n2; ++n) {
                this._bufout.write(string + "resStepGen-" + ((Element)this.d[n]).toString());
            }
            this.a.a(this._bufout, string);
            this._bufout.newLine();
            return;
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            return;
        }
    }

    private void writeDebugOutput(RunTimePeriod runTimePeriod, double d, double d2) {
        if (this._bufout == null || runTimePeriod.a == null) {
            return;
        }
        String string = ",";
        try {
            int n;
            this._bufout.write(runTimePeriod.a.getHecTime().dateAndTime(4));
            this._bufout.write(string + runTimePeriod.a.step);
            this._bufout.write(string + runTimePeriod.c);
            this._bufout.write(string + runTimePeriod.b);
            this._bufout.write(string + RMAIO.setPrecision2((double)d, (int)2));
            this._bufout.write(string + RMAIO.setPrecision2((double)d2, (int)2));
            this._bufout.write(string + RMAIO.setPrecision2((double)(d - d2), (int)2));
            int n2 = this.b.length;
            double d3 = 0.0;
            for (n = 0; n < n2; ++n) {
                this._bufout.write(string + this.b[n]);
            }
            for (n = 0; n < n2; ++n) {
                this._bufout.write(string + this.c[n]);
            }
            for (n = 0; n < n2; ++n) {
                this._bufout.write(string + RMAIO.setPrecision2((double)this.k[n], (int)2));
            }
            for (n = 0; n < n2; ++n) {
                d3 += this.e[n];
                this._bufout.write(string + RMAIO.setPrecision2((double)this.e[n], (int)2));
            }
            this._bufout.write(string + RMAIO.setPrecision2((double)d3, (int)2));
            this._bufout.write(string + RMAIO.setPrecision2((double)this.D, (int)2));
            this._bufout.write(string + RMAIO.setPrecision2((double)(this.D - d2 - d3), (int)2));
            for (n = 0; n < n2; ++n) {
                this._bufout.write(string + RMAIO.setPrecision2((double)this.j[n], (int)2));
            }
            this.a.b(this._bufout, string);
            this._bufout.newLine();
            return;
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            return;
        }
    }

    public void getTSRecordProxyVecResVar(Vector vector, int n) {
        if (this.g == null || this._reservoirIndexArray == null) {
            return;
        }
        for (int i = 0; i < this._reservoirIndexArray.length; ++i) {
            Object object = this.g.getElement(this._reservoirIndexArray[i]);
            object = this.getTSProxyName() + "-" + object.getName() + "-Final";
            if ((object = this.getTSRecordProxy((String)object, n)) == null) continue;
            vector.addElement(object);
        }
    }

    public TSRecordProxy getTSRecordProxyResVar(int n, int n2) {
        if (this.g == null || this._reservoirIndexArray == null || this._reservoirIndexArray.length <= n) {
            return null;
        }
        Object object = this.g.getElement(this._reservoirIndexArray[n]);
        object = this.getTSProxyName() + "-" + object.getName();
        object = this.getTSRecordProxy((String)object, n2);
        return object;
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }

    @Override
    boolean isPowerRule() {
        return true;
    }
}

