/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.heclib.util.HecTime;
import hec.io.AsciiSerializable;
import hec.model.RunTimeStep;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Arrays;
import rma.util.RMAConst;

public class SystemPwrGenerationPattern
implements AsciiSerializable,
Serializable,
Cloneable {
    public static final int PATTERN_ADJUST_SLIDE = 0;
    public static final int PATTERN_ADJUST_SCALE = 1;
    public static final int POWER_GEN_DAY = 7;
    public static final int POWER_GEN_ALL_WEEK = 1;
    public static final int POWER_GEN_WEEK_DAY_END = 2;
    int m_pwrPatternAdjustMethod = 1;
    double[][] m_powerGenPattern;
    int m_patternType = 1;
    String[] months = new String[]{"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"};
    private static int[] a = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    public SystemPwrGenerationPattern() {
        this.m_powerGenPattern = new double[this.m_patternType][24];
        for (int i = 0; i < this.m_patternType; ++i) {
            Arrays.fill(this.m_powerGenPattern[i], 1.0);
        }
    }

    public boolean getPatternForDay(int n, double[] dArray) {
        if (n <= 0 || n > 7) {
            return false;
        }
        if (dArray == null || dArray.length != 24) {
            return false;
        }
        if (this.m_powerGenPattern == null) {
            return false;
        }
        switch (this.m_patternType) {
            case 1: {
                System.arraycopy(this.m_powerGenPattern[0], 0, dArray, 0, 24);
                break;
            }
            case 2: {
                if (n > 1 && n < 7) {
                    System.arraycopy(this.m_powerGenPattern[0], 0, dArray, 0, 24);
                    break;
                }
                System.arraycopy(this.m_powerGenPattern[1], 0, dArray, 0, 24);
                break;
            }
            case 7: {
                System.arraycopy(this.m_powerGenPattern[n - 1], 0, dArray, 0, 24);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public int getPwrPatternAdjustMethod() {
        return this.m_pwrPatternAdjustMethod;
    }

    public void setPwrPatternAdjustMethod(int n) {
        if (n != 1 && n != 0) {
            throw new IllegalArgumentException("Invalid power pattern adjustment in SystemHydropowerOpRule.setPwrPatternAdjustMethod()");
        }
        this.m_pwrPatternAdjustMethod = n;
    }

    public int getPwrGenPatternType() {
        return this.m_patternType;
    }

    public void setPwrGenPatternType(int n) {
        if (n != 1 && n != 7 && n != 2) {
            throw new IllegalArgumentException("Unrecognized Power Generation Type");
        }
        this.m_patternType = n;
        double[][] dArray = this.m_powerGenPattern;
        this.m_powerGenPattern = new double[this.m_patternType][24];
        for (int i = 0; i < this.m_powerGenPattern.length && i < dArray.length; ++i) {
            System.arraycopy(dArray[i], 0, this.m_powerGenPattern[i], 0, 24);
        }
    }

    public double[][] getPwrGenPattern() {
        return this.m_powerGenPattern;
    }

    public void setPwrGenPattern(double[][] dArray) {
        if (dArray == null) {
            return;
        }
        this.m_powerGenPattern = dArray;
    }

    public double[][] computePowerGenerationPattern(RunTimeStep runTimeStep, double d, int n, double d2, double d3, double d4, int n2, int n3) {
        int n4;
        int n5;
        int n6 = runTimeStep.getDayOfWeek() + 1;
        boolean bl = n6 == 1 || n6 == 7;
        int n7 = 0;
        switch (this.m_patternType) {
            case 1: {
                n7 = 0;
                break;
            }
            case 2: {
                n7 = bl ? 1 : 0;
                break;
            }
            case 7: {
                n7 = n6 - 1;
            }
        }
        double[][] dArray = new double[this.m_powerGenPattern.length][this.m_powerGenPattern[0].length];
        for (n5 = 0; n5 < this.m_powerGenPattern.length; ++n5) {
            System.arraycopy(this.m_powerGenPattern[n5], 0, dArray[n5], 0, this.m_powerGenPattern[n5].length);
        }
        for (n5 = 0; n5 < dArray.length; ++n5) {
            for (n4 = 0; n4 < dArray[n5].length; ++n4) {
                if (RMAConst.isValidValue((double)dArray[n5][n4])) continue;
                dArray[n5][n4] = 0.0;
            }
        }
        if (this.m_pwrPatternAdjustMethod == 1) {
            this.scale(runTimeStep, dArray, d, n);
        } else {
            double d5 = this.getTotalPowerGeneration(runTimeStep, n);
            double[][] dArray2 = this.expandPattern(dArray, this.m_patternType);
            this.slide(runTimeStep, dArray2, d, d5, n, 0, 0, dArray2.length, 24);
            dArray = this.compressPattern(dArray2, this.m_patternType);
        }
        double[][] dArray3 = new double[2][24];
        this.distributeOveragePower(dArray, d2);
        System.arraycopy(dArray[n7], 0, dArray3[1], 0, 24);
        if (d3 != 0.0) {
            n4 = 0;
            int n8 = 0;
            if (n2 == 1) {
                n8 = bl ? 0 : 1;
                n4 = n8 + 1;
            } else if (n2 == 2) {
                n8 = runTimeStep.getDayOfWeek();
                n4 = n3 + 7;
            }
            n3 = runTimeStep.getHecTime().minutesSinceMidnight() / 60;
            double d6 = d - d4;
            double d7 = d6 + d3;
            double d8 = this.getTotalPowerGeneration(runTimeStep, n, dArray);
            double[][] dArray4 = this.expandPattern(dArray, this.m_patternType);
            for (int i = 0; i < n3; ++i) {
                d8 -= dArray4[n8][i];
            }
            if (d8 != 0.0 || n3 == 24) {
                this.slide(runTimeStep, dArray4, d7, d6, n, n8, n3, n4, 24);
                if (n2 == 2 && n8 > 0 && n8 <= 5) {
                    System.arraycopy(dArray4[n8], 0, dArray4[1], 0, 24);
                }
                dArray = this.compressPattern(dArray4, this.m_patternType);
            } else {
                dArray4[n8][n3] = d7;
                dArray = this.compressPattern(dArray4, this.m_patternType);
            }
            double[][] dArray5 = new double[dArray.length][24];
            for (int i = 0; i < dArray.length; ++i) {
                for (int j = 0; j < dArray[i].length; ++j) {
                    dArray5[i][j] = dArray[i][j] - d2;
                }
            }
            double d9 = 0.0;
            for (int i = n8; i < dArray.length; ++i) {
                int n9;
                for (n9 = 0; n9 < dArray[i].length && d9 != 0.0; ++n9) {
                    if (!(dArray[i][n9] > 0.0)) continue;
                    double[] dArray6 = dArray[i];
                    int n10 = n9;
                    dArray6[n10] = dArray6[n10] + d9;
                    double[] dArray7 = dArray5[i];
                    int n11 = n9;
                    dArray7[n11] = dArray7[n11] + d9;
                    break;
                }
                d9 = 0.0;
                for (n9 = n3; n9 < dArray[i].length; ++n9) {
                    if (dArray5[i][n9] <= 0.0) continue;
                    d9 += this.distributeRight(dArray5[i][n9], n9, dArray[i], dArray5[i]);
                    dArray[i][n9] = d2;
                    dArray5[i][n9] = 0.0;
                }
            }
        }
        System.arraycopy(dArray[n7], 0, dArray3[0], 0, 24);
        return dArray3;
    }

    private double getTotalPowerGeneration(RunTimeStep runTimeStep, int n, double[][] dArray) {
        switch (n) {
            case 11: {
                return this.computeDailyPowerGeneration(runTimeStep, dArray);
            }
            case 13: {
                return this.computeMonthlyPowerGeneration(runTimeStep, dArray);
            }
            case 12: {
                return this.computeWeeklyPowerGeneration(runTimeStep, dArray);
            }
        }
        return 0.0;
    }

    private double getTotalPowerGeneration(RunTimeStep runTimeStep, int n) {
        return this.getTotalPowerGeneration(runTimeStep, n, this.m_powerGenPattern);
    }

    private double computeMonthlyPowerGeneration(RunTimeStep runTimeStep, double[][] dArray) {
        double d = 0.0;
        runTimeStep.getHecTime().day();
        int n = runTimeStep.getHecTime().month() - 1;
        int n2 = runTimeStep.getHecTime().year();
        int n3 = SystemPwrGenerationPattern.a(n, n2);
        if (this.m_patternType == 1) {
            return (double)n3 * this.sumArray(dArray[0]);
        }
        HecTime hecTime = new HecTime();
        hecTime.set("01" + this.months[n] + n2);
        hecTime.setTimeIncrement(3);
        n2 = 0;
        for (n = hecTime.day(); n <= n3; ++n) {
            int n4 = RunTimeStep.getDayOfWeek((HecTime)hecTime) + 1;
            switch (this.m_patternType) {
                case 2: {
                    n2 = n4 == 1 || n4 == 7 ? 1 : 0;
                    n2 = n2 != 0 ? 1 : 0;
                    break;
                }
                case 7: {
                    n2 = n4 - 1;
                }
            }
            d += this.sumArray(dArray[n2]);
            hecTime.add(1);
        }
        return d;
    }

    private double computeWeeklyPowerGeneration(RunTimeStep runTimeStep, double[][] dArray) {
        double d = 0.0;
        if (this.m_patternType == 1) {
            d = 7.0 * this.sumArray(dArray[0]);
        } else if (this.m_patternType == 2) {
            d = 5.0 * this.sumArray(dArray[0]) + 2.0 * this.sumArray(dArray[1]);
        } else {
            for (int i = 0; i < this.m_powerGenPattern.length; ++i) {
                d += this.sumArray(dArray[i]);
            }
        }
        return d;
    }

    /*
     * Unable to fully structure code
     */
    private double computeDailyPowerGeneration(RunTimeStep var1_1, double[][] var2_3) {
        var1_2 = var1_1.getDayOfWeek() + 1;
        var3_4 = var1_2 == 1 || var1_2 == 7;
        var4_5 = 0;
        switch (this.m_patternType) {
            case 1: {
                v0 = 0;
                ** GOTO lbl13
            }
            case 7: {
                v0 = var1_2 - 1;
                ** GOTO lbl13
            }
            case 2: {
                v0 = var3_4 != false ? 1 : 0;
lbl13:
                // 3 sources

                var4_5 = v0;
            }
        }
        return this.sumArray(var2_3[var4_5]);
    }

    private int countNonZeroValues(double[] dArray) {
        return this.countNonZeroValues(0, dArray);
    }

    private int countNonZeroValues(int n, double[] dArray) {
        int n2 = 0;
        if (dArray == null) {
            return 0;
        }
        if (n < 0 || n >= dArray.length) {
            return 0;
        }
        while (n < dArray.length) {
            if (RMAConst.isValidValue((double)dArray[n]) && dArray[n] > 0.0) {
                ++n2;
            }
            ++n;
        }
        return n2;
    }

    private double sumArray(double[] dArray) {
        return this.sumArray(0, dArray);
    }

    private double sumArray(int n, double[] dArray) {
        double d = 0.0;
        if (dArray == null) {
            return 0.0;
        }
        if (n < 0 || n >= dArray.length) {
            return 0.0;
        }
        while (n < dArray.length) {
            if (RMAConst.isValidValue((double)dArray[n])) {
                d += dArray[n];
            }
            ++n;
        }
        return d;
    }

    private void scale(RunTimeStep runTimeStep, double[][] dArray, double d, int n) {
        double d2 = this.getTotalPowerGeneration(runTimeStep, n);
        double d3 = d2 != 0.0 ? d / d2 : d;
        for (int i = 0; i < dArray.length; ++i) {
            int n2 = 0;
            while (n2 < dArray[i].length) {
                double[] dArray2 = dArray[i];
                int n3 = n2++;
                dArray2[n3] = dArray2[n3] * d3;
            }
        }
    }

    private double[][] expandPattern(double[][] dArray, int n) {
        double[][] dArray2 = new double[7][24];
        switch (this.m_patternType) {
            case 2: {
                for (int i = 0; i < 5; ++i) {
                    System.arraycopy(dArray[0], 0, dArray2[i + 1], 0, dArray[0].length);
                }
                System.arraycopy(dArray[1], 0, dArray2[0], 0, dArray[1].length);
                System.arraycopy(dArray[1], 0, dArray2[6], 0, dArray[1].length);
                break;
            }
            case 7: {
                for (int i = 0; i < 7; ++i) {
                    System.arraycopy(dArray[i], 0, dArray2[i], 0, dArray[i].length);
                }
                break;
            }
            case 1: {
                for (int i = 0; i < 7; ++i) {
                    System.arraycopy(dArray[0], 0, dArray2[i], 0, dArray[0].length);
                }
                break;
            }
        }
        return dArray2;
    }

    private double[][] compressPattern(double[][] dArray, int n) {
        double[][] dArray2 = null;
        switch (this.m_patternType) {
            case 2: {
                dArray2 = new double[2][24];
                System.arraycopy(dArray[0], 0, dArray2[1], 0, dArray[0].length);
                System.arraycopy(dArray[1], 0, dArray2[0], 0, dArray[0].length);
                break;
            }
            case 7: {
                dArray2 = new double[7][24];
                for (int i = 0; i < 7; ++i) {
                    System.arraycopy(dArray[i], 0, dArray2[i], 0, dArray[i].length);
                }
                break;
            }
            case 1: {
                dArray2 = new double[1][24];
                for (int i = 0; i < 7; ++i) {
                    System.arraycopy(dArray[i], 0, dArray2[0], 0, dArray[0].length);
                }
                break;
            }
        }
        return dArray2;
    }

    private void slide(RunTimeStep object, double[][] dArray, double d, double d2, int n, int n2, int n3, int n4, int n5) {
        int n6;
        double d3 = d;
        n = 0;
        object = new int[dArray.length];
        for (n6 = n2; n6 < n4; ++n6) {
            object[n6 % 7] = (RunTimeStep)this.countNonZeroValues(n3, dArray[n6 % 7]);
            if (object[n6 % 7] <= 0) continue;
            n += object[n6 % 7];
        }
        if (n4 < n2) {
            n4 += 7;
        }
        for (n6 = n2; n6 < n4; ++n6) {
            object = dArray[n6 % 7];
            n2 = 0;
            boolean bl = true;
            double d4 = d2;
            d = d3;
            while (n2 != 0 || bl) {
                double d5 = d - d4;
                double d6 = d5 / (double)n;
                bl = false;
                n2 = 0;
                d4 = 0.0;
                d = 0.0;
                for (int i = n3; i < n5; ++i) {
                    if (object[i] == 0.0) continue;
                    Object object2 = object;
                    int n7 = i;
                    object2[n7] = object2[n7] + d6;
                    d += object[i];
                    if (object[i] < 0.0) {
                        object[i] = (RunTimeStep)0.0;
                        n2 = 1;
                        --n;
                        continue;
                    }
                    d4 += object[i];
                }
            }
        }
    }

    private void distributeOveragePower(double[][] dArray, double d) {
        int n;
        int n2;
        double d2 = 0.0;
        double[][] dArray2 = new double[dArray.length][dArray[0].length];
        for (n2 = 0; n2 < dArray.length; ++n2) {
            for (n = 0; n < dArray[n2].length; ++n) {
                dArray2[n2][n] = dArray[n2][n] - d;
            }
        }
        for (n2 = 0; n2 < dArray.length; ++n2) {
            boolean bl = false;
            for (n = 0; n < dArray[n2].length && d2 != 0.0; ++n) {
                if (!(dArray[n2][n] > 0.0)) continue;
                double[] dArray3 = dArray[n2];
                int n3 = n;
                dArray3[n3] = dArray3[n3] + d2;
                double[] dArray4 = dArray2[n2];
                int n4 = n;
                dArray4[n4] = dArray4[n4] + d2;
                break;
            }
            d2 = 0.0;
            for (n = 0; n < dArray[n2].length; ++n) {
                if (dArray2[n2][n] <= 0.0) continue;
                if (bl) {
                    d2 += dArray2[n2][n];
                    dArray2[n2][n] = 0.0;
                    dArray[n2][n] = d;
                    continue;
                }
                double d3 = this.distributeLeft(dArray2[n2][n] / 2.0, n, dArray[n2], dArray2[n2]);
                d3 = this.distributeRight(dArray2[n2][n] / 2.0 + d3, n, dArray[n2], dArray2[n2]);
                dArray[n2][n] = d;
                dArray2[n2][n] = 0.0;
                if (!(d3 > 0.0)) continue;
                d2 += d3;
                bl = true;
            }
        }
    }

    private double distributeRight(double d, int n, double[] dArray, double[] dArray2) {
        ++n;
        while (n < dArray.length) {
            if (!(dArray2[n] >= 0.0)) {
                double d2;
                double d3 = d + dArray2[n];
                if (d2 <= 0.0) {
                    int n2 = n;
                    dArray[n2] = dArray[n2] + d;
                    dArray2[n] = d3;
                    return 0.0;
                }
                int n3 = n;
                dArray[n3] = dArray[n3] + -1.0 * dArray2[n];
                d = d3;
                dArray2[n] = 0.0;
            }
            ++n;
        }
        return d;
    }

    private double distributeLeft(double d, int n, double[] dArray, double[] dArray2) {
        --n;
        while (n >= 0) {
            if (!(dArray2[n] >= 0.0)) {
                double d2;
                double d3 = d + dArray2[n];
                if (d2 <= 0.0) {
                    int n2 = n;
                    dArray[n2] = dArray[n2] + d;
                    dArray2[n] = d3;
                    return 0.0;
                }
                int n3 = n;
                dArray[n3] = dArray[n3] + -1.0 * dArray2[n];
                d = d3;
                dArray2[n] = 0.0;
            }
            --n;
        }
        return d;
    }

    public static void a(String[] object) {
        object = new SystemPwrGenerationPattern();
        for (int i = 0; i < ((SystemPwrGenerationPattern)object).m_patternType; ++i) {
            for (int j = 0; j < 24; ++j) {
                ((SystemPwrGenerationPattern)object).m_powerGenPattern[i][j] = 50.0;
            }
        }
        ((SystemPwrGenerationPattern)object).setPwrGenPatternType(1);
        System.out.println("Finished");
    }

    protected static int a(int n, int n2) {
        if (n == 1 && n2 % 4 == 0 && (n2 % 100 != 0 || n2 % 400 == 0)) {
            return 29;
        }
        try {
            return a[n];
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return 0;
        }
    }

    private int computeNonZeroPatternValues(int n, RunTimeStep runTimeStep) {
        return this.computeNonZeroPatternValues(n, runTimeStep, this.m_powerGenPattern);
    }

    private int computeNonZeroPatternValues(int n, RunTimeStep runTimeStep, double[][] dArray) {
        switch (n) {
            case 11: {
                return this.computeDailyNonZeroPatternValues(runTimeStep, dArray);
            }
            case 13: {
                return this.computeMonthlyNonZeroPatternValues(runTimeStep, dArray);
            }
            case 12: {
                return this.computeWeeklyNonZeroPatternValues(runTimeStep, dArray);
            }
        }
        return 0;
    }

    private int computeMonthlyNonZeroPatternValues(RunTimeStep runTimeStep, double[][] dArray) {
        int n = 0;
        runTimeStep.getHecTime().day();
        int n2 = runTimeStep.getHecTime().month() - 1;
        int n3 = runTimeStep.getHecTime().year();
        int n4 = SystemPwrGenerationPattern.a(n2, n3);
        if (this.m_patternType == 1) {
            return n4 * this.countNonZeroValues(dArray[0]);
        }
        HecTime hecTime = new HecTime();
        hecTime.set("01" + this.months[n2] + n3);
        hecTime.setTimeIncrement(3);
        n3 = 0;
        for (n2 = hecTime.day(); n2 <= n4; ++n2) {
            int n5 = RunTimeStep.getDayOfWeek((HecTime)hecTime) + 1;
            switch (this.m_patternType) {
                case 2: {
                    n3 = n5 == 1 || n5 == 7 ? 1 : 0;
                    n3 = n3 != 0 ? 1 : 0;
                    break;
                }
                case 7: {
                    n3 = n5 - 1;
                }
            }
            n += this.countNonZeroValues(dArray[n3]);
            hecTime.add(1);
        }
        return n;
    }

    private int computeWeeklyNonZeroPatternValues(RunTimeStep runTimeStep, double[][] dArray) {
        int n = 0;
        if (this.m_patternType == 1) {
            n = 7 * this.countNonZeroValues(dArray[0]);
        } else if (this.m_patternType == 2) {
            n = 5 * this.countNonZeroValues(dArray[0]) + 2 * this.countNonZeroValues(dArray[1]);
        } else {
            for (int i = 0; i < this.m_powerGenPattern.length; ++i) {
                n += this.countNonZeroValues(dArray[i]);
            }
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    private int computeDailyNonZeroPatternValues(RunTimeStep var1_1, double[][] var2_3) {
        var1_2 = var1_1.getDayOfWeek() + 1;
        var3_4 = var1_2 == 1 || var1_2 == 7;
        var4_5 = 0;
        switch (this.m_patternType) {
            case 1: {
                v0 = 0;
                ** GOTO lbl13
            }
            case 7: {
                v0 = var1_2 - 1;
                ** GOTO lbl13
            }
            case 2: {
                v0 = var3_4 != false ? 1 : 0;
lbl13:
                // 3 sources

                var4_5 = v0;
            }
        }
        return this.countNonZeroValues(var2_3[var4_5]);
    }

    public Object getFieldObject(Field object) {
        try {
            object = ((Field)object).get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public synchronized Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println("CloneNotSupportedException => " + cloneNotSupportedException.getMessage());
            cloneNotSupportedException.printStackTrace();
            return null;
        }
    }
}

