/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.heclib.util.intContainer;
import hec.io.AsciiSerializable;
import hec.lang.NamedType;
import hec.rss.model.OpSetRef;
import hec.rss.model.ResSystemOpSet;
import hec.rss.model.ReservoirElement;
import hec.rss.model.SystemOpRule;
import hec.rss.model.SystemOpRuleRef;
import hec.rss.model.SystemReservoirStorage;
import hec.rss.model.ZoneBounds;
import hec.rss.model.reports.AltInputReportInfc;
import hec.rss.model.reports.AlternativeInputReport;
import hec.util.XMLUtilities;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.jdom.Content;
import org.jdom.Element;
import rma.util.RMASort;

public class SystemStorageZone
extends NamedType
implements AsciiSerializable,
AltInputReportInfc,
Serializable,
Cloneable {
    private Hashtable _storageTable = new Hashtable();
    private Hashtable _zoneTable = new Hashtable();
    private Hashtable _ruleRefTable = new Hashtable();
    private int _nextIndex = 1;
    protected transient ResSystemOpSet a = null;

    public SystemStorageZone() {
    }

    public SystemStorageZone(int n, String string, String string2) {
        this();
        this.setIndex(n);
        this.setName(string);
        this.setDescription(string2);
    }

    public int getNumResevoirStorages() {
        return this._zoneTable.size();
    }

    public ReservoirElement getReservoir(int n) {
        return this.a.getReservoir(n);
    }

    public ResSystemOpSet getSystemOpSet() {
        return this.a;
    }

    public void setParent(ResSystemOpSet resSystemOpSet) {
        this.a = resSystemOpSet;
    }

    public String toString() {
        return this.getName();
    }

    public SystemReservoirStorage getSystemStorage(int n) {
        SystemReservoirStorage systemReservoirStorage = (SystemReservoirStorage)this._storageTable.get(new intContainer(n));
        if (systemReservoirStorage == null) {
            return null;
        }
        systemReservoirStorage.setParent(this);
        return systemReservoirStorage;
    }

    public void deleteSystemStorage(int n) {
        this._storageTable.remove(new intContainer(n));
    }

    public void deleteZoneBounds(int n) {
        this._zoneTable.remove(new intContainer(n));
    }

    public ZoneBounds getStorageZoneBounds(int n) {
        ZoneBounds zoneBounds = (ZoneBounds)this._zoneTable.get(new intContainer(n));
        if (zoneBounds == null) {
            return null;
        }
        zoneBounds.setParent(this);
        return zoneBounds;
    }

    public Vector getAllStorageZoneBounds() {
        Enumeration enumeration = this._zoneTable.elements();
        Vector<ZoneBounds> vector = new Vector<ZoneBounds>();
        while (enumeration.hasMoreElements()) {
            ZoneBounds zoneBounds = (ZoneBounds)enumeration.nextElement();
            zoneBounds.setParent(this);
            vector.addElement(zoneBounds);
        }
        return vector;
    }

    public ZoneBounds getDefaultZoneBounds() {
        Enumeration enumeration = this._zoneTable.elements();
        if (enumeration.hasMoreElements()) {
            enumeration = (ZoneBounds)enumeration.nextElement();
            ((ZoneBounds)((Object)enumeration)).setParent(this);
            return enumeration;
        }
        return null;
    }

    public void addSystemReservoirStorage(ReservoirElement reservoirElement, SystemReservoirStorage systemReservoirStorage) {
        if (reservoirElement == null || systemReservoirStorage == null) {
            return;
        }
        int n = reservoirElement.getIndex();
        systemReservoirStorage.setIndex(this.getNextIndex());
        systemReservoirStorage.setParent(this);
        this._storageTable.put(new intContainer(n), systemReservoirStorage);
    }

    public void addStorageZoneBounds(ReservoirElement reservoirElement, ZoneBounds zoneBounds) {
        if (reservoirElement == null || zoneBounds == null) {
            return;
        }
        zoneBounds.setParent(this);
        zoneBounds.setIndex(this.getNextIndex());
        this._zoneTable.put(new intContainer(reservoirElement.getIndex()), zoneBounds);
    }

    public SystemOpRuleRef addSystemRuleReference(SystemOpRule systemOpRule) {
        if (systemOpRule == null) {
            return null;
        }
        Object object = new intContainer(systemOpRule.getIndex());
        if ((object = (SystemOpRuleRef)this._ruleRefTable.get(object)) == null) {
            object = new SystemOpRuleRef(this, systemOpRule);
            object.setIndex(systemOpRule.getIndex());
            ((SystemOpRuleRef)object).setPriority(this._ruleRefTable.size() + 1);
            object.setName(systemOpRule.getName());
            this._ruleRefTable.put(new intContainer(systemOpRule.getIndex()), object);
        }
        return object;
    }

    public void removeRuleRef(SystemOpRule systemOpRule) {
        if (systemOpRule == null) {
            return;
        }
        this._ruleRefTable.remove(new intContainer(systemOpRule.getIndex()));
    }

    public Vector getSortedZoneRuleRefs(boolean bl) {
        Vector<SystemOpRuleRef> vector = new Vector<SystemOpRuleRef>();
        Vector<Float> vector2 = new Vector<Float>();
        Enumeration enumeration = this._ruleRefTable.elements();
        while (enumeration.hasMoreElements()) {
            SystemOpRuleRef systemOpRuleRef = (SystemOpRuleRef)enumeration.nextElement();
            vector.add(systemOpRuleRef);
            vector2.add(new Float(systemOpRuleRef.getPriority()));
        }
        RMASort.quickSort(vector2, vector, (boolean)bl);
        return vector;
    }

    private int getNextIndex() {
        return this._nextIndex++;
    }

    public Object clone() {
        try {
            Object object;
            SystemStorageZone systemStorageZone = (SystemStorageZone)super.clone();
            Object object2 = this._storageTable.elements();
            systemStorageZone._storageTable = new Hashtable();
            while (object2.hasMoreElements()) {
                object = (SystemReservoirStorage)((SystemReservoirStorage)object2.nextElement()).clone();
                ((SystemReservoirStorage)object).setParent(systemStorageZone);
                systemStorageZone._storageTable.put(new intContainer(((SystemReservoirStorage)object).getReservoirId()), object);
            }
            object = this._zoneTable.elements();
            systemStorageZone._zoneTable = new Hashtable();
            while (object.hasMoreElements()) {
                object2 = (ZoneBounds)((ZoneBounds)object.nextElement()).clone();
                ((ZoneBounds)object2).setParent(systemStorageZone);
                systemStorageZone._zoneTable.put(new intContainer(((ZoneBounds)object2).getReservoirID()), object2);
            }
            object2 = this._ruleRefTable.elements();
            systemStorageZone._ruleRefTable = new Hashtable();
            while (object2.hasMoreElements()) {
                object = (SystemOpRuleRef)((SystemOpRuleRef)object2.nextElement()).clone();
                if (object == null) {
                    System.out.println("error cloning a rule reference");
                    continue;
                }
                ((SystemOpRuleRef)object).setParent(systemStorageZone);
                systemStorageZone._ruleRefTable.put(new intContainer(object.getIndex()), object);
            }
            systemStorageZone._nextIndex = this._nextIndex;
            systemStorageZone.a = this.a;
            return systemStorageZone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println("Clone Error when cloning System Storage Zone" + this.getName());
            System.out.println(cloneNotSupportedException.getMessage());
            return null;
        }
    }

    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, Element object) {
        object.setAttribute("ZoneName", this.getName());
        Element element = new Element("ReservoirsUsed");
        object.addContent((Content)element);
        Enumeration enumeration = this._storageTable.elements();
        while (enumeration.hasMoreElements()) {
            SystemReservoirStorage systemReservoirStorage = (SystemReservoirStorage)enumeration.nextElement();
            alternativeInputReport = new Element("Reservoir");
            element.addContent((Content)alternativeInputReport);
            object = this.getReservoir(systemReservoirStorage.getReservoirId());
            alternativeInputReport.setAttribute("ReservoirName", object.getName());
            object = this.a.getOpSetReferences((ReservoirElement)object);
            alternativeInputReport.setAttribute("OperationSet", ((OpSetRef)object).getOpSet().getName());
            object = (ZoneBounds)this._zoneTable.get(new intContainer(systemReservoirStorage.getReservoirId()));
            ((ZoneBounds)object).setParent(this);
            alternativeInputReport.setAttribute("SelectedStorageZone", ((ZoneBounds)object).getUpperBound().getDisplayName());
            object = new Element("StorageValues");
            alternativeInputReport.addContent((Content)object);
            XMLUtilities.createArrayElements((Element)object, (double[])systemReservoirStorage.getStorageValues());
        }
    }
}

