/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.TSRecordProxy;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.heclib.dss.DSSPathname;
import hec.heclib.util.doubleArrayContainer;
import hec.io.AsciiSerializable;
import hec.io.DSSIdentifier;
import hec.model.ModelVariable;
import hec.model.PairedValues;
import hec.model.RunTimeStep;
import hec.model.TSLocation;
import hec.rss.model.Element;
import hec.rss.model.IndependentVariable;
import hec.rss.model.Junction;
import hec.rss.model.JunctionElement;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssModelVariableConstants;
import hec.rss.model.RssRatingObject;
import hec.rss.model.RssReturnStatusConstants;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.reports.AltInputReportInfc;
import hec.rss.model.reports.AlternativeInputReport;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.jdom.Content;
import rma.util.DSSPathPartGenerator;
import rma.util.RMAConst;

public class TailwaterElevation
extends RssTSLocationObject
implements AsciiSerializable,
RssModelVariableConstants,
AltInputReportInfc,
Serializable,
Cloneable {
    Element _element;
    boolean _usesConstElev = false;
    double _constElev = Double.NEGATIVE_INFINITY;
    boolean _usesDnstrmElev = false;
    int _dnstrmJuncId = Integer.MIN_VALUE;
    boolean _usesRatingCurveElev = false;
    PairedValues _ratingCurve = new PairedValues();
    double _stageDatum = 0.0;
    RssRatingObject _ratingObject;
    private transient doubleArrayContainer a;
    private transient doubleArrayContainer b;
    private transient doubleArrayContainer c;

    public TailwaterElevation() {
    }

    public TailwaterElevation(Element element) {
        this._element = element;
        this._ratingObject = new RssRatingObject(element);
    }

    public void getElementDependencies(List<Element> list, Element element) {
        if (list == null || element == null) {
            return;
        }
        Object object = element.getSystem();
        int n = this.getDnstrmJuncId();
        if (n != Integer.MIN_VALUE && this.usesDnstrmElev() && (object = ((RssSystem)object).getElement(n)) != null && (object = ((Element)object).getTopParent()) != element && !list.contains(object)) {
            list.add((Element)object);
        }
        if (this._ratingObject != null && this._ratingObject.usesIndependentVariable()) {
            object = this._ratingObject.getIndependentVariable();
            ((IndependentVariable)object).getElementDependencies(list, element);
        }
    }

    protected String getOutputBPart() {
        ArrayList<String> arrayList = this.getElement().getFullNameList();
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
        }
        arrayList.add("TAILWATER");
        return this.getElement().getSystem().generateUniquePathPart(arrayList, "-");
    }

    public void setupForSerialization() {
        if (this._ratingCurve != null) {
            Object object = new DSSPathname();
            object.setAPart(this.getElement().getSystem().getName());
            Object object2 = new DSSPathPartGenerator();
            String string = this.getElement().getTopParent().getName();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            string = object2.generatePathnamePart(arrayList, "");
            object.setAPart(string);
            arrayList.clear();
            arrayList.add(this.getElement().getParent().getName());
            arrayList.add("Tail Rating Curve");
            object2 = object2.generatePathnamePart(arrayList, "-");
            object.setBPart((String)object2);
            object2 = Parameter.getParamString((int)Parameter.PARAMID_STAGE) + "-" + Parameter.getParamString((int)Parameter.PARAMID_FLOW);
            object.setCPart((String)object2);
            object2 = this.getElement().getSystem().getDssPairedDataFilePath();
            object = object.getPathname();
            this._ratingCurve.setDssIdentifer(new DSSIdentifier((String)object2, (String)object));
            this._ratingCurve.setParamXId(Parameter.PARAMID_STAGE);
            this._ratingCurve.setParamYId(Parameter.PARAMID_FLOW);
            this._ratingCurve.setUnitSystem(this.getElement().getUnitSystem());
        }
        if (this._ratingObject != null) {
            this._ratingObject.setRatingName("Tail Rating Curve");
            this._ratingObject.setupForSerialization();
        }
    }

    @Override
    public synchronized Object clone() {
        TailwaterElevation tailwaterElevation = (TailwaterElevation)super.clone();
        ((TailwaterElevation)super.clone())._ratingCurve = (PairedValues)this._ratingCurve.clone();
        if (this._ratingObject != null) {
            tailwaterElevation._ratingObject = (RssRatingObject)((RssTSLocationObject)this._ratingObject).clone();
            tailwaterElevation._ratingObject.setElement(tailwaterElevation._element);
        }
        return tailwaterElevation;
    }

    public void initialize() {
        this.a = null;
        this.b = null;
        if (this._element != null && this._element.getNode(1) == null) {
            return;
        }
        RssReturnStatusConstants rssReturnStatusConstants = this._element.getNode(1);
        this.a = rssReturnStatusConstants.getTSContainer(0);
        if (this._element.getFunction() != null) {
            this.b = this._element.getFunction().getTSContainer(30);
        }
        this.c = null;
        if (this._usesDnstrmElev && this._dnstrmJuncId != Integer.MIN_VALUE) {
            rssReturnStatusConstants = this.getElement().getSystem();
            if ((rssReturnStatusConstants = ((RssSystem)rssReturnStatusConstants).getElement(this._dnstrmJuncId)) instanceof JunctionElement) {
                if (((JunctionElement)(rssReturnStatusConstants = (JunctionElement)rssReturnStatusConstants)).hasRatingCurve()) {
                    rssReturnStatusConstants = (Junction)((Element)rssReturnStatusConstants).getFunction();
                    this.c = ((RssTSLocationObject)rssReturnStatusConstants).getTSContainer(68);
                }
            } else if (rssReturnStatusConstants instanceof ReservoirElement) {
                this.c = ((ReservoirElement)rssReturnStatusConstants).getStorageFunction().getTSContainer(10);
            }
        }
        if (this._ratingObject != null) {
            this._ratingObject.initialize();
        }
    }

    public void computeElevation(RunTimeStep runTimeStep) {
        if (this.b == null) {
            return;
        }
        this.b.array[runTimeStep.step] = this.getElevation(runTimeStep);
    }

    public void setElement(Element element) {
        this._element = element;
        if (this._ratingObject != null) {
            this._ratingObject.setElement(element);
        }
    }

    public Element getElement() {
        return this._element;
    }

    public boolean usesConstElev() {
        return this._usesConstElev;
    }

    public void setUsesConstElev(boolean bl) {
        this._usesConstElev = bl;
    }

    public void getConstElev(ParamDouble paramDouble) {
        paramDouble.setValue(this._constElev);
        paramDouble.setUnitSystem(this._element.getUnitSystem());
        paramDouble.setParameterId(Parameter.PARAMID_ELEV);
    }

    public double getElevation(RunTimeStep runTimeStep) {
        double d = Double.NEGATIVE_INFINITY;
        if (this._usesRatingCurveElev || this._ratingObject != null && this._ratingObject.usesIndependentVariable()) {
            if (this._ratingObject != null && this._ratingObject.usesIndependentVariable()) {
                double d2;
                d = d2 = this._ratingObject.getElevation(runTimeStep, 0.0);
            } else if (this._usesRatingCurveElev && this._ratingCurve != null && this.a != null) {
                double d3 = this.a.array[runTimeStep.step];
                double d4 = this._ratingCurve.getXValue(d3);
                double d5 = 0.0;
                if (RMAConst.isValidValue((double)this._stageDatum)) {
                    d5 = this._stageDatum;
                }
                d = d4 + d5;
            }
        }
        if (this._usesDnstrmElev && this.c != null) {
            int n = runTimeStep.step - 1;
            if (n < 0) {
                n = 0;
            }
            if (RMAConst.isValidValue((double)this.c.array[n]) && this.c.array[n] > d) {
                d = this.c.array[n];
            }
        }
        if (this._usesConstElev && this._constElev != Double.NEGATIVE_INFINITY && this._constElev > d) {
            d = this._constElev;
        }
        return d;
    }

    public void getElevation(RunTimeStep runTimeStep, ParamDouble paramDouble) {
        double d = this.getElevation(runTimeStep);
        paramDouble.setValue(d);
        paramDouble.setUnitSystem(this._element.getUnitSystem());
        paramDouble.setParameterId(Parameter.PARAMID_ELEV);
    }

    public boolean isDefined(RunTimeStep runTimeStep) {
        if (this._usesRatingCurveElev && this._ratingCurve != null && this.a != null) {
            double d = this.a.array[runTimeStep.step];
            return RMAConst.isValidValue((double)d);
        }
        if (this._usesConstElev) {
            return RMAConst.isValidValue((double)this._constElev);
        }
        if (this._usesDnstrmElev && this.c != null) {
            int n = runTimeStep.step;
            return RMAConst.isValidValue((double)this.c.array[n]);
        }
        return false;
    }

    public void setConstElev(ParamDouble paramDouble) {
        this._constElev = paramDouble.getValue();
    }

    public boolean usesDnstrmElev() {
        return this._usesDnstrmElev;
    }

    public void setUsesDnstrmElev(boolean bl) {
        this._usesDnstrmElev = bl;
    }

    public void setDnstrmJuncId(int n) {
        this._dnstrmJuncId = n;
    }

    public int getDnstrmJuncId() {
        return this._dnstrmJuncId;
    }

    public boolean usesRatingCurveElev() {
        return this._usesRatingCurveElev;
    }

    public void setUsesRatingCurveElev(boolean bl) {
        this._usesRatingCurveElev = bl;
    }

    public PairedValues getRatingCurve() {
        this._ratingCurve.setUnitSystem(this._element.getUnitSystem());
        this._ratingCurve.setParamXId(Parameter.PARAMID_STAGE);
        this._ratingCurve.setParamYId(Parameter.PARAMID_FLOW);
        return (PairedValues)this._ratingCurve.clone();
    }

    public void setRatingCurve(PairedValues pairedValues) {
        if (pairedValues == null) {
            return;
        }
        this._ratingCurve = pairedValues;
        this._ratingCurve.setUnitSystem(this._element.getUnitSystem());
        this._ratingCurve.setParamXId(Parameter.PARAMID_STAGE);
        this._ratingCurve.setParamYId(Parameter.PARAMID_FLOW);
    }

    public void getStageDatum(ParamDouble paramDouble) {
        paramDouble.setValue(this._stageDatum);
        paramDouble.setUnitSystem(this._element.getUnitSystem());
        paramDouble.setParameterId(Parameter.PARAMID_ELEV);
    }

    public void setStageDatum(ParamDouble paramDouble) {
        this._stageDatum = paramDouble.getValue();
    }

    public RssRatingObject getRatingObject() {
        if (this._ratingObject == null) {
            this._ratingObject = new RssRatingObject(this._element);
            IndependentVariable independentVariable = this.getDefaultIndependentVariable();
            this._ratingObject.setIndependentVariable(independentVariable);
            this._ratingObject.setRatingName("Tail Rating Curve");
        }
        return this._ratingObject;
    }

    public void setRatingObject(RssRatingObject rssRatingObject) {
        this._ratingObject = rssRatingObject;
    }

    public int getDownstreamModelVariableElementId() {
        int n = Integer.MIN_VALUE;
        if (this._ratingObject != null && this._ratingObject.usesIndependentVariable()) {
            n = this._ratingObject.getDownstreamModelVariableElementId(this._element);
        }
        return n;
    }

    public IndependentVariable getDefaultIndependentVariable() {
        IndependentVariable independentVariable = new IndependentVariable(2);
        TSLocation tSLocation = this.getElement();
        Element element = tSLocation.getTopParent();
        tSLocation = tSLocation.getNode(1);
        TSRecordProxy tSRecordProxy = null;
        if (tSLocation != null) {
            tSRecordProxy = tSLocation.getTSRecordProxy(0);
        }
        tSLocation = new ModelVariable("Node", "Flow", 0, Parameter.PARAMID_FLOW);
        independentVariable.setModalVariableInfo(tSRecordProxy, element, (ModelVariable)tSLocation);
        return independentVariable;
    }

    @Override
    public Vector getActiveTSRecordProxies(Vector vector, int n) {
        if (n == 0) {
            if (this._element == null) {
                return vector;
            }
            TSRecordProxy tSRecordProxy = this._element.getFunction().getTSRecordProxy(30);
            if (tSRecordProxy != null) {
                vector.addElement(tSRecordProxy);
            }
        }
        if (this._ratingObject != null) {
            ((RssTSLocationObject)this._ratingObject).getActiveTSRecordProxies(vector, n);
        }
        return vector;
    }

    public Vector getActiveTSProxies(Vector vector, int n) {
        if (vector == null) {
            vector = new Vector<TSRecordProxy>();
        }
        boolean bl = false;
        if (n == 1) {
            bl = true;
        }
        int n2 = this._tsrecordVector.size();
        for (int i = 0; i < n2; ++i) {
            TSRecordProxy tSRecordProxy = (TSRecordProxy)this._tsrecordVector.elementAt(i);
            if (tSRecordProxy.isInput() != bl) continue;
            vector.add(tSRecordProxy);
        }
        if (this._ratingObject != null) {
            this._ratingObject.getActiveTSProxies(vector, n);
        }
        return vector;
    }

    @Override
    public void updateTSProxyList() {
        if (this._element == null) {
            return;
        }
        if (this._element.getFunction() != null && this._element.getFunction().getTSRecordProxy(30) == null) {
            this._element.getFunction().addTSRecordProxy(30);
        }
        if (this._ratingObject != null) {
            ((RssTSLocationObject)this._ratingObject).updateTSProxyList();
        }
    }

    public void getReferencedStateVariables(List list) {
        if (this._ratingObject != null) {
            this._ratingObject.getReferencedStateVariables(list);
        }
    }

    @Override
    public RssSystem getSystem() {
        return this._element.getSystem();
    }

    @Override
    public Object getFieldObject(Field object) {
        try {
            object = ((Field)object).get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, org.jdom.Element element) {
        element.setAttribute("Use_Constant_Elev", Boolean.toString(this._usesConstElev));
        if (this._usesConstElev) {
            element.setAttribute("Constant_Elev", Double.toString(this._constElev));
        }
        element.setAttribute("Use_Downstream_Control", Boolean.toString(this._usesDnstrmElev));
        if (this._usesDnstrmElev) {
            element.setAttribute("Downstream_Controll", Double.toString(this._dnstrmJuncId));
        }
        element.setAttribute("Use_Rating_Curve", Boolean.toString(this._usesRatingCurveElev));
        if (this._usesRatingCurveElev) {
            org.jdom.Element element2 = new org.jdom.Element("Rating_Curve");
            element.addContent((Content)element2);
            this.getRatingObject().outputReport(alternativeInputReport, element2);
        }
        if (this._usesRatingCurveElev) {
            element.setAttribute("Downstream_Controll", Double.toString(this._dnstrmJuncId));
        }
    }
}

