/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.TSRecordProxy;
import hec.heclib.util.doubleArrayContainer;
import hec.model.RunTimeStep;
import hec.rss.model.DemandRuleInf;
import hec.rss.model.Element;
import hec.rss.model.OpRule;
import hec.rss.model.OpValue;
import hec.rss.model.OperationsElement;
import hec.rss.model.ReservoirElement;
import hec.rss.model.ReservoirOutletElement;
import hec.rss.model.RssReturnStatusConstants;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.Storage;
import hec.rss.model.TandemOp;
import hec.rss.model.WaterAccount;
import hec.rss.model.reports.AlternativeInputReport;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import rma.util.RMAConst;

public class TandemOpRule
extends OpRule
implements DemandRuleInf {
    int _reservoirIndex;
    private transient RunTimeStep a;
    private transient Storage b;
    private transient Storage c;
    private transient Vector d;
    private transient boolean[] e;
    private transient double[] f;
    private transient Vector i;
    private transient doubleArrayContainer j;
    private transient WaterAccount k;
    private Hashtable _childFractionTable;

    public TandemOpRule() {
    }

    public TandemOpRule(String string) {
        super(string);
    }

    @Override
    public void getElementDependencies(List list) {
        ReservoirElement reservoirElement = this.getTandemReservoir();
        if (reservoirElement != null && !list.contains(reservoirElement)) {
            list.add(reservoirElement);
        }
    }

    @Override
    public Vector getActiveTSRecordProxies(Vector vector, int n) {
        vector = super.getActiveTSRecordProxies(vector, n);
        if (n == 0) {
            TandemOpRule tandemOpRule = this;
            TSRecordProxy tSRecordProxy = tandemOpRule.getTSRecordProxy(tandemOpRule.getTSProxyName(), 89);
            if (tSRecordProxy != null) {
                vector.addElement(tSRecordProxy);
            }
        }
        return vector;
    }

    @Override
    public void updateTSProxyList() {
        super.updateTSProxyList();
        TandemOpRule tandemOpRule = this;
        if (tandemOpRule.getTSRecordProxy(tandemOpRule.getTSProxyName(), 89) == null) {
            TandemOpRule tandemOpRule2 = this;
            tandemOpRule2.addTSRecordProxy(tandemOpRule2.getTSProxyName(), 89);
        }
    }

    @Override
    public void evaluateLimits(RunTimeStep runTimeStep, int n) {
    }

    public void setBalanceStor(RunTimeStep runTimeStep, double d, double d2) {
        double d3;
        int n;
        if (this.j != null && this.j.array != null) {
            this.j.array[runTimeStep.step] = d;
        }
        if ((n = !runTimeStep.isPerAvgTimeStep() ? 1 : 0) != 0) {
            n = runTimeStep.step - 1;
            if (n < 0) {
                n = 0;
            }
            double[] dArray = this.b.getOutflowArray();
            d3 = (d2 / (double)runTimeStep.getTimeStepSeconds() * Storage.DSDT_TO_Q * 2.0 - dArray[n] * 0.8) / 1.2;
        } else {
            d3 = d2 / (double)runTimeStep.getTimeStepSeconds() * Storage.DSDT_TO_Q;
        }
        if (this.h != null) {
            this.h.array[runTimeStep.step] = d3;
        }
    }

    public void setRuleLimit(RunTimeStep runTimeStep, double d) {
        if (this.h != null) {
            this.h.array[runTimeStep.step] = d;
        }
    }

    @Override
    public OpValue getOpValue(RunTimeStep runTimeStep) {
        if (this.h == null || this.h.array == null || !RMAConst.isValidValue((double)this.h.array[runTimeStep.step])) {
            return null;
        }
        OpValue opValue = new OpValue();
        new OpValue().type = 1;
        opValue.value = this.h.array[runTimeStep.step];
        opValue.childFractionTable = this._childFractionTable;
        return opValue;
    }

    @Override
    public boolean isLocalRule() {
        return false;
    }

    @Override
    public boolean isDnstrmRule() {
        return true;
    }

    @Override
    public boolean isPerAvgRule() {
        return false;
    }

    public void setReservoirIndex(int n) {
        this._reservoirIndex = n;
    }

    public int getReservoirIndex() {
        return this._reservoirIndex;
    }

    public ReservoirElement getTandemReservoir() {
        return (ReservoirElement)((RssTSLocationObject)this).getSystem().getElement(this._reservoirIndex);
    }

    @Override
    public int getRuleLimitType() {
        return 1;
    }

    @Override
    public boolean initializeCompute() {
        this.j = null;
        if (!super.initializeCompute()) {
            return false;
        }
        OperationsElement operationsElement = this._controller.getElementOp().getOperationsElement();
        if (operationsElement == null) {
            ((RssTSLocationObject)this).getSystem().printErrorMessage("Error: TandemOpRule.initializeCompute failed to find reservoir");
            return false;
        }
        this.b = operationsElement.getStorageFunction();
        ReservoirElement reservoirElement = ((RssTSLocationObject)this).getSystem().findReservoir(this._reservoirIndex);
        if (reservoirElement == null) {
            ((RssTSLocationObject)this).getSystem().printErrorMessage("Error: TandemOpRule.initializeCompute failed to find downstream reservoir");
            return false;
        }
        int n = operationsElement.getChildElementCount();
        if (n > 2) {
            Object object;
            int n2;
            this._childFractionTable = new Hashtable(n);
            RssSystem rssSystem = ((RssTSLocationObject)this._controller).getSystem();
            int n3 = 0;
            for (n2 = 0; n2 < n; ++n2) {
                object = operationsElement.getChildElementAt(n2);
                if (!(object instanceof ReservoirOutletElement) || !(object = rssSystem.getDownstreamElements((Element)object)).contains(reservoirElement)) continue;
                this._childFractionTable.put(n2, Float.valueOf(1.0f));
                ++n3;
            }
            for (n2 = 0; n2 < n; ++n2) {
                object = n2;
                if (this._childFractionTable.get(object) == null) continue;
                this._childFractionTable.put(n2, new Float(1.0f / (float)n3));
            }
        } else {
            this._childFractionTable = null;
        }
        this.c = reservoirElement.getStorageFunction();
        this.a = new RunTimeStep();
        this.i = new Vector();
        this.d = new Vector();
        this.d.add(operationsElement);
        this.d.add(reservoirElement);
        this.e = new boolean[2];
        this.e[0] = true;
        this.e[1] = true;
        this.f = new double[2];
        this.j = this.getTSContainer(this.getTSProxyName(), 89);
        return true;
    }

    @Override
    public OpValue evaluateRule(RunTimeStep runTimeStep, double d, int n, boolean bl) {
        double d2;
        if (n < 0) {
            return null;
        }
        RssReturnStatusConstants rssReturnStatusConstants = ((RssTSLocationObject)this).getSystem();
        rssReturnStatusConstants = ((RssSystem)rssReturnStatusConstants).getTandemOp();
        if (!bl) {
            ((TandemOp)rssReturnStatusConstants).a(this);
            return null;
        }
        double d3 = ((TandemOp)rssReturnStatusConstants).a(this, runTimeStep);
        int n2 = !runTimeStep.isPerAvgTimeStep() ? 1 : 0;
        if (n2 != 0) {
            n2 = runTimeStep.step - 1;
            if (n2 < 0) {
                n2 = 0;
            }
            double[] dArray = this.b.getOutflowArray();
            d2 = (d3 / (double)runTimeStep.getTimeStepSeconds() * Storage.DSDT_TO_Q * 2.0 - dArray[n2] * 0.8) / 1.2;
        } else {
            d2 = d3 / (double)runTimeStep.getTimeStepSeconds() * Storage.DSDT_TO_Q;
        }
        OpValue opValue = new OpValue();
        new OpValue().type = 1;
        opValue.value = d2;
        return opValue;
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, org.jdom.Element element) {
        super.outputReport(alternativeInputReport, element);
        element.setAttribute("Rule", "Tandem");
        element.setAttribute("DownstreamReservoirID", Integer.toString(this.getReservoirIndex()));
    }

    @Override
    public WaterAccount getWaterAccount() {
        return this.k;
    }

    @Override
    public void setWaterAccount(WaterAccount waterAccount) {
        this.k = waterAccount;
    }
}

