/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.io.AsciiSerializable;
import hec.rss.model.reports.AltInputReportInfc;
import hec.rss.model.reports.AlternativeInputReport;
import hec.util.XMLUtilities;
import java.io.Serializable;
import java.lang.reflect.Field;
import org.jdom.Content;
import org.jdom.Element;
import rma.util.RMAConst;

public class TimeOfDayMultiplier
implements AsciiSerializable,
AltInputReportInfc,
Serializable,
Cloneable {
    private double[] _multiplier;
    private transient boolean a = false;
    private transient boolean b = true;
    private int _interval = 1;

    public TimeOfDayMultiplier() {
        int n = 24 / this._interval;
        this._multiplier = new double[n];
        for (int i = 0; i < n; ++i) {
            this._multiplier[i] = 1.0;
        }
    }

    public boolean isDefaults() {
        if (this._multiplier == null || this._interval == 0) {
            return true;
        }
        if (this.b) {
            this.a = true;
            int n = 24 / this._interval;
            for (int i = 0; i < n; ++i) {
                if (this._multiplier[i] == 1.0 || !RMAConst.isValidValue((double)this._multiplier[i])) continue;
                this.a = false;
                break;
            }
            this.b = false;
        }
        return this.a;
    }

    public boolean isAllZeroes() {
        if (this._multiplier == null || this._interval == 0) {
            return true;
        }
        boolean bl = true;
        int n = 24 / this._interval;
        for (int i = 0; i < n; ++i) {
            if (this._multiplier[i] == 0.0 || !RMAConst.isValidValue((double)this._multiplier[i])) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public double getLargestHourlyMultiplier() {
        if (this.isDefaults()) {
            return 1.0;
        }
        if (this._multiplier == null) {
            return 1.0;
        }
        int n = this._multiplier.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            if (this._multiplier[i] == Double.NEGATIVE_INFINITY) continue;
            d = Math.max(d, this._multiplier[i]);
        }
        return d;
    }

    public double getHourlyMultiplier(int n) {
        if (this.isDefaults()) {
            return 1.0;
        }
        if ((n %= 24) < 0) {
            n += 24;
        }
        if (n == 0) {
            n = 24;
        }
        int n2 = n / this._interval;
        if (n % this._interval == 0) {
            --n2;
        }
        return this._multiplier[n2];
    }

    public double getHourlyWeightedMultiplier(int n) {
        if (this.isDefaults()) {
            return 0.041666666666666664;
        }
        double d = this.sumHourly();
        if (d == 0.0) {
            return 0.041666666666666664;
        }
        if ((n %= 24) < 0) {
            n += 24;
        }
        if (n == 0) {
            n = 24;
        }
        int n2 = n / this._interval;
        if (n % this._interval == 0) {
            --n2;
        }
        double d2 = this._multiplier[n2] / d;
        return d2;
    }

    public double sumHourly() {
        if (this.isDefaults()) {
            return 24.0;
        }
        double d = 0.0;
        double d2 = this._interval;
        for (int i = 0; i < this._multiplier.length; ++i) {
            d += this._multiplier[i] * d2;
        }
        return d;
    }

    public double[] getMultipliers() {
        if (this._multiplier == null) {
            return null;
        }
        return (double[])this._multiplier.clone();
    }

    public void setMultipliers(double[] dArray) {
        if (dArray == null || dArray.length <= 0) {
            return;
        }
        int n = 24 / dArray.length;
        if (!TimeOfDayMultiplier.a(n)) {
            return;
        }
        this._interval = n;
        this._multiplier = dArray;
        this.b = true;
    }

    public boolean setMultiplier(int n, double d) {
        if (this._multiplier == null || n < 0 || n > this._multiplier.length) {
            return false;
        }
        this._multiplier[n] = d;
        this.b = true;
        return true;
    }

    public static boolean a(int n) {
        return n == 1 || n == 2 || n == 3 || n == 4 || n == 6 || n == 12;
    }

    public void setInterval(int n) {
        int n2;
        if (!TimeOfDayMultiplier.a(n)) {
            return;
        }
        int n3 = 24 / n;
        double[] dArray = new double[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            dArray[n2] = 1.0;
        }
        if (this._multiplier != null && this._multiplier.length > 1) {
            n2 = this._interval;
            for (int i = 0; i < n3; ++i) {
                int n4 = n * i / n2;
                dArray[i] = this._multiplier[n4];
            }
        }
        this._interval = n;
        this._multiplier = dArray;
    }

    public int getInterval() {
        return this._interval;
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            TimeOfDayMultiplier timeOfDayMultiplier = (TimeOfDayMultiplier)super.clone();
            return timeOfDayMultiplier;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public Object getFieldObject(Field object) {
        try {
            object = ((Field)object).get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, Element element) {
        alternativeInputReport = new Element("Multiple");
        element.addContent((Content)alternativeInputReport);
        XMLUtilities.createArrayElements((Element)alternativeInputReport, (double[])this._multiplier);
        element.setAttribute("Interval", Integer.toString(this._interval));
    }
}

