/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.TSDataSet;
import hec.clientapp.model.TSRecordProxy;
import hec.heclib.util.doubleArrayContainer;
import hec.model.RunTimeStep;
import hec.model.TSLocation;
import hec.rss.model.AdjustableParameter;
import hec.rss.model.Controller;
import hec.rss.model.OpController;
import hec.rss.model.Operations;
import hec.rss.model.RssModelVariableSet;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.Rule;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Vector;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class TimeSeries
extends Rule
implements TSLocation {
    Vector<TSRecordProxy> _tsrecordVector = new Vector();
    public static String b = " Forecast Div";
    @Deprecated
    Operations _manager;
    String _diversionName;
    private transient doubleArrayContainer c;

    public TimeSeries() {
        this.setRuleType("Time-Series");
    }

    @Deprecated
    public TimeSeries(Controller controller) {
        super(controller);
        this.setRuleType("Time-Series");
        this._manager = controller.getOperations();
    }

    public TimeSeries(OpController opController) {
        super(opController);
        this.setRuleType("Time-Series");
    }

    public void setDiversionName(String string) {
        this._diversionName = string;
        String cfr_ignored_0 = string + " " + this.getName();
    }

    @Override
    public boolean initialize() {
        for (int i = 0; i < this._tsrecordVector.size(); ++i) {
            TSRecordProxy tSRecordProxy = this._tsrecordVector.elementAt(i);
            if (tSRecordProxy == null) continue;
            tSRecordProxy.initialize();
        }
        this.c = ((RssTSLocationObject)this).getTSContainer(85);
        if (this.c == null) {
            ((RssTSLocationObject)this._opController).getSystem().printErrorMessage("Diversion TimeSeries Rule failed to find input record");
            return false;
        }
        return true;
    }

    @Override
    public double getValue(AdjustableParameter adjustableParameter, RunTimeStep runTimeStep, double d) {
        if (this.c.array == null) {
            return d;
        }
        if (RMAConst.isValidValue((double)this.c.array[runTimeStep.step])) {
            d = this.c.array[runTimeStep.step];
        }
        if (this.useDemandScale()) {
            return d * this.getDemandScale();
        }
        return d;
    }

    @Override
    public boolean writeData(BufferedWriter bufferedWriter) {
        String string = this.getRuleType();
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Controller Rule=" + string));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Controller " + string + " Name=" + this.getName()));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Controller " + string + " DiversionName=" + this._diversionName));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Controller " + string + " End"));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)"");
        return true;
    }

    @Override
    public boolean readData(BufferedReader bufferedReader) {
        String string = this.getRuleType();
        try {
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                if (string2.length() == 0) {
                    string2 = bufferedReader.readLine();
                    continue;
                }
                if (string2.indexOf("Controller " + string) < 0) break;
                String string3 = RMAIO.getType((String)string2, (String)"=");
                string2 = RMAIO.getParam((String)string2, (String)"=");
                if (string3.equals("Controller " + string + " Name")) {
                    this.setName(string2);
                } else if (string3.equals("Controller " + string + " DiversionName")) {
                    this.setDiversionName(string2);
                } else if (string3.equals("Controller " + string + " End")) break;
                string2 = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    @Override
    public void updateTSProxyList() {
        String string = this._diversionName;
        TSRecordProxy tSRecordProxy = ((RssTSLocationObject)this).getTSRecordProxy(string, 85);
        if (tSRecordProxy == null) {
            ((RssTSLocationObject)this).addTSRecordProxy(string, 85);
        }
    }

    @Override
    public Vector getActiveTSRecordProxies(Vector vector, int n) {
        if (vector == null) {
            vector = new Vector<String>();
        }
        if (n == 1) {
            String string = this._diversionName;
            if ((string = ((RssTSLocationObject)this).getTSRecordProxy(string, 85)) != null) {
                vector.addElement(string);
            }
        }
        return vector;
    }

    @Override
    public TSRecordProxy addTSRecordProxy(String string, int n) {
        TSRecordProxy tSRecordProxy;
        if (this._tsrecordVector == null) {
            this._tsrecordVector = new Vector();
        }
        if ((tSRecordProxy = RssModelVariableSet.newTSRecordProxy(((RssTSLocationObject)this._opController).getSystem(), this, n)) != null) {
            tSRecordProxy.setName(string);
            this._tsrecordVector.addElement(tSRecordProxy);
        }
        return tSRecordProxy;
    }

    @Override
    public TSRecordProxy addTSRecord(String string, String string2, boolean bl) {
        if (string == null || string2 == null) {
            return null;
        }
        TSRecordProxy tSRecordProxy = ((RssTSLocationObject)this._opController).getSystem().newTSRecordProxy(this);
        tSRecordProxy.setName(string);
        tSRecordProxy.setParamName(string2);
        tSRecordProxy.setInput(bl);
        this._tsrecordVector.addElement(tSRecordProxy);
        return tSRecordProxy;
    }

    public void removeTSRecord(String string, String string2, boolean bl) {
        if (string == null || string2 == null) {
            return;
        }
        for (int i = 0; i < this._tsrecordVector.size(); ++i) {
            TSRecordProxy tSRecordProxy = this._tsrecordVector.elementAt(i);
            if (tSRecordProxy == null || tSRecordProxy.isInput() != bl || !string2.equalsIgnoreCase(tSRecordProxy.getParamName())) continue;
            this._tsrecordVector.removeElementAt(i);
            return;
        }
    }

    @Override
    public doubleArrayContainer getTSContainer(int n) {
        if (this._tsrecordVector == null) {
            this._tsrecordVector = new Vector();
        }
        int n2 = this._tsrecordVector.size();
        for (int i = 0; i < n2; ++i) {
            TSRecordProxy tSRecordProxy = this._tsrecordVector.elementAt(i);
            if (tSRecordProxy == null || tSRecordProxy.getVariableId() != n) continue;
            return tSRecordProxy.getTSContainer();
        }
        return null;
    }

    @Override
    public TSRecordProxy getTSRecordProxy(String string, int n) {
        if (string == null) {
            return null;
        }
        if (this._tsrecordVector == null) {
            this._tsrecordVector = new Vector();
        }
        for (int i = 0; i < this._tsrecordVector.size(); ++i) {
            TSRecordProxy tSRecordProxy = this._tsrecordVector.elementAt(i);
            if (tSRecordProxy == null || tSRecordProxy.getVariableId() != n || !tSRecordProxy.getName().equals(string)) continue;
            return tSRecordProxy;
        }
        return null;
    }

    @Override
    public Vector getTSRecordProxies() {
        return this._tsrecordVector;
    }

    @Override
    public TSDataSet getTSDataSet(boolean bl) {
        RssSystem rssSystem = ((RssTSLocationObject)this._opController).getSystem();
        if (rssSystem == null) {
            return null;
        }
        if (bl) {
            return rssSystem.getInputTSDataSet();
        }
        return rssSystem.getOutputTSDataSet();
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            return super.setFieldObject(field, object);
        }
    }
}

