/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.TSDataSet;
import hec.clientapp.model.TSRecordProxy;
import hec.heclib.util.doubleArrayContainer;
import hec.io.AsciiSerializable;
import hec.io.TimeSeriesContainer;
import hec.model.RunTimeStep;
import hec.model.TSLocation;
import hec.model.TimeSeriesConditionalComparable;
import hec.rss.model.Element;
import hec.rss.model.ElementOp;
import hec.rss.model.IndependentVariable;
import hec.rss.model.RssModelVariableConstants;
import hec.rss.model.RssModelVariableSet;
import hec.rss.model.RssSystem;
import hec.rss.model.StateVariable;
import hec.rss.model.globalvariable.GlobalVariable;
import hec.rss.model.globalvariable.TimeSeriesGlobalVariable;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Vector;

public class TimeSeriesComparisonWrapper
implements AsciiSerializable,
TSLocation,
TimeSeriesConditionalComparable,
RssModelVariableConstants {
    IndependentVariable m_indepVariable = null;
    ElementOp m_reservoirOp = null;
    List<TSRecordProxy> m_tsProxyList = new Vector<TSRecordProxy>();
    private transient doubleArrayContainer a;

    public TimeSeriesComparisonWrapper() {
    }

    public TimeSeriesComparisonWrapper(IndependentVariable independentVariable, ElementOp elementOp) {
        this.m_indepVariable = independentVariable;
        this.m_reservoirOp = elementOp;
    }

    public void getReferencedStateVariables(List list) {
        if (this.m_indepVariable == null || !(this.m_reservoirOp instanceof ElementOp)) {
            return;
        }
        if (this.m_indepVariable.getType() == 4) {
            Object object = this.m_reservoirOp.getOperationsElement();
            if (object == null) {
                return;
            }
            if ((object = object.getSystem()) == null) {
                return;
            }
            if ((object = ((RssSystem)object).getStateVariable(this.m_indepVariable.getStateVariableId())) != null && !list.contains(object)) {
                list.add(object);
            }
        }
    }

    public IndependentVariable getIndependentVariable() {
        return this.m_indepVariable;
    }

    public void setElementOp(ElementOp elementOp) {
        this.m_reservoirOp = elementOp;
    }

    public TSDataSet getTSDataSet(boolean bl) {
        RssSystem rssSystem = this.m_reservoirOp.getOperationsElement().getSystem();
        if (rssSystem == null) {
            return null;
        }
        if (bl) {
            return rssSystem.getInputTSDataSet();
        }
        return rssSystem.getOutputTSDataSet();
    }

    public TSRecordProxy getTSRecordProxy(String string, int n) {
        if (string == null) {
            return null;
        }
        if (this.m_tsProxyList == null) {
            this.m_tsProxyList = new Vector<TSRecordProxy>();
            return null;
        }
        int n2 = this.m_tsProxyList.size();
        for (int i = 0; i < n2; ++i) {
            TSRecordProxy tSRecordProxy = this.m_tsProxyList.get(i);
            if (tSRecordProxy == null || tSRecordProxy.getVariableId() != n || !tSRecordProxy.getName().equals(string)) continue;
            return tSRecordProxy;
        }
        return null;
    }

    public void updateTSProxyList() {
        String string;
        TSRecordProxy tSRecordProxy;
        this.a = null;
        if (this.m_indepVariable != null && this.m_indepVariable.getType() == 3 && (tSRecordProxy = this.getTSRecordProxy(string = this.m_indepVariable.getTimeSeriesName(), 85)) == null) {
            this.addTSRecordProxy(string, 85);
        }
    }

    public TSRecordProxy addTSRecordProxy(String string, int n) {
        TSRecordProxy tSRecordProxy;
        RssSystem rssSystem = this.m_reservoirOp.getOperationsElement().getSystem();
        if (this.m_tsProxyList == null) {
            this.m_tsProxyList = new Vector<TSRecordProxy>();
        }
        if ((tSRecordProxy = RssModelVariableSet.newTSRecordProxy(rssSystem, this, n)) != null) {
            tSRecordProxy.setName(string);
            this.m_tsProxyList.add(tSRecordProxy);
        }
        return tSRecordProxy;
    }

    public List getActiveTSRecordProxies(List vector, int n) {
        if (vector == null) {
            vector = new Vector<String>();
        }
        if (n != 0 && this.m_indepVariable != null && this.m_indepVariable.getType() == 3) {
            String string = this.m_indepVariable.getTimeSeriesName();
            if ((string = this.getTSRecordProxy(string, 85)) != null) {
                vector.add(string);
            }
        }
        return vector;
    }

    public void getElementDependencies(RssSystem rssReturnStatusConstants, Element element, List<Element> list) {
        if (this.m_reservoirOp == null || list == null) {
            return;
        }
        IndependentVariable independentVariable = this.m_indepVariable;
        if (independentVariable != null && independentVariable.getType() == 2 && (rssReturnStatusConstants = ((RssSystem)rssReturnStatusConstants).getElement(independentVariable.getElementId())) != null && (rssReturnStatusConstants = ((Element)rssReturnStatusConstants).getTopParent()) != element && !list.contains(rssReturnStatusConstants)) {
            list.add((Element)rssReturnStatusConstants);
        }
    }

    public doubleArrayContainer getTSContainer(String string, int n) {
        if (this.m_tsProxyList == null) {
            this.m_tsProxyList = new Vector<TSRecordProxy>();
        }
        int n2 = this.m_tsProxyList.size();
        for (int i = 0; i < n2; ++i) {
            TSRecordProxy tSRecordProxy = this.m_tsProxyList.get(i);
            if (tSRecordProxy == null || tSRecordProxy.getVariableId() != n || !tSRecordProxy.getName().equals(string)) continue;
            return tSRecordProxy.getTSContainer();
        }
        return null;
    }

    public Object clone() {
        TimeSeriesComparisonWrapper timeSeriesComparisonWrapper;
        try {
            timeSeriesComparisonWrapper = (TimeSeriesComparisonWrapper)super.clone();
            ((TimeSeriesComparisonWrapper)super.clone()).m_indepVariable = (IndependentVariable)this.m_indepVariable.clone();
        }
        catch (Exception exception) {
            return null;
        }
        return timeSeriesComparisonWrapper;
    }

    public String toString() {
        if (this.m_indepVariable == null) {
            return "";
        }
        if (this.m_indepVariable.getType() == 3) {
            return this.m_indepVariable.getTimeSeriesName();
        }
        if (this.m_indepVariable.getType() == 4 || 6 == this.m_indepVariable.getType()) {
            return this.m_indepVariable.toString();
        }
        Object object = this.m_reservoirOp.getOperationsElement();
        if (object != null) {
            object = object.getSystem();
            return ((RssSystem)object).getNameForKeyString(this.m_indepVariable.getTSProxyName()) + ":" + this.m_indepVariable.getModelVariable().toString();
        }
        return this.m_indepVariable.getTSProxyName() + ":" + this.m_indepVariable.getModelVariable().toString();
    }

    public int compare(RunTimeStep runTimeStep, TimeSeriesComparisonWrapper timeSeriesComparisonWrapper) {
        double d;
        double d2 = this.getTimeSeriesValue(runTimeStep);
        if (d2 == (d = timeSeriesComparisonWrapper.getTimeSeriesValue(runTimeStep))) {
            return 0;
        }
        if (d2 > d) {
            return 1;
        }
        return -1;
    }

    public int compare(RunTimeStep runTimeStep, double d) {
        double d2 = this.getTimeSeriesValue(runTimeStep);
        if (Double.isNaN(d2)) {
            return 0;
        }
        if (d2 == d) {
            return 0;
        }
        if (d2 > d) {
            return 1;
        }
        return -1;
    }

    public double getTimeSeriesValue(RunTimeStep runTimeStep) {
        if (this.m_indepVariable == null || this.m_reservoirOp == null || runTimeStep == null) {
            return Double.NaN;
        }
        if (this.m_reservoirOp.getOperationsElement() == null) {
            return Double.NaN;
        }
        if (this.a == null) {
            RssSystem rssSystem = this.m_reservoirOp.getOperationsElement().getSystem();
            switch (this.m_indepVariable.getType()) {
                case 2: {
                    Object object = rssSystem.getTSRecordProxy(this.m_indepVariable.getTSProxyName(), this.m_indepVariable.getModelVariableId());
                    if (object == null) {
                        object = this.getProxyName(rssSystem, this.m_indepVariable.getTSProxyName());
                        rssSystem.printErrorMessage("TimeSeriesComparisonWrapper.compare: failed to find TSRecordProxy for " + (String)object + ", for Element:" + String.valueOf(this.m_reservoirOp.getOperationsElement()) + ", Operations Set:" + String.valueOf(this.m_reservoirOp.getActiveOpSet()) + ". Check If Blocks for the Time Series " + String.valueOf(rssSystem.getObjectForKeyString(this.m_indepVariable.getTSProxyName())) + " and readd it to the If block");
                        return 0.0;
                    }
                    this.a = object.getTSContainer();
                    if (this.a != null) break;
                    object = this.getProxyName(rssSystem, this.m_indepVariable.getTSProxyName());
                    rssSystem.printErrorMessage("TimeSeriesComparisonWrapper.compare: failed to find Independent Variable Time Series for " + (String)object + ", for Element:" + String.valueOf(this.m_reservoirOp.getOperationsElement()) + ", Operations Set:" + String.valueOf(this.m_reservoirOp.getActiveOpSet()));
                    return 0.0;
                }
                case 3: {
                    String string = this.m_indepVariable.getTimeSeriesName();
                    if (string == null) {
                        string = this.getProxyName(rssSystem, this.m_indepVariable.getTSProxyName());
                        rssSystem.printErrorMessage("TimeSeriesComparisonWrapper.compare: external time series name is null for " + string + ", for Element:" + String.valueOf(this.m_reservoirOp.getOperationsElement()) + ", Operations Set:" + String.valueOf(this.m_reservoirOp.getActiveOpSet()));
                        return 0.0;
                    }
                    this.a = this.getTSContainer(string, 85);
                    if (this.a != null) break;
                    string = this.getProxyName(rssSystem, this.m_indepVariable.getTSProxyName());
                    rssSystem.printErrorMessage("TimeSeriesComparisonWrapper.compare: failed to find Independent Variable Time Series for " + string + ", for Element:" + String.valueOf(this.m_reservoirOp.getOperationsElement()) + ", Operations Set:" + String.valueOf(this.m_reservoirOp.getActiveOpSet()));
                    return 0.0;
                }
                case 4: {
                    int n = this.m_indepVariable.getStateVariableId();
                    StateVariable stateVariable = rssSystem.getStateVariable(n);
                    if (stateVariable == null) {
                        stateVariable = rssSystem.getStateVariable(this.m_indepVariable.getStateVariableName());
                    }
                    if (stateVariable == null) {
                        rssSystem.printErrorMessage("TimeSeriesComparisonWrapper.compare: failed to find State Variable for " + this.m_indepVariable.getStateVariableName());
                        return 0.0;
                    }
                    this.a = stateVariable.getTSContainer(97);
                    if (this.a != null) break;
                    rssSystem.printErrorMessage("TimeSeriesComparisonWrapper.compare: failed to find State Variable Time Series for " + this.m_indepVariable.getStateVariableName());
                    return 0.0;
                }
                case 6: {
                    int n = this.m_indepVariable.getGlobalVariableId();
                    GlobalVariable globalVariable = rssSystem.getGlobalVariable(n);
                    if (globalVariable == null) {
                        globalVariable = rssSystem.getGlobalVariable(this.m_indepVariable.getGlobalVariableName());
                    }
                    if (!(globalVariable instanceof TimeSeriesGlobalVariable)) break;
                    globalVariable = (TimeSeriesGlobalVariable)globalVariable;
                    if ((globalVariable = ((TimeSeriesGlobalVariable)globalVariable).getTimeSeriesContainer()) != null) {
                        this.a = new doubleArrayContainer(((TimeSeriesContainer)globalVariable).values);
                        if (this.a.length != 0) break;
                        rssSystem.printErrorMessage("TimeSeriesComparisonWrapper.compare: failed to find Global Variable Time Series Data for " + this.m_indepVariable.getGlobalVariableName());
                        return 0.0;
                    }
                    rssSystem.printErrorMessage("TimeSeriesComparisonWrapper.compare: failed to find Global Variable Time Series for " + this.m_indepVariable.getGlobalVariableName());
                    return 0.0;
                }
                default: {
                    return 0.0;
                }
            }
        }
        double d = this.m_indepVariable.evaluateTSFunction(runTimeStep, this.a.array);
        return d;
    }

    private String getProxyName(RssSystem rssSystem, String string) {
        Object object = string;
        if (((String)object).startsWith("~")) {
            object = String.valueOf(rssSystem.getObjectForKeyString((String)object)) + " (" + string + ")";
        }
        return object;
    }

    public int compare(RunTimeStep runTimeStep, TimeSeriesConditionalComparable timeSeriesConditionalComparable) {
        return this.compare(runTimeStep, (TimeSeriesComparisonWrapper)timeSeriesConditionalComparable);
    }

    public Object getFieldObject(Field object) {
        try {
            object = ((Field)object).get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }
}

