/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.model.RunTimeWindow;
import hec.rss.model.Element;
import hec.rss.model.Function;
import hec.rss.model.ITimeStepRoutingElement;
import hec.rss.model.RssNode;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.TimeStepUtil;
import java.lang.reflect.Field;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class TimeStepRoutingElement
extends Element
implements ITimeStepRoutingElement {
    private Map<Duration, Function> _timeStepRoutingFunctionMap = new HashMap<Duration, Function>();

    public TimeStepRoutingElement() {
    }

    public TimeStepRoutingElement(Element element) {
    }

    public TimeStepRoutingElement(RssSystem rssSystem, int n) {
        super(rssSystem, n);
    }

    @Override
    public synchronized Object clone() {
        TimeStepRoutingElement timeStepRoutingElement = (TimeStepRoutingElement)super.clone();
        Object object = this._timeStepRoutingFunctionMap.entrySet();
        timeStepRoutingElement._timeStepRoutingFunctionMap = new HashMap<Duration, Function>();
        object = object.iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            timeStepRoutingElement._timeStepRoutingFunctionMap.put((Duration)entry.getKey(), (Function)((RssTSLocationObject)((Function)entry.getValue())).clone());
        }
        return timeStepRoutingElement;
    }

    @Override
    public boolean initialize(RunTimeWindow runTimeWindow) {
        if (!this.setRoutingFunction(runTimeWindow)) {
            return false;
        }
        return super.initialize(runTimeWindow);
    }

    public boolean setRoutingFunction(RunTimeWindow runTimeWindow) {
        int n = runTimeWindow.getTimeStepMinutes();
        Function function = this._timeStepRoutingFunctionMap.get(Duration.ofMinutes(n));
        if (function == null && (function = this._timeStepRoutingFunctionMap.get(TimeStepUtil.TIME_STEP_ALL.getDuration())) == null && (function = this._timeStepRoutingFunctionMap.get(TimeStepUtil.TIME_STEP_UNDEFINED.getDuration())) == null) {
            this._system.printErrorMessage("Reach.initialize: " + this.getName() + " does not have a routing function defined. See log for details.");
            return false;
        }
        super.setFunction(function);
        return true;
    }

    @Override
    public void putFunction(Duration object, Function function) {
        if (function != null) {
            this._timeStepRoutingFunctionMap.put((Duration)object, function);
            function.setElement(this);
            return;
        }
        if ((object = this._timeStepRoutingFunctionMap.remove(object)) != null) {
            ((Function)object).setElement(null);
        }
    }

    @Override
    public Duration[] getDefinedTimeStepDurations() {
        Set<Duration> set = this._timeStepRoutingFunctionMap.keySet();
        return set.toArray(new Duration[set.size()]);
    }

    @Override
    public Function getFunction(Duration object, Function function) {
        if ((object = this._timeStepRoutingFunctionMap.get(object)) != null) {
            return object;
        }
        return function;
    }

    @Override
    public void updateTSProxyList() {
        super.updateTSProxyList();
        for (Function function : this._timeStepRoutingFunctionMap.values()) {
            ((RssTSLocationObject)function).updateTSProxyList();
        }
    }

    @Override
    public Vector getActiveTSProxies(Vector vector, int n) {
        vector = super.getActiveTSProxies(vector, n);
        for (Function function : this._timeStepRoutingFunctionMap.values()) {
            vector = function.getActiveTSProxies(vector, n);
        }
        return vector;
    }

    @Override
    public void setActive(boolean bl, boolean bl2) {
        for (Function function : this._timeStepRoutingFunctionMap.values()) {
            Vector object = function.getComputedNodes();
            if (object == null) {
                return;
            }
            int n = object.size();
            for (int i = 0; i < n; ++i) {
                RssNode rssNode = (RssNode)object.elementAt(i);
                rssNode.setActive(bl);
            }
        }
        super.setActive(bl, bl2);
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }
}

