/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.lang.InvalidStateException;
import hec.rss.model.Channel;
import hec.rss.model.ChannelType;
import java.lang.reflect.Field;
import rma.util.RMAConst;

public class TrapezoidalChannel
extends Channel {
    private double _bottomWidth;
    private double _sideSlope;
    private double _manningsN;

    @Override
    public ChannelType getChannelType() {
        return ChannelType.TRAPEZOID;
    }

    public double getBottomWidth() {
        return this._bottomWidth;
    }

    public double getSideSlope() {
        return this._sideSlope;
    }

    public double getManningsN() {
        return this._manningsN;
    }

    public void setBottomWidth(double d) {
        this._bottomWidth = d;
    }

    public void setSideSlope(double d) {
        this._sideSlope = d;
    }

    public void setManningsN(double d) {
        this._manningsN = d;
    }

    public void getBottomWidth(ParamDouble paramDouble) {
        if (paramDouble == null) {
            return;
        }
        paramDouble.setValue(this._bottomWidth);
        paramDouble.setUnitSystem(this.getUnitSystem());
        paramDouble.setPrecision(2);
        paramDouble.setParameterId(Parameter.PARAMID_WIDTH);
    }

    public void setBottomWidth(ParamDouble paramDouble) {
        if (paramDouble == null) {
            return;
        }
        int n = this.getUnitSystem();
        if (n == paramDouble.getUnitSystem()) {
            this._bottomWidth = paramDouble.getValue();
            return;
        }
        this._bottomWidth = paramDouble.convertToUnitSystem(n);
    }

    @Override
    public boolean isValid() throws InvalidStateException {
        int n = 0;
        if (!super.isValid()) {
            ++n;
        }
        if (!RMAConst.isValidValue((double)this._bottomWidth) || this._bottomWidth < 0.0) {
            System.out.println("ERROR: Invalid channel bottom width");
            TrapezoidalChannel trapezoidalChannel = this;
            throw new InvalidStateException((Object)trapezoidalChannel, "Invalid Channel bottom width (" + trapezoidalChannel._bottomWidth + "). Width is either an invalid value or less than 0");
        }
        if (!RMAConst.isValidValue((double)this._sideSlope) || this._sideSlope < 0.0) {
            System.out.println("ERROR: Invalid channel side slope");
            TrapezoidalChannel trapezoidalChannel = this;
            throw new InvalidStateException((Object)trapezoidalChannel, "Invalid Channel side slope (" + trapezoidalChannel._sideSlope + "). Slope is either an invalid value or less than 0");
        }
        if (!RMAConst.isValidValue((double)this._manningsN) || this._manningsN < 0.001) {
            System.out.println("ERROR: Invalid Manning's n for channel");
            TrapezoidalChannel trapezoidalChannel = this;
            throw new InvalidStateException((Object)trapezoidalChannel, "Invalid Manning's n (" + trapezoidalChannel._sideSlope + ") for channel. Manning's n is either an invalid value or less than 0.001");
        }
        return n == 0;
    }

    public double getArea(double d) {
        if (d <= 0.0) {
            return 0.0;
        }
        return d * (this._bottomWidth + this._sideSlope * d);
    }

    @Override
    public double getTopWidth(double d) {
        if (d <= 0.0) {
            return 0.0;
        }
        return this._bottomWidth + 2.0 * this._sideSlope * d;
    }

    public double getWetPerimeter(double d) {
        if (d <= 0.0) {
            return 0.0;
        }
        return this._bottomWidth + d * 2.0 * Math.sqrt(Math.pow(this._sideSlope, 2.0) + 1.0);
    }

    public double getVelocity(double d) {
        if (d <= 0.0) {
            return 0.0;
        }
        double d2 = 1.0;
        if (this.getUnitSystem() == 1) {
            d2 = 1.486;
        }
        return d2 / this._manningsN * Math.pow(this.getArea(d) / this.getWetPerimeter(d), 0.6666666666666666) * Math.sqrt(this._slope);
    }

    @Override
    public double getCelerity(double d) {
        if (d <= 0.0) {
            return 0.0;
        }
        double d2 = ((Channel)this).getTopWidth(d);
        double d3 = Math.sqrt(this._sideSlope * this._sideSlope + 1.0);
        double d4 = (10.0 * this._sideSlope * this._bottomWidth * d + 16.0 * this._sideSlope * d * d * d3 + 5.0 * this._bottomWidth * this._bottomWidth + 6.0 * this._bottomWidth * d * d3) / (d2 * 3.0 * (this._bottomWidth + d * 2.0 * d3));
        return d4 * this.getVelocity(d);
    }

    @Override
    public double getDepth(double d) {
        double d2 = 1.0;
        if (this.getUnitSystem() == 1) {
            d2 = 1.486;
        }
        double d3 = d2 / this._manningsN * Math.sqrt(this._slope);
        double d4 = d / 2.0;
        if (this._bottomWidth > 0.0) {
            d4 /= this._bottomWidth;
        }
        double d5 = d4;
        for (int i = 0; i < 20; ++i) {
            double d6;
            double d7 = (this._bottomWidth + this._sideSlope * d4) * d4;
            double d8 = this._bottomWidth + 2.0 * this._sideSlope * d4;
            double d9 = this._bottomWidth + d4 * 2.0 * Math.sqrt(this._sideSlope * this._sideSlope + 1.0);
            double d10 = 2.0 * Math.sqrt(this._sideSlope * this._sideSlope + 1.0);
            double d11 = d3 * Math.pow(d7, 1.6666666666666667) / Math.pow(d9, 0.6666666666666666) - d;
            d5 = d4 - d11 / (d6 = d3 * (1.6666666666666667 * Math.pow(d7, 0.6666666666666666) * d8 / Math.pow(d9, 0.6666666666666666) - d10 * 0.6666666666666666 * Math.pow(d7, 1.6666666666666667) / Math.pow(d9, 1.6666666666666667)));
            if (Math.abs(d5 - d4) < 0.001) break;
            d4 = d5;
        }
        if (d5 < 0.0) {
            d5 = 0.0;
        }
        return d5;
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }
}

