/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.TSRecordProxy;
import hec.data.Parameter;
import hec.heclib.util.doubleArrayContainer;
import hec.io.AsciiSerializable;
import hec.model.PairedValues;
import hec.model.RunTimeStep;
import hec.rss.model.OpRule;
import hec.rss.model.OpValue;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Vector;

public class VariableTSBasedOpRule
extends OpRule
implements AsciiSerializable,
Serializable,
Cloneable {
    public static final int MIN = -1;
    public static final int MAX = 1;
    public static final int SPECIFIED = 0;
    private PairedValues _valueRelease = new PairedValues();
    private int _limitType;
    private int _elementIndex;
    private String _parameterName = "";
    private String _inputName = "";
    private int _elemId = -1;
    private int _varId = -1;
    private transient doubleArrayContainer a;
    private transient doubleArrayContainer b;

    public VariableTSBasedOpRule() {
    }

    public VariableTSBasedOpRule(String string) {
        super(string);
    }

    @Override
    public void updateTSProxyList() {
        TSRecordProxy tSRecordProxy;
        if (this._limitType == -1) {
            tSRecordProxy = this.getTSRecordProxy(82);
            if (tSRecordProxy == null) {
                this.addTSRecordProxy(82);
            }
        } else if (this._limitType == 1) {
            tSRecordProxy = this.getTSRecordProxy(81);
            if (tSRecordProxy == null) {
                this.addTSRecordProxy(81);
            }
        } else {
            tSRecordProxy = this.getTSRecordProxy(80);
            if (tSRecordProxy == null) {
                this.addTSRecordProxy(80);
            }
        }
        if ((tSRecordProxy = this.getTSRecordProxy(85)) == null) {
            this.addTSRecordProxy(85);
        }
    }

    @Override
    public Vector getActiveTSRecordProxies(Vector vector, int n) {
        if (vector == null) {
            vector = new Vector<TSRecordProxy>();
        }
        if (n == 0) {
            if (this._limitType == -1) {
                TSRecordProxy tSRecordProxy = this.getTSRecordProxy(82);
                if (tSRecordProxy != null) {
                    vector.addElement(tSRecordProxy);
                }
            } else if (this._limitType == 1) {
                TSRecordProxy tSRecordProxy = this.getTSRecordProxy(81);
                if (tSRecordProxy != null) {
                    vector.addElement(tSRecordProxy);
                }
            } else {
                TSRecordProxy tSRecordProxy = this.getTSRecordProxy(80);
                if (tSRecordProxy != null) {
                    vector.addElement(tSRecordProxy);
                }
            }
        } else {
            TSRecordProxy tSRecordProxy = this.getTSRecordProxy(85);
            if (tSRecordProxy != null) {
                vector.addElement(tSRecordProxy);
            }
        }
        return vector;
    }

    @Override
    public boolean initializeCompute() {
        this.a = null;
        this.b = null;
        if (!super.initializeCompute()) {
            return false;
        }
        this.b = this._limitType == -1 ? this.getTSContainer(82) : (this._limitType == 1 ? this.getTSContainer(81) : this.getTSContainer(80));
        this.a = this.getTSContainer(85);
        if (this.a == null || this.b == null) {
            this._controller.getElementOp().getOperationsElement().getSystem().printErrorMessage("InputTSBasedOpRule.initializeCompute: Failed to load time series arrays");
            return false;
        }
        return true;
    }

    @Override
    public OpValue evaluateRule(RunTimeStep object, double d) {
        if (this._valueRelease == null) {
            return null;
        }
        double d2 = this.a.array[object.step];
        double d3 = this._valueRelease.interpolate(d2);
        if (d3 == Double.NEGATIVE_INFINITY) {
            return null;
        }
        this.b.array[object.step] = d3;
        if (this.getEnableRiseFallCondition() && !this.checkRisingFallingCondition((RunTimeStep)object)) {
            return null;
        }
        object = new OpValue();
        new OpValue().value = d3;
        object.type = this._limitType == -1 ? 0 : (this._limitType == 1 ? 2 : 1);
        return object;
    }

    @Override
    public Object clone() {
        VariableTSBasedOpRule variableTSBasedOpRule = (VariableTSBasedOpRule)super.clone();
        if (this._valueRelease != null) {
            variableTSBasedOpRule._valueRelease = (PairedValues)this._valueRelease.clone();
        }
        return variableTSBasedOpRule;
    }

    public void setParameterValueRelease(PairedValues pairedValues) {
        if (pairedValues == null) {
            return;
        }
        this._valueRelease = pairedValues;
    }

    public PairedValues getParameterValueRelease() {
        this._valueRelease.setUnitSystem(this.getUnitSystem());
        this._valueRelease.setParamXId(-1);
        this._valueRelease.setParamYId(Parameter.PARAMID_FLOW);
        return this._valueRelease;
    }

    public void setInterpolationType(int n) {
        this._valueRelease.setInterpolationType(n);
    }

    public int getInterpolationType() {
        return this._valueRelease.getInterpolationType();
    }

    public void setElementType(int n) {
        this._elementIndex = n;
    }

    public int getElementType() {
        return this._elementIndex;
    }

    public int getLimitType() {
        return this._limitType;
    }

    public void setLimitType(int n) {
        if (n != -1 && n != 1 && n != 0) {
            return;
        }
        this._limitType = n;
    }

    public String getParameterName() {
        return this._parameterName;
    }

    public void setParameterName(String string) {
        this._parameterName = string;
    }

    public String getInputName() {
        return this._inputName;
    }

    public void setInputName(String string) {
        this._inputName = string;
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }
}

