/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.io.AsciiSerializable;
import hec.rss.model.VerticalDatumType;
import java.lang.reflect.Field;
import java.text.Format;
import java.text.MessageFormat;

public class VerticalDatumSettings
implements AsciiSerializable {
    public static final String UNDEF = "Undef";
    VerticalDatumType mType = VerticalDatumType.UNSPECIFIED;
    double mNGVDShiftToNAVD88 = 0.0;
    String mOtherName = "Undef";
    double mOtherShiftToNAVD88 = 0.0;
    String mUnits = "";

    public VerticalDatumSettings() {
    }

    public VerticalDatumSettings(VerticalDatumSettings verticalDatumSettings) {
        this.mType = verticalDatumSettings.mType;
        this.mNGVDShiftToNAVD88 = verticalDatumSettings.mNGVDShiftToNAVD88;
        this.mOtherName = verticalDatumSettings.mOtherName;
        this.mOtherShiftToNAVD88 = verticalDatumSettings.mOtherShiftToNAVD88;
        this.mUnits = verticalDatumSettings.mUnits;
    }

    public void setUnits(String string) {
        this.mUnits = string;
    }

    public VerticalDatumType getType() {
        return this.mType;
    }

    public void setType(VerticalDatumType verticalDatumType) {
        this.mType = verticalDatumType;
    }

    public double getNGVDShiftToNAVD88() {
        return this.mNGVDShiftToNAVD88;
    }

    public void setNGVDShiftToNAVD88(double d) {
        this.mNGVDShiftToNAVD88 = d;
    }

    public String getLocalName() {
        return this.mOtherName;
    }

    public void setLocalName(String string) {
        this.mOtherName = string;
    }

    public double getLocalShiftToNAVD88() {
        return this.mOtherShiftToNAVD88;
    }

    public void setLocalShiftToNAVD88(double d) {
        this.mOtherShiftToNAVD88 = d;
    }

    public String toVerticalDatumXml() {
        MessageFormat messageFormat = new MessageFormat("<vertical-datum-info unit=\"{4}\">\n<native-datum>{0}</native-datum>\n{1}{2}{3}</vertical-datum-info>");
        Object object = new MessageFormat("<local-datum-name>{0}</local-datum-name>\n");
        Object object2 = new MessageFormat("   <offset estimate=\"true\">\n     <to-datum>NAVD-88</to-datum>\n     <value>{0}</value>\n   </offset>\n");
        MessageFormat messageFormat2 = new MessageFormat("   <offset estimate=\"true\">\n     <to-datum>NGVD-29</to-datum>\n     <value>{0}</value>\n   </offset>\n");
        String string = "";
        VerticalDatumType verticalDatumType = this.getType();
        if (verticalDatumType != null) {
            switch (verticalDatumType) {
                case NAVD88: {
                    string = "";
                    object = ((Format)object2).format(new String[]{Double.toString(0.0)});
                    object2 = messageFormat2.format(new String[]{Double.toString(-1.0 * this.getNGVDShiftToNAVD88())});
                    string = messageFormat.format(new String[]{"NAVD88", string, object, object2, this.mUnits});
                    break;
                }
                case NGVD29: {
                    object = ((Format)object2).format(new String[]{Double.toString(this.getNGVDShiftToNAVD88())});
                    object2 = messageFormat2.format(new String[]{Double.toString(0.0)});
                    string = messageFormat.format(new String[]{"NGVD29", "", object, object2, this.mUnits});
                    break;
                }
                case LOCAL: {
                    string = ((Format)object).format(new String[]{this.getLocalName()});
                    object = ((Format)object2).format(new String[]{Double.toString(this.getLocalShiftToNAVD88())});
                    object2 = messageFormat2.format(new String[]{Double.toString(this.getLocalShiftToNAVD88() - this.getNGVDShiftToNAVD88())});
                    string = messageFormat.format(new String[]{"LOCAL", string, object, object2, this.mUnits});
                    break;
                }
                case UNSPECIFIED: {
                    string = ((Format)object).format(new String[]{VerticalDatumType.UNSPECIFIED.toString()});
                    object = ((Format)object2).format(new String[]{Double.toString(-3.4028234663852886E38)});
                    object2 = messageFormat2.format(new String[]{Double.toString(-3.4028234663852886E38)});
                    string = messageFormat.format(new String[]{"LOCAL", string, object, object2, this.mUnits});
                }
            }
        }
        return string;
    }

    public Object getFieldObject(Field object) {
        try {
            object = ((Field)object).get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }
}

