/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.Manager;
import hec.clientapp.rmi.csinterface.HecRmiWorkspace;
import hec.rss.RssRmiWorkspace;
import hec.rss.server.RssAdvancedOptions;
import hec.rss.wq.model.AltWaterQualityOptions;
import java.rmi.RemoteException;
import mil.army.usace.hec.metadata.IntervalFactory;

public final class WQUtilities {
    private WQUtilities() {
        throw new AssertionError((Object)"Utility class should not be instantiated");
    }

    public static boolean shouldComputeWaterQuality(Manager manager, AltWaterQualityOptions altWaterQualityOptions) {
        Object object;
        if (manager == null || altWaterQualityOptions == null) {
            return false;
        }
        RssRmiWorkspace rssRmiWorkspace = (RssRmiWorkspace)((Object)manager.getWorkspace().getRemote());
        try {
            object = rssRmiWorkspace.getChildWorkspace("");
            if (object instanceof HecRmiWorkspace) {
                rssRmiWorkspace = ((HecRmiWorkspace)object).getBaseWorkspace();
                rssRmiWorkspace = (RssRmiWorkspace)rssRmiWorkspace.getChildWorkspace("rss");
            }
        }
        catch (RemoteException remoteException) {
            System.out.println("shouldComputeWaterQuality:exception getting base wksp options" + String.valueOf(remoteException));
            manager.printErrorMessage("Failed to get ResSim Base Workspace to determine Water Quality Compute");
            return false;
        }
        object = null;
        try {
            if (rssRmiWorkspace != null) {
                object = rssRmiWorkspace.getRssAdvancedOptions();
            }
        }
        catch (RemoteException remoteException) {
            System.out.println("shouldComputeWaterQuality:exception getting advanced options" + String.valueOf(remoteException));
            manager.printErrorMessage("Failed to get ResSim Advanced Options to determine Water Quality Compute");
            return false;
        }
        if (object != null && ((RssAdvancedOptions)object).hasWaterQuality()) {
            return altWaterQualityOptions.shouldRunWq();
        }
        return false;
    }

    public static String getDSSInterval(int n) {
        return switch (n) {
            case 3 -> IntervalFactory.regular1Day().getInterval();
            case 2 -> IntervalFactory.regular1Hour().getInterval();
            case 1 -> IntervalFactory.regular1Minute().getInterval();
            default -> IntervalFactory.irregular().getInterval();
        };
    }
}

