/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.TSRecordProxy;
import hec.heclib.util.doubleArrayContainer;
import hec.io.AsciiSerializable;
import hec.lang.NamedType;
import hec.model.RunTimeStep;
import hec.rss.model.DemandRuleInf;
import hec.rss.model.HindcastData;
import hec.rss.model.OpRule;
import hec.rss.model.OpSet;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.Storage;
import hec.rss.model.StorageZone;
import hec.rss.model.StorageZoneRef;
import hec.rss.model.WaterAccountSet;
import hec.rss.model.YieldAnalysisRuleRef;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import rma.util.RMAConst;

public class WaterAccount
extends RssTSLocationObject
implements AsciiSerializable,
Cloneable {
    int _hindcastCondition = 0;
    private transient doubleArrayContainer b;
    private transient double c = 0.0;
    private boolean _usePercentOfCon = true;
    private double _percentOfCon = 0.0;
    private double _maxStorage = 0.0;
    private List<YieldAnalysisRuleRef> _ruleRefs = null;
    private String _name;
    private String _description = "";
    private int _waterAccountSetIndex = Integer.MIN_VALUE;
    private transient doubleArrayContainer d;
    private transient doubleArrayContainer e;
    private transient doubleArrayContainer f;
    private transient doubleArrayContainer g;
    private transient doubleArrayContainer h;
    private transient doubleArrayContainer i;
    private transient doubleArrayContainer j;
    private transient doubleArrayContainer k;
    private transient doubleArrayContainer l;
    private transient doubleArrayContainer m;
    private transient doubleArrayContainer n;
    protected transient RssSystem a;
    private transient String o = "";
    private transient StorageZone p;
    private transient ReservoirElement q;
    private transient double r;
    private int _index = Integer.MIN_VALUE;
    private transient boolean s;
    private transient boolean t;
    private transient double u;
    private transient boolean v = false;
    private transient boolean w = false;
    private transient double x;
    private transient boolean y = false;
    private transient double z = 0.0;
    private transient double A = 0.0;
    private transient double B = 0.0;
    private transient boolean C = false;
    private transient boolean D;
    public static final double FLOW_TOLERANCE = 0.01;
    public static final int MAX_ITERATIONS = 10;

    public WaterAccount() {
    }

    public WaterAccount(String string, String string2, int n, int n2) {
        super(string);
        this.setName(string);
        this.setDescription(string2);
        this.setWaterAccountSetIndex(n);
        this._index = n2;
    }

    public int getIndex() {
        return this._index;
    }

    private void setWaterAccountSetIndex(int n) {
        this._waterAccountSetIndex = n;
    }

    public void setDefaultFlag(boolean bl) {
        this.w = bl;
    }

    public boolean getDefaultFlag() {
        return this.w;
    }

    public int getWaterAccountSetIndex() {
        return this._waterAccountSetIndex;
    }

    public void setReservoir(ReservoirElement reservoirElement) {
        this.q = reservoirElement;
    }

    public void setReservoirs(ReservoirElement reservoirElement, RunTimeStep runTimeStep) {
        this.setReservoir(reservoirElement, runTimeStep);
        Object object = this.a.getAlternative().getWaterAccountSet();
        object = ((WaterAccountSet)object).getWaterAccounts(this.q);
        for (int i = 0; i < object.size(); ++i) {
            ((WaterAccount)object.get(i)).setReservoir(reservoirElement, runTimeStep);
        }
    }

    public void setReservoir(ReservoirElement reservoirElement, RunTimeStep runTimeStep) {
        this.q = reservoirElement;
        this.setStorageZone();
        this.setLowerStorageLimit(runTimeStep);
    }

    public ReservoirElement getReservoir() {
        return this.q;
    }

    public void setStorageZone() {
        Object object = this.getDefaultFlag() ? this.a.getAlternative().getWaterAccountSet() : this.a.getWaterAccountSet(this.getWaterAccountSetIndex());
        object = ((WaterAccountSet)object).getResZoneRefs();
        NamedType namedType = null;
        for (int i = 0; i < object.size(); ++i) {
            if (((StorageZoneRef)object.get(i)).getReservoirIndex() != this.q.getIndex()) continue;
            namedType = ((StorageZoneRef)object.get(i)).getStorageZone();
            if (namedType != null) break;
            namedType = this.q.getReservoirOp().getOperationSet(((StorageZoneRef)object.get(i)).getOpsetId());
            namedType = ((OpSet)namedType).getZone(((StorageZoneRef)object.get(i)).getZoneIndex());
            break;
        }
        this.p = namedType;
    }

    public StorageZone getStorageZone() {
        return this.p;
    }

    public void setLowerStorageLimit(RunTimeStep runTimeStep) {
        double d = this.p.getElevation(runTimeStep);
        this.r = this.q.getStorageFunction().elevationToStorage(d);
    }

    public double getLowerStorageLimit() {
        return this.r;
    }

    public void initialize() {
        this.d = this.getTSContainer(this.o + this.getName(), 190);
        this.e = this.getTSContainer(this.o + this.getName(), 191);
        this.f = this.getTSContainer(this.o + this.getName(), 192);
        this.g = this.getTSContainer(this.o + this.getName(), 193);
        this.i = this.getTSContainer(this.o + this.getName(), 203);
        this.j = this.getTSContainer(this.o + this.getName(), 204);
        this.m = this.getTSContainer(this.o + this.getName(), 205);
        this.k = this.getTSContainer(this.o + this.getName(), 206);
        this.l = this.getTSContainer(this.o + this.getName(), 207);
        this.n = this.getTSContainer(this.o + this.getName(), 208);
        if (this.v) {
            this.h = this.getTSContainer(this.o + this.getName(), 194);
        }
        this.fillTSArrays();
        if (this._hindcastCondition == 0) {
            this.b = this.getTSContainer(this.o + this.getName(), 195);
            if (this.b == null) {
                this.a.printErrorMessage("Failed to get lookback storage TS array for Water Account " + this.o + this.getName());
            }
        }
        WaterAccount waterAccount = this;
        waterAccount.initializeRules(waterAccount.a);
        this.C = true;
    }

    private void fillTSArrays() {
        Arrays.fill(this.d.array, -3.4028234663852886E38);
        Arrays.fill(this.e.array, -3.4028234663852886E38);
        Arrays.fill(this.f.array, -3.4028234663852886E38);
        Arrays.fill(this.g.array, -3.4028234663852886E38);
        Arrays.fill(this.i.array, -3.4028234663852886E38);
        Arrays.fill(this.j.array, -3.4028234663852886E38);
        Arrays.fill(this.m.array, -3.4028234663852886E38);
        Arrays.fill(this.k.array, -3.4028234663852886E38);
        Arrays.fill(this.l.array, -3.4028234663852886E38);
        Arrays.fill(this.n.array, -3.4028234663852886E38);
        if (this.v) {
            Arrays.fill(this.h.array, -3.4028234663852886E38);
        }
    }

    public boolean isInitialized() {
        return this.C;
    }

    public void initializeDefault() {
        this.d = this.getTSContainer(this.getName(), 190);
        this.e = this.getTSContainer(this.getName(), 191);
        this.f = this.getTSContainer(this.getName(), 192);
        this.g = this.getTSContainer(this.getName(), 193);
        this.i = this.getTSContainer(this.getName(), 203);
        this.j = this.getTSContainer(this.getName(), 204);
        this.m = this.getTSContainer(this.getName(), 205);
        this.k = this.getTSContainer(this.getName(), 206);
        this.l = this.getTSContainer(this.getName(), 207);
        this.n = this.getTSContainer(this.getName(), 208);
        this.fillTSArrays();
        WaterAccount waterAccount = this;
        waterAccount.initializeRules(waterAccount.a);
    }

    public Vector getHindcastDataList(Vector vector) {
        if (vector == null) {
            vector = new Vector<Object>();
        }
        Object object = this.a.getKeyStringForObject(this);
        object = new HindcastData((String)object, 195, 0);
        vector.add(object);
        return vector;
    }

    public boolean initializeRules(RssSystem rssReturnStatusConstants) {
        this.a = rssReturnStatusConstants;
        if (rssReturnStatusConstants == null) {
            return false;
        }
        if (this.getRuleRefs() == null) {
            return false;
        }
        for (int i = 0; i < this.getRuleRefs().size(); ++i) {
            rssReturnStatusConstants = this.getRuleRefs().get(i);
            ((YieldAnalysisRuleRef)rssReturnStatusConstants).initializeData(this.a);
            if (((YieldAnalysisRuleRef)rssReturnStatusConstants).getRule() == null || !(((YieldAnalysisRuleRef)rssReturnStatusConstants).getRule() instanceof DemandRuleInf)) continue;
            ((DemandRuleInf)((Object)((YieldAnalysisRuleRef)rssReturnStatusConstants).getRule())).setWaterAccount(this);
        }
        return true;
    }

    public boolean isFull() {
        return this.s;
    }

    public boolean isEmpty() {
        return this.t;
    }

    public double getExcessInflowVol() {
        return this.u;
    }

    public boolean allAccountsFull() {
        boolean bl = true;
        if (!this.q.getDefaultWaterAccount().isFull()) {
            bl = false;
        }
        Object object = this.a.getAlternative().getWaterAccountSet();
        object = ((WaterAccountSet)object).getWaterAccounts(this.q);
        for (int i = 0; i < object.size(); ++i) {
            if (((WaterAccount)object.get(i)).isFull()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public boolean allAccountsEmpty() {
        boolean bl = true;
        if (!this.q.getDefaultWaterAccount().isEmpty()) {
            bl = false;
        }
        Object object = this.a.getAlternative().getWaterAccountSet();
        object = ((WaterAccountSet)object).getWaterAccounts(this.q);
        for (int i = 0; i < object.size(); ++i) {
            if (((WaterAccount)object.get(i)).isEmpty()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public void setExcessInflowVol(double d) {
        this.u = d;
    }

    public String toString() {
        return this._name;
    }

    public int initEvalControllerDecision(RunTimeStep runTimeStep, ReservoirElement reservoirElement) {
        if (!this.w) {
            return 1;
        }
        this.setReservoirs(reservoirElement, runTimeStep);
        int n = this.setAccountFractions(runTimeStep);
        if (n != 0) {
            return n;
        }
        this.updateCharges(runTimeStep, 0.0);
        RunTimeStep runTimeStep2 = new RunTimeStep(runTimeStep);
        new RunTimeStep(runTimeStep).step = runTimeStep.step - 1;
        double d = this.q.getStorageFunction().getPreviousStorage(runTimeStep) - this.q.getReservoirOp().getGuideCurveStorage(runTimeStep2);
        d = Math.max(d, 0.0);
        this.setCreditAbvGC(runTimeStep, d);
        this.allocateInflow(runTimeStep);
        this.setMaxStorages(runTimeStep);
        return 0;
    }

    public void updateCharges(RunTimeStep runTimeStep, double d) {
        double d2;
        Storage storage = this.q.getStorageFunction();
        double d3 = storage.getPreviousStorage(runTimeStep);
        double d4 = 0.0;
        if (d3 < this.r) {
            d2 = this.r - d3;
            d4 = d2 / (double)runTimeStep.getTimeStepSeconds() * Storage.DSDT_TO_Q;
        }
        this.setTotalGCOpDemand(d);
        d2 = d4 + d;
        double d5 = this.getCurrentFractionOfCon();
        this.setCharges(runTimeStep, d5 * d2);
        Object object = this.a.getAlternative().getWaterAccountSet();
        object = ((WaterAccountSet)object).getWaterAccounts(this.q);
        for (int i = 0; i < object.size(); ++i) {
            WaterAccount waterAccount = (WaterAccount)object.get(i);
            d5 = waterAccount.getCurrentFractionOfCon();
            waterAccount.setCharges(runTimeStep, d5 * d2);
        }
    }

    private void setCreditAbvGC(RunTimeStep runTimeStep, double d) {
        double d2 = d * Storage.DSDT_TO_Q / (double)runTimeStep.getTimeStepSeconds();
        double d3 = this.getCurrentFractionOfCon();
        this.setCredit(runTimeStep, d3 * d2);
        Object object = this.a.getAlternative().getWaterAccountSet();
        object = ((WaterAccountSet)object).getWaterAccounts(this.q);
        for (int i = 0; i < object.size(); ++i) {
            WaterAccount waterAccount = (WaterAccount)object.get(i);
            d3 = waterAccount.getCurrentFractionOfCon();
            waterAccount.setCredit(runTimeStep, d3 * d2);
        }
    }

    private void allocateInflow(RunTimeStep runTimeStep) {
        List<WaterAccount> list = this.q.getStorageFunction();
        double d = ((Storage)((Object)list)).getNetInflow(runTimeStep);
        double d2 = ((Storage)((Object)list)).getInflow(runTimeStep);
        double d3 = ((Storage)((Object)list)).getPumpbackFlow(runTimeStep);
        double d4 = d2 + d3 - d;
        double d5 = this.getCurrentFractionOfCon();
        this.setCurrentInflow(runTimeStep, d5 * d2);
        this.setCurrentVolume(runTimeStep, 0.0);
        this.setLosses(runTimeStep, d5 * d4);
        this.setSurplus(runTimeStep, d5 * 0.0);
        this.setTransfers(runTimeStep, d5 * 0.0);
        if (d3 >= 0.0) {
            this.setPumpback(runTimeStep, 0.0);
        } else {
            this.setPumpback(runTimeStep, d3);
        }
        list = this.a.getAlternative().getWaterAccountSet();
        list = ((WaterAccountSet)((Object)list)).getWaterAccounts(this.q);
        for (int i = 0; i < list.size(); ++i) {
            WaterAccount waterAccount = list.get(i);
            d5 = waterAccount.getCurrentFractionOfCon();
            waterAccount.setCurrentInflow(runTimeStep, d5 * d2);
            waterAccount.setCurrentVolume(runTimeStep, 0.0);
            waterAccount.setLosses(runTimeStep, d5 * d4);
            waterAccount.setPumpback(runTimeStep, 0.0);
            waterAccount.setSurplus(runTimeStep, d5 * 0.0);
            waterAccount.setTransfers(runTimeStep, d5 * 0.0);
        }
    }

    public void updateLosses(RunTimeStep runTimeStep, double d) {
        Storage storage = this.q.getStorageFunction();
        double d2 = storage.getNetInflow(runTimeStep);
        double d3 = storage.getInflow(runTimeStep);
        double d4 = storage.getPumpbackFlow(runTimeStep);
        double d5 = d3 + d4 - d2;
        double d6 = this.getCurrentFractionOfCon();
        this.setLosses(runTimeStep, d6 * (d5 += d));
        Object object = this.a.getAlternative().getWaterAccountSet();
        object = ((WaterAccountSet)object).getWaterAccounts(this.q);
        for (int i = 0; i < object.size(); ++i) {
            WaterAccount waterAccount = (WaterAccount)object.get(i);
            d6 = waterAccount.getCurrentFractionOfCon();
            waterAccount.setLosses(runTimeStep, d6 * d5);
        }
    }

    public void initializeWADemands(RunTimeStep runTimeStep) {
        this.setDemand(runTimeStep, 0.0);
        this.D = false;
        Object object = this.a.getAlternative().getWaterAccountSet();
        object = ((WaterAccountSet)object).getWaterAccounts(this.q);
        for (int i = 0; i < object.size(); ++i) {
            WaterAccount waterAccount = (WaterAccount)object.get(i);
            waterAccount.setDemand(runTimeStep, 0.0);
            if (!waterAccount.hasYieldAnalysis()) continue;
            waterAccount.setRuleDemand(runTimeStep, 0.0);
        }
    }

    private void setMaxStorages(RunTimeStep runTimeStep) {
        double d = this.q.getGuideCurveStorage(runTimeStep) - this.r;
        this.setMaxStorage(runTimeStep, d);
        Object object = this.a.getAlternative().getWaterAccountSet();
        object = ((WaterAccountSet)object).getWaterAccounts(this.q);
        for (int i = 0; i < object.size(); ++i) {
            WaterAccount waterAccount = (WaterAccount)object.get(i);
            waterAccount.setMaxStorage(runTimeStep, d);
        }
    }

    private void setMaxStorage(RunTimeStep runTimeStep, double d) {
        double d2 = this.getDefaultFlag() ? d * this.getCurrentFractionOfCon() : (this.usePercentOfCon() ? d * this.getPercentOfCon() / 100.0 : Math.min(this.getMaxStorage(), d));
        this.setMaxVolTS(runTimeStep, d2);
    }

    public double getAvailableVolume(RunTimeStep runTimeStep) {
        double d = this.getPrevVolume(runTimeStep);
        if (d == -3.4028234663852886E38) {
            RunTimeStep runTimeStep2 = new RunTimeStep(runTimeStep);
            --runTimeStep2.step;
            if (runTimeStep2.step < 0) {
                runTimeStep2.step = 0;
            }
            d = this.q.getStorageFunction().getPreviousStorage(runTimeStep) - this.q.getStorageFunction().elevationToStorage(this.p.getElevation(runTimeStep2));
            if (this.usePercentOfCon()) {
                d *= this.getPercentOfCon() / 100.0;
            } else if (d > this.getMaxStorage()) {
                d = this.getMaxStorage();
            }
            this.setCurrentVolume(runTimeStep2, d);
        }
        double d2 = d + this.getTotalInflow(runTimeStep) * (double)runTimeStep.getTimeStepSeconds() / Storage.DSDT_TO_Q;
        return d2;
    }

    public boolean evalConvergence(int n, boolean bl) {
        if (n < 2) {
            return false;
        }
        if (bl) {
            return false;
        }
        if (this.allAccountsFull() || this.allAccountsEmpty()) {
            return true;
        }
        return !(Math.abs(this.getResExcessInflowVol()) > 0.01);
    }

    public void updateCurrentVolume(RunTimeStep runTimeStep) {
        double d;
        double d2 = this.getMaxVolTS(runTimeStep);
        double d3 = this.getPrevVolume(runTimeStep);
        double d4 = this.getDemand(runTimeStep);
        double d5 = this.getTotalInflow(runTimeStep);
        double d6 = d3 + (d5 - d4) * (double)runTimeStep.getTimeStepSeconds() / Storage.DSDT_TO_Q;
        if (d - d2 > -0.001) {
            this.u = d6 - d2;
            this.s = true;
            this.t = false;
            d6 = d2;
        } else if (d6 < 0.001) {
            this.u = d6;
            this.s = false;
            this.t = true;
            d6 = 0.0;
        } else {
            this.u = 0.0;
            this.s = false;
            this.t = false;
        }
        this.D = true;
        this.setCurrentVolume(runTimeStep, d6);
    }

    public void updateWAStates(RunTimeStep runTimeStep) {
        this.checkFullEmpty(runTimeStep);
        Object object = this.a.getAlternative().getWaterAccountSet();
        object = ((WaterAccountSet)object).getWaterAccounts(this.q);
        for (int i = 0; i < object.size(); ++i) {
            WaterAccount waterAccount = (WaterAccount)object.get(i);
            waterAccount.checkFullEmpty(runTimeStep);
        }
    }

    private void checkFullEmpty(RunTimeStep runTimeStep) {
        double d;
        double d2 = this.getMaxVolTS(runTimeStep);
        double d3 = this.getCurrentVolume(runTimeStep);
        if (d - d2 > -0.001) {
            this.s = true;
            this.t = false;
            return;
        }
        if (d3 < 0.001) {
            this.s = false;
            this.t = true;
            return;
        }
        this.s = false;
        this.t = false;
    }

    public void redistributeInflow(RunTimeStep runTimeStep) {
        double d;
        double d2;
        WaterAccount waterAccount;
        double d3;
        this.sumResExcessInflowVol();
        double d4 = this.getResExcessInflowVol();
        double d5 = d4 * Storage.DSDT_TO_Q / (double)runTimeStep.getTimeStepSeconds();
        if (Math.abs(d3) < 0.01) {
            return;
        }
        Object object = this.a.getAlternative().getWaterAccountSet();
        object = ((WaterAccountSet)object).getWaterAccounts(this.q);
        for (int i = 0; i < object.size(); ++i) {
            waterAccount = (WaterAccount)object.get(i);
            if (waterAccount.isFull()) {
                d2 = waterAccount.getExcessInflowVol() * Storage.DSDT_TO_Q / (double)runTimeStep.getTimeStepSeconds();
                waterAccount.incrementSurplus(runTimeStep, d2);
                waterAccount.incrementTransfers(runTimeStep, -d2);
                continue;
            }
            if (!waterAccount.isEmpty()) continue;
            d = waterAccount.getExcessInflowVol() * Storage.DSDT_TO_Q / (double)runTimeStep.getTimeStepSeconds();
            waterAccount.incrementTransfers(runTimeStep, -d);
        }
        if (this.isFull()) {
            d2 = this.getExcessInflowVol() * Storage.DSDT_TO_Q / (double)runTimeStep.getTimeStepSeconds();
            this.incrementSurplus(runTimeStep, d2);
            this.incrementTransfers(runTimeStep, -d2);
        } else if (this.isEmpty()) {
            d = this.getExcessInflowVol() * Storage.DSDT_TO_Q / (double)runTimeStep.getTimeStepSeconds();
            this.incrementTransfers(runTimeStep, -d);
        }
        if (d5 > 0.0) {
            double d6 = 0.0;
            for (int i = 0; i < object.size(); ++i) {
                waterAccount = (WaterAccount)object.get(i);
                if (waterAccount.isFull()) continue;
                d6 += waterAccount.getCurrentFractionOfCon();
            }
            if (!this.isFull()) {
                d6 += this.getCurrentFractionOfCon();
            }
            for (int i = 0; i < object.size(); ++i) {
                waterAccount = (WaterAccount)object.get(i);
                if (waterAccount.isFull()) continue;
                double d7 = waterAccount.getCurrentFractionOfCon() / d6;
                waterAccount.incrementTransfers(runTimeStep, d7 * d5);
            }
            if (!this.isFull()) {
                double d8 = this.getCurrentFractionOfCon() / d6;
                this.incrementTransfers(runTimeStep, d8 * d5);
            }
            return;
        }
        if (d5 < 0.0) {
            double d9 = 0.0;
            for (int i = 0; i < object.size(); ++i) {
                waterAccount = (WaterAccount)object.get(i);
                if (waterAccount.isEmpty()) continue;
                d9 += waterAccount.getCurrentFractionOfCon();
            }
            if (!this.isEmpty()) {
                d9 += this.getCurrentFractionOfCon();
            }
            for (int i = 0; i < object.size(); ++i) {
                waterAccount = (WaterAccount)object.get(i);
                if (waterAccount.isEmpty()) continue;
                double d10 = waterAccount.getCurrentFractionOfCon() / d9;
                waterAccount.incrementTransfers(runTimeStep, d10 * d5);
            }
            if (!this.isEmpty()) {
                double d11 = this.getCurrentFractionOfCon() / d9;
                this.incrementTransfers(runTimeStep, d11 * d5);
            }
        }
    }

    public double sumWADemands(RunTimeStep runTimeStep, double d) {
        double d2 = d + this.getDemand(runTimeStep);
        Object object = this.a.getAlternative().getWaterAccountSet();
        object = ((WaterAccountSet)object).getWaterAccounts(this.q);
        for (int i = 0; i < object.size(); ++i) {
            WaterAccount waterAccount = (WaterAccount)object.get(i);
            d2 += waterAccount.getDemand(runTimeStep);
        }
        return d2;
    }

    public void updateVolumes(RunTimeStep runTimeStep) {
        this.updateCurrentVolume(runTimeStep);
        Object object = this.a.getAlternative().getWaterAccountSet();
        object = ((WaterAccountSet)object).getWaterAccounts(this.q);
        for (int i = 0; i < object.size(); ++i) {
            WaterAccount waterAccount = (WaterAccount)object.get(i);
            waterAccount.updateCurrentVolume(runTimeStep);
        }
    }

    public void updatePumpbackDestinationOnlyDefault(RunTimeStep runTimeStep, double d) {
        double d2 = this.getCurrentVolume(runTimeStep);
        double d3 = this.getMaxVolTS(runTimeStep);
        double d4 = d * (double)runTimeStep.getTimeStepSeconds() / Storage.DSDT_TO_Q;
        this.setPumpback(runTimeStep, d);
        if (d2 + d4 > d3) {
            double d5 = d2 + d4 - d3;
            this.setCurrentVolume(runTimeStep, d3);
            this.setExcessInflowVol(d5);
            this.updateWAStates(runTimeStep);
            for (int i = 0; i < 10; ++i) {
                this.redistributeInflow(runTimeStep);
                this.updateVolumes(runTimeStep);
                if (this.evalConvergence(i, false)) break;
            }
            return;
        }
        this.setCurrentVolume(runTimeStep, d2 += d4);
    }

    public void updatePumpbackDestinationAllAccounts(RunTimeStep runTimeStep, double d) {
        Iterator iterator;
        WaterAccount waterAccount;
        double d2 = d * (double)runTimeStep.getTimeStepSeconds() / Storage.DSDT_TO_Q;
        HashMap<WaterAccount, Double> hashMap = new HashMap<WaterAccount, Double>();
        HashMap<WaterAccount, Double> hashMap2 = new HashMap<WaterAccount, Double>();
        HashMap<WaterAccount, Double> hashMap3 = new HashMap<WaterAccount, Double>();
        HashMap<WaterAccount, Boolean> hashMap4 = new HashMap<WaterAccount, Boolean>();
        WaterAccount waterAccount2 = this;
        hashMap.put(waterAccount2, waterAccount2.getCurrentVolume(runTimeStep));
        hashMap2.put(this, 0.0);
        WaterAccount waterAccount3 = this;
        hashMap3.put(waterAccount3, waterAccount3.getCurrentFractionOfCon());
        hashMap4.put(this, Boolean.FALSE);
        Object object = this.a.getAlternative().getWaterAccountSet();
        object = ((WaterAccountSet)object).getWaterAccounts(this.q);
        Iterator<WaterAccount> iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            WaterAccount waterAccount4;
            WaterAccount waterAccount5 = waterAccount = (waterAccount4 = iterator2.next());
            hashMap.put(waterAccount5, waterAccount5.getCurrentVolume(runTimeStep));
            hashMap2.put(waterAccount, 0.0);
            WaterAccount waterAccount6 = waterAccount;
            hashMap3.put(waterAccount6, waterAccount6.getCurrentFractionOfCon());
            hashMap4.put(waterAccount, Boolean.FALSE);
        }
        for (int i = 0; i < 10; ++i) {
            double d3;
            double d4;
            double d5;
            double d6;
            double d7;
            double d8;
            double d9;
            double d10 = 0.0;
            if (!((Boolean)hashMap4.get(this)).booleanValue()) {
                double d11 = (Double)hashMap.get(this);
                d9 = this.getMaxVolTS(runTimeStep);
                d8 = (Double)hashMap3.get(this);
                d7 = d2 * d8;
                d6 = d11 + d7;
                hashMap.put(this, Math.min(d6, d9));
                d5 = (Math.min(d6, d9) - d11) * Storage.DSDT_TO_Q / (double)runTimeStep.getTimeStepSeconds();
                hashMap2.put(this, d5);
                hashMap4.put(this, d6 >= d9);
                d10 = 0.0 + Math.max(0.0, d6 - d9);
            }
            iterator = object.iterator();
            while (iterator.hasNext()) {
                waterAccount = (WaterAccount)iterator.next();
                if (((Boolean)hashMap4.get(waterAccount)).booleanValue()) continue;
                double d12 = (Double)hashMap.get(waterAccount);
                d9 = waterAccount.getMaxVolTS(runTimeStep);
                d8 = (Double)hashMap3.get(waterAccount);
                d7 = d2 * d8;
                d6 = d12 + d7;
                hashMap.put(waterAccount, Math.min(d6, d9));
                d5 = (Math.min(d6, d9) - d12) * Storage.DSDT_TO_Q / (double)runTimeStep.getTimeStepSeconds();
                hashMap2.put(waterAccount, d5);
                hashMap4.put(waterAccount, d6 >= d9);
                d10 += Math.max(0.0, d6 - d9);
            }
            if (Math.abs(d10) < 0.01) break;
            d2 = d10;
            double d13 = 0.0;
            if (!((Boolean)hashMap4.get(this)).booleanValue()) {
                d13 = 0.0 + this.getCurrentFractionOfCon();
            }
            iterator = object.iterator();
            while (iterator.hasNext()) {
                waterAccount = (WaterAccount)iterator.next();
                if (((Boolean)hashMap4.get(waterAccount)).booleanValue()) continue;
                d13 += waterAccount.getCurrentFractionOfCon();
            }
            if (!((Boolean)hashMap4.get(this)).booleanValue()) {
                d4 = this.getCurrentFractionOfCon();
                d3 = d4 / d13;
                hashMap3.put(this, d3);
            } else {
                hashMap3.put(this, 0.0);
            }
            iterator = object.iterator();
            while (iterator.hasNext()) {
                waterAccount = (WaterAccount)iterator.next();
                if (!((Boolean)hashMap4.get(waterAccount)).booleanValue()) {
                    d4 = waterAccount.getCurrentFractionOfCon();
                    d3 = d4 / d13;
                    hashMap3.put(waterAccount, d3);
                    continue;
                }
                hashMap3.put(waterAccount, 0.0);
            }
        }
        this.setCurrentVolume(runTimeStep, (Double)hashMap.get(this));
        this.setPumpback(runTimeStep, (Double)hashMap2.get(this));
        Iterator iterator3 = object.iterator();
        while (iterator3.hasNext()) {
            iterator = (WaterAccount)iterator3.next();
            waterAccount = iterator;
            ((WaterAccount)((Object)iterator)).setCurrentVolume(runTimeStep, (Double)hashMap.get(waterAccount));
            waterAccount.setPumpback(runTimeStep, (Double)hashMap2.get(waterAccount));
        }
    }

    public void updatePumpbackSource(RunTimeStep runTimeStep, double d) {
        double d2;
        double d3 = this.getCurrentVolume(runTimeStep);
        double d4 = this.getMaxVolTS(runTimeStep);
        double d5 = this.getPumpback(runTimeStep);
        if (Math.abs(d2 - d) < 0.01) {
            return;
        }
        double d6 = (d - d5) * (double)runTimeStep.getTimeStepSeconds() / Storage.DSDT_TO_Q;
        this.setPumpback(runTimeStep, d);
        if (d3 + d6 > d4) {
            double d7 = d3 + d6 - d4;
            this.setCurrentVolume(runTimeStep, d4);
            this.setExcessInflowVol(d7);
            this.updateWAStates(runTimeStep);
            for (int i = 0; i < 10; ++i) {
                this.redistributeInflow(runTimeStep);
                this.updateVolumes(runTimeStep);
                if (this.evalConvergence(i, false)) break;
            }
            return;
        }
        this.setCurrentVolume(runTimeStep, d3 += d6);
    }

    public void sumResExcessInflowVol() {
        double d = this.getExcessInflowVol();
        Object object = this.a.getAlternative().getWaterAccountSet();
        object = ((WaterAccountSet)object).getWaterAccounts(this.q);
        for (int i = 0; i < object.size(); ++i) {
            d += ((WaterAccount)object.get(i)).getExcessInflowVol();
        }
        this.setResExcessInflowVol(d);
    }

    public double getCurrentInflow(RunTimeStep runTimeStep) {
        if (this.f == null) {
            this.f = this.getTSContainer(this.o + this.getName(), 192);
        }
        return this.f.array[runTimeStep.getStep()];
    }

    public void setCurrentInflow(RunTimeStep runTimeStep, double d) {
        if (this.f == null) {
            this.f = this.getTSContainer(this.o + this.getName(), 192);
        }
        this.f.set(runTimeStep.getStep(), d);
    }

    public double getPrevVolume(RunTimeStep runTimeStep) {
        if (this.d == null) {
            this.d = this.getTSContainer(this.o + this.getName(), 190);
        }
        return this.d.array[runTimeStep.getPrevStep()];
    }

    public double getCurrentVolume(RunTimeStep runTimeStep) {
        if (this.d == null) {
            this.d = this.getTSContainer(this.o + this.getName(), 190);
        }
        return this.d.array[runTimeStep.step];
    }

    public void setCurrentVolume(RunTimeStep runTimeStep, double d) {
        if (this.d == null) {
            this.d = this.getTSContainer(this.o + this.getName(), 190);
        }
        this.d.array[runTimeStep.step] = d;
    }

    public void setDemand(RunTimeStep runTimeStep, double d) {
        if (this.g == null) {
            this.g = this.getTSContainer(this.o + this.getName(), 193);
        }
        this.g.set(runTimeStep.getStep(), d);
    }

    public double getDemand(RunTimeStep runTimeStep) {
        if (this.g == null) {
            this.g = this.getTSContainer(this.o + this.getName(), 193);
        }
        return this.g.array[runTimeStep.getStep()];
    }

    public double getRuleDemand(RunTimeStep runTimeStep) {
        if (this.v) {
            if (this.h == null) {
                this.h = this.getTSContainer(this.o + this.getName(), 194);
            }
            return this.h.array[runTimeStep.getStep()];
        }
        return Double.NEGATIVE_INFINITY;
    }

    public void setRuleDemand(RunTimeStep runTimeStep, double d) {
        if (this.v) {
            if (this.h == null) {
                this.h = this.getTSContainer(this.o + this.getName(), 194);
            }
            this.h.set(runTimeStep.getStep(), d);
        }
    }

    public void setMaxVolTS(RunTimeStep runTimeStep, double d) {
        if (this.e == null) {
            this.e = this.getTSContainer(this.o + this.getName(), 191);
        }
        this.e.set(runTimeStep.getStep(), d);
    }

    public double getMaxVolTS(RunTimeStep runTimeStep) {
        if (this.e == null) {
            this.e = this.getTSContainer(this.o + this.getName(), 191);
        }
        return this.e.array[runTimeStep.step];
    }

    public void setSurplus(RunTimeStep runTimeStep, double d) {
        if (this.i == null) {
            this.i = this.getTSContainer(this.o + this.getName(), 203);
        }
        this.i.set(runTimeStep.step, d);
    }

    public double getSurplus(RunTimeStep runTimeStep) {
        if (this.i == null) {
            this.i = this.getTSContainer(this.o + this.getName(), 203);
        }
        return this.i.array[runTimeStep.step];
    }

    public void setTransfers(RunTimeStep runTimeStep, double d) {
        if (this.j == null) {
            this.j = this.getTSContainer(this.o + this.getName(), 204);
        }
        this.j.set(runTimeStep.step, d);
    }

    public double getTransfers(RunTimeStep runTimeStep) {
        if (this.j == null) {
            this.j = this.getTSContainer(this.o + this.getName(), 204);
        }
        return this.j.array[runTimeStep.step];
    }

    public void setCredit(RunTimeStep runTimeStep, double d) {
        if (this.k == null) {
            this.k = this.getTSContainer(this.o + this.getName(), 206);
        }
        this.k.set(runTimeStep.step, d);
    }

    public double getCredit(RunTimeStep runTimeStep) {
        if (this.k == null) {
            this.k = this.getTSContainer(this.o + this.getName(), 206);
        }
        return this.k.array[runTimeStep.step];
    }

    public void setLosses(RunTimeStep runTimeStep, double d) {
        if (this.l == null) {
            this.l = this.getTSContainer(this.o + this.getName(), 207);
        }
        this.l.set(runTimeStep.step, d);
    }

    public double getLosses(RunTimeStep runTimeStep) {
        if (this.l == null) {
            this.l = this.getTSContainer(this.o + this.getName(), 207);
        }
        return this.l.array[runTimeStep.step];
    }

    public void setCharges(RunTimeStep runTimeStep, double d) {
        if (this.m == null) {
            this.m = this.getTSContainer(this.o + this.getName(), 205);
        }
        this.m.set(runTimeStep.step, d);
    }

    public double getCharges(RunTimeStep runTimeStep) {
        if (this.m == null) {
            this.m = this.getTSContainer(this.o + this.getName(), 205);
        }
        return this.m.array[runTimeStep.step];
    }

    public void setPumpback(RunTimeStep runTimeStep, double d) {
        if (this.n == null) {
            this.n = this.getTSContainer(this.o + this.getName(), 208);
        }
        this.n.set(runTimeStep.step, d);
    }

    public double getPumpback(RunTimeStep runTimeStep) {
        if (this.n == null) {
            this.n = this.getTSContainer(this.o + this.getName(), 208);
        }
        return this.n.array[runTimeStep.step];
    }

    public void incrementTransfers(RunTimeStep runTimeStep, double d) {
        double d2 = this.getTransfers(runTimeStep);
        this.setTransfers(runTimeStep, d2 += d);
    }

    public void incrementSurplus(RunTimeStep runTimeStep, double d) {
        double d2 = this.getSurplus(runTimeStep);
        this.setSurplus(runTimeStep, d2 += d);
    }

    public double getTotalInflow(RunTimeStep runTimeStep) {
        double d = this.getCurrentInflow(runTimeStep);
        double d2 = this.getTransfers(runTimeStep);
        double d3 = this.getCredit(runTimeStep);
        double d4 = this.getLosses(runTimeStep);
        double d5 = this.getCharges(runTimeStep);
        double d6 = this.getPumpback(runTimeStep);
        double d7 = d + d3 + d6 + d2 - d4 - d5;
        return d7;
    }

    public void setUsePercentOfCon(boolean bl) {
        this._usePercentOfCon = bl;
    }

    public boolean usePercentOfCon() {
        return this._usePercentOfCon;
    }

    public void setPercentOfCon(double d) {
        this._percentOfCon = d;
    }

    public double getPercentOfCon() {
        if (this.y) {
            return this._percentOfCon * this.z;
        }
        return this._percentOfCon;
    }

    public void setMaxStorage(double d) {
        this._maxStorage = d;
    }

    public double getMaxStorage() {
        if (this.y) {
            return this.z * this._maxStorage;
        }
        return this._maxStorage;
    }

    public void setRuleRefs(List<YieldAnalysisRuleRef> list) {
        this._ruleRefs = list;
    }

    public List<YieldAnalysisRuleRef> getRuleRefs() {
        return this._ruleRefs;
    }

    public void setName(String string) {
        this._name = string;
    }

    public String getName() {
        return this._name;
    }

    public void setDescription(String string) {
        this._description = string;
    }

    public String getDescription() {
        return this._description;
    }

    public void setTotalGCOpDemand(double d) {
        this.B = d;
    }

    public double getTotalGCOpDemand() {
        return this.B;
    }

    public void setResExcessInflowVol(double d) {
        this.A = d;
    }

    public double getResExcessInflowVol() {
        return this.A;
    }

    public boolean inflowEvaled() {
        return this.D;
    }

    public int setAccountFractions(RunTimeStep runTimeStep) {
        Object object = this.a.getAlternative().getWaterAccountSet();
        object = ((WaterAccountSet)object).getWaterAccounts(this.q);
        int n = 1;
        for (int i = 0; i < object.size(); ++i) {
            if (((WaterAccount)object.get(i)).usePercentOfCon()) continue;
            n = 0;
        }
        double d = 0.0;
        if (n != 0) {
            for (n = 0; n < object.size(); ++n) {
                double d2 = ((WaterAccount)object.get(n)).getPercentOfCon() / 100.0;
                ((WaterAccount)object.get(n)).setCurrentFractionOfCon(d2);
                d += d2;
            }
        } else {
            for (n = 0; n < object.size(); ++n) {
                double d3;
                if (((WaterAccount)object.get(n)).usePercentOfCon()) {
                    d3 = ((WaterAccount)object.get(n)).getPercentOfCon() / 100.0;
                } else {
                    double d4 = this.q.getGuideCurveStorage(runTimeStep);
                    double d5 = this.q.getStorageFunction().elevationToStorage(this.p.getElevation(runTimeStep));
                    double d6 = d4 - d5;
                    d3 = ((WaterAccount)object.get(n)).getMaxStorage() / d6;
                }
                ((WaterAccount)object.get(n)).setCurrentFractionOfCon(d3);
                d += d3;
            }
        }
        if (d - 1.0 > 1.0E-5) {
            System.out.println("The Reservoir " + this.q.getName() + " is Over-Allocated for Water Accounting at time step " + runTimeStep.dateTimeString() + ". ");
            this.a.printErrorMessage("The Reservoir " + this.q.getName() + " is Over-Allocated for Water Accountingat time step " + runTimeStep.dateTimeString() + ". ");
            return 1;
        }
        if (Math.abs(1.0 - d) > 1.0E-5) {
            this.setCurrentFractionOfCon(1.0 - d);
        } else {
            this.setCurrentFractionOfCon(0.0);
        }
        return 0;
    }

    public void setCurrentFractionOfCon(double d) {
        this.x = d;
    }

    public double getCurrentFractionOfCon() {
        return this.x;
    }

    public boolean hasYieldAnalysis() {
        return this.v;
    }

    public void applyHindcastData(HindcastData hindcastData) {
        if (hindcastData == null) {
            return;
        }
        this._hindcastCondition = hindcastData.getType();
        if (hindcastData.getVariableId() == 195 && hindcastData.getType() == 1) {
            this.c = hindcastData.getValue();
        }
    }

    public double getInitialStorage() {
        return this.c;
    }

    public void setInitialStorage(double d) {
        this.c = d;
    }

    public boolean usesReservoir(ReservoirElement reservoirElement) {
        for (int i = 0; i < this._ruleRefs.size(); ++i) {
            Object object = this._ruleRefs.get(i);
            if ((object = ((YieldAnalysisRuleRef)object).getReservoirList(this.a.getAlternative())) == null) continue;
            for (int j = 0; j < object.size(); ++j) {
                if (((ReservoirElement)object.get(j)).getIndex() != reservoirElement.getIndex()) continue;
                return true;
            }
        }
        return false;
    }

    public int computeHindcastStep(RunTimeStep runTimeStep) {
        double d;
        Object object;
        Object object2;
        double d2 = 0.0;
        Object object3 = this.a.getAlternative().getWaterAccountSet();
        if (object3 == null) {
            object3 = "Water Account Set not found.";
            System.out.println((String)object3);
            this.a.printErrorMessage((String)object3);
            return 1;
        }
        object3 = ((WaterAccountSet)object3).getResZoneRefs();
        Iterator<StorageZoneRef> iterator = object3.iterator();
        while (iterator.hasNext()) {
            Object object4 = iterator.next();
            object2 = this.a.findReservoir(((StorageZoneRef)object4).getReservoirIndex());
            OpSet opSet = ((ReservoirElement)object2).getReservoirOp().getOperationSet(((StorageZoneRef)object4).getOpsetId());
            object3 = opSet.getZone(((StorageZoneRef)object4).getZoneIndex());
            object = opSet.getGuideCurveZone();
            object4 = ((ReservoirElement)object2).getStorageFunction();
            double d3 = ((Storage)object4).elevationToStorage(((StorageZone)object).getElevation(runTimeStep));
            double d4 = ((Storage)object4).elevationToStorage(((StorageZone)object3).getElevation(runTimeStep));
            ((Storage)object4).getStorage(runTimeStep);
            d2 += d3 - d4;
        }
        if (this._usePercentOfCon) {
            d = d2 * this.getPercentOfCon() / 100.0;
        } else {
            double d5;
            d = this.getMaxStorage();
            if (d5 > d2) {
                object2 = "Water Accounting Error: " + this.getName() + " maximum storage exceeds storage in reservoir(s).";
                System.out.println((String)object2);
                this.a.printErrorMessage((String)object2);
                return 1;
            }
        }
        this.setMaxVolTS(runTimeStep, d);
        double d6 = d;
        switch (this._hindcastCondition) {
            case 0: {
                if (this.b != null && RMAConst.isValidValue((double)this.b.array[runTimeStep.step])) {
                    d6 = this.b.array[runTimeStep.step];
                    break;
                }
                object3 = "Water Accounting Error: Known storage TS empty or invalid for Water Account: " + this.getName();
                object = "Date and Time: " + runTimeStep.dateTimeString();
                System.out.println((String)object3);
                System.out.println((String)object);
                this.a.printErrorMessage((String)object3);
                this.a.printErrorMessage((String)object);
                return 1;
            }
            case 1: {
                d6 = this.getInitialStorage();
                break;
            }
            case 2: {
                d6 = this._usePercentOfCon ? d2 * this.getPercentOfCon() / 100.0 : this.getMaxStorage();
                if (!(d6 > d)) break;
                d6 = d;
            }
        }
        if (d > d2 + 1.0E-5) {
            object3 = "Water Accounting Error: " + this.getName() + " lookback storage " + d + " exceeds storage in reservoir(s) " + d2;
            System.out.println((String)object3);
            this.a.printErrorMessage((String)object3);
            return 1;
        }
        this.setCurrentVolume(runTimeStep, d6);
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    public int computeDefaultWAhindcastStep(RunTimeStep var1_1) {
        if (!this.w) {
            return 1;
        }
        var2_2 = this.a.getAlternative().getWaterAccountSet();
        var3_3 = var2_2.getWaterAccounts();
        var2_2 = var2_2.getResZoneRefs();
        var4_4 = null;
        for (var5_5 = 0; var5_5 < var2_2.size(); ++var5_5) {
            var7_7 = (StorageZoneRef)var2_2.get(var5_5);
            var8_9 = var7_7.getReservoirIndex();
            if (this.q.getIndex() != var8_9) continue;
            var4_4 = var7_7.getStorageZone();
            if (var4_4 != null) break;
            var9_10 = this.q.getReservoirOp().getOperationSet(var7_7.getOpsetId());
            var4_4 = var9_10.getZone(var7_7.getZoneIndex());
            break;
        }
        this.p = var4_4;
        var5_6 = this.q.getStorageFunction();
        var7_8 = var5_6.getStorage(var1_1);
        var9_11 = var5_6.elevationToStorage(var4_4.getElevation(var1_1));
        var11_12 = this.q.getGuideCurveStorage(var1_1);
        if (!(var7_8 <= var9_11)) {
            var13_13 = var7_8 - var9_11;
            for (var15_14 = 0; var15_14 < var3_3.size(); ++var15_14) {
                var16_16 = var3_3.get(var15_14);
                if (!var16_16.usesReservoir(this.q)) continue;
                var17_17 = var16_16.getCurrentVolume(var1_1);
                var13_13 -= var17_17;
            }
            if (var13_13 < 0.0) {
                var15_15 = var13_13 / var11_12;
                if (Math.abs(v0) > 1.0E-5) {
                    System.out.println("The Reservoir " + this.q.getName() + " is Over-Allocated for Water Accounting. Please check hindcast data.");
                    this.a.printErrorMessage("The Reservoir " + this.q.getName() + " is Over-Allocated for Water Accounting. Please check hindcast data.");
                    return 1;
                } else {
                    ** GOTO lbl-1000
                }
            }
        } else lbl-1000:
        // 3 sources

        {
            var13_13 = 0.0;
        }
        this.d.array[var1_1.step] = var13_13;
        this.e.array[var1_1.step] = var13_13;
        return 0;
    }

    public boolean checkUsesRule(RssSystem rssSystem, List<YieldAnalysisRuleRef> list) {
        boolean bl = false;
        this.initializeRules(rssSystem);
        if (this._ruleRefs != null && list != null) {
            for (int i = 0; i < this._ruleRefs.size(); ++i) {
                if (!(this._ruleRefs.get(i).getRule() instanceof OpRule)) continue;
                int n = ((OpRule)this._ruleRefs.get(i).getRule()).getIndex();
                for (int j = 0; j < list.size(); ++j) {
                    int n2;
                    if (!(list.get(j).getRule() instanceof OpRule) || (n2 = ((OpRule)list.get(j).getRule()).getIndex()) != n) continue;
                    bl = true;
                    break;
                }
                if (bl) break;
            }
        }
        return bl;
    }

    public double getStorageScale() {
        return this.z;
    }

    public void setStorageScale(double d) {
        this.z = d;
    }

    public void setUseStorageScale(boolean bl) {
        this.y = bl;
    }

    public boolean writeFile(BufferedWriter bufferedWriter) throws IOException {
        if (bufferedWriter == null) {
            return false;
        }
        bufferedWriter.write("WaterAccountBegin");
        bufferedWriter.newLine();
        bufferedWriter.write("Name=" + this.getName());
        bufferedWriter.newLine();
        bufferedWriter.write("Description=" + this.getDescription());
        bufferedWriter.newLine();
        bufferedWriter.write("UsePercentOfCon=" + Boolean.toString(this._usePercentOfCon));
        bufferedWriter.newLine();
        bufferedWriter.write("PercentOfCon=" + Double.toString(this._percentOfCon));
        bufferedWriter.newLine();
        bufferedWriter.write("MaxStorage=" + Double.toString(this._maxStorage));
        bufferedWriter.newLine();
        bufferedWriter.write("Index=" + Integer.toString(this._index));
        bufferedWriter.newLine();
        for (int i = 0; i < this._ruleRefs.size(); ++i) {
            YieldAnalysisRuleRef yieldAnalysisRuleRef = this._ruleRefs.get(i);
            yieldAnalysisRuleRef.writeDataToFile(bufferedWriter);
        }
        bufferedWriter.write("WaterAccountEnd");
        bufferedWriter.newLine();
        return true;
    }

    public boolean readFile(BufferedReader bufferedReader) throws IOException {
        this._ruleRefs = new ArrayList<YieldAnalysisRuleRef>();
        if (bufferedReader == null) {
            return false;
        }
        String string = bufferedReader.readLine();
        while (string != null) {
            int n = string.indexOf(61);
            if (n < 0) continue;
            Object object = string.substring(0, n);
            String string2 = string.substring(n + 1);
            if (((String)object).equals("WaterAccountEnd")) {
                return true;
            }
            if (((String)object).equals("Name")) {
                this.setName(string2);
                continue;
            }
            if (((String)object).equals("Description")) {
                this.setDescription(string2);
                continue;
            }
            if (((String)object).equals("UsePercentOfCon")) {
                this.setUsePercentOfCon(Boolean.parseBoolean(string2));
                continue;
            }
            if (((String)object).equals("PercentOfCon")) {
                this.setPercentOfCon(Double.parseDouble(string2));
                continue;
            }
            if (((String)object).equals("MaxStorage")) {
                this.setMaxStorage(Double.parseDouble(string2));
                continue;
            }
            if (((String)object).equals("Index")) {
                this.setIndex(Integer.parseInt(string2));
                continue;
            }
            if (!((String)object).equals("YieldAnalysisRuleRefBegin")) continue;
            object = new YieldAnalysisRuleRef();
            ((YieldAnalysisRuleRef)object).readFile(bufferedReader);
            this._ruleRefs.add((YieldAnalysisRuleRef)object);
        }
        return true;
    }

    @Override
    public Object clone() {
        WaterAccount waterAccount = (WaterAccount)super.clone();
        if (this._ruleRefs != null) {
            ArrayList<YieldAnalysisRuleRef> arrayList = new ArrayList<YieldAnalysisRuleRef>();
            for (int i = 0; i < this._ruleRefs.size(); ++i) {
                YieldAnalysisRuleRef yieldAnalysisRuleRef = (YieldAnalysisRuleRef)this._ruleRefs.get(i).clone();
                arrayList.add(yieldAnalysisRuleRef);
            }
            waterAccount.setRuleRefs(arrayList);
        }
        return waterAccount;
    }

    @Override
    public Object getFieldObject(Field object) {
        try {
            object = ((Field)object).get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    @Override
    public RssSystem getSystem() {
        return this.a;
    }

    public void setSystem(RssSystem rssSystem) {
        this.a = rssSystem;
    }

    public void updateTSProxyList(boolean bl) {
        this.v = bl;
        if (this.v) {
            String string;
            if ((this.o == null || this.o.length() == 0) && this.a != null && this._waterAccountSetIndex != Integer.MIN_VALUE && (string = this.a.getWaterAccountSet(this._waterAccountSetIndex).getName()) != null) {
                this.o = string + " - ";
            }
            WaterAccount waterAccount = this;
            TSRecordProxy tSRecordProxy = waterAccount.getTSRecordProxy(waterAccount.o + this.getName(), 194);
            if (tSRecordProxy == null) {
                WaterAccount waterAccount2 = this;
                waterAccount2.addTSRecordProxy(waterAccount2.o + this.getName(), 194);
            }
        }
        ((RssTSLocationObject)this).updateTSProxyList();
    }

    @Override
    public void updateTSProxyList() {
        Object object;
        Object object2;
        if (!this.w) {
            if ((this.o == null || this.o.length() == 0) && this.a != null && this._waterAccountSetIndex != Integer.MIN_VALUE && (object2 = this.a.getWaterAccountSet(this._waterAccountSetIndex).getName()) != null) {
                this.o = (String)object2 + " - ";
            }
            object = this.o + this.getName();
        } else {
            object = this.getName();
        }
        object2 = this.getTSRecordProxy((String)object, 190);
        if (object2 == null) {
            this.addTSRecordProxy((String)object, 190);
        }
        if ((object2 = this.getTSRecordProxy((String)object, 191)) == null) {
            this.addTSRecordProxy((String)object, 191);
        }
        if ((object2 = this.getTSRecordProxy((String)object, 192)) == null) {
            this.addTSRecordProxy((String)object, 192);
        }
        if ((object2 = this.getTSRecordProxy((String)object, 193)) == null) {
            this.addTSRecordProxy((String)object, 193);
        }
        if ((object2 = this.getTSRecordProxy((String)object, 203)) == null) {
            this.addTSRecordProxy((String)object, 203);
        }
        if ((object2 = this.getTSRecordProxy((String)object, 204)) == null) {
            this.addTSRecordProxy((String)object, 204);
        }
        if ((object2 = this.getTSRecordProxy((String)object, 206)) == null) {
            this.addTSRecordProxy((String)object, 206);
        }
        if ((object2 = this.getTSRecordProxy((String)object, 205)) == null) {
            this.addTSRecordProxy((String)object, 205);
        }
        if ((object2 = this.getTSRecordProxy((String)object, 207)) == null) {
            this.addTSRecordProxy((String)object, 207);
        }
        if ((object2 = this.getTSRecordProxy((String)object, 208)) == null) {
            this.addTSRecordProxy((String)object, 208);
        }
        if (!this.w && (object2 = this.getTSRecordProxy((String)object, 195)) == null) {
            this.addTSRecordProxy((String)object, 195);
        }
    }

    public Vector getActiveTSProxies(Vector vector, int n) {
        if (vector == null) {
            vector = new Vector<TSRecordProxy>();
        }
        if (n == 1 && !this.w) {
            if (this._hindcastCondition == 0) {
                WaterAccount waterAccount = this;
                vector.add(waterAccount.getTSRecordProxy(waterAccount.o + this.getName(), 195));
            }
        } else if (n == 0) {
            Object object = !this.w ? this.o + this.getName() : this.getName();
            vector.add(this.getTSRecordProxy((String)object, 190));
            vector.add(this.getTSRecordProxy((String)object, 191));
            vector.add(this.getTSRecordProxy((String)object, 192));
            vector.add(this.getTSRecordProxy((String)object, 193));
            vector.add(this.getTSRecordProxy((String)object, 203));
            vector.add(this.getTSRecordProxy((String)object, 204));
            vector.add(this.getTSRecordProxy((String)object, 205));
            vector.add(this.getTSRecordProxy((String)object, 206));
            vector.add(this.getTSRecordProxy((String)object, 207));
            vector.add(this.getTSRecordProxy((String)object, 208));
            if (this.v && !this.w) {
                vector.add(this.getTSRecordProxy((String)object, 194));
            }
        }
        return vector;
    }

    public TSRecordProxy getActiveTSProxy(int n) {
        TSRecordProxy tSRecordProxy = null;
        Iterator iterator = new Vector();
        iterator = this.getActiveTSProxies((Vector)((Object)iterator), 0);
        ArrayList<TSRecordProxy> arrayList = new ArrayList<TSRecordProxy>();
        iterator = ((Vector)((Object)iterator)).iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof TSRecordProxy)) continue;
            arrayList.add((TSRecordProxy)object);
        }
        for (TSRecordProxy tSRecordProxy2 : arrayList) {
            int n2 = tSRecordProxy2.getVariableId();
            if (n != n2) continue;
            tSRecordProxy = tSRecordProxy2;
            break;
        }
        return tSRecordProxy;
    }
}

