/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.TSDataSet;
import hec.clientapp.model.TSRecordProxy;
import hec.gfx2d.TimeSeriesDataSet;
import hec.heclib.dss.DSSPathname;
import hec.heclib.util.HecTime;
import hec.io.DSSIdentifier;
import hec.io.TimeSeriesContainer;
import hec.rss.client.WaterAccountPlotRowItem;
import hec.rss.model.Element;
import hec.rss.model.OpSet;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssRun;
import hec.rss.model.StorageZone;
import hec.rss.model.StorageZoneRef;
import hec.rss.model.WaterAccountSet;
import java.io.FileNotFoundException;
import java.rmi.RemoteException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.army.usace.hec.rmi.csinterface.DSSManager;

public class WaterAccountCurveDataReader {
    private final WaterAccountSet a;
    private final RssRun b;

    public WaterAccountCurveDataReader(RssRun rssRun) {
        this.a = rssRun.getAlternative().getWaterAccountSet();
        this.b = rssRun;
    }

    public TimeSeriesContainer a(String string) {
        TimeSeriesContainer timeSeriesContainer = new TimeSeriesContainer();
        HecTime hecTime = this.b.getRunTimeWindow().getStartTime();
        HecTime hecTime2 = this.b.getRunTimeWindow().getEndTime();
        DSSManager dSSManager = this.b.getDSSFileManager();
        DSSIdentifier dSSIdentifier = new DSSIdentifier(this.b.getDSSOutputFile(), string);
        dSSIdentifier.setTimeWindow(hecTime, hecTime2);
        try {
            timeSeriesContainer = dSSManager.readTS(dSSIdentifier, true);
        }
        catch (FileNotFoundException | RemoteException iOException) {
            Logger.getLogger(WaterAccountCurveDataReader.class.getName()).log(Level.WARNING, "Failed to retrieve time series container with dss path: " + string + " " + String.valueOf(iOException));
        }
        return timeSeriesContainer;
    }

    public TimeSeriesDataSet a(WaterAccountPlotRowItem object, int n) {
        int n2 = n;
        String string = ((WaterAccountPlotRowItem)object).c();
        object = this;
        String string2 = null;
        TSRecordProxy tSRecordProxy = ((WaterAccountCurveDataReader)object).a.getWaterAccounts().get(0).getActiveTSProxy(n2);
        if (tSRecordProxy != null) {
            object = ((WaterAccountCurveDataReader)object).b.getRegOutputTSData();
            if ((object = object.getTSRecord(tSRecordProxy.getName(), n2)) != null) {
                object = object.getDSSPathname();
                object = new DSSPathname((String)object);
                object.setBPart(string);
                string2 = object.toString();
            }
        }
        object = string2;
        object = this.a((String)object);
        return new TimeSeriesDataSet((TimeSeriesContainer)object);
    }

    public ReservoirElement a(int n) {
        StorageZoneRef storageZoneRef;
        List<StorageZoneRef> list = this.a.getResZoneRefs();
        if (list != null && (storageZoneRef = list.get(n)) != null) {
            int n2 = storageZoneRef.getReservoirIndex();
            return (ReservoirElement)this.b.getAlternative().getSystem().getElement(n2);
        }
        return null;
    }

    private OpSet d(int n) {
        ReservoirElement reservoirElement = this.a(n);
        if (reservoirElement != null) {
            int n2 = this.b.getAlternative().getResOpSetSelection(reservoirElement._index);
            return reservoirElement.getReservoirOp().getOperationSet(n2);
        }
        return null;
    }

    private TimeSeriesContainer a(StorageZone object, int n) {
        OpSet opSet = this.d(n);
        if (opSet != null) {
            opSet = ((StorageZone)object).getOpSet().getTSRecordProxy(opSet.getFullZoneName((StorageZone)object), 78);
            TSDataSet tSDataSet = this.b.getRegOutputTSData();
            opSet = tSDataSet.getTSRecord(opSet.getName(), 78);
            tSDataSet = this.b.getRunTimeWindow().getStartTime();
            Object object2 = this.b.getRunTimeWindow().getEndTime();
            DSSManager dSSManager = this.b.getDSSFileManager();
            opSet = new DSSIdentifier(this.b.getDSSOutputFile(), opSet.getDSSPathname());
            opSet.setTimeWindow((HecTime)tSDataSet, (HecTime)object2);
            try {
                return dSSManager.readTS((DSSIdentifier)opSet, true);
            }
            catch (FileNotFoundException | RemoteException iOException) {
                Logger logger = Logger.getLogger(WaterAccountCurveDataReader.class.getName());
                int n2 = n;
                StorageZone storageZone = object;
                object = this;
                object2 = "";
                object = ((WaterAccountCurveDataReader)object).a(n2);
                if (object != null) {
                    object2 = ((Element)object).getDisplayName();
                }
                object = storageZone.getDisplayName();
                logger.log(Level.WARNING, "Failed to retrieve time series container for " + ("Reservoir: " + (String)object2 + ", Zone: " + (String)object) + " " + String.valueOf(iOException));
            }
        }
        return null;
    }

    public TimeSeriesDataSet a(int n, int n2) {
        TimeSeriesContainer timeSeriesContainer = null;
        ReservoirElement reservoirElement = this.a(n);
        if (reservoirElement != null && (reservoirElement = reservoirElement.getStorageFunction().getTSRecordProxy(n2)) != null) {
            reservoirElement = this.b.getRegOutputTSData().getTSRecord(reservoirElement.getName(), n2);
            timeSeriesContainer = this.a(reservoirElement.getDSSPathname());
        }
        return new TimeSeriesDataSet(timeSeriesContainer);
    }

    public TimeSeriesDataSet b(int n) {
        Object object = new TimeSeriesContainer();
        OpSet opSet = this.d(n);
        if (opSet != null) {
            object = opSet.getGuideCurveZone();
            object = this.a((StorageZone)object, n);
            object = this.a((TimeSeriesContainer)object, n);
        }
        return new TimeSeriesDataSet(object);
    }

    private TimeSeriesContainer a(TimeSeriesContainer timeSeriesContainer, int n) {
        TimeSeriesContainer timeSeriesContainer2 = new TimeSeriesContainer();
        Object object = this.a(n);
        if (object == null) {
            return timeSeriesContainer2;
        }
        int n2 = this.a.getResZoneRefs().get(n).getZoneIndex();
        OpSet opSet = this.d(n);
        if (opSet != null) {
            object = ((ReservoirElement)object).getStorageZone(opSet.getIndex(), n2);
            TimeSeriesContainer timeSeriesContainer3 = this.a((StorageZone)object, n);
            if (timeSeriesContainer == null || timeSeriesContainer3 == null) {
                return timeSeriesContainer2;
            }
            timeSeriesContainer.clone(timeSeriesContainer2);
            object = new double[timeSeriesContainer.numberValues];
            for (n2 = 0; n2 < timeSeriesContainer.numberValues; ++n2) {
                double d = timeSeriesContainer.getValue(n2);
                double d2 = timeSeriesContainer3.getValue(n2);
                object[n2] = d - d2;
            }
            timeSeriesContainer2.setValues((double[])object);
        }
        return timeSeriesContainer2;
    }

    public TimeSeriesDataSet c(int n) {
        TimeSeriesDataSet timeSeriesDataSet = this.a(n, 11);
        return new TimeSeriesDataSet(this.a(timeSeriesDataSet._timeSeries, n));
    }

    public String a(String string, boolean bl) {
        if (bl) {
            return string + " - DEFAULT WATER ACCOUNT";
        }
        return this.a.getName() + " - " + string;
    }
}

