/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.TSRecordProxy;
import hec.data.DataSetIllegalArgumentException;
import hec.data.Parameter;
import hec.io.AsciiSerializable;
import hec.model.RunTimeWindow;
import hec.model.TSRecord;
import hec.rss.model.DownstreamOp;
import hec.rss.model.DownstreamOpRule;
import hec.rss.model.OpSet;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssModelVariableSet;
import hec.rss.model.RssReturnStatusConstants;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.StorageZoneRef;
import hec.rss.model.WaterAccount;
import hec.rss.model.YieldAnalysisRuleRef;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class WaterAccountSet
implements AsciiSerializable {
    private List<WaterAccount> _waterAccounts;
    private List<StorageZoneRef> _resZoneRefs = null;
    private String _name;
    private String _description;
    private int _index;
    private int _nextWaterAcountIndex = 0;
    private boolean _allAcctsUsePctOfCon;

    public WaterAccountSet() {
    }

    public boolean containsReservoirOpSet(int n, int n2) {
        for (int i = 0; i < this._resZoneRefs.size(); ++i) {
            StorageZoneRef storageZoneRef = this._resZoneRefs.get(i);
            if (storageZoneRef.getReservoirIndex() != n || storageZoneRef.getOpsetId() != n2) continue;
            return true;
        }
        return false;
    }

    public boolean containsReservoir(ReservoirElement reservoirElement) {
        if (this._resZoneRefs == null || this._waterAccounts == null) {
            return false;
        }
        for (int i = 0; i < this._resZoneRefs.size(); ++i) {
            StorageZoneRef storageZoneRef = this._resZoneRefs.get(i);
            if (!storageZoneRef.isActive() || storageZoneRef.getReservoirIndex() != reservoirElement.getIndex()) continue;
            for (int j = 0; j < this._waterAccounts.size(); ++j) {
                List<YieldAnalysisRuleRef> list = this._waterAccounts.get(j).getRuleRefs();
                if (list == null) continue;
                for (int k = 0; k < list.size(); ++k) {
                    RssReturnStatusConstants rssReturnStatusConstants = list.get(k);
                    if (((YieldAnalysisRuleRef)rssReturnStatusConstants).getRuleOwner() instanceof ReservoirElement) {
                        if ((rssReturnStatusConstants = (ReservoirElement)((YieldAnalysisRuleRef)rssReturnStatusConstants).getRuleOwner()).getIndex() != reservoirElement.getIndex()) continue;
                        return true;
                    }
                    if (!(((YieldAnalysisRuleRef)rssReturnStatusConstants).getRuleOwner() instanceof DownstreamOp) || !(((YieldAnalysisRuleRef)rssReturnStatusConstants).getRule() instanceof DownstreamOpRule)) continue;
                    ReservoirElement[] reservoirElementArray = ((DownstreamOpRule)((YieldAnalysisRuleRef)rssReturnStatusConstants).getRule()).e;
                    if (((DownstreamOpRule)((YieldAnalysisRuleRef)rssReturnStatusConstants).getRule()).e == null) {
                        return false;
                    }
                    for (int i2 = 0; i2 < reservoirElementArray.length; ++i2) {
                        rssReturnStatusConstants = reservoirElementArray[i2];
                        if (rssReturnStatusConstants.getIndex() != reservoirElement.getIndex()) continue;
                        return true;
                    }
                }
            }
            break;
        }
        return false;
    }

    public WaterAccountSet(String string, String string2, List<StorageZoneRef> list, int n) {
        this.setName(string);
        this.setDescription(string2);
        this._resZoneRefs = list;
        this._index = n;
        this._waterAccounts = new ArrayList<WaterAccount>();
    }

    public int getIndex() {
        return this._index;
    }

    public int getSize() {
        if (this._waterAccounts == null) {
            return 0;
        }
        return this._waterAccounts.size();
    }

    public int getSize(ReservoirElement object) {
        if ((object = this.getWaterAccounts((ReservoirElement)object)) == null) {
            return 0;
        }
        return object.size();
    }

    public void setName(String string) {
        this._name = string;
    }

    public String getName() {
        return this._name;
    }

    public void setDescription(String string) {
        this._description = string;
    }

    public String getDescription() {
        return this._description;
    }

    public void setResZoneRefs(List<StorageZoneRef> list) {
        this._resZoneRefs = list;
    }

    public List<StorageZoneRef> getResZoneRefs() {
        return this._resZoneRefs;
    }

    public boolean getAllAcctsUsePctOfCon() {
        return this._allAcctsUsePctOfCon;
    }

    public void setAllAcctsUsePctOfCon(boolean bl) {
        this._allAcctsUsePctOfCon = bl;
    }

    public boolean containsReservoirOpSet(StorageZoneRef storageZoneRef) {
        return this._resZoneRefs.contains(storageZoneRef);
    }

    public void setWaterAccounts(List<WaterAccount> list) {
        this._waterAccounts = list;
    }

    public List<WaterAccount> getWaterAccounts() {
        return this._waterAccounts;
    }

    public void addWaterAccount(WaterAccount waterAccount) {
        if (this._waterAccounts == null) {
            this._waterAccounts = new ArrayList<WaterAccount>();
        }
        if (this._waterAccounts != null && !this._waterAccounts.contains(waterAccount)) {
            this._waterAccounts.add(waterAccount);
        }
    }

    public List<WaterAccount> getWaterAccounts(ReservoirElement reservoirElement) {
        if (this._resZoneRefs == null || this._waterAccounts == null) {
            return null;
        }
        ArrayList<WaterAccount> arrayList = new ArrayList<WaterAccount>();
        for (int i = 0; i < this._resZoneRefs.size(); ++i) {
            Cloneable cloneable = this._resZoneRefs.get(i);
            if (!cloneable.isActive() || cloneable.getReservoirIndex() != reservoirElement.getIndex()) continue;
            for (i = 0; i < this._waterAccounts.size(); ++i) {
                cloneable = this._waterAccounts.get(i);
                List<YieldAnalysisRuleRef> list = ((WaterAccount)cloneable).getRuleRefs();
                if (list == null) continue;
                for (int j = 0; j < list.size(); ++j) {
                    RssReturnStatusConstants rssReturnStatusConstants = list.get(j);
                    if (((YieldAnalysisRuleRef)rssReturnStatusConstants).getRuleOwner() instanceof ReservoirElement) {
                        if ((rssReturnStatusConstants = (ReservoirElement)((YieldAnalysisRuleRef)rssReturnStatusConstants).getRuleOwner()) == null || rssReturnStatusConstants.getIndex() != reservoirElement.getIndex() || arrayList.contains(cloneable)) continue;
                        arrayList.add((WaterAccount)cloneable);
                        continue;
                    }
                    if (!(((YieldAnalysisRuleRef)rssReturnStatusConstants).getRuleOwner() instanceof DownstreamOp)) continue;
                    rssReturnStatusConstants = (DownstreamOpRule)((YieldAnalysisRuleRef)rssReturnStatusConstants).getRule();
                    ArrayList<ReservoirElement> arrayList2 = new ArrayList<ReservoirElement>();
                    ((DownstreamOpRule)rssReturnStatusConstants).getReservoirs(arrayList2);
                    for (int k = 0; k < arrayList2.size(); ++k) {
                        rssReturnStatusConstants = (ReservoirElement)arrayList2.get(k);
                        if (rssReturnStatusConstants == null || rssReturnStatusConstants.getIndex() != reservoirElement.getIndex() || arrayList.contains(cloneable)) continue;
                        arrayList.add((WaterAccount)cloneable);
                    }
                }
            }
            break;
        }
        return arrayList;
    }

    public WaterAccount createNewWaterAccount(String object, String string, int n) {
        object = new WaterAccount((String)object, string, n, this.nextWaterAccountIndex());
        this.addWaterAccount((WaterAccount)object);
        return object;
    }

    public void renameWaterAccount(String object, String string) {
        object = this.getWaterAccount((String)object);
        ((WaterAccount)object).setName(string);
    }

    public void deleteWaterAccount(WaterAccount waterAccount) {
        if ((waterAccount = this.getWaterAccount(waterAccount.getName())) == null) {
            return;
        }
        this._waterAccounts.remove(waterAccount);
    }

    public WaterAccount getWaterAccount(String string) {
        if (this._waterAccounts == null) {
            return null;
        }
        for (int i = 0; i < this._waterAccounts.size(); ++i) {
            WaterAccount waterAccount = this._waterAccounts.get(i);
            if (!waterAccount.getName().equals(string)) continue;
            return waterAccount;
        }
        return null;
    }

    public WaterAccount getWaterAccountSet(int n) {
        if (this._waterAccounts != null) {
            for (int i = 0; i < this._waterAccounts.size(); ++i) {
                WaterAccount waterAccount = this._waterAccounts.get(i);
                if (waterAccount.getIndex() != n) continue;
                return waterAccount;
            }
        }
        return null;
    }

    public int nextWaterAccountIndex() {
        int n = this._nextWaterAcountIndex++;
        return n;
    }

    public String toString() {
        return this._name;
    }

    public Object clone() {
        try {
            WaterAccountSet waterAccountSet = (WaterAccountSet)super.clone();
            waterAccountSet.setName(this._name);
            waterAccountSet.setDescription(this._description);
            if (this._waterAccounts != null) {
                for (int i = 0; i < this._waterAccounts.size(); ++i) {
                    waterAccountSet.addWaterAccount((WaterAccount)((RssTSLocationObject)this._waterAccounts.get(i)).clone());
                }
            }
            if (this._resZoneRefs != null) {
                for (int i = 0; i < this._resZoneRefs.size(); ++i) {
                    StorageZoneRef storageZoneRef = (StorageZoneRef)this._resZoneRefs.get(i).clone();
                    waterAccountSet._resZoneRefs.add(storageZoneRef);
                }
            }
            return waterAccountSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println(cloneNotSupportedException);
            return null;
        }
    }

    public Object getFieldObject(Field object) {
        try {
            object = ((Field)object).get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public void initialize(RssSystem rssSystem, RunTimeWindow object) {
        int n;
        List<WaterAccount> list = this.getWaterAccounts();
        for (n = 0; n < list.size(); ++n) {
            list.get(n).initialize();
        }
        if (rssSystem.getComputeElemBlockCounter() == 0) {
            n = 1;
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i).usePercentOfCon()) continue;
                n = 0;
                break;
            }
            this.setAllAcctsUsePctOfCon(n != 0);
            this.createDefaultWaterAccounts(rssSystem, (RunTimeWindow)object);
            return;
        }
        for (n = 0; n < this._resZoneRefs.size(); ++n) {
            ReservoirElement reservoirElement = (ReservoirElement)rssSystem.getElement(this._resZoneRefs.get(n).getReservoirIndex());
            object = reservoirElement.getDefaultWaterAccount();
            if (object == null) continue;
            ((WaterAccount)object).initializeDefault();
        }
    }

    private void createDefaultWaterAccounts(RssSystem rssSystem, RunTimeWindow runTimeWindow) {
        String string = "Default Water Account";
        for (int i = 0; i < this._resZoneRefs.size(); ++i) {
            Object object;
            Object object2;
            TSRecord tSRecord;
            Object object3;
            StorageZoneRef storageZoneRef = this._resZoneRefs.get(i);
            ReservoirElement reservoirElement = (ReservoirElement)rssSystem.getElement(storageZoneRef.getReservoirIndex());
            if (!this.containsReservoir(reservoirElement)) continue;
            Object object4 = reservoirElement.getName() + " - Default Water Account";
            object4 = new WaterAccount((String)object4, string, -1, -1);
            ((WaterAccount)object4).setDefaultFlag(true);
            ((WaterAccount)object4).setSystem(rssSystem);
            ((RssTSLocationObject)object4).clearTSProxyList();
            ((RssTSLocationObject)object4).updateTSProxyList();
            Vector vector = new Vector();
            ((WaterAccount)object4).getActiveTSProxies(vector, 0);
            for (int j = 0; j < vector.size(); ++j) {
                object3 = (TSRecordProxy)vector.elementAt(j);
                if (object3 == null || (tSRecord = rssSystem.getRssRun().getOutputTSData().createTSRecord(object3.getName(), object3.getVariableId(), object3.getParamName())) == null) continue;
                tSRecord.initialize(runTimeWindow);
                tSRecord.setDSSFilename(rssSystem.getRssRun().getDSSOutputFile());
                object2 = rssSystem.getRssRun().constructTSRecordProxyDssPath((TSRecordProxy)object3, "-REG");
                tSRecord.setDSSPathname((String)object2);
                if (runTimeWindow.isPerAvgTimeStep()) {
                    tSRecord.setUnitsType("PER-AVER");
                } else {
                    tSRecord.setUnitsType("INST-VAL");
                }
                int n = object3.getVariableId();
                try {
                    object = Parameter.getParameter((int)RssModelVariableSet.getModelVariable(n).getParamId()).getUnitsStringForSystem(rssSystem.getUnitSystem());
                    tSRecord.setUnits((String)object);
                    continue;
                }
                catch (DataSetIllegalArgumentException dataSetIllegalArgumentException) {
                    System.out.println((Object)dataSetIllegalArgumentException);
                }
            }
            ((WaterAccount)object4).initializeDefault();
            ArrayList<YieldAnalysisRuleRef> arrayList = new ArrayList<YieldAnalysisRuleRef>();
            object3 = reservoirElement.getReservoirOp().getOperationSet(storageZoneRef.getOpsetId());
            tSRecord = YieldAnalysisRuleRef.b(reservoirElement, (OpSet)object3);
            object2 = this.getWaterAccounts();
            for (int j = 0; j < tSRecord.size(); ++j) {
                object = (YieldAnalysisRuleRef)tSRecord.get(j);
                boolean bl = false;
                boolean bl2 = false;
                for (int k = 0; k < object2.size(); ++k) {
                    if (!((WaterAccount)object2.get(k)).usesReservoir(reservoirElement)) continue;
                    List<YieldAnalysisRuleRef> list = ((WaterAccount)object2.get(k)).getRuleRefs();
                    for (int i2 = 0; i2 < list.size(); ++i2) {
                        if (!list.get(i2).getRuleName().equals(((YieldAnalysisRuleRef)object).getRuleName()) || !list.get(i2).getLocationName().equals(((YieldAnalysisRuleRef)object).getLocationName())) continue;
                        bl = true;
                        bl2 = true;
                        break;
                    }
                    if (bl2) break;
                }
                if (bl) continue;
                arrayList.add((YieldAnalysisRuleRef)object);
            }
            ((WaterAccount)object4).setRuleRefs(arrayList);
            ((WaterAccount)object4).initializeRules(rssSystem);
            reservoirElement.setDefaultWaterAccount((WaterAccount)object4);
        }
    }
}

