/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.Manager;
import hec.clientapp.model.TSRecordProxy;
import hec.heclib.util.doubleArrayContainer;
import hec.lang.NamedType;
import hec.model.RunTimeStep;
import hec.rss.model.ContinuousIntakeControlDevice;
import hec.rss.model.Element;
import hec.rss.model.GatedIntakeControlDevice;
import hec.rss.model.OpController;
import hec.rss.model.OpRule;
import hec.rss.model.ReleaseFuncOpRule;
import hec.rss.model.ReservoirElement;
import hec.rss.model.ReservoirOp;
import hec.rss.model.RssAlt;
import hec.rss.model.RssRun;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.StorageZone;
import hec.rss.model.WaterControlDevice;
import hec.rss.model.WaterQualityOpReleaseType;
import hec.rss.plugins.waterquality.model.RssWQGeometry;
import hec.rss.wq.model.WQOpValue;
import hec.rss.wq.model.WQRun;
import hec.rss.wq.util.WqI18n;
import hec.wqenginecore.Constituent;
import hec.wqenginecore.WQEngineAdapter;
import hec.wqenginecore.WQException;
import hec.wqenginecore.geometry.SubDomain;
import hec.wqenginecore.geometry.WQControlDevice;
import hec.wqengineimpl.WQConstituent;
import hec.wqengineimpl.geometry.WQGeoSubDomain;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.army.usace.hec.metadata.UnitUtil;
import mil.army.usace.hec.metadata.UnitsConversionException;

public class WaterQualityOpRule
extends ReleaseFuncOpRule {
    public static final Logger logger = Logger.getLogger(WaterQualityOpRule.class.getName());
    private int _downstreamLocationID = -1;
    private String _constituentName = "";
    private WaterQualityOpReleaseType _releaseType = WaterQualityOpReleaseType.TOP_OF_POOL;
    private transient doubleArrayContainer a;
    private transient WQOpValue b;
    private transient RssWQGeometry c;
    private transient WQEngineAdapter d;
    private transient WQGeoSubDomain e;
    private transient WQControlDevice f;
    private transient WaterControlDevice j;
    private transient WQConstituent k;

    public WaterQualityOpRule() {
    }

    public WaterQualityOpRule(String string) {
        super(string);
    }

    public int getDownstreamControlLocationID() {
        return this._downstreamLocationID;
    }

    public void setDownstreamControlLocationID(int n) {
        if (n < -1) {
            n = -1;
        }
        this._downstreamLocationID = n;
    }

    public String getConstituentName() {
        return this._constituentName;
    }

    public void setConstituentName(String string) {
        this._constituentName = string;
    }

    public WaterQualityOpReleaseType getReleaseType() {
        return this._releaseType;
    }

    public void setReleaseType(WaterQualityOpReleaseType waterQualityOpReleaseType) {
        this._releaseType = waterQualityOpReleaseType;
    }

    @Override
    public boolean initializeCompute() {
        if (!super.initializeCompute()) {
            return false;
        }
        Object object = this.getNetwork();
        RssRun rssRun = ((RssSystem)object).getRssRun();
        Object object2 = this.getController();
        Cloneable cloneable = ((OpController)object2).getReservoirOp();
        cloneable = ((ReservoirOp)cloneable).getReservoirElement();
        if ((object = ((RssSystem)object).getWQRun()) == null) {
            object2 = WqI18n.a("WQOpRule.Init.MissingWQRun.Msg").format(new Object[]{this.getName(), cloneable.getName()});
            logger.log(Level.WARNING, (String)object2);
            rssRun.printWarningMessage((String)object2);
            return true;
        }
        this.c = ((WQRun)object).getRssWQGeometry();
        if (this.c == null) {
            object2 = WqI18n.a("WQOpRule.Init.MissingRSSGeom.Error").format(new Object[]{this.getName(), cloneable.getName()});
            logger.log(Level.SEVERE, (String)object2);
            rssRun.printErrorMessage((String)object2);
            return false;
        }
        this.k = ((WQRun)object).getWQConstituent(this._constituentName);
        if (this.k == null) {
            object2 = WqI18n.a("WQOpRule.Init.MissingConstit.Error").format(new Object[]{this._constituentName, this.getName(), cloneable.getName()});
            logger.log(Level.SEVERE, (String)object2);
            rssRun.printErrorMessage((String)object2);
            return false;
        }
        this.e = this.c.getWQSubdomain((Element)((Object)cloneable));
        if (this.e == null || !this.c.isInExtent((SubDomain)this.e)) {
            object2 = WqI18n.a("WQOpRule.Init.MissingRes.Msg").format(new Object[]{cloneable.getName(), this.getName()});
            logger.log(Level.WARNING, (String)object2);
            rssRun.printWarningMessage((String)object2);
            return true;
        }
        object2 = ((OpController)object2).getReleaseElement();
        this.j = ((Element)object2).getWaterControlDevice();
        if (this.j == null) {
            String string = WqI18n.a("WQOpRule.Init.MissingOutletDevice.Msg").format(new Object[]{this.getName(), cloneable.getName()});
            logger.log(Level.WARNING, string);
            rssRun.printWarningMessage(string);
            return false;
        }
        this.f = this.c.getWQControlDevice((Element)object2);
        if (this.f == null) {
            String string = WqI18n.a("WQOpRule.Init.MissingWQControlDevice.Error").format(new Object[]{this.j.getName(), cloneable.getName()});
            logger.log(Level.SEVERE, string);
            rssRun.printErrorMessage(string);
            return false;
        }
        if (this.j instanceof GatedIntakeControlDevice) {
            Object object3 = new ArrayList<StorageZone>();
            ArrayList<OpRule> arrayList = new ArrayList<OpRule>();
            RssAlt rssAlt = rssRun.getAlternative();
            int n = rssAlt.getResOpSetSelection(cloneable.getIndex());
            ((ReservoirElement)cloneable).getStorageZones(n, (List<StorageZone>)object3);
            object3 = object3.iterator();
            while (object3.hasNext()) {
                StorageZone storageZone = (StorageZone)object3.next();
                arrayList.clear();
                storageZone.getRules(arrayList);
                for (NamedType namedType : arrayList) {
                    if (namedType == this || !(namedType instanceof WaterQualityOpRule)) continue;
                    namedType = (WaterQualityOpRule)namedType;
                    namedType = namedType.getController();
                    if ((namedType = ((OpController)namedType).getReleaseElement()) == null || namedType.getIndex() != object2.getIndex()) continue;
                    object = WqI18n.a("WQOpRule.Init.MultipleWQGatedIntakeRules.Error").format(new Object[]{this.j.getName(), cloneable.getName()});
                    logger.log(Level.SEVERE, (String)object);
                    rssRun.printErrorMessage((String)object);
                    return false;
                }
            }
        }
        this.d = ((WQRun)object).getWQEngineAdapter();
        if (!(this.j instanceof ContinuousIntakeControlDevice)) {
            this.a = this.getTSContainer(210);
        }
        this.b = new WQOpValue();
        return true;
    }

    public void evaluateRule(RunTimeStep runTimeStep, int n) {
        if (this.getNetwork().getWQRun() == null) {
            return;
        }
        if (this.e == null || !this.c.isInExtent((SubDomain)this.e)) {
            return;
        }
        if (this.j instanceof ContinuousIntakeControlDevice) {
            this.evaluateRuleContinuousIntake(runTimeStep, n);
            return;
        }
        if (this.j instanceof GatedIntakeControlDevice) {
            this.evaluateRuleGatedIntake(runTimeStep, n);
        }
    }

    public void evaluateRuleContinuousIntake(RunTimeStep runTimeStep, int n) {
        double d;
        Manager manager = this.getNetwork();
        manager = manager.getRssRun();
        Object object = this.getController();
        Object object2 = ((OpController)object).getReservoirOp();
        ReservoirElement reservoirElement = ((ReservoirOp)object2).getReservoirElement();
        double d2 = ((OpController)object).getCurOpValue((RunTimeStep)runTimeStep).value;
        object = new double[]{d2};
        ((ReservoirOp)object2).setWQControlDeviceFlowRatios((double[])object, this, d2);
        double d3 = this.getWQCDOpElevation(runTimeStep, true);
        double d4 = this.getWQCDOpElevation(runTimeStep, false);
        double d5 = reservoirElement.getStorageFunction().getElevation(runTimeStep);
        object = this.e.getResLayerBoundaryElevs();
        double[] dArray = this.getLayerVals(reservoirElement, (RssRun)manager);
        object2 = dArray;
        if (dArray == null) {
            return;
        }
        double d6 = this.getWqTarget(runTimeStep, reservoirElement, (RssRun)manager);
        double d7 = this.findOpElevation((double[])object, (double[])object2, d6, d3, d4, d5, d2);
        boolean bl = this._releaseType == WaterQualityOpReleaseType.TOP_OF_POOL;
        boolean bl2 = this.testValsIncreasingUp((double[])object2);
        double d8 = switch (((OpRule)this).getRuleLimitType()) {
            case 0 -> {
                if (bl2) {
                    d = d7;
                    yield d4;
                }
                d = d3;
                yield d7;
            }
            case 2 -> {
                if (bl2) {
                    d = d3;
                    yield d7;
                }
                d = d7;
                yield d4;
            }
            case 1 -> {
                d = d7;
                yield d7;
            }
            default -> {
                d = d7;
                yield d7;
            }
        };
        this.b.b(d);
        this.b.c(d8);
        double d9 = bl ? d8 : d;
        this.b.a(d9);
        this.a.array[runTimeStep.step] = d9;
    }

    private double[] getLayerVals(ReservoirElement object, RssRun rssRun) {
        double[] dArray;
        try {
            dArray = this.d.getReservoirLayerWQResults((SubDomain)this.e, (Constituent)this.k);
        }
        catch (WQException wQException) {
            object = WqI18n.a("WQOpRule.EvalRule.LayerValues.Error").format(new Object[]{this.k.getDisplayName(), object.getName()});
            logger.log(Level.SEVERE, (String)object, wQException);
            rssRun.printErrorMessage((String)object);
            return null;
        }
        return dArray;
    }

    private double getWqTarget(RunTimeStep runTimeStep, ReservoirElement object, RssRun rssRun) {
        double d = this.getLimitValue(runTimeStep);
        if (this.getUnitSystem() == 1 && this.k.getId() == 1) {
            try {
                d = UnitUtil.convertUnits((double)d, (String)"F", (String)"C");
            }
            catch (UnitsConversionException unitsConversionException) {
                object = WqI18n.a("WQOpRule.EvalRule.TempConversion.Error").format(new Object[]{this.getName(), object.getName()});
                logger.log(Level.WARNING, (String)object, unitsConversionException);
                rssRun.printWarningMessage((String)object);
            }
        }
        return d;
    }

    public void evaluateRuleGatedIntake(RunTimeStep runTimeStep, int n) {
        double[] dArray;
        Object object = this.getNetwork();
        object = ((RssSystem)object).getRssRun();
        RssTSLocationObject rssTSLocationObject = this.getController();
        Object object2 = ((OpController)rssTSLocationObject).getReservoirOp();
        Object object3 = ((ReservoirOp)object2).getReservoirElement();
        double d = ((OpController)rssTSLocationObject).getCurOpValue((RunTimeStep)runTimeStep).value;
        rssTSLocationObject = (GatedIntakeControlDevice)this.j;
        int n2 = ((GatedIntakeControlDevice)rssTSLocationObject).getNumberOfPortLevels();
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n2];
        Object object4 = new double[n2];
        Arrays.fill(dArray2, 0.0);
        Arrays.fill(dArray3, d);
        Arrays.fill(object4, 0.0);
        double[] dArray4 = ((GatedIntakeControlDevice)rssTSLocationObject).getPortCenterlines();
        double d2 = ((ReservoirElement)object3).getStorageFunction().getElevation(runTimeStep);
        int n3 = -1;
        for (int i = 0; i < n2; ++i) {
            if (dArray4[i] > d2) {
                dArray3[i] = 0.0;
                continue;
            }
            n3 = i;
        }
        if (n3 == -1) {
            String string = WqI18n.a("WQOpRule.EvalRule.NoSubmergedPorts.Warning").format(new Object[]{this.j.getName(), object3.getName()});
            logger.log(Level.WARNING, string);
            object.printWarningMessage(string);
            ((ReservoirOp)object2).setWQControlDeviceFlowRatios((double[])object4, this, d);
            return;
        }
        double d3 = this.getWqTarget(runTimeStep, (ReservoirElement)object3, (RssRun)object);
        double[] cfr_ignored_0 = new double[n2];
        try {
            dArray2 = this.d.computeWQCDFlows((SubDomain)this.e, this.f, (Constituent)this.k, n2, dArray2, dArray3, d, d3);
        }
        catch (WQException wQException) {
            object4 = WqI18n.a("WQOpRule.EvalRule.LayerValues.Error").format(new Object[]{this.getName(), object3.getName()});
            logger.log(Level.SEVERE, (String)object4, wQException);
            object.printErrorMessage((String)object4);
            return;
        }
        dArray3 = this.getTopRelease(n2, n3, d);
        object4 = this.getBottomRelease(n2, d);
        boolean bl = this._releaseType == WaterQualityOpReleaseType.TOP_OF_POOL;
        double[] dArray5 = this.getLayerVals((ReservoirElement)object3, (RssRun)object);
        object = dArray5;
        if (dArray5 == null) {
            return;
        }
        boolean bl2 = this.testValsIncreasingUp((double[])object);
        switch (((OpRule)this).getRuleLimitType()) {
            case 0: {
                if (bl2) {
                    dArray = Arrays.copyOf(dArray2, n2);
                    object3 = Arrays.copyOf(dArray3, n2);
                    break;
                }
                dArray = Arrays.copyOf(object4, n2);
                object3 = Arrays.copyOf(dArray2, n2);
                break;
            }
            case 2: {
                if (bl2) {
                    dArray = Arrays.copyOf(object4, n2);
                    object3 = Arrays.copyOf(dArray2, n2);
                    break;
                }
                dArray = Arrays.copyOf(dArray2, n2);
                object3 = Arrays.copyOf(dArray3, n2);
                break;
            }
            case 1: {
                dArray = Arrays.copyOf(dArray2, n2);
                object3 = Arrays.copyOf(dArray2, n2);
                break;
            }
            default: {
                dArray = Arrays.copyOf(dArray2, n2);
                object3 = Arrays.copyOf(dArray2, n2);
            }
        }
        dArray2 = bl ? Arrays.copyOf((double[])object3, n2) : Arrays.copyOf(dArray, n2);
        ((ReservoirOp)object2).setWQControlDeviceFlowRatios(dArray2, this, d);
        for (int i = 0; i < n2; ++i) {
            object2 = ((GatedIntakeControlDevice)rssTSLocationObject).getDSSBpart(i + 1);
            object2 = rssTSLocationObject.getTSContainer((String)object2, 70);
            ((doubleArrayContainer)object2).array[runTimeStep.step] = dArray2[i];
        }
    }

    private double[] getTopRelease(int n, int n2, double d) {
        double[] dArray = new double[n];
        Arrays.fill(dArray, 0.0);
        dArray[n2] = d;
        return dArray;
    }

    private double[] getBottomRelease(int n, double d) {
        double[] dArray = new double[n];
        Arrays.fill(dArray, 0.0);
        dArray[0] = d;
        return dArray;
    }

    public WQOpValue getWQOpValue() {
        return this.b;
    }

    public void setWQControlDeviceElev(double d) {
        double[] dArray = new double[]{d};
        try {
            this.d.reallocateWQControlDeviceElevs((SubDomain)this.e, this.f, 1, dArray);
            return;
        }
        catch (WQException wQException) {
            ReservoirElement reservoirElement = this.getController().getReservoirOp().getReservoirElement();
            RssRun rssRun = this.getNetwork().getRssRun();
            String string = WqI18n.a("WQOpRule.EvalRule.ApplyRule.Error").format(new Object[]{this.getName(), reservoirElement.getName(), d});
            logger.log(Level.SEVERE, string, wQException);
            rssRun.printErrorMessage(string);
            return;
        }
    }

    private boolean testValsIncreasingUp(double[] dArray) {
        int n = dArray.length;
        if (n == 1) {
            return true;
        }
        return dArray[0] < dArray[n - 1];
    }

    private double findOpElevation(double[] dArray, double[] dArray2, double d, double d2, double d3, double d4, double d5) {
        double d6 = -3.4028234663852886E38;
        int n = this.findLayerForElevation(dArray, d4);
        if (n == 0) {
            d6 = 0.5 * (dArray[0] + dArray[1]);
        } else {
            int n2;
            ArrayList<Double> arrayList = new ArrayList<Double>();
            ArrayList<Double> arrayList2 = new ArrayList<Double>();
            arrayList.add(dArray[0]);
            arrayList2.add(dArray2[0]);
            for (n2 = 0; n2 <= n; ++n2) {
                double d7 = 0.5 * (dArray[n2] + dArray[n2 + 1]);
                arrayList.add(d7);
                try {
                    double d8 = this.d.getWQResultForReleaseAtElev((SubDomain)this.e, (Constituent)this.k, d5, d7);
                    if (n2 == n && Math.abs(d8) < 0.001) {
                        ArrayList<Double> arrayList3 = arrayList2;
                        d8 = (Double)arrayList3.get(arrayList3.size() - 1);
                    }
                    arrayList2.add(d8);
                    continue;
                }
                catch (WQException wQException) {
                    String string = WqI18n.a("WQOpRule.EvalRule.GetWQResult.Error").format(new Object[]{d7, this.k.getDisplayName()});
                    logger.log(Level.WARNING, string, wQException);
                    arrayList2.add(dArray2[n2]);
                }
            }
            if ((Double)arrayList.get(n) < d4) {
                arrayList.set(n, d4);
            } else {
                arrayList.add(d4);
                try {
                    double d9;
                    double d10 = this.d.getWQResultForReleaseAtElev((SubDomain)this.e, (Constituent)this.k, d5, d4);
                    if (Math.abs(d9) < 0.001) {
                        ArrayList<Double> arrayList4 = arrayList2;
                        d10 = (Double)arrayList4.get(arrayList4.size() - 1);
                    }
                    arrayList2.add(d10);
                }
                catch (WQException wQException) {
                    String string = WqI18n.a("WQOpRule.EvalRule.GetWQResult.Error").format(new Object[]{d4, this.k.getDisplayName()});
                    logger.log(Level.WARNING, string, wQException);
                    arrayList2.add(dArray2[n]);
                }
            }
            n2 = arrayList.size();
            if (d < (Double)arrayList2.get(0)) {
                d6 = (Double)arrayList.get(0);
            } else if (d > (Double)arrayList2.get(n2 - 1)) {
                d6 = d4;
            } else {
                for (int i = 0; i < n2 - 1; ++i) {
                    if (!(d > (Double)arrayList2.get(i)) || !(d <= (Double)arrayList2.get(i + 1))) continue;
                    d6 = (Double)arrayList.get(i) + (d - (Double)arrayList2.get(i)) * ((Double)arrayList.get(i + 1) - (Double)arrayList.get(i)) / ((Double)arrayList2.get(i + 1) - (Double)arrayList2.get(i));
                    break;
                }
            }
        }
        d6 = Math.min(Math.max(d6, d2), d3);
        return d6;
    }

    private int findLayerForElevation(double[] dArray, double d) {
        int n = dArray.length - 1;
        if (d < dArray[0]) {
            return 0;
        }
        if (d > dArray[n]) {
            return n - 1;
        }
        for (int i = 0; i < n; ++i) {
            if (!(d > dArray[i]) || !(d <= dArray[i + 1])) continue;
            return i;
        }
        return 0;
    }

    private double getWQCDOpElevation(RunTimeStep object, boolean bl) {
        ReservoirElement reservoirElement = this.getController().getReservoirOp().getReservoirElement();
        double d = RssWQGeometry.getReservoirMinElevation(reservoirElement);
        double d2 = reservoirElement.getStorageFunction().getElevation((RunTimeStep)object);
        if (this.j instanceof ContinuousIntakeControlDevice) {
            double d3;
            object = (ContinuousIntakeControlDevice)this.j;
            boolean bl2 = bl ? ((ContinuousIntakeControlDevice)object).useElevationForMaxIntake() : ((ContinuousIntakeControlDevice)object).useElevationForMinIntake();
            if (bl2) {
                d3 = bl ? ((ContinuousIntakeControlDevice)object).getMaxIntake() : ((ContinuousIntakeControlDevice)object).getMinIntake();
            } else {
                double d4 = bl ? ((ContinuousIntakeControlDevice)object).getMaxIntake() : ((ContinuousIntakeControlDevice)object).getMinIntake();
                d3 = d2 - d4;
            }
            String string = "";
            if (bl && d3 < d) {
                string = WqI18n.a("WQOpRule.EvalRule.HighIntake.Error").getText();
            } else if (!bl && d3 > d2) {
                string = WqI18n.a("WQOpRule.EvalRule.LowIntake.Error").getText();
            }
            if (!string.isEmpty()) {
                logger.log(Level.WARNING, string);
                this.getNetwork().printWarningMessage(string);
            }
            return Math.min(Math.max(d3, d), d2);
        }
        return Double.NaN;
    }

    public WaterControlDevice getWaterControlDevice() {
        return this.j;
    }

    @Override
    public Vector getActiveTSRecordProxies(Vector vector, int n) {
        TSRecordProxy tSRecordProxy;
        if (vector == null) {
            vector = new Vector();
        }
        vector = super.getActiveTSRecordProxies(vector, n);
        if (n == 0 && (tSRecordProxy = this.getTSRecordProxy(210)) != null && !vector.contains(tSRecordProxy)) {
            vector.addElement(tSRecordProxy);
        }
        return vector;
    }

    @Override
    public void updateTSProxyList() {
        super.updateTSProxyList();
        String string = this.getTSProxyName();
        TSRecordProxy tSRecordProxy = this.getTSRecordProxy(string, 210);
        if (tSRecordProxy == null) {
            this.addTSRecordProxy(string, 210);
        }
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }
}

