/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import hec.map.WorldLine;
import hec.map.WorldPt;

public class WorldLineCoordinateSequence
implements CoordinateSequence {
    private final GeometryFactory a;
    private final WorldLine b;

    public WorldLineCoordinateSequence(WorldLine worldLine, GeometryFactory geometryFactory) {
        this.b = worldLine;
        this.a = geometryFactory;
    }

    public int getDimension() {
        return 1;
    }

    public Coordinate getCoordinate(int n) {
        if (this.b.pts == null || this.b.pts.isEmpty() || this.b.pts.size() <= n) {
            return null;
        }
        WorldPt worldPt = (WorldPt)this.b.pts.get(n);
        worldPt = new Coordinate(worldPt.e, worldPt.n);
        return worldPt;
    }

    public Coordinate getCoordinateCopy(int n) {
        return this.getCoordinate(n);
    }

    public void getCoordinate(int n, Coordinate coordinate) {
        Coordinate coordinate2 = this.getCoordinate(n);
        if (coordinate2 != null) {
            coordinate.setCoordinate(coordinate2);
        }
    }

    public double getX(int n) {
        return ((WorldPt)this.b.pts.get((int)n)).e;
    }

    public double getY(int n) {
        return ((WorldPt)this.b.pts.get((int)n)).n;
    }

    public double getOrdinate(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.getX(n);
            }
            case 1: {
                return this.getY(n);
            }
        }
        return Double.NaN;
    }

    public int size() {
        if (this.b.pts != null) {
            return this.b.pts.size();
        }
        return 0;
    }

    public void setOrdinate(int n, int n2, double d) {
        switch (n2) {
            case 0: {
                ((WorldPt)this.b.pts.get((int)n)).e = d;
                return;
            }
            case 1: {
                ((WorldPt)this.b.pts.get((int)n)).n = d;
                return;
            }
        }
        throw new IllegalArgumentException("invalid ordinateIndex");
    }

    public Coordinate[] toCoordinateArray() {
        Coordinate[] coordinateArray = new Coordinate[this.size()];
        for (int i = 0; i < coordinateArray.length; ++i) {
            coordinateArray[i] = this.getCoordinate(i);
        }
        return coordinateArray;
    }

    public Envelope expandEnvelope(Envelope envelope) {
        for (int i = 0; i < this.b.pts.size(); ++i) {
            WorldPt worldPt = (WorldPt)this.b.pts.get(i);
            envelope.expandToInclude(worldPt.e, worldPt.n);
        }
        return envelope;
    }

    public Object clone() {
        return new WorldLineCoordinateSequence(this.b, this.a);
    }
}

