/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.io.DSSIdentifier;
import hec.lang.NamedType;
import hec.model.RunTimeWindow;
import hec.model.TSRecord;
import hec.rss.client.AdjustmentOptions;
import hec.rss.model.DownstreamOpRule;
import hec.rss.model.OpRule;
import hec.rss.model.OpSet;
import hec.rss.model.ReleaseFuncOpRule;
import hec.rss.model.ReservoirElement;
import hec.rss.model.ReservoirYieldAnalysis;
import hec.rss.model.ReverseReservoirYieldAnalysis;
import hec.rss.model.ReverseWaterAccountYieldAnalysis;
import hec.rss.model.RssAlt;
import hec.rss.model.RssReturnStatusConstants;
import hec.rss.model.RssRun;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.Rule;
import hec.rss.model.ScheduledHydropowerOpRule;
import hec.rss.model.Storage;
import hec.rss.model.StorageZone;
import hec.rss.model.StorageZoneRef;
import hec.rss.model.SystemHydropowerOpRule;
import hec.rss.model.WaterAccount;
import hec.rss.model.WaterAccountYieldAnalysis;
import hec.rss.model.YieldAnalysisData;
import hec.rss.model.YieldAnalysisRuleRef;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mil.army.usace.hec.metadata.constants.NumericalConstants;
import mil.army.usace.hec.rmi.csinterface.DSSManager;
import org.apache.commons.lang3.ArrayUtils;

public class YieldAnalysis
implements Cloneable {
    private List<YieldAnalysisRuleRef> a = new ArrayList<YieldAnalysisRuleRef>();
    private int b = 25;
    private boolean c = false;
    private boolean d = true;
    private int e = 8;
    public static final double STORAGE_EPSILON = 10.0;
    private YieldAnalysisData f = new YieldAnalysisData();
    List<Double[]> l;
    List<Double[]> m;
    List<Double[]> n;
    List<Double[]> o;
    List<Double[]> p;
    private double[] g;
    int[] q;
    private Map<YieldAnalysisRuleRef, List<Integer>> h;
    private List<Integer> i;
    private List<Integer> j;
    private int k = 1;
    private boolean r = false;
    private int s = 0;

    public int initializeCompute(RssRun object) {
        if (this.a == null || this.a.size() == 0) {
            object.printErrorMessage("Yield Analysis Error: Demand Rule not found.  Specify the Demand Rule in the Yield tab of the Alternative Editor");
            return 1;
        }
        this.initializeRuleRefs(((RssRun)object).getAlternative());
        object = this;
        this.s = 0;
        ((YieldAnalysis)object).r = false;
        if (object instanceof ReservoirYieldAnalysis) {
            ((YieldAnalysis)object).r = ((ReservoirYieldAnalysis)object).b();
            ((YieldAnalysis)object).s = ((ReservoirYieldAnalysis)object).a();
        } else if (object instanceof WaterAccountYieldAnalysis) {
            ((YieldAnalysis)object).r = ((WaterAccountYieldAnalysis)object).f();
            ((YieldAnalysis)object).s = ((WaterAccountYieldAnalysis)object).e();
        }
        ((YieldAnalysis)object).r = ((YieldAnalysis)object).r && ((YieldAnalysis)object).s > 0;
        this.initializeOutputArrays();
        this.setYieldAnalysisRuleUseDemandScale(true);
        return 0;
    }

    public void initializeRuleRefs(RssAlt rssAlt) {
        Object object = this.getYieldAnalysisRuleRefs();
        object = object.iterator();
        while (object.hasNext()) {
            YieldAnalysisRuleRef yieldAnalysisRuleRef = (YieldAnalysisRuleRef)object.next();
            yieldAnalysisRuleRef.initializeDataForCompute(rssAlt);
            if (!(yieldAnalysisRuleRef.getRule() instanceof SystemHydropowerOpRule)) continue;
            this.setUseHydropowerRules(true);
        }
    }

    public void initializeOutputArrays() {
        YieldAnalysisData yieldAnalysisData = this.getYieldAnalysisData();
        yieldAnalysisData.initializeOutputArrays(this.getMaxIterations());
        yieldAnalysisData.setStartScale(1, 1.0);
        if (this.r) {
            double d = 1.0 + (double)this.s / 100.0;
            double d2 = 1.0 - (double)this.s / 100.0;
            yieldAnalysisData.setUpperScale(1, d);
            yieldAnalysisData.setLowerScale(1, d2);
            yieldAnalysisData.setIsBracketed(1, true);
            return;
        }
        yieldAnalysisData.setUpperScale(1, 1.0);
        yieldAnalysisData.setLowerScale(1, 0.0);
        yieldAnalysisData.setIsBracketed(1, false);
    }

    public YieldAnalysisData getYieldAnalysisData() {
        if (this.f == null) {
            this.f = new YieldAnalysisData();
        }
        return this.f;
    }

    public WaterAccount getWaterAccount(RssAlt object) {
        WaterAccountYieldAnalysis waterAccountYieldAnalysis = ((RssAlt)object).getWaterAccountYieldAnalysis();
        WaterAccount waterAccount = waterAccountYieldAnalysis.d();
        if (waterAccount == null) {
            int n = waterAccountYieldAnalysis.c();
            object = ((RssAlt)object).getWaterAccountSet().getWaterAccounts();
            for (int i = 0; i < object.size(); ++i) {
                if (n != ((WaterAccount)object.get(i)).getIndex()) continue;
                waterAccount = (WaterAccount)object.get(i);
                break;
            }
        }
        return waterAccount;
    }

    public int loadData(RssRun rssRun, int n) {
        Object object = rssRun.getRunTimeWindow();
        YieldAnalysisData yieldAnalysisData = this.getYieldAnalysisData();
        this.l = new ArrayList<Double[]>();
        this.m = new ArrayList<Double[]>();
        this.n = new ArrayList<Double[]>();
        this.p = new ArrayList<Double[]>();
        this.o = new ArrayList<Double[]>();
        this.h = new HashMap<YieldAnalysisRuleRef, List<Integer>>();
        this.i = new ArrayList<Integer>();
        this.j = new ArrayList<Integer>();
        for (YieldAnalysisRuleRef yieldAnalysisRuleRef : this.a) {
            Object object2;
            Object object3;
            OpRule opRule = (OpRule)yieldAnalysisRuleRef.getRule();
            try {
                object3 = YieldAnalysis.getOpRuleLimitTS(rssRun, opRule, object);
                object2 = YieldAnalysis.getOpRuleResultTS(rssRun, opRule, object);
                this.l.add(ArrayUtils.toObject((double[])object3));
                this.m.add(ArrayUtils.toObject((double[])object2));
            }
            catch (FileNotFoundException | RemoteException iOException) {
                RssSystem rssSystem = ((RssTSLocationObject)opRule).getSystem();
                rssSystem.printErrorMessage(iOException.getMessage());
                rssSystem.printLogMessage(iOException.getMessage());
                yieldAnalysisData.setDecision(n, -21);
                return -21;
            }
            this.j.add(opRule.getIndex());
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (StorageZoneRef storageZoneRef : yieldAnalysisRuleRef.getZones()) {
                object3 = storageZoneRef;
                Object object4 = storageZoneRef.getStorageZone();
                ReservoirElement reservoirElement = ((StorageZone)object4).getReservoirElement();
                int n2 = reservoirElement.getIndex();
                arrayList.add(n2);
                if (this.i.contains(n2)) continue;
                OpSet opSet = reservoirElement.getReservoirOp().getActiveOpSet();
                object3 = opSet;
                object2 = opSet.getGuideCurveZone();
                try {
                    object3 = YieldAnalysis.getResPoolStorTS(rssRun, reservoirElement, object);
                    object2 = YieldAnalysis.getResZoneStorTS(rssRun, (StorageZone)object2, object);
                    object4 = YieldAnalysis.getResZoneStorTS(rssRun, (StorageZone)object4, object);
                    this.q = YieldAnalysis.getSimulationTimeArray(rssRun, reservoirElement, object);
                }
                catch (FileNotFoundException | RemoteException iOException) {
                    object = ((RssTSLocationObject)opRule).getSystem();
                    object.printErrorMessage(iOException.getMessage());
                    object.printLogMessage(iOException.getMessage());
                    yieldAnalysisData.setDecision(n, -21);
                    return -21;
                }
                this.n.add(ArrayUtils.toObject((double[])object3));
                this.p.add(ArrayUtils.toObject((double[])object2));
                this.o.add(ArrayUtils.toObject((double[])object4));
                this.i.add(n2);
            }
            this.h.put(yieldAnalysisRuleRef, arrayList);
        }
        this.setNumRoutingSteps();
        return 0;
    }

    public int loadWaterAccountData(RssRun manager, WaterAccount waterAccount, int n) {
        RunTimeWindow runTimeWindow = manager.getRunTimeWindow();
        YieldAnalysisData yieldAnalysisData = this.getYieldAnalysisData();
        this.l = new ArrayList<Double[]>();
        this.m = new ArrayList<Double[]>();
        this.n = new ArrayList<Double[]>();
        this.p = new ArrayList<Double[]>();
        try {
            Object object = YieldAnalysis.getWARuleLimitTS(manager, waterAccount, runTimeWindow);
            this.l.add(ArrayUtils.toObject((double[])object));
            object = YieldAnalysis.getWARuleResultTS(manager, waterAccount, runTimeWindow);
            this.m.add(ArrayUtils.toObject((double[])object));
            object = (OpRule)waterAccount.getRuleRefs().get(0).getRule();
            this.g = YieldAnalysis.getOpRuleResultTS(manager, (OpRule)object, runTimeWindow);
            object = YieldAnalysis.getWAStorTS(manager, waterAccount, runTimeWindow);
            this.n.add(ArrayUtils.toObject((double[])object));
            object = YieldAnalysis.getWAMaxStorTS(manager, waterAccount, runTimeWindow);
            this.p.add(ArrayUtils.toObject((double[])object));
            this.q = YieldAnalysis.getWASimulationTimeArray(manager, waterAccount, runTimeWindow);
        }
        catch (FileNotFoundException | RemoteException iOException) {
            manager = ((RssTSLocationObject)waterAccount).getSystem();
            manager.printErrorMessage(iOException.getMessage());
            manager.printLogMessage(iOException.getMessage());
            yieldAnalysisData.setDecision(n, -21);
            return -21;
        }
        this.setNumRoutingSteps(waterAccount);
        return 0;
    }

    public void setNumRoutingSteps(WaterAccount object) {
        this.k = 1;
        for (YieldAnalysisRuleRef yieldAnalysisRuleRef : ((WaterAccount)object).getRuleRefs()) {
            OpRule opRule = (OpRule)yieldAnalysisRuleRef.getRule();
            if (!(yieldAnalysisRuleRef.getRule() instanceof DownstreamOpRule)) continue;
            this.k = Math.max(this.k, ((DownstreamOpRule)opRule).getNumRouteSteps());
        }
    }

    public void setNumRoutingSteps() {
        this.k = 1;
        for (YieldAnalysisRuleRef yieldAnalysisRuleRef : this.a) {
            OpRule opRule = (OpRule)yieldAnalysisRuleRef.getRule();
            if (!(yieldAnalysisRuleRef.getRule() instanceof DownstreamOpRule)) continue;
            this.k = Math.max(this.k, ((DownstreamOpRule)opRule).getNumRouteSteps());
        }
    }

    public void setNumRoutingSteps(List<OpRule> object) {
        this.k = 1;
        object = object.iterator();
        while (object.hasNext()) {
            OpRule opRule = (OpRule)object.next();
            if (!(opRule instanceof DownstreamOpRule)) continue;
            this.k = Math.max(this.k, ((DownstreamOpRule)opRule).getNumRouteSteps());
        }
    }

    public void setNumLagSteps(StorageZoneRef storageZoneRef) {
        for (RssReturnStatusConstants rssReturnStatusConstants : this.a) {
            if (!(rssReturnStatusConstants.getRule() instanceof DownstreamOpRule)) continue;
            NamedType namedType = storageZoneRef.getStorageZone();
            namedType = namedType.getReservoirElement();
            rssReturnStatusConstants = (DownstreamOpRule)rssReturnStatusConstants.getRule();
            int n = -1;
            for (int i = 0; i < ((DownstreamOpRule)rssReturnStatusConstants).e.length; ++i) {
                if (((DownstreamOpRule)rssReturnStatusConstants).e[i] != namedType) continue;
                n = i;
                break;
            }
            Math.round((float)((DownstreamOpRule)rssReturnStatusConstants).f[n]);
        }
    }

    public int testRule(RssRun rssRun, YieldAnalysisRuleRef yieldAnalysisRuleRef, int n) {
        YieldAnalysisData yieldAnalysisData = this.getYieldAnalysisData();
        double d = yieldAnalysisRuleRef.getTolerance();
        RunTimeWindow runTimeWindow = rssRun.getRunTimeWindow();
        int n2 = 0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = -1.7976931348623157E308;
        int n3 = this.j.indexOf(yieldAnalysisRuleRef.getRule().getIndex());
        double[] dArray = ArrayUtils.toPrimitive((Double[])this.m.get(n3));
        double[] dArray2 = ArrayUtils.toPrimitive((Double[])this.l.get(n3));
        double d7 = this.d(rssRun);
        for (int i = this.k; i < dArray.length; ++i) {
            double d8;
            if ((dArray2[i] - dArray[i]) * d7 > d) {
                ++n2;
            }
            double d9 = this.a(yieldAnalysisRuleRef, i);
            double d10 = this.b(yieldAnalysisRuleRef, i);
            if (d8 - d9 < 10.0) {
                d3 = 0.0;
                d2 = 0.0;
            }
            d3 += dArray2[i] * d7 * (double)runTimeWindow.getTimeStepSeconds() / Storage.DSDT_TO_Q;
            double d11 = Math.max((dArray2[i] - dArray[i]) * d7, 0.0);
            d4 = Math.max(d4, d11);
            d5 = Math.max(d5, d2 += d11 * (double)runTimeWindow.getTimeStepSeconds() / Storage.DSDT_TO_Q);
            if (!(d3 > 0.0)) continue;
            d6 = Math.max(d6, d2 / d3);
        }
        double d12 = yieldAnalysisData.getHeuristicRatioDecr(n);
        double d13 = 1.0 - d6;
        double d14 = yieldAnalysisData.getLimitingRuleTol(n);
        if (NumericalConstants.isNotValidValue((double)d14) || d13 < d12) {
            yieldAnalysisData.setMaxDemandShortage(n, d4);
            yieldAnalysisData.setAccumDemandShortage(n, d5);
            yieldAnalysisData.setHeuristicRatioDecr(n, d13);
            yieldAnalysisData.setLimitingRuleTol(n, d);
        }
        boolean bl = yieldAnalysisData.getRuleTest(n);
        boolean bl2 = n2 == 0;
        yieldAnalysisData.setRuleTest(n, bl && bl2);
        if (n2 > 0) {
            return 24;
        }
        return 25;
    }

    final double d(RssRun rssRun) {
        double d = 1.0;
        if (this.useHydropowerRules()) {
            double d2 = rssRun.getRunTimeWindow().getTimeStepMinutes();
            d = 1.0 / (d2 / 60.0);
        }
        return d;
    }

    public int testWaterAccountRule(RssRun rssRun, int n) {
        YieldAnalysisData yieldAnalysisData = this.getYieldAnalysisData();
        Object object = this;
        object = ((YieldAnalysis)object).getYieldAnalysisRuleRefs();
        double d = -3.4028234663852886E38;
        if ((object = object.iterator()).hasNext()) {
            object = (YieldAnalysisRuleRef)object.next();
            d = ((YieldAnalysisRuleRef)object).getTolerance();
        }
        double d2 = d;
        yieldAnalysisData.setLimitingRuleTol(n, d2);
        RunTimeWindow runTimeWindow = rssRun.getRunTimeWindow();
        int n2 = 0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = -1.7976931348623157E308;
        double[] dArray = ArrayUtils.toPrimitive((Double[])this.m.get(0));
        double[] dArray2 = ArrayUtils.toPrimitive((Double[])this.l.get(0));
        double[] dArray3 = ArrayUtils.toPrimitive((Double[])this.n.get(0));
        double[] dArray4 = ArrayUtils.toPrimitive((Double[])this.p.get(0));
        double d8 = this.d(rssRun);
        for (int i = this.k; i < dArray.length; ++i) {
            if (NumericalConstants.isNotValidValue((double)dArray3[i])) continue;
            if ((dArray2[i] - dArray[i]) * d8 > d2) {
                ++n2;
            }
            if (dArray4[i] - dArray3[i] < 10.0) {
                d4 = 0.0;
                d3 = 0.0;
            }
            d4 += this.g[i] * d8 * (double)runTimeWindow.getTimeStepSeconds() / Storage.DSDT_TO_Q;
            double d9 = Math.max((dArray2[i] - dArray[i]) * d8, 0.0);
            d5 = Math.max(d5, d9);
            d6 = Math.max(d6, d3 += d9 * (double)runTimeWindow.getTimeStepSeconds() / Storage.DSDT_TO_Q);
            if (!(d4 > 0.0)) continue;
            d7 = Math.max(d7, d3 / d4);
        }
        yieldAnalysisData.setMaxDemandShortage(n, d5);
        yieldAnalysisData.setAccumDemandShortage(n, d6);
        yieldAnalysisData.setHeuristicRatioDecr(n, 1.0 - d7);
        if (n2 > 0) {
            yieldAnalysisData.setRuleTest(n, false);
            return 24;
        }
        yieldAnalysisData.setRuleTest(n, true);
        return 25;
    }

    private double a(YieldAnalysisRuleRef iterator, int n) {
        iterator = this.h.get(iterator);
        double d = 0.0;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            n2 = this.i.indexOf(n2);
            d += this.n.get(n2)[n].doubleValue();
        }
        return d;
    }

    private double b(YieldAnalysisRuleRef iterator, int n) {
        iterator = this.h.get(iterator);
        double d = 0.0;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            n2 = this.i.indexOf(n2);
            d += this.p.get(n2)[n].doubleValue();
        }
        return d;
    }

    public int testStorage(RssRun rssRun, YieldAnalysisRuleRef yieldAnalysisRuleRef, int n) {
        int n22;
        int n3 = 0;
        int n4 = 0;
        double d = Double.MAX_VALUE;
        double d2 = 0.0;
        double d3 = Double.MAX_VALUE;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        boolean bl = false;
        List<Integer> list = this.h.get(yieldAnalysisRuleRef);
        int n9 = this.j.indexOf(yieldAnalysisRuleRef.getRule().getIndex());
        double[] dArray = ArrayUtils.toPrimitive((Double[])this.l.get(n9));
        RunTimeWindow runTimeWindow = rssRun.getRunTimeWindow();
        int n10 = this.n.get(0).length;
        double d4 = yieldAnalysisRuleRef.getResTolerance(list.get(0));
        double d5 = Double.MAX_VALUE;
        double d6 = Double.MAX_VALUE;
        double d7 = this.d(rssRun);
        for (int i = this.k; i < n10; ++i) {
            double d8;
            double d9;
            double d10;
            int n11;
            for (int n22 : list) {
                n11 = this.i.indexOf(n22);
                if (!(this.n.get(n11)[i] < this.o.get(n11)[i] - 10.0)) continue;
                ++n3;
            }
            n11 = this.i.indexOf(list.get(0));
            d5 = Math.min(d5, this.o.get(n11)[i]);
            d6 = Math.min(d6, this.n.get(n11)[i]);
            for (int n22 : list) {
                n11 = this.i.indexOf(n22);
                if (!(this.n.get(n11)[i] <= this.o.get(n11)[i] + yieldAnalysisRuleRef.getResTolerance(n22))) continue;
                ++n4;
                d4 = yieldAnalysisRuleRef.getResTolerance(n22);
                d5 = Math.min(d5, this.o.get(n11)[i]);
                d6 = Math.min(d6, this.n.get(n11)[i]);
            }
            double d11 = this.a(yieldAnalysisRuleRef, i);
            double d12 = this.b(yieldAnalysisRuleRef, i);
            double d13 = d12 - d11;
            if (d10 < 10.0) {
                double d14;
                n5 = this.q[i];
                d9 = this.b(yieldAnalysisRuleRef, i - 1) - this.a(yieldAnalysisRuleRef, i - 1);
                if (d14 >= 10.0 && bl) {
                    n8 = this.q[i - 1];
                    bl = false;
                }
                d2 = 0.0;
            }
            if (d11 < d) {
                d = d11;
                n7 = this.q[i];
                n6 = n5;
                bl = true;
            }
            int n12 = i;
            Iterator iterator = yieldAnalysisRuleRef;
            YieldAnalysis yieldAnalysis = this;
            iterator = yieldAnalysis.h.get(iterator);
            double d15 = 0.0;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                int n13 = (Integer)iterator.next();
                n13 = yieldAnalysis.i.indexOf(n13);
                d15 += yieldAnalysis.o.get(n13)[n12].doubleValue();
            }
            d9 = d11 - d15;
            d2 += dArray[i] * d7 * (double)runTimeWindow.getTimeStepSeconds() / Storage.DSDT_TO_Q;
            if (!(d8 > 0.0)) continue;
            d3 = Math.min(d3, d9 / d2);
        }
        YieldAnalysisData yieldAnalysisData = this.getYieldAnalysisData();
        n22 = yieldAnalysisData.getStorageTest(n);
        boolean bl2 = n3 > 0;
        yieldAnalysisData.setStorageTest(n, n22 != 0 && bl2);
        boolean bl3 = yieldAnalysisData.getStorageTolTest(n);
        boolean bl4 = n4 > 0;
        yieldAnalysisData.setStorageTolTest(n, bl3 && bl4);
        if (n8 < n6) {
            n8 = this.q[n10 - 1];
        }
        double d16 = yieldAnalysisData.getHeuristicRatioIncr(n);
        double d17 = d3 + 1.0;
        double d18 = yieldAnalysisData.getMinStorage(n);
        if (NumericalConstants.isNotValidValue((double)d18) || d17 < d16) {
            yieldAnalysisData.setMinStorage(n, d6);
            yieldAnalysisData.setLowerLimitStor(d5);
            yieldAnalysisData.setLowerLimitStorTol(d5 + d4);
            yieldAnalysisData.setStartCritPeriod(n, n6);
            yieldAnalysisData.setMinCritPeriod(n, n7);
            yieldAnalysisData.setEndCritPeriod(n, n8);
            yieldAnalysisData.setHeuristicRatioIncr(n, d17);
        }
        if (bl2) {
            return 22;
        }
        if (bl4) {
            return 23;
        }
        return 21;
    }

    public int testWaterAccountStorage(RssRun rssRun, int n, double d) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = Double.MAX_VALUE;
        double d5 = 0.0;
        double d6 = Double.MAX_VALUE;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        boolean bl = false;
        ArrayUtils.toPrimitive((Double[])this.l.get(0));
        double[] dArray = ArrayUtils.toPrimitive((Double[])this.n.get(0));
        double[] dArray2 = ArrayUtils.toPrimitive((Double[])this.p.get(0));
        RunTimeWindow runTimeWindow = rssRun.getRunTimeWindow();
        double d7 = this.d(rssRun);
        int n9 = dArray.length;
        for (int i = this.k; i < n9; ++i) {
            double d8;
            if (NumericalConstants.isNotValidValue((double)dArray[i])) continue;
            if (dArray[i] < -10.0) {
                ++n2;
            }
            if (dArray[i] <= d) {
                ++n3;
            }
            d2 += dArray[i];
            d3 += dArray2[i];
            ++n4;
            if (dArray2[i] - dArray[i] < 10.0) {
                double d9;
                n5 = this.q[i];
                double d10 = dArray2[i - 1] - dArray[i - 1];
                if (d9 >= 10.0 && bl) {
                    n8 = this.q[i - 1];
                    bl = false;
                }
                d5 = 0.0;
            }
            if (dArray[i] < d4) {
                d4 = dArray[i];
                n7 = this.q[i];
                n6 = n5;
                bl = true;
            }
            d5 += this.g[i] * d7 * (double)runTimeWindow.getTimeStepSeconds() / Storage.DSDT_TO_Q;
            if (!(d8 > 0.0)) continue;
            d6 = Math.min(d6, dArray[i] / d5);
        }
        YieldAnalysisData yieldAnalysisData = this.getYieldAnalysisData();
        yieldAnalysisData.setAvgSimStorage(n, d2 / (double)n4);
        yieldAnalysisData.setAvgConPoolStorage(n, d3 / (double)n4);
        yieldAnalysisData.setStorageTest(n, n2 > 0);
        yieldAnalysisData.setStorageTolTest(n, n3 > 0);
        if (n8 < n6) {
            n8 = this.q[n9 - 1];
        }
        yieldAnalysisData.setMinStorage(n, d4);
        yieldAnalysisData.setStartCritPeriod(n, n6);
        yieldAnalysisData.setMinCritPeriod(n, n7);
        yieldAnalysisData.setEndCritPeriod(n, n8);
        yieldAnalysisData.setHeuristicRatioIncr(n, d6 + 1.0);
        if (n2 > 0) {
            if (this instanceof ReverseWaterAccountYieldAnalysis) {
                return 21;
            }
            return 22;
        }
        if (n3 > 0) {
            return 23;
        }
        if (this instanceof ReverseWaterAccountYieldAnalysis) {
            return 22;
        }
        return 21;
    }

    public void calcAvgStartingRuleDemand(RssRun rssRun) {
        int n = 0;
        double d = 0.0;
        double[] dArray = ArrayUtils.toPrimitive((Double[])this.l.get(0));
        for (int i = 0; i < dArray.length; ++i) {
            if (!NumericalConstants.isValidValue((double)dArray[i])) continue;
            ++n;
            d += dArray[i];
        }
        if (n != 0) {
            d /= (double)n;
        }
        if (this.useHydropowerRules()) {
            d /= (double)rssRun.getRunTimeWindow().getTimeStepMinutes() / 60.0;
        }
        YieldAnalysisData yieldAnalysisData = this.getYieldAnalysisData();
        yieldAnalysisData.setAvgStartingRuleDemand(d);
    }

    public int getUseBisectionAfterIts(RssRun rssRun) {
        int n = this.useBisectionOnly() ? 0 : this.getMaxHeuristicIterations();
        if (this.useHydropowerRules() && n > 0) {
            rssRun.printWarningMessage("Yield Analysis on Hydropower Rules only supported for Bisection Convergence Method");
            n = 0;
        }
        return n;
    }

    public boolean makeDecisionUseBisection(int n, int n2) {
        YieldAnalysisData yieldAnalysisData = this.getYieldAnalysisData();
        if (n > n2 || yieldAnalysisData.getUseBisection(n - 1)) {
            n2 = 1;
            yieldAnalysisData.setUseBisection(n, true);
        } else {
            n2 = 0;
            yieldAnalysisData.setUseBisection(n, false);
        }
        return n2 != 0;
    }

    public void setYieldAnalysisRuleUseDemandScale(boolean bl) {
        for (RssReturnStatusConstants rssReturnStatusConstants : this.a) {
            if ((rssReturnStatusConstants = rssReturnStatusConstants.getRule()) instanceof OpRule) {
                ((OpRule)rssReturnStatusConstants).setUseDemandScale(bl);
                continue;
            }
            if (!(rssReturnStatusConstants instanceof Rule)) continue;
            ((Rule)rssReturnStatusConstants).setUseDemandScale(bl);
        }
    }

    public void setYieldAnalysisRuleDemandScale(double d) {
        for (RssReturnStatusConstants rssReturnStatusConstants : this.a) {
            if ((rssReturnStatusConstants = rssReturnStatusConstants.getRule()) instanceof OpRule) {
                ((OpRule)rssReturnStatusConstants).setDemandScale(d);
                continue;
            }
            if (!(rssReturnStatusConstants instanceof Rule)) continue;
            ((Rule)rssReturnStatusConstants).setDemandScale(d);
        }
    }

    public void updateByDemandScale(double d) {
        for (RssReturnStatusConstants rssReturnStatusConstants : this.a) {
            if ((rssReturnStatusConstants = rssReturnStatusConstants.getRule()) instanceof OpRule) {
                ((OpRule)rssReturnStatusConstants).updateByDemandScale(d);
                continue;
            }
            if (!(rssReturnStatusConstants instanceof Rule)) continue;
            ((Rule)rssReturnStatusConstants).updateByDemandScale(d);
        }
    }

    public void setNextBisectionScaleBracketed(int n) {
        AdjustmentOptions adjustmentOptions;
        YieldAnalysisData yieldAnalysisData = this.getYieldAnalysisData();
        int n2 = n + 1;
        yieldAnalysisData.setIsBracketed(n2, true);
        int n3 = yieldAnalysisData.getDecision(n);
        int n4 = n3 = n3 == 21 ? 1 : 0;
        if (this instanceof ReverseReservoirYieldAnalysis && !(adjustmentOptions = ((ReverseReservoirYieldAnalysis)this).a()).g()) {
            int n5 = n3 = n3 == 0 ? 1 : 0;
        }
        if (n3 != 0) {
            yieldAnalysisData.setLowerScale(n2, yieldAnalysisData.getStartScale(n));
            yieldAnalysisData.setUpperScale(n2, yieldAnalysisData.getUpperScale(n));
        } else {
            yieldAnalysisData.setLowerScale(n2, yieldAnalysisData.getLowerScale(n));
            yieldAnalysisData.setUpperScale(n2, yieldAnalysisData.getStartScale(n));
        }
        double d = 0.5 * (yieldAnalysisData.getLowerScale(n2) + yieldAnalysisData.getUpperScale(n2));
        if (this.r && n == 1) {
            d = n3 != 0 ? yieldAnalysisData.getUpperScale(n) : yieldAnalysisData.getLowerScale(n);
        }
        yieldAnalysisData.setEndScale(n, d);
        yieldAnalysisData.setStartScale(n2, d);
        yieldAnalysisData.setHeuristicRatioIncr(n, -3.4028234663852886E38);
        yieldAnalysisData.setHeuristicRatioDecr(n, -3.4028234663852886E38);
    }

    public void setNextBisectionScaleNotBracketed(int n) {
        YieldAnalysisData yieldAnalysisData = this.getYieldAnalysisData();
        int n2 = n + 1;
        int n3 = yieldAnalysisData.getDecision(n);
        if (n3 == 21) {
            double d = yieldAnalysisData.getStartScale(n);
            double d2 = d * 2.0;
            yieldAnalysisData.setLowerScale(n2, d);
            yieldAnalysisData.setUpperScale(n2, d2);
            yieldAnalysisData.setEndScale(n, d2);
            yieldAnalysisData.setStartScale(n2, d2);
            yieldAnalysisData.setIsBracketed(n2, false);
        } else {
            this.setNextBisectionScaleBracketed(n);
        }
        yieldAnalysisData.setHeuristicRatioIncr(n, -3.4028234663852886E38);
        yieldAnalysisData.setHeuristicRatioDecr(n, -3.4028234663852886E38);
    }

    public void setNextHeuristicsScaleWA(int n) {
        double d;
        YieldAnalysisData yieldAnalysisData = this.getYieldAnalysisData();
        int n2 = n + 1;
        double d2 = yieldAnalysisData.getStartScale(n);
        int n3 = yieldAnalysisData.getDecision(n);
        if (n3 == 21) {
            d = d2 * yieldAnalysisData.getHeuristicRatioIncr(n);
            yieldAnalysisData.setHeuristicRatioDecr(n, -3.4028234663852886E38);
        } else {
            d = d2 * yieldAnalysisData.getHeuristicRatioDecr(n);
            yieldAnalysisData.setHeuristicRatioIncr(n, -3.4028234663852886E38);
        }
        yieldAnalysisData.setEndScale(n, d);
        yieldAnalysisData.setStartScale(n2, d);
        if (yieldAnalysisData.getIsBracketed(n)) {
            if (n3 == 21) {
                yieldAnalysisData.setLowerScale(n2, d2);
                yieldAnalysisData.setUpperScale(n2, yieldAnalysisData.getUpperScale(n));
            } else {
                yieldAnalysisData.setLowerScale(n2, yieldAnalysisData.getLowerScale(n));
                yieldAnalysisData.setUpperScale(n2, d2);
            }
            yieldAnalysisData.setIsBracketed(n2, true);
            if (!this.a(n2, d)) {
                yieldAnalysisData.setUseBisection(n, true);
                this.setNextBisectionScaleBracketed(n);
                return;
            }
        } else {
            if (n3 == 21) {
                yieldAnalysisData.setLowerScale(n2, d2);
                yieldAnalysisData.setUpperScale(n2, d);
                yieldAnalysisData.setIsBracketed(n2, false);
                return;
            }
            yieldAnalysisData.setLowerScale(n2, yieldAnalysisData.getLowerScale(n));
            yieldAnalysisData.setUpperScale(n2, d2);
            yieldAnalysisData.setIsBracketed(n2, true);
            if (!this.a(n2, d)) {
                yieldAnalysisData.setUseBisection(n, true);
                this.setNextBisectionScaleBracketed(n);
            }
        }
    }

    private boolean a(int n, double d) {
        YieldAnalysisData yieldAnalysisData = this.getYieldAnalysisData();
        double d2 = yieldAnalysisData.getLowerScale(n);
        double d3 = yieldAnalysisData.getUpperScale(n);
        return !(d > d3) && !(d < d2);
    }

    public List<YieldAnalysisRuleRef> getYieldAnalysisRuleRefs() {
        return this.a;
    }

    public List<YieldAnalysisRuleRef> getYieldAnalysisRuleRefs(RssSystem rssSystem) {
        for (YieldAnalysisRuleRef yieldAnalysisRuleRef : this.a) {
            yieldAnalysisRuleRef.initializeData(rssSystem);
        }
        return this.a;
    }

    public void setMaxIterations(int n) {
        this.b = n;
    }

    public int getMaxIterations() {
        return this.b;
    }

    public void setUseBisectionOnly(boolean bl) {
        this.d = bl;
    }

    public boolean useBisectionOnly() {
        return this.d;
    }

    public void setMaxHeuristicIterations(int n) {
        this.e = n;
    }

    public int getMaxHeuristicIterations() {
        return this.e;
    }

    public void setUseHydropowerRules(boolean bl) {
        this.c = bl;
    }

    public boolean useHydropowerRules() {
        return this.c;
    }

    public void setRuleRefs(List<YieldAnalysisRuleRef> list) {
        this.a = list;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static double[] getOpRuleLimitTS(RssRun rssRun, OpRule opRule, RunTimeWindow runTimeWindow) throws RemoteException, FileNotFoundException {
        RssSystem rssSystem = ((RssTSLocationObject)opRule).getSystem();
        rssRun = rssRun.getRegOutputTSData();
        TSRecord tSRecord = null;
        if (opRule instanceof ScheduledHydropowerOpRule) {
            opRule = opRule.getTSRecordProxy(59);
            tSRecord = rssRun.getTSRecord(opRule.getName(), 59);
            return YieldAnalysis.a(rssSystem.getDSSFileManager(), tSRecord, runTimeWindow);
        }
        if (!(opRule instanceof DownstreamOpRule)) {
            if (!(opRule instanceof ReleaseFuncOpRule)) return YieldAnalysis.a(rssSystem.getDSSFileManager(), tSRecord, runTimeWindow);
            if (((ReleaseFuncOpRule)opRule).getLimitType() == 0) {
                opRule = opRule.getTSRecordProxy(80);
                tSRecord = rssRun.getTSRecord(opRule.getName(), 80);
                return YieldAnalysis.a(rssSystem.getDSSFileManager(), tSRecord, runTimeWindow);
            }
        }
        opRule = opRule.getTSRecordProxy(82);
        tSRecord = rssRun.getTSRecord(opRule.getName(), 82);
        return YieldAnalysis.a(rssSystem.getDSSFileManager(), tSRecord, runTimeWindow);
    }

    private static double[] a(DSSManager object, TSRecord object2, RunTimeWindow runTimeWindow) throws RemoteException, FileNotFoundException {
        String string = object2.getDSSPathname();
        object2 = object2.getDSSFilename();
        DSSIdentifier dSSIdentifier = new DSSIdentifier((String)object2, string);
        dSSIdentifier.setTimeWindow(runTimeWindow.getStartTime(), runTimeWindow.getEndTime());
        try {
            object = object.read(dSSIdentifier);
        }
        catch (RemoteException remoteException) {
            object = string;
            object = "DSS Output record: " + (String)object + " was not found.\nThe Pool, Storage Zone, and Rule Limit DSS Output groups are required to enable the Yield Analysis logic to determine if the firm yield for the selected demand rule has been identified.\nPlease be sure these DSS Output groups are ON for the target reservoir(s).";
            throw new RemoteException((String)object);
        }
        catch (FileNotFoundException fileNotFoundException) {
            object = object2;
            object = "DSS Output File: " + (String)object + " was not found.";
            throw new FileNotFoundException((String)object);
        }
        return object.dataArray;
    }

    private static int[] b(DSSManager object, TSRecord object2, RunTimeWindow runTimeWindow) throws RemoteException, FileNotFoundException {
        String string = object2.getDSSPathname();
        object2 = object2.getDSSFilename();
        object2 = new DSSIdentifier((String)object2, string);
        object2.setTimeWindow(runTimeWindow.getStartTime(), runTimeWindow.getEndTime());
        try {
            object = object.read((DSSIdentifier)object2);
        }
        catch (FileNotFoundException | RemoteException iOException) {
            object = iOException;
            throw iOException;
        }
        return object.timeArray;
    }

    public static double[] getWARuleLimitTS(RssRun rssRun, WaterAccount object, RunTimeWindow runTimeWindow) throws RemoteException, FileNotFoundException {
        RssSystem rssSystem = rssRun.getAlternative().getSystem();
        rssRun = rssRun.getRegOutputTSData();
        object = rssSystem.getWaterAccountSet(((WaterAccount)object).getWaterAccountSetIndex()).getName() + " - " + ((WaterAccount)object).getName();
        rssRun = rssRun.getTSRecord((String)object, 194);
        return YieldAnalysis.a(rssSystem.getDSSFileManager(), (TSRecord)rssRun, runTimeWindow);
    }

    public static double[] getOpRuleResultTS(RssRun rssRun, OpRule opRule, RunTimeWindow runTimeWindow) throws RemoteException, FileNotFoundException {
        RssSystem rssSystem = ((RssTSLocationObject)opRule).getSystem();
        rssRun = rssRun.getRegOutputTSData();
        opRule = opRule.getTargetTSRecordProxy();
        rssRun = rssRun.getTSRecord(opRule.getName(), opRule.getVariableId());
        return YieldAnalysis.a(rssSystem.getDSSFileManager(), (TSRecord)rssRun, runTimeWindow);
    }

    public static double[] getWARuleResultTS(RssRun rssRun, WaterAccount object, RunTimeWindow runTimeWindow) throws RemoteException, FileNotFoundException {
        RssSystem rssSystem = rssRun.getAlternative().getSystem();
        rssRun = rssRun.getRegOutputTSData();
        object = rssSystem.getWaterAccountSet(((WaterAccount)object).getWaterAccountSetIndex()).getName() + " - " + ((WaterAccount)object).getName();
        rssRun = rssRun.getTSRecord((String)object, 193);
        return YieldAnalysis.a(rssSystem.getDSSFileManager(), (TSRecord)rssRun, runTimeWindow);
    }

    public static double[] getResZoneStorTS(RssRun rssRun, StorageZone storageZone, RunTimeWindow runTimeWindow) throws RemoteException, FileNotFoundException {
        OpSet opSet = storageZone.getOpSet();
        RssSystem rssSystem = ((RssTSLocationObject)opSet).getSystem();
        rssRun = rssRun.getRegOutputTSData();
        OpSet opSet2 = opSet;
        storageZone = opSet2.getTSRecordProxy(opSet2.getFullZoneName(storageZone), 78);
        rssRun = rssRun.getTSRecord(storageZone.getName(), 78);
        return YieldAnalysis.a(rssSystem.getDSSFileManager(), (TSRecord)rssRun, runTimeWindow);
    }

    public static double[] getResZoneElevTS(RssRun rssRun, StorageZone storageZone, RunTimeWindow runTimeWindow) throws RemoteException, FileNotFoundException {
        OpSet opSet = storageZone.getOpSet();
        RssSystem rssSystem = ((RssTSLocationObject)opSet).getSystem();
        rssRun = rssRun.getRegOutputTSData();
        OpSet opSet2 = opSet;
        storageZone = opSet2.getTSRecordProxy(opSet2.getFullZoneName(storageZone), 76);
        rssRun = rssRun.getTSRecord(storageZone.getName(), 76);
        return YieldAnalysis.a(rssSystem.getDSSFileManager(), (TSRecord)rssRun, runTimeWindow);
    }

    public static double[] getResPoolStorTS(RssRun rssRun, ReservoirElement reservoirElement, RunTimeWindow runTimeWindow) throws RemoteException, FileNotFoundException {
        RssSystem rssSystem = reservoirElement.getSystem();
        rssRun = rssRun.getRegOutputTSData();
        reservoirElement = reservoirElement.getStorageFunction().getTSRecordProxy(11);
        rssRun = rssRun.getTSRecord(reservoirElement.getName(), 11);
        return YieldAnalysis.a(rssSystem.getDSSFileManager(), (TSRecord)rssRun, runTimeWindow);
    }

    public static double[] getWAStorTS(RssRun rssRun, WaterAccount object, RunTimeWindow runTimeWindow) throws RemoteException, FileNotFoundException {
        RssSystem rssSystem = rssRun.getAlternative().getSystem();
        rssRun = rssRun.getRegOutputTSData();
        object = rssSystem.getWaterAccountSet(((WaterAccount)object).getWaterAccountSetIndex()).getName() + " - " + ((WaterAccount)object).getName();
        rssRun = rssRun.getTSRecord((String)object, 190);
        return YieldAnalysis.a(rssSystem.getDSSFileManager(), (TSRecord)rssRun, runTimeWindow);
    }

    public static double[] getWAMaxStorTS(RssRun rssRun, WaterAccount object, RunTimeWindow runTimeWindow) throws RemoteException, FileNotFoundException {
        RssSystem rssSystem = rssRun.getAlternative().getSystem();
        rssRun = rssRun.getRegOutputTSData();
        object = rssSystem.getWaterAccountSet(((WaterAccount)object).getWaterAccountSetIndex()).getName() + " - " + ((WaterAccount)object).getName();
        rssRun = rssRun.getTSRecord((String)object, 191);
        return YieldAnalysis.a(rssSystem.getDSSFileManager(), (TSRecord)rssRun, runTimeWindow);
    }

    public static int[] getSimulationTimeArray(RssRun rssRun, ReservoirElement reservoirElement, RunTimeWindow runTimeWindow) throws RemoteException, FileNotFoundException {
        RssSystem rssSystem = reservoirElement.getSystem();
        rssRun = rssRun.getRegOutputTSData();
        reservoirElement = reservoirElement.getStorageFunction().getTSRecordProxy(11);
        rssRun = rssRun.getTSRecord(reservoirElement.getName(), 11);
        return YieldAnalysis.b(rssSystem.getDSSFileManager(), (TSRecord)rssRun, runTimeWindow);
    }

    public static int[] getWASimulationTimeArray(RssRun rssRun, WaterAccount object, RunTimeWindow runTimeWindow) throws RemoteException, FileNotFoundException {
        RssSystem rssSystem = rssRun.getAlternative().getSystem();
        rssRun = rssRun.getRegOutputTSData();
        object = rssSystem.getWaterAccountSet(((WaterAccount)object).getWaterAccountSetIndex()).getName() + " - " + ((WaterAccount)object).getName();
        rssRun = rssRun.getTSRecord((String)object, 190);
        return YieldAnalysis.b(rssSystem.getDSSFileManager(), (TSRecord)rssRun, runTimeWindow);
    }

    public boolean writeFile(BufferedWriter bufferedWriter, RssAlt rssAlt) throws IOException {
        if (bufferedWriter == null) {
            return false;
        }
        bufferedWriter.write("YieldAnalysisBegin");
        bufferedWriter.newLine();
        bufferedWriter.write("UseHydropowerRules=" + Boolean.toString(this.useHydropowerRules()));
        bufferedWriter.newLine();
        bufferedWriter.write("MaxIteration=" + Integer.toString(this.getMaxIterations()));
        bufferedWriter.newLine();
        bufferedWriter.write("UseBisectionOnly=" + Boolean.toString(this.d));
        bufferedWriter.newLine();
        bufferedWriter.write("MaxHeuristicIterations=" + Integer.toString(this.e));
        bufferedWriter.newLine();
        for (int i = 0; i < this.a.size(); ++i) {
            YieldAnalysisRuleRef yieldAnalysisRuleRef = this.a.get(i);
            if (!yieldAnalysisRuleRef.isInitialized()) {
                yieldAnalysisRuleRef.initializeData(rssAlt.getSystem());
            }
            yieldAnalysisRuleRef.writeDataToFile(bufferedWriter);
        }
        bufferedWriter.write("YieldAnalysisEnd");
        bufferedWriter.newLine();
        return true;
    }

    public boolean readFile(BufferedReader bufferedReader) throws IOException {
        this.a = new ArrayList<YieldAnalysisRuleRef>();
        if (bufferedReader == null) {
            return false;
        }
        Object object = bufferedReader.readLine();
        while (object != null) {
            int n = ((String)object).indexOf(61);
            if (n >= 0) {
                String string = ((String)object).substring(0, n);
                object = ((String)object).substring(n + 1);
                if (string.equals("UseHydropowerRules")) {
                    this.setUseHydropowerRules(Boolean.parseBoolean((String)object));
                } else if (string.equals("MaxIteration")) {
                    this.setMaxIterations(Integer.parseInt((String)object));
                } else if (string.equals("UseBisectionOnly")) {
                    this.setUseBisectionOnly(Boolean.parseBoolean((String)object));
                } else if (string.equals("MaxHeuristicIterations")) {
                    this.setMaxHeuristicIterations(Integer.parseInt((String)object));
                }
            } else {
                if (((String)object).equalsIgnoreCase("YieldAnalysisEnd")) {
                    return true;
                }
                if (((String)object).equalsIgnoreCase("YieldAnalysisRuleRefBegin")) {
                    object = new YieldAnalysisRuleRef();
                    ((YieldAnalysisRuleRef)object).readFile(bufferedReader);
                    this.a.add((YieldAnalysisRuleRef)object);
                }
            }
            object = bufferedReader.readLine();
        }
        return true;
    }

    public Object clone() {
        try {
            YieldAnalysis yieldAnalysis = (YieldAnalysis)super.clone();
            yieldAnalysis.setMaxIterations(this.b);
            yieldAnalysis.setUseHydropowerRules(this.c);
            yieldAnalysis.setUseBisectionOnly(this.d);
            yieldAnalysis.setMaxHeuristicIterations(this.getMaxHeuristicIterations());
            ArrayList<YieldAnalysisRuleRef> arrayList = new ArrayList<YieldAnalysisRuleRef>();
            for (int i = 0; i < this.a.size(); ++i) {
                arrayList.add((YieldAnalysisRuleRef)this.a.get(i).clone());
            }
            yieldAnalysis.setRuleRefs(arrayList);
            if (this.f != null) {
                yieldAnalysis.f = (YieldAnalysisData)this.f.clone();
            }
            return yieldAnalysis;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println(cloneNotSupportedException);
            return null;
        }
    }
}

