/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.data.Parameter;
import hec.heclib.util.HecTime;
import hec.io.DSSIdentifier;
import hec.io.DataContainer;
import hec.io.PairedDataContainer;
import hec.rss.model.ReservoirStorageVsYieldAnalysis;
import hec.rss.model.ReservoirYieldAnalysis;
import hec.rss.model.ReverseReservoirYieldAnalysis;
import hec.rss.model.ReverseWaterAccountYieldAnalysis;
import hec.rss.model.ReverseYieldAnalysisBase;
import hec.rss.model.RssRun;
import hec.rss.model.WaterAccountYieldAnalysis;
import hec.rss.model.YieldAnalysis;
import hec.rss.model.YieldAnalysisRuleRef;
import java.rmi.RemoteException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.army.usace.hec.rmi.csinterface.DSSManager;

public class YieldAnalysisData
implements Cloneable {
    public static final int YA_INCR_SCALE = 21;
    public static final int YA_DECR_SCALE = 22;
    public static final int YA_CONVERGED = 23;
    public static final int YA_RULEFAIL = 24;
    public static final int YA_RULEPASS = 25;
    public static final int YA_DSS_READ_ERROR = -21;
    public static final int YA_STOP_SCRIPT = -22;
    private double a;
    private double b;
    private double c;
    private double d;
    private int e;
    private double[] f;
    private double[] g;
    private double[] h;
    private double[] i;
    private boolean[] j;
    private boolean[] k;
    private boolean[] l;
    private boolean[] m;
    private int[] n;
    private int[] o;
    private int[] p;
    private double[] q;
    private double[] r;
    private double[] s;
    private double[] t;
    private double[] u;
    private double[] v;
    private int[] w;
    private boolean[] x;
    private double[] y;
    private double[] z;

    YieldAnalysisData() {
    }

    public void setLowerLimitStor(double d) {
        this.a = d;
    }

    public double getLowerLimitStor() {
        return this.a;
    }

    public void setLowerLimitStorTol(double d) {
        this.b = d;
    }

    public double getLowerLimitStorTol() {
        return this.b;
    }

    public void setStorageTol(double d) {
        this.c = d;
    }

    public double getStorageTol() {
        return this.c;
    }

    public void setAvgStartingRuleDemand(double d) {
        this.d = d;
    }

    public double getAvgStartingRuleDemand() {
        return this.d;
    }

    public void setElevationInterval(int n) {
        this.e = n;
    }

    public void initializeOutputArrays(int n) {
        this.f = new double[n];
        this.g = new double[n];
        this.h = new double[n];
        this.i = new double[n];
        this.j = new boolean[n];
        Arrays.fill(this.f, -3.4028234663852886E38);
        Arrays.fill(this.g, -3.4028234663852886E38);
        Arrays.fill(this.h, -3.4028234663852886E38);
        Arrays.fill(this.i, -3.4028234663852886E38);
        Arrays.fill(this.j, false);
        this.k = new boolean[n];
        this.l = new boolean[n];
        this.m = new boolean[n];
        Arrays.fill(this.k, false);
        Arrays.fill(this.l, false);
        Arrays.fill(this.m, false);
        this.n = new int[n];
        this.o = new int[n];
        this.p = new int[n];
        Arrays.fill(this.n, Integer.MIN_VALUE);
        Arrays.fill(this.o, Integer.MIN_VALUE);
        Arrays.fill(this.p, Integer.MIN_VALUE);
        this.q = new double[n];
        Arrays.fill(this.q, -3.4028234663852886E38);
        this.r = new double[n];
        Arrays.fill(this.r, -3.4028234663852886E38);
        this.s = new double[n];
        Arrays.fill(this.s, -3.4028234663852886E38);
        this.t = new double[n];
        Arrays.fill(this.t, -3.4028234663852886E38);
        this.u = new double[n];
        Arrays.fill(this.u, -3.4028234663852886E38);
        this.v = new double[n];
        Arrays.fill(this.v, -3.4028234663852886E38);
        this.w = new int[n];
        Arrays.fill(this.w, Integer.MIN_VALUE);
        this.x = new boolean[n];
        Arrays.fill(this.x, false);
        this.y = new double[n];
        Arrays.fill(this.y, -3.4028234663852886E38);
        this.z = new double[n];
        Arrays.fill(this.z, -3.4028234663852886E38);
    }

    public void setStartScale(int n, double d) {
        this.f[n - 1] = d;
    }

    public double getStartScale(int n) {
        return this.f[n - 1];
    }

    public void setEndScale(int n, double d) {
        this.g[n - 1] = d;
    }

    public double getEndScale(int n) {
        return this.g[n - 1];
    }

    public void setLowerScale(int n, double d) {
        this.i[n - 1] = d;
    }

    public double getLowerScale(int n) {
        return this.i[n - 1];
    }

    public void setUpperScale(int n, double d) {
        this.h[n - 1] = d;
    }

    public double getUpperScale(int n) {
        return this.h[n - 1];
    }

    public void setIsBracketed(int n, boolean bl) {
        this.j[n - 1] = bl;
    }

    public boolean getIsBracketed(int n) {
        return this.j[n - 1];
    }

    public void setRuleTest(int n, boolean bl) {
        this.k[n - 1] = bl;
    }

    public boolean getRuleTest(int n) {
        return this.k[n - 1];
    }

    public void setStorageTest(int n, boolean bl) {
        this.l[n - 1] = bl;
    }

    public boolean getStorageTest(int n) {
        return this.l[n - 1];
    }

    public void setStorageTolTest(int n, boolean bl) {
        this.m[n - 1] = bl;
    }

    public boolean getStorageTolTest(int n) {
        return this.m[n - 1];
    }

    public void setStartCritPeriod(int n, int n2) {
        this.n[n - 1] = n2;
    }

    public int getStartCritPeriod(int n) {
        return this.n[n - 1];
    }

    public void setMinCritPeriod(int n, int n2) {
        this.o[n - 1] = n2;
    }

    public int getMinCritPeriod(int n) {
        return this.o[n - 1];
    }

    public void setEndCritPeriod(int n, int n2) {
        this.p[n - 1] = n2;
    }

    public int getEndCritPeriod(int n) {
        return this.p[n - 1];
    }

    public void setMinStorage(int n, double d) {
        this.q[n - 1] = d;
    }

    public double getMinStorage(int n) {
        return this.q[n - 1];
    }

    public void setAvgSimStorage(int n, double d) {
        this.r[n - 1] = d;
    }

    public double getAvgSimStorage(int n) {
        return this.r[n - 1];
    }

    public void setAvgConPoolStorage(int n, double d) {
        this.s[n - 1] = d;
    }

    public double getAvgConPoolStorage(int n) {
        return this.s[n - 1];
    }

    public void setMaxDemandShortage(int n, double d) {
        this.t[n - 1] = d;
    }

    public double getMaxDemandShortage(int n) {
        return this.t[n - 1];
    }

    public void setAccumDemandShortage(int n, double d) {
        this.u[n - 1] = d;
    }

    public double getAccumDemandShortage(int n) {
        return this.u[n - 1];
    }

    public void setLimitingRuleTol(int n, double d) {
        this.v[n - 1] = d;
    }

    public double getLimitingRuleTol(int n) {
        return this.v[n - 1];
    }

    public void setDecision(int n, int n2) {
        this.w[n - 1] = n2;
    }

    public int getDecision(int n) {
        return this.w[n - 1];
    }

    public void setUseBisection(int n, boolean bl) {
        this.x[n - 1] = bl;
    }

    public boolean getUseBisection(int n) {
        if (n == 0) {
            return false;
        }
        return this.x[n - 1];
    }

    public void setHeuristicRatioIncr(int n, double d) {
        this.y[n - 1] = d;
    }

    public double getHeuristicRatioIncr(int n) {
        return this.y[n - 1];
    }

    public void setHeuristicRatioDecr(int n, double d) {
        this.z[n - 1] = d;
    }

    public double getHeuristicRatioDecr(int n) {
        return this.z[n - 1];
    }

    public void setScalesConverged(int n) {
        this.setEndScale(n, this.getStartScale(n));
        this.setHeuristicRatioDecr(n, -3.4028234663852886E38);
        this.setHeuristicRatioIncr(n, -3.4028234663852886E38);
    }

    public int getTotalIterations() {
        int n = Integer.MIN_VALUE;
        if (this.f != null) {
            n = 0;
            for (int i = 0; i < this.f.length && this.f[i] != -3.4028234663852886E38; ++i) {
                ++n;
            }
        }
        return n;
    }

    public double getFinalScaleFactor() {
        double d = -3.4028234663852886E38;
        int n = this.getTotalIterations();
        if (n > 0 && this.f != null && this.f.length >= n - 1) {
            d = this.f[n - 1];
        }
        return d;
    }

    public double getFinalAvgAnnualDemand() {
        double d = -3.4028234663852886E38;
        double d2 = this.getAvgStartingRuleDemand();
        double d3 = this.getFinalScaleFactor();
        if (d3 != -3.4028234663852886E38 && d2 != -3.4028234663852886E38) {
            d = d2 * d3;
        }
        return d;
    }

    public boolean writePairedData(RssRun rssRun, YieldAnalysis yieldAnalysis) {
        int n;
        YieldAnalysis yieldAnalysis2 = yieldAnalysis;
        RssRun rssRun2 = rssRun;
        YieldAnalysisData yieldAnalysisData = this;
        int n2 = yieldAnalysisData.getTotalIterations();
        int n3 = Parameter.PARAMID_FLOW;
        double[][] dArray = new double[3][n2];
        String[] stringArray = new String[3];
        for (n = 0; n < n2; ++n) {
            dArray[0][n] = yieldAnalysisData.d * yieldAnalysisData.f[n];
            dArray[1][n] = yieldAnalysisData.v[n];
            dArray[2][n] = yieldAnalysisData.t[n];
        }
        stringArray[0] = "Average Simulation Demand";
        stringArray[1] = "Limiting Rule Tolerance";
        stringArray[2] = "Maximum Demand Shortage";
        boolean bl = yieldAnalysisData.a(rssRun2, yieldAnalysis2, 3, n3, dArray, stringArray);
        if (!bl) {
            return false;
        }
        yieldAnalysis2 = yieldAnalysis;
        rssRun2 = rssRun;
        YieldAnalysisData yieldAnalysisData2 = this;
        n2 = yieldAnalysisData2.getTotalIterations();
        n3 = Parameter.PARAMID_STOR;
        dArray = new double[3][n2];
        stringArray = new String[3];
        for (n = 0; n < n2; ++n) {
            dArray[0][n] = yieldAnalysisData2.a;
            dArray[1][n] = yieldAnalysisData2.b;
            dArray[2][n] = yieldAnalysisData2.q[n];
        }
        String string = yieldAnalysis2 instanceof ReverseReservoirYieldAnalysis ? "Con Pool" : "Water Acct";
        stringArray[0] = "Lower Limit of " + string;
        stringArray[1] = "Lower Limit of " + string + " + Storage Tolerance";
        stringArray[2] = "Simulated Minimum Storage";
        boolean bl2 = yieldAnalysisData2.a(rssRun2, yieldAnalysis2, 3, n3, dArray, stringArray);
        if (!bl2) {
            return false;
        }
        yieldAnalysis2 = yieldAnalysis;
        rssRun2 = rssRun;
        YieldAnalysisData yieldAnalysisData3 = this;
        n2 = yieldAnalysisData3.getTotalIterations();
        n3 = Parameter.PARAMID_COUNT;
        dArray = new double[7][n2];
        stringArray = new String[7];
        for (int i = 0; i < n2; ++i) {
            dArray[0][i] = yieldAnalysisData3.i[i];
            dArray[1][i] = yieldAnalysisData3.h[i];
            dArray[2][i] = yieldAnalysisData3.f[i];
            double d = yieldAnalysisData3.y[i];
            if (d != -3.4028234663852886E38) {
                d *= yieldAnalysisData3.f[i];
            }
            dArray[3][i] = d;
            double d2 = yieldAnalysisData3.z[i];
            if (d2 != -3.4028234663852886E38) {
                d2 *= yieldAnalysisData3.f[i];
            }
            dArray[4][i] = d2;
            dArray[5][i] = yieldAnalysisData3.k[i] ? 1.0 : 0.0;
            dArray[6][i] = yieldAnalysisData3.m[i] ? 1.0 : 0.0;
        }
        stringArray[0] = "Demand Scale Minimum Limit";
        stringArray[1] = "Demand Scale Maximum Limit";
        stringArray[2] = "Trial Demand Scale";
        stringArray[3] = "Heuristic Increase Demand Factor";
        stringArray[4] = "Heuristic Decrease Demand Factor";
        stringArray[5] = "Demand Rule Convergence Test";
        stringArray[6] = "Storage Convergence Test";
        boolean bl3 = yieldAnalysisData3.a(rssRun2, yieldAnalysis2, 7, n3, dArray, stringArray);
        if (!bl3) {
            return false;
        }
        bl3 = this.a(rssRun, yieldAnalysis);
        return bl3;
    }

    public boolean writePairedDataReverse(RssRun rssRun, YieldAnalysis yieldAnalysis) {
        int n;
        YieldAnalysis yieldAnalysis2 = yieldAnalysis;
        RssRun rssRun2 = rssRun;
        YieldAnalysisData yieldAnalysisData = this;
        int n2 = yieldAnalysisData.getTotalIterations();
        int n3 = Parameter.PARAMID_FLOW;
        if (yieldAnalysis2.useHydropowerRules()) {
            n3 = Parameter.PARAMID_POWER;
        }
        double[][] dArray = new double[2][n2];
        String[] stringArray = new String[2];
        for (n = 0; n < n2; ++n) {
            dArray[0][n] = yieldAnalysisData.v[n];
            dArray[1][n] = yieldAnalysisData.t[n];
        }
        stringArray[0] = "Rule Tolerance";
        stringArray[1] = "Maximum Demand Shortage";
        boolean bl = yieldAnalysisData.a(rssRun2, yieldAnalysis2, 2, n3, dArray, stringArray);
        if (!bl) {
            return false;
        }
        yieldAnalysis2 = yieldAnalysis;
        rssRun2 = rssRun;
        YieldAnalysisData yieldAnalysisData2 = this;
        n2 = yieldAnalysisData2.getTotalIterations();
        n3 = Parameter.PARAMID_STOR;
        dArray = new double[5][n2];
        stringArray = new String[5];
        for (n = 0; n < n2; ++n) {
            dArray[0][n] = yieldAnalysisData2.a;
            dArray[1][n] = yieldAnalysisData2.b;
            dArray[2][n] = yieldAnalysisData2.q[n];
            dArray[3][n] = yieldAnalysisData2.r[n];
            dArray[4][n] = yieldAnalysisData2.s[n];
        }
        String string = yieldAnalysis2 instanceof ReverseReservoirYieldAnalysis ? "Con Pool" : "Water Acct";
        stringArray[0] = "Lower Limit of " + string;
        stringArray[1] = "Lower Limit of " + string + " + Storage Tolerance";
        stringArray[2] = "Simulated Minimum Storage";
        stringArray[3] = "Average Simulation Storage";
        stringArray[4] = "Average Total " + string + " Storage";
        boolean bl2 = yieldAnalysisData2.a(rssRun2, yieldAnalysis2, 5, n3, dArray, stringArray);
        if (!bl2) {
            return false;
        }
        yieldAnalysis2 = yieldAnalysis;
        rssRun2 = rssRun;
        YieldAnalysisData yieldAnalysisData3 = this;
        n2 = yieldAnalysisData3.getTotalIterations();
        n3 = Parameter.PARAMID_COUNT;
        dArray = new double[7][n2];
        stringArray = new String[7];
        for (int i = 0; i < n2; ++i) {
            dArray[0][i] = yieldAnalysisData3.i[i];
            dArray[1][i] = yieldAnalysisData3.h[i];
            dArray[2][i] = yieldAnalysisData3.f[i];
            dArray[3][i] = yieldAnalysisData3.y[i];
            dArray[4][i] = yieldAnalysisData3.z[i];
            dArray[5][i] = yieldAnalysisData3.k[i] ? 1.0 : 0.0;
            dArray[6][i] = yieldAnalysisData3.m[i] ? 1.0 : 0.0;
        }
        stringArray[0] = "Storage Scale Minimum Limit";
        stringArray[1] = "Storage Scale Maximum Limit";
        stringArray[2] = "Trial Storage Scale";
        stringArray[3] = "Heuristic Increase Demand Factor";
        stringArray[4] = "Heuristic Decrease Demand Factor";
        stringArray[5] = "Demand Rule Convergence Test";
        stringArray[6] = "Storage Convergence Test";
        boolean bl3 = yieldAnalysisData3.a(rssRun2, yieldAnalysis2, 7, n3, dArray, stringArray);
        if (!bl3) {
            return false;
        }
        bl3 = this.a(rssRun, yieldAnalysis);
        return bl3;
    }

    private boolean a(RssRun rssRun, YieldAnalysis yieldAnalysis) {
        int n = this.getTotalIterations();
        int n2 = Parameter.PARAMID_TIMING;
        double[][] dArray = new double[3][n];
        String[] stringArray = new String[3];
        for (int i = 0; i < n; ++i) {
            dArray[0][i] = this.n[i];
            dArray[1][i] = this.o[i];
            dArray[2][i] = this.p[i];
        }
        stringArray[0] = "Critical Period Start";
        stringArray[1] = "Critical Period Minimum";
        stringArray[2] = "Critical Period End";
        return this.a(rssRun, yieldAnalysis, 3, n2, dArray, stringArray);
    }

    private boolean a(RssRun rssRun, YieldAnalysis yieldAnalysis, int n, int n2, double[][] dArray, String[] stringArray) {
        int n3 = this.getTotalIterations();
        PairedDataContainer pairedDataContainer = new PairedDataContainer();
        int n4 = Parameter.PARAMID_COUNT;
        double[] dArray2 = new double[n3];
        int n5 = 0;
        while (n5 < n3) {
            int n6 = n5++;
            dArray2[n6] = (double)n6 + 1.0;
        }
        pairedDataContainer.yOrdinates = dArray;
        pairedDataContainer.labels = stringArray;
        pairedDataContainer.xOrdinates = dArray2;
        pairedDataContainer.numberOrdinates = n3;
        pairedDataContainer.numberCurves = n;
        pairedDataContainer.xparameter = Parameter.getParamString((int)n4);
        pairedDataContainer.xunits = Parameter.getUnitsStringForSystem((int)n4, (int)rssRun.getAlternative().getUnitSystem());
        pairedDataContainer.yparameter = Parameter.getParamString((int)n2);
        pairedDataContainer.yunits = Parameter.getUnitsStringForSystem((int)n2, (int)rssRun.getAlternative().getUnitSystem());
        pairedDataContainer.labelsUsed = true;
        pairedDataContainer.fullName = this.a(rssRun, yieldAnalysis, n4, n2);
        pairedDataContainer.fileName = rssRun.getDSSOutputFile();
        try {
            n5 = rssRun.getDSSFileManager().write((DataContainer)pairedDataContainer);
        }
        catch (RemoteException remoteException) {
            System.out.println("Failed to save data set: " + pairedDataContainer.fullName);
            return false;
        }
        if (n5 < 0) {
            System.out.println("Failed to save data set: " + pairedDataContainer.fullName);
            return false;
        }
        return true;
    }

    public boolean readPairedData(RssRun rssRun, YieldAnalysis yieldAnalysis) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        this.initializeOutputArrays(yieldAnalysis.getMaxIterations());
        YieldAnalysis yieldAnalysis2 = yieldAnalysis;
        RssRun rssRun2 = rssRun;
        YieldAnalysisData yieldAnalysisData = this;
        int n = Parameter.PARAMID_FLOW;
        rssRun2 = yieldAnalysisData.a(rssRun2, yieldAnalysis2, n);
        if (rssRun2 == null || rssRun2.getXOridnates() == null || rssRun2.getNumberCurves() != 3) {
            bl3 = false;
        } else {
            boolean bl4;
            int n2 = ((PairedDataContainer)rssRun2).xOrdinates.length;
            for (n = 0; n < n2; ++n) {
                if (n == 0) {
                    yieldAnalysisData.d = ((PairedDataContainer)rssRun2).yOrdinates[0][n];
                }
                yieldAnalysisData.v[n] = ((PairedDataContainer)rssRun2).yOrdinates[1][n];
                yieldAnalysisData.t[n] = ((PairedDataContainer)rssRun2).yOrdinates[2][n];
            }
            bl3 = bl4 = true;
        }
        if (!bl3) {
            return false;
        }
        yieldAnalysis2 = yieldAnalysis;
        rssRun2 = rssRun;
        YieldAnalysisData yieldAnalysisData2 = this;
        n = Parameter.PARAMID_STOR;
        if ((rssRun2 = yieldAnalysisData2.a(rssRun2, yieldAnalysis2, n)) == null || rssRun2.getXOridnates() == null || rssRun2.getNumberCurves() != 3) {
            bl2 = false;
        } else {
            int n3 = ((PairedDataContainer)rssRun2).xOrdinates.length;
            for (n = 0; n < n3; ++n) {
                if (n == 0) {
                    yieldAnalysisData2.a = ((PairedDataContainer)rssRun2).yOrdinates[0][n];
                    yieldAnalysisData2.b = ((PairedDataContainer)rssRun2).yOrdinates[1][n];
                }
                yieldAnalysisData2.q[n] = ((PairedDataContainer)rssRun2).yOrdinates[2][n];
            }
            bl2 = bl = true;
        }
        if (!bl2) {
            return false;
        }
        bl = this.b(rssRun, yieldAnalysis);
        if (!bl) {
            return false;
        }
        bl = this.c(rssRun, yieldAnalysis);
        return bl;
    }

    public boolean readPairedDataReverse(RssRun rssRun, ReverseYieldAnalysisBase reverseYieldAnalysisBase) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        this.initializeOutputArrays(reverseYieldAnalysisBase.getMaxIterations());
        ReverseYieldAnalysisBase reverseYieldAnalysisBase2 = reverseYieldAnalysisBase;
        RssRun rssRun2 = rssRun;
        YieldAnalysisData yieldAnalysisData = this;
        int n = Parameter.PARAMID_FLOW;
        rssRun2 = yieldAnalysisData.a(rssRun2, reverseYieldAnalysisBase2, n);
        if (rssRun2 == null || ((PairedDataContainer)rssRun2).xOrdinates == null || rssRun2.getNumberCurves() != 2) {
            bl3 = false;
        } else {
            boolean bl4;
            int n2 = ((PairedDataContainer)rssRun2).xOrdinates.length;
            for (n = 0; n < n2; ++n) {
                yieldAnalysisData.v[n] = ((PairedDataContainer)rssRun2).yOrdinates[0][n];
                yieldAnalysisData.t[n] = ((PairedDataContainer)rssRun2).yOrdinates[1][n];
            }
            bl3 = bl4 = true;
        }
        if (!bl3) {
            return false;
        }
        reverseYieldAnalysisBase2 = reverseYieldAnalysisBase;
        rssRun2 = rssRun;
        YieldAnalysisData yieldAnalysisData2 = this;
        n = Parameter.PARAMID_STOR;
        if ((rssRun2 = yieldAnalysisData2.a(rssRun2, reverseYieldAnalysisBase2, n)) == null || rssRun2.getXOridnates() == null || rssRun2.getNumberCurves() != 5) {
            bl2 = false;
        } else {
            int n3 = ((PairedDataContainer)rssRun2).xOrdinates.length;
            for (n = 0; n < n3; ++n) {
                if (n == 0) {
                    yieldAnalysisData2.a = ((PairedDataContainer)rssRun2).yOrdinates[0][n];
                    yieldAnalysisData2.b = ((PairedDataContainer)rssRun2).yOrdinates[1][n];
                }
                yieldAnalysisData2.q[n] = ((PairedDataContainer)rssRun2).yOrdinates[2][n];
                yieldAnalysisData2.r[n] = ((PairedDataContainer)rssRun2).yOrdinates[3][n];
                yieldAnalysisData2.s[n] = ((PairedDataContainer)rssRun2).yOrdinates[4][n];
            }
            bl2 = bl = true;
        }
        if (!bl2) {
            return false;
        }
        bl = this.b(rssRun, reverseYieldAnalysisBase);
        if (!bl) {
            return false;
        }
        bl = this.c(rssRun, reverseYieldAnalysisBase);
        return bl;
    }

    private boolean b(RssRun rssRun, YieldAnalysis yieldAnalysis) {
        int n = Parameter.PARAMID_COUNT;
        if ((rssRun = this.a(rssRun, yieldAnalysis, n)) == null || rssRun.getXOridnates() == null || rssRun.getNumberCurves() != 7) {
            return false;
        }
        int n2 = ((PairedDataContainer)rssRun).xOrdinates.length;
        for (n = 0; n < n2; ++n) {
            this.i[n] = ((PairedDataContainer)rssRun).yOrdinates[0][n];
            this.h[n] = ((PairedDataContainer)rssRun).yOrdinates[1][n];
            this.f[n] = ((PairedDataContainer)rssRun).yOrdinates[2][n];
            this.y[n] = ((PairedDataContainer)rssRun).yOrdinates[3][n];
            this.z[n] = ((PairedDataContainer)rssRun).yOrdinates[4][n];
            this.k[n] = ((PairedDataContainer)rssRun).yOrdinates[5][n] == 1.0;
            this.m[n] = ((PairedDataContainer)rssRun).yOrdinates[6][n] == 1.0;
        }
        return true;
    }

    private boolean c(RssRun rssRun, YieldAnalysis yieldAnalysis) {
        int n = Parameter.PARAMID_TIMING;
        if ((rssRun = this.a(rssRun, yieldAnalysis, n)) == null || rssRun.getXOridnates() == null || rssRun.getNumberCurves() != 3) {
            return false;
        }
        int n2 = ((PairedDataContainer)rssRun).xOrdinates.length;
        for (n = 0; n < n2; ++n) {
            this.n[n] = (int)((PairedDataContainer)rssRun).yOrdinates[0][n];
            this.o[n] = (int)((PairedDataContainer)rssRun).yOrdinates[1][n];
            this.p[n] = (int)((PairedDataContainer)rssRun).yOrdinates[2][n];
        }
        return true;
    }

    private PairedDataContainer a(RssRun object, YieldAnalysis yieldAnalysis, int n) {
        DSSManager dSSManager = object.getDSSFileManager();
        String string = ((RssRun)object).getDSSOutputFile();
        if (dSSManager == null || string == null) {
            return null;
        }
        int n2 = Parameter.PARAMID_COUNT;
        object = this.a((RssRun)object, yieldAnalysis, n2, n);
        object = new DSSIdentifier(string, (String)object);
        yieldAnalysis = null;
        try {
            yieldAnalysis = dSSManager.readPairedDataContainer((DSSIdentifier)object);
        }
        catch (RemoteException remoteException) {
            System.out.println("Failed to read data set: " + null.fullName);
        }
        return yieldAnalysis;
    }

    private String a(RssRun rssRun, YieldAnalysis object, int n, int n2) {
        Object object2;
        Object object3 = "";
        String string = "";
        if (object instanceof ReservoirStorageVsYieldAnalysis) {
            object = (ReservoirStorageVsYieldAnalysis)object;
            object2 = ((YieldAnalysis)object).getYieldAnalysisRuleRefs().get(0);
            string = YieldAnalysisData.a((YieldAnalysisRuleRef)object2, rssRun);
            double d = ((ReservoirStorageVsYieldAnalysis)object).d(this.e);
            object = new DecimalFormat("0.00");
            object = ((NumberFormat)object).format(d);
            object3 = "Elevation " + (String)object;
        } else if (object instanceof ReverseYieldAnalysisBase) {
            string = YieldAnalysisData.a((ReverseYieldAnalysisBase)object);
        } else if (object instanceof ReservoirYieldAnalysis || object instanceof WaterAccountYieldAnalysis) {
            object = ((YieldAnalysis)object).getYieldAnalysisRuleRefs().get(0);
            string = YieldAnalysisData.a((YieldAnalysisRuleRef)object, rssRun);
        }
        object = Parameter.getParamString((int)n) + "-" + Parameter.getParamString((int)n2);
        object2 = "";
        String string2 = "";
        String string3 = rssRun.getOutputFPart();
        object = Arrays.asList("", object3, string, object, object2, string2, string3, "");
        object = String.join((CharSequence)"/", object);
        return object;
    }

    private static String a(ReverseYieldAnalysisBase reverseYieldAnalysisBase) {
        String string = null;
        if (reverseYieldAnalysisBase instanceof ReverseReservoirYieldAnalysis) {
            string = "Yield Analysis-" + ((ReverseReservoirYieldAnalysis)reverseYieldAnalysisBase).k().getDisplayName();
        } else if (reverseYieldAnalysisBase instanceof ReverseWaterAccountYieldAnalysis) {
            string = "Yield Analysis-" + ((ReverseWaterAccountYieldAnalysis)reverseYieldAnalysisBase).d().getDisplayName();
        }
        return string;
    }

    private static String a(YieldAnalysisRuleRef yieldAnalysisRuleRef, RssRun rssRun) {
        if (!yieldAnalysisRuleRef.isInitialized()) {
            yieldAnalysisRuleRef.initializeData(rssRun.getNetwork());
        }
        return "Yield Rule-" + yieldAnalysisRuleRef.getRuleName();
    }

    public void printFYComputeMessages(RssRun rssRun, YieldAnalysis object, int n) {
        String string = ((YieldAnalysis)object).getYieldAnalysisRuleRefs().get(0).getRuleName();
        boolean bl = false;
        if (((YieldAnalysis)object).useHydropowerRules()) {
            bl = true;
        }
        String string2 = " ";
        if (object instanceof ReservoirYieldAnalysis || object instanceof ReservoirStorageVsYieldAnalysis) {
            string2 = "Conservation Pool";
        } else if (object instanceof WaterAccountYieldAnalysis) {
            string2 = "Water Account";
        }
        rssRun.printMessage(" ");
        rssRun.printMessage("  Yield Analysis Rule: " + string + " Storage Scales:");
        String string3 = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_FLOW, (int)rssRun.getAlternative().getUnitSystem());
        String string4 = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_POWER, (int)rssRun.getAlternative().getUnitSystem());
        String string5 = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_STOR, (int)rssRun.getAlternative().getUnitSystem());
        DecimalFormat decimalFormat = new DecimalFormat("0.000000");
        object = decimalFormat.format(this.getLowerScale(n));
        string = decimalFormat.format(this.getUpperScale(n));
        String string6 = decimalFormat.format(this.getStartScale(n));
        rssRun.printMessage("    Min Demand Factor: " + (String)object + ", Max Demand Factor: " + string + ", Trial Demand Factor: " + string6);
        String string7 = bl ? string4 : string3;
        object = decimalFormat.format(this.getStartScale(n) * this.getAvgStartingRuleDemand());
        rssRun.printMessage("  Simulation Average Demand: " + (String)object + " " + string7);
        string = this.getStartCritDate(n);
        string6 = this.getEndCritDate(n);
        string3 = this.getMinCritDate(n);
        object = decimalFormat.format(this.getMinStorage(n));
        rssRun.printMessage("  Critical Period: " + string + " to " + string6);
        rssRun.printMessage("  Minimum " + string2 + " Storage on " + string3 + " is " + (String)object + " " + string5);
        object = decimalFormat.format(this.getLowerLimitStor());
        string = decimalFormat.format(this.getLowerLimitStorTol() - this.getLowerLimitStor());
        rssRun.printMessage("  Lower Limit of " + string2 + " Storage: " + (String)object + " " + string5 + "; Storage Tolerance = " + string + " " + string5);
        string = decimalFormat.format(this.getLimitingRuleTol(n));
        object = decimalFormat.format(this.getMaxDemandShortage(n));
        rssRun.printMessage("  Maximum Demand Shortage: " + (String)object + " " + string7 + "; Rule Tolerance = " + string + " " + string7);
        object = this.getRuleTest(n) ? "PASS" : "FAIL";
        rssRun.printMessage("  Convergence Test: Maximum Demand Shortage Within Rule Tolerance: " + (String)object);
        object = this.getStorageTolTest(n) ? "PASS" : "FAIL";
        rssRun.printMessage("  Convergence Test: Minimum " + string2 + " Storage Within Tolerance: " + (String)object);
        if (!this.getRuleTest(n)) {
            rssRun.printMessage("  Rule test failed, decreasing demand scale");
        } else if (this.getDecision(n) == 22) {
            rssRun.printMessage("  Minimum Storage At or Below Zero, decreasing demand scale");
        } else if (this.getDecision(n) == 21) {
            rssRun.printMessage("  Minimum Storage Above Tolerance, increasing demand scale");
        } else {
            rssRun.printMessage(" ");
            object = decimalFormat.format(this.getStartScale(n) * this.getAvgStartingRuleDemand());
            rssRun.printMessage("Yield Analysis Compute " + n + " converged with Simulation Average Demand : " + (String)object + " " + string7);
        }
        rssRun.printMessage(" ");
    }

    public void printRevFYComputeMessages(RssRun rssRun, ReverseYieldAnalysisBase object, int n) {
        Object object2 = " ";
        String string = " ";
        if (object instanceof ReverseReservoirYieldAnalysis) {
            object2 = ((ReverseReservoirYieldAnalysis)object).k().getDisplayName();
            string = "Conservation Pool";
        } else if (object instanceof ReverseWaterAccountYieldAnalysis) {
            object2 = ((ReverseWaterAccountYieldAnalysis)object).d().getDisplayName();
            string = "Water Account";
        }
        rssRun.printMessage(" ");
        rssRun.printMessage("  " + (String)object2 + " " + string + " Storage Scales:");
        String string2 = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_FLOW, (int)rssRun.getAlternative().getUnitSystem());
        String string3 = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_POWER, (int)rssRun.getAlternative().getUnitSystem());
        String string4 = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_STOR, (int)rssRun.getAlternative().getUnitSystem());
        DecimalFormat decimalFormat = new DecimalFormat("0.000000");
        object2 = decimalFormat.format(this.getLowerScale(n));
        String string5 = decimalFormat.format(this.getUpperScale(n));
        String string6 = decimalFormat.format(this.getStartScale(n));
        rssRun.printMessage("    Min Storage Factor: " + (String)object2 + ", Max Storage Factor: " + string5 + ", Trial Storage Factor: " + string6);
        object2 = new DecimalFormat("0.0");
        object2 = ((NumberFormat)object2).format(this.getAvgConPoolStorage(n));
        rssRun.printMessage("  Simulation Average " + string + " Storage: " + (String)object2 + " " + string4);
        string5 = this.getStartCritDate(n);
        string6 = this.getEndCritDate(n);
        String string7 = this.getMinCritDate(n);
        object2 = decimalFormat.format(this.getMinStorage(n));
        rssRun.printMessage("  Critical Period: " + string5 + " to " + string6);
        rssRun.printMessage("  Minimum " + string + " Storage on " + string7 + " is " + (String)object2 + " " + string4);
        object2 = decimalFormat.format(this.getLowerLimitStor());
        string5 = decimalFormat.format(this.getStorageTol());
        rssRun.printMessage("  Lower Limit of " + string + " Storage: " + (String)object2 + " " + string4 + "; Storage Tolerance = " + string5 + " " + string4);
        object2 = decimalFormat.format(this.getMaxDemandShortage(n));
        string5 = decimalFormat.format(this.getLimitingRuleTol(n));
        object = ((YieldAnalysis)object).useHydropowerRules() ? string3 : string2;
        rssRun.printMessage("  Maximum Demand Shortage: " + (String)object2 + " " + (String)object + "; Limiting Rule Tolerance = " + string5 + " " + (String)object);
        object = this.getRuleTest(n) ? "PASS" : "FAIL";
        rssRun.printMessage("  Convergence Test: Maximum Total Demand Shortage Within Rule Tolerance: " + (String)object);
        object = this.getStorageTolTest(n) ? "PASS" : "FAIL";
        rssRun.printMessage("  Convergence Test: Minimum " + string + " Storage Within Tolerance: " + (String)object);
        if (!this.getRuleTest(n)) {
            rssRun.printMessage("  Rule test failed, increasing storage scale");
        } else if (this.getDecision(n) == 21) {
            rssRun.printMessage("  Minimum Storage At or Below Zero, increasing storage scale");
        } else if (this.getDecision(n) == 22) {
            rssRun.printMessage("  Minimum Storage Above Tolerance, decreasing storage scale");
        } else {
            rssRun.printMessage(" ");
            object2 = decimalFormat.format(this.getAvgConPoolStorage(n));
            rssRun.printMessage("Yield Analysis Compute " + n + " converged with Average " + string + " Storage = " + (String)object2 + " " + string4);
        }
        rssRun.printMessage(" ");
    }

    public String getStartCritDate(int n) {
        if (n <= 0 || n > this.getTotalIterations()) {
            return null;
        }
        n = this.getStartCritPeriod(n);
        return YieldAnalysisData.intMinToString(n);
    }

    public String getMinCritDate(int n) {
        if (n <= 0 || n > this.getTotalIterations()) {
            return null;
        }
        n = this.getMinCritPeriod(n);
        return YieldAnalysisData.intMinToString(n);
    }

    public String getEndCritDate(int n) {
        if (n <= 0 || n > this.getTotalIterations()) {
            return null;
        }
        n = this.getEndCritPeriod(n);
        return YieldAnalysisData.intMinToString(n);
    }

    public static String intMinToString(int n) {
        HecTime hecTime = new HecTime();
        hecTime.set(n);
        String string = hecTime.date(4);
        return string;
    }

    public Object clone() {
        try {
            YieldAnalysisData yieldAnalysisData = (YieldAnalysisData)super.clone();
            if (this.f != null) {
                int n = this.f.length;
                yieldAnalysisData.initializeOutputArrays(n);
                yieldAnalysisData.f = Arrays.copyOf(this.f, n);
                yieldAnalysisData.g = Arrays.copyOf(this.g, n);
                yieldAnalysisData.i = Arrays.copyOf(this.i, n);
                yieldAnalysisData.h = Arrays.copyOf(this.h, n);
                yieldAnalysisData.j = Arrays.copyOf(this.j, n);
                yieldAnalysisData.k = Arrays.copyOf(this.k, n);
                yieldAnalysisData.l = Arrays.copyOf(this.l, n);
                yieldAnalysisData.m = Arrays.copyOf(this.m, n);
                yieldAnalysisData.n = Arrays.copyOf(this.n, n);
                yieldAnalysisData.o = Arrays.copyOf(this.o, n);
                yieldAnalysisData.p = Arrays.copyOf(this.p, n);
                yieldAnalysisData.q = Arrays.copyOf(this.q, n);
                yieldAnalysisData.r = Arrays.copyOf(this.r, n);
                yieldAnalysisData.s = Arrays.copyOf(this.s, n);
                yieldAnalysisData.t = Arrays.copyOf(this.t, n);
                yieldAnalysisData.u = Arrays.copyOf(this.u, n);
                yieldAnalysisData.v = Arrays.copyOf(this.v, n);
                yieldAnalysisData.w = Arrays.copyOf(this.w, n);
                yieldAnalysisData.x = Arrays.copyOf(this.x, n);
                yieldAnalysisData.y = Arrays.copyOf(this.y, n);
                yieldAnalysisData.z = Arrays.copyOf(this.z, n);
            }
            yieldAnalysisData.a = this.a;
            yieldAnalysisData.b = this.b;
            yieldAnalysisData.c = this.c;
            yieldAnalysisData.d = this.d;
            return yieldAnalysisData;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Clone Exception", cloneNotSupportedException);
            return null;
        }
    }
}

