/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.io.AsciiSerializable;
import hec.rss.model.DivertedOutletElement;
import hec.rss.model.DownstreamCntrlOpRule;
import hec.rss.model.DownstreamOp;
import hec.rss.model.DownstreamOpRule;
import hec.rss.model.Element;
import hec.rss.model.OpRule;
import hec.rss.model.OpSet;
import hec.rss.model.PumpOpRule;
import hec.rss.model.RateChangeElevLimitOpRule;
import hec.rss.model.RateChangeLimitOpRule;
import hec.rss.model.ReleaseFuncOpRule;
import hec.rss.model.ReservoirElement;
import hec.rss.model.ReverseReservoirYieldAnalysisBase;
import hec.rss.model.ReverseYieldAnalysisBase;
import hec.rss.model.RssAlt;
import hec.rss.model.RssModelVariableConstants;
import hec.rss.model.RssNode;
import hec.rss.model.RssReturnStatusConstants;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.ScheduledHydropowerOpRule;
import hec.rss.model.StorageZone;
import hec.rss.model.StorageZoneRef;
import hec.rss.model.SystemHydropowerOpRule;
import hec.rss.model.SystemHydropowerRule;
import hec.rss.model.TandemOpRule;
import hec.rss.model.WaterAccount;
import hec.rss.model.WaterAccountYieldAnalysis;
import hec.rss.model.YieldAnalysisType;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import rma.util.RMAIO;

public class YieldAnalysisRuleRef
implements AsciiSerializable,
RssModelVariableConstants,
RssReturnStatusConstants,
Cloneable {
    public static final String RULETYPE_HYDROPOWER = "Local Hydropower";
    public static final String RULETYPE_SYSHYDROPOWER = "System Hydropower";
    public static final String RULETYPE_RESMIN = "Minimum Reservoir Release";
    public static final String RULETYPE_RESSPEC = "Specified Reservoir Release";
    public static final String RULETYPE_DNSTRMMIN = "Minimum Downstream Flow";
    private boolean _initialized = false;
    private transient RssTSLocationObject a = null;
    private transient Object b = null;
    private List<StorageZoneRef> _zones = new ArrayList<StorageZoneRef>();
    private double _tolerance = 10.0;
    private String _initalizeDataString;

    public YieldAnalysisRuleRef() {
    }

    public YieldAnalysisRuleRef(RssTSLocationObject rssTSLocationObject, Object object) {
        this.a = rssTSLocationObject;
        this.b = object;
        this.rewriteInitString();
    }

    public RssTSLocationObject getRule() {
        return this.a;
    }

    public Object getRuleOwner() {
        return this.b;
    }

    public String getLocationName() {
        Object object = null;
        if (this.a instanceof DownstreamOpRule) {
            object = (DownstreamOpRule)this.a;
            int n = ((DownstreamOpRule)object).getDownstreamControlLocationID();
            if ((object = ((RssTSLocationObject)object).getSystem().getNode(n)) == null) {
                return null;
            }
            if ((object = ((RssNode)object).getUpstreamElement()) == null) {
                return null;
            }
            object = object.getName();
        } else if (this.a instanceof SystemHydropowerRule || this.a instanceof SystemHydropowerOpRule) {
            object = "System";
        } else {
            if (this.b == null) {
                return null;
            }
            if (this.a instanceof ReleaseFuncOpRule) {
                object = ((ReservoirElement)this.b).getName();
            } else if (this.a instanceof ScheduledHydropowerOpRule) {
                object = ((ReservoirElement)this.b).getName();
            }
        }
        return object;
    }

    public String getRuleName() {
        if (this.a == null) {
            return null;
        }
        return this.a.getName();
    }

    public String getRuleTypeString() {
        String string = null;
        if (this.a instanceof DownstreamOpRule) {
            string = RULETYPE_DNSTRMMIN;
        } else if (this.a instanceof ScheduledHydropowerOpRule) {
            string = RULETYPE_HYDROPOWER;
        } else if (this.a instanceof SystemHydropowerRule) {
            string = RULETYPE_SYSHYDROPOWER;
        } else if (this.a instanceof ReleaseFuncOpRule && ((ReleaseFuncOpRule)this.a).getLimitType() == -1) {
            string = RULETYPE_RESMIN;
        } else if (this.a instanceof ReleaseFuncOpRule && ((ReleaseFuncOpRule)this.a).getLimitType() == 0) {
            string = RULETYPE_RESSPEC;
        }
        return string;
    }

    public List<ReservoirElement> getReservoirList(RssAlt rssAlt) {
        ArrayList<ReservoirElement> arrayList = new ArrayList<ReservoirElement>();
        if (this.a == null) {
            return arrayList;
        }
        ((RssTSLocationObject)((OpRule)this.a)).getSystem();
        if (this.a instanceof DownstreamOpRule) {
            DownstreamOpRule downstreamOpRule = (DownstreamOpRule)this.a;
            YieldAnalysisRuleRef.a(rssAlt, ((DownstreamOp)this.b).a, downstreamOpRule, arrayList);
        } else if (this.a instanceof ScheduledHydropowerOpRule) {
            arrayList.add((ReservoirElement)this.b);
        } else if (this.a instanceof SystemHydropowerRule) {
            SystemHydropowerRule systemHydropowerRule = (SystemHydropowerRule)this.a;
            systemHydropowerRule.getReservoirs(arrayList);
        } else if (this.a instanceof ReleaseFuncOpRule) {
            arrayList.add((ReservoirElement)this.b);
        }
        return arrayList;
    }

    public static List<ReservoirElement> a(RssAlt rssAlt, RssSystem object, DownstreamOpRule downstreamOpRule, List<ReservoirElement> list) {
        if (list == null) {
            list = new ArrayList<ReservoirElement>();
        }
        if (rssAlt == null || object == null) {
            return list;
        }
        object = ((RssSystem)object).getElementVector();
        int n = object.size();
        block0: for (int i = 0; i < n; ++i) {
            Object object2 = (Element)object.get(i);
            if (!(object2 instanceof ReservoirElement)) continue;
            ReservoirElement reservoirElement = (ReservoirElement)object2;
            int n2 = rssAlt.getResOpSetSelection(object2.getIndex());
            object2 = reservoirElement.getReservoirOp().getOperationSet(n2);
            if (object2 == null) continue;
            object2 = ((OpSet)object2).getRules(null);
            int n3 = object2.size();
            for (int j = 0; j < n3; ++j) {
                OpRule opRule = (OpRule)object2.get(j);
                if (!(opRule instanceof DownstreamCntrlOpRule) || !downstreamOpRule.getName().equals(opRule.getName()) || downstreamOpRule.getIndex() != ((DownstreamCntrlOpRule)opRule).getParentRule().getIndex() || downstreamOpRule.getDownstreamControlLocationID() != ((DownstreamCntrlOpRule)opRule).getParentRule().getDownstreamControlLocationID() || list.contains(reservoirElement)) continue;
                list.add(reservoirElement);
                continue block0;
            }
        }
        return list;
    }

    public void writeDataToFile(BufferedWriter bufferedWriter) {
        if (bufferedWriter == null) {
            return;
        }
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)"YieldAnalysisRuleRefBegin");
        this._initalizeDataString = "";
        if (this.b instanceof ReservoirElement) {
            var2_2 = (ReservoirElement)this.b;
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Reservoir=" + var2_2.getIndex() + ":" + var2_2.getName()));
            this._initalizeDataString = "Reservoir=" + var2_2.getIndex() + ":" + var2_2.getName() + "\n";
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Rule=" + this.a.getIndex() + ":" + this.a.getName() + ":" + ((OpRule)this.a).getController().getIndex()));
            this._initalizeDataString = this._initalizeDataString + "Rule=" + this.a.getIndex() + ":" + this.a.getName() + ":" + ((OpRule)this.a).getController().getIndex() + "\n";
        } else if (this.b instanceof DownstreamOp) {
            var2_2 = (DownstreamOpRule)this.a;
            if (var2_2 != null) {
                RMAIO.fout((BufferedWriter)bufferedWriter, (String)("DownstreamRule=" + var2_2.getDownstreamControlLocationID() + ":" + var2_2.getIndex()));
                this._initalizeDataString = this._initalizeDataString + "DownstreamRule=" + var2_2.getDownstreamControlLocationID() + ":" + var2_2.getIndex() + "\n";
            }
        } else if (this.b == null && this.a instanceof SystemHydropowerOpRule) {
            var2_2 = (SystemHydropowerOpRule)this.a;
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("SystemHydroRule=" + var2_2.getIndex() + ":" + var2_2.getName()));
            this._initalizeDataString = this._initalizeDataString + "SystemHydroRule=" + var2_2.getIndex() + ":" + var2_2.getName() + "\n";
        }
        for (int i = 0; i < this._zones.size(); ++i) {
            this._initalizeDataString = this._zones.get(i).writeData(bufferedWriter, this._initalizeDataString);
        }
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Tolerance=" + this._tolerance));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)"YieldAnalysisRuleRefEnd");
    }

    public void readFile(BufferedReader bufferedReader) {
        this._initalizeDataString = new String();
        StringWriter stringWriter = new StringWriter();
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                stringWriter.getBuffer().append(string);
                if (string.startsWith("YieldAnalysisRuleRefEnd")) {
                    this._initalizeDataString = stringWriter.getBuffer().toString();
                    return;
                }
                if (string.startsWith("Tolerance")) {
                    int n = string.indexOf(61);
                    string = string.substring(n + 1);
                    this.setTolerence(Double.parseDouble(string));
                }
                stringWriter.getBuffer().append("\n");
            }
        }
        catch (IOException iOException) {
            System.out.println("readDataFromFile:error reading FirmYieldRuleRef " + String.valueOf(iOException));
        }
        this._initialized = false;
    }

    public boolean isInitialized() {
        return this._initialized;
    }

    public void initializeData(RssSystem rssSystem) {
        if (this._initalizeDataString == null) {
            this._initalizeDataString = new String();
        }
        Reader reader = new StringReader(this._initalizeDataString);
        reader = new BufferedReader(reader);
        this.initializeData(rssSystem, (BufferedReader)reader);
    }

    public void initializeDataForCompute(RssAlt rssAlt) {
        Cloneable cloneable;
        Iterator<WaterAccount> iterator;
        Object object;
        Object object2;
        if (this._initalizeDataString == null) {
            this._initalizeDataString = new String();
        }
        Object object3 = new StringReader(this._initalizeDataString);
        object3 = new BufferedReader((Reader)object3);
        this.initializeData(rssAlt.getSystem(), (BufferedReader)object3);
        if (rssAlt.getSelectedYieldAnalysis() == YieldAnalysisType.WATER_ACCOUNT && rssAlt.getWaterAccountYieldAnalysis() != null) {
            object3 = rssAlt.getWaterAccountYieldAnalysis();
            object2 = ((WaterAccountYieldAnalysis)object3).d();
            if (object2 == null) {
                int n = ((WaterAccountYieldAnalysis)object3).c();
                object = rssAlt.getWaterAccountSet().getWaterAccounts();
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    cloneable = iterator.next();
                    if (n != ((WaterAccount)cloneable).getIndex()) continue;
                    object2 = cloneable;
                    break;
                }
            }
            ((WaterAccountYieldAnalysis)object3).a((WaterAccount)object2);
        }
        if (rssAlt.getWaterAccountSet() != null) {
            object3 = this.getReservoirList(rssAlt);
            object2 = rssAlt.getWaterAccountSet().getResZoneRefs();
            this._zones.clear();
            Iterator iterator2 = object3.iterator();
            while (iterator2.hasNext()) {
                object = (ReservoirElement)iterator2.next();
                iterator = object2.iterator();
                while (iterator.hasNext()) {
                    cloneable = (StorageZoneRef)((Object)iterator.next());
                    if (object.getIndex() != ((StorageZoneRef)cloneable).getReservoirIndex()) continue;
                    object3 = cloneable;
                    ((StorageZoneRef)object3).setZone((ReservoirElement)object);
                    this._zones.add((StorageZoneRef)cloneable);
                }
            }
        }
        if (rssAlt.getSelectedYieldAnalysis() == YieldAnalysisType.RESERVOIR_STORAGE_VS_YIELD_ANALYSIS && rssAlt.getReservoirStorageVsYieldAnalysis() != null) {
            object3 = rssAlt.getReservoirStorageVsYieldAnalysis();
            object2 = ((ReverseReservoirYieldAnalysisBase)object3).m();
            StorageZoneRef storageZoneRef = new StorageZoneRef((StorageZone)object2);
            storageZoneRef.setTolerance(((ReverseYieldAnalysisBase)object3).p().getValue());
            storageZoneRef.setZoneIndex(object2.getIndex());
            storageZoneRef.setReservoirIndex(((StorageZone)object2).getReservoirElement().getIndex());
            storageZoneRef.setZone(((StorageZone)object2).getReservoirElement());
            this._zones.clear();
            this._zones.add(storageZoneRef);
        }
    }

    private void initializeData(RssSystem rssSystem, BufferedReader bufferedReader) {
        try {
            String string;
            this._zones = new ArrayList<StorageZoneRef>();
            block2: while ((string = bufferedReader.readLine()) != null) {
                Object object;
                if (string.startsWith("YieldAnalysisRuleRefEnd")) {
                    this._initialized = true;
                    return;
                }
                Object object2 = RMAIO.getType((String)string, (String)"=");
                if ("Reservoir".equalsIgnoreCase((String)object2)) {
                    string = RMAIO.getParam((String)string, (String)"=");
                    int n = RMAIO.parseInt((String)RMAIO.getType((String)string, (String)":"));
                    if (rssSystem == null) continue;
                    this.b = rssSystem.getElement(n);
                    continue;
                }
                if ("Rule".equalsIgnoreCase((String)object2)) {
                    OpRule opRule;
                    int n;
                    string = RMAIO.getParam((String)string, (String)"=");
                    object2 = new StringTokenizer(string, ":");
                    int n2 = Integer.MIN_VALUE;
                    object = "";
                    int n3 = Integer.MIN_VALUE;
                    if (((StringTokenizer)object2).hasMoreTokens()) {
                        n2 = RMAIO.parseInt((String)((StringTokenizer)object2).nextToken());
                    }
                    if (((StringTokenizer)object2).hasMoreTokens()) {
                        object = ((StringTokenizer)object2).nextToken();
                    }
                    if (((StringTokenizer)object2).hasMoreTokens()) {
                        n3 = RMAIO.parseInt((String)((StringTokenizer)object2).nextToken());
                    }
                    if (!(this.b instanceof ReservoirElement)) continue;
                    object2 = (ReservoirElement)this.b;
                    object2 = ((ReservoirElement)object2).getReservoirOp().getRules();
                    for (n = 0; n < object2.size(); ++n) {
                        opRule = (OpRule)object2.get(n);
                        if (opRule.getIndex() != n2 || opRule.getController().getIndex() != n3) continue;
                        this.a = opRule;
                        break;
                    }
                    if (this.a != null) continue;
                    for (n = 0; n < object2.size(); ++n) {
                        opRule = (OpRule)object2.get(n);
                        if (!((String)object).equals(opRule.getName())) continue;
                        this.a = opRule;
                        continue block2;
                    }
                    continue;
                }
                if ("SystemHydroRule".equalsIgnoreCase((String)object2)) {
                    string = RMAIO.getParam((String)string, (String)"=");
                    int n = RMAIO.parseInt((String)RMAIO.getType((String)string, (String)":"));
                    string = RMAIO.getParam((String)string, (String)":");
                    if (rssSystem == null) continue;
                    this.a = rssSystem.getSystemHydropowerRule(string);
                    if (this.a != null) continue;
                    this.a = rssSystem.getSystemHydropowerRule(n);
                    continue;
                }
                if ("StorageZone".equalsIgnoreCase((String)object2)) {
                    object2 = new StorageZoneRef();
                    if (!((StorageZoneRef)object2).parseData(rssSystem, string = RMAIO.getParam((String)string, (String)"="))) continue;
                    this._zones.add((StorageZoneRef)object2);
                    continue;
                }
                if ("DownstreamRule".equalsIgnoreCase((String)object2)) {
                    string = RMAIO.getParam((String)string, (String)"=");
                    int n = RMAIO.parseInt((String)RMAIO.getType((String)string, (String)":"));
                    int n4 = RMAIO.parseInt((String)RMAIO.getParam((String)string, (String)":"));
                    if (rssSystem == null) continue;
                    this.b = object = rssSystem.getDownstreamOp(n);
                    if (object == null) continue;
                    this.a = ((DownstreamOp)object).getDownstreamOpRule(n4);
                    continue;
                }
                if (!"Tolerance".equals(object2)) continue;
                string = RMAIO.getParam((String)string, (String)"=");
                this._tolerance = Double.parseDouble(string);
            }
            this._initialized = true;
            return;
        }
        catch (IOException iOException) {
            System.out.println("readDataFromFile:error reading FirmYieldRuleRef " + String.valueOf(iOException));
            this._initialized = false;
            return;
        }
    }

    public static List<YieldAnalysisRuleRef> a(RssAlt rssAlt, RssSystem rssSystem, boolean bl) {
        ArrayList<YieldAnalysisRuleRef> arrayList = new ArrayList<YieldAnalysisRuleRef>();
        if (rssAlt == null || rssSystem == null) {
            return arrayList;
        }
        Vector vector = rssSystem.getElementVector();
        int n = vector.size();
        ArrayList<OpRule> arrayList2 = new ArrayList<OpRule>();
        ArrayList<OpRule> arrayList3 = new ArrayList<OpRule>();
        for (int i = 0; i < n; ++i) {
            Object object = (Element)vector.get(i);
            if (!(object instanceof ReservoirElement)) continue;
            ReservoirElement reservoirElement = (ReservoirElement)object;
            int n2 = rssAlt.getResOpSetSelection(object.getIndex());
            object = reservoirElement.getReservoirOp().getOperationSet(n2);
            if (object == null) continue;
            object = ((OpSet)object).getRules(null);
            int n3 = object.size();
            for (int j = 0; j < n3; ++j) {
                OpRule opRule = (OpRule)object.get(j);
                if (opRule instanceof ScheduledHydropowerOpRule && !bl) {
                    arrayList.add(new YieldAnalysisRuleRef(opRule, reservoirElement));
                    continue;
                }
                if (opRule instanceof SystemHydropowerOpRule && !bl) {
                    if (arrayList3.contains(opRule = ((SystemHydropowerOpRule)opRule).getParentRule())) continue;
                    arrayList.add(new YieldAnalysisRuleRef(opRule, null));
                    arrayList3.add(opRule);
                    continue;
                }
                if (opRule instanceof DownstreamCntrlOpRule && bl) {
                    if ((opRule = ((DownstreamCntrlOpRule)opRule).getParentRule()) == null || arrayList2.contains(opRule) || ((ReleaseFuncOpRule)opRule).getLimitType() != -1) continue;
                    DownstreamOp downstreamOp = rssSystem.getDownstreamOp(((DownstreamOpRule)opRule).getDownstreamControlLocationID());
                    opRule.setSystem(rssSystem);
                    downstreamOp.setSystem(rssSystem);
                    arrayList.add(new YieldAnalysisRuleRef(opRule, downstreamOp));
                    arrayList2.add(opRule);
                    continue;
                }
                if (!(opRule instanceof ReleaseFuncOpRule) || !bl || ((ReleaseFuncOpRule)(opRule = (ReleaseFuncOpRule)opRule)).getLimitType() != -1 && ((ReleaseFuncOpRule)opRule).getLimitType() != 0) continue;
                arrayList.add(new YieldAnalysisRuleRef(opRule, reservoirElement));
            }
        }
        arrayList2.clear();
        arrayList3.clear();
        return arrayList;
    }

    public static List<YieldAnalysisRuleRef> a(ReservoirElement reservoirElement, OpSet object) {
        ArrayList<YieldAnalysisRuleRef> arrayList = new ArrayList<YieldAnalysisRuleRef>();
        ArrayList<OpRule> arrayList2 = new ArrayList<OpRule>();
        ArrayList<OpRule> arrayList3 = new ArrayList<OpRule>();
        object = ((OpSet)object).getRules(null);
        int n = object.size();
        for (int i = 0; i < n; ++i) {
            OpRule opRule = (OpRule)object.get(i);
            if (opRule instanceof ScheduledHydropowerOpRule) {
                arrayList.add(new YieldAnalysisRuleRef(opRule, reservoirElement));
                continue;
            }
            if (opRule instanceof SystemHydropowerOpRule) {
                if (arrayList3.contains(opRule = ((SystemHydropowerOpRule)opRule).getParentRule())) continue;
                arrayList.add(new YieldAnalysisRuleRef(opRule, null));
                arrayList3.add(opRule);
                continue;
            }
            if (opRule instanceof SystemHydropowerRule) {
                if (arrayList3.contains(opRule = (SystemHydropowerRule)opRule)) continue;
                arrayList.add(new YieldAnalysisRuleRef(opRule, null));
                arrayList3.add(opRule);
                continue;
            }
            if (opRule instanceof DownstreamCntrlOpRule) {
                if ((opRule = ((DownstreamCntrlOpRule)opRule).getParentRule()) == null || arrayList2.contains(opRule) || ((ReleaseFuncOpRule)opRule).getLimitType() != -1) continue;
                DownstreamOp downstreamOp = reservoirElement.getSystem().getDownstreamOp(((DownstreamOpRule)opRule).getDownstreamControlLocationID());
                opRule.setSystem(reservoirElement.getSystem());
                downstreamOp.setSystem(reservoirElement.getSystem());
                arrayList.add(new YieldAnalysisRuleRef(opRule, downstreamOp));
                arrayList2.add(opRule);
                continue;
            }
            if (!(opRule instanceof ReleaseFuncOpRule) || ((ReleaseFuncOpRule)(opRule = (ReleaseFuncOpRule)opRule)).getLimitType() != -1 && ((ReleaseFuncOpRule)opRule).getLimitType() != 0) continue;
            arrayList.add(new YieldAnalysisRuleRef(opRule, reservoirElement));
        }
        arrayList2.clear();
        arrayList3.clear();
        return arrayList;
    }

    public static List<YieldAnalysisRuleRef> b(ReservoirElement reservoirElement, OpSet object) {
        ArrayList<YieldAnalysisRuleRef> arrayList = new ArrayList<YieldAnalysisRuleRef>();
        object = ((OpSet)object).getRules(null);
        int n = object.size();
        for (int i = 0; i < n; ++i) {
            OpRule opRule;
            RssModelVariableConstants rssModelVariableConstants = (OpRule)object.get(i);
            if (rssModelVariableConstants instanceof ScheduledHydropowerOpRule) {
                arrayList.add(new YieldAnalysisRuleRef((RssTSLocationObject)rssModelVariableConstants, reservoirElement));
                continue;
            }
            if (rssModelVariableConstants instanceof SystemHydropowerOpRule) {
                arrayList.add(new YieldAnalysisRuleRef((RssTSLocationObject)rssModelVariableConstants, reservoirElement));
                continue;
            }
            if (rssModelVariableConstants instanceof RateChangeElevLimitOpRule) {
                opRule = (RateChangeElevLimitOpRule)rssModelVariableConstants;
                if (((RateChangeElevLimitOpRule)opRule).getType() != 1) continue;
                arrayList.add(new YieldAnalysisRuleRef((RssTSLocationObject)rssModelVariableConstants, reservoirElement));
                continue;
            }
            if (rssModelVariableConstants instanceof RateChangeLimitOpRule) {
                opRule = (RateChangeLimitOpRule)rssModelVariableConstants;
                if (((RateChangeLimitOpRule)opRule).getType() != 0) continue;
                arrayList.add(new YieldAnalysisRuleRef((RssTSLocationObject)rssModelVariableConstants, reservoirElement));
                continue;
            }
            if (rssModelVariableConstants instanceof TandemOpRule) {
                arrayList.add(new YieldAnalysisRuleRef((RssTSLocationObject)rssModelVariableConstants, reservoirElement));
                continue;
            }
            if (rssModelVariableConstants instanceof DownstreamCntrlOpRule) {
                opRule = ((DownstreamCntrlOpRule)rssModelVariableConstants).getParentRule();
                if (opRule == null || ((ReleaseFuncOpRule)opRule).getLimitType() != -1) continue;
                rssModelVariableConstants = reservoirElement.getSystem().getDownstreamOp(((DownstreamOpRule)opRule).getDownstreamControlLocationID());
                opRule.setSystem(reservoirElement.getSystem());
                ((DownstreamOp)rssModelVariableConstants).setSystem(reservoirElement.getSystem());
                arrayList.add(new YieldAnalysisRuleRef(opRule, rssModelVariableConstants));
                continue;
            }
            if (rssModelVariableConstants instanceof ReleaseFuncOpRule) {
                opRule = (ReleaseFuncOpRule)rssModelVariableConstants;
                int n2 = ((ReleaseFuncOpRule)opRule).getLimitType();
                if (n2 != -1 && n2 != 0) continue;
                arrayList.add(new YieldAnalysisRuleRef(opRule, reservoirElement));
                continue;
            }
            if (!(rssModelVariableConstants instanceof PumpOpRule)) continue;
            arrayList.add(new YieldAnalysisRuleRef((RssTSLocationObject)rssModelVariableConstants, reservoirElement));
        }
        return arrayList;
    }

    public StorageZone getZoneForReservoir(ReservoirElement reservoirElement) {
        int n = this._zones.size();
        for (int i = 0; i < n; ++i) {
            Cloneable cloneable = this._zones.get(i);
            cloneable = cloneable.getStorageZone();
            Object object = ((StorageZone)cloneable).getOpSet();
            if ((object = ((OpSet)object).getElementOp().getOperationsElement()) != reservoirElement) continue;
            return cloneable;
        }
        return null;
    }

    public double getTolerance() {
        return this._tolerance;
    }

    public double getResTolerance(int n) {
        for (StorageZoneRef storageZoneRef : this._zones) {
            if (storageZoneRef.getReservoirIndex() != n) continue;
            return storageZoneRef.getTolerance();
        }
        return -3.4028234663852886E38;
    }

    public void setTolerence(double d) {
        this._tolerance = d;
    }

    public String toString() {
        return this.getLocationName();
    }

    public void setZones(List<StorageZoneRef> list) {
        this._zones.clear();
        this._zones.addAll(list);
    }

    public List<StorageZoneRef> getZones() {
        return this._zones;
    }

    public void initCompute(RssAlt rssAlt) {
        this.updateRule(rssAlt);
        if (this._zones != null) {
            int n = this._zones.size();
            for (int i = 0; i < n; ++i) {
                StorageZoneRef storageZoneRef = this._zones.get(i);
                storageZoneRef.updateZone(rssAlt);
            }
        }
    }

    private void updateRule(RssAlt object) {
        if (this.a == null || this.b == null) {
            return;
        }
        if (this.a instanceof SystemHydropowerRule) {
            String string = ((SystemHydropowerRule)this.a).getName();
            int n = ((SystemHydropowerRule)this.a).getIndex();
            this.a = ((RssAlt)object).getSystem().getSystemHydropowerRule(string);
            if (this.a == null) {
                this.a = ((RssAlt)object).getSystem().getSystemHydropowerRule(n);
            }
            return;
        }
        if (this.a instanceof DownstreamOpRule) {
            int n = ((DownstreamOpRule)this.a).getDownstreamControlLocationID();
            int n2 = ((DownstreamOpRule)this.a).getIndex();
            this.b = object = ((RssAlt)object).getSystem().getDownstreamOp(n);
            if (object != null) {
                this.a = ((DownstreamOp)object).getDownstreamOpRule(n2);
            }
            return;
        }
        if (this.a instanceof OpRule && this.b instanceof ReservoirElement) {
            OpRule opRule;
            int n;
            int n3 = ((OpRule)this.a).getIndex();
            String string = ((OpRule)this.a).getName();
            object = (ReservoirElement)this.b;
            object = ((ReservoirElement)object).getReservoirOp().getRules();
            for (n = 0; n < object.size(); ++n) {
                opRule = (OpRule)object.get(n);
                if (opRule.getIndex() != n3) continue;
                this.a = opRule;
                break;
            }
            if (this.a == null) {
                for (n = 0; n < object.size(); ++n) {
                    opRule = (OpRule)object.get(n);
                    if (!string.equals(opRule.getName())) continue;
                    this.a = opRule;
                    return;
                }
            }
        }
    }

    public Object clone() {
        try {
            YieldAnalysisRuleRef yieldAnalysisRuleRef = (YieldAnalysisRuleRef)super.clone();
            if (this.getZones().size() > 0) {
                this.rewriteInitString();
            }
            yieldAnalysisRuleRef._initalizeDataString = this._initalizeDataString;
            yieldAnalysisRuleRef._tolerance = this._tolerance;
            return yieldAnalysisRuleRef;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println(cloneNotSupportedException);
            return null;
        }
    }

    public void rewriteInitString() {
        this._initalizeDataString = "";
        if (this.b instanceof ReservoirElement) {
            var1_1 = (ReservoirElement)this.b;
            this._initalizeDataString = "Reservoir=" + var1_1.getIndex() + ":" + var1_1.getName() + "\n";
            this._initalizeDataString = this.a instanceof OpRule ? this._initalizeDataString + "Rule=" + this.a.getIndex() + ":" + this.a.getName() + ":" + ((OpRule)this.a).getController().getIndex() + "\n" : this._initalizeDataString + "Rule=" + this.a.getIndex() + ":" + this.a.getName() + "\n";
        } else if (this.b instanceof DownstreamOp) {
            var1_1 = (DownstreamOpRule)this.a;
            DownstreamOp cfr_ignored_0 = (DownstreamOp)this.b;
            if (var1_1 != null) {
                this._initalizeDataString = this._initalizeDataString + "DownstreamRule=" + var1_1.getDownstreamControlLocationID() + ":" + var1_1.getIndex() + "\n";
            }
        } else if (this.b instanceof DivertedOutletElement) {
            var1_1 = (DivertedOutletElement)this.b;
            this._initalizeDataString = this._initalizeDataString + "Diversion=" + var1_1.getIndex() + ":" + var1_1.getName() + "\n";
            this._initalizeDataString = this._initalizeDataString + "Rule=" + this.a.getIndex() + ":" + this.a.getName() + "\n";
        } else if (this.b == null && this.a instanceof SystemHydropowerOpRule) {
            var1_1 = ((SystemHydropowerOpRule)this.a).getParentRule();
            this._initalizeDataString = this._initalizeDataString + "SystemHydroRule=" + var1_1.getIndex() + ":" + var1_1.getName() + "\n";
        } else if (this.b == null && this.a instanceof SystemHydropowerRule) {
            var1_1 = (SystemHydropowerRule)this.a;
            this._initalizeDataString = this._initalizeDataString + "SystemHydroRule=" + var1_1.getIndex() + ":" + var1_1.getName() + "\n";
        }
        for (int i = 0; i < this._zones.size(); ++i) {
            this._initalizeDataString = this._zones.get(i).writeInitString(this._initalizeDataString);
        }
    }

    public Object getFieldObject(Field object) {
        try {
            object = ((Field)object).get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }
}

