/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model.dependencies;

import hec.rss.model.RssSystem;
import hec.rss.model.StateVariable;
import hec.rss.model.dependencies.AstCatalog;
import hec.rss.model.dependencies.AstMatcher;
import hec.rss.model.dependencies.CurrentSVRef;
import hec.rss.model.dependencies.Dependency;
import hec.rss.model.dependencies.Dependency$DependencyType;
import hec.rss.model.dependencies.Helpers;
import hec.rss.model.dependencies.InputTsValRef;
import hec.rss.model.dependencies.LocalFlowTimeSeriesMatcher;
import hec.rss.model.dependencies.OutputTsValRef;
import hec.rss.model.dependencies.TsValRef;
import hec.rss.model.dependencies.matchers.InputValMatcher;
import hec.rss.model.dependencies.matchers.NetworkJunctionMatcher;
import hec.rss.model.dependencies.matchers.NetworkTSMatcher;
import hec.rss.model.dependencies.matchers.SetValueMatcher;
import hec.rss.model.dependencies.matchers.StateVarLocalTsMatcher;
import hec.rss.model.dependencies.matchers.StateVarMatcher;
import hec.rss.model.dependencies.matchers.StateVarSetValMatcher;
import hec.rss.model.dependencies.matchers.StateVarTsMatcher;
import hec.rss.model.dependencies.matchers.StateVarValMatcher;
import hec.rss.model.dependencies.matchers.StateVarVarGetMatcher;
import hec.rss.model.dependencies.matchers.StateVarVarPutMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.python.antlr.PythonTree;
import org.python.antlr.Visitor;
import org.python.antlr.ast.Assign;
import org.python.antlr.ast.Call;
import org.python.antlr.ast.Name;
import org.python.antlr.op.Load;
import org.python.antlr.op.Store;
import org.python.core.PyObject;
import org.python.core.PyObjectDerived;

public class AstVisitor
extends Visitor {
    private static final Logger logger = Logger.getLogger(AstVisitor.class.getName());
    List<AstMatcher> matchers = new ArrayList<AstMatcher>();
    AstCatalog catalog = new AstCatalog();
    Map<String, Object> env = new HashMap<String, Object>();

    public AstVisitor(Map<String, Object> map) {
        this.env = map;
        this.resetMatchers();
    }

    public AstVisitor() {
        this.resetMatchers();
    }

    public void resetMatchers() {
        Object object = this.env.get("network");
        this.matchers.clear();
        this.matchers.add(new NetworkTSMatcher());
        this.matchers.add(new StateVarMatcher((RssSystem)object));
        this.matchers.add(new StateVarTsMatcher());
        this.matchers.add(new InputValMatcher());
        this.matchers.add(new SetValueMatcher());
        this.matchers.add(new StateVarVarGetMatcher());
        this.matchers.add(new StateVarVarPutMatcher());
        this.matchers.add(new StateVarLocalTsMatcher());
        this.matchers.add(new StateVarValMatcher());
        this.matchers.add(new StateVarSetValMatcher());
        this.matchers.add(new StateVarLocalTsMatcher());
        this.matchers.add(new NetworkJunctionMatcher());
        this.matchers.add(new LocalFlowTimeSeriesMatcher());
        object = AstVisitor.getCatalogKey("currentVariable");
        this.catalog.a(object, new CurrentSVRef((StateVariable)this.env.get("currentVariable")));
    }

    public void setEnvironment(Object map) {
        if (map instanceof Map) {
            map = map;
        } else if (map instanceof PyObjectDerived) {
            map = (PyObjectDerived)map;
            map = (Map)map.__tojava__(Map.class);
        } else if (map == null) {
            map = new LinkedHashMap();
        } else {
            logger.log(Level.WARNING, "Unexpected environment object:{0} class:{1}", new Object[]{map, map.getClass()});
            map = new LinkedHashMap();
        }
        this.env = map;
        this.resetMatchers();
    }

    public Object visitCall(Call call) throws Exception {
        Object object = super.visitCall(call);
        this.checkMatchers((PythonTree)call);
        return object;
    }

    public Object visitName(Name name) throws Exception {
        Object object = super.visitName(name);
        Object object2 = AstVisitor.getCatalogKey(name);
        PyObject pyObject = name.getCtx();
        if (pyObject instanceof Load && (object2 = this.catalog.a(object2)) != null) {
            this.catalog.a((Object)name, object2);
        }
        return object;
    }

    public static String getCatalogKey(Name name) {
        return AstVisitor.getCatalogKey(Helpers.b(name.getId()));
    }

    public static String getCatalogKey(String string) {
        return "Name:" + string;
    }

    public Object visitAssign(Assign object) throws Exception {
        Object object2 = super.visitAssign((Assign)object);
        PyObject pyObject = object.getValue();
        if ((object = object.getTargets()) instanceof List) {
            object = (List)object;
            object = object.iterator();
            while (object.hasNext()) {
                Object object3 = object.next();
                if (!(object3 instanceof Name)) continue;
                object3 = (Name)object3;
                String string = AstVisitor.getCatalogKey((Name)object3);
                if (!((object3 = object3.getCtx()) instanceof Store) || (object3 = this.catalog.a(pyObject)) == null) continue;
                this.catalog.a((Object)string, object3);
            }
        }
        return object2;
    }

    private void checkMatchers(PythonTree pythonTree) {
        for (AstMatcher astMatcher : this.matchers) {
            astMatcher.match(pythonTree, this.catalog);
        }
    }

    public Collection<Dependency> getInputDeps() {
        LinkedHashSet<Dependency> linkedHashSet = new LinkedHashSet<Dependency>();
        Object object = this.catalog.a(InputTsValRef.class);
        object = object.iterator();
        while (object.hasNext()) {
            Cloneable cloneable = (InputTsValRef)object.next();
            cloneable = new Dependency((TsValRef)cloneable, Dependency$DependencyType.INPUT);
            linkedHashSet.add((Dependency)cloneable);
        }
        return linkedHashSet;
    }

    public Collection<Dependency> getOutputDeps() {
        LinkedHashSet<Dependency> linkedHashSet = new LinkedHashSet<Dependency>();
        Object object = this.catalog.a(OutputTsValRef.class);
        object = object.iterator();
        while (object.hasNext()) {
            Cloneable cloneable = (OutputTsValRef)object.next();
            cloneable = new Dependency((TsValRef)cloneable, Dependency$DependencyType.OUTPUT);
            linkedHashSet.add((Dependency)cloneable);
        }
        return linkedHashSet;
    }
}

