/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model.engine.UI;

import hec.rss.model.engine.RSRuleLimit;
import hec.rss.model.engine.RSRuleLimit$RULE_TYPE;
import hec.rss.model.engine.UI.RSEngineTSViewerFrame;
import hec.rss.model.engine.UI.RSEngineTSViewerPanel$1;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import rma.swing.RmaJPanel;
import rma.util.RMAIO;

public class RSEngineTSViewerPanel
extends RmaJPanel
implements MouseListener,
MouseMotionListener,
Runnable {
    public static final int CELL_X_MIN = 50;
    public static final int CELL_Y_MIN = 20;
    RSEngineTSViewerFrame _frame;
    String _resultFileName;
    int _commandCount;
    int _numSteps;
    int _tsCount;
    List<String> _tsNameList;
    List<ArrayList<Double>[]> _valueList;
    List<ArrayList<RSRuleLimit[]>[]> _limitList;
    Map<String, Integer> _tsMap;
    List<String> _lineList;
    boolean _isAnimating = false;
    int _drawStep = 0;
    Thread _animationThread = null;
    private int _curStep = -1;
    private String _currentTSName;
    private int _plotPanelWidth = 200;
    private int _currentTimeStep;
    private int _plotTSId;
    private int _plotStepId;
    private transient Dimension a;
    private transient int b = 0;
    private transient int c = 0;
    private transient int d;
    private transient int e;
    private transient int f;
    private transient int g;

    public RSEngineTSViewerPanel() {
        RSEngineTSViewerPanel rSEngineTSViewerPanel = this;
        rSEngineTSViewerPanel.addMouseListener(rSEngineTSViewerPanel);
        RSEngineTSViewerPanel rSEngineTSViewerPanel2 = this;
        rSEngineTSViewerPanel2.addMouseMotionListener(rSEngineTSViewerPanel2);
        this.addComponentListener(new RSEngineTSViewerPanel$1(this));
        this.loadFile("ResSimTSHist.txt");
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (this._isAnimating) {
            return null;
        }
        Dimension dimension = new Dimension();
        Dimension dimension2 = new Dimension();
        Dimension dimension3 = new Dimension();
        this.getDrawDimensions(dimension, dimension2, dimension3);
        int n = dimension2.width;
        int n2 = mouseEvent.getX() / n - 1 + this.b;
        if (n2 < 0 || n2 >= this._tsNameList.size()) {
            return null;
        }
        return this._tsNameList.get(n2);
    }

    public void setViewerFrame(RSEngineTSViewerFrame rSEngineTSViewerFrame) {
        this._frame = rSEngineTSViewerFrame;
    }

    void loadFile(String object) {
        this._resultFileName = object;
        object = new File((String)object);
        this._commandCount = 0;
        this._numSteps = 0;
        this._tsCount = 0;
        this._tsNameList = new ArrayList<String>();
        this._valueList = new ArrayList<ArrayList<Double>[]>();
        this._limitList = new ArrayList<ArrayList<RSRuleLimit[]>[]>();
        this._tsMap = new HashMap<String, Integer>();
        this._lineList = new ArrayList<String>();
        try {
            object = new BufferedReader(new FileReader((File)object));
            try {
                ((BufferedReader)object).readLine();
                Object object2 = ((BufferedReader)object).readLine();
                while (object2 != null && ((String)object2).length() > 0) {
                    StringTokenizer stringTokenizer = new StringTokenizer((String)object2, "\t");
                    String string = stringTokenizer.nextToken();
                    int n = Integer.parseInt(stringTokenizer.nextToken());
                    this._lineList.add((String)object2);
                    ++this._commandCount;
                    if (n >= this._numSteps) {
                        this._numSteps = n + 1;
                    }
                    if ((object2 = this._tsMap.get(string)) == null) {
                        this._tsNameList.add(string);
                        this._tsMap.put(string, this._tsCount);
                        ++this._tsCount;
                    }
                    object2 = ((BufferedReader)object).readLine();
                }
                this.resetData();
            }
            finally {
                ((BufferedReader)object).close();
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    public void play() {
        if (this._isAnimating) {
            this._isAnimating = false;
            return;
        }
        if (this._curStep < 0) {
            this.resetData();
            RSEngineTSViewerPanel rSEngineTSViewerPanel = this;
            rSEngineTSViewerPanel.resetDraw(rSEngineTSViewerPanel.getGraphics());
        }
        this._isAnimating = true;
        this._animationThread = new Thread(this);
        this._animationThread.start();
    }

    @Override
    public void run() {
        if (this._curStep >= this._commandCount) {
            this._curStep = 0;
        }
        for (int i = this._curStep; i < this._commandCount && this._isAnimating; ++i) {
            this.incrDrawStep(1);
        }
        this._isAnimating = false;
    }

    private void incrDrawStep(int n) {
        int n2;
        String string;
        if (this._curStep + n < 0) {
            this.reset();
            return;
        }
        if (this._curStep + n >= this._commandCount) {
            return;
        }
        this._curStep += n;
        Object object = this._lineList.get(this._curStep);
        object = new StringTokenizer((String)object, "\t");
        this._currentTSName = string = ((StringTokenizer)object).nextToken();
        this._currentTimeStep = n2 = Integer.parseInt(((StringTokenizer)object).nextToken());
        double d = Double.parseDouble(((StringTokenizer)object).nextToken());
        Integer.parseInt(((StringTokenizer)object).nextToken());
        ((StringTokenizer)object).nextToken();
        RSRuleLimit[] rSRuleLimitArray = null;
        if (((StringTokenizer)object).hasMoreTokens()) {
            object = ((StringTokenizer)object).nextToken();
            int n3 = ((StringTokenizer)(object = new StringTokenizer((String)object, "#"))).countTokens();
            if (n3 > 0) {
                rSRuleLimitArray = new RSRuleLimit[n3];
                for (int i = 0; i < n3; ++i) {
                    Object object2 = ((StringTokenizer)object).nextToken();
                    if (object2 == null || ((String)object2).trim().length() <= 0) continue;
                    RSRuleLimit rSRuleLimit = new RSRuleLimit();
                    rSRuleLimit.a();
                    object2 = new StringTokenizer((String)object2, ";");
                    String string2 = ((StringTokenizer)object2).nextToken();
                    if (string2 != null && string2.trim().length() > 0) {
                        rSRuleLimit.e(Double.valueOf(string2));
                    }
                    if ((string2 = ((StringTokenizer)object2).nextToken()) != null && string2.trim().length() > 0) {
                        rSRuleLimit.d(Double.valueOf(string2));
                    }
                    if ((object2 = ((StringTokenizer)object2).nextToken()) != null && ((String)object2).trim().length() > 0) {
                        rSRuleLimit.f(Double.valueOf((String)object2));
                    }
                    if (!rSRuleLimit.e()) continue;
                    rSRuleLimitArray[i] = rSRuleLimit;
                }
            }
        }
        if ((object = this._tsMap.get(string)) != null) {
            this._valueList.get((Integer)object)[n2].add(d);
            if (rSRuleLimitArray != null) {
                this._limitList.get((Integer)object)[n2].add(rSRuleLimitArray);
            }
            RSEngineTSViewerPanel rSEngineTSViewerPanel = this;
            rSEngineTSViewerPanel.draw(rSEngineTSViewerPanel.getGraphics());
        }
    }

    private void setDrawStep(int n) {
        this.resetData();
        if (n < 0) {
            n = 0;
        }
        if (n >= this._commandCount) {
            n = this._commandCount - 1;
        }
        for (int i = 0; i < n; ++i) {
            int n2;
            String string;
            Object object = this._lineList.get(i);
            object = new StringTokenizer((String)object, "\t");
            this._currentTSName = string = ((StringTokenizer)object).nextToken();
            this._currentTimeStep = n2 = Integer.parseInt(((StringTokenizer)object).nextToken());
            double d = Double.parseDouble(((StringTokenizer)object).nextToken());
            Integer.parseInt(((StringTokenizer)object).nextToken());
            ((StringTokenizer)object).nextToken();
            RSRuleLimit[] rSRuleLimitArray = null;
            if (((StringTokenizer)object).hasMoreTokens()) {
                object = ((StringTokenizer)object).nextToken();
                int n3 = ((StringTokenizer)(object = new StringTokenizer((String)object, "#"))).countTokens();
                if (n3 > 0) {
                    rSRuleLimitArray = new RSRuleLimit[n3];
                    for (int j = 0; j < n3; ++j) {
                        Object object2 = ((StringTokenizer)object).nextToken();
                        if (object2 == null || ((String)object2).trim().length() <= 0) continue;
                        RSRuleLimit rSRuleLimit = new RSRuleLimit();
                        rSRuleLimit.a();
                        object2 = new StringTokenizer((String)object2, ";");
                        String string2 = ((StringTokenizer)object2).nextToken();
                        if (string2 != null && string2.trim().length() > 0) {
                            rSRuleLimit.e(Double.valueOf(string2));
                        }
                        if ((string2 = ((StringTokenizer)object2).nextToken()) != null && string2.trim().length() > 0) {
                            rSRuleLimit.d(Double.valueOf(string2));
                        }
                        if ((object2 = ((StringTokenizer)object2).nextToken()) != null && ((String)object2).trim().length() > 0) {
                            rSRuleLimit.f(Double.valueOf((String)object2));
                        }
                        if (!rSRuleLimit.e()) continue;
                        rSRuleLimitArray[j] = rSRuleLimit;
                    }
                }
            }
            if ((object = this._tsMap.get(string)) == null) continue;
            this._valueList.get((Integer)object)[n2].add(d);
            if (rSRuleLimitArray == null) continue;
            this._limitList.get((Integer)object)[n2].add(rSRuleLimitArray);
        }
        this._curStep = n;
        RSEngineTSViewerPanel rSEngineTSViewerPanel = this;
        rSEngineTSViewerPanel.draw(rSEngineTSViewerPanel.getGraphics());
    }

    public void resetData() {
        this._valueList = new ArrayList<ArrayList<Double>[]>();
        this._limitList = new ArrayList<ArrayList<RSRuleLimit[]>[]>();
        for (int i = 0; i < this._tsCount; ++i) {
            ArrayList[] arrayListArray = new ArrayList[this._numSteps];
            ArrayList[] arrayListArray2 = new ArrayList[this._numSteps];
            for (int j = 0; j < this._numSteps; ++j) {
                arrayListArray[j] = new ArrayList();
                arrayListArray2[j] = new ArrayList();
            }
            this._valueList.add(arrayListArray);
            this._limitList.add(arrayListArray2);
        }
    }

    public void resetDraw(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(Color.LIGHT_GRAY);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
    }

    public void paint(Graphics graphics) {
        this.resetDraw(graphics);
        this.draw(graphics);
    }

    public void recalcDrawDimensions() {
        this.a = this.getSize();
        this.a.width -= this._plotPanelWidth;
        this.d = this.a.width / (this._tsCount + 1);
        this.e = this.a.height / (this._numSteps + 1);
        this.f = this._tsCount;
        this.g = this._numSteps;
        if (this.d < 50) {
            this.f = this.a.width / 50 - 1;
            this.d = this.a.width / (this.f + 1);
        }
        if (this.e < 20) {
            this.g = this.a.height / 20 - 1;
            this.e = this.a.height / (this.g + 1);
        }
        if (this.b > this._tsCount - this.f) {
            this.b = this._tsCount - this.f;
            this.b = Math.max(this.b, 0);
        }
        if (this.c > this._numSteps - this.g) {
            this.c = this._numSteps - this.g;
            this.c = Math.max(this.c, 0);
        }
    }

    public void getDrawDimensions(Dimension dimension, Dimension dimension2, Dimension dimension3) {
        if (dimension == null || dimension2 == null || dimension3 == null) {
            return;
        }
        this.recalcDrawDimensions();
        dimension.setSize(this.a);
        dimension2.width = this.d;
        dimension2.height = this.e;
        dimension3.width = this.f;
        dimension3.height = this.g;
    }

    public void draw(Graphics graphics) {
        ArrayList<Double>[] arrayListArray;
        int n;
        this.recalcDrawDimensions();
        Dimension dimension = this.a;
        int n2 = this.d;
        int n3 = this.e;
        int n4 = this.f;
        int n5 = this.g;
        int n6 = this._plotPanelWidth;
        for (n = 0; n < n4; ++n) {
            graphics.setColor(Color.GRAY);
            graphics.drawLine((n + 1) * n2, 0, (n + 1) * n2, dimension.height);
            graphics.setColor(Color.GRAY);
            graphics.fillRect((n + 1) * n2 + 1, 0 * n3 + 1, n2 - 2, n3 - 2);
            graphics.setColor(Color.BLACK);
            graphics.drawString("TS" + Integer.toString(n + 1 + this.b), (int)(((double)n + 1.5) * (double)n2) - 4, n3 / 2 + 4);
        }
        for (n = 0; n < n5; ++n) {
            graphics.setColor(Color.GRAY);
            graphics.drawLine(0, (n + 1) * n3, dimension.width, (n + 1) * n3);
            graphics.setColor(Color.GRAY);
            graphics.fillRect(0 * n2 + 1, (n + 1) * n3 + 1, n2 - 2, n3 - 2);
            graphics.setColor(Color.BLACK);
            graphics.drawString(Integer.toString(n + this.c), n2 / 2 - 6, (int)(((double)n + 1.5) * (double)n3) + 4);
        }
        int[] nArray = new int[4];
        Object object = new int[4];
        for (int i = 0; i < n4; ++i) {
            arrayListArray = this._valueList.get(i + this.b);
            for (int j = 0; j < n5; ++j) {
                graphics.setColor(Color.WHITE);
                graphics.fillRect((i + 1) * n2 + 1, (j + 1) * n3 + 1, n2 - 2, n3 - 2);
                if (i + this.b == this._plotTSId) {
                    graphics.setColor(Color.MAGENTA);
                    graphics.drawRect((i + 1) * n2, (j + 1) * n3, n2, n3);
                }
                graphics.setColor(Color.BLUE);
                ArrayList<Double> arrayList = arrayListArray[j + this.c];
                int n7 = arrayList.size();
                if (n7 > 1) {
                    double d;
                    double d2;
                    double d3 = d2 = arrayList.get(0).doubleValue();
                    double d4 = d2;
                    double d5 = arrayList.get(n7 - 1);
                    for (int k = 1; k < n7; ++k) {
                        d = arrayList.get(k);
                        d3 = Math.max(d, d3);
                        d4 = Math.min(d, d4);
                    }
                    double d6 = ((double)n2 - 2.0) / (double)n7;
                    double d7 = ((double)n3 - 2.0) / (d3 - d4);
                    for (int k = 1; k < n7; ++k) {
                        d = arrayList.get(k);
                        nArray[0] = (i + 1) * n2 + 1 + (int)((double)(k - 1) * d6);
                        nArray[1] = (i + 1) * n2 + 1 + (int)((double)k * d6);
                        nArray[2] = nArray[1];
                        nArray[3] = nArray[0];
                        object[0] = (j + 1) * n3 + 1 + (int)((d3 - d2) * d7);
                        object[1] = (j + 1) * n3 + 1 + (int)((d3 - d) * d7);
                        object[2] = (j + 1) * n3 + 1 + (int)((d3 - d5) * d7);
                        object[3] = object[2];
                        graphics.setColor(Color.CYAN);
                        graphics.fillPolygon(nArray, (int[])object, 4);
                        graphics.setColor(Color.BLUE);
                        graphics.drawLine(nArray[0], (int)object[0], nArray[1], (int)object[1]);
                        d2 = d;
                    }
                }
                graphics.setColor(this.getTextColor(n7));
                String string = "N/A";
                if (n7 > 0) {
                    string = RMAIO.setPrecision2((double)arrayList.get(n7 - 1), (int)2);
                }
                graphics.drawString(string, (i + 1) * n2 + 4, (int)(((double)j + 1.5) * (double)n3) + 4);
            }
        }
        if (this._plotTSId >= 0 && this._plotTSId < this._tsCount) {
            int n8;
            double d;
            double d8;
            graphics.setColor(Color.WHITE);
            graphics.fillRect(dimension.width + 1, 1, n6 - 2, dimension.height - 2);
            graphics.setColor(Color.BLACK);
            graphics.drawString(this._tsNameList.get(this._plotTSId), dimension.width + 2, 15);
            ArrayList<Double>[] arrayListArray2 = this._valueList.get(this._plotTSId);
            arrayListArray = this._limitList.get(this._plotTSId);
            double d9 = Double.MIN_VALUE;
            double d10 = Double.MAX_VALUE;
            for (int i = 0; i < this._numSteps; ++i) {
                ArrayList<Double> arrayList;
                int n9;
                ArrayList<Double> arrayList2 = arrayListArray2[i];
                int n10 = arrayList2.size();
                if (n10 > 0) {
                    for (int j = 0; j < n10; ++j) {
                        d8 = arrayList2.get(j);
                        if (d8 == -3.4028234663852886E38) continue;
                        d9 = Math.max(d8, d9);
                        d10 = Math.min(d8, d10);
                    }
                }
                if ((n9 = (arrayList = arrayListArray[i]).size()) <= 0) continue;
                for (int j = 0; j < n9; ++j) {
                    RSRuleLimit[] rSRuleLimitArray = (RSRuleLimit[])arrayList.get(j);
                    if (rSRuleLimitArray == null || rSRuleLimitArray.length <= 0) continue;
                    for (int k = 0; k < rSRuleLimitArray.length; ++k) {
                        RSRuleLimit rSRuleLimit = rSRuleLimitArray[k];
                        if (rSRuleLimit == null) continue;
                        if (rSRuleLimit.a(RSRuleLimit$RULE_TYPE.MAX)) {
                            d8 = rSRuleLimit.b(RSRuleLimit$RULE_TYPE.MAX);
                            d9 = Math.max(d8, d9);
                            d10 = Math.min(d8, d10);
                        }
                        if (rSRuleLimit.a(RSRuleLimit$RULE_TYPE.MIN)) {
                            d8 = rSRuleLimit.b(RSRuleLimit$RULE_TYPE.MIN);
                            d9 = Math.max(d8, d9);
                            d10 = Math.min(d8, d10);
                        }
                        if (!rSRuleLimit.a(RSRuleLimit$RULE_TYPE.DEMAND)) continue;
                        d8 = rSRuleLimit.b(RSRuleLimit$RULE_TYPE.DEMAND);
                        d9 = Math.max(d8, d9);
                        d10 = Math.min(d8, d10);
                    }
                }
            }
            if (d9 == Double.MIN_VALUE) {
                d9 = 0.0;
                d10 = 0.0;
            }
            double d11 = d9;
            d9 = d11 + Math.abs(d11) * 0.05;
            double d12 = d10;
            d10 = d12 - Math.abs(d12) * 0.05;
            double d13 = Math.max(0.01, Math.abs(d9 / 100.0));
            if (d > d9 - d10) {
                double d14 = 0.5 * (d9 + d10);
                d9 = d14 + d13 / 2.0;
                d10 = d14 - d13 / 2.0;
            }
            double d15 = ((double)this._plotPanelWidth - 2.0) / (d9 - d10);
            double d16 = ((double)dimension.height - (double)n3 - 2.0) / (double)n5;
            graphics.setColor(Color.ORANGE);
            for (int i = 0; i < n5; ++i) {
                ArrayList<Double> arrayList = arrayListArray2[i + this.c];
                int n11 = arrayList.size();
                for (int j = 0; j < n11; ++j) {
                    d8 = arrayList.get(j);
                    n8 = dimension.width + 1 + (int)((d8 - d10) * d15);
                    int n12 = n3 + 1 + (int)(((double)i + 0.5) * d16);
                    graphics.fillRect(n8 - 1, n12 - 1, 3, 3);
                }
            }
            graphics.setColor(Color.MAGENTA);
            ArrayList<Double> arrayList = arrayListArray2[this.c];
            int n13 = arrayList.size();
            double d17 = n13 > 0 ? arrayList.get(n13 - 1) : -3.4028234663852886E38;
            for (n8 = 1; n8 < n5; ++n8) {
                arrayList = arrayListArray2[n8 + this.c];
                n13 = arrayList.size();
                d8 = n13 > 0 ? arrayList.get(n13 - 1) : -3.4028234663852886E38;
                if (d17 == -3.4028234663852886E38 || d8 == -3.4028234663852886E38) {
                    d17 = d8;
                    continue;
                }
                int n14 = dimension.width + 1 + (int)((d17 - d10) * d15);
                n2 = n3 + 1 + (int)(((double)(n8 - 1) + 0.5) * d16);
                n4 = dimension.width + 1 + (int)((d8 - d10) * d15);
                n6 = n3 + 1 + (int)(((double)n8 + 0.5) * d16);
                graphics.drawLine(n14, n2, n4, n6);
                d17 = d8;
            }
            for (n8 = 0; n8 < n5; ++n8) {
                ArrayList<Double> arrayList3 = arrayListArray[n8 + this.c];
                n2 = arrayList3.size();
                for (n6 = n4 = Math.max(0, n2 - 1); n6 < n2; ++n6) {
                    RSRuleLimit[] rSRuleLimitArray = (RSRuleLimit[])arrayList3.get(n6);
                    if (rSRuleLimitArray == null || rSRuleLimitArray.length <= 0) continue;
                    for (int i = 0; i < rSRuleLimitArray.length; ++i) {
                        RSRuleLimit rSRuleLimit = rSRuleLimitArray[i];
                        object = rSRuleLimit;
                        if (rSRuleLimit == null) continue;
                        if (((RSRuleLimit)object).a(RSRuleLimit$RULE_TYPE.MAX)) {
                            d8 = ((RSRuleLimit)object).b(RSRuleLimit$RULE_TYPE.MAX);
                            graphics.setColor(Color.RED.darker());
                            int n15 = dimension.width + 1 + (int)((d8 - d10) * d15);
                            int n16 = n3 + 1 + (int)(((double)n8 + 0.5) * d16);
                            graphics.fillRect(n15, n16 - 3, 1, 7);
                            graphics.fillRect(n15, n16 - 1, 5, 3);
                            graphics.drawString(Integer.toString(i), n15, n16 - 1);
                        }
                        if (((RSRuleLimit)object).a(RSRuleLimit$RULE_TYPE.MIN)) {
                            d8 = ((RSRuleLimit)object).b(RSRuleLimit$RULE_TYPE.MIN);
                            graphics.setColor(Color.RED.brighter());
                            int n17 = dimension.width + 1 + (int)((d8 - d10) * d15);
                            int n18 = n3 + 1 + (int)(((double)n8 + 0.5) * d16);
                            graphics.fillRect(n17 - 1, n18 - 3, 1, 7);
                            graphics.fillRect(n17 - 5, n18 - 1, 5, 3);
                            graphics.drawString(Integer.toString(i), n17, n18 + 10);
                        }
                        if (!((RSRuleLimit)object).a(RSRuleLimit$RULE_TYPE.DEMAND)) continue;
                        d8 = ((RSRuleLimit)object).b(RSRuleLimit$RULE_TYPE.DEMAND);
                        graphics.setColor(Color.PINK);
                        int n19 = dimension.width + 1 + (int)((d8 - d10) * d15);
                        int n20 = n3 + 1 + (int)(((double)n8 + 0.5) * d16);
                        graphics.fillRect(n19 - 1, n20 - 3, 3, 7);
                        graphics.fillRect(n19 - 3, n20 - 1, 7, 3);
                    }
                }
            }
        }
    }

    private void drawBigSpark(Graphics graphics, int n, int n2) {
        int n3;
        double d;
        double d2;
        double d3;
        Object object = this.getSize();
        int n4 = this._plotPanelWidth;
        ((Dimension)object).width -= n4;
        n4 = n + 50;
        if (n4 + 800 > ((Dimension)object).width && (n4 = n - 50 - 800) < 0) {
            n4 = 0;
        }
        if ((n = n2 + 50) + 400 > ((Dimension)object).height && (n = n2 - 50 - 400) < 0) {
            n = 0;
        }
        Object object2 = new int[4];
        object = new int[4];
        int n5 = this._plotTSId;
        Object object3 = this._valueList.get(n5);
        ArrayList<RSRuleLimit[]>[] arrayListArray = this._limitList.get(this._plotTSId);
        int n6 = this._plotStepId;
        graphics.setColor(Color.WHITE);
        graphics.fillRect(n4, n, 800, 400);
        graphics.setColor(Color.BLACK);
        graphics.drawRect(n4, n, 800, 400);
        graphics.setColor(Color.BLACK);
        String string = this._tsNameList.get(this._plotTSId) + ", step " + this._plotStepId;
        graphics.drawString(string, n4 + 800 / 2 - 50, n + 15);
        graphics.setColor(Color.BLUE);
        object3 = object3[n6];
        int n7 = ((ArrayList)object3).size();
        if (n7 <= 0) {
            return;
        }
        double d4 = d3 = ((Double)((ArrayList)object3).get(0)).doubleValue();
        double d5 = d3;
        double d6 = (Double)((ArrayList)object3).get(n7 - 1);
        for (int i = 1; i < n7; ++i) {
            d2 = (Double)((ArrayList)object3).get(i);
            d4 = Math.max(d2, d4);
            d5 = Math.min(d2, d5);
        }
        ArrayList<RSRuleLimit[]> arrayList = arrayListArray[n6];
        int n8 = arrayList.size();
        if (n8 > 0) {
            for (int i = 0; i < n8; ++i) {
                RSRuleLimit[] rSRuleLimitArray = arrayList.get(i);
                if (rSRuleLimitArray == null || rSRuleLimitArray.length <= 0) continue;
                for (int j = 0; j < rSRuleLimitArray.length; ++j) {
                    RSRuleLimit rSRuleLimit = rSRuleLimitArray[j];
                    if (rSRuleLimit == null) continue;
                    if (rSRuleLimit.a(RSRuleLimit$RULE_TYPE.MAX)) {
                        d2 = rSRuleLimit.b(RSRuleLimit$RULE_TYPE.MAX);
                        d4 = Math.max(d2, d4);
                        d5 = Math.min(d2, d5);
                    }
                    if (rSRuleLimit.a(RSRuleLimit$RULE_TYPE.MIN)) {
                        d2 = rSRuleLimit.b(RSRuleLimit$RULE_TYPE.MIN);
                        d4 = Math.max(d2, d4);
                        d5 = Math.min(d2, d5);
                    }
                    if (!rSRuleLimit.a(RSRuleLimit$RULE_TYPE.DEMAND)) continue;
                    d2 = rSRuleLimit.b(RSRuleLimit$RULE_TYPE.DEMAND);
                    d4 = Math.max(d2, d4);
                    d5 = Math.min(d2, d5);
                }
            }
        }
        if (d4 == Double.MIN_VALUE) {
            d4 = 0.0;
            d5 = 0.0;
        }
        double d7 = d4;
        d4 = d7 + Math.abs(d7) * 0.05;
        double d8 = d5;
        d5 = d8 - Math.abs(d8) * 0.05;
        double d9 = Math.max(0.01, Math.abs(d4 / 100.0));
        if (d > d4 - d5) {
            double d10 = 0.5 * (d4 + d5);
            d4 = d10 + d9 / 2.0;
            d5 = d10 - d9 / 2.0;
        }
        double d11 = 760.0 / (double)n7;
        double d12 = 360.0 / (d4 - d5);
        for (n6 = 1; n6 < n7; ++n6) {
            d2 = (Double)((ArrayList)object3).get(n6);
            object2[0] = n4 + 20 + (int)((double)(n6 - 1) * d11);
            object2[1] = n4 + 20 + (int)((double)n6 * d11);
            object2[2] = object2[1];
            object2[3] = object2[0];
            object[0] = n + 20 + (int)((d4 - d3) * d12);
            object[1] = n + 20 + (int)((d4 - d2) * d12);
            object[2] = n + 20 + (int)((d4 - d6) * d12);
            object[3] = object[2];
            graphics.setColor(Color.CYAN);
            graphics.fillPolygon((int[])object2, (int[])object, 4);
            graphics.setColor(Color.BLUE);
            graphics.drawLine((int)object2[0], (int)object[0], (int)object2[1], (int)object[1]);
            d3 = d2;
        }
        for (n6 = 0; n6 < n8; ++n6) {
            RSRuleLimit[] rSRuleLimitArray = arrayList.get(n6);
            if (rSRuleLimitArray == null || rSRuleLimitArray.length <= 0) continue;
            for (int i = 0; i < rSRuleLimitArray.length; ++i) {
                int n9;
                RSRuleLimit rSRuleLimit = rSRuleLimitArray[i];
                object2 = rSRuleLimit;
                if (rSRuleLimit == null) continue;
                if (((RSRuleLimit)object2).a(RSRuleLimit$RULE_TYPE.MAX)) {
                    d2 = ((RSRuleLimit)object2).b(RSRuleLimit$RULE_TYPE.MAX);
                    graphics.setColor(Color.RED.darker());
                    int n10 = n4 + 20 + (int)((double)n6 * d11);
                    n9 = n + 20 + (int)((d4 - d2) * d12);
                    graphics.fillRect(n10 - 3, n9 - 1, 7, 1);
                    graphics.fillRect(n10 - 1, n9 - 5, 3, 5);
                    graphics.drawString(Integer.toString(i), n10 + 2, n9 - 1);
                }
                if (((RSRuleLimit)object2).a(RSRuleLimit$RULE_TYPE.MIN)) {
                    d2 = ((RSRuleLimit)object2).b(RSRuleLimit$RULE_TYPE.MIN);
                    graphics.setColor(Color.RED.brighter());
                    int n11 = n4 + 20 + (int)((double)n6 * d11);
                    n9 = n + 20 + (int)((d4 - d2) * d12);
                    graphics.fillRect(n11 - 3, n9, 7, 1);
                    graphics.fillRect(n11 - 1, n9, 3, 5);
                    graphics.drawString(Integer.toString(i), n11 + 2, n9 + 10);
                }
                if (!((RSRuleLimit)object2).a(RSRuleLimit$RULE_TYPE.DEMAND)) continue;
                d2 = ((RSRuleLimit)object2).b(RSRuleLimit$RULE_TYPE.DEMAND);
                graphics.setColor(Color.PINK);
                int n12 = n4 + 20 + (int)((double)n6 * d11);
                n9 = n + 20 + (int)((d4 - d2) * d12);
                graphics.fillRect(n12 - 1, n9 - 3, 3, 7);
                graphics.fillRect(n12 - 3, n9 - 1, 7, 3);
            }
        }
        graphics.setColor(Color.BLACK);
        String string2 = RMAIO.setPrecision2((double)d4, (int)2);
        graphics.drawString(string2, n4 + 800 - 50, n + 15);
        string2 = RMAIO.setPrecision2((double)d5, (int)2);
        graphics.drawString(string2, n4 + 800 - 50, n + 400 - 4);
        graphics.setColor(Color.BLACK);
        double d13 = (d4 - d5) / d4 * 100.0;
        if (d6 != 0.0) {
            d13 = (d4 - d5) / d6 * 100.0;
        }
        arrayList = "Range " + RMAIO.setPrecision2((double)d13, (int)1) + "%, " + n7 + " iterations";
        graphics.drawString((String)((Object)arrayList), n4 + 800 / 2 - 50, n + 400 - 4);
        graphics.setColor(this.getTextColor(n7));
        object2 = "N/A";
        if (n7 > 0) {
            object2 = RMAIO.setPrecision2((double)((Double)((ArrayList)object3).get(n7 - 1)), (int)2);
        }
        if ((n3 = n + 20 + (int)((d4 - d6) * d12) - 4) < 20) {
            n3 = 20;
        }
        if (n3 > n + 400 - 20) {
            n3 = n + 400 - 20;
        }
        graphics.drawString((String)object2, n4 + 800 - 50, n3);
    }

    private Color getFillColor(int n) {
        int n2;
        n = Math.min(99, n);
        int n3 = 255;
        int n4 = 255;
        if (n == 0) {
            return Color.WHITE;
        }
        if (n >= 67) {
            n3 = (int)((double)(255 * (n - 67)) / 33.0);
            n2 = (int)(255.0 * (1.0 - (double)(n - 67) / 33.0));
        } else if (n >= 33) {
            n2 = (int)((double)(255 * (n - 33)) / 34.0);
            n4 = (int)(255.0 * (1.0 - (double)(n - 33) / 34.0));
        } else {
            n4 = 255;
            n2 = n3 = 255 - (int)(255.0 * (double)n / 33.0);
        }
        return new Color(n3, n2, n4);
    }

    private Color getTextColor(int n) {
        n = Math.min(99, n);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (n == 0) {
            return Color.BLACK;
        }
        if (n >= 67) {
            n2 = (int)((double)(255 * (n - 67)) / 33.0);
            n3 = (int)(255.0 * (1.0 - (double)(n - 67) / 33.0));
        } else if (n >= 33) {
            n3 = (int)((double)(255 * (n - 33)) / 34.0);
            n4 = (int)(255.0 * (1.0 - (double)(n - 33) / 34.0));
        } else {
            n4 = (int)(255.0 * (double)n / 33.0);
        }
        return new Color(n2, n3, n4);
    }

    public void stop() {
    }

    public void pause() {
        if (this._isAnimating) {
            this._isAnimating = false;
            return;
        }
    }

    public void setStep(int n) {
    }

    public void next() {
        if (this._isAnimating) {
            this._isAnimating = false;
            return;
        }
        this.incrDrawStep(1);
    }

    public void prev() {
        if (this._isAnimating) {
            this._isAnimating = false;
            return;
        }
        RSEngineTSViewerPanel rSEngineTSViewerPanel = this;
        rSEngineTSViewerPanel.setDrawStep(rSEngineTSViewerPanel._curStep - 1);
    }

    public void last() {
        if (this._isAnimating) {
            this._isAnimating = false;
            return;
        }
        RSEngineTSViewerPanel rSEngineTSViewerPanel = this;
        rSEngineTSViewerPanel.setDrawStep(rSEngineTSViewerPanel._lineList.size() - 1);
    }

    public void reset() {
        if (this._isAnimating) {
            this._isAnimating = false;
            return;
        }
        this.resetData();
        RSEngineTSViewerPanel rSEngineTSViewerPanel = this;
        rSEngineTSViewerPanel.resetDraw(rSEngineTSViewerPanel.getGraphics());
        this._curStep = -1;
        this.incrDrawStep(1);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this._isAnimating) {
            return;
        }
        Dimension dimension = new Dimension();
        Dimension dimension2 = new Dimension();
        Dimension dimension3 = new Dimension();
        this.getDrawDimensions(dimension, dimension2, dimension3);
        int n = dimension2.width;
        int n2 = mouseEvent.getX() / n - 1 + this.b;
        if (n2 < 0 || n2 >= this._tsNameList.size()) {
            return;
        }
        this._plotTSId = n2;
        RSEngineTSViewerPanel rSEngineTSViewerPanel = this;
        rSEngineTSViewerPanel.draw(rSEngineTSViewerPanel.getGraphics());
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this._isAnimating) {
            return;
        }
        if (!mouseEvent.isAltDown()) {
            return;
        }
        Dimension dimension = new Dimension();
        Dimension dimension2 = new Dimension();
        Dimension dimension3 = new Dimension();
        this.getDrawDimensions(dimension, dimension2, dimension3);
        int n = dimension2.width;
        int n2 = dimension2.height;
        n = mouseEvent.getX() / n - 1 + this.b;
        if (n < 0 || n >= this._tsNameList.size()) {
            return;
        }
        this._plotTSId = n;
        this._plotStepId = mouseEvent.getY() / n2 - 1 + this.c;
        if (this._plotStepId < 0 || this._plotStepId >= this._numSteps) {
            this._plotStepId = 0;
        }
        RSEngineTSViewerPanel rSEngineTSViewerPanel = this;
        rSEngineTSViewerPanel.draw(rSEngineTSViewerPanel.getGraphics());
        RSEngineTSViewerPanel rSEngineTSViewerPanel2 = this;
        rSEngineTSViewerPanel2.drawBigSpark(rSEngineTSViewerPanel2.getGraphics(), mouseEvent.getPoint().x, mouseEvent.getPoint().y);
    }

    public void setTSOffset(int n) {
        n = Math.min(this._tsCount - this.f, n);
        if (this.b != (n = Math.max(n, 0))) {
            this.b = n;
            this.repaint();
        }
    }

    public void setStepOffset(int n) {
        n = Math.min(this._numSteps - this.g, n);
        if (this.c != (n = Math.max(n, 0))) {
            this.c = n;
            this.repaint();
        }
    }

    public int getTSOffset() {
        return this.b;
    }

    public int getTSCount() {
        return this._tsCount;
    }

    public int getNumSteps() {
        return this._numSteps;
    }

    public int getStepOffset() {
        return this.c;
    }
}

