/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model.engine.UI;

import hec.rss.model.engine.UI.RSEngineViewerFrame;
import hec.rss.model.engine.UI.RSEngineViewerPanel$1;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import rma.swing.RmaJPanel;

public class RSEngineViewerPanel
extends RmaJPanel
implements Runnable {
    public static final int CELL_X_MIN = 50;
    public static final int CELL_Y_MIN = 20;
    RSEngineViewerFrame _frame;
    String _resultFileName;
    int _commandCount;
    int _numSteps;
    int _funcCount;
    List<String> _funcNameList;
    List<int[][]> _funcEvalList;
    Map<String, Integer> _funcMap;
    List<String> _lineList;
    List<String> _currentQueue;
    boolean _isAnimating = false;
    int _drawStep = 0;
    Thread _animationThread = null;
    private int _curStep = -1;
    private String _currentFuncName;
    private int _queuePanelWidth = 150;
    private int _currentTimeStep;
    private transient Dimension a;
    private transient int b = 0;
    private transient int c = 0;
    private transient int d;
    private transient int e;
    private transient int f;
    private transient int g;

    public RSEngineViewerPanel() {
        this.addComponentListener(new RSEngineViewerPanel$1(this));
        this.loadFile("ResSimQueueOut.txt");
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (this._isAnimating) {
            return null;
        }
        Dimension dimension = new Dimension();
        Dimension dimension2 = new Dimension();
        Dimension dimension3 = new Dimension();
        this.getDrawDimensions(dimension, dimension2, dimension3);
        int n = dimension2.width;
        int n2 = mouseEvent.getX() / n - 1 + this.b;
        if (n2 < 0 || n2 >= this._funcNameList.size()) {
            return null;
        }
        return this._funcNameList.get(n2);
    }

    public void setViewerFrame(RSEngineViewerFrame rSEngineViewerFrame) {
        this._frame = rSEngineViewerFrame;
    }

    void loadFile(String object) {
        this._resultFileName = object;
        object = new File((String)object);
        this._commandCount = 0;
        this._numSteps = 0;
        this._funcCount = 0;
        this._funcNameList = new ArrayList<String>();
        this._funcEvalList = new ArrayList<int[][]>();
        this._funcMap = new HashMap<String, Integer>();
        this._lineList = new ArrayList<String>();
        this._currentQueue = new ArrayList<String>();
        try {
            object = new BufferedReader(new FileReader((File)object));
            try {
                ((BufferedReader)object).readLine();
                Object object2 = ((BufferedReader)object).readLine();
                while (object2 != null && ((String)object2).length() > 0) {
                    StringTokenizer stringTokenizer = new StringTokenizer((String)object2, "\t");
                    String string = stringTokenizer.nextToken();
                    Object object3 = stringTokenizer.nextToken();
                    object3 = string + "_" + (String)object3;
                    int n = Integer.parseInt(stringTokenizer.nextToken());
                    this._lineList.add((String)object2);
                    ++this._commandCount;
                    if (n >= this._numSteps) {
                        this._numSteps = n + 1;
                    }
                    if ((object2 = this._funcMap.get(object3)) == null) {
                        this._funcNameList.add((String)object3);
                        this._funcMap.put((String)object3, this._funcCount);
                        ++this._funcCount;
                    }
                    object2 = ((BufferedReader)object).readLine();
                }
                this.resetData();
            }
            finally {
                ((BufferedReader)object).close();
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    public void play() {
        if (this._isAnimating) {
            this._isAnimating = false;
            return;
        }
        if (this._curStep < 0) {
            this.resetData();
            RSEngineViewerPanel rSEngineViewerPanel = this;
            rSEngineViewerPanel.resetDraw(rSEngineViewerPanel.getGraphics());
        }
        this._isAnimating = true;
        this._animationThread = new Thread(this);
        this._animationThread.start();
    }

    @Override
    public void run() {
        if (this._curStep >= this._commandCount) {
            this._curStep = 0;
        }
        for (int i = this._curStep; i < this._commandCount && this._isAnimating; ++i) {
            this.incrDrawStep(1);
        }
        this._isAnimating = false;
    }

    private void incrDrawStep(int n) {
        int n2;
        Object object;
        if (this._curStep + n < 0) {
            this.reset();
            return;
        }
        if (this._curStep + n >= this._commandCount) {
            return;
        }
        this._curStep += n;
        for (int i = 0; i < this._funcCount; ++i) {
            for (int j = 0; j < this._numSteps; ++j) {
                object = this._funcEvalList.get(i);
                int[] nArray = object[j];
                nArray[1] = nArray[1] - n;
                if (object[j][1] < 0) {
                    object[j][1] = 0;
                }
                if (object[j][1] <= 100) continue;
                object[j][1] = 100;
            }
        }
        String string = this._lineList.get(this._curStep);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        object = stringTokenizer.nextToken();
        Object object2 = stringTokenizer.nextToken();
        this._currentFuncName = object2 = (String)object + "_" + (String)object2;
        this._currentTimeStep = n2 = Integer.parseInt(stringTokenizer.nextToken());
        Integer.parseInt(stringTokenizer.nextToken());
        this._currentQueue = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken() + ":" + stringTokenizer.nextToken();
            this._currentQueue.add((String)object);
        }
        Integer n3 = this._funcMap.get(object2);
        object = n3;
        if (n3 != null && n2 >= 0) {
            int[] nArray = this._funcEvalList.get((Integer)object)[n2];
            nArray[0] = nArray[0] + 1;
            this._funcEvalList.get((int)((Integer)object).intValue())[n2][1] = 100;
            RSEngineViewerPanel rSEngineViewerPanel = this;
            rSEngineViewerPanel.draw(rSEngineViewerPanel.getGraphics());
        }
    }

    private void setDrawStep(int n) {
        this.resetData();
        if (n < 0) {
            n = 0;
        }
        if (n >= this._commandCount) {
            n = this._commandCount - 1;
        }
        for (int i = 0; i < n; ++i) {
            Object object;
            int n2;
            for (int j = 0; j < this._funcCount; ++j) {
                for (int k = 0; k < this._numSteps; ++k) {
                    int[][] nArray = this._funcEvalList.get(j);
                    int[] nArray2 = nArray[k];
                    nArray2[1] = nArray2[1] - 1;
                    if (nArray[k][1] < 0) {
                        nArray[k][1] = 0;
                    }
                    if (nArray[k][1] <= 100) continue;
                    nArray[k][1] = 100;
                }
            }
            Object object2 = this._lineList.get(i);
            StringTokenizer stringTokenizer = new StringTokenizer((String)object2, "\t");
            String string = stringTokenizer.nextToken();
            object2 = stringTokenizer.nextToken();
            this._currentFuncName = object2 = string + "_" + (String)object2;
            this._currentTimeStep = n2 = Integer.parseInt(stringTokenizer.nextToken());
            Integer.parseInt(stringTokenizer.nextToken());
            this._currentQueue = new ArrayList<String>();
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken() + ":" + stringTokenizer.nextToken();
                this._currentQueue.add((String)object);
            }
            object = this._funcMap.get(object2);
            if (object == null) continue;
            int[] nArray = this._funcEvalList.get((Integer)object)[n2];
            nArray[0] = nArray[0] + 1;
            this._funcEvalList.get((int)((Integer)object).intValue())[n2][1] = 100;
        }
        this._curStep = n;
        RSEngineViewerPanel rSEngineViewerPanel = this;
        rSEngineViewerPanel.draw(rSEngineViewerPanel.getGraphics());
    }

    public void resetData() {
        this._funcEvalList = new ArrayList<int[][]>();
        for (int i = 0; i < this._funcCount; ++i) {
            this._funcEvalList.add(new int[this._numSteps][2]);
        }
    }

    public void resetDraw(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(Color.LIGHT_GRAY);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
    }

    public void paint(Graphics graphics) {
        this.resetDraw(graphics);
        this.draw(graphics);
    }

    public void recalcDrawDimensions() {
        this.a = this.getSize();
        this.a.width -= this._queuePanelWidth;
        this.d = this.a.width / (this._funcCount + 1);
        this.e = this.a.height / (this._numSteps + 1);
        this.f = this._funcCount;
        this.g = this._numSteps;
        if (this.d < 50) {
            this.f = this.a.width / 50 - 1;
            this.d = this.a.width / (this.f + 1);
        }
        if (this.e < 20) {
            this.g = this.a.height / 20 - 1;
            this.e = this.a.height / (this.g + 1);
        }
        if (this.b > this._funcCount - this.f) {
            this.b = this._funcCount - this.f;
            this.b = Math.max(this.b, 0);
        }
        if (this.c > this._numSteps - this.g) {
            this.c = this._numSteps - this.g;
            this.c = Math.max(this.c, 0);
        }
    }

    public void getDrawDimensions(Dimension dimension, Dimension dimension2, Dimension dimension3) {
        if (dimension == null || dimension2 == null || dimension3 == null) {
            return;
        }
        this.recalcDrawDimensions();
        dimension.setSize(this.a);
        dimension2.width = this.d;
        dimension2.height = this.e;
        dimension3.width = this.f;
        dimension3.height = this.g;
    }

    public void draw(Graphics graphics) {
        Object object;
        int n;
        this.recalcDrawDimensions();
        Dimension dimension = this.a;
        int n2 = this.d;
        int n3 = this.e;
        int n4 = this._queuePanelWidth;
        for (n = 0; n < this.f; ++n) {
            graphics.setColor(Color.GRAY);
            graphics.drawLine((n + 1) * n2, 0, (n + 1) * n2, dimension.height);
            graphics.setColor(Color.GRAY);
            graphics.fillRect((n + 1) * n2 + 1, 0 * n3 + 1, n2 - 2, n3 - 2);
            graphics.setColor(Color.BLACK);
            graphics.drawString("F" + Integer.toString(n + 1 + this.b), (int)(((double)n + 1.5) * (double)n2) - 4, n3 / 2 + 4);
        }
        for (n = 0; n < this.g; ++n) {
            graphics.setColor(Color.GRAY);
            graphics.drawLine(0, (n + 1) * n3, dimension.width, (n + 1) * n3);
            graphics.setColor(Color.GRAY);
            graphics.fillRect(0 * n2 + 1, (n + 1) * n3 + 1, n2 - 2, n3 - 2);
            graphics.setColor(Color.BLACK);
            graphics.drawString(Integer.toString(n + this.c), n2 / 2 - 6, (int)(((double)n + 1.5) * (double)n3) + 4);
        }
        for (n = 0; n < this.f; ++n) {
            object = this._funcEvalList.get(n + this.b);
            for (int i = 0; i < this.g; ++i) {
                graphics.setColor(this.getFillColor(object[i][1], object[i][0]));
                graphics.fillRect((n + 1) * n2 + 1, (i + 1) * n3 + 1, n2 - 2, n3 - 2);
                graphics.setColor(Color.BLACK);
                graphics.drawString(Integer.toString((int)object[i + this.c][0]), (int)(((double)n + 1.5) * (double)n2) - 4, (int)(((double)i + 1.5) * (double)n3) + 4);
            }
        }
        graphics.setColor(Color.LIGHT_GRAY);
        graphics.fillRect(dimension.width + 1, 0, n4, dimension.height);
        graphics.setColor(Color.RED);
        n = 20;
        if (this._currentFuncName != null) {
            graphics.drawString(this._currentFuncName + ":" + this._currentTimeStep, dimension.width + 2, 20);
        }
        graphics.setColor(Color.BLUE);
        n += 20;
        object = this._currentQueue.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            graphics.drawString(string, dimension.width + 2, n);
            n += 15;
        }
    }

    private Color getFillColor(int n, int n2) {
        if (n2 == 0) {
            return Color.LIGHT_GRAY;
        }
        if (n == 0) {
            return Color.WHITE;
        }
        if (n > 99) {
            n2 = 0;
            n = 0;
        } else {
            n2 = (int)(255.0 * (1.0 - (double)n / 100.0));
            double cfr_ignored_0 = (double)n / 100.0;
            n = n2;
        }
        return new Color(225, n2, n);
    }

    private Color getTextColor(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (n == 0) {
            return Color.BLACK;
        }
        if (n >= 67) {
            n2 = (int)((double)(255 * (n - 67)) / 33.0);
            n3 = (int)(255.0 * (1.0 - (double)(n - 67) / 33.0));
        } else if (n >= 33) {
            n3 = (int)((double)(255 * (n - 33)) / 34.0);
            n4 = (int)(255.0 * (1.0 - (double)(n - 33) / 34.0));
        } else {
            n4 = (int)(255.0 * (double)n / 33.0);
        }
        return new Color(n2, n3, n4);
    }

    public void stop() {
    }

    public void pause() {
        if (this._isAnimating) {
            this._isAnimating = false;
            return;
        }
    }

    public void setStep(int n) {
    }

    public void next() {
        if (this._isAnimating) {
            this._isAnimating = false;
            return;
        }
        this.incrDrawStep(1);
    }

    public void prev() {
        if (this._isAnimating) {
            this._isAnimating = false;
            return;
        }
        RSEngineViewerPanel rSEngineViewerPanel = this;
        rSEngineViewerPanel.setDrawStep(rSEngineViewerPanel._curStep - 1);
    }

    public void last() {
        if (this._isAnimating) {
            this._isAnimating = false;
            return;
        }
        this.resetData();
        RSEngineViewerPanel rSEngineViewerPanel = this;
        rSEngineViewerPanel.resetDraw(rSEngineViewerPanel.getGraphics());
        this._curStep = -1;
        RSEngineViewerPanel rSEngineViewerPanel2 = this;
        rSEngineViewerPanel2.setDrawStep(rSEngineViewerPanel2._commandCount - 1);
    }

    public void reset() {
        if (this._isAnimating) {
            this._isAnimating = false;
            return;
        }
        this.resetData();
        RSEngineViewerPanel rSEngineViewerPanel = this;
        rSEngineViewerPanel.resetDraw(rSEngineViewerPanel.getGraphics());
        this._curStep = -1;
        this.incrDrawStep(1);
    }

    public void setFuncOffset(int n) {
        n = Math.min(this._funcCount - this.f, n);
        if (this.b != (n = Math.max(n, 0))) {
            this.b = n;
            this.repaint();
        }
    }

    public void setStepOffset(int n) {
        n = Math.min(this._numSteps - this.g, n);
        if (this.c != (n = Math.max(n, 0))) {
            this.c = n;
            this.repaint();
        }
    }

    public int getFuncOffset() {
        return this.b;
    }

    public int getFuncCount() {
        return this._funcCount;
    }

    public int getNumSteps() {
        return this._numSteps;
    }

    public int getStepOffset() {
        return this.c;
    }
}

