/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model.globalvariable;

import com.google.common.flogger.FluentLogger;
import hec.rss.model.globalvariable.BaseAltGlobalData;
import hec.rss.model.globalvariable.GlobalVariable;
import hec.rss.model.globalvariable.GlobalVariableType;
import hec.rss.model.globalvariable.StringGlobalVariable;
import java.rmi.RemoteException;

public class AltStringGlobalData
extends BaseAltGlobalData {
    private static final FluentLogger b = FluentLogger.forEnclosingClass();

    public AltStringGlobalData() {
    }

    public AltStringGlobalData(GlobalVariable globalVariable, String string) {
        super(globalVariable, string);
    }

    @Override
    public GlobalVariableType getType() {
        return GlobalVariableType.STRING;
    }

    @Override
    protected boolean finishWritingData(String string) {
        return this.writeDssTextValue(string, ((BaseAltGlobalData)this).getValue());
    }

    @Override
    protected boolean finishReadingData() {
        String string = this.readDssTextValue();
        if (string != null) {
            string = string.trim();
            this.setValue(string);
        }
        return true;
    }

    @Override
    public String getValue() {
        String string = super.getValue();
        if (this.a instanceof StringGlobalVariable && ((StringGlobalVariable)this.a).isFilePath()) {
            try {
                string = this.getGVDataSet().getProxyList().getWorkspace().makeAbsolutePath(string);
            }
            catch (RemoteException remoteException) {
                ((FluentLogger.Api)((FluentLogger.Api)b.atWarning()).withCause((Throwable)remoteException)).log("Failed to get absolute path for %s", (Object)string);
            }
        }
        return string;
    }

    @Override
    public boolean writeDssData(String string) {
        return this.writeDssTextValue(string, ((BaseAltGlobalData)this).getValue());
    }

    @Override
    protected boolean writeDssTextValue(String string, Object object) {
        if (this.a instanceof StringGlobalVariable && ((StringGlobalVariable)this.a).isFilePath()) {
            try {
                object = this.getGVDataSet().getProxyList().getWorkspace().getRelativePath((String)object);
            }
            catch (RemoteException remoteException) {
                ((FluentLogger.Api)((FluentLogger.Api)b.atWarning()).withCause((Throwable)remoteException)).log("Failed to get relative path for String Global Variable %s path=%s", (Object)this.getName(), object);
            }
        }
        return super.writeDssTextValue(string, object);
    }

    @Override
    public boolean loadData() {
        this._value = this.readDssTextValue();
        if (this._value != null) {
            this._value = this._value.trim();
        }
        return this._value != null;
    }
}

