/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model.globalvariable;

import hec.data.Parameter;
import hec.heclib.dss.DSSPathname;
import hec.io.DSSIdentifier;
import hec.io.DataContainer;
import hec.io.PairedDataContainer;
import hec.lang.annotation.Scriptable;
import hec.model.PairedValues;
import hec.model.PairedValuesExt;
import hec.model.SeasonalPairedValues;
import hec.rss.model.NameValuePair;
import hec.rss.model.RssSystem;
import hec.rss.model.globalvariable.BaseAltGlobalData;
import hec.rss.model.globalvariable.GlobalVariable;
import hec.rss.model.globalvariable.GlobalVariableType;
import hec.rss.model.globalvariable.GlobalVariableUtils;
import hec.rss.model.globalvariable.TableGlobalVariable;
import hec.rss.model.globalvariable.TableType;
import java.io.BufferedWriter;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.List;
import java.util.logging.Logger;
import rma.util.RMAIO;

public class AltTableGlobalData
extends BaseAltGlobalData {
    private boolean _isDSS;
    private PairedDataContainer _pairedDataContainer;
    private long _gvModifiedTime;
    private transient boolean b;

    public AltTableGlobalData() {
    }

    public AltTableGlobalData(GlobalVariable globalVariable, String string, boolean bl) {
        super(globalVariable, string);
        this._isDSS = bl;
    }

    public boolean isDSS() {
        return this._isDSS;
    }

    public void setIsDss(boolean bl) {
        this._isDSS = bl;
    }

    @Scriptable
    public void setPairedData(PairedDataContainer pairedDataContainer) {
        this._pairedDataContainer = pairedDataContainer;
    }

    public PairedDataContainer getPairedData() {
        if (this._pairedDataContainer == null) {
            this.readPairedDataRecord(null);
            if (this._pairedDataContainer == null) {
                this._pairedDataContainer = this.createPairedDataContainer();
            }
        }
        return this._pairedDataContainer;
    }

    private PairedDataContainer createPairedDataContainer() {
        Object object;
        PairedDataContainer pairedDataContainer = new PairedDataContainer();
        if (!this.isDSS()) {
            pairedDataContainer.fullName = this.getDSSPathname();
            pairedDataContainer.fileName = this.getDSSFilename();
        } else if (this.a != null) {
            object = this.a.getNetwork();
            pairedDataContainer.fileName = ((RssSystem)object).getGlobalVariableTablesFile();
            object = new DSSPathname(this.getDSSPathname());
            object.setBPart(this.getValue());
            if (this.a instanceof TableGlobalVariable) {
                object.setFPart(((TableGlobalVariable)this.a).getTableType().toString());
            }
            pairedDataContainer.fullName = object.getPathname();
        }
        if (this.a instanceof TableGlobalVariable) {
            object = (TableGlobalVariable)this.a;
            pairedDataContainer = ((TableGlobalVariable)object).getTableType() == TableType.SIMPLELOOKUPTABLE || ((TableGlobalVariable)object).getTableType() == TableType.REPORT ? this.createSimplePairedData((TableGlobalVariable)object, pairedDataContainer) : this.createTwoVarPairedData((TableGlobalVariable)object, pairedDataContainer);
        }
        return pairedDataContainer;
    }

    private PairedDataContainer createTwoVarPairedData(TableGlobalVariable tableGlobalVariable, PairedDataContainer pairedDataContainer) {
        int n = Integer.getInteger("GlobalVariableTable.InitialSize", 0);
        List<NameValuePair<String>> list = tableGlobalVariable.getIndependentList();
        List<NameValuePair<String>> list2 = tableGlobalVariable.getDependentList();
        pairedDataContainer.labelsUsed = true;
        int n2 = 0;
        if (list.size() > 1) {
            n2 = list.size() - 1;
        }
        pairedDataContainer.labels = new String[list2.size() + n2];
        pairedDataContainer.parameters = new String[list2.size() + n2];
        pairedDataContainer.units = new String[list2.size() + n2];
        int n3 = tableGlobalVariable.getNetwork().getUnitSystem();
        pairedDataContainer.yunits = Parameter.getUnitsStringForSystem((String)list2.get(0).getValue(), (int)n3);
        int n4 = 0;
        int n5 = 0;
        while (n5 < list2.size()) {
            pairedDataContainer.parameters[n5] = list2.get(n5).getValue();
            pairedDataContainer.units[n5] = Parameter.getUnitsStringForSystem((String)list2.get(n5).getValue(), (int)n3);
            n4 = n5++;
        }
        if (n2 > 0) {
            for (n5 = 1; n5 < list.size(); ++n5) {
                pairedDataContainer.parameters[n4 + 1] = list.get(n5).getValue();
                pairedDataContainer.units[n4 + n5] = Parameter.getUnitsStringForSystem((String)list.get(n5).getValue(), (int)n3);
            }
        }
        if (list2.size() == 1) {
            pairedDataContainer.yparameter = pairedDataContainer.parameters[0];
        }
        pairedDataContainer.numberCurves = list2.size() + n2;
        pairedDataContainer.numberOrdinates = n;
        pairedDataContainer.xOrdinates = new double[n];
        pairedDataContainer.xparameter = list.get(0).getValue();
        pairedDataContainer.xunits = Parameter.getUnitsStringForSystem((String)list.get(0).getValue(), (int)n3);
        pairedDataContainer.yOrdinates = new double[list2.size() + n2][n];
        String string = this.getDSSPathname();
        if (string == null || string.isEmpty()) {
            DSSPathname dSSPathname = new DSSPathname();
            dSSPathname.setBPart(tableGlobalVariable.getName());
            dSSPathname.setCPart(GlobalVariableUtils.a(tableGlobalVariable));
            dSSPathname.setEPart(GlobalVariableType.TABLE.toString());
            pairedDataContainer.fullName = dSSPathname.getPathname();
        } else {
            pairedDataContainer.fullName = string;
        }
        return pairedDataContainer;
    }

    private PairedDataContainer createSimplePairedData(TableGlobalVariable tableGlobalVariable, PairedDataContainer pairedDataContainer) {
        int n = Integer.getInteger("GlobalVariableTable.InitialSize", 0);
        List<NameValuePair<String>> list = tableGlobalVariable.getIndependentList();
        List<NameValuePair<String>> list2 = tableGlobalVariable.getDependentList();
        if (list.isEmpty() || list2.isEmpty()) {
            return null;
        }
        pairedDataContainer.labelsUsed = true;
        pairedDataContainer.labels = new String[list2.size()];
        pairedDataContainer.parameters = new String[list2.size()];
        pairedDataContainer.units = new String[list2.size()];
        int n2 = tableGlobalVariable.getNetwork().getUnitSystem();
        pairedDataContainer.yunits = Parameter.getUnitsStringForSystem((String)list2.get(0).getValue(), (int)n2);
        for (int i = 0; i < list2.size(); ++i) {
            pairedDataContainer.labels[i] = list2.get(i).getName();
            pairedDataContainer.parameters[i] = list2.get(i).getValue();
            pairedDataContainer.units[i] = Parameter.getUnitsStringForSystem((String)list2.get(i).getValue(), (int)n2);
        }
        if (list2.size() == 1) {
            pairedDataContainer.yparameter = pairedDataContainer.parameters[0];
        }
        pairedDataContainer.numberCurves = list2.size();
        pairedDataContainer.numberOrdinates = n;
        pairedDataContainer.xOrdinates = new double[n];
        pairedDataContainer.xparameter = list.get(0).getValue();
        pairedDataContainer.xunits = Parameter.getUnitsStringForSystem((String)list.get(0).getValue(), (int)n2);
        pairedDataContainer.yOrdinates = new double[list2.size()][n];
        String string = this.getDSSPathname();
        if (string == null || string.isEmpty()) {
            DSSPathname dSSPathname = new DSSPathname();
            dSSPathname.setBPart(tableGlobalVariable.getName());
            dSSPathname.setCPart(GlobalVariableUtils.a(tableGlobalVariable));
            dSSPathname.setEPart(GlobalVariableType.TABLE.toString());
            pairedDataContainer.fullName = dSSPathname.getPathname();
        } else {
            pairedDataContainer.fullName = string;
        }
        return pairedDataContainer;
    }

    @Override
    public GlobalVariableType getType() {
        return GlobalVariableType.TABLE;
    }

    @Override
    protected boolean finishWritingData(String string) {
        if (!this._isDSS) {
            return ((BaseAltGlobalData)this).writeDssData(string);
        }
        return true;
    }

    @Override
    public boolean writeDssData(String string) {
        boolean bl = true;
        if (!this._isDSS) {
            if (this.getValue() == null) {
                this.readPairedDataRecord(null);
            }
            bl = this.writeDssTextValue(string, this.getValue()) && this.writePairedDataRecord();
        }
        return bl;
    }

    private boolean writePairedDataRecord() {
        if (this.isDSS()) {
            return true;
        }
        if (this._pairedDataContainer != null) {
            Object object;
            Object object2 = null;
            if (this.a instanceof TableGlobalVariable) {
                object = (TableGlobalVariable)this.a;
                object2 = ((TableGlobalVariable)object).getTable();
                if ((object2 = this.getPairedDataFromTable(object2)) != null) {
                    this._pairedDataContainer = object2;
                }
                object2 = this.a.getNetwork().getGlobalVariableTablesFile();
            }
            if (object2 == null || this.getValue() == null) {
                return false;
            }
            this._pairedDataContainer.fullName = object = GlobalVariableUtils.a((TableGlobalVariable)this.a, this.getValue());
            this._pairedDataContainer.fileName = object2;
            try {
                int n = this.getGVDataSet().getDSSFileManager().write((DataContainer)this._pairedDataContainer);
                return n == 0;
            }
            catch (RemoteException remoteException) {
                return false;
            }
        }
        return true;
    }

    private PairedDataContainer getPairedDataFromTable(Object object) {
        if (object instanceof PairedValues) {
            return ((PairedValues)object).getPairedDataContainer();
        }
        if (object instanceof PairedValuesExt) {
            return ((PairedValuesExt)object).getPairedDataContainer();
        }
        if (object instanceof SeasonalPairedValues) {
            return ((SeasonalPairedValues)object).getPairedDataContainer();
        }
        return null;
    }

    public boolean readPairedDataRecord(String string) {
        try {
            String string2 = this.getDSSFilename();
            String string3 = this.getDSSPathname();
            if (string2 == null || string3 == null || string2.isEmpty() || string2.replace("/", "").isEmpty()) {
                return false;
            }
            string2 = new DSSIdentifier(string2, string3);
            if (!this.isDSS()) {
                if (string == null) {
                    string = this.readDssTextValue();
                    if (string != null) {
                        string = string.replaceAll("[\t\n\r]", "");
                    }
                    this.setValue(string);
                }
                if (string != null && this.a != null) {
                    string2 = GlobalVariableUtils.a((TableGlobalVariable)this.a, string);
                    this.setValue(string);
                    string = this.a.getNetwork().getGlobalVariableTablesFile();
                    if (string == null || string2.isEmpty()) {
                        return false;
                    }
                    string2 = new DSSIdentifier(string, string2);
                } else {
                    string2 = null;
                }
            }
            if (string2 != null) {
                this._pairedDataContainer = this.getGVDataSet().getDSSFileManager().readPairedDataContainer((DSSIdentifier)string2);
                if (this._pairedDataContainer != null && this._pairedDataContainer.numberCurves == 0) {
                    this._pairedDataContainer = null;
                }
            }
            return true;
        }
        catch (RemoteException remoteException) {
            RemoteException remoteException2 = remoteException;
            remoteException.printStackTrace();
            return false;
        }
    }

    @Override
    protected boolean finishReadingData() {
        if (!this.isDSS()) {
            return this.readPairedDataRecord(null);
        }
        return true;
    }

    @Override
    protected void parseGVRecord(String string, String string2) {
        if ("GVRecord IsDss".equals(string)) {
            this._isDSS = Boolean.parseBoolean(string2);
            return;
        }
        if ("GVRecord ModTime".equals(string)) {
            this._gvModifiedTime = RMAIO.parseLong((String)string2);
        }
    }

    @Override
    protected void writeAdditionalInfo(BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write("GVRecord IsDss=" + this._isDSS);
        bufferedWriter.newLine();
        bufferedWriter.write("GVRecord ModTime=" + this._gvModifiedTime);
        bufferedWriter.newLine();
    }

    @Override
    public void setGlobalVariable(GlobalVariable globalVariable) {
        super.setGlobalVariable(globalVariable);
        if (globalVariable instanceof TableGlobalVariable) {
            globalVariable = (TableGlobalVariable)globalVariable;
            long l = this.getGlobalVariableModifiedTime();
            if (((TableGlobalVariable)globalVariable).getModifiedTime() > l && l != 0L) {
                this.checkParams();
                this.setGlobalVariableModifiedTime(((TableGlobalVariable)globalVariable).getModifiedTime());
            }
        }
    }

    private void checkParams() {
    }

    @Override
    public boolean loadData() {
        return this.readPairedDataRecord(null);
    }

    private long getGlobalVariableModifiedTime() {
        return this._gvModifiedTime;
    }

    private void setGlobalVariableModifiedTime(long l) {
        this._gvModifiedTime = l;
    }

    public void markAsNewData(boolean bl) {
        this.b = bl;
    }

    public boolean isNewData() {
        return this.b;
    }

    static {
        Logger.getLogger(AltTableGlobalData.class.getName());
    }
}

