/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model.globalvariable;

import hec.clientapp.model.Manager;
import hec.clientapp.model.TSRecordImpl;
import hec.rss.model.GVDataSet;
import hec.rss.model.globalvariable.GlobalVariable;
import hec.rss.model.globalvariable.GlobalVariableData;
import hec.rss.model.globalvariable.GlobalVariableDataLocation;
import hec.rss.model.globalvariable.GlobalVariableType;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Objects;
import rma.util.RMAIO;

public class AltTimeSeriesGlobalData
extends TSRecordImpl
implements GlobalVariableData {
    private transient GlobalVariable a;
    private transient GVDataSet b;
    private GlobalVariableDataLocation _gvDataLocation = new GlobalVariableDataLocation();
    private transient boolean c = false;

    public AltTimeSeriesGlobalData() {
    }

    public AltTimeSeriesGlobalData(GlobalVariable globalVariable) {
        this.a = globalVariable;
        AltTimeSeriesGlobalData altTimeSeriesGlobalData = this;
        altTimeSeriesGlobalData.setName(altTimeSeriesGlobalData.a.getName());
        this.setIndex(globalVariable.getIndex());
    }

    @Override
    public GlobalVariableType getType() {
        return GlobalVariableType.TIME_SERIES;
    }

    @Override
    public String getValue() {
        return null;
    }

    @Override
    public void setGVDataSet(GVDataSet gVDataSet) {
        this.b = gVDataSet;
    }

    @Override
    public GVDataSet getGVDataSet() {
        return this.b;
    }

    public String getDSSFilePath() {
        return this._dssFilename;
    }

    @Override
    public boolean readData(BufferedReader bufferedReader) {
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.length() == 0) continue;
                if (string.indexOf("GVRecord") < 0) break;
                String string2 = RMAIO.getType((String)string, (String)"=");
                string = RMAIO.getParam((String)string, (String)"=").trim();
                if ("GVRecord Name".equalsIgnoreCase(string2)) {
                    this.setName(string);
                    continue;
                }
                if ("GVRecord ID".equalsIgnoreCase(string2)) {
                    this.setIndex(RMAIO.parseInt((String)string));
                    continue;
                }
                if ("GVRecord DssFilename".equalsIgnoreCase(string2)) {
                    string = this.getGVDataSet().makeAbsolutePath(string);
                    this.setDSSFilename(string);
                    continue;
                }
                if ("GVRecord DssPathname".equalsIgnoreCase(string2)) {
                    this.setDSSPathname(string);
                    continue;
                }
                if ("GVRecord End".equalsIgnoreCase(string2)) break;
                if (this._gvDataLocation.parseVariable(string2, string)) continue;
                this.parseGVRecord(string2, string);
            }
            if (this.finishdReadingData()) {
                return true;
            }
        }
        catch (IOException iOException) {}
        return false;
    }

    protected void parseGVRecord(String string, String string2) {
    }

    @Override
    public boolean writeData(BufferedWriter bufferedWriter, String string) {
        try {
            bufferedWriter.write("GVRecord Name=" + this.getName());
            bufferedWriter.newLine();
            bufferedWriter.write("GVRecord ID=" + this.getIndex());
            bufferedWriter.newLine();
            if (string == null) {
                string = this.getDSSFilename();
            }
            bufferedWriter.write("GVRecord DssFilename=" + this.getRelativePath(string));
            bufferedWriter.newLine();
            string = this.getDSSPathname();
            bufferedWriter.write("GVRecord DssPathname=" + (string != null ? string : ""));
            bufferedWriter.newLine();
            this._gvDataLocation.writeData(bufferedWriter);
            this.writeAdditionalInfo(bufferedWriter);
            bufferedWriter.write("GVRecord End");
            bufferedWriter.newLine();
            if (this.finishWritingData()) {
                return true;
            }
        }
        catch (IOException iOException) {
            System.out.println("Failed write global variable record " + this.getName() + " error:" + String.valueOf(iOException));
        }
        return false;
    }

    protected void writeAdditionalInfo(BufferedWriter bufferedWriter) throws IOException {
    }

    protected boolean finishWritingData() {
        return true;
    }

    protected boolean finishdReadingData() {
        return true;
    }

    public String getRelativePath(String string) {
        return this.b.getRelativePath(string);
    }

    public Manager getDataSet() {
        return this.b;
    }

    public String getAltName() {
        return this.b.getAltName();
    }

    @Override
    public AltTimeSeriesGlobalData clone() {
        AltTimeSeriesGlobalData altTimeSeriesGlobalData = (AltTimeSeriesGlobalData)super.clone();
        return altTimeSeriesGlobalData;
    }

    @Override
    public boolean loadData() {
        return true;
    }

    @Override
    public boolean writeDssData(String string) {
        String string2 = null;
        if (string != null) {
            string2 = this._dssFilename;
            this._dssFilename = string;
        }
        boolean bl = this.writeTSData();
        if (string2 != null) {
            this._dssFilename = string2;
        }
        return bl;
    }

    @Override
    public void setValue(Object object) {
    }

    @Override
    public GlobalVariableDataLocation getGlobalVariableDataLocation() {
        if (this.a != null) {
            this._gvDataLocation.setIsDataLocation(this.a.getIsDataLocation());
        }
        return this._gvDataLocation;
    }

    @Override
    public void setGlobalVariable(GlobalVariable globalVariable) {
        this.a = globalVariable;
    }

    @Override
    public boolean readDssData(String string, String string2) {
        return true;
    }

    protected boolean isInputData() {
        if (this.a != null) {
            return this.a.isInput();
        }
        return super.isInputData();
    }

    @Override
    public boolean copyInto(GlobalVariableData globalVariableData) {
        if (globalVariableData == null || !globalVariableData.getClass().equals(this.getClass())) {
            return false;
        }
        this._dssFilename = globalVariableData.getDSSFilename();
        this._dssPathname = globalVariableData.getDSSPathname();
        this._gvDataLocation = globalVariableData.getGlobalVariableDataLocation().clone();
        return true;
    }

    @Override
    public void markForDelete(boolean bl) {
        this.c = bl;
    }

    @Override
    public boolean isMarkedForDeletion() {
        return this.c;
    }

    public void setCurrentValue(int n, double d) {
        if (this.isInputData()) {
            this.b.printWarningMessage("TimeSeries Global Variable " + this.getName() + " is an Input Global Variable, it can't have its value set");
            return;
        }
        super.setCurrentValue(n, d);
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        object = (AltTimeSeriesGlobalData)object;
        return Objects.equals(this.getName(), object.getName());
    }

    public int hashCode() {
        return Objects.hashCode(this.getName());
    }
}

