/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model.globalvariable;

import hec.heclib.dss.DSSPathname;
import hec.io.DSSIdentifier;
import hec.lang.NamedType;
import hec.rss.model.GVDataSet;
import hec.rss.model.globalvariable.GlobalVariable;
import hec.rss.model.globalvariable.GlobalVariableData;
import hec.rss.model.globalvariable.GlobalVariableDataLocation;
import hec.rss.model.globalvariable.GlobalVariableType;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Objects;
import rma.util.RMAIO;

public abstract class BaseAltGlobalData
extends NamedType
implements GlobalVariableData {
    protected String _value;
    protected transient GlobalVariable a;
    private String _dssFilename;
    private transient GVDataSet b;
    private String _dssPathname;
    private GlobalVariableDataLocation _gvDataLocation = new GlobalVariableDataLocation();
    private transient boolean c = false;

    public BaseAltGlobalData() {
    }

    public BaseAltGlobalData(GlobalVariable globalVariable, String string) {
        this.a = globalVariable;
        BaseAltGlobalData baseAltGlobalData = this;
        baseAltGlobalData.setName(baseAltGlobalData.a.getName());
        this._value = string;
        this.setIndex(globalVariable.getIndex());
    }

    @Override
    public String getValue() {
        return this._value;
    }

    @Override
    public abstract GlobalVariableType getType();

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setValue(Object object) {
        if (this.a == null && object != null) {
            this._value = object.toString();
            return;
        }
        if (this.canCoerceValue(object) && object != null) {
            Object object2 = this.getCoercedValue(object);
            if (object2 != null) {
                this._value = object2.toString();
                return;
            }
            this._value = object.toString();
            return;
        }
        this.b.printWarningMessage("Failed to set value '" + String.valueOf(object) + "' on Global Variable " + String.valueOf(this.a));
        this._value = null;
    }

    protected Object getCoercedValue(Object object) {
        return object.toString();
    }

    protected boolean canCoerceValue(Object object) {
        return true;
    }

    @Override
    public String getDSSFilename() {
        if (this._dssFilename == null) {
            return "";
        }
        return this._dssFilename;
    }

    @Override
    public void setDSSFilename(String string) {
        this._dssFilename = string;
    }

    private GlobalVariableType parseType(String string) {
        return GlobalVariableType.valueOf(string);
    }

    public String getRelativePath(String string) {
        return this.b.getRelativePath(string);
    }

    @Override
    public void setGVDataSet(GVDataSet gVDataSet) {
        this.b = gVDataSet;
    }

    @Override
    public GVDataSet getGVDataSet() {
        return this.b;
    }

    @Override
    public String getDSSPathname() {
        return this.getDSSPathname(false);
    }

    public String getDSSPathname(boolean bl) {
        if (bl) {
            String string = this.b.getName();
            if (string != null) {
                string = string.replace(":", "");
            }
            DSSPathname dSSPathname = new DSSPathname(this._dssPathname);
            dSSPathname.setBPart(this.getName());
            dSSPathname.setDPart(this.getType().toString());
            dSSPathname.setFPart(string);
            this._dssPathname = dSSPathname.getPathname();
        }
        return this._dssPathname;
    }

    @Override
    public void setDSSPathname(String string) {
        this._dssPathname = string;
    }

    protected String getDssEPart() {
        return "";
    }

    protected boolean writeDssTextValue(String string, Object object) {
        if (object == null) {
            return true;
        }
        if (string == null) {
            string = this.getDSSFilename();
        }
        string = new DSSIdentifier(string, this.getDSSPathname());
        try {
            return this.b.getDSSFileManager().writeTextData((DSSIdentifier)string, object.toString()) == 0;
        }
        catch (RemoteException remoteException) {
            System.out.println("writeDssTextValue:exception writing DSS data for " + this.getName() + " error:" + String.valueOf(remoteException));
            return false;
        }
    }

    @Override
    public boolean loadData() {
        this._value = this.readDssTextValue();
        return this._value != null;
    }

    @Override
    public boolean readDssData(String string, String string2) {
        if ((string = this.readDssTextValue(string, string2)) != null) {
            this._value = string.trim();
        }
        return true;
    }

    protected String readDssTextValue() {
        BaseAltGlobalData baseAltGlobalData = this;
        return baseAltGlobalData.readDssTextValue(baseAltGlobalData.getDSSFilename(), this.getDSSPathname());
    }

    protected String readDssTextValue(String string, String string2) {
        DSSIdentifier dSSIdentifier = new DSSIdentifier(string, string2);
        try {
            if (this.b.getFileManager().fileExists(string)) {
                dSSIdentifier = this.b.getDSSFileManager().readTextData(dSSIdentifier);
                if (dSSIdentifier != null) {
                    return dSSIdentifier.text;
                }
                System.out.println("readDssTextValue:" + this.getName() + " Failed to find DSS path " + string2 + " in file " + string);
            } else {
                System.out.println("readDssTextValue:" + this.getName() + " Failed to find DSS file " + string);
            }
        }
        catch (RemoteException remoteException) {
            System.out.println("readDssTextValue:exception writing DSS data for " + this.getName() + " error:" + String.valueOf(remoteException));
        }
        return null;
    }

    @Override
    public boolean writeData(BufferedWriter bufferedWriter, String string) {
        try {
            bufferedWriter.write("GVRecord Name=" + this.getName());
            bufferedWriter.newLine();
            bufferedWriter.write("GVRecord ID=" + this.getIndex());
            bufferedWriter.newLine();
            String string2 = string;
            if (string2 == null) {
                string2 = this.getDSSFilename();
            }
            bufferedWriter.write("GVRecord DssFilename=" + this.getRelativePath(string2));
            bufferedWriter.newLine();
            string2 = this.getDSSPathname();
            bufferedWriter.write("GVRecord DssPathname=" + (string2 != null ? string2 : ""));
            bufferedWriter.newLine();
            this._gvDataLocation.writeData(bufferedWriter);
            this.writeAdditionalInfo(bufferedWriter);
            bufferedWriter.write("GVRecord End");
            bufferedWriter.newLine();
            if (this.finishWritingData(string)) {
                return true;
            }
        }
        catch (IOException iOException) {
            System.out.println("Failed write global variable record " + this.getName() + " error:" + String.valueOf(iOException));
        }
        return false;
    }

    protected void writeAdditionalInfo(BufferedWriter bufferedWriter) throws IOException {
    }

    @Override
    public boolean readData(BufferedReader bufferedReader) {
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.length() == 0) continue;
                if (string.indexOf("GVRecord") < 0) break;
                String string2 = RMAIO.getType((String)string, (String)"=");
                string = RMAIO.getParam((String)string, (String)"=").trim();
                if ("GVRecord Name".equalsIgnoreCase(string2)) {
                    this.setName(string);
                    continue;
                }
                if ("GVRecord ID".equalsIgnoreCase(string2)) {
                    this.setIndex(RMAIO.parseInt((String)string));
                    continue;
                }
                if ("GVRecord DssFilename".equalsIgnoreCase(string2)) {
                    if (!RMAIO.isFullPath((String)string)) {
                        string = this.getGVDataSet().makeAbsolutePath(string);
                    }
                    this.setDSSFilename(string);
                    continue;
                }
                if ("GVRecord DssPathname".equalsIgnoreCase(string2)) {
                    this.setDSSPathname(string);
                    continue;
                }
                if ("GVRecord End".equalsIgnoreCase(string2)) break;
                if (this._gvDataLocation.parseVariable(string2, string)) continue;
                this.parseGVRecord(string2, string);
            }
            if (this.finishReadingData()) {
                return true;
            }
        }
        catch (IOException iOException) {}
        return false;
    }

    protected void parseGVRecord(String string, String string2) {
    }

    @Override
    public abstract boolean writeDssData(String var1);

    protected boolean finishWritingData(String string) {
        return true;
    }

    protected boolean finishReadingData() {
        return true;
    }

    @Override
    public void setGlobalVariable(GlobalVariable globalVariable) {
        this.a = globalVariable;
    }

    @Override
    public GlobalVariableData clone() {
        try {
            BaseAltGlobalData baseAltGlobalData = (BaseAltGlobalData)super.clone();
            if (this._gvDataLocation != null) {
                baseAltGlobalData._gvDataLocation = this._gvDataLocation.clone();
            }
            return baseAltGlobalData;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public GlobalVariableDataLocation getGlobalVariableDataLocation() {
        if (this.a != null) {
            this._gvDataLocation.setIsDataLocation(this.a.getIsDataLocation());
        }
        return this._gvDataLocation;
    }

    @Override
    public boolean copyInto(GlobalVariableData globalVariableData) {
        if (globalVariableData == null || !globalVariableData.getClass().equals(this.getClass())) {
            return false;
        }
        this._dssFilename = globalVariableData.getDSSFilename();
        this._dssPathname = globalVariableData.getDSSPathname();
        this._gvDataLocation = globalVariableData.getGlobalVariableDataLocation().clone();
        return true;
    }

    @Override
    public void markForDelete(boolean bl) {
        this.c = bl;
    }

    @Override
    public boolean isMarkedForDeletion() {
        return this.c;
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        object = (BaseAltGlobalData)object;
        return Objects.equals(this.getName(), object.getName());
    }

    public int hashCode() {
        return Objects.hashCode(this.getName());
    }
}

