/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model.globalvariable;

import hec.lang.NamedType;
import hec.lang.annotation.Scriptable;
import hec.rss.model.GVDataSet;
import hec.rss.model.RssSystem;
import hec.rss.model.globalvariable.GlobalVariable;
import hec.rss.model.globalvariable.GlobalVariableData;
import hec.rss.model.reports.AlternativeInputReport;
import java.lang.reflect.Field;
import org.jdom.Element;

public abstract class BaseGlobalVariable
extends NamedType
implements GlobalVariable {
    private boolean _isInput = true;
    protected RssSystem _network;
    protected transient GlobalVariableData a;
    private boolean _isDataLocation;

    public BaseGlobalVariable() {
    }

    public BaseGlobalVariable(RssSystem rssSystem) {
        this();
        this._network = rssSystem;
    }

    @Override
    public BaseGlobalVariable clone() {
        try {
            return (BaseGlobalVariable)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            CloneNotSupportedException cloneNotSupportedException2 = cloneNotSupportedException;
            cloneNotSupportedException.printStackTrace();
            return null;
        }
    }

    @Override
    @Scriptable
    public boolean isInput() {
        return this._isInput;
    }

    @Override
    public void setInput(boolean bl) {
        this._isInput = bl;
    }

    @Scriptable
    public String getUsageType() {
        if (this.isInput()) {
            return "Input";
        }
        return "Output";
    }

    @Override
    public boolean initializeGv() {
        if (this._network == null) {
            return false;
        }
        GVDataSet gVDataSet = this.isInput() ? this._network.getRssRun().getInputGVData() : this._network.getOutputGVDataSet();
        GlobalVariableData globalVariableData = gVDataSet.getGlobalVariableData(this._index, this.getType());
        if (globalVariableData != null && globalVariableData.getType() == this.getType()) {
            this.a = globalVariableData;
        }
        if (this.a == null) {
            this._network.printLogMessage("Warning:No Global Variable Data for " + String.valueOf((Object)this.getType()) + " " + this.getName() + " found in GVDataSet " + gVDataSet.getName());
        }
        return this.a != null;
    }

    @Override
    public void setGlobalVariableData(GlobalVariableData globalVariableData) {
        this.a = globalVariableData;
        if (this.a != null) {
            this.a.setGlobalVariable(this);
        }
    }

    @Scriptable
    public void printToComputeLog() {
        if (this._network != null) {
            String string = this.getComputeMsg();
            this._network.printLogMessage(string);
        }
    }

    protected String getComputeMsg() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.valueOf((Object)this.getType()) + " Global Variable:" + this.getName());
        if (this.a != null) {
            stringBuilder.append(" Value:" + this.a.getValue());
        }
        return stringBuilder.toString();
    }

    @Scriptable
    public void printToComputeWindow() {
        if (this._network != null) {
            String string = this.getComputeMsg();
            this._network.printMessage(string);
        }
    }

    @Override
    public void finalizeCompute() {
        this.a = null;
    }

    @Override
    @Scriptable
    public RssSystem getNetwork() {
        return this._network;
    }

    @Override
    public String hasValidValue() {
        return null;
    }

    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            return super.setFieldObject(field, object);
        }
    }

    @Override
    public void setIsDataLocation(boolean bl) {
        this._isDataLocation = bl;
    }

    @Override
    public boolean getIsDataLocation() {
        return this._isDataLocation;
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, Element element) {
        element.setAttribute("Name", this._name);
        element.setAttribute("Description", this._description);
        element.setAttribute("GlobalVariableType", this.getType().toString());
        element.setAttribute("UsageType", this.getUsageType());
        element.setAttribute("IsDataLocation", String.valueOf(this.getIsDataLocation()));
    }
}

