/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model.globalvariable;

import hec.clientapp.util.DssDefaultFileVersionInfo;
import hec.clientapp.util.DssUtilities;
import hec.clientapp.util.DssVersion;
import hec.heclib.dss.DSSPathname;
import hec.heclib.util.HecTime;
import hec.model.RunTimeStep;
import hec.model.RunTimeWindow;
import hec.rss.model.DayOfWeek;
import hec.rss.model.NameValuePair;
import hec.rss.model.globalvariable.ScalarDataType;
import hec.rss.model.globalvariable.ScalarGlobalVariable;
import hec.rss.model.globalvariable.StringGlobalVariable;
import hec.rss.model.globalvariable.TableGlobalVariable;
import java.time.DateTimeException;
import java.time.LocalTime;
import java.time.Month;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.List;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class GlobalVariableUtils {
    public static final String SEASONAL_DATE = "Seasonal Date";
    public static final String DATE = "Date";

    private GlobalVariableUtils() {
    }

    public static String a(ScalarGlobalVariable scalarGlobalVariable) {
        if (scalarGlobalVariable == null) {
            return null;
        }
        Object object = scalarGlobalVariable.getDataType().toString();
        if (scalarGlobalVariable.isSelection()) {
            object = (String)object + "-Selection";
        }
        return object;
    }

    public static String a(StringGlobalVariable stringGlobalVariable) {
        if (stringGlobalVariable.isSelection()) {
            return "Selection";
        }
        return "";
    }

    public static String a(TableGlobalVariable object) {
        StringBuilder stringBuilder = new StringBuilder();
        if (object != null) {
            Object object2;
            int n;
            List<NameValuePair<String>> list = ((TableGlobalVariable)object).getIndependentList();
            object = ((TableGlobalVariable)object).getDependentList();
            for (n = 0; n < list.size(); ++n) {
                if (n > 0) {
                    stringBuilder.append("-");
                }
                object2 = list.get(n);
                if ((object2 = ((NameValuePair)object2).getValue()) == null) continue;
                stringBuilder.append((String)object2);
            }
            for (n = 0; n < object.size(); ++n) {
                stringBuilder.append("-");
                object2 = (NameValuePair)object.get(n);
                object2 = (String)((NameValuePair)object2).getValue();
                if (object2 == null) continue;
                stringBuilder.append((String)object2);
            }
        }
        return stringBuilder.toString();
    }

    public static Object a(RunTimeStep object, RunTimeWindow runTimeWindow, String string, ScalarDataType scalarDataType) {
        if (string == null) {
            return null;
        }
        Object object2 = string.toString();
        object2 = object2 != null ? ((String)object2).trim() : object2;
        switch (scalarDataType) {
            case INTEGER: {
                int n = RMAIO.parseInt((String)object2);
                if (RMAConst.isValidValue((int)n)) {
                    return n;
                }
                double d = RMAIO.parseDouble((String)object2);
                if (RMAConst.isValidValue((double)d)) {
                    return (int)d;
                }
                return null;
            }
            case DOUBLE: {
                double d = RMAIO.parseDouble((String)object2);
                if (RMAConst.isValidValue((double)d)) {
                    return d;
                }
                return null;
            }
            case BOOLEAN: {
                int n = RMAIO.parseInt((String)string);
                if (RMAConst.isValidValue((int)n)) {
                    return n != 0;
                }
                return Boolean.parseBoolean((String)object2);
            }
            case DAYOFWEEK: {
                object = DayOfWeek.a((String)object2);
                if (object == null) {
                    int n = RMAIO.parseInt((String)object2);
                    object = DayOfWeek.a(n);
                }
                return object;
            }
            case DATE: {
                return new HecTime((String)object2);
            }
            case MONTHOFYEAR: {
                return GlobalVariableUtils.b((String)object2);
            }
            case DATEANDTIME: {
                object = new HecTime((String)object2);
                if (!object.isDefined()) break;
                return object;
            }
            case SEASONAL_DATE: {
                HecTime hecTime;
                int n = object != null ? object.getHecTime().year() : (runTimeWindow != null ? runTimeWindow.getStartTime().year() : 1900);
                if (((String)object2).split("-").length < 2) {
                    object2 = (String)object2 + n;
                }
                if (!(hecTime = new HecTime((String)object2)).isDateDefined()) break;
                return hecTime;
            }
            case TIME: {
                object = DateTimeFormatter.ofPattern("HHmm");
                int n = RMAIO.parseInt((String)object2);
                if (!RMAConst.isValidValue((int)n)) break;
                object2 = String.format("%04d", n);
                try {
                    object = LocalTime.parse((CharSequence)object2, (DateTimeFormatter)object);
                    return object;
                }
                catch (DateTimeParseException dateTimeParseException) {
                    object = LocalTime.parse((CharSequence)object2);
                    return object;
                }
            }
        }
        return null;
    }

    public static String a(TableGlobalVariable tableGlobalVariable, String string) {
        if (tableGlobalVariable == null) {
            return "";
        }
        DSSPathname dSSPathname = new DSSPathname();
        dSSPathname.setBPart(string);
        dSSPathname.setCPart(GlobalVariableUtils.a(tableGlobalVariable));
        dSSPathname.setFPart(tableGlobalVariable.getTableType().toString());
        return dSSPathname.getPathname();
    }

    private static Object b(String monthArray) {
        String string = monthArray.toUpperCase();
        Month month = null;
        try {
            month = Month.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                month = Month.of(RMAIO.parseInt((String)monthArray));
            }
            catch (DateTimeException dateTimeException) {
                monthArray = Month.values();
                for (int i = 0; i < monthArray.length; ++i) {
                    if (!monthArray[i].toString().startsWith(string)) continue;
                    return monthArray[i];
                }
            }
        }
        return month;
    }

    public static String a(String string) {
        String string2 = string;
        DssDefaultFileVersionInfo dssDefaultFileVersionInfo = DssUtilities.getDefaultDssFileVersion();
        if (dssDefaultFileVersionInfo.getDssVersion() == DssVersion.SIX) {
            string2 = string.toUpperCase();
        }
        return string2;
    }
}

