/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model.globalvariable;

import hec.heclib.util.HecTime;
import hec.lang.annotation.Scriptable;
import hec.model.RunTimeStep;
import hec.model.RunTimeWindow;
import hec.rss.model.DayOfWeek;
import hec.rss.model.RssSystem;
import hec.rss.model.globalvariable.BaseGlobalVariable;
import hec.rss.model.globalvariable.GlobalVariable;
import hec.rss.model.globalvariable.GlobalVariableType;
import hec.rss.model.globalvariable.GlobalVariableUtils;
import hec.rss.model.globalvariable.ScalarDataType;
import hec.rss.model.reports.AlternativeInputReport;
import java.lang.reflect.Field;
import java.time.Month;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class ScalarGlobalVariable
extends BaseGlobalVariable
implements GlobalVariable {
    public static final String DATE_TIME_FORMAT = "ddMMMyyyy HHmm";
    public static final String SEASONAL_DATE_FORMAT = "ddMMM";
    public static final String DATE_FORMAT = "ddMMMyyyy";
    private ScalarDataType _dataType = ScalarDataType.INTEGER;
    private List<String> _selectionList = new ArrayList<String>();
    private String _minLimit;
    private String _maxLimit;
    private boolean _isSelectionList = false;
    private boolean _isMinSelected = false;
    private boolean _isMaxSelected = false;
    private String _parameter;

    public ScalarGlobalVariable() {
    }

    public ScalarGlobalVariable(RssSystem rssSystem) {
        super(rssSystem);
    }

    @Override
    public ScalarGlobalVariable clone() {
        ScalarGlobalVariable scalarGlobalVariable = (ScalarGlobalVariable)super.clone();
        scalarGlobalVariable.setDataType(this.getDataType());
        List<String> list = this.getSelectionList();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.addAll(list);
        for (int i = 0; i < arrayList2.size(); ++i) {
            arrayList.add((String)arrayList2.get(i));
        }
        scalarGlobalVariable.setSelectionList(arrayList);
        return scalarGlobalVariable;
    }

    @Override
    public GlobalVariableType getType() {
        return GlobalVariableType.SCALAR;
    }

    public void setSelectionList(List<String> list) {
        if (this.isInput() && this.a != null) {
            return;
        }
        this._selectionList = list;
    }

    @Scriptable
    public void setValue(Object object) {
        if (this.isInput()) {
            return;
        }
        if (this.a != null) {
            this.a.setValue(object);
        }
    }

    @Scriptable
    public void setValue(int n) {
        if (this.isInput()) {
            return;
        }
        if (this.a != null) {
            this.a.setValue(n);
        }
    }

    @Scriptable
    public void setValue(double d) {
        if (this.isInput()) {
            return;
        }
        if (this.a != null) {
            this.a.setValue(d);
        }
    }

    @Scriptable
    public void setValue(boolean bl) {
        if (this.isInput()) {
            return;
        }
        if (this.a != null) {
            this.a.setValue(bl);
        }
    }

    @Scriptable
    public void setMinLimit(Object object) {
        if (this.isInput() && this.a == null) {
            if (object != null && !object.toString().isEmpty()) {
                if (GlobalVariableUtils.a(null, null, object.toString(), this.getDataType()) != null) {
                    this._minLimit = object.toString();
                    return;
                }
            } else {
                this._minLimit = null;
            }
        }
    }

    @Scriptable
    public void setMinLimit(int n) {
        if (this.isInput() && this.a == null && this.getDataType() == ScalarDataType.INTEGER) {
            this._minLimit = String.valueOf(n);
        }
    }

    @Scriptable
    public void setMinLimit(double d) {
        if (this.isInput() && this.a == null && this.getDataType() == ScalarDataType.DOUBLE) {
            this._minLimit = String.valueOf(d);
        }
    }

    @Scriptable
    public Object getMinLimit() {
        return this.getValueAsType(null, this._minLimit);
    }

    @Scriptable
    public Object getMinLimit(RunTimeStep runTimeStep) {
        return this.getValueAsType(runTimeStep, this._minLimit);
    }

    @Scriptable
    public Object getMaxLimit() {
        return this.getValueAsType(null, this._maxLimit);
    }

    @Scriptable
    public Object getMaxLimit(RunTimeStep runTimeStep) {
        return this.getValueAsType(runTimeStep, this._maxLimit);
    }

    @Scriptable
    public void setMaxLimit(Object object) {
        if (this.isInput() && this.a == null) {
            if (object != null && !object.toString().isEmpty()) {
                if (GlobalVariableUtils.a(null, null, object.toString(), this.getDataType()) != null) {
                    this._maxLimit = object.toString();
                    return;
                }
            } else {
                this._maxLimit = null;
            }
        }
    }

    @Scriptable
    public void setMaxLimit(int n) {
        if (this.isInput() && this.a == null && this.getDataType() == ScalarDataType.INTEGER) {
            this._maxLimit = String.valueOf(n);
        }
    }

    @Scriptable
    public void setMaxLimit(double d) {
        if (this.isInput() && this.a == null && this.getDataType() == ScalarDataType.DOUBLE) {
            this._maxLimit = String.valueOf(d);
        }
    }

    @Scriptable
    public List<String> getSelectionList() {
        return Collections.unmodifiableList(this._selectionList);
    }

    @Scriptable
    public void appendToSelectionList(Object object) {
        if (object != null && !this._selectionList.contains(object = object.toString())) {
            this._selectionList.add((String)object);
        }
    }

    @Scriptable
    public void appendToSelectionList(int n) {
        String string = String.valueOf(n);
        this.appendToSelectionList(string);
    }

    @Scriptable
    public void appendToSelectionList(double d) {
        String string = String.valueOf(d);
        this.appendToSelectionList(string);
    }

    @Scriptable
    public int getSelectionListIndex() {
        String string;
        if (this.isSelection() && this.a != null && (string = this.a.getValue()) != null) {
            int n = this._selectionList.indexOf(string);
            if (n == -1) {
                return n;
            }
            return n + 1;
        }
        return -2;
    }

    @Scriptable
    public int getSelectionListLength() {
        return this._selectionList.size();
    }

    @Scriptable
    public boolean isSelection() {
        return this._isSelectionList;
    }

    @Scriptable
    public ScalarDataType getDataType() {
        return this._dataType;
    }

    @Scriptable
    public Object getValue() {
        if (this.a != null) {
            String string = this.a.getValue();
            return this.getValueAsType(null, string);
        }
        return null;
    }

    @Scriptable
    public Object getValue(RunTimeStep runTimeStep) {
        if (this.a != null) {
            String string = this.a.getValue();
            return this.getValueAsType(runTimeStep, string);
        }
        return null;
    }

    private Object getValueAsType(RunTimeStep runTimeStep, String string) {
        RunTimeWindow runTimeWindow = null;
        if (this._network.getRssRun() != null) {
            runTimeWindow = this._network.getRssRun().getRunTimeWindow();
        }
        return GlobalVariableUtils.a(runTimeStep, runTimeWindow, string, this.getDataType());
    }

    public void setDataType(ScalarDataType scalarDataType) {
        this._dataType = scalarDataType;
    }

    public void setIsSelectionList(boolean bl) {
        this._isSelectionList = bl;
    }

    public void setIsMinSelected(boolean bl) {
        this._isMinSelected = bl;
    }

    public void setIsMaxSelected(boolean bl) {
        this._isMaxSelected = bl;
    }

    public boolean isSelectionList() {
        return this._isSelectionList;
    }

    public boolean isMinSelected() {
        return this._isMinSelected;
    }

    public boolean isMaxSelected() {
        return this._isMaxSelected;
    }

    public String getMinLimitAsString() {
        String string = this._minLimit;
        if (this.getDataType() == ScalarDataType.TIME && this._minLimit != null) {
            string = String.format("%04d", RMAIO.parseInt((String)this._minLimit));
        }
        return string;
    }

    public String getMaxLimitAsString() {
        String string = this._maxLimit;
        if (this.getDataType() == ScalarDataType.TIME && this._maxLimit != null) {
            string = String.format("%04d", RMAIO.parseInt((String)this._maxLimit));
        }
        return string;
    }

    @Override
    public String getDescriptiveText() {
        return (this.isInput() ? "Input " : "Output ") + String.valueOf((Object)this.getDataType()) + " Global Variable " + this.getName();
    }

    public String getParameter() {
        ScalarDataType scalarDataType = this.getDataType();
        if (ScalarDataType.INTEGER == scalarDataType || ScalarDataType.DOUBLE == scalarDataType) {
            return this._parameter;
        }
        return scalarDataType.toString();
    }

    public void setParameter(String string) {
        this._parameter = string;
    }

    @Override
    public String hasValidValue() {
        Object object = this.getValue();
        if (object == null) {
            return null;
        }
        Object object2 = this.getDataType();
        if (!(this.isMaxSelected() || this.isMinSelected() || this.isSelectionList())) {
            return null;
        }
        if (ScalarDataType.INTEGER == object2) {
            Object object3;
            int n;
            if (object instanceof Double) {
                n = ((Double)object).intValue();
            } else {
                if (!(object instanceof Integer)) {
                    return "Value for Scalar Global Variable " + this.getName() + " is not an Integer. Its a " + object.getClass().getName();
                }
                n = (Integer)object;
            }
            if (this.isMinSelected()) {
                object2 = Integer.MIN_VALUE;
                object3 = this.getMinLimit();
                if (object3 instanceof Double) {
                    object2 = ((Double)object3).intValue();
                } else if (object3 instanceof Integer) {
                    object2 = (Integer)object3;
                }
                if (RMAConst.isValidValue((int)((Integer)object2)) && n < (Integer)object2) {
                    return "Value (" + n + ") for Scalar Global Variable " + this.getName() + " is less than the minimum (" + (Integer)object2 + ") allowed";
                }
            }
            if (this.isMaxSelected()) {
                object2 = Integer.MIN_VALUE;
                object3 = this.getMaxLimit();
                if (object3 instanceof Double) {
                    object2 = ((Double)object3).intValue();
                } else if (object3 instanceof Integer) {
                    object2 = (Integer)object3;
                }
                if (RMAConst.isValidValue((int)((Integer)object2)) && n > (Integer)object2) {
                    return "Value (" + n + ") for Scalar Global Variable " + this.getName() + " is greater than the maximum (" + (Integer)object2 + ") allowed";
                }
            }
            if ((object2 = this.checkSelectionList(String.valueOf(n))) != null) {
                return object2;
            }
        } else if (ScalarDataType.BOOLEAN == object2) {
            if (object instanceof Boolean) {
                return "Value for Scalar Global Variable " + this.getName() + " is not an Boolean. Its a " + object.getClass().getName();
            }
        } else if (ScalarDataType.DATE == object2 || ScalarDataType.DATEANDTIME == object2 || ScalarDataType.SEASONAL_DATE == object2 || ScalarDataType.TIME == object2) {
            if (object instanceof HecTime) {
                return "Value for Scalar Global Variable " + this.getName() + " is not a HecTime. Its a " + object.getClass().getName();
            }
            object = (HecTime)object;
            if (this.isMinSelected() && object.lessThan((HecTime)(object2 = (HecTime)this.getMinLimit()))) {
                return "Value (" + String.valueOf(object) + ") for Scalar Global Variable " + this.getName() + " is less than the minimum (" + String.valueOf(object2) + ") allowed";
            }
            if (this.isMaxSelected() && object.greaterThan((HecTime)(object2 = (HecTime)this.getMaxLimit()))) {
                return "Value (" + String.valueOf(object) + ") for Scalar Global Variable " + this.getName() + " is greater than the maximum (" + String.valueOf(object2) + ") allowed";
            }
            object2 = this.checkSelectionList(String.valueOf(object));
            if (object2 != null) {
                return object2;
            }
        } else if (ScalarDataType.DAYOFWEEK == object2) {
            if (object instanceof DayOfWeek) {
                return "Value for Scalar Global Variable " + this.getName() + " is not a hec.model.DayOfWeek. Its a " + object.getClass().getName();
            }
            object = (DayOfWeek)((Object)object);
            if (this.isMinSelected() && ((Enum)object).compareTo(object2 = (DayOfWeek)((Object)this.getMinLimit())) < 0) {
                return "Value (" + String.valueOf(object) + ") for Scalar Global Variable " + this.getName() + " is less than the minimum (" + String.valueOf(object2) + ") allowed";
            }
            if (this.isMaxSelected() && ((Enum)object).compareTo(object2 = (DayOfWeek)((Object)this.getMaxLimit())) > 0) {
                return "Value (" + String.valueOf(object) + ") for Scalar Global Variable " + this.getName() + " is greater than the maximum (" + String.valueOf(object2) + ") allowed";
            }
            object2 = this.checkSelectionList(String.valueOf(object));
            if (object2 != null) {
                return object2;
            }
        } else if (ScalarDataType.DOUBLE == object2) {
            if (object instanceof Double) {
                return "Value for Scalar Global Variable " + this.getName() + " is not an Double. Its a " + object.getClass().getName();
            }
            int n = (Integer)object;
            if (this.isMinSelected() && (double)n < (Double)(object2 = (Double)this.getMinLimit())) {
                return "Value (" + n + ") for Scalar Global Variable " + this.getName() + " is less than the minimum (" + (Double)object2 + ") allowed";
            }
            if (this.isMaxSelected() && n > ((Double)(object2 = (Double)this.getMaxLimit())).intValue()) {
                return "Value (" + n + ") for Scalar Global Variable " + this.getName() + " is greater than the maximum (" + (Double)object2 + ") allowed";
            }
            object2 = this.checkSelectionList(String.valueOf(n));
            if (object2 != null) {
                return object2;
            }
        } else if (ScalarDataType.MONTHOFYEAR == object2) {
            if (object instanceof Month) {
                return "Value for Scalar Global Variable " + this.getName() + " is not a java.time.Month. Its a " + object.getClass().getName();
            }
            object = (Month)object;
            if (this.isMinSelected() && ((Enum)object).compareTo(object2 = (Month)this.getMinLimit()) < 0) {
                return "Value (" + String.valueOf(object) + ") for Scalar Global Variable " + this.getName() + " is less than the minimum (" + String.valueOf(object2) + ") allowed";
            }
            if (this.isMaxSelected() && ((Enum)object).compareTo(object2 = (Month)this.getMaxLimit()) > 0) {
                return "Value (" + String.valueOf(object) + ") for Scalar Global Variable " + this.getName() + " is greater than the maximum (" + String.valueOf(object2) + ") allowed";
            }
            object2 = this.checkSelectionList(String.valueOf(object));
            if (object2 != null) {
                return object2;
            }
        }
        return null;
    }

    @Override
    public void outputReport(AlternativeInputReport object, Element element) {
        super.outputReport((AlternativeInputReport)object, element);
        if (this.getParameter() != null) {
            element.setAttribute("Parameter", this.getParameter());
        }
        element.setAttribute("DataType", this.getDataType().toString());
        element.setAttribute("HasMinLimit", String.valueOf(this.isMinSelected()));
        element.setAttribute("HasMaxLimit", String.valueOf(this.isMaxSelected()));
        object = this.getMinLimit();
        if (this.isMinSelected() && object != null) {
            element.setAttribute("MinLimit", object.toString());
        }
        object = this.getMaxLimit();
        if (this.isMaxSelected() && object != null) {
            element.setAttribute("MinLimit", object.toString());
        }
        boolean bl = this.isSelection();
        element.setAttribute("HasSelectionList", String.valueOf(bl));
        if (bl) {
            List<String> list = this.getSelectionList();
            Element element2 = new Element("SelectionList");
            element.addContent((Content)element2);
            for (int i = 0; i < list.size(); ++i) {
                element2.setAttribute("Selection" + (i + 1), list.get(i));
            }
        }
    }

    private String checkSelectionList(String string) {
        if (!this.isSelectionList()) {
            return null;
        }
        List<String> list = this.getSelectionList();
        if (list.contains(string)) {
            return null;
        }
        return "Value (" + string + ") for Scalar Global Variable " + this.getName() + " is not in the selection list";
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            return super.setFieldObject(field, object);
        }
    }
}

