/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model.globalvariable;

import hec.lang.annotation.Scriptable;
import hec.rss.model.RssSystem;
import hec.rss.model.globalvariable.BaseGlobalVariable;
import hec.rss.model.globalvariable.CharacterSetType;
import hec.rss.model.globalvariable.GlobalVariable;
import hec.rss.model.globalvariable.GlobalVariableType;
import hec.rss.model.reports.AlternativeInputReport;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.CharUtils;
import org.jdom.Content;
import org.jdom.Element;

public class StringGlobalVariable
extends BaseGlobalVariable
implements GlobalVariable {
    public static final String INVALID_CHARS_PROPERTY = "GvEditor.StringGV.hasInvalidChars";
    private boolean _isFreeForm = true;
    private CharacterSetType _characterSetType = CharacterSetType.ASCII;
    private boolean _isCaseSensitive = false;
    private List<Character> _invalidCharacters = new ArrayList<Character>();
    private List<String> _selectionList = new ArrayList<String>();
    private boolean _isFilePath;

    public StringGlobalVariable() {
    }

    public StringGlobalVariable(RssSystem rssSystem) {
        super(rssSystem);
    }

    @Override
    public StringGlobalVariable clone() {
        StringGlobalVariable stringGlobalVariable = (StringGlobalVariable)super.clone();
        StringGlobalVariable stringGlobalVariable2 = this;
        stringGlobalVariable.setInvalidCharacters(stringGlobalVariable2.cloneInvalidCharacters(stringGlobalVariable2.getInvalidCharacters()));
        StringGlobalVariable stringGlobalVariable3 = this;
        stringGlobalVariable.setSelectionList(stringGlobalVariable3.cloneSelectionList(stringGlobalVariable3.getSelectionList()));
        return stringGlobalVariable;
    }

    private List<String> cloneSelectionList(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.addAll(list);
        for (int i = 0; i < arrayList2.size(); ++i) {
            arrayList.add((String)arrayList2.get(i));
        }
        return arrayList;
    }

    private List<Character> cloneInvalidCharacters(List<Character> list) {
        ArrayList<Character> arrayList = new ArrayList<Character>();
        ArrayList<Character> arrayList2 = new ArrayList<Character>();
        arrayList2.addAll(list);
        for (int i = 0; i < arrayList2.size(); ++i) {
            arrayList.add((Character)arrayList2.get(i));
        }
        return arrayList;
    }

    public CharacterSetType getCharacterSetType() {
        return this._characterSetType;
    }

    public void setCharacterSetType(CharacterSetType characterSetType) {
        this._characterSetType = characterSetType;
    }

    @Override
    public GlobalVariableType getType() {
        return GlobalVariableType.STRING;
    }

    @Scriptable
    public String getValue() {
        if (this.a != null) {
            String string = this.a.getValue();
            return string;
        }
        return null;
    }

    @Scriptable
    public void setValue(String string) {
        if (this.isInput()) {
            return;
        }
        if (this.a != null) {
            this.a.setValue(string);
        }
    }

    public boolean isFreeform() {
        return this._isFreeForm;
    }

    public void setFreeForm(boolean bl) {
        this._isFreeForm = bl;
    }

    public boolean isCaseSensitive() {
        return this._isCaseSensitive;
    }

    public void setCaseSensitive(boolean bl) {
        this._isCaseSensitive = bl;
    }

    public List<Character> getInvalidCharacters() {
        if (Boolean.getBoolean(INVALID_CHARS_PROPERTY)) {
            return this._invalidCharacters;
        }
        return new ArrayList<Character>();
    }

    public void setInvalidCharacters(List<Character> list) {
        this._invalidCharacters = list;
    }

    @Scriptable
    public List<String> getSelectionList() {
        return Collections.unmodifiableList(this._selectionList);
    }

    @Scriptable
    public int getSelectionListIndex() {
        String string;
        if (this.isSelection() && this.a != null && (string = this.a.getValue()) != null) {
            int n = this._selectionList.indexOf(string);
            if (n == -1) {
                return n;
            }
            return n + 1;
        }
        return -2;
    }

    @Scriptable
    public int getSelectListLength() {
        return this._selectionList.size();
    }

    @Scriptable
    public void appendToSelectionList(String string) {
        if (string != null && !this._selectionList.contains(string)) {
            this._selectionList.add(string);
        }
    }

    @Scriptable
    public boolean isSelection() {
        return !this.isFreeform();
    }

    @Scriptable
    public void setSelectionList(List<String> list) {
        this._selectionList = list;
    }

    @Override
    public String getDescriptiveText() {
        return (this.isInput() ? "Input " : "Output ") + "String " + this.getName();
    }

    @Override
    @Scriptable
    public String hasValidValue() {
        Object object = this.getValue();
        if (!(object instanceof String)) {
            return null;
        }
        Object object2 = object;
        if (((String)object2).isEmpty()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.isFreeform()) {
            if ((object = this.checkSelectionList(String.valueOf(object))) != null) {
                return object;
            }
        } else if (this.getCharacterSetType() == CharacterSetType.ALPHABETIC) {
            object = this.checkValuesCharacterSet((String)object2, Character::isAlphabetic);
            if (object != null) {
                stringBuilder.append((String)object);
            }
        } else if (this.getCharacterSetType() == CharacterSetType.ALPHANUMERIC) {
            object = this.checkValuesCharacterSet((String)object2, Character::isLetterOrDigit);
            if (object != null) {
                stringBuilder.append((String)object);
            }
        } else if (this.getCharacterSetType() == CharacterSetType.ASCII && (object = this.checkValuesCharacterSet((String)object2, CharUtils::isAscii)) != null) {
            stringBuilder.append((String)object);
        }
        if (this.isFreeform() && (object = this.getInvalidCharacters()) != null && !object.isEmpty() && (object = this.checkInvalidChars((String)object2, (List<Character>)object)) != null) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append((String)object);
        }
        if (stringBuilder.length() > 0) {
            return stringBuilder.toString();
        }
        return null;
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, Element element) {
        super.outputReport(alternativeInputReport, element);
        boolean bl = this.isSelection();
        element.setAttribute("HasSelectionList", String.valueOf(bl));
        if (bl) {
            List<String> list = this.getSelectionList();
            Element element2 = new Element("SelectionList");
            element.addContent((Content)element2);
            for (int i = 0; i < list.size(); ++i) {
                element2.setAttribute("Selection" + (i + 1), list.get(i));
            }
            return;
        }
        element.setAttribute("FreeForm", String.valueOf(this.isFreeform()));
        element.setAttribute("CharacterSetType", this.getCharacterSetType().toString());
        element.setAttribute("CaseSensitive", String.valueOf(this.isCaseSensitive()));
        List<Character> list = this.getInvalidCharacters();
        if (list != null && !list.isEmpty()) {
            Element element3 = new Element("SelectionList");
            element.addContent((Content)element3);
            for (int i = 0; i < list.size(); ++i) {
                element3.setAttribute("InvalidChar" + (i + 1), String.valueOf(list.get(i)));
            }
        }
    }

    private String checkInvalidChars(String object, List<Character> list) {
        if (Boolean.getBoolean(INVALID_CHARS_PROPERTY)) {
            object = ((String)object).toCharArray();
            for (int i = 0; i < ((Object)object).length; ++i) {
                if (!list.contains(Character.valueOf((char)object[i]))) continue;
                return "Character '" + String.valueOf((char)object[i]) + "' for String Global Variable " + this.getName() + " is an invalid character";
            }
        }
        return null;
    }

    private String checkValuesCharacterSet(String object, Function<Character, Boolean> function) {
        object = ((String)object).toCharArray();
        for (int i = 0; i < ((Object)object).length; ++i) {
            if (function.apply(Character.valueOf((char)object[i])).booleanValue()) continue;
            return "Character '" + String.valueOf((char)object[i]) + "' for String Global Variable " + this.getName() + " not in selected character set";
        }
        return null;
    }

    private String checkSelectionList(String string) {
        List<String> list = this.getSelectionList();
        if (list.contains(string)) {
            return null;
        }
        return "Value (" + string + ") for String Global Variable " + this.getName() + " is not in the selection list";
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            return super.setFieldObject(field, object);
        }
    }

    public boolean isFilePath() {
        return this._isFilePath;
    }

    public void setFilePath(boolean bl) {
        this._isFilePath = bl;
    }
}

