/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model.globalvariable;

import hec.data.Parameter;
import hec.io.PairedDataContainer;
import hec.lang.annotation.Scriptable;
import hec.model.PairedValues;
import hec.model.PairedValuesExt;
import hec.model.SeasonalPairedValues;
import hec.model.SeasonalRecord;
import hec.rss.model.NameValuePair;
import hec.rss.model.RssSystem;
import hec.rss.model.globalvariable.AltTableGlobalData;
import hec.rss.model.globalvariable.BaseGlobalVariable;
import hec.rss.model.globalvariable.GlobalVariableType;
import hec.rss.model.globalvariable.TableType;
import hec.rss.model.reports.AlternativeInputReport;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jdom.Content;
import org.jdom.Element;

public class TableGlobalVariable
extends BaseGlobalVariable {
    private TableType _tableType = TableType.SIMPLELOOKUPTABLE;
    private List<NameValuePair<String>> _independentList = new ArrayList<NameValuePair<String>>();
    private List<NameValuePair<String>> _dependentList = new ArrayList<NameValuePair<String>>();
    private boolean _isDSS = true;
    private boolean _seasonalData;
    private long _modifiedTime;
    private transient Object b;

    public TableGlobalVariable() {
    }

    public TableGlobalVariable(RssSystem rssSystem) {
        super(rssSystem);
    }

    @Override
    public TableGlobalVariable clone() {
        TableGlobalVariable tableGlobalVariable = (TableGlobalVariable)super.clone();
        tableGlobalVariable.setTableType(this.getTableType());
        TableGlobalVariable tableGlobalVariable2 = this;
        tableGlobalVariable.setIndependentList(tableGlobalVariable2.cloneList(tableGlobalVariable2.getIndependentList()));
        TableGlobalVariable tableGlobalVariable3 = this;
        tableGlobalVariable.setDependentList(tableGlobalVariable3.cloneList(tableGlobalVariable3.getDependentList()));
        return tableGlobalVariable;
    }

    private List<NameValuePair<String>> cloneList(List<NameValuePair<String>> list) {
        ArrayList<NameValuePair<String>> arrayList = new ArrayList<NameValuePair<String>>();
        ArrayList<NameValuePair<String>> arrayList2 = new ArrayList<NameValuePair<String>>();
        arrayList2.addAll(list);
        for (int i = 0; i < arrayList2.size(); ++i) {
            arrayList.add((NameValuePair<String>)((NameValuePair)arrayList2.get(i)).clone());
        }
        return arrayList;
    }

    @Override
    @Scriptable
    public GlobalVariableType getType() {
        return GlobalVariableType.TABLE;
    }

    @Scriptable
    public String getDSSFilename() {
        if (this.a instanceof AltTableGlobalData) {
            AltTableGlobalData altTableGlobalData = (AltTableGlobalData)this.a;
            return altTableGlobalData.getDSSFilename();
        }
        return null;
    }

    @Scriptable
    public String getDSSPathname() {
        if (this.a instanceof AltTableGlobalData) {
            AltTableGlobalData altTableGlobalData = (AltTableGlobalData)this.a;
            return altTableGlobalData.getDSSPathname();
        }
        return null;
    }

    @Scriptable
    public Object getTable() {
        if (!this.isInput() && this.b != null) {
            return this.b;
        }
        if (this.a instanceof AltTableGlobalData) {
            AltTableGlobalData altTableGlobalData = (AltTableGlobalData)this.a;
            if ((altTableGlobalData = altTableGlobalData.getPairedData()) == null) {
                return null;
            }
            int n = this._network.getUnitSystem();
            ((PairedDataContainer)altTableGlobalData).xparameter = this._dependentList.get(0).getValue();
            ((PairedDataContainer)altTableGlobalData).xunits = Parameter.getUnitsStringForSystem((String)((PairedDataContainer)altTableGlobalData).xparameter, (int)n);
            ((PairedDataContainer)altTableGlobalData).yparameter = this._independentList.get(0).getValue();
            ((PairedDataContainer)altTableGlobalData).yunits = Parameter.getUnitsStringForSystem((String)((PairedDataContainer)altTableGlobalData).yparameter, (int)n);
            try {
                Object object = null;
                switch (this.getTableType()) {
                    case SIMPLELOOKUPTABLE: {
                        object = this.getSimpleLookupTableValue((PairedDataContainer)altTableGlobalData);
                        break;
                    }
                    case TWOVARIABLELOOKUP: {
                        object = this.getTwoVariableLookupValue((PairedDataContainer)altTableGlobalData);
                        break;
                    }
                    case REPORT: {
                        object = new PairedValuesExt();
                        object.setUnitSystem(this._network.getUnitSystem());
                        object.setData((PairedDataContainer)altTableGlobalData);
                    }
                }
                if (object == null) {
                    object = altTableGlobalData;
                }
                if (!this.isInput()) {
                    this.b = object;
                }
                return object;
            }
            catch (Exception exception) {
                this._network.printErrorMessage("Failed to get Table for GlobalVariable " + this.getName() + " Error:" + String.valueOf(exception));
            }
        }
        return null;
    }

    private Object getTwoVariableLookupValue(PairedDataContainer pairedDataContainer) {
        List<NameValuePair<String>> list = this.getIndependentList();
        if (list.size() > 0 && "Seasonal Date".equals(((NameValuePair)((Object)(list = list.get(0)))).getValue())) {
            list = new SeasonalPairedValues();
            list.setUnitSystem(this._network.getUnitSystem());
            list.setData(pairedDataContainer);
            return list;
        }
        list = new PairedValuesExt();
        list.setUnitSystem(this._network.getUnitSystem());
        list.setData(pairedDataContainer);
        return list;
    }

    private Object getSimpleLookupTableValue(PairedDataContainer pairedDataContainer) {
        List<NameValuePair<String>> list = this.getIndependentList();
        if (list.size() > 0 && "Seasonal Date".equals(((NameValuePair)((Object)(list = list.get(0)))).getValue())) {
            list = new SeasonalRecord();
            list.setUnitSystem(this._network.getUnitSystem());
            double[] dArray = pairedDataContainer.xOrdinates;
            int[] nArray = new int[pairedDataContainer.xOrdinates.length];
            for (int i = 0; i < dArray.length; ++i) {
                nArray[i] = (int)dArray[i];
            }
            list.setArrays(nArray, pairedDataContainer.yOrdinates[0]);
            if (pairedDataContainer.labelsUsed && pairedDataContainer.labels != null && pairedDataContainer.labels.length > 0) {
                list.setCurveLabel(pairedDataContainer.labels[0]);
            }
            return list;
        }
        list = new PairedValues();
        list.setUnitSystem(this._network.getUnitSystem());
        list.setData(pairedDataContainer);
        return list;
    }

    public PairedDataContainer getPairedDataContainer() {
        AltTableGlobalData altTableGlobalData = (AltTableGlobalData)this.a;
        altTableGlobalData = altTableGlobalData.getPairedData();
        int n = this._network.getUnitSystem();
        ((PairedDataContainer)altTableGlobalData).xparameter = this._dependentList.get(0).getValue();
        ((PairedDataContainer)altTableGlobalData).xunits = Parameter.getUnitsStringForSystem((String)((PairedDataContainer)altTableGlobalData).xparameter, (int)n);
        ((PairedDataContainer)altTableGlobalData).yparameter = this._independentList.get(0).getValue();
        ((PairedDataContainer)altTableGlobalData).yunits = Parameter.getUnitsStringForSystem((String)((PairedDataContainer)altTableGlobalData).yparameter, (int)n);
        return altTableGlobalData;
    }

    @Scriptable
    public void setTable(PairedDataContainer pairedDataContainer) {
        if (this.isInput()) {
            return;
        }
        if (pairedDataContainer != null && this.a instanceof AltTableGlobalData) {
            AltTableGlobalData altTableGlobalData = (AltTableGlobalData)this.a;
            altTableGlobalData.setPairedData(pairedDataContainer);
        }
    }

    @Scriptable
    public void setTable(PairedValues pairedValues) {
        if (this.isInput()) {
            return;
        }
        if (this.getTableType() == TableType.SIMPLELOOKUPTABLE) {
            pairedValues = pairedValues.getPairedDataContainer();
            if (this.a instanceof AltTableGlobalData) {
                AltTableGlobalData altTableGlobalData = (AltTableGlobalData)this.a;
                altTableGlobalData.setPairedData((PairedDataContainer)pairedValues);
            }
        }
    }

    @Scriptable
    public void setTable(PairedValuesExt pairedValuesExt) {
        if (this.isInput()) {
            return;
        }
        if (this.getTableType() == TableType.TWOVARIABLELOOKUP || this.getTableType() == TableType.REPORT) {
            pairedValuesExt = pairedValuesExt.getPairedDataContainer();
            if (this.a instanceof AltTableGlobalData) {
                AltTableGlobalData altTableGlobalData = (AltTableGlobalData)this.a;
                altTableGlobalData.setPairedData((PairedDataContainer)pairedValuesExt);
            }
        }
    }

    @Scriptable
    public TableType getTableType() {
        return this._tableType;
    }

    @Scriptable
    public String getTableTypeAsString() {
        return this._tableType.toString();
    }

    @Scriptable
    public boolean isReportTable() {
        return TableType.REPORT == this.getTableType();
    }

    public void setTableType(TableType tableType) {
        if (tableType != null) {
            this._tableType = tableType;
        }
    }

    @Scriptable
    public int getNumDependentParameters() {
        return this.getDependentList().size();
    }

    @Scriptable
    public int getNumIndependentParameters() {
        return this.getIndependentList().size();
    }

    @Scriptable
    public int getNumYParameters() {
        TableType tableType = this.getTableType();
        if (TableType.SIMPLELOOKUPTABLE == tableType) {
            return 1;
        }
        if (TableType.TWOVARIABLELOOKUP == tableType) {
            return 1;
        }
        if (TableType.REPORT == tableType) {
            return this.getNumDependentParameters();
        }
        return -1;
    }

    @Scriptable
    public int getNumYCurves() {
        if (this.a instanceof AltTableGlobalData) {
            if (this.isReportTable()) {
                return 0;
            }
            AltTableGlobalData altTableGlobalData = (AltTableGlobalData)this.a;
            if ((altTableGlobalData = altTableGlobalData.getPairedData()) != null) {
                int n = altTableGlobalData.getNumberOrdinates();
                if (this.getTableType() == TableType.TWOVARIABLELOOKUP) {
                    return n - 1;
                }
                return n;
            }
        }
        return -1;
    }

    @Scriptable
    public int getNumRows() {
        if (this.a instanceof AltTableGlobalData) {
            AltTableGlobalData altTableGlobalData = (AltTableGlobalData)this.a;
            if ((altTableGlobalData = altTableGlobalData.getPairedData()) != null) {
                return altTableGlobalData.getNumberOrdinates();
            }
        }
        return -1;
    }

    @Scriptable
    public String getXParameter() {
        if (!this._independentList.isEmpty()) {
            NameValuePair<String> nameValuePair = this._independentList.get(0);
            return nameValuePair.getValue();
        }
        return null;
    }

    @Scriptable
    public String getZParameter() {
        if (this.getTableType() == TableType.TWOVARIABLELOOKUP && !this._dependentList.isEmpty()) {
            NameValuePair<String> nameValuePair = this._dependentList.get(0);
            return nameValuePair.getValue();
        }
        return null;
    }

    @Scriptable
    public String getYParameter() {
        if (this.getTableType() == TableType.TWOVARIABLELOOKUP) {
            NameValuePair<String> nameValuePair = this._independentList.get(1);
            return nameValuePair.getValue();
        }
        if (!this._dependentList.isEmpty()) {
            NameValuePair<String> nameValuePair = this._dependentList.get(0);
            return nameValuePair.getValue();
        }
        return null;
    }

    @Scriptable
    public String getYParameter(int n) {
        if (!this._dependentList.isEmpty() && n >= 0 && n < this._dependentList.size()) {
            NameValuePair<String> nameValuePair = this._dependentList.get(n);
            return nameValuePair.getValue();
        }
        return null;
    }

    public double[] getYParameterValues() {
        if (this.getTableType() == TableType.TWOVARIABLELOOKUP) {
            AltTableGlobalData altTableGlobalData = (AltTableGlobalData)this.a;
            if ((altTableGlobalData = altTableGlobalData.getPairedData()) != null && altTableGlobalData.getNumberCurves() > 1) {
                return altTableGlobalData.getYOridnates()[1];
            }
        }
        return null;
    }

    @Scriptable
    public List<String> getYParameters() {
        return this._dependentList.stream().map(nameValuePair -> (String)nameValuePair.getValue()).collect(Collectors.toList());
    }

    @Scriptable
    public double[] getYValues(int n) {
        if (this.a instanceof AltTableGlobalData) {
            AltTableGlobalData altTableGlobalData = (AltTableGlobalData)this.a;
            if ((altTableGlobalData = altTableGlobalData.getPairedData()) != null && n >= 0 && n < ((PairedDataContainer)altTableGlobalData).numberCurves) {
                return ((PairedDataContainer)altTableGlobalData).yOrdinates[n];
            }
        }
        return null;
    }

    @Scriptable
    public double[] getXValues() {
        if (this.a instanceof AltTableGlobalData) {
            AltTableGlobalData altTableGlobalData = (AltTableGlobalData)this.a;
            if ((altTableGlobalData = altTableGlobalData.getPairedData()) != null) {
                return ((PairedDataContainer)altTableGlobalData).xOrdinates;
            }
        }
        return null;
    }

    @Scriptable
    public int getNumXValues() {
        if (this.a instanceof AltTableGlobalData) {
            AltTableGlobalData altTableGlobalData = (AltTableGlobalData)this.a;
            if ((altTableGlobalData = altTableGlobalData.getPairedData()) != null) {
                return altTableGlobalData.getNumberOrdinates();
            }
        }
        return -1;
    }

    @Scriptable
    public int getNumYValues() {
        if (this.a instanceof AltTableGlobalData) {
            Object object = this.getTableType();
            if (TableType.SIMPLELOOKUPTABLE == object || TableType.TWOVARIABLELOOKUP == object) {
                object = (AltTableGlobalData)this.a;
                if ((object = ((AltTableGlobalData)object).getPairedData()) != null) {
                    return object.getNumberCurves();
                }
            } else if (TableType.REPORT == object) {
                return 0;
            }
        }
        return -1;
    }

    @Scriptable
    public void setXParameter(String string) {
        if (!this.isInput() && this.a instanceof AltTableGlobalData) {
            NameValuePair<String> nameValuePair = (AltTableGlobalData)this.a;
            if ((nameValuePair = ((AltTableGlobalData)((Object)nameValuePair)).getPairedData()) != null) {
                ((PairedDataContainer)nameValuePair).xparameter = string;
                if (this._independentList.size() == 0) {
                    nameValuePair = new NameValuePair<String>("", string);
                    this._independentList.add(nameValuePair);
                    return;
                }
                nameValuePair = this._independentList.get(0);
                nameValuePair.setValue(string);
            }
        }
    }

    @Scriptable
    public void setYParameter(String string) {
        if (!this.isInput() && this.a instanceof AltTableGlobalData) {
            NameValuePair<String> nameValuePair = (AltTableGlobalData)this.a;
            if ((nameValuePair = ((AltTableGlobalData)((Object)nameValuePair)).getPairedData()) != null) {
                int n = 0;
                if (this.getTableType() == TableType.TWOVARIABLELOOKUP) {
                    n = 1;
                }
                if (((PairedDataContainer)nameValuePair).parameters == null) {
                    ((PairedDataContainer)nameValuePair).parameters = new String[nameValuePair.getNumberCurves()];
                }
                ((PairedDataContainer)nameValuePair).parameters[n] = string;
                while (this._dependentList.size() < n) {
                    nameValuePair = new NameValuePair<String>("", "");
                    this._dependentList.add(nameValuePair);
                }
                nameValuePair = this._independentList.get(n);
                nameValuePair.setValue(string);
            }
        }
    }

    @Scriptable
    public void setYParameters(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        if (!this.isInput() && this.a instanceof AltTableGlobalData) {
            NameValuePair<String> nameValuePair = (AltTableGlobalData)this.a;
            if ((nameValuePair = ((AltTableGlobalData)((Object)nameValuePair)).getPairedData()) != null) {
                if (((PairedDataContainer)nameValuePair).parameters == null) {
                    String[] stringArray2 = ((PairedDataContainer)nameValuePair).parameters;
                    ((PairedDataContainer)nameValuePair).parameters = new String[nameValuePair.getNumberCurves()];
                    System.arraycopy(stringArray2, 0, ((PairedDataContainer)nameValuePair).parameters, 0, ((PairedDataContainer)nameValuePair).parameters.length);
                }
                int n = Math.min(((PairedDataContainer)nameValuePair).parameters.length, stringArray.length);
                System.arraycopy(stringArray, 0, ((PairedDataContainer)nameValuePair).parameters, 0, n);
                if (this.getTableType() == TableType.TWOVARIABLELOOKUP) {
                    nameValuePair = this._independentList.get(1);
                    nameValuePair.setValue(stringArray[0]);
                    if (stringArray.length > 1) {
                        nameValuePair = this._dependentList.get(0);
                        nameValuePair.setValue(stringArray[1]);
                    }
                    return;
                }
                for (int i = 0; i < stringArray.length && i < this._dependentList.size(); ++i) {
                    NameValuePair<String> nameValuePair2 = this._dependentList.get(i);
                    nameValuePair2.setValue(stringArray[i]);
                }
            }
        }
    }

    public List<NameValuePair<String>> getIndependentList() {
        return this._independentList;
    }

    public void setIndependentList(List<NameValuePair<String>> list) {
        this._independentList = list;
    }

    public List<NameValuePair<String>> getDependentList() {
        return this._dependentList;
    }

    public void setDependentList(List<NameValuePair<String>> list) {
        this._dependentList = list;
    }

    public boolean isDSS() {
        return this._isDSS;
    }

    public void setIsDSS(boolean bl) {
        this._isDSS = bl;
    }

    @Override
    public boolean initializeGv() {
        if (this._network == null) {
            return false;
        }
        Object object = this.isInput() ? this._network.getInputGvDataSet() : this._network.getOutputGVDataSet();
        if (object != null && (object = object.getGlobalVariableData(this._index, this.getType())) instanceof AltTableGlobalData) {
            this.a = object;
            this.a.setGlobalVariable(this);
            object = (AltTableGlobalData)object;
            object = ((AltTableGlobalData)object).getPairedData();
            if (object == null) {
                this.getNetwork().printWarningMessage("Failed to create table data for Output Table GlobalVariable " + this.getName());
            }
            this.setTable((PairedDataContainer)object);
            this.b = null;
            return true;
        }
        return false;
    }

    @Override
    protected String getComputeMsg() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.valueOf((Object)this.getType()) + " Global Variable:" + this.getName());
        Object object = this.getTable();
        if (object != null) {
            stringBuilder.append(" Value:" + object.toString());
        }
        return stringBuilder.toString();
    }

    public void setSeasonalData(boolean bl) {
        this._seasonalData = bl;
    }

    public boolean isSeasonalData() {
        return this._seasonalData;
    }

    public void setModifiedTime(long l) {
        this._modifiedTime = l;
    }

    public long getModifiedTime() {
        return this._modifiedTime;
    }

    @Override
    public String getDescriptiveText() {
        return (this.isInput() ? "Input " : "Output ") + String.valueOf((Object)this.getTableType()) + " Global Variable " + this.getName();
    }

    @Override
    public void outputReport(AlternativeInputReport object, Element element) {
        super.outputReport((AlternativeInputReport)object, element);
        element.setAttribute("TableType", this.getTableTypeAsString());
        element.setAttribute("IsDss", String.valueOf(this.isDSS()));
        element.setAttribute("SeasonalData", String.valueOf(this.isSeasonalData()));
        object = this.getIndependentList();
        Element element2 = new Element("IndependentVariables");
        element.addContent((Content)element2);
        for (int i = 0; i < object.size(); ++i) {
            element2.setAttribute("IndyVar" + (i + 1) + "ParamName", ((NameValuePair)object.get(i)).getName());
            element2.setAttribute("IndyVar" + (i + 1) + "ParamType", (String)((NameValuePair)object.get(i)).getValue());
        }
        List<NameValuePair<String>> list = this.getDependentList();
        object = new Element("DependentVariables");
        element.addContent((Content)object);
        for (int i = 0; i < list.size(); ++i) {
            object.setAttribute("DepVar" + (i + 1) + "ParamName", list.get(i).getName());
            object.setAttribute("DepVar" + (i + 1) + "ParamType", list.get(i).getValue());
        }
    }

    @Scriptable
    public void setXValues(double[] dArray) {
        if (!this.isInput() && this.a instanceof AltTableGlobalData) {
            AltTableGlobalData altTableGlobalData = (AltTableGlobalData)this.a;
            if ((altTableGlobalData = altTableGlobalData.getPairedData()) != null) {
                altTableGlobalData.setXOrdinates(dArray);
            }
        }
    }

    @Scriptable
    public void setYValues(double[][] dArray) {
        if (!this.isInput() && this.a instanceof AltTableGlobalData) {
            AltTableGlobalData altTableGlobalData = (AltTableGlobalData)this.a;
            if ((altTableGlobalData = altTableGlobalData.getPairedData()) != null) {
                altTableGlobalData.setYOrdinates(dArray);
            }
        }
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            return super.setFieldObject(field, object);
        }
    }
}

