/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model.globalvariable;

import hec.clientapp.model.TSRecordProxy;
import hec.data.Parameter;
import hec.heclib.dss.DssDataType;
import hec.heclib.util.intArrayContainer;
import hec.io.TimeSeriesContainer;
import hec.lang.annotation.Scriptable;
import hec.model.RunTimeWindow;
import hec.model.TSRecord;
import hec.rss.model.RssSystem;
import hec.rss.model.globalvariable.AltTimeSeriesGlobalData;
import hec.rss.model.globalvariable.GlobalVariable;
import hec.rss.model.globalvariable.GlobalVariableData;
import hec.rss.model.globalvariable.GlobalVariableType;
import hec.rss.model.globalvariable.TimeStepType;
import hec.rss.model.reports.AlternativeInputReport;
import java.lang.reflect.Field;
import org.jdom.Element;

public class TimeSeriesGlobalVariable
extends TSRecordProxy
implements GlobalVariable {
    private String _parameter = "";
    private TimeStepType _timeStepType = TimeStepType.ALTERNATIVE;
    private String _parameterType = "";
    private boolean _inputRec = true;
    private RssSystem _network;
    private transient AltTimeSeriesGlobalData a;
    private boolean _isDataLocation;

    public TimeSeriesGlobalVariable() {
    }

    public TimeSeriesGlobalVariable(RssSystem rssSystem) {
        this._network = rssSystem;
    }

    @Override
    public TimeSeriesGlobalVariable clone() {
        return (TimeSeriesGlobalVariable)super.clone();
    }

    @Override
    public GlobalVariableType getType() {
        return GlobalVariableType.TIME_SERIES;
    }

    public String getParameter() {
        return this._parameter;
    }

    public void setParameter(String string) {
        this._parameter = string;
    }

    public TimeStepType getTimeStepType() {
        return this._timeStepType;
    }

    public void setTimeStepType(TimeStepType timeStepType) {
        this._timeStepType = timeStepType;
    }

    public String getParameterType() {
        return this._parameterType;
    }

    public void setParameterType(String string) {
        this._parameterType = string;
    }

    @Override
    public void setIndex(int n) {
        this._index = n;
    }

    @Override
    public int getIndex() {
        return this._index;
    }

    @Override
    @Scriptable
    public boolean isInput() {
        return this._inputRec;
    }

    @Override
    public void setInput(boolean bl) {
        this._inputRec = bl;
    }

    @Scriptable
    public String getUsageType() {
        if (this.isInput()) {
            return "Input";
        }
        return "Output";
    }

    @Override
    public boolean initializeGv() {
        if (this._network == null) {
            return false;
        }
        Object object = this.isInput() ? this._network.getInputGvDataSet() : this._network.getOutputGVDataSet();
        if ((object = object.getGlobalVariableData(this._index, this.getType())) instanceof AltTimeSeriesGlobalData) {
            this.a = (AltTimeSeriesGlobalData)object;
            this.a.initialize(this._network.getRssRun().getRunTimeWindow());
            this._tsRecord = this.a;
            if (!this.isInput()) {
                object = this._network.getRssRun().getRunTimeWindow();
                if (this._timeStepType != TimeStepType.ALTERNATIVE) {
                    object = object.clone();
                    int n = this._timeStepType.getTimeStep();
                    int n2 = this._timeStepType.getTimeStepIncrement();
                    object.setTimeStep(n, n2);
                }
                if (this.a.initialize((RunTimeWindow)object)) {
                    this._dataArray = this.a.getTSContainer();
                    if (this._dataArray == null) {
                        this._network.printWarningMessage("Failed to get data array for TimeSeries Global Variable " + this.getName());
                    }
                } else {
                    this._network.printWarningMessage("Failed to initialize TimeSeries Global Variable " + this.getName());
                }
                this._network.getAlternative();
                this.a.setUnits(Parameter.getUnitsStringForSystem((String)this._parameterType, (int)this._network.getUnitSystem()));
                String string = DssDataType.INST_VAL.toString();
                if (this._network.getRssRun().getRunTimeWindow().isPerAvgTimeStep()) {
                    string = DssDataType.PER_AVER.toString();
                }
                this.a.setUnitsType(string);
                this._tsRecord = this.a;
                return true;
            }
            if (this.a.loadTSData()) {
                this._dataArray = this.a.getTSContainer();
                this._timeArray = new intArrayContainer(this.a.getTimeArray());
                return true;
            }
        }
        return false;
    }

    @Override
    public String getDescriptiveText() {
        return (String)(this.isInput() ? "Input " : "Output " + String.valueOf((Object)this._timeStepType)) + " TimeSeries " + this.getName();
    }

    @Override
    public void setGlobalVariableData(GlobalVariableData globalVariableData) {
        if (globalVariableData instanceof AltTimeSeriesGlobalData) {
            this.a = (AltTimeSeriesGlobalData)globalVariableData;
            this.a.setGlobalVariable(this);
        }
    }

    @Override
    public void finalizeCompute() {
        this.a = null;
        this.unload();
    }

    @Override
    @Scriptable
    public RssSystem getNetwork() {
        return this._network;
    }

    public TSRecord getTSRecord() {
        return this.a;
    }

    @Scriptable
    public String getDSSFilename() {
        if (this.a instanceof AltTimeSeriesGlobalData) {
            AltTimeSeriesGlobalData altTimeSeriesGlobalData = this.a;
            return altTimeSeriesGlobalData.getDSSFilename();
        }
        return null;
    }

    @Scriptable
    public String getDSSPathname() {
        if (this.a instanceof AltTimeSeriesGlobalData) {
            AltTimeSeriesGlobalData altTimeSeriesGlobalData = this.a;
            return altTimeSeriesGlobalData.getDSSPathname();
        }
        return null;
    }

    @Scriptable
    public TimeSeriesContainer getTimeSeriesContainer() {
        if (this.a instanceof AltTimeSeriesGlobalData) {
            AltTimeSeriesGlobalData altTimeSeriesGlobalData = this.a;
            return altTimeSeriesGlobalData.getTimeSeriesContainer();
        }
        return null;
    }

    @Scriptable
    public TimeSeriesContainer getTimeSeriesContainerFor(int n, int n2) {
        if (this.a instanceof AltTimeSeriesGlobalData) {
            AltTimeSeriesGlobalData altTimeSeriesGlobalData = this.a;
            return altTimeSeriesGlobalData.getTimeSeriesContainerFor(n, n2);
        }
        return null;
    }

    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            return super.setFieldObject(field, object);
        }
    }

    @Override
    public String hasValidValue() {
        return null;
    }

    @Override
    public void setIsDataLocation(boolean bl) {
        this._isDataLocation = bl;
    }

    @Override
    public boolean getIsDataLocation() {
        return this._isDataLocation;
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, Element element) {
        element.setAttribute("Name", this._name);
        element.setAttribute("Description", this._description);
        element.setAttribute("GlobalVariableType", this.getType().toString());
        element.setAttribute("UsageType", this.getUsageType());
        element.setAttribute("Parameter", this.getParameterType());
        element.setAttribute("IsDataLocation", String.valueOf(this.getIsDataLocation()));
        if (!this.isInput()) {
            element.setAttribute("ParameterName", this.getParameter());
            element.setAttribute("TimeStep", this.getTimeStepType().toString());
        }
    }

    public void setCurrentValue(int n, double d) {
        if (this.isInput()) {
            this._network.printWarningMessage("TimeSeries Global Variable " + this.getName() + " is an Input Global Variable, it can't have its value set");
            return;
        }
        super.setCurrentValue(n, d);
    }
}

