/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model.rs4engine;

import hec.model.RunTimeStep;
import hec.rss.model.rs4engine.Graph.Graph;
import hec.rss.model.rs4engine.GraphArrowRte;
import hec.rss.model.rs4engine.GraphArrowRteEq;
import hec.rss.model.rs4engine.GraphArrowRteEqCntrl;
import hec.rss.model.rs4engine.GraphVertexRte;
import hec.rss.model.rs4engine.GraphVertexRteEq;
import hec.rss.model.rs4engine.RSEqn;
import hec.rss.model.rs4engine.RSEqnBatch;
import hec.rss.model.rs4engine.RSEqnBatchEyeCntrl;
import hec.rss.model.rs4engine.RSEqnBatchObj;
import hec.rss.model.rs4engine.RSEqnBatchReg;
import hec.rss.model.rs4engine.RSEqnBatchRte;
import hec.rss.model.rs4engine.RSLinSystem;
import hec.rss.model.rs4engine.RSLinSystemWeighted;
import hec.rss.model.rs4engine.RSVar;
import hec.rss.model.rs4engine.RSVarList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GraphRouting
extends Graph<GraphVertexRte, GraphArrowRte> {
    private RSVarList _rteVarList;
    private List<RSEqnBatchRte> _rteEqnList;
    private RSVarList _objVarList;
    private List<RSEqnBatchObj> _objEqnList = new ArrayList<RSEqnBatchObj>();
    private List<RSEqnBatchReg> _regEqnList;
    private List<RSEqnBatchReg> _regEqnCntrlList;

    public void setBatchSize(int n) {
        this.buildRteEqnList();
        for (RSEqnBatchRte rSEqnBatch : this._rteEqnList) {
            rSEqnBatch.a(n);
        }
        for (RSEqnBatchObj rSEqnBatchObj : this._objEqnList) {
            rSEqnBatchObj.a(n);
        }
        this.buildRegEqnList();
        for (RSEqnBatchReg rSEqnBatchReg : this._regEqnList) {
            rSEqnBatchReg.a(n);
        }
        this.buildRegEqnCntrlList();
        for (RSEqnBatchReg rSEqnBatchReg : this._regEqnCntrlList) {
            rSEqnBatchReg.a(n);
        }
    }

    public void updateSystemState(RunTimeStep runTimeStep, int n) {
        for (RSEqnBatchRte rSEqnBatchRte : this._rteEqnList) {
            rSEqnBatchRte.b(runTimeStep, n);
        }
    }

    private RSVarList buildRteVarList() {
        this._rteVarList = new RSVarList();
        Object object = this.getArrowList();
        object = object.iterator();
        while (object.hasNext()) {
            GraphArrowRte graphArrowRte = (GraphArrowRte)object.next();
            this._rteVarList.add(graphArrowRte.c());
        }
        return this._rteVarList;
    }

    private int getNumRteVars() {
        return this._rteVarList.size();
    }

    public double[] getRteVarVals(int n, RunTimeStep runTimeStep) {
        int n2 = runTimeStep.getStep();
        int n3 = this.getNumRteVars();
        double[] dArray = new double[n3 * n];
        for (int i = 0; i < n3; ++i) {
            RSVar rSVar = (RSVar)this._rteVarList.get(i);
            for (int j = 0; j < n; ++j) {
                dArray[RSEqn.a((int)i, (int)j, (int)n)] = rSVar.b(n2 + j);
            }
        }
        return dArray;
    }

    public void setRteVarVals(double[] dArray, int n, RunTimeStep runTimeStep, int n2) {
        int n3 = runTimeStep.getStep();
        int n4 = this.getNumRteVars();
        for (int i = 0; i < n4; ++i) {
            int n5;
            RSVar rSVar = (RSVar)this._rteVarList.get(i);
            int n6 = Math.min(n2, rSVar.c() - (n3 + n));
            for (n5 = 0; n5 < n; ++n5) {
                rSVar.a(n3 + n5, dArray[RSEqn.a(i, n5, n)]);
            }
            for (n5 = n; n5 < n + n6; ++n5) {
                rSVar.a(n3 + n5, dArray[RSEqn.a(i, n - 1, n)]);
            }
        }
    }

    private List<RSEqnBatchRte> buildRteEqnList() {
        Object object;
        Object object2;
        this._rteEqnList = new ArrayList<RSEqnBatchRte>();
        Object object3 = this.getArrowList();
        object3 = object3.iterator();
        while (object3.hasNext()) {
            object2 = (GraphArrowRte)object3.next();
            if (!(object2 instanceof GraphArrowRteEq)) continue;
            object = (GraphArrowRteEq)object2;
            this._rteEqnList.add((RSEqnBatchRte)((GraphArrowRteEq)object).j());
        }
        object3 = this.getVertexList();
        object2 = object3.iterator();
        while (object2.hasNext()) {
            object = (GraphVertexRte)object2.next();
            if (!(object instanceof GraphVertexRteEq)) continue;
            object3 = (GraphVertexRteEq)object;
            this._rteEqnList.add((RSEqnBatchRte)((GraphVertexRteEq)object3).h());
        }
        return this._rteEqnList;
    }

    private int getNumRteEqns() {
        return this._rteEqnList.size();
    }

    private void buildRteEqns(RunTimeStep runTimeStep) {
        for (RSEqnBatchRte rSEqnBatchRte : this._rteEqnList) {
            rSEqnBatchRte.a(this._rteVarList, runTimeStep);
        }
    }

    private void updateRteEqns(RunTimeStep runTimeStep) {
        for (RSEqnBatchRte rSEqnBatchRte : this._rteEqnList) {
            rSEqnBatchRte.b(runTimeStep);
        }
    }

    public RSLinSystem buildRteSystem(int n, RunTimeStep runTimeStep) {
        this.buildRteVarList();
        this.buildRteEqnList();
        this.buildRteEqns(runTimeStep);
        RSLinSystem rSLinSystem = new RSLinSystem(n * this.getNumRteEqns(), n * this.getNumRteVars());
        rSLinSystem.a(this._rteEqnList);
        return rSLinSystem;
    }

    public void updateRteSystem(RSLinSystem rSLinSystem, RunTimeStep runTimeStep) {
        this.updateRteEqns(runTimeStep);
        rSLinSystem.b(this._rteEqnList);
    }

    private RSVarList buildObjVarList() {
        this._objVarList = new RSVarList();
        Object object = this.getArrowList();
        object = object.iterator();
        while (object.hasNext()) {
            GraphArrowRte graphArrowRte = (GraphArrowRte)object.next();
            if (!(graphArrowRte instanceof GraphArrowRteEqCntrl)) continue;
            this._objVarList.add(((RSEqnBatchEyeCntrl)((GraphArrowRteEqCntrl)graphArrowRte).j()).f());
        }
        return this._objVarList;
    }

    public int getNumObjVars() {
        return this._objVarList.size();
    }

    public double[] getObjVarVals(int n, RunTimeStep runTimeStep) {
        int n2 = runTimeStep.getStep();
        int n3 = this.getNumObjVars();
        double[] dArray = new double[n3 * n];
        for (int i = 0; i < n3; ++i) {
            RSVar rSVar = (RSVar)this._objVarList.get(i);
            for (int j = 0; j < n; ++j) {
                dArray[RSEqn.a((int)i, (int)j, (int)n)] = rSVar.b(n2 + j);
            }
        }
        return dArray;
    }

    public void setObjVarVals(double[] dArray, int n, RunTimeStep runTimeStep, int n2) {
        int n3 = runTimeStep.getStep();
        int n4 = this.getNumObjVars();
        for (int i = 0; i < n4; ++i) {
            int n5;
            RSVar rSVar = (RSVar)this._objVarList.get(i);
            int n6 = Math.min(n2, rSVar.c() - (n3 + n));
            for (n5 = 0; n5 < n; ++n5) {
                rSVar.a(n3 + n5, dArray[RSEqn.a(i, n5, n)]);
            }
            for (n5 = n; n5 < n + n6; ++n5) {
                rSVar.a(n3 + n5, dArray[RSEqn.a(i, n - 1, n)]);
            }
        }
    }

    public void setObjEqnList(List<RSEqnBatchObj> list) {
        this._objEqnList = list;
    }

    public List<RSEqnBatchObj> getObjEqnList() {
        return this._objEqnList;
    }

    public List<RSEqnBatchObj> getSortedFilteredObjEqnList() {
        this.sortObjEqnList();
        ArrayList<RSEqnBatchObj> arrayList = new ArrayList<RSEqnBatchObj>();
        arrayList.addAll(this.getObjEqnList());
        int n = arrayList.size();
        --n;
        while (n >= 0) {
            RSEqnBatchObj rSEqnBatchObj = (RSEqnBatchObj)arrayList.get(n);
            if (rSEqnBatchObj.i() == -1) {
                arrayList.remove(n);
            }
            --n;
        }
        return arrayList;
    }

    private int getNumObjEqns() {
        return this._objEqnList.size();
    }

    private void sortObjEqnList() {
        RSEqnBatchObj.b(this._objEqnList);
    }

    private void buildObjEqns(RunTimeStep runTimeStep) {
        for (RSEqnBatchObj rSEqnBatchObj : this._objEqnList) {
            rSEqnBatchObj.a(this._rteVarList, runTimeStep);
        }
    }

    private void updateObjEqns(RunTimeStep runTimeStep) {
        for (RSEqnBatchObj rSEqnBatchObj : this._objEqnList) {
            ((RSEqnBatch)rSEqnBatchObj).b(runTimeStep);
        }
    }

    public double[] buildObjEmbedding(int n) {
        int n2 = this.getNumRteEqns();
        int n3 = this.getNumObjVars();
        double[] dArray = new double[n * n2 * n * n3];
        Arrays.fill(dArray, 0.0);
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            RSEqnBatchRte rSEqnBatchRte = this._rteEqnList.get(i);
            if (!(rSEqnBatchRte instanceof RSEqnBatchEyeCntrl)) continue;
            for (int j = 0; j < n; ++j) {
                dArray[(n * i + j) * (n * n3) + (n * n4 + j)] = 1.0;
            }
            ++n4;
        }
        return dArray;
    }

    public double[] buildObjRateMat(int n) {
        int n2 = this.getNumObjVars();
        double[] dArray = new double[n * n2 * n * n2];
        Arrays.fill(dArray, 0.0);
        return dArray;
    }

    public void updateObjRateMat(int n, double[] dArray) {
        int n2 = this.getNumObjVars();
        int n3 = this.getNumRteEqns();
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            Object object = this._rteEqnList.get(i);
            if (!(object instanceof RSEqnBatchEyeCntrl)) continue;
            object = ((RSEqnBatchEyeCntrl)object).g();
            for (int j = 0; j < n; ++j) {
                dArray[(n * n4 + j) * (n * n2) + (n * n4 + j)] = (double)object[j];
            }
            ++n4;
        }
    }

    public RSLinSystemWeighted buildObjSystem(int n, RunTimeStep runTimeStep) {
        this.buildObjVarList();
        this.buildObjEqns(runTimeStep);
        RSLinSystemWeighted rSLinSystemWeighted = new RSLinSystemWeighted(n * this.getNumObjEqns(), n * this.getNumRteVars());
        ((RSLinSystem)rSLinSystemWeighted).a(this._objEqnList);
        return rSLinSystemWeighted;
    }

    public void updateObjSystem(RSLinSystemWeighted rSLinSystemWeighted, int n, RunTimeStep runTimeStep) {
        this.updateObjEqns(runTimeStep);
        ((RSLinSystem)rSLinSystemWeighted).b(this._objEqnList);
    }

    private List<RSEqnBatchReg> buildRegEqnList() {
        this._regEqnList = new ArrayList<RSEqnBatchReg>();
        Object object = this.getArrowList();
        object = object.iterator();
        while (object.hasNext()) {
            GraphArrowRte graphArrowRte = (GraphArrowRte)object.next();
            if (graphArrowRte.d()) {
                this._regEqnList.add(graphArrowRte.e());
            }
            if (graphArrowRte.f()) {
                this._regEqnList.add(graphArrowRte.g());
            }
            if (!graphArrowRte.h()) continue;
            this._regEqnList.add(graphArrowRte.i());
        }
        return this._regEqnList;
    }

    private int getNumRegEqns() {
        return this._regEqnList.size();
    }

    private void buildRegEqns(RunTimeStep runTimeStep) {
        for (RSEqnBatchReg rSEqnBatchReg : this._regEqnList) {
            rSEqnBatchReg.a(this._objVarList, runTimeStep);
        }
    }

    private void updateRegEqns(RunTimeStep runTimeStep) {
        for (RSEqnBatchReg rSEqnBatchReg : this._regEqnList) {
            ((RSEqnBatch)rSEqnBatchReg).b(runTimeStep);
        }
    }

    public RSLinSystemWeighted buildRegSystem(int n, RunTimeStep runTimeStep) {
        this.buildRegEqnList();
        this.buildRegEqns(runTimeStep);
        RSLinSystemWeighted rSLinSystemWeighted = new RSLinSystemWeighted(n * this.getNumRegEqns(), n * this.getNumObjVars());
        ((RSLinSystem)rSLinSystemWeighted).a(this._regEqnList);
        return rSLinSystemWeighted;
    }

    public void updateRegSystem(RSLinSystemWeighted rSLinSystemWeighted, int n, RunTimeStep runTimeStep) {
        this.updateRegEqns(runTimeStep);
        ((RSLinSystem)rSLinSystemWeighted).b(this._regEqnList);
    }

    private List<RSEqnBatchReg> buildRegEqnCntrlList() {
        this._regEqnCntrlList = new ArrayList<RSEqnBatchReg>();
        Object object = this.getArrowList();
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (GraphArrowRte)object.next();
            if (!(object2 instanceof GraphArrowRteEqCntrl)) continue;
            if (((RSEqnBatchEyeCntrl)(object2 = (RSEqnBatchEyeCntrl)((GraphArrowRteEqCntrl)object2).j())).h()) {
                this._regEqnCntrlList.add(((RSEqnBatchEyeCntrl)object2).i());
            }
            if (((RSEqnBatchEyeCntrl)object2).j()) {
                this._regEqnCntrlList.add(((RSEqnBatchEyeCntrl)object2).k());
            }
            if (!((RSEqnBatchEyeCntrl)object2).l()) continue;
            this._regEqnCntrlList.add(((RSEqnBatchEyeCntrl)object2).m());
        }
        return this._regEqnCntrlList;
    }

    public List<RSEqnBatchReg> getRegEqnCntrlList() {
        return this._regEqnCntrlList;
    }

    private int getNumRegEqnCntrls() {
        return this._regEqnCntrlList.size();
    }

    private void buildRegEqnCntrls(RunTimeStep runTimeStep) {
        for (RSEqnBatchReg rSEqnBatchReg : this._regEqnCntrlList) {
            rSEqnBatchReg.a(this._objVarList, runTimeStep);
        }
    }

    private void updateRegEqnCntrls(RunTimeStep runTimeStep) {
        for (RSEqnBatchReg rSEqnBatchReg : this._regEqnCntrlList) {
            ((RSEqnBatch)rSEqnBatchReg).b(runTimeStep);
        }
    }

    public RSLinSystemWeighted buildRegCntrlSystem(int n, RunTimeStep runTimeStep) {
        this.buildRegEqnCntrlList();
        this.buildRegEqnCntrls(runTimeStep);
        RSLinSystemWeighted rSLinSystemWeighted = new RSLinSystemWeighted(n * this.getNumRegEqnCntrls(), n * this.getNumObjVars());
        ((RSLinSystem)rSLinSystemWeighted).a(this._regEqnCntrlList);
        return rSLinSystemWeighted;
    }

    public void updateRegCntrlSystem(RSLinSystemWeighted rSLinSystemWeighted, int n, RunTimeStep runTimeStep) {
        this.updateRegEqnCntrls(runTimeStep);
        ((RSLinSystem)rSLinSystemWeighted).b(this._regEqnCntrlList);
    }
}

