/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model.rs4engine;

import hec.rss.model.rs4engine.LinSystem;
import hec.rss.model.rs4engine.LinSystemNewtonSolver;
import hec.rss.model.rs4engine.RSLinSystemWeighted;
import hec.rss.model.rs4engine.RSMsrLinSystem;
import java.util.Arrays;
import rma.lang.RmaMath;

public class RSLinSystemObjSolver {
    private double a;
    private double[] b;
    private double[] c;
    private double d;
    private double[] e;
    private double[] f;
    private double[] g;
    private double[] h;
    private double[] i;
    private double[] j;
    private double[] k;
    private double[] l;
    private double[] m;
    private double[] n;
    private double[] o;
    private double[] p;
    private double[] q;
    private double[] r;
    private double[] s;
    private double[] t;
    private double u;
    private double v;
    private double w;

    public RSLinSystemObjSolver(int n, int n2, int n3, double d) {
        this.a(d);
        this.b = new double[n];
        this.c = new double[n2];
        this.d = 0.0;
        int n4 = n3;
        this.e = new double[n4 * n4];
        Arrays.fill(this.e, 0.0);
        this.f = new double[n * n3];
        this.g = new double[n3 * n];
        int n5 = n3;
        this.h = new double[n5 * n5];
        this.i = new double[n3];
        this.j = new double[n2 * n3];
        this.k = new double[n3 * n2];
        int n6 = n3;
        this.l = new double[n6 * n6];
        this.m = new double[n3];
        int n7 = n3;
        this.n = new double[n7 * n7];
        this.o = new double[n3];
        this.p = new double[n3];
        this.q = new double[1];
        this.r = new double[1];
        this.s = new double[n3];
        this.t = new double[n3];
        this.u = Double.NaN;
        this.v = Double.NaN;
        this.w = Double.NaN;
    }

    public RSLinSystemObjSolver(int n, int n2, int n3) {
        this(n, n2, n3, 1.0);
    }

    public void a(double d) {
        this.a = d;
    }

    public double a() {
        return this.a;
    }

    public double[] b() {
        return this.b;
    }

    public double[] c() {
        return this.c;
    }

    public double[] d() {
        return this.s;
    }

    public double[] e() {
        return this.t;
    }

    public double f() {
        return this.u;
    }

    public double g() {
        return this.v;
    }

    public double h() {
        return this.w;
    }

    public double[] a(RSMsrLinSystem rSMsrLinSystem, double[] dArray) {
        LinSystemNewtonSolver.a(rSMsrLinSystem, dArray, this.b);
        return this.b;
    }

    public double[] a(LinSystem linSystem, double[] dArray) {
        LinSystemNewtonSolver.a(linSystem, dArray, this.c);
        return this.c;
    }

    public boolean a(RSMsrLinSystem rSMsrLinSystem, RSLinSystemWeighted rSLinSystemWeighted) {
        int n;
        int n2;
        RSLinSystemWeighted rSLinSystemWeighted2 = rSLinSystemWeighted;
        RSMsrLinSystem rSMsrLinSystem2 = rSMsrLinSystem;
        RSLinSystemObjSolver rSLinSystemObjSolver = this;
        int n3 = rSMsrLinSystem2.a();
        int n4 = rSLinSystemWeighted2.a();
        int n5 = rSMsrLinSystem2.b();
        RmaMath.matMultAtB((double[])rSMsrLinSystem2.c(), (double[])rSMsrLinSystem2.e(), (double[])rSLinSystemObjSolver.g, (int)n3, (int)n5, (int)n3);
        RmaMath.matMultAB((double[])rSLinSystemObjSolver.g, (double[])rSMsrLinSystem2.c(), (double[])rSLinSystemObjSolver.h, (int)n5, (int)n3, (int)n5);
        RmaMath.matMultAtB((double[])rSLinSystemWeighted2.c(), (double[])rSLinSystemWeighted2.e(), (double[])rSLinSystemObjSolver.k, (int)n4, (int)n5, (int)n4);
        RmaMath.matMultAB((double[])rSLinSystemObjSolver.k, (double[])rSLinSystemWeighted2.c(), (double[])rSLinSystemObjSolver.l, (int)n5, (int)n4, (int)n5);
        int n6 = n5;
        RmaMath.matMultAS((double[])rSLinSystemObjSolver.l, (double)rSLinSystemObjSolver.a, (int)n6, (int)n6);
        int n7 = n5;
        rSLinSystemObjSolver.n = Arrays.copyOf(rSLinSystemObjSolver.h, n7 * n7);
        RmaMath.matAddTo((double[])rSLinSystemObjSolver.l, (double[])rSLinSystemObjSolver.n);
        for (n2 = 0; n2 < n5; ++n2) {
            double d = Math.sqrt(rSLinSystemObjSolver.n[n2 * n5 + n2]);
            rSLinSystemObjSolver.e[n2 * n5 + n2] = d == 0.0 ? 0.0 : 1.0 / d;
        }
        double[] dArray = this.c;
        double[] dArray2 = this.b;
        rSLinSystemWeighted2 = rSLinSystemWeighted;
        rSMsrLinSystem2 = rSMsrLinSystem;
        rSLinSystemObjSolver = this;
        n5 = rSMsrLinSystem2.a();
        n2 = rSLinSystemWeighted2.a();
        int n8 = n = rSMsrLinSystem2.b();
        RmaMath.matMultAB((double[])rSMsrLinSystem2.c(), (double[])rSLinSystemObjSolver.e, (double[])rSLinSystemObjSolver.f, (int)n5, (int)n8, (int)n8);
        RmaMath.matMultAtB((double[])rSLinSystemObjSolver.f, (double[])rSMsrLinSystem2.e(), (double[])rSLinSystemObjSolver.g, (int)n5, (int)n, (int)n5);
        RmaMath.matMultAB((double[])rSLinSystemObjSolver.g, (double[])rSLinSystemObjSolver.f, (double[])rSLinSystemObjSolver.h, (int)n, (int)n5, (int)n);
        RmaMath.matMultAB((double[])rSLinSystemObjSolver.g, (double[])dArray2, (double[])rSLinSystemObjSolver.i, (int)n, (int)n5, (int)1);
        int n9 = n;
        RmaMath.matMultAB((double[])rSLinSystemWeighted2.c(), (double[])rSLinSystemObjSolver.e, (double[])rSLinSystemObjSolver.j, (int)n2, (int)n9, (int)n9);
        RmaMath.matMultAtB((double[])rSLinSystemObjSolver.j, (double[])rSLinSystemWeighted2.e(), (double[])rSLinSystemObjSolver.k, (int)n2, (int)n, (int)n2);
        RmaMath.matMultAS((double[])rSLinSystemObjSolver.k, (double)rSLinSystemObjSolver.a, (int)n, (int)n2);
        RmaMath.matMultAB((double[])rSLinSystemObjSolver.k, (double[])rSLinSystemObjSolver.j, (double[])rSLinSystemObjSolver.l, (int)n, (int)n2, (int)n);
        RmaMath.matMultAB((double[])rSLinSystemObjSolver.k, (double[])dArray, (double[])rSLinSystemObjSolver.m, (int)n, (int)n2, (int)1);
        int n10 = n;
        RmaMath.matMultAtB((double[])rSLinSystemObjSolver.e, (double[])rSLinSystemObjSolver.e, (double[])rSLinSystemObjSolver.n, (int)n10, (int)n10, (int)n);
        int n11 = n;
        RmaMath.matMultAS((double[])rSLinSystemObjSolver.n, (double)rSLinSystemObjSolver.d, (int)n11, (int)n11);
        RmaMath.matAddTo((double[])rSLinSystemObjSolver.h, (double[])rSLinSystemObjSolver.n);
        RmaMath.matAddTo((double[])rSLinSystemObjSolver.l, (double[])rSLinSystemObjSolver.n);
        RmaMath.invertMatrix((double[])rSLinSystemObjSolver.n);
        rSLinSystemObjSolver.o = Arrays.copyOf(rSLinSystemObjSolver.i, n);
        RmaMath.matAddTo((double[])rSLinSystemObjSolver.m, (double[])rSLinSystemObjSolver.o);
        int n12 = n;
        RmaMath.matMultAB((double[])rSLinSystemObjSolver.n, (double[])rSLinSystemObjSolver.o, (double[])rSLinSystemObjSolver.p, (int)n12, (int)n12, (int)1);
        int n13 = n;
        RmaMath.matMultAB((double[])rSLinSystemObjSolver.e, (double[])rSLinSystemObjSolver.p, (double[])rSLinSystemObjSolver.s, (int)n13, (int)n13, (int)1);
        dArray = this.c;
        dArray2 = this.b;
        rSLinSystemWeighted2 = rSLinSystemWeighted;
        rSMsrLinSystem2 = rSMsrLinSystem;
        rSLinSystemObjSolver = this;
        n5 = rSMsrLinSystem2.a();
        n2 = rSLinSystemWeighted2.a();
        n = rSMsrLinSystem2.b();
        int n14 = n5;
        RmaMath.matMultAB((double[])rSMsrLinSystem2.e(), (double[])rSMsrLinSystem2.c(), (double[])rSLinSystemObjSolver.f, (int)n14, (int)n14, (int)n);
        RmaMath.matMultAtB((double[])dArray2, (double[])rSLinSystemObjSolver.f, (double[])rSLinSystemObjSolver.i, (int)n5, (int)1, (int)n);
        int n15 = n;
        RmaMath.matMultAtB((double[])rSMsrLinSystem2.c(), (double[])rSLinSystemObjSolver.f, (double[])rSLinSystemObjSolver.h, (int)n5, (int)n15, (int)n15);
        int n16 = n2;
        RmaMath.matMultAB((double[])rSLinSystemWeighted2.e(), (double[])rSLinSystemWeighted2.c(), (double[])rSLinSystemObjSolver.j, (int)n16, (int)n16, (int)n);
        RmaMath.matMultAS((double[])rSLinSystemObjSolver.j, (double)rSLinSystemObjSolver.a, (int)n2, (int)n);
        RmaMath.matMultAtB((double[])dArray, (double[])rSLinSystemObjSolver.j, (double[])rSLinSystemObjSolver.m, (int)n2, (int)1, (int)n);
        int n17 = n;
        RmaMath.matMultAtB((double[])rSLinSystemWeighted2.c(), (double[])rSLinSystemObjSolver.j, (double[])rSLinSystemObjSolver.l, (int)n2, (int)n17, (int)n17);
        rSLinSystemObjSolver.o = Arrays.copyOf(rSLinSystemObjSolver.i, n);
        RmaMath.matAddTo((double[])rSLinSystemObjSolver.m, (double[])rSLinSystemObjSolver.o);
        RmaMath.matMultAB((double[])rSLinSystemObjSolver.o, (double[])rSLinSystemObjSolver.s, (double[])rSLinSystemObjSolver.q, (int)1, (int)n, (int)1);
        int n18 = n;
        rSLinSystemObjSolver.n = Arrays.copyOf(rSLinSystemObjSolver.h, n18 * n18);
        RmaMath.matAddTo((double[])rSLinSystemObjSolver.l, (double[])rSLinSystemObjSolver.n);
        int n19 = n;
        RmaMath.matMultAB((double[])rSLinSystemObjSolver.n, (double[])rSLinSystemObjSolver.s, (double[])rSLinSystemObjSolver.o, (int)n19, (int)n19, (int)1);
        RmaMath.matMultAtB((double[])rSLinSystemObjSolver.s, (double[])rSLinSystemObjSolver.o, (double[])rSLinSystemObjSolver.r, (int)n, (int)1, (int)1);
        double d = 1.0;
        if (Math.abs(rSLinSystemObjSolver.r[0]) > 1.0E-8) {
            d = rSLinSystemObjSolver.q[0] / rSLinSystemObjSolver.r[0];
        }
        rSLinSystemObjSolver.t = Arrays.copyOf(rSLinSystemObjSolver.s, n);
        RmaMath.matMultAS((double[])rSLinSystemObjSolver.t, (double)d, (int)n, (int)1);
        return true;
    }

    public double[] a(double[] dArray) {
        return LinSystemNewtonSolver.a(this.t, dArray);
    }

    public double[] a(RSMsrLinSystem rSMsrLinSystem, RSLinSystemWeighted rSLinSystemWeighted, double[] dArray) {
        this.a(rSMsrLinSystem, dArray);
        this.a(rSLinSystemWeighted, dArray);
        this.a(rSMsrLinSystem, rSLinSystemWeighted);
        return this.a(dArray);
    }

    public void b(RSMsrLinSystem rSMsrLinSystem, RSLinSystemWeighted rSLinSystemWeighted) {
        this.u = rSMsrLinSystem.d(this.b());
        this.v = rSLinSystemWeighted.d(this.c());
        this.w = this.u + this.a * this.v;
    }
}

