/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.client;

import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientWorkspace;
import hec.clientapp.model.Manager;
import hec.clientapp.model.ManagerProxy;
import hec.clientapp.model.ManagerProxyListContainer;
import hec.clientapp.model.ManagerProxyListManager;
import hec.clientapp.model.ModelAlt;
import hec.clientapp.model.SimulationPeriod;
import hec.gui.AbstractEditorPanel;
import hec.io.Identifier;
import hec.lang.ModelReference;
import hec.lang.NamedType;
import hec.rss.client.AbstractAlternativeEditor;
import hec.rss.client.AlternativePanel;
import hec.rss.model.RssAlt;
import hec.rss.model.RssSystem;
import hec.rss.plugins.ProgramOrderPlugin;
import hec.rss.plugins.ResSimPluginModelPanel;
import hec.supplemental.model.ProgramOrderItem;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Vector;
import javax.swing.SwingUtilities;
import rma.util.RMAIO;

public abstract class AltPluginPanel
extends AbstractEditorPanel
implements AlternativePanel,
ResSimPluginModelPanel {
    protected ModelAlt _modelAlt;
    protected RssAlt _rssAlt;
    private RssSystem _system;

    public AltPluginPanel(LayoutManager layoutManager) {
        super(layoutManager);
    }

    protected abstract String getAltFileExt();

    protected abstract String getAltClassname();

    protected abstract String getAltRmiWorkspaceName();

    protected abstract void setPluginAlt(Manager var1);

    protected abstract Manager getPluginAlt();

    protected abstract ProgramOrderPlugin getPlugin();

    protected boolean getOrCreatePluginAlternative(RssAlt rssAlt, boolean bl) {
        Object object = SwingUtilities.windowForComponent((Component)((Object)this));
        String string = this.getAltName(rssAlt);
        Manager manager = null;
        if (object instanceof AbstractAlternativeEditor) {
            ClientWorkspace clientWorkspace;
            ManagerProxyListContainer managerProxyListContainer = ((AbstractAlternativeEditor)(object = (AbstractAlternativeEditor)object)).getWorkspace();
            if (managerProxyListContainer instanceof ClientWorkspace) {
                clientWorkspace = (ClientWorkspace)managerProxyListContainer;
                object = clientWorkspace.getManagerIdentifier(this.getAltRmiWorkspaceName(), this.getAltClassname(), string, this.getAltFileExt());
                manager = clientWorkspace.openManager(this.getAltRmiWorkspaceName(), (Identifier)object);
                this.setPluginAlt(manager);
            } else if (managerProxyListContainer instanceof SimulationPeriod) {
                clientWorkspace = (SimulationPeriod)managerProxyListContainer;
                object = clientWorkspace.getManagerProxyList(this.getAltRmiWorkspaceName(), this.getAltClassname());
                for (int i = 0; i < ((Vector)object).size(); ++i) {
                    clientWorkspace = (ManagerProxy)((Vector)object).get(i);
                    if (!clientWorkspace.getName().contains(string)) continue;
                    manager = clientWorkspace.loadManager(null, null);
                    this.setPluginAlt(manager);
                    break;
                }
            }
            if (manager != null) {
                if (managerProxyListContainer instanceof ClientWorkspace) {
                    object = (ClientWorkspace)managerProxyListContainer;
                    clientWorkspace = object.getManagerIdentifier("rss", ModelAlt.class.getName(), manager.getName(), ".malt");
                    clientWorkspace.setDescription(manager.getDescription() + " (Simulation)");
                    clientWorkspace = (ModelAlt)object.openManager("rss", (Identifier)clientWorkspace);
                    this._modelAlt = clientWorkspace;
                } else if (managerProxyListContainer instanceof ManagerProxyListManager) {
                    object = (ManagerProxyListManager)managerProxyListContainer;
                    clientWorkspace = object.getManagerIdentifier("rss", ModelAlt.class.getName(), manager.getName(), ".malt");
                    clientWorkspace.setDescription(manager.getDescription() + " (Simulation)");
                    clientWorkspace = (ModelAlt)object.openManager("rss", (Identifier)clientWorkspace);
                    this._modelAlt = clientWorkspace;
                }
                return true;
            }
        }
        if (bl) {
            return this.createPluginAlternative(rssAlt);
        }
        return false;
    }

    protected String getAltName(RssAlt object) {
        object = this.getAltRmiWorkspaceName() + object.getName();
        if (((String)object).length() > 10) {
            object = ((String)object).substring(0, 10);
        }
        return object;
    }

    @Override
    public boolean createPluginAlternative(RssAlt rssAlt) {
        System.out.println("createPluginAlternative:creating " + this.getAltRmiWorkspaceName() + " PluginAlt for " + String.valueOf(rssAlt));
        ClientWorkspace clientWorkspace = ClientApp.Workspace();
        String string = this.getAltName(rssAlt);
        Identifier identifier = clientWorkspace.getManagerIdentifier(this.getAltRmiWorkspaceName(), this.getAltClassname(), string, this.getAltFileExt());
        identifier.setDescription("");
        string = clientWorkspace.newManager(this.getAltRmiWorkspaceName(), this.getAltClassname());
        this.setPluginAlt((Manager)string);
        if (string == null) {
            RMAIO.postError((Component)((Object)this), (String)"An Error Occurred when creating a new W2 Alternative!\nSave aborted");
            return false;
        }
        string.setName(identifier.getName());
        string.setDescription(rssAlt.getDescription());
        boolean bl = clientWorkspace.saveManagerAs(this.getAltRmiWorkspaceName(), (Manager)string, identifier);
        if (!bl) {
            AltPluginPanel altPluginPanel = this;
            RMAIO.postError((Component)((Object)altPluginPanel), (String)("An Error Occurred when saving the new " + altPluginPanel.getAltRmiWorkspaceName() + " Alternative!\nSave aborted"));
            clientWorkspace.deleteManager(this.getAltRmiWorkspaceName(), identifier);
            return false;
        }
        ModelReference modelReference = new ModelReference(string.getIndex(), this.getAltClassname(), this.getAltRmiWorkspaceName());
        Identifier identifier2 = clientWorkspace.getManagerIdentifier("rss", ModelAlt.class.getName(), string.getName(), ".malt");
        identifier2.setDescription(string.getDescription() + " (Simulation)");
        ModelAlt modelAlt = (ModelAlt)ClientApp.Workspace().newManager("rss", ModelAlt.class.getName());
        if (modelAlt == null) {
            AltPluginPanel altPluginPanel = this;
            RMAIO.postError((Component)((Object)altPluginPanel), (String)("An Error Occurred when creating a new " + altPluginPanel.getAltRmiWorkspaceName() + " Model Simulation Alternative!\nSave aborted"));
            clientWorkspace.deleteManager(this.getAltRmiWorkspaceName(), identifier);
            return false;
        }
        modelAlt.setModelRef(modelReference);
        modelAlt.setAltId(string.getName());
        modelReference = this.getPlugin().getProgramOrderItem();
        modelAlt.setProgramIndex((ProgramOrderItem)modelReference);
        boolean bl2 = clientWorkspace.saveManagerAs("rss", (Manager)modelAlt, identifier2);
        if (!bl2) {
            AltPluginPanel altPluginPanel = this;
            RMAIO.postError((Component)((Object)altPluginPanel), (String)("An Error occurred when trying to save the " + altPluginPanel.getAltRmiWorkspaceName() + " Model Simulation Alternative"));
            clientWorkspace.deleteManager(this.getAltRmiWorkspaceName(), identifier);
            clientWorkspace.deleteManager("rss", identifier2);
            return false;
        }
        this._modelAlt = modelAlt;
        return true;
    }

    @Override
    public void deleteAltManager(RssAlt rssAlt) {
        this.getOrCreatePluginAlternative(rssAlt, false);
        if (this.getPluginAlt() == null) {
            return;
        }
        rssAlt = this.getPluginAlt().getIdentifier();
        ClientApp.Workspace().deleteManager(this.getAltRmiWorkspaceName(), (Identifier)rssAlt);
    }

    public boolean savePanel(NamedType namedType) {
        if (namedType instanceof RssAlt) {
            return this.savePanel((RssAlt)namedType);
        }
        return true;
    }

    @Override
    public void setSystem(RssSystem rssSystem) {
        this._system = rssSystem;
    }
}

