/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.waterquality.model;

import com.google.common.flogger.FluentLogger;
import hec.clientapp.rmi.csinterface.RmiWorkspace;
import hec.io.FilePath;
import hec.io.HecFile;
import hec.map.MapIdentifier;
import hec.map.WorldLine;
import hec.map.WorldPt;
import hec.map.aishape.AiShapeArc;
import hec.map.aishape.AiShapeFieldDescriptor;
import hec.map.aishape.AiShapeMap;
import hec.map.aishape.AiShapeObject;
import hec.map.aishape.Attribute;
import hec.rss.model.Element;
import hec.rss.model.ReachElement;
import hec.rss.model.RssNode;
import hec.rss.model.RssSystem;
import hec.rss.plugins.waterquality.model.Connection;
import hec.rss.plugins.waterquality.model.ConnectionSet;
import hec.rss.plugins.waterquality.model.RssWQGeometry;
import hec.rss.plugins.waterquality.model.StationedCell;
import hec.rss.wq.model.WqGeometry;
import hec.wqenginecore.WQException;
import hec.wqenginecore.geometry.SubDomain;
import hec.wqengineimpl.geometry.WQGeoSubDomain;
import hec.wqengineimpl.geometry.WQSubDomainRef;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.Stream;
import mil.army.usace.hec.metadata.UnitUtil;
import mil.army.usace.hec.metadata.UnitsConversionException;
import mil.army.usace.hec.rmi.io.HecFileImpl;
import org.apache.commons.lang3.ArrayUtils;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class ConnectionMap {
    private static final FluentLogger a = FluentLogger.forEnclosingClass();
    public static final String LENGTH_CHA = "Length Cha";
    public static final double DELTA = 1.0E-7;
    private final String b;
    private final String c;
    private final String d;
    private Map<String, NavigableSet<Connection>> e;
    private Map<Connection, Double> f;
    private Map<Connection, AiShapeArc> g;

    public ConnectionMap(String string, String string2, String string3) {
        this.b = string;
        this.c = string2;
        this.d = string3;
    }

    public static double[] findXFace(double[] dArray) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        arrayList.add(1.0);
        DoubleStream.of(dArray).filter(d -> d > 0.0 && d < 1.0).forEach(arrayList::add);
        if (arrayList.size() == 1) {
            arrayList.add(0.5);
        }
        arrayList.add(0.0);
        return arrayList.stream().mapToDouble(d -> d).toArray();
    }

    public void initialize(AiShapeMap object) {
        Integer object22 = ConnectionMap.a((AiShapeMap)object, this.b);
        Object object2 = ConnectionMap.a((AiShapeMap)object, this.c);
        Integer n = ConnectionMap.a((AiShapeMap)object, this.d);
        Integer n2 = ConnectionMap.a((AiShapeMap)object, LENGTH_CHA);
        this.f = new LinkedHashMap<Connection, Double>();
        this.g = new LinkedHashMap<Connection, AiShapeArc>();
        if (object22 != null && object2 != null && n != null && n2 != null) {
            this.initializeShapeMaps((AiShapeMap)object, object22, (Integer)object2, n, n2);
        } else {
            ((FluentLogger.Api)a.atWarning()).log("Could not find one of the specified columns in the AiShapeMap.  riverColumnName:%s:%d, reachColumnName:%s:%d, stationColumnName:%s:%d, lengthCha:%s:%d", (Object)this.b, (Object)object22, (Object)this.c, object2, (Object)this.d, (Object)n, (Object)LENGTH_CHA, (Object)n2);
        }
        this.e = new LinkedHashMap<String, NavigableSet<Connection>>();
        for (Connection connection : this.f.keySet()) {
            object2 = this.e.computeIfAbsent(connection.getRiver(), string -> new TreeSet<Connection>(this.getComparator()));
            object2.add(connection);
        }
    }

    public void initializeShapeMaps(AiShapeMap object, Integer n, Integer n2, Integer n3, Integer n4) {
        object = object.getShapes();
        object = object.iterator();
        while (object.hasNext()) {
            AiShapeObject aiShapeObject = (AiShapeObject)object.next();
            if (aiShapeObject == null) continue;
            this.addShapeToMaps(n, n2, n3, n4, aiShapeObject);
        }
    }

    public void addShapeToMaps(Integer object, Integer object2, Integer object3, Integer object4, AiShapeObject aiShapeObject) {
        Attribute attribute = aiShapeObject.getAttribute();
        if (attribute != null) {
            double d;
            object = this.getFieldValueOrNull(attribute, (Integer)object);
            object2 = this.getFieldValueOrNull(attribute, (Integer)object2);
            object3 = this.getFieldValueOrNull(attribute, (Integer)object3);
            if ((object4 = this.getFieldValueOrNull(attribute, (Integer)object4)) != null && (d = RMAIO.parseDouble((String)object4, (double)-1.0)) != -1.0) {
                object = new Connection((String)object, (String)object2, (String)object3);
                this.f.put((Connection)object, d);
                if (aiShapeObject instanceof AiShapeArc) {
                    this.g.put((Connection)object, (AiShapeArc)aiShapeObject);
                }
            }
        }
    }

    public Comparator<Connection> getComparator() {
        return Comparator.comparingDouble(this::getStationing).reversed();
    }

    public String getFieldValueOrNull(Attribute object, Integer n) {
        String string = null;
        if (object != null && n != null && (object = object.getField(n.intValue())) != null && (object = object.getValue()) != null) {
            string = String.valueOf(object);
        }
        return string;
    }

    private static Integer a(AiShapeMap object, String string) {
        Integer n = null;
        object = object.getFieldDescriptors();
        for (int i = 0; i < object.size(); ++i) {
            AiShapeFieldDescriptor aiShapeFieldDescriptor = (AiShapeFieldDescriptor)object.get(i);
            if (!aiShapeFieldDescriptor.toString().equals(string)) continue;
            n = i;
            break;
        }
        return n;
    }

    public static AiShapeMap getAiShapeMap(File object) {
        AiShapeMap aiShapeMap = null;
        if (((File)object).exists()) {
            aiShapeMap = new AiShapeMap();
            object = ((File)object).getAbsolutePath();
            aiShapeMap.setMapIdentifier(new MapIdentifier((String)object, (HecFile)new HecFileImpl(new FilePath((String)object))));
            try {
                aiShapeMap.load();
            }
            catch (IOException iOException) {
                aiShapeMap = null;
            }
        }
        return aiShapeMap;
    }

    public List<Double> getCellSizes(Connection object, Connection connection) {
        object = this.getConnectionsBetweenInclusive(connection, (Connection)object);
        return this.getLengthsBetween((Collection<Connection>)object);
    }

    public List<Double> getLengthsBetween(Collection<Connection> collection) {
        List<Double> list = Collections.emptyList();
        if (collection != null && !collection.isEmpty()) {
            list = new ArrayList<Double>(collection.size());
            for (Connection connection : collection) {
                list.add(this.f.get(connection));
            }
            if (!collection.isEmpty()) {
                List<Double> list2 = list;
                list2.remove(list2.size() - 1);
            }
        }
        return list;
    }

    public NavigableSet<Connection> getConnectionsBetweenInclusive(Connection connection, Connection connection2) {
        Object object;
        NavigableSet<Connection> navigableSet = Collections.emptyNavigableSet();
        if (connection2 != null && connection != null && (object = connection2.getRiver()) != null && ((String)object).equals(connection.getRiver())) {
            object = this.e.get(object);
            Comparator<Connection> comparator = this.getComparator();
            int n = comparator.compare(connection, connection2);
            if (n < 0) {
                navigableSet = object.subSet(connection, true, connection2, true);
            } else if (n == 0) {
                navigableSet = new TreeSet<Connection>(comparator);
                navigableSet.add(connection);
                navigableSet.add(connection2);
            }
        }
        return navigableSet;
    }

    public double getStationing(Connection object) {
        object = ((Connection)object).getStation();
        object = ((String)object).replace("*", "");
        return RMAIO.parseDouble((String)object, (double)-1.0);
    }

    public static List<Double> rescale(List<Double> list, double d) {
        double d3;
        if (list != null && (d3 = ConnectionMap.sum(list)) != 0.0 && d != 0.0) {
            Double d4 = d / d3;
            return list.stream().map(d2 -> d2 * d4).collect(Collectors.toList());
        }
        return list;
    }

    public static double sum(List<Double> list) {
        DoubleAdder doubleAdder = new DoubleAdder();
        list.stream().forEach(doubleAdder::add);
        return doubleAdder.doubleValue();
    }

    public static void updateCellDetails(WQGeoSubDomain wQGeoSubDomain, double d, WorldLine worldLine, double[] dArray) {
        int n = wQGeoSubDomain.getNumCells();
        int n2 = wQGeoSubDomain.getNumFacesInternal();
        int n3 = wQGeoSubDomain.getNumFaces();
        int n4 = wQGeoSubDomain.getNumFacesFlow();
        wQGeoSubDomain.updateAndRecalculate(dArray, d);
        int n5 = wQGeoSubDomain.getNumCells();
        int n6 = wQGeoSubDomain.getNumFacesInternal();
        int n7 = wQGeoSubDomain.getNumFaces();
        int n8 = wQGeoSubDomain.getNumFacesFlow();
        ((FluentLogger.Api)a.atFine()).log("sd:%s was:%d, %d, %d, %d now:%d, %d, %d, %d", (Object)wQGeoSubDomain.getName(), (Object)n, (Object)n2, (Object)n3, (Object)n4, (Object)n5, (Object)n6, (Object)n7, (Object)n8);
        Object object = WQGeoSubDomain.centerRatioFromXFace((double[])dArray);
        object = ConnectionMap.getCoordinatesFromRatios(worldLine, object);
        wQGeoSubDomain.setCellCenterCoordinates((double[][])object);
    }

    public static double[][] getCoordinatesFromRatios(WorldLine worldLine, double[] dArray) {
        double[][] dArray2 = new double[dArray.length][3];
        for (int i = 0; i < dArray.length; ++i) {
            double d = dArray[i];
            WorldPt worldPt = worldLine.getLocationByCoord(d);
            dArray2[i][0] = worldPt.e;
            dArray2[i][1] = worldPt.n;
            dArray2[i][2] = 0.0;
        }
        return dArray2;
    }

    public void updateXRAS(WqGeometry manager) {
        RssWQGeometry rssWQGeometry = manager.getRssWqGeometry();
        ConnectionSet connectionSet = rssWQGeometry.getConnectionSet();
        manager = manager.getNetwork();
        for (SubDomain subDomain : rssWQGeometry.getReaches()) {
            Object object;
            if (!(subDomain instanceof WQGeoSubDomain) || !((object = manager.getElement((subDomain = (WQGeoSubDomain)subDomain).getElementId())) instanceof ReachElement)) continue;
            object = (ReachElement)object;
            WQSubDomainRef wQSubDomainRef = subDomain.getRef();
            String[] stringArray = connectionSet.getUpstream(wQSubDomainRef);
            String[] stringArray2 = connectionSet.getDownstream(wQSubDomainRef);
            Map<Double, Connection> map = this.findIntersectionsBetween((Connection)stringArray, (Connection)stringArray2, (ReachElement)object);
            double[] dArray = this.getScaledLengths((ReachElement)object, map.keySet());
            object = dArray;
            if (dArray.length == 0) {
                ((FluentLogger.Api)a.atInfo()).log("Could not find cross-sections for:%s up:%s down:%s", (Object)wQSubDomainRef, (Object)stringArray, (Object)stringArray2);
            }
            stringArray2 = map.values();
            String[] stringArray3 = null;
            if (stringArray2 != null && !stringArray2.isEmpty()) {
                stringArray3 = (String[])stringArray2.stream().map(connection -> connection.getRiver()).toArray(String[]::new);
            }
            wQSubDomainRef = stringArray3;
            stringArray2 = map.values();
            stringArray3 = null;
            if (stringArray2 != null && !stringArray2.isEmpty()) {
                stringArray3 = (String[])stringArray2.stream().map(connection -> connection.getReach()).toArray(String[]::new);
            }
            stringArray = stringArray3;
            stringArray2 = map.values();
            stringArray3 = null;
            if (stringArray2 != null && !stringArray2.isEmpty()) {
                stringArray3 = (String[])stringArray2.stream().map(connection -> connection.getStation()).toArray(String[]::new);
            }
            stringArray2 = stringArray3;
            subDomain.setXRAS((double[])object, (String[])wQSubDomainRef, stringArray, stringArray2);
        }
    }

    public Map<Double, Connection> findIntersectionsBetween(Connection connection, Connection connection2, ReachElement reachElement) {
        LinkedHashMap<Double, Connection> linkedHashMap = new LinkedHashMap<Double, Connection>();
        NavigableSet<Connection> navigableSet = this.getConnectionsBetweenInclusive(connection, connection2);
        if (navigableSet != null) {
            for (Connection connection3 : navigableSet) {
                Double d = this.getStationOfIntersection(connection3, reachElement);
                if (d == null) continue;
                Connection connection4 = (Connection)linkedHashMap.get(d);
                if (connection4 != null) {
                    ((FluentLogger.Api)a.atFine()).log("In the list of %d cross sections found between:%s and:%s the cross-section:%s intersects the reach at the same location as:%s.  Cross-section:%s will be skipped.", (Object)navigableSet.size(), (Object)connection, (Object)connection2, (Object)connection3, (Object)connection4, (Object)connection3);
                    continue;
                }
                linkedHashMap.put(d, connection3);
            }
        }
        return linkedHashMap;
    }

    public double[] getScaledLengths(ReachElement reachElement, Set<Double> collection) {
        double[] cfr_ignored_0 = new double[0];
        double[] dArray = null;
        collection = new ArrayList<Double>(collection);
        double d = ((Element)reachElement).getDownstreamNode().getStreamStation();
        double d3 = Math.abs(((Element)reachElement).getUpstreamNode().getStreamStation() - d);
        dArray = collection.stream().mapToDouble(d2 -> d2 - d).map(d2 -> d2 / d3).toArray();
        return dArray;
    }

    public static List<Double> lengthsToBoundaryRatios(List<Double> list) {
        list = ConnectionMap.rescale(list, 1.0);
        ArrayList<Double> arrayList = new ArrayList<Double>();
        if (list != null) {
            DoubleAdder doubleAdder = new DoubleAdder();
            if ((list = (List)((Stream)list.stream().sequential()).map(d -> {
                doubleAdder.add((double)d);
                return 1.0 - doubleAdder.doubleValue();
            }).collect(Collectors.toCollection(ArrayList::new))) != null && !list.isEmpty()) {
                arrayList.add(1.0);
                arrayList.addAll(list);
            }
        }
        if (!arrayList.isEmpty()) {
            ArrayList<Double> arrayList2 = arrayList;
            if ((Double)arrayList2.get(arrayList2.size() - 1) != 0.0) {
                ArrayList<Double> arrayList3 = arrayList;
                arrayList3.set(arrayList3.size() - 1, 0.0);
            }
        }
        return arrayList;
    }

    public static List<Double> subtract(List<Double> list, List<Double> list2) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (int i = 0; i < list.size(); ++i) {
            Double d = list.get(i);
            Double d2 = 0.0;
            if (list2 != null && list2.size() > i) {
                d2 = list2.get(i);
            }
            arrayList.add(d - d2);
        }
        return arrayList;
    }

    public static WorldLine getWorldLine(ReachElement tSLocation) {
        Object object = tSLocation.getLine();
        if (object == null || ((WorldLine)object).pts.isEmpty()) {
            object = tSLocation.getUpstreamNode();
            tSLocation = tSLocation.getDownstreamNode();
            double d = ((RssNode)object).getStreamCoord();
            double d2 = tSLocation.getStreamCoord();
            tSLocation = ((RssNode)object).getStream();
            object = tSLocation.getLineSegment(d2, d);
        }
        return object;
    }

    public static double getLength(ReachElement tSLocation) {
        RssNode rssNode = ((Element)tSLocation).getUpstreamNode();
        tSLocation = ((Element)tSLocation).getDownstreamNode();
        return Math.abs(rssNode.getStreamStation() - tSLocation.getStreamStation());
    }

    public static List<Double> adjustLengths(List<Double> list, Double d, Double d2) {
        if (d != null && RMAConst.isValidValue((double)d) && d2 != null && RMAConst.isValidValue((double)d2)) {
            list = ConnectionMap.adjustCells(list, d, d2);
        } else if (d2 != null && RMAConst.isValidValue((double)d2)) {
            list = ConnectionMap.divideLargeCells(list, d2);
        } else if (d != null && RMAConst.isValidValue((double)d)) {
            list = ConnectionMap.carryToNext(list, d);
        }
        return ConnectionMap.atLeastTwoCells(list);
    }

    public static List<Double> divideLargeCells(List<Double> list, Double d) {
        ArrayList<Double> arrayList = null;
        if (list != null) {
            arrayList = new ArrayList<Double>(list.size());
            for (int i = 0; i < list.size(); ++i) {
                Double d2;
                Double d3 = list.get(i);
                if (d2 > d + 1.0E-7) {
                    double d4 = Math.ceil(d3 / d);
                    double d5 = d3 / d4;
                    int n = 0;
                    while ((double)n < d4) {
                        arrayList.add(d5);
                        ++n;
                    }
                    continue;
                }
                arrayList.add(d3);
            }
        }
        return arrayList;
    }

    public static List<Double> adjustCells(List<Double> list, Double d, Double d2) {
        ArrayList<Double> arrayList = null;
        if (list != null) {
            int n;
            arrayList = new ArrayList<Double>(list.size());
            double d3 = 0.0;
            for (n = 0; n < list.size(); ++n) {
                Double d4 = list.get(n) + d3;
                d3 = 0.0;
                while (d4 > d2 + 1.0E-7) {
                    arrayList.add(d2);
                    d4 = d4 - d2;
                }
                if (d4 < d - 1.0E-7) {
                    d3 = d4;
                    continue;
                }
                arrayList.add(d4);
            }
            if (d3 != 0.0) {
                if (arrayList.isEmpty()) {
                    arrayList.add(d3);
                } else {
                    n = arrayList.size() - 1;
                    arrayList.set(n, (Double)arrayList.get(n) + d3);
                }
            }
        }
        return arrayList;
    }

    public static List<Double> atLeastTwoCells(List<Double> list) {
        block0: {
            if (list == null || list.size() != 1) break block0;
            Double d = list.isEmpty() ? Double.valueOf(0.0) : list.get(0);
            list = new ArrayList<Double>(2);
            list.add(d * 0.5);
            list.add(d * 0.5);
        }
        return list;
    }

    public static List<Double> carryToNext(List<Double> list, Double d) {
        ArrayList<Double> arrayList = null;
        if (list != null) {
            int n;
            double d2 = 0.0;
            arrayList = new ArrayList<Double>(list.size());
            for (n = 0; n < list.size(); ++n) {
                Double d3;
                Double d4 = list.get(n) + d2;
                if (d3 < d - 1.0E-7) {
                    d2 = d4;
                    continue;
                }
                arrayList.add(d4);
                d2 = 0.0;
            }
            if (d2 != 0.0) {
                if (arrayList.isEmpty()) {
                    arrayList.add(d2);
                } else {
                    n = arrayList.size() - 1;
                    arrayList.set(n, (Double)arrayList.get(n) + d2);
                }
            }
        }
        return arrayList;
    }

    public Double getStationOfIntersection(Connection connection, ReachElement tSLocation) {
        Double d = null;
        connection = this.g.get(connection);
        tSLocation = ((Element)tSLocation).getUpstreamNode();
        WorldLine worldLine = (tSLocation = ((RssNode)tSLocation).getStream()).getLine();
        connection = this.getIntersectionOrNull(worldLine, (AiShapeArc)connection);
        if (connection != null) {
            d = tSLocation.getStationByLocation((WorldPt)connection);
        }
        return d;
    }

    public WorldPt getIntersectionOrNull(WorldLine worldLine, AiShapeArc object) {
        WorldPt worldPt = null;
        if (object != null && (object = object.getArcLines()) != null) {
            WorldPt worldPt2 = new WorldPt();
            object = object.iterator();
            while (object.hasNext()) {
                WorldLine worldLine2 = (WorldLine)object.next();
                if (!worldLine2.intersects(worldLine, worldPt2)) continue;
                worldPt = worldPt2;
                break;
            }
        }
        return worldPt;
    }

    public List<StationedCell> getRasStationedCells(ConnectionSet object, WQGeoSubDomain object2, ReachElement reachElement, RssSystem rssSystem) throws WQException {
        ArrayList<StationedCell> arrayList = new ArrayList<StationedCell>();
        Object object3 = object2.getRef();
        Connection connection = ((ConnectionSet)object).getUpstream((WQSubDomainRef)object3);
        object = ((ConnectionSet)object).getDownstream((WQSubDomainRef)object3);
        object3 = new LinkedHashMap();
        object = this.findIntersectionsBetween(connection, (Connection)object, reachElement);
        if ((object = object.values()) != null) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Connection connection2 = (Connection)iterator.next();
                double d = this.getStationing(connection2);
                if (d == -1.0) continue;
                object3.put(connection2, d);
            }
        }
        double d = ConnectionMap.getReachElemLength(reachElement, rssSystem);
        Object[] objectArray = ArrayUtils.toObject((double[])object2.getXFace());
        if (objectArray == null || objectArray.length < 2) {
            ((FluentLogger.Api)a.atInfo()).log("For reach %s, at least two cells are needed: xFace: %s", (Object)reachElement.getName(), (Object)Arrays.toString(objectArray));
        } else {
            Object[] objectArray2 = ArrayUtils.toObject((double[])object2.getXRAS());
            object = object3.entrySet();
            if (objectArray2 == null || objectArray2.length == 0) {
                ((FluentLogger.Api)a.atFine()).log("For reach %s, at least two RAS cross sections are needed to determine RAS stationing. Found:%s", (Object)reachElement.getName(), (Object)Arrays.toString(objectArray2));
                for (int i = 0; i < objectArray.length - 1; ++i) {
                    double d2 = (Double)objectArray[i] - (Double)objectArray[i + 1];
                    StationedCell stationedCell = new StationedCell(null, null, true, true, d2 * d);
                    arrayList.add(stationedCell);
                }
            } else if (objectArray2.length == 1) {
                ((FluentLogger.Api)a.atFine()).log("For reach %s, only one RAS cross section was provided.  Found:", (Object)reachElement.getName(), (Object)Arrays.toString(objectArray2));
                for (int i = 0; i < objectArray.length - 1; ++i) {
                    double d3 = (Double)objectArray[i] - (Double)objectArray[i + 1];
                    double d4 = (Double)objectArray2[0] + 1.0E-4 * (double)(i + 1);
                    double d5 = (Double)objectArray2[0] + 1.0E-4 * (double)i;
                    StationedCell stationedCell = new StationedCell(d4, d5, true, true, d3 * d);
                    arrayList.add(stationedCell);
                }
            } else if (object.size() == objectArray2.length) {
                object2 = DoubleStream.of(object2.getXRAS()).boxed().collect(Collectors.toSet());
                Double[] doubleArray = (Double[])object.stream().map(Map.Entry::getValue).toArray(Double[]::new);
                try {
                    Double[] doubleArray2 = ConnectionMap.interpLinear((Double[])objectArray2, doubleArray, (Double[])objectArray);
                    for (int i = 0; i < objectArray.length - 1; ++i) {
                        double d6 = doubleArray2[i];
                        double d7 = doubleArray2[i + 1];
                        double d8 = (Double)objectArray[i] - (Double)objectArray[i + 1];
                        boolean bl = !object2.contains(objectArray[i]);
                        boolean bl2 = !object2.contains(objectArray[i + 1]);
                        object = new StationedCell(d6, d7, bl, bl2, d8 * d);
                        arrayList.add((StationedCell)object);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    ((FluentLogger.Api)((FluentLogger.Api)a.atWarning()).withCause((Throwable)illegalArgumentException)).log("Could not calculate the stationing of the RAS cross-section for reach %s", (Object)reachElement.getName());
                }
            } else {
                ((FluentLogger.Api)a.atWarning()).log("For reach %s the xRAS field contained:%d items but only %d connections were found.  It is unclear how to match these collections.", (Object)reachElement.getName(), (Object)objectArray2.length, (Object)object.size());
            }
        }
        return arrayList;
    }

    public static double getReachElemLength(ReachElement reachElement, RssSystem rssSystem) throws WQException {
        double d = ConnectionMap.getStreamAlignLenConversionFactor(rssSystem);
        double d2 = ((Element)reachElement).getUpstreamNode().getStreamStation();
        double d3 = ((Element)reachElement).getDownstreamNode().getStreamStation();
        return (d2 - d3) * d;
    }

    public static double getStreamAlignLenConversionFactor(RssSystem object) throws WQException {
        String string;
        int n = object.getUnitSystem();
        if (n == 1) {
            string = "feet";
        } else if (n == 2) {
            string = "meter";
        } else {
            ((FluentLogger.Api)a.atWarning()).log("Network unit system is not recognized.  Using feet.");
            string = "feet";
        }
        String string2 = null;
        object = object.getWorkspace();
        if (object != null) {
            object = (RmiWorkspace)object.getRemote();
            try {
                string2 = object.getStreamAlignmentUnits();
            }
            catch (RemoteException remoteException) {
                ((FluentLogger.Api)((FluentLogger.Api)a.atSevere()).withCause((Throwable)remoteException)).log("Could not get stream alignment units from workspace.");
                throw new WQException("Could not get stream alignment units from workspace.");
            }
        }
        if (string2 == null || string2.isEmpty()) {
            throw new WQException("Watershed Stream Alignment Units are not defined. Could not create WQ Geometry. \n Please define Stream Alignment Units using Watershed Properties in the Watershed Module.");
        }
        if (string2.endsWith("s")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        string2 = string2.toLowerCase();
        object = new double[]{1.0};
        try {
            UnitUtil.convertUnits((double[])object, (String)string2, (String)string);
        }
        catch (UnitsConversionException unitsConversionException) {
            ((FluentLogger.Api)((FluentLogger.Api)a.atSevere()).withCause((Throwable)unitsConversionException)).log("Could not convert stream alignment units from:%s to:%s", (Object)string2, (Object)string);
            throw new WQException("Could not convert stream alignment units from:" + string2 + " to:" + string);
        }
        return (double)object[0];
    }

    public static Double[] interpLinear(Double[] doubleArray, Double[] doubleArray2, Double[] doubleArray3) {
        return ConnectionMap.interpLinear(doubleArray, doubleArray2, doubleArray3, Collections.reverseOrder(Double::compare));
    }

    public static final Double[] interpLinear(Double[] object, Double[] doubleArray, Double[] doubleArray2, Comparator<Double> comparator) throws IllegalArgumentException {
        Double[] doubleArray3 = null;
        if (doubleArray2 != null) {
            double[] dArray;
            if (((Double[])object).length != doubleArray.length) {
                throw new IllegalArgumentException("X and Y must be the same length. " + ((Double[])object).length + " !=" + doubleArray.length);
            }
            if (((Double[])object).length <= 1) {
                throw new IllegalArgumentException("X must contain more than one value. Length=" + ((Double[])object).length);
            }
            double[] dArray2 = new double[((Double[])object).length - 1];
            double[] dArray3 = dArray = new double[((Double[])object).length - 1];
            double[] dArray4 = dArray2;
            Comparator<Double> comparator2 = comparator;
            Double[] doubleArray4 = doubleArray;
            doubleArray3 = object;
            double[] dArray5 = new double[((Double[])object).length - 1];
            double[] dArray6 = new double[doubleArray3.length - 1];
            for (int i = 0; i < doubleArray3.length - 1; ++i) {
                int n = comparator2.compare(doubleArray3[i + 1], doubleArray3[i]);
                if (n == 0) {
                    object = String.format("X must be monotonic. A duplicate x-value (%s) was found at index:%d and index:%d", doubleArray3[i], i, i + 1);
                    throw new IllegalArgumentException((String)object);
                }
                if (n < 0) {
                    object = String.format("X must be sorted. Item %d and %d were:%s and:%s", i, i + 1, doubleArray3[i], doubleArray3[i + 1]);
                    throw new IllegalArgumentException((String)object);
                }
                dArray5[i] = doubleArray3[i + 1] - doubleArray3[i];
                dArray6[i] = doubleArray4[i + 1] - doubleArray4[i];
                dArray4[i] = dArray6[i] / dArray5[i];
                dArray3[i] = doubleArray4[i] - doubleArray3[i] * dArray4[i];
            }
            doubleArray3 = new Double[doubleArray2.length];
            for (int i = 0; i < doubleArray2.length; ++i) {
                int n = comparator.compare(doubleArray2[i], object[((Double[])object).length - 1]);
                int n2 = comparator.compare(doubleArray2[i], object[0]);
                if (n > 0 || n2 < 0) {
                    n = Arrays.binarySearch(object, doubleArray2[i], comparator);
                    if (n < 0) {
                        n = -1 - n;
                    }
                    if (n >= dArray2.length) {
                        n = dArray2.length - 1;
                    }
                    doubleArray3[i] = dArray2[n] * doubleArray2[i] + dArray[n];
                    continue;
                }
                n = Arrays.binarySearch(object, doubleArray2[i], comparator);
                if (n < -1) {
                    n = -n - 2;
                    doubleArray3[i] = dArray2[n] * doubleArray2[i] + dArray[n];
                    continue;
                }
                doubleArray3[i] = doubleArray[n];
            }
        }
        return doubleArray3;
    }
}

